/*
 * Decompiled with CFR 0.152.
 */
package ice.event.communication.util;

import ice.data.tas.bt7.UBMatrix;
import ice.event.communication.PeakListData;
import ice.event.communication.PeakSetData;
import ice.event.communication.UBMatrixChangeEvent;
import ice.event.communication.util.exception.UBMatrixParseChangeEventException;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UBMatrixChangeEventParser {
    public static UBMatrixChangeEvent ubMatrixChangeEventParser(Object callingClass, String eventStringXml) throws UBMatrixParseChangeEventException {
        UBMatrixChangeEvent ubMatrixChangeEvent = null;
        UBMatrixChangeEvent.EventType eventType = UBMatrixChangeEvent.EventType.UNKNOWN;
        UBMatrix.ReferencePlane refPlane = UBMatrix.ReferencePlane.UNKNOWN;
        Boolean inputChanged = null;
        PeakListData pld = null;
        try {
            String value;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(eventStringXml.getBytes()));
            Node parentNode = doc.getFirstChild();
            NamedNodeMap attributes = parentNode.getAttributes();
            Node typeNode = attributes.getNamedItem("type");
            Node refPlaneNode = attributes.getNamedItem("referencePlane");
            Node inputChangedNode = attributes.getNamedItem("inputChanged");
            if (typeNode != null) {
                value = typeNode.getNodeValue();
                if ("modify".equals(value)) {
                    eventType = UBMatrixChangeEvent.EventType.MODIFY;
                }
                if ("list".equals(value)) {
                    eventType = UBMatrixChangeEvent.EventType.LIST;
                }
            }
            if (refPlaneNode != null) {
                value = refPlaneNode.getNodeValue();
                if ("a".equals(value)) {
                    refPlane = UBMatrix.ReferencePlane.A;
                }
                if ("b".equals(value)) {
                    refPlane = UBMatrix.ReferencePlane.B;
                }
            }
            if (inputChangedNode != null) {
                value = inputChangedNode.getNodeValue();
                if ("True".equals(value)) {
                    inputChanged = true;
                } else if ("False".equals(value)) {
                    inputChanged = false;
                }
            }
            HashMap<String, PeakListData> peaksetLists = new HashMap<String, PeakListData>();
            NodeList children = parentNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (1 == child.getNodeType()) {
                    NamedNodeMap childAttributes;
                    String nodeName = child.getNodeName();
                    if (("peak-list".equals(child.getNodeName()) || "CalculationIncludedPeakSets".equals(child.getNodeName())) && (childAttributes = child.getAttributes()) != null) {
                        Node nameNode = childAttributes.getNamedItem("name");
                        Object listName = null;
                        pld = UBMatrixChangeEventParser.parsePeakListNode(child);
                        peaksetLists.put(nodeName, pld);
                    }
                }
                ++i;
            }
            ubMatrixChangeEvent = new UBMatrixChangeEvent(callingClass, eventType, refPlane, inputChanged, peaksetLists);
        }
        catch (Exception e) {
            UBMatrixParseChangeEventException umpcee = null;
            umpcee = new UBMatrixParseChangeEventException(e);
            throw umpcee;
        }
        return ubMatrixChangeEvent;
    }

    protected static PeakListData parsePeakListNode(Node node) {
        Integer primaryPeakSet = null;
        PeakListData pld = null;
        NamedNodeMap attributes = node.getAttributes();
        Node primaryPeakSetNode = attributes.getNamedItem("primary");
        if (primaryPeakSetNode != null && !primaryPeakSetNode.getNodeValue().equals("")) {
            primaryPeakSet = Integer.valueOf(primaryPeakSetNode.getNodeValue());
        }
        pld = new PeakListData(primaryPeakSet);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (1 == child.getNodeType() && "peak-set".equals(child.getNodeName())) {
                PeakSetData psd = UBMatrixChangeEventParser.parsePeakSetNode(child);
                pld.addPeakSetData(psd);
            }
            ++i;
        }
        return pld;
    }

    protected static PeakSetData parsePeakSetNode(Node node) {
        String value;
        PeakSetData.DataType dataType = PeakSetData.DataType.UNKNOWN;
        Integer id = null;
        Boolean included = null;
        Double h = null;
        Double k = null;
        Double l = null;
        Double a3 = null;
        Double a4 = null;
        Double lTilt = null;
        Double uTilt = null;
        NamedNodeMap attributes = node.getAttributes();
        Node dataTypeNode = attributes.getNamedItem("type");
        Node idNode = attributes.getNamedItem("id");
        Node includedNode = attributes.getNamedItem("included");
        if (dataTypeNode != null) {
            value = dataTypeNode.getNodeValue();
            if ("add".equals(value)) {
                dataType = PeakSetData.DataType.ADD;
            } else if ("remove".equals(value)) {
                dataType = PeakSetData.DataType.REMOVE;
            }
        }
        if (idNode != null) {
            id = Integer.valueOf(idNode.getNodeValue());
        }
        if (includedNode != null) {
            value = includedNode.getNodeValue();
            if ("True".equals(value)) {
                included = true;
            } else if ("False".equals(value)) {
                included = false;
            }
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (1 == child.getNodeType()) {
                if ("H".equals(child.getNodeName())) {
                    h = Double.valueOf(child.getFirstChild().getNodeValue());
                } else if ("K".equals(child.getNodeName())) {
                    k = Double.valueOf(child.getFirstChild().getNodeValue());
                } else if ("L".equals(child.getNodeName())) {
                    l = Double.valueOf(child.getFirstChild().getNodeValue());
                } else if ("A3".equals(child.getNodeName())) {
                    a3 = Double.valueOf(child.getFirstChild().getNodeValue());
                } else if ("A4".equals(child.getNodeName())) {
                    a4 = Double.valueOf(child.getFirstChild().getNodeValue());
                } else if ("LTilt".equals(child.getNodeName())) {
                    lTilt = Double.valueOf(child.getFirstChild().getNodeValue());
                } else if ("UTilt".equals(child.getNodeName())) {
                    uTilt = Double.valueOf(child.getFirstChild().getNodeValue());
                }
            }
            ++i;
        }
        PeakSetData psd = new PeakSetData(dataType, id, included, h, k, l, a3, a4, lTilt, uTilt);
        return psd;
    }
}

