/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import org.apache.log4j.Logger;

public abstract class Device
implements Comparable<Device> {
    private static final Logger logger = Logger.getLogger("DataLogger.DeviceLogger");
    public static String nameFieldName = "name";
    public static String unitsFieldName = "units";
    protected String name;
    protected String units;
    protected ICEListenerList<DeviceValueChangedListener, DeviceValueChangedEvent> valueChangeListeners;

    public Device(String newName, String newUnits) {
        this.name = newName;
        this.units = newUnits;
        this.valueChangeListeners = new ICEListenerList(300);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.notifyValueChangeListeners(nameFieldName, oldName, this.name);
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        String oldUnits = this.units;
        this.units = units;
        this.notifyValueChangeListeners(unitsFieldName, oldUnits, this.units);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Device dev) {
        Device device = dev;
        return this.getName().compareTo(device.getName());
    }

    public void addValueChangeListener(DeviceValueChangedListener dvcl) throws ICEListenerListExceptionBase {
        this.valueChangeListeners.addListener(dvcl);
    }

    public void removeValueChangeListener(DeviceValueChangedListener dvcl) {
        this.valueChangeListeners.removeListener(dvcl);
    }

    protected void notifyValueChangeListeners(String propertyName, Object oldValue, Object newValue) {
        DeviceValueChangedEvent deviceValueChangedEvent = new DeviceValueChangedEvent(this, propertyName, oldValue, newValue);
        this.valueChangeListeners.notifyListeners(deviceValueChangedEvent);
    }
}

