/*
 * Decompiled with CFR 0.152.
 */
package ice.communication;

import ice.communication.DispatcherConnection;
import ice.communication.messageHandlers.serverExceptions.IceServerExceptionQueue;
import ice.data.AvailableElectromagnetDevice;
import ice.data.AvailableMagnetDevice;
import ice.data.AvailableMiscDevice;
import ice.data.AvailablePressureDevice;
import ice.data.AvailableTempDevice;
import ice.data.BaseScan;
import ice.data.InstalledDevice;
import ice.data.QueueCommand;
import ice.data.Server;
import ice.data.tas.bt7.Instrument;
import ice.event.AvailableDeviceEvent;
import ice.event.DeviceEvent;
import ice.event.ExperimentChangeListener;
import ice.event.SendEvent;
import ice.event.SendListener;
import ice.event.communication.AngleCalcEvent;
import ice.event.communication.AngleCalcListener;
import ice.event.communication.AvailableDeviceListListener;
import ice.event.communication.BraggCalcEvent;
import ice.event.communication.BraggCalcListener;
import ice.event.communication.BroadcastMessageEvent;
import ice.event.communication.BroadcastMessageListener;
import ice.event.communication.ClientMessageEvent;
import ice.event.communication.ClientMessageListener;
import ice.event.communication.ConnectionEvent;
import ice.event.communication.ConnectionListener;
import ice.event.communication.DataMessageEvent;
import ice.event.communication.DataMessageListener;
import ice.event.communication.DeviceChangeEvent;
import ice.event.communication.DeviceChangeListener;
import ice.event.communication.DeviceRemoveEvent;
import ice.event.communication.ErrorMessageEvent;
import ice.event.communication.ErrorMessageListener;
import ice.event.communication.ExperimentChangeEvent;
import ice.event.communication.FileChangeEvent;
import ice.event.communication.FileChangeListener;
import ice.event.communication.FitResultEvent;
import ice.event.communication.FitResultListener;
import ice.event.communication.IceFileContentsChangeEvent;
import ice.event.communication.IceFileContentsChangeListener;
import ice.event.communication.InstrumentChangeEvent;
import ice.event.communication.InstrumentChangeListener;
import ice.event.communication.QueueChangeEvent;
import ice.event.communication.QueueChangeListener;
import ice.event.communication.ResponseMessageEvent;
import ice.event.communication.ResponseMessageListener;
import ice.event.communication.SampleChangeEvent;
import ice.event.communication.SampleChangeListener;
import ice.event.communication.ScanListChangeEvent;
import ice.event.communication.ScanListChangeListener;
import ice.event.communication.StatusChangeEvent;
import ice.event.communication.StatusChangeListener;
import ice.event.communication.UBCalcDestinationResponseEvent;
import ice.event.communication.UBCalcDestinationResponseListener;
import ice.event.communication.UBMatrixAskCommandListener;
import ice.event.communication.UBMatrixChangeEvent;
import ice.event.communication.UBMatrixChangeListener;
import ice.event.communication.util.UBMatrixAskCommandListenerUtil;
import ice.event.communication.util.UBMatrixChangeEventParser;
import ice.event.communication.util.UBMatrixParsedAskResponse;
import ice.event.communication.util.exception.UBMatrixParseChangeEventException;
import ice.gui.panel.sans.data.SansScan;
import ice.primitive.DoubleRef;
import ice.primitive.StringRef;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import ice.util.PreferencesManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CommunicationManager
implements Runnable {
    public static final int TIMEOUT = 300;
    public static final String KILL_MESSAGE_TAG = "Kill received:";
    protected static Logger loggerInfoFromServer = Logger.getLogger("InfoFromServerLogger");
    private static Logger logger = Logger.getLogger("NetworkLogger.CommMgrLogger");
    private DispatcherConnection dispatcher;
    private Connector connector;
    private ArrayList<ConnectionListener> connectionListeners = new ArrayList();
    private String username;
    private String display;
    private String address;
    private String displayID;
    private ICEListenerList<ClientMessageListener, ClientMessageEvent> clientListenerList;
    private CopyOnWriteArrayList<StatusChangeListener> statusListenerList;
    private ICEListenerList<QueueChangeListener, QueueChangeEvent> queueChangeListenerList;
    private ICEListenerList<BroadcastMessageListener, BroadcastMessageEvent> messageListenerList;
    private ICEListenerList<SendListener, SendEvent> sendListenerList;
    private ICEListenerList<FileChangeListener, FileChangeEvent> fileChangeListenerList;
    private ICEListenerList<ErrorMessageListener, ErrorMessageEvent> errorListenerList;
    private ICEListenerList<ExperimentChangeListener, ExperimentChangeEvent> expListenerList;
    private ICEListenerList<SampleChangeListener, SampleChangeEvent> sampleListenerList;
    private ICEListenerList<ScanListChangeListener, ScanListChangeEvent> scanListChangeListeners;
    private ICEListenerList<InstrumentChangeListener, InstrumentChangeEvent> instrumentChangeListeners;
    private ICEListenerList<BraggCalcListener, BraggCalcEvent> braggCalcListeners;
    private ICEListenerList<AngleCalcListener, AngleCalcEvent> angleCalcListeners;
    private ICEListenerList<DeviceChangeListener, DeviceEvent> deviceChangeListeners;
    private ICEListenerList<IceFileContentsChangeListener, IceFileContentsChangeEvent> contentChangeListeners;
    private ICEListenerList<FitResultListener, FitResultEvent> fitResultListeners;
    private ICEListenerList<AvailableDeviceListListener, AvailableDeviceEvent> availableDeviceListListeners;
    protected ICEListenerList<DataMessageListener, DataMessageEvent> dataMessageListeners;
    protected ICEListenerList<ResponseMessageListener, ResponseMessageEvent> responseMessageListeners;
    protected HashMap<String, ICEListenerList<ResponseMessageListener, ResponseMessageEvent>> responseMessageListenerMap;
    protected ICEListenerList<UBMatrixChangeListener, UBMatrixChangeEvent> ubMatrixChangeListeners;
    protected ICEListenerList<UBCalcDestinationResponseListener, UBCalcDestinationResponseEvent> ubCalcDestinationResponseListeners;
    protected ICEListenerList<UBMatrixAskCommandListener, UBMatrixParsedAskResponse> ubMatrixAskCommandListener;
    private boolean stopFlag;
    private boolean connected;
    private boolean polling;
    protected long timeSinceLastStateMessage;
    protected static final long MAX_WAIT_TIME_FOR_STATE_MESSAGE = 120L;

    public CommunicationManager(String username, String display) {
        this.username = username;
        this.display = display;
        this.stopFlag = false;
        this.connected = false;
        this.polling = false;
        this.dispatcher = new DispatcherConnection(username, display);
        this.displayID = DispatcherConnection.getDispID();
        this.connector = new Connector();
        this.clientListenerList = new ICEListenerList();
        this.statusListenerList = new CopyOnWriteArrayList();
        this.queueChangeListenerList = new ICEListenerList();
        this.messageListenerList = new ICEListenerList();
        this.sendListenerList = new ICEListenerList();
        this.fileChangeListenerList = new ICEListenerList();
        this.errorListenerList = new ICEListenerList();
        this.expListenerList = new ICEListenerList();
        this.sampleListenerList = new ICEListenerList();
        this.scanListChangeListeners = new ICEListenerList();
        this.instrumentChangeListeners = new ICEListenerList();
        this.braggCalcListeners = new ICEListenerList();
        this.angleCalcListeners = new ICEListenerList();
        this.deviceChangeListeners = new ICEListenerList();
        this.contentChangeListeners = new ICEListenerList();
        this.fitResultListeners = new ICEListenerList();
        this.availableDeviceListListeners = new ICEListenerList();
        this.ubMatrixChangeListeners = new ICEListenerList();
        this.ubCalcDestinationResponseListeners = new ICEListenerList();
        this.ubMatrixAskCommandListener = new ICEListenerList();
        this.dataMessageListeners = new ICEListenerList();
        this.responseMessageListeners = new ICEListenerList();
        this.responseMessageListenerMap = new HashMap();
    }

    public void connectToServer(Server server) {
        this.address = server.getAddress();
        this.connectToServer();
    }

    private void connectToServer() {
        Thread thread2 = new Thread(this.connector);
        thread2.start();
    }

    public void disconnect() {
        logger.debug("disconnecting");
        this.stopFlag = true;
        this.dispatcher.disconnect();
        this.connected = false;
        this.polling = false;
    }

    public void getServerQueueList() throws IOException {
        this.dispatcher.send("CONTROL", String.valueOf(this.displayID) + " liststack");
    }

    public void sendMessage(String message, boolean notifySendListener) throws IOException {
        this.dispatcher.send("CONTROL", String.valueOf(this.displayID) + " " + message);
        if (notifySendListener) {
            SendEvent sendEvent = new SendEvent(this, message);
            this.notifySendListeners(sendEvent);
        }
    }

    public void sendMessage(String message) throws IOException {
        this.dispatcher.send("CONTROL", String.valueOf(this.displayID) + " " + message);
        SendEvent sendEvent = new SendEvent(this, message);
        this.notifySendListeners(sendEvent);
    }

    @Override
    public void run() {
        try {
            String someTag = "";
            DispatcherConnection.ServerMessage serverMessage = null;
            long currentTime = -1L;
            long diffTime = -1L;
            this.timeSinceLastStateMessage = System.currentTimeMillis();
            String preference = PreferencesManager.getPreferenceString("communication.allowTimeout");
            while (!this.stopFlag) {
                try {
                    try {
                        serverMessage = this.dispatcher.getMessage();
                    }
                    catch (NullPointerException npe) {
                        this.connected = false;
                        if (!this.stopFlag) {
                            throw new IOException("ComunicationError.run " + npe.toString());
                        }
                        logger.debug("ComunicationError.run  caught null pointer exception, but was expected: " + npe.getMessage());
                    }
                    someTag = serverMessage.getTag();
                    byte[] someData = serverMessage.getMessageBuffer();
                    String convertedData = new String(someData, "utf-8");
                    if (convertedData.length() < 100) {
                        loggerInfoFromServer.debug(convertedData);
                    }
                    convertedData.contains("State");
                    this.processMessage(someTag, convertedData);
                    if (!preference.equalsIgnoreCase("undefined") && !preference.equalsIgnoreCase("yes") || (diffTime = ((currentTime = System.currentTimeMillis()) - this.timeSinceLastStateMessage) / 1000L) <= 120L) continue;
                    logger.error("CommunicationManager.run The server has not sent a state message withing the max wait time or 120 disconnecting");
                    this.dispatcher.disconnect();
                    throw new IOException();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error("CommunicationManager.run " + e);
                }
            }
            logger.debug("commMgr done");
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            logger.error("Communication Manager.run lost connection with server", ioe);
            this.connected = false;
            if (!this.stopFlag) {
                logger.error("Communication Manager.run   Not sure why...", ioe);
                this.sendConnectionEvent(new ConnectionEvent(this, ConnectionEvent.ConnectionState.LOST_CONNECTION, "Lost connection with server."));
            }
        }
        catch (NullPointerException npe) {
            logger.error("This should not happen at all anymore CommunicationManager.init", npe);
            this.connected = false;
            this.sendConnectionEvent(new ConnectionEvent(this, ConnectionEvent.ConnectionState.LOST_CONNECTION, "Lost connection with server. Please quit and restart the client."));
        }
        catch (Exception re) {
            logger.error("Communication Manager.run  Unknown error in communication manager " + re);
        }
    }

    private void processMessage(String tag, String data) {
        try {
            if (tag.equalsIgnoreCase(this.displayID)) {
                if (data.toUpperCase().startsWith("RESPONSE:")) {
                    this.newResponseMsg(data);
                    String clientVersion = data.substring("RESPONSE:".length());
                    this.newClientMsg(clientVersion);
                } else {
                    this.newClientMsg(data);
                }
            } else if (tag.equalsIgnoreCase("MESSAGE")) {
                this.notifyMessageListeners(data);
            } else if (tag.equalsIgnoreCase("STATUS")) {
                String upperCase = data.toUpperCase();
                if (upperCase.startsWith("STATE")) {
                    this.timeSinceLastStateMessage = System.currentTimeMillis();
                    this.newStatusMessage(data);
                } else if (upperCase.startsWith("<QUEUE>")) {
                    this.newQueueMsg(data);
                } else if (upperCase.startsWith("<UB-MATRIX")) {
                    this.newUBMsg(data);
                } else if (upperCase.startsWith("FILE:")) {
                    this.newFileMsg(data);
                } else if (upperCase.startsWith("EXPT:")) {
                    this.newExpMsg(data);
                } else if (upperCase.startsWith("SAMPLE:")) {
                    this.newSampleMsg(data);
                } else if (upperCase.startsWith("SCANS:")) {
                    this.newScanMsg(data);
                } else if (upperCase.startsWith("SCANSCHANGED:")) {
                    this.newScanChangedMsg(data);
                } else if (upperCase.startsWith("SCANSDELETED:")) {
                    this.newScanDeletedMsg(data);
                } else if (upperCase.startsWith("DEVICES:")) {
                    this.newDevicesMsg(data);
                } else if (upperCase.startsWith("INSTR:")) {
                    this.newInstrMsg(data);
                }
            } else if (tag.equalsIgnoreCase("DATA")) {
                this.notifyDataMessage(data);
            } else if (tag.equalsIgnoreCase("ERROR")) {
                this.notifyErrorMessage(data);
            } else if (tag.equalsIgnoreCase("EXC")) {
                IceServerExceptionQueue.receiveExceptionMessage(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e);
        }
    }

    private void notifyDataMessage(String data) {
        DataMessageEvent dme = new DataMessageEvent(this, data, new Date());
        this.dataMessageListeners.notifyListeners(dme);
    }

    public void reconnect() {
        logger.debug("Attempting to reconnect...");
        this.connector.setReconnecting(true);
        try {
            logger.error("sleeping");
            Thread.sleep(5000L);
            logger.error("done sleeping");
        }
        catch (InterruptedException ie) {
            logger.error("thread interrupted.");
        }
        this.connectToServer();
    }

    private void newClientMsg(String data) {
        ClientMessageEvent clientMessageEvent = new ClientMessageEvent(this, data);
        this.clientListenerList.notifyListeners(clientMessageEvent);
    }

    private void newStatusMessage(String data) {
        Instrument.State state = Instrument.State.unknown;
        String instrumentXPeekName = null;
        String instrumentName = null;
        String instrumentPath = null;
        Date time = null;
        Integer scanPoint = null;
        Float scanProgress = null;
        Integer totalPoints = null;
        StringTokenizer tokenizer = new StringTokenizer(data, ":");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String tokenUC = token.toUpperCase();
            if (tokenUC.startsWith("STATE=")) {
                String stateString = tokenUC.substring(6);
                if (stateString.equals("IDLE")) {
                    state = Instrument.State.idle;
                    continue;
                }
                if (stateString.equals("BUSY")) {
                    state = Instrument.State.busy;
                    continue;
                }
                if (stateString.equals("PAUSE")) {
                    state = Instrument.State.pause;
                    continue;
                }
                if (!stateString.equals("SCAN")) continue;
                state = Instrument.State.scan;
                continue;
            }
            if (tokenUC.startsWith("XPEEKNAME=")) {
                instrumentXPeekName = token.substring(10);
                continue;
            }
            if (tokenUC.startsWith("INSTRUMENTNAME=")) {
                instrumentName = token.substring(15);
                continue;
            }
            if (tokenUC.startsWith("INSTRUMENTPATH=")) {
                instrumentPath = token.substring(15);
                continue;
            }
            if (tokenUC.startsWith("SERVERTIME=")) {
                long seconds = Double.valueOf(Double.valueOf(token.substring(11)) * 1000.0).longValue();
                time = new Date(seconds);
                continue;
            }
            if (tokenUC.startsWith("SCANPOINT=")) {
                try {
                    scanPoint = Integer.parseInt(token.substring(10));
                }
                catch (NumberFormatException nfe) {
                    logger.error("Invalid number for current scan point( " + token.substring(10) + ").  Ignoring.");
                }
                continue;
            }
            if (!tokenUC.startsWith("SCANPROG=")) continue;
            scanProgress = Float.valueOf(Float.parseFloat(token.substring(9)));
        }
        if (scanPoint != null && scanProgress != null) {
            totalPoints = Float.valueOf((float)scanPoint.intValue() / scanProgress.floatValue()).intValue();
        }
        if (instrumentName == null) {
            instrumentName = instrumentXPeekName;
            instrumentPath = "tas.macs." + instrumentName;
        }
        StatusChangeEvent sce = new StatusChangeEvent(this, state, instrumentName, instrumentPath, time, scanPoint, scanProgress, totalPoints);
        Iterator<StatusChangeListener> iterator = this.statusListenerList.iterator();
        while (iterator.hasNext()) {
            iterator.next().statusChanged(sce);
        }
    }

    public void notifyMessageListeners(String data) {
        BroadcastMessageEvent broadcastMessageEvent = new BroadcastMessageEvent(this, data);
        this.messageListenerList.notifyListeners(broadcastMessageEvent);
    }

    private void newFileMsg(String data) {
        String fullPath = "";
        StringTokenizer lineTokenizer = new StringTokenizer(data, "\n");
        String header = new String(lineTokenizer.nextToken());
        StringTokenizer headerTokenizer = new StringTokenizer(header, ":");
        headerTokenizer.nextToken();
        String rootName = new String(headerTokenizer.nextToken());
        if (headerTokenizer.hasMoreTokens()) {
            fullPath = headerTokenizer.nextToken();
        }
        ArrayList<String> files = new ArrayList<String>();
        while (lineTokenizer.hasMoreTokens()) {
            String fileName = new String(lineTokenizer.nextToken());
            files.add(fileName);
        }
        FileChangeEvent fileChangeEvent = new FileChangeEvent(this, rootName, fullPath, files);
        this.fileChangeListenerList.notifyListeners(fileChangeEvent);
    }

    public void notifyErrorMessage(String data) {
        ErrorMessageEvent errorMessageEvent = new ErrorMessageEvent(this, data);
        this.errorListenerList.notifyListeners(errorMessageEvent);
    }

    public void addClientListener(ClientMessageListener cl) throws ICEListenerListExceptionBase {
        this.clientListenerList.addListener(cl);
    }

    public boolean removeClientListener(ClientMessageListener cl) {
        return this.clientListenerList.removeListener(cl);
    }

    public void addStatusListener(StatusChangeListener sl) {
        this.statusListenerList.add(sl);
    }

    public boolean removeStatusListener(StatusChangeListener sl) {
        return this.statusListenerList.remove(sl);
    }

    public void addErrorListener(ErrorMessageListener el) throws ICEListenerListExceptionBase {
        this.errorListenerList.addListener(el);
    }

    public void removeErrorListener(ErrorMessageListener el) {
        this.errorListenerList.removeListener(el);
    }

    public void addQueueChangeListener(QueueChangeListener listener) throws ICEListenerListExceptionBase {
        this.queueChangeListenerList.addListener(listener);
    }

    public void removeQueueChangeListener(QueueChangeListener qcl) {
        this.queueChangeListenerList.removeListener(qcl);
    }

    public void addMessageListener(BroadcastMessageListener ml) throws ICEListenerListExceptionBase {
        this.messageListenerList.addListener(ml);
    }

    public void removeMessageListener(BroadcastMessageListener ml) {
        this.messageListenerList.removeListener(ml);
    }

    public void addFileChangeListener(FileChangeListener fl) throws ICEListenerListExceptionBase {
        this.fileChangeListenerList.addListener(fl);
    }

    public void removeFileChangeListener(FileChangeListener fl) {
        this.fileChangeListenerList.removeListener(fl);
    }

    public void addSendListener(SendListener sl) throws ICEListenerListExceptionBase {
        this.sendListenerList.addListener(sl);
    }

    public void removeSendListener(SendListener sl) {
        this.sendListenerList.removeListener(sl);
    }

    public void notifySendListeners(SendEvent se) {
        this.sendListenerList.notifyListeners(se);
    }

    public void addExperimentListener(ExperimentChangeListener el) throws ICEListenerListExceptionBase {
        this.expListenerList.addListener(el);
    }

    public void removeExperimentListener(ExperimentChangeListener el) {
        this.expListenerList.removeListener(el);
    }

    public void addScanListChangeListener(ScanListChangeListener slcl) throws ICEListenerListExceptionBase {
        this.scanListChangeListeners.addListener(slcl);
    }

    public void removeScanListChangeListener(ScanListChangeListener slcl) {
        this.scanListChangeListeners.removeListener(slcl);
    }

    private void newExpMsg(String data) {
        logger.debug("Experiment updated: " + data);
        StringRef id = new StringRef();
        StringRef name = new StringRef();
        StringRef participants = new StringRef();
        StringRef details = new StringRef();
        StringRef comment = new StringRef();
        if (this.parseExpMsg(data, id, name, participants, details, comment)) {
            this.notifyExpListeners(data, id.value, name.value, participants.value, details.value, comment.value);
        }
    }

    private boolean parseExpMsg(String data, StringRef id, StringRef name, StringRef participants, StringRef details, StringRef comment) {
        int location = data.indexOf("\n");
        int nameLoc = data.toUpperCase().indexOf("\nNAME=");
        int participantsLoc = data.toUpperCase().indexOf("\nPARTICIPANTS=");
        int detailsLoc = data.toUpperCase().indexOf("\nDETAILS=");
        int commentLoc = data.toUpperCase().indexOf("\nCOMMENT");
        int[] locations = new int[]{nameLoc, participantsLoc, detailsLoc, commentLoc};
        try {
            id.value = data.substring(5, location);
            Arrays.sort(locations);
            int i = 0;
            while (i < locations.length) {
                int length = i == locations.length - 1 ? data.length() : locations[i + 1];
                if (locations[i] == nameLoc) {
                    name.value = data.substring(locations[i] + 6, length);
                } else if (locations[i] == participantsLoc) {
                    participants.value = data.substring(locations[i] + 14, length);
                } else if (locations[i] == detailsLoc) {
                    details.value = data.substring(locations[i] + 9, length);
                } else if (locations[i] == commentLoc) {
                    comment.value = data.substring(locations[i] + 9, length);
                }
                ++i;
            }
            return true;
        }
        catch (NumberFormatException nfe) {
            logger.error("Experiment ID received not a number.  Ignoring.", nfe);
            return false;
        }
    }

    private void notifyExpListeners(String data, String id, String name, String participants, String details, String comment) {
        ExperimentChangeEvent experimentChangeEvent = new ExperimentChangeEvent(this, id, name, participants, details, comment);
        this.expListenerList.notifyListeners(experimentChangeEvent);
    }

    public void addSampleListener(SampleChangeListener sl) throws ICEListenerListExceptionBase {
        this.sampleListenerList.addListener(sl);
    }

    public void removeSampleListener(SampleChangeListener sl) {
        this.sampleListenerList.removeListener(sl);
    }

    private void notifySampleListeners(double a, double b, double c, double alpha, double beta, double gamma, double h1, double k1, double l1, double h2, double k2, double l2, double apert, double thk, double trans, String description) {
        SampleChangeEvent sampleChangeEvent = new SampleChangeEvent(this, a, b, c, alpha, beta, gamma, h1, k1, l1, h2, k2, l2, apert, thk, trans, description);
        this.sampleListenerList.notifyListeners(sampleChangeEvent);
    }

    private void newSampleMsg(String data) {
        DoubleRef a = new DoubleRef();
        DoubleRef b = new DoubleRef();
        DoubleRef c = new DoubleRef();
        DoubleRef alpha = new DoubleRef();
        DoubleRef beta = new DoubleRef();
        DoubleRef gamma = new DoubleRef();
        DoubleRef h1 = new DoubleRef();
        DoubleRef k1 = new DoubleRef();
        DoubleRef l1 = new DoubleRef();
        DoubleRef h2 = new DoubleRef();
        DoubleRef k2 = new DoubleRef();
        DoubleRef l2 = new DoubleRef();
        DoubleRef apert = new DoubleRef();
        DoubleRef thk = new DoubleRef();
        DoubleRef trans = new DoubleRef();
        StringRef description = new StringRef();
        if (this.parseSampleMsg(data, a, b, c, alpha, beta, gamma, h1, k1, l1, h2, k2, l2, apert, thk, trans, description)) {
            this.notifySampleListeners(a.value, b.value, c.value, alpha.value, beta.value, gamma.value, h1.value, k1.value, l1.value, h2.value, k2.value, l2.value, apert.value, thk.value, trans.value, description.value);
        }
    }

    private boolean parseSampleMsg(String data, DoubleRef a, DoubleRef b, DoubleRef c, DoubleRef alpha, DoubleRef beta, DoubleRef gamma, DoubleRef h1, DoubleRef k1, DoubleRef l1, DoubleRef h2, DoubleRef k2, DoubleRef l2, DoubleRef apert, DoubleRef thk, DoubleRef trans, StringRef description) {
        int latticeLoc = data.toUpperCase().indexOf("\nLATTICE=");
        int orientLoc = data.toUpperCase().indexOf("\nORIENT=");
        int descrLoc = data.toUpperCase().indexOf("\nDESCR=");
        int[] locations = new int[]{latticeLoc, orientLoc, descrLoc};
        Arrays.sort(locations);
        String lattices = "";
        String orients = "";
        int i = 0;
        while (i < locations.length) {
            int length = i == locations.length - 1 ? data.length() : locations[i + 1];
            if (locations[i] == latticeLoc) {
                lattices = data.substring(locations[i] + 9, length);
            } else if (locations[i] == orientLoc) {
                orients = data.substring(locations[i] + 8, length);
            } else if (locations[i] == descrLoc) {
                description.value = data.substring(locations[i] + 7, length);
            }
            ++i;
        }
        logger.debug("lattices: " + lattices + "\norients: " + orients + "\ndescription: " + description);
        try {
            StringTokenizer tokenizer = new StringTokenizer(lattices, " ");
            a.value = Double.valueOf(tokenizer.nextToken());
            b.value = Double.valueOf(tokenizer.nextToken());
            c.value = Double.valueOf(tokenizer.nextToken());
            alpha.value = Double.valueOf(tokenizer.nextToken());
            beta.value = Double.valueOf(tokenizer.nextToken());
            gamma.value = Double.valueOf(tokenizer.nextToken());
            tokenizer = new StringTokenizer(orients, " ");
            h1.value = Double.valueOf(tokenizer.nextToken());
            k1.value = Double.valueOf(tokenizer.nextToken());
            l1.value = Double.valueOf(tokenizer.nextToken());
            h2.value = Double.valueOf(tokenizer.nextToken());
            k2.value = Double.valueOf(tokenizer.nextToken());
            l2.value = Double.valueOf(tokenizer.nextToken());
        }
        catch (NumberFormatException nfe) {
            logger.error("Invalid number given with sample information.  Ignoring.", nfe);
            return false;
        }
        catch (NoSuchElementException nsee) {
            logger.error("Message corrupted, unable to read all the attributes.  Ignoring.", nsee);
            return false;
        }
        catch (IndexOutOfBoundsException ioobe) {
            logger.error("Message corrupted, unable to read all the attributes.  Ignoring.", ioobe);
            return false;
        }
        Double temp = null;
        temp = this.getDoubleFromBuffer("APERT=", data);
        apert.value = temp;
        temp = this.getDoubleFromBuffer("THK=", data);
        thk.value = temp;
        temp = this.getDoubleFromBuffer("TRANS=", data);
        trans.value = temp;
        return true;
    }

    protected Double getDoubleFromBuffer(String key, String buffer) {
        int index = -1;
        int endIndex = -1;
        String value = null;
        String[] pair = null;
        Double theDouble = 0.0;
        index = buffer.indexOf(key);
        if (index > -1) {
            endIndex = buffer.indexOf(10, index);
            if (endIndex == -1) {
                endIndex = buffer.length();
            }
            if ((pair = (value = buffer.substring(index, endIndex)).split("=")).length > 1) {
                try {
                    theDouble = Double.parseDouble(pair[1]);
                }
                catch (NumberFormatException e) {
                    theDouble = 0.0;
                }
            }
        }
        return theDouble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstrumentChangeListener(InstrumentChangeListener icl) throws ICEListenerListExceptionBase {
        ICEListenerList<InstrumentChangeListener, InstrumentChangeEvent> iCEListenerList = this.instrumentChangeListeners;
        synchronized (iCEListenerList) {
            this.instrumentChangeListeners.addListener(icl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstrumentChangeListener(InstrumentChangeListener icl) {
        ICEListenerList<InstrumentChangeListener, InstrumentChangeEvent> iCEListenerList = this.instrumentChangeListeners;
        synchronized (iCEListenerList) {
            this.instrumentChangeListeners.removeListener(icl);
        }
    }

    private void newInstrMsg(String data) {
        Instrument.VerticalFocusMode vertFMode = Instrument.VerticalFocusMode.unknown;
        Instrument.HorizontalFocusMode horizFMode = Instrument.HorizontalFocusMode.unknown;
        double phi = -1.0;
        double anaSpacing = -1.0;
        double monoSpacing = -1.0;
        Instrument.DetectorMode detectorMode = Instrument.DetectorMode.UNKNOWN;
        Instrument.AnalyzerMode analyzerMode = Instrument.AnalyzerMode.unknown;
        boolean ubMatrixMode = false;
        String defaultSampleChanger = "N/A";
        String[] sampleHolderPositions = null;
        StringTokenizer tokenizer = new StringTokenizer(data, "\n");
        tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String upperCase = token.toUpperCase();
            logger.debug("token: " + token);
            if (upperCase.startsWith("VERTIFOCUS=")) {
                if ((upperCase = upperCase.substring(11)).equals("FLAT")) {
                    vertFMode = Instrument.VerticalFocusMode.flat;
                    continue;
                }
                if (!upperCase.equals("SAGITTAL")) continue;
                vertFMode = Instrument.VerticalFocusMode.sagittal;
                continue;
            }
            if (upperCase.startsWith("HORIZFOCUS=")) {
                if ((upperCase = upperCase.substring(11)).equals("ENERGY")) {
                    horizFMode = Instrument.HorizontalFocusMode.energy;
                    continue;
                }
                if (upperCase.equals("FLAT")) {
                    horizFMode = Instrument.HorizontalFocusMode.flat;
                    continue;
                }
                if (upperCase.equals("POINT")) {
                    horizFMode = Instrument.HorizontalFocusMode.point;
                    continue;
                }
                if (!upperCase.equals("VENETIAN")) continue;
                horizFMode = Instrument.HorizontalFocusMode.venetian;
                continue;
            }
            if (upperCase.startsWith("PHI=")) {
                try {
                    phi = Double.parseDouble(upperCase.substring(4));
                }
                catch (NumberFormatException nfe) {
                    logger.error("Unable to parse phi.  Ignoring.", nfe);
                }
                continue;
            }
            if (upperCase.startsWith("ANASPACING=")) {
                try {
                    anaSpacing = Double.parseDouble(upperCase.substring(11));
                }
                catch (NumberFormatException nfe) {
                    logger.error("Unable to parse anaspacing.  Ignoring.", nfe);
                }
                continue;
            }
            if (upperCase.startsWith("MONOSPACING=")) {
                try {
                    monoSpacing = Double.parseDouble(upperCase.substring(12));
                }
                catch (NumberFormatException nfe) {
                    logger.error("Unable to parse monospacing.  Ignoring.", nfe);
                }
                continue;
            }
            if (upperCase.startsWith("DETMODE=")) {
                String detMode = upperCase.substring(8);
                if (detMode.equals("DD")) {
                    detectorMode = Instrument.DetectorMode.DIFFRACTIONDETECTOR;
                    continue;
                }
                if (detMode.equals("SD")) {
                    detectorMode = Instrument.DetectorMode.SINGLEDETECTOR;
                    continue;
                }
                if (!detMode.equals("PSD")) continue;
                detectorMode = Instrument.DetectorMode.POSITIONSENSITIVEDETECTOR;
                continue;
            }
            if (upperCase.startsWith("ANALYZERFOCUSMODE=")) {
                String anaMode = upperCase.substring(18);
                if (anaMode.equals("ENERGY")) {
                    analyzerMode = Instrument.AnalyzerMode.energy;
                    continue;
                }
                if (!anaMode.equals("FLAT")) continue;
                analyzerMode = Instrument.AnalyzerMode.flat;
                continue;
            }
            if (upperCase.startsWith("UBMATRIXMODE=")) {
                String ubMode = upperCase.substring(13);
                if (ubMode.equals("ENABLED")) {
                    ubMatrixMode = true;
                    continue;
                }
                if (!ubMode.equals("DISABLED")) continue;
                ubMatrixMode = false;
                continue;
            }
            if (upperCase.startsWith("DEFAULTSAMPLECHANGER=")) {
                defaultSampleChanger = upperCase.substring(21);
                continue;
            }
            if (!upperCase.startsWith("SAMPLECHANGER=")) continue;
            String values = upperCase.substring(14);
            String[] blocks = values.split(",");
            sampleHolderPositions = blocks;
        }
        InstrumentChangeEvent ice = new InstrumentChangeEvent(this, horizFMode, vertFMode, phi, anaSpacing, monoSpacing, detectorMode, analyzerMode, ubMatrixMode, defaultSampleChanger, sampleHolderPositions);
        this.instrumentChangeListeners.notifyListeners(ice);
    }

    public boolean addBraggCalcListener(BraggCalcListener bcl) {
        boolean returnValue = true;
        try {
            this.braggCalcListeners.addListener(bcl);
        }
        catch (Exception e) {
            returnValue = false;
        }
        return returnValue;
    }

    public boolean removeBraggCalcListener(BraggCalcListener bcl) {
        return this.braggCalcListeners.removeListener(bcl);
    }

    public boolean addAngleCalcListener(AngleCalcListener acl) {
        boolean returnValue = true;
        try {
            this.angleCalcListeners.addListener(acl);
        }
        catch (ICEListenerListExceptionBase e) {
            returnValue = false;
        }
        return returnValue;
    }

    public boolean removeAngleCalcListener(AngleCalcListener acl) {
        return this.angleCalcListeners.removeListener(acl);
    }

    private synchronized void newResponseMsg(String response) {
        block31: {
            try {
                ICEListenerList<ResponseMessageListener, ResponseMessageEvent> listenerList;
                if (response.toUpperCase().startsWith("RESPONSE:")) {
                    response = response.substring(9);
                }
                logger.debug("response: " + response);
                String upperCase = response.toUpperCase();
                ResponseMessageEvent responseMsgEvent = new ResponseMessageEvent(this, response);
                if (this.responseMessageListenerMap.get(null) != null) {
                    listenerList = this.responseMessageListenerMap.get(null);
                    listenerList.notifyListeners(responseMsgEvent);
                }
                if (responseMsgEvent.getLabel() != null && this.responseMessageListenerMap.get(responseMsgEvent.getLabel()) != null) {
                    listenerList = this.responseMessageListenerMap.get(responseMsgEvent.getLabel());
                    listenerList.notifyListeners(responseMsgEvent);
                }
                this.responseMessageListeners.notifyListeners(responseMsgEvent);
                if (upperCase.startsWith("QECALC:")) {
                    ArrayList<Double> AMotorValues = new ArrayList<Double>();
                    boolean isValid = true;
                    response = response.substring(7);
                    try {
                        try {
                            String[] data = response.split(" ");
                            int x = 0;
                            while (x < data.length) {
                                Double AMotorValue = Double.valueOf(data[x]);
                                AMotorValues.add(AMotorValue);
                                ++x;
                            }
                            break block31;
                        }
                        catch (NoSuchElementException nsee) {
                            logger.error("Bad QECalc (Bragg Buffer) response.  Not enough fields.  Cancelling.", nsee);
                            isValid = false;
                            BraggCalcEvent braggCalcEvent = new BraggCalcEvent(this, isValid, AMotorValues);
                            this.braggCalcListeners.notifyListeners(braggCalcEvent);
                            break block31;
                        }
                        catch (NumberFormatException nfe) {
                            logger.error("Bad QeCalc (Bragg Buffer) response.  Invalid number given.  Cancelling.", nfe);
                            isValid = false;
                            BraggCalcEvent braggCalcEvent = new BraggCalcEvent(this, isValid, AMotorValues);
                            this.braggCalcListeners.notifyListeners(braggCalcEvent);
                            break block31;
                        }
                    }
                    finally {
                        BraggCalcEvent braggCalcEvent = new BraggCalcEvent(this, isValid, AMotorValues);
                        this.braggCalcListeners.notifyListeners(braggCalcEvent);
                    }
                }
                if (UBMatrixAskCommandListenerUtil.isStringUBMatrixAskResponse(upperCase)) {
                    UBMatrixParsedAskResponse theParsedResponse = null;
                    theParsedResponse = UBMatrixParsedAskResponse.parseAskResponseString(this, response);
                    this.ubMatrixAskCommandListener.notifyListeners(theParsedResponse);
                } else if (upperCase.startsWith("CALCA3A4FROMHKL:")) {
                    logger.debug("calc response: " + response);
                    response = response.substring(16);
                    ArrayList<Double> angleValues = new ArrayList<Double>();
                    try {
                        String[] data = response.split(" ");
                        int x = 0;
                        while (x < data.length) {
                            Double angleValue = Double.valueOf(data[x]);
                            angleValues.add(angleValue);
                            ++x;
                        }
                        AngleCalcEvent angleCalcEvent = new AngleCalcEvent(this, angleValues);
                        this.angleCalcListeners.notifyListeners(angleCalcEvent);
                    }
                    catch (NoSuchElementException nsee) {
                        logger.error("Bad calcA3A4fromHKL (Sample Alignment) response.  Not enough fields.  Cancelling.", nsee);
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Bad calcA3A4fromHKL (Sample Alignment) response.  Invalid number given.  Cancelling.", nfe);
                    }
                } else if (upperCase.startsWith("GETFITRESULTS:")) {
                    logger.debug("fit result: " + response);
                    try {
                        response = response.substring(14);
                        double fitResult = Double.parseDouble(response);
                        FitResultEvent fitResultEvent = new FitResultEvent(this, fitResult);
                        this.fitResultListeners.notifyListeners(fitResultEvent);
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number for getfitresult", nfe);
                    }
                } else if (upperCase.startsWith("RESOURCEFILECONTENTS:")) {
                    this.newResourceFileContentsResponse(response.substring(21));
                } else if (upperCase.startsWith("GETAVAILABLEDEVICEDEFAULTS:")) {
                    this.newDeviceListMsg(response.substring(27));
                } else if (upperCase.startsWith("CALCA3A4FROMHKLUBMOVE:")) {
                    String message = response.substring(22);
                    this.newUBCalcDestinationMsg(message);
                }
            }
            catch (Exception e) {
                logger.error(e);
                e.printStackTrace();
            }
        }
    }

    protected void newUBCalcDestinationMsg(String message) {
        StringTokenizer tokenizer = new StringTokenizer(message, ",=[]");
        try {
            double h = Double.parseDouble(tokenizer.nextToken().trim());
            double k = Double.parseDouble(tokenizer.nextToken().trim());
            double l = Double.parseDouble(tokenizer.nextToken().trim());
            tokenizer.nextToken();
            double a3 = Double.parseDouble(tokenizer.nextToken().trim());
            tokenizer.nextToken();
            double a4 = Double.parseDouble(tokenizer.nextToken().trim());
            tokenizer.nextToken();
            double lTilt = Double.parseDouble(tokenizer.nextToken().trim());
            tokenizer.nextToken();
            double uTilt = Double.parseDouble(tokenizer.nextToken().trim());
            UBCalcDestinationResponseEvent event = new UBCalcDestinationResponseEvent(this, a3, a4, lTilt, uTilt);
            this.ubCalcDestinationResponseListeners.notifyListeners(event);
        }
        catch (NumberFormatException nfee) {
            logger.error("Malformed message ubcalcdestination response received.  Ignoring.  Message: " + message);
        }
    }

    private void newQueueMsg(String data) {
        ArrayList<QueueCommand> cmdList = new ArrayList<QueueCommand>();
        QueueCommand currCommand = null;
        String currOwner = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(data.getBytes()));
            NodeList nodeList = doc.getFirstChild().getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if ("CMD".equalsIgnoreCase(node.getNodeName())) {
                    int id = -1;
                    QueueCommand.State state = null;
                    String owner = null;
                    Double estimatedTime = null;
                    String value = null;
                    NamedNodeMap attributes = node.getAttributes();
                    id = Integer.parseInt(attributes.getNamedItem("id").getNodeValue());
                    NodeList cmdNodes = node.getChildNodes();
                    int j = 0;
                    while (j < cmdNodes.getLength()) {
                        Node childNode = cmdNodes.item(j);
                        if (childNode.getNodeType() == 1) {
                            String childNodeName = childNode.getNodeName();
                            if ("STATUS".equalsIgnoreCase(childNodeName)) {
                                String status = childNode.getFirstChild().getNodeValue();
                                if ("current".equalsIgnoreCase(status)) {
                                    state = QueueCommand.State.current;
                                } else if ("queued".equalsIgnoreCase(status)) {
                                    state = QueueCommand.State.future;
                                }
                            } else if ("OWNER".equalsIgnoreCase(childNodeName)) {
                                owner = childNode.getFirstChild().getNodeValue();
                            } else if ("ESTIMATEDTIME".equalsIgnoreCase(childNodeName)) {
                                String timeValue = childNode.getFirstChild().getNodeValue();
                                try {
                                    estimatedTime = Double.valueOf(timeValue);
                                }
                                catch (NumberFormatException e) {
                                    logger.error("estimated time is not a double");
                                }
                            } else if ("VALUE".equalsIgnoreCase(childNodeName)) {
                                value = childNode.getFirstChild().getNodeValue();
                            }
                        }
                        ++j;
                    }
                    QueueCommand qc = new QueueCommand(id, value, state, estimatedTime);
                    if (state == QueueCommand.State.current) {
                        currCommand = qc;
                        currOwner = owner;
                    } else {
                        cmdList.add(qc);
                    }
                }
                ++i;
            }
            this.notifyQueueListeners(currCommand, currOwner, cmdList);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addUBMatrixChangeListener(UBMatrixChangeListener ubmcl) throws ICEListenerListExceptionBase {
        this.ubMatrixChangeListeners.addListener(ubmcl);
    }

    public void removeUBMatrixChangeListener(UBMatrixChangeListener ubmcl) {
        this.ubMatrixChangeListeners.removeListener(ubmcl);
    }

    protected void newUBMsg(String data) {
        logger.debug("New UB Matrix message.");
        try {
            UBMatrixChangeEvent ubMatrixChangeEvent = null;
            ubMatrixChangeEvent = UBMatrixChangeEventParser.ubMatrixChangeEventParser(this, data);
            this.ubMatrixChangeListeners.notifyListeners(ubMatrixChangeEvent);
        }
        catch (UBMatrixParseChangeEventException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException nfe) {
            logger.error("Error parsing message.", nfe);
        }
    }

    public static void descend(Node node, String spacer) {
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1) {
                System.out.println(String.valueOf(spacer) + "Name: " + childNode.getNodeName());
                System.out.println(String.valueOf(spacer) + "Num Children: " + childNode.getChildNodes().getLength());
                CommunicationManager.descend(childNode, String.valueOf(spacer) + " ");
            } else if (childNode.getNodeType() == 3) {
                System.out.println(String.valueOf(spacer) + "Text: " + childNode.getNodeValue());
            }
            ++i;
        }
    }

    private void notifyQueueListeners(QueueCommand currCommand, String currOwner, ArrayList<QueueCommand> cmdList) {
        QueueChangeEvent queueChangeEvent = null;
        queueChangeEvent = new QueueChangeEvent(this, currCommand, currOwner, cmdList);
        this.queueChangeListenerList.notifyListeners(queueChangeEvent);
    }

    private void newScanMsg(String data) {
        ScanListChangeEvent slce = new ScanListChangeEvent(this);
        slce.setNewScanList(this.extractScanList(data));
        this.scanListChangeListeners.notifyListeners(slce);
    }

    private void newScanChangedMsg(String data) {
        ScanListChangeEvent slce = new ScanListChangeEvent(this);
        slce.setChangedScanList(this.extractScanList(data));
        this.scanListChangeListeners.notifyListeners(slce);
    }

    private void newScanDeletedMsg(String data) {
        ScanListChangeEvent slce = new ScanListChangeEvent(this);
        slce.setDeletedScanList(this.extractScanList(data));
        this.scanListChangeListeners.notifyListeners(slce);
    }

    private ArrayList<BaseScan> extractScanList(String data) {
        ArrayList<BaseScan> scanList = new ArrayList<BaseScan>();
        StringTokenizer outerTokenizer = new StringTokenizer(data, "\n");
        outerTokenizer.nextToken();
        while (outerTokenizer.hasMoreTokens()) {
            String scanData = new String(outerTokenizer.nextToken());
            int index1 = scanData.toUpperCase().indexOf("JTYPE=");
            BaseScan.ScanType scanType = BaseScan.ScanType.unknownScan;
            if (index1 != -1) {
                String scanTypeString;
                int index2 = scanData.toUpperCase().indexOf(":", index1);
                if (index2 == -1) {
                    index2 = scanData.length() - 1;
                }
                if ((scanTypeString = scanData.substring(index1 + 6, index2).toUpperCase()).equals("ANGLE")) {
                    scanType = BaseScan.ScanType.angleScan;
                } else if (scanTypeString.equals("VECTOR")) {
                    scanType = BaseScan.ScanType.vectorScan;
                } else if (scanTypeString.equals("ENV")) {
                    scanType = BaseScan.ScanType.environmentScan;
                } else if (scanTypeString.equals("MOTOR")) {
                    scanType = BaseScan.ScanType.motorScan;
                } else if (scanTypeString.equals("SANSAUTO")) {
                    scanType = BaseScan.ScanType.sansScan;
                    this.createSansScan();
                }
            }
            index1 = scanData.toUpperCase().indexOf("SUBID=");
            String submissionID = "Unknown";
            if (index1 != -1) {
                int index2 = scanData.toUpperCase().indexOf(":", index1);
                if (index2 == -1) {
                    index2 = scanData.length() - 1;
                }
                submissionID = scanData.substring(index1 + 6, index2);
            }
            BaseScan newScan = scanType.equals("SANSAUTO") ? new BaseScan(scanType, submissionID) : new SansScan(scanType, submissionID);
            StringTokenizer scanTokenizer = new StringTokenizer(scanData, ":");
            scanTokenizer.nextToken();
            boolean inComment = false;
            while (scanTokenizer.hasMoreTokens()) {
                String token = new String(scanTokenizer.nextToken());
                String tokenUpperCase = token.toUpperCase();
                if (inComment) {
                    int quoteIndex = token.indexOf(34);
                    while (quoteIndex > 0 && token.charAt(quoteIndex - 1) == '\\') {
                        quoteIndex = token.indexOf(34, quoteIndex + 1);
                    }
                    if (quoteIndex >= 0) {
                        inComment = false;
                    }
                    newScan.appendComments(":" + token);
                    continue;
                }
                if (tokenUpperCase.startsWith("TITLE=")) {
                    String title = token.substring(6, token.length());
                    newScan.setName(title);
                    continue;
                }
                if (tokenUpperCase.startsWith("FILENAME=")) {
                    String prefix = token.substring(9, token.length());
                    newScan.setPrefix(prefix);
                    continue;
                }
                if (tokenUpperCase.startsWith("COMMENT=")) {
                    String commnt = token.substring(8, token.length());
                    int quoteIndex = token.indexOf(34);
                    while (quoteIndex > 0 && token.charAt(quoteIndex - 1) == '\\') {
                        quoteIndex = token.indexOf(34, quoteIndex + 1);
                    }
                    if (quoteIndex >= 0) {
                        inComment = true;
                        quoteIndex = token.indexOf(34, quoteIndex + 1);
                        while (quoteIndex > 0 && token.charAt(quoteIndex - 1) == '\\') {
                            quoteIndex = token.indexOf(34, quoteIndex + 1);
                        }
                        if (quoteIndex >= 0) {
                            inComment = false;
                        }
                    }
                    newScan.setComments(commnt);
                    continue;
                }
                if (tokenUpperCase.startsWith("NPTS=")) {
                    try {
                        newScan.setNumPoints(Integer.parseInt(token.substring(5, token.length())));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number setting number of points in scan.  Ignoring: " + nfe);
                    }
                    continue;
                }
                if (tokenUpperCase.startsWith("PREFAC=")) {
                    try {
                        newScan.setPrefactor(Double.parseDouble(token.substring(7, token.length())));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number setting prefactor in scan.  Ignoring: " + nfe);
                    }
                    continue;
                }
                if (tokenUpperCase.startsWith("COUNTS=")) {
                    try {
                        newScan.setBaseCount(Double.parseDouble(token.substring(7, token.length())));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number setting base count in scan.  Ignoring: " + nfe);
                    }
                    continue;
                }
                if (tokenUpperCase.startsWith("DETECTORTYPE=")) {
                    String detectorType = token.substring(13, token.length()).toUpperCase();
                    if (detectorType.equals("DETECTOR")) {
                        newScan.setDataOfInterest(BaseScan.DataOfInterest.detector);
                        continue;
                    }
                    if (detectorType.equals("MONITOR")) {
                        newScan.setDataOfInterest(BaseScan.DataOfInterest.monitor);
                        continue;
                    }
                    if (!detectorType.equals("TIME")) continue;
                    newScan.setDataOfInterest(BaseScan.DataOfInterest.time);
                    continue;
                }
                if (tokenUpperCase.startsWith("COUNTTYPE=")) {
                    String countType = token.substring(10, token.length()).toUpperCase();
                    if (countType.equals("MONITOR")) {
                        newScan.setCountType(BaseScan.CountType.monitor);
                        continue;
                    }
                    if (!countType.equals("TIME")) continue;
                    newScan.setCountType(BaseScan.CountType.time);
                    continue;
                }
                if (tokenUpperCase.startsWith("TIMEOUT=")) {
                    try {
                        newScan.setCountTimeout(Double.parseDouble(token.substring(8, token.length())));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number setting count timeout in scan.  Ignoring: " + nfe);
                    }
                    continue;
                }
                if (tokenUpperCase.startsWith("FIXED=")) {
                    if (token.substring(6, token.length()).equals("0")) {
                        newScan.setFixedEnergyDevice(BaseScan.FixedEnergy.monochromator);
                        continue;
                    }
                    if (!token.substring(6, token.length()).equals("1")) continue;
                    newScan.setFixedEnergyDevice(BaseScan.FixedEnergy.analyzer);
                    continue;
                }
                if (tokenUpperCase.startsWith("FIXEDE=")) {
                    try {
                        newScan.setFixedEnergy(Double.parseDouble(token.substring(7, token.length())));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number setting fixed energy value in scan.  Ignoring: " + nfe);
                    }
                    continue;
                }
                if (tokenUpperCase.startsWith("HOLDPOINT=")) {
                    try {
                        newScan.setPointHold(Double.parseDouble(token.substring(10, token.length())));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number setting point hold in scan.  Ignoring: " + nfe);
                    }
                    continue;
                }
                if (tokenUpperCase.startsWith("HOLDSCAN=")) {
                    try {
                        newScan.setPreScanHold(Double.valueOf(token.substring(9, token.length())));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number setting pre-scan hold in scan.  Ignoring: " + nfe);
                    }
                    continue;
                }
                if (tokenUpperCase.startsWith("PRESETDEVICESPROPERTIES=")) {
                    try {
                        String temp = "TEMP";
                        String magnet = "MAGFIELD";
                        String guides = "GUIDETABLE";
                        Pattern p = Pattern.compile("(\\d+\\.?\\d*|N/A)");
                        Matcher m = p.matcher(token);
                        if (tokenUpperCase.contains(temp)) {
                            String value1;
                            int index = token.indexOf("tolerance");
                            if (index != -1 && m.find(index)) {
                                value1 = m.group(1);
                                newScan.settempTolerance(Double.valueOf(value1));
                            }
                            if ((index = token.indexOf("toleranceDT")) != -1 && m.find(index)) {
                                value1 = m.group(1);
                                newScan.settempToleranceBT(Double.valueOf(value1));
                            }
                            if ((index = token.indexOf("timeout")) == -1 || !m.find(index)) continue;
                            value1 = m.group(1);
                            newScan.settempMaxWaitTime(Double.valueOf(value1));
                            continue;
                        }
                        if (tokenUpperCase.contains(magnet)) {
                            int index = token.indexOf("tolerance");
                            if (index == -1 || !m.find(index)) continue;
                            String value1 = m.group(1);
                            newScan.setmagTolerance(Double.valueOf(value1));
                            continue;
                        }
                        if (!tokenUpperCase.contains(guides)) continue;
                        String aperture = "apert";
                        int index = token.indexOf("apert");
                        if (index == -1 || !m.find(index)) continue;
                        String value1 = m.group(1);
                        newScan.addPresetDeviceProperty(guides.toString(), "apert", value1);
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number for environment property value for scan.  Ignoring: " + nfe);
                    }
                    continue;
                }
                if (tokenUpperCase.startsWith("RANGE=")) {
                    try {
                        String range = token.substring(6, token.length());
                        int deviceIndex1 = range.indexOf("=");
                        if (deviceIndex1 == -1) continue;
                        String deviceName = range.substring(0, deviceIndex1);
                        int deviceIndex2 = range.indexOf(" ", deviceIndex1 + 1);
                        int deviceIndex3 = range.indexOf(" ", deviceIndex2 + 1);
                        if (deviceIndex3 == -1) {
                            deviceIndex3 = range.length();
                        }
                        if (deviceIndex2 == -1) continue;
                        if (deviceName.toUpperCase().equals("DUMMYTEMP") || deviceName.toUpperCase().equals("LAKESHORE331") || deviceName.toUpperCase().equals("LAKESHORE340") || deviceName.toUpperCase().equals("OXFORDTEMP") || deviceName.toUpperCase().equals("EUROFURNACE") || deviceName.toUpperCase().equals("FURNACE") || deviceName.toUpperCase().equals("TEMP")) {
                            double firstValue = Double.valueOf(range.substring(deviceIndex1 + 1, deviceIndex2));
                            newScan.settempSetPoint(firstValue);
                        }
                        if (deviceName.toUpperCase().equals("LAKESHORE7T") || deviceName.toUpperCase().equals("LAKESHORE7SHORT") || deviceName.toUpperCase().equals("OXFORD11T") || deviceName.toUpperCase().equals("OXFORD7T") || deviceName.toUpperCase().equals("OXFORD11TEST") || deviceName.toUpperCase().equals("OXFORD11SHORT") || deviceName.toUpperCase().equals("MAGFIELD")) {
                            double firstValue = Double.valueOf(range.substring(deviceIndex1 + 1, deviceIndex2));
                            newScan.setmagSetPoint(firstValue);
                        }
                        if (deviceName.toUpperCase().equals("Q")) {
                            try {
                                String firstVector = range.substring(deviceIndex1 + 1, deviceIndex2);
                                String secondVector = range.substring(deviceIndex2 + 1, deviceIndex3);
                                StringTokenizer tokenizer = new StringTokenizer(firstVector, "~");
                                double h1 = Double.parseDouble(tokenizer.nextToken());
                                double k1 = Double.parseDouble(tokenizer.nextToken());
                                double l1 = Double.parseDouble(tokenizer.nextToken());
                                tokenizer = new StringTokenizer(secondVector, "~");
                                double h2 = Double.parseDouble(tokenizer.nextToken());
                                double k2 = Double.parseDouble(tokenizer.nextToken());
                                double l2 = Double.parseDouble(tokenizer.nextToken());
                                newScan.addDeviceRange("H", h1, h2);
                                newScan.addDeviceRange("K", k1, k2);
                                newScan.addDeviceRange("L", l1, l2);
                            }
                            catch (Exception parseError) {
                                logger.error("Could not parse Q properly", parseError);
                            }
                            continue;
                        }
                        double firstValue = Double.valueOf(range.substring(deviceIndex1 + 1, deviceIndex2));
                        double secondValue = Double.valueOf(range.substring(deviceIndex2 + 1, deviceIndex3));
                        if (range.toUpperCase().endsWith("S")) {
                            newScan.setRangeMode(BaseScan.INITIAL_FINAL);
                        } else if (range.toUpperCase().endsWith("I")) {
                            newScan.setRangeMode(BaseScan.INITIAL_STEP);
                        } else {
                            newScan.setRangeMode(BaseScan.CENTER_STEP);
                        }
                        newScan.addDeviceRange(deviceName, firstValue, secondValue);
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number setting device range.  Ignoring: " + nfe);
                    }
                    continue;
                }
                if (tokenUpperCase.startsWith("ANGLE=")) {
                    String angleToken = token.substring(6, token.length());
                    for (SansScan.AngleFields op : EnumSet.allOf(SansScan.AngleFields.class)) {
                        String angleField = op.getName();
                        if (!angleToken.toUpperCase().startsWith(String.valueOf(angleField.toUpperCase()) + "=")) continue;
                        int size = angleField.length();
                        ((SansScan)newScan).addAngleValue(angleField, angleToken.substring(size + 1, angleToken.length()));
                    }
                    continue;
                }
                if (tokenUpperCase.startsWith("SAMPLE=")) {
                    String sampleToken = token.substring(7, token.length());
                    for (SansScan.SampleFields op : EnumSet.allOf(SansScan.SampleFields.class)) {
                        String sampleField = op.getName();
                        if (!sampleToken.toUpperCase().startsWith(String.valueOf(sampleField.toUpperCase()) + "=")) continue;
                        int size = sampleField.length();
                        ((SansScan)newScan).addSampleValue(sampleField, sampleToken.substring(size + 1, sampleToken.length()));
                    }
                    continue;
                }
                for (SansScan.ScanFields op : EnumSet.allOf(SansScan.ScanFields.class)) {
                    String scanField = op.getName();
                    if (!tokenUpperCase.startsWith(String.valueOf(scanField.toUpperCase()) + "=")) continue;
                    int size = scanField.length();
                    ((SansScan)newScan).addScanValue(scanField, token.substring(size + 1, token.length()));
                }
            }
            scanList.add(newScan);
        }
        return scanList;
    }

    private void createSansScan() {
    }

    private void newDevicesMsg(String data) {
        logger.debug("New devices status message: " + data);
        Vector<DeviceChangeEvent> events = new Vector<DeviceChangeEvent>();
        StringTokenizer lineTokenizer = new StringTokenizer(data, "\n");
        lineTokenizer.nextToken();
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken();
            StringTokenizer tokenizer = new StringTokenizer(line, ":");
            String deviceName = tokenizer.nextToken();
            String secondTokenUC = tokenizer.nextToken().toUpperCase();
            if (secondTokenUC.equals("REMOVED")) {
                Vector<DeviceRemoveEvent> removeEvents = new Vector<DeviceRemoveEvent>();
                DeviceRemoveEvent dre = new DeviceRemoveEvent(this, deviceName);
                DeviceEvent deviceEvent = null;
                removeEvents.add(dre);
                deviceEvent = new DeviceEvent(this, removeEvents, DeviceEvent.Type.REMOVE);
                this.deviceChangeListeners.notifyListeners(deviceEvent);
                continue;
            }
            InstalledDevice.Type type = InstalledDevice.Type.unknown;
            String units = "None";
            Double lowerLimit = Double.NaN;
            Double upperLimit = Double.NaN;
            Boolean busy = null;
            Boolean fixed = null;
            String softwareValue = null;
            String hardwareValue = null;
            String parent = null;
            Double tolerance = null;
            Integer channel = null;
            DeviceChangeEvent.EnvType environmentType = null;
            Integer numSensors = null;
            Integer sampleChannel = null;
            Integer controlChannel = null;
            Double maxUpperTilt = null;
            Double maxLowerTilt = null;
            Boolean persistenceMode = null;
            Boolean persistenceFlag = null;
            Double timeout = null;
            Boolean brokenState = null;
            Boolean oldBrokenState = null;
            HashMap<String, String> extras = new HashMap<String, String>();
            if (secondTokenUC.equals("ALIAS")) {
                type = InstalledDevice.Type.alias;
            } else if (secondTokenUC.equals("COUNTER")) {
                type = InstalledDevice.Type.counter;
            } else if (secondTokenUC.equals("ENV")) {
                type = InstalledDevice.Type.environment;
            } else if (secondTokenUC.equals("MOTOR")) {
                type = InstalledDevice.Type.motor;
            } else if (secondTokenUC.equals("SWITCH")) {
                type = InstalledDevice.Type.switchType;
            } else if (secondTokenUC.equals("VIRTUAL")) {
                type = InstalledDevice.Type.virtual;
            }
            while (tokenizer.hasMoreTokens()) {
                String value;
                String token = tokenizer.nextToken();
                String tokenUC = token.toUpperCase();
                if (tokenUC.startsWith("UNIT=")) {
                    units = token.substring(5);
                    continue;
                }
                if (tokenUC.startsWith("LOW=")) {
                    try {
                        lowerLimit = Double.parseDouble(token.substring(4));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number for lower limit value(" + token + ").  Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("UP=")) {
                    try {
                        upperLimit = Double.parseDouble(token.substring(3));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number for upper limit value(" + token + "). Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("BUSY=")) {
                    if (token.substring(5).equals("0")) {
                        busy = false;
                        continue;
                    }
                    if (token.substring(5).equals("1")) {
                        busy = true;
                        continue;
                    }
                    logger.error("Invalid boolean for busy state(" + token + ").  Ignoring.");
                    continue;
                }
                if (tokenUC.startsWith("FIX=")) {
                    if (token.substring(4).equals("0")) {
                        fixed = false;
                        continue;
                    }
                    if (token.substring(4).equals("1")) {
                        fixed = true;
                        continue;
                    }
                    logger.error("Invalid boolean for fixed state(" + token + ").  Ignoring.");
                    continue;
                }
                if (tokenUC.startsWith("SVAL=")) {
                    softwareValue = token.substring(5);
                    continue;
                }
                if (tokenUC.startsWith("HVAL=")) {
                    hardwareValue = token.substring(5);
                    continue;
                }
                if (tokenUC.startsWith("PARENT=")) {
                    parent = token.substring(7);
                    continue;
                }
                if (tokenUC.startsWith("TOLERANCE=")) {
                    try {
                        tolerance = Double.parseDouble(token.substring(10));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number for tolerance (" + token.substring(4) + ").  Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("CHANNEL=")) {
                    try {
                        channel = Integer.parseInt(token.substring(8));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number for channel (" + token.substring(8) + ").  Ignoring");
                    }
                    continue;
                }
                if (tokenUC.startsWith("CLASS=")) {
                    value = tokenUC.substring(6);
                    if ("TEMPERATURE".equals(value)) {
                        environmentType = DeviceChangeEvent.EnvType.TEMPERATURE;
                        continue;
                    }
                    if ("MAGNET".equals(value)) {
                        environmentType = DeviceChangeEvent.EnvType.MAGNET;
                        continue;
                    }
                    if ("PRESSURE".equals(value)) {
                        environmentType = DeviceChangeEvent.EnvType.PRESSURE;
                        continue;
                    }
                    if (!"OTHER".equals(value)) continue;
                    environmentType = DeviceChangeEvent.EnvType.MISCELLANEOUS;
                    continue;
                }
                if (tokenUC.startsWith("NUMSENSORS=")) {
                    try {
                        numSensors = Integer.valueOf(token.substring(11));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number value for number of sensors (" + token.substring(11) + ").  Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("SAMPLESENSORINDEX=")) {
                    try {
                        sampleChannel = Integer.valueOf(token.substring(18));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number value for sample channel (" + token.substring(18) + ").  Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("CONTROLSENSORINDEX=")) {
                    try {
                        controlChannel = Integer.valueOf(token.substring(19));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number value for control channel (" + token.substring(19) + ").  Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("UPPERTILTLIMIT=")) {
                    try {
                        maxUpperTilt = Double.valueOf(token.substring(15));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number value for max upper tilt (" + token.substring(15) + ").  Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("LOWERTILTLIMIT=")) {
                    try {
                        maxLowerTilt = Double.valueOf(token.substring(15));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number value for max lower tilt (" + token.substring(15) + ").  Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("PERSISTENCEFLAG=")) {
                    try {
                        value = tokenUC.substring(16);
                        if ("0".equals(value)) {
                            persistenceMode = false;
                            continue;
                        }
                        if (!"1".equals(value)) continue;
                        persistenceMode = true;
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number value for persistence mode (" + token.substring(16) + ").  Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("timeout=".toUpperCase())) {
                    try {
                        String timeoutString = token.substring(8);
                        timeout = Double.parseDouble(timeoutString);
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number for timeout value(" + token + ").  Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("magnetPSFlag=".toUpperCase())) {
                    try {
                        String magnetPSFlagString = token.substring("magnetPSFlag=".length());
                        persistenceFlag = Boolean.parseBoolean(magnetPSFlagString);
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number for timeout value(" + token + ").  Ignoring.");
                    }
                    continue;
                }
                if (tokenUC.startsWith("BROKENSTATE=")) {
                    try {
                        String commaDelimitedValues = tokenUC.substring(12);
                        String[] states = commaDelimitedValues.split(",");
                        int newState = Integer.valueOf(states[0]);
                        int oldState = Integer.valueOf(states[1]);
                        brokenState = newState == 1;
                        oldBrokenState = oldState == 1;
                    }
                    catch (Exception all) {
                        logger.error("Invalid parsing for broken state mode (" + token.substring(12) + ").  Ignoring.");
                    }
                    continue;
                }
                String[] pair = tokenUC.split("=");
                if (pair.length != 2) continue;
                extras.put(pair[0], pair[1]);
            }
            events.add(new DeviceChangeEvent(this, deviceName, type, units, lowerLimit, upperLimit, busy, fixed, softwareValue, hardwareValue, parent, tolerance, channel, environmentType, sampleChannel, controlChannel, maxUpperTilt, maxLowerTilt, persistenceFlag, persistenceMode, numSensors, timeout, brokenState, oldBrokenState, extras));
        }
        if (events.size() > 0) {
            DeviceEvent deviceEvent = new DeviceEvent(this, events, DeviceEvent.Type.ADD);
            this.deviceChangeListeners.notifyListeners(deviceEvent);
        }
    }

    public void addDeviceChangeListener(DeviceChangeListener dcl) throws ICEListenerListExceptionBase {
        this.deviceChangeListeners.addListener(dcl);
    }

    public void removeDeviceChangeListener(DeviceChangeListener dcl) {
        this.deviceChangeListeners.removeListener(dcl);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    private void newResourceFileContentsResponse(String message) {
        logger.debug("new contents response: " + message);
        String data = message;
        try {
            StringTokenizer tokenizer = new StringTokenizer(data, " ");
            tokenizer.nextToken();
            String filename = tokenizer.nextToken();
            if (filename.startsWith("\"")) {
                while (!filename.endsWith("\"")) {
                    filename = String.valueOf(filename) + tokenizer.nextToken();
                }
            }
            String[] parsedFileName = null;
            String parentName = "";
            parsedFileName = filename.split(":");
            if (parsedFileName.length > 1) {
                parentName = parsedFileName[0];
                filename = parsedFileName[1];
            }
            String contents = "";
            while (tokenizer.hasMoreTokens()) {
                contents = String.valueOf(contents) + " " + tokenizer.nextToken();
            }
            if (!contents.equals("")) {
                contents = contents.substring(1);
            }
            IceFileContentsChangeEvent ifcc = new IceFileContentsChangeEvent(this, filename, parentName, contents);
            this.contentChangeListeners.notifyListeners(ifcc);
        }
        catch (NoSuchElementException nsee) {
            logger.error("Invalid transfer format (" + message + ").  Aborting.", nsee);
        }
        catch (Exception e) {
            logger.error(e);
            e.printStackTrace();
        }
    }

    public void addIceFileContentsChangeListener(IceFileContentsChangeListener ifccl) throws ICEListenerListExceptionBase {
        this.contentChangeListeners.addListener(ifccl);
    }

    public void removeIceFileContentsChangeListener(IceFileContentsChangeListener ifccl) {
        this.contentChangeListeners.removeListener(ifccl);
    }

    public void addFitResultListener(FitResultListener frl) throws ICEListenerListExceptionBase {
        this.fitResultListeners.addListener(frl);
    }

    public void removeFitResultListener(FitResultListener frl) {
        this.fitResultListeners.removeListener(frl);
    }

    protected void newDeviceListMsg(String data) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(data.getBytes()));
            Node parentNode = doc.getFirstChild();
            NamedNodeMap parentAttributes = parentNode.getAttributes();
            String deviceClass = parentAttributes.getNamedItem("Class").getNodeValue();
            if ("temperature".equals(deviceClass)) {
                List<AvailableTempDevice> list = AvailableTempDevice.parseXmlList(parentNode);
                AvailableDeviceEvent availableDeviceEvent = new AvailableDeviceEvent(this, list, AvailableDeviceEvent.Type.TEMP);
                this.availableDeviceListListeners.notifyListeners(availableDeviceEvent);
            } else if ("magnet".equals(deviceClass)) {
                List<AvailableMagnetDevice> list = AvailableMagnetDevice.parseXmlList(parentNode);
                AvailableDeviceEvent availableDeviceEvent = new AvailableDeviceEvent(this, list, AvailableDeviceEvent.Type.MAGNET);
                this.availableDeviceListListeners.notifyListeners(availableDeviceEvent);
            } else if ("pressure".equals(deviceClass)) {
                List<AvailablePressureDevice> list = AvailablePressureDevice.parseXmlList(parentNode);
                AvailableDeviceEvent availableDeviceEvent = new AvailableDeviceEvent(this, list, AvailableDeviceEvent.Type.PRESSURE);
                this.availableDeviceListListeners.notifyListeners(availableDeviceEvent);
            } else if ("other".equals(deviceClass)) {
                List<AvailableMiscDevice> list = AvailableMiscDevice.parseXmlList(parentNode);
                AvailableDeviceEvent availableDeviceEvent = new AvailableDeviceEvent(this, list, AvailableDeviceEvent.Type.OTHER);
                this.availableDeviceListListeners.notifyListeners(availableDeviceEvent);
            } else if ("electromagnet".equals(deviceClass)) {
                List<AvailableElectromagnetDevice> emDeviceList = AvailableElectromagnetDevice.parseXmlList(parentNode);
                this.availableDeviceListListeners.notifyListeners(new AvailableDeviceEvent(this, emDeviceList, AvailableDeviceEvent.Type.ELECTROMAGNET));
            }
        }
        catch (ParserConfigurationException pce) {
            logger.error("Error reading XML data.  This shouldn't happen.  Forced to ignore message: " + data, pce);
        }
        catch (SAXException saxe) {
            logger.error("Error reading XML data.  This shouldn't happen.  Forced to ignore message: " + data, saxe);
        }
        catch (IOException ioe) {
            logger.error("Error reading XML data.  This shouldn't happen.  Forced to ignore message: " + data, ioe);
        }
    }

    public void addAvailableDeviceListListener(AvailableDeviceListListener adll) throws ICEListenerListExceptionBase {
        this.availableDeviceListListeners.addListener(adll);
    }

    public void removeAvailableDeviceListListener(AvailableDeviceListListener adll) {
        this.availableDeviceListListeners.removeListener(adll);
    }

    public void addUBMatrixAskCommandListener(UBMatrixAskCommandListener listener) throws ICEListenerListExceptionBase {
        this.ubMatrixAskCommandListener.addListener(listener);
    }

    public void addUBCalcDestinationResponseListener(UBCalcDestinationResponseListener listener) throws ICEListenerListExceptionBase {
        this.ubCalcDestinationResponseListeners.addListener(listener);
    }

    public void removeUBCalcDestinationResponseListener(UBCalcDestinationResponseListener listener) {
        this.ubCalcDestinationResponseListeners.removeListener(listener);
    }

    private void sendConnectionEvent(ConnectionEvent ce) {
        for (ConnectionListener cl : this.connectionListeners) {
            cl.receiveConnectionEvent(ce);
        }
    }

    public void addConnectionListener(ConnectionListener cl) {
        this.connectionListeners.add(cl);
    }

    public void addDataMessageListener(DataMessageListener dl) throws ICEListenerListExceptionBase {
        this.dataMessageListeners.addListener(dl);
    }

    public boolean removeDataMessageListener(DataMessageListener dl) throws ICEListenerListExceptionBase {
        return this.dataMessageListeners.removeListener(dl);
    }

    public synchronized void addResponseMessageListener(ResponseMessageListener rml, String label) throws ICEListenerListExceptionBase {
        if (this.responseMessageListenerMap.containsKey(label)) {
            this.responseMessageListenerMap.get(label).addListener(rml);
        } else {
            ICEListenerList newListenerList = new ICEListenerList();
            newListenerList.addListener(rml);
            this.responseMessageListenerMap.put(label, newListenerList);
        }
    }

    public synchronized void addResponseMessageListener(ResponseMessageListener rml) throws ICEListenerListExceptionBase {
        this.addResponseMessageListener(rml, null);
    }

    public synchronized boolean removeResponseMessageListener(ResponseMessageListener rml) {
        boolean found = false;
        for (String k : this.responseMessageListenerMap.keySet()) {
            found |= this.responseMessageListenerMap.get(k).removeListener(rml);
        }
        return found;
    }

    public synchronized boolean removeResponseMessageListener(ResponseMessageListener rml, String label) {
        if (this.responseMessageListenerMap.containsKey(label)) {
            this.responseMessageListenerMap.get(label).removeListener(rml);
            if (this.responseMessageListenerMap.get(label).isEmpty()) {
                this.responseMessageListenerMap.remove(label);
            }
            return true;
        }
        return false;
    }

    private class Connector
    implements Runnable {
        private boolean reconnecting = false;

        private Connector() {
        }

        public void setReconnecting(boolean reconnecting) {
            this.reconnecting = reconnecting;
        }

        @Override
        public void run() {
            try {
                ConnectionEvent.ConnectionState failureState = ConnectionEvent.ConnectionState.INITIAL_CONNECTION_FAILURE;
                ConnectionEvent.ConnectionState successState = ConnectionEvent.ConnectionState.INITIAL_CONNECTION_SUCCESS;
                if (this.reconnecting) {
                    failureState = ConnectionEvent.ConnectionState.RECONNECTION_FAILURE;
                    successState = ConnectionEvent.ConnectionState.RECONNECTION_SUCCESS;
                }
                if (CommunicationManager.this.username.length() == 0) {
                    logger.fatal("No username provided.");
                    CommunicationManager.this.sendConnectionEvent(new ConnectionEvent(CommunicationManager.this, failureState, "No username provided."));
                    return;
                }
                if (CommunicationManager.this.display.length() == 0) {
                    logger.fatal("No display provided.");
                    CommunicationManager.this.sendConnectionEvent(new ConnectionEvent(CommunicationManager.this, failureState, "No display provided."));
                    return;
                }
                try {
                    CommunicationManager.this.dispatcher.connect(CommunicationManager.this.address, 300);
                    CommunicationManager.this.dispatcher.always();
                    String hostID = CommunicationManager.this.dispatcher.my_id();
                    String subscriptionMessage = "a " + hostID + " a STATUS a MESSAGE a DATA a ERROR a EXC";
                    CommunicationManager.this.dispatcher.subscribe(subscriptionMessage);
                    CommunicationManager.this.dispatcher.register();
                    logger.debug("System Connected?  " + CommunicationManager.this.dispatcher.connected());
                    if (!CommunicationManager.this.dispatcher.connected()) {
                        logger.error("Unable to connect to server.");
                        CommunicationManager.this.sendConnectionEvent(new ConnectionEvent(CommunicationManager.this, failureState, "Unable to connect to server."));
                    }
                    logger.debug("Getting first message.");
                    DispatcherConnection.ServerMessage serverMessage = CommunicationManager.this.dispatcher.getMessage();
                    String tag = serverMessage.getTag();
                    logger.debug("tag: " + tag);
                    byte[] data = serverMessage.getMessageBuffer();
                    String data2 = new String(data, "utf-8");
                    logger.debug("data: " + data2);
                }
                catch (IOException ioe) {
                    logger.error(ioe);
                    CommunicationManager.this.sendConnectionEvent(new ConnectionEvent(CommunicationManager.this, failureState, ioe.getMessage()));
                    return;
                }
                CommunicationManager.this.connected = true;
                CommunicationManager.this.sendConnectionEvent(new ConnectionEvent(CommunicationManager.this, successState, "Connected to server."));
                logger.debug("connector ending");
            }
            catch (RuntimeException re) {
                System.out.println(re);
            }
        }
    }
}

