/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class DeviceReadCommand
extends ImmediateCommand {
    private static final String command = "DEVICE READ ";
    private String deviceName = null;

    public DeviceReadCommand() throws NoClientAPIInstanceException {
    }

    public DeviceReadCommand(String deviceName) throws NoClientAPIInstanceException {
        super(command + deviceName);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public DeviceReadCommand(String deviceName, ClientAPI clientApiRef) {
        super(command + deviceName, clientApiRef);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(command + this.deviceName);
        return command + this.deviceName;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        try {
            double motorPosition = Double.parseDouble(this.getResponse());
            this.setSuccess(true);
            this.setError(false);
        }
        catch (NumberFormatException notDouble) {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public String getImmediateCommandString() {
        return command + this.deviceName;
    }
}

