/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.QueuedCommand;

public class DeviceFreeCommand
extends QueuedCommand {
    private static final String command = "DEVICE FREE ";
    private String deviceName = null;

    public DeviceFreeCommand() throws NoClientAPIInstanceException {
    }

    public DeviceFreeCommand(String deviceName) throws NoClientAPIInstanceException {
        super(command + deviceName);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public DeviceFreeCommand(String deviceName, ClientAPI clientApiRef) {
        super(command + deviceName, clientApiRef);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(command + this.deviceName);
        return command + this.deviceName;
    }

    @Override
    protected synchronized void parseAsynchronousResponse() {
        String response = this.getResponse();
        if (response.contains(command)) {
            this.setSuccess(true);
            this.setError(false);
        } else {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }
}

