/*
 * Decompiled with CFR 0.152.
 */
package ice.clientAPI.sampleEnvTests;

import ice.ClientAPI;
import ice.clientAPI.exceptions.InconsistentClientApiInstanceException;
import ice.commands.Command;
import ice.commands.DeviceAddCommand;
import ice.commands.DeviceDestroyCommand;
import ice.commands.DeviceGetPropertyCommand;
import ice.commands.DeviceReadCommand;
import ice.commands.DeviceSetPropertyCommand;
import ice.commands.MoveCommand;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;

public class TemperatureTest {
    public static String runCommand(Command command) throws TemperatureTestException, ICEListenerListExceptionBase {
        command.run();
        System.out.println(command.getResponse());
        if (command.isError() || !command.isSuccess()) {
            throw new TemperatureTestException("command: \"" + command.getCommandString() + "\" failed");
        }
        return command.getResponse();
    }

    public static void main(String[] args) throws TemperatureTestException {
        Boolean dummyFlag = null;
        String address = args[0];
        String deviceName = args[1];
        if (args.length > 2) {
            dummyFlag = args[2].compareToIgnoreCase("1") == 0 || args[2].compareToIgnoreCase("true") == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        try {
            try {
                double readSetPoint;
                ClientAPI adaptor = ClientAPI.getInstance("testUser", address);
                try {
                    adaptor.waitForConnection();
                }
                catch (InterruptedException e1) {
                    throw new TemperatureTestException("Could not connect to server");
                }
                DeviceAddCommand addCmd = new DeviceAddCommand(deviceName, DeviceAddCommand.DeviceType.ENV, dummyFlag);
                DeviceSetPropertyCommand setControlChannelB = new DeviceSetPropertyCommand(deviceName, "controlSensorIndex", "1");
                DeviceSetPropertyCommand setSampleChannelB = new DeviceSetPropertyCommand(deviceName, "sampleSensorIndex", "1");
                DeviceDestroyCommand destroyCommand = new DeviceDestroyCommand(deviceName);
                destroyCommand.run();
                TemperatureTest.runCommand(addCmd);
                TemperatureTest.runCommand(setControlChannelB);
                TemperatureTest.runCommand(setSampleChannelB);
                String temperatureString = TemperatureTest.runCommand(new DeviceReadCommand(deviceName));
                double originalTemperature = Double.valueOf(temperatureString);
                double setPoint = originalTemperature + 5.0;
                TemperatureTest.runCommand(new DeviceGetPropertyCommand(deviceName, "setpoint"));
                TemperatureTest.runCommand(new DeviceSetPropertyCommand(deviceName, "PosSoftLimit", Double.toString(originalTemperature + 1.0)));
                MoveCommand moveCommand = new MoveCommand(deviceName, setPoint);
                moveCommand.run();
                System.out.println(moveCommand.getResponse());
                if (!moveCommand.hitSoftLimit()) {
                    throw new TemperatureTestException("Temperature device did not hit soft limit.");
                }
                TemperatureTest.runCommand(new DeviceSetPropertyCommand(deviceName, "PosSoftLimit", Double.toString(originalTemperature + 6.0)));
                TemperatureTest.runCommand(new DeviceSetPropertyCommand(deviceName, "tolerance", "1.0"));
                TemperatureTest.runCommand(new DeviceSetPropertyCommand(deviceName, "toleranceDT", "5"));
                TemperatureTest.runCommand(new DeviceSetPropertyCommand(deviceName, "timeout", "60"));
                moveCommand = new MoveCommand(deviceName, setPoint);
                moveCommand.run();
                System.out.println(moveCommand.getResponse());
                String setPointString = TemperatureTest.runCommand(new DeviceGetPropertyCommand(deviceName, "setpoint"));
                try {
                    readSetPoint = Double.valueOf(setPointString);
                }
                catch (NumberFormatException e) {
                    throw new TemperatureTestException("Read a setpoint from temperature controller which could not be converted to a double: " + setPointString);
                }
                if (readSetPoint != setPoint) {
                    throw new TemperatureTestException("The setpoint read from the temperature controller (" + Double.toString(readSetPoint) + ") is not the same as the setpoint sent to the controller (" + Double.toString(setPoint) + ")");
                }
                temperatureString = TemperatureTest.runCommand(new DeviceReadCommand(deviceName));
                double newTemperature = Double.valueOf(temperatureString);
                if (newTemperature <= originalTemperature + 3.0) {
                    throw new TemperatureTestException("The new temperature (" + Double.toString(newTemperature) + ") is not greater than the old temperature + 3.0 (" + Double.toString(originalTemperature + 3.0) + ")");
                }
                TemperatureTest.runCommand(new DeviceDestroyCommand(deviceName));
            }
            catch (InconsistentClientApiInstanceException ICAPIe) {
                System.out.println("Error getting a client api instance.");
                ClientAPI.close();
            }
            catch (ICEListenerListExceptionBase e) {
                e.printStackTrace();
                ClientAPI.close();
            }
        }
        finally {
            ClientAPI.close();
        }
    }

    private static class TemperatureTestException
    extends Exception {
        TemperatureTestException(String description) {
            super(description);
        }
    }
}

