/*
 * Decompiled with CFR 0.152.
 */
package ice.clientAPI;

import ice.clientAPI.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Vector;

public class MessageQueue<e>
implements Queue<e> {
    private static final int DEFAULTMAXSIZE = 50;
    private int capacity = 50;
    private final List<Message<e>> msgQ = new Vector<Message<e>>(this.capacity);
    private Map<Long, List<Message<e>>> commandIdMessageMap = new HashMap<Long, List<Message<e>>>();

    public MessageQueue() {
    }

    public MessageQueue(int size) {
        this.setCapacity(size);
    }

    public MessageQueue(List<Message<e>> messages) {
        if (messages != null) {
            this.msgQ.addAll(messages);
        }
        for (Message<e> m : this.msgQ) {
            if (this.commandIdMessageMap.containsKey(m.getCommandId())) {
                this.commandIdMessageMap.get(m.getCommandId()).add(m);
                continue;
            }
            Vector<Message<e>> newVec = new Vector<Message<e>>();
            newVec.add(m);
            this.commandIdMessageMap.put(m.getCommandId(), newVec);
        }
    }

    public int setCapacity(int newCapacity) {
        this.capacity = newCapacity;
        int removedElements = 0;
        int i = this.msgQ.size();
        while (i > this.capacity) {
            this.msgQ.remove(0);
            ++removedElements;
            --i;
        }
        return removedElements;
    }

    @Override
    public int size() {
        return this.msgQ.size();
    }

    public int remainingCapacity() {
        return this.capacity - this.msgQ.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public e poll() {
        Message<e> removeVal = this.msgQ.remove(0);
        this.commandIdMessageMap.get(removeVal.getCommandId()).remove(removeVal);
        return removeVal.getMessageContent();
    }

    @Override
    public boolean add(e newMessageContent) {
        Message<e> newMessage = new Message<e>(newMessageContent);
        if (this.msgQ.add(newMessage)) {
            if (this.commandIdMessageMap.containsKey(newMessage.getCommandId())) {
                this.commandIdMessageMap.get(newMessage.getCommandId()).add(newMessage);
            } else {
                Vector<Message<e>> newVec = new Vector<Message<e>>();
                newVec.add(newMessage);
                this.commandIdMessageMap.put(newMessage.getCommandId(), newVec);
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.msgQ.clear();
        this.commandIdMessageMap.clear();
    }

    public Iterator<Message<e>> messageIterator() {
        return this.msgQ.iterator();
    }

    public String getContentsAsString() {
        String contents = "";
        for (Message<e> msg : this.msgQ) {
            contents = String.valueOf(contents) + "commandID " + String.valueOf(msg.getCommandId()) + ": " + msg.getMessageString() + "\n";
        }
        return contents;
    }

    public MessageQueue<e> getMessagesForCommandId(long commandId) {
        MessageQueue<e> returnQ = new MessageQueue<e>(this.commandIdMessageMap.get(commandId));
        return returnQ;
    }

    public MessageQueue<e> getMessagesForAbsCommandId(long commandId) {
        MessageQueue<e> returnQ = new MessageQueue<e>(this.commandIdMessageMap.get(commandId));
        MessageQueue<e> negMessages = new MessageQueue<e>(this.commandIdMessageMap.get(commandId * -1L));
        returnQ.addAll((Collection<e>)negMessages.messageContentList());
        return returnQ;
    }

    @Override
    public e element() {
        if (this.msgQ.size() > 0) {
            return this.msgQ.get(0).getMessageContent();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean offer(e o) {
        if (this.capacity > this.msgQ.size()) {
            this.add(o);
            return true;
        }
        return false;
    }

    @Override
    public e peek() {
        if (!this.msgQ.isEmpty()) {
            return this.msgQ.get(0).getMessageContent();
        }
        return null;
    }

    @Override
    public e remove() {
        if (this.msgQ.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.poll();
    }

    @Override
    public boolean addAll(Collection<? extends e> c) {
        for (e item : c) {
            if (this.add(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (Message<e> m : this.msgQ) {
            if (m != o) continue;
            return true;
        }
        return false;
    }

    public List<e> messageContentList() {
        ArrayList<e> l = new ArrayList<e>(this.msgQ.size());
        for (Message<e> m : this.msgQ) {
            l.add(m.getMessageContent());
        }
        return l;
    }

    public Message<e> getContainingMessage(Object o) {
        for (Message<e> m : this.msgQ) {
            if (m.getMessageContent() != o) continue;
            return m;
        }
        return null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.messageContentList().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.msgQ.isEmpty();
    }

    @Override
    public Iterator<e> iterator() {
        return this.messageContentList().iterator();
    }

    @Override
    public synchronized boolean remove(Object o) {
        for (Message<e> m : this.msgQ) {
            if (m.getMessageContent() != o) continue;
            this.commandIdMessageMap.get(m.getCommandId()).remove(o);
            this.msgQ.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        for (Object item : c) {
            if (this.remove(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        ArrayList<Message<e>> removeList = new ArrayList<Message<e>>(this.msgQ.size());
        for (Message<e> m : this.msgQ) {
            if (c.contains(m.getMessageContent())) continue;
            this.commandIdMessageMap.get(m.getCommandId()).remove(m.getMessageContent());
            removeList.add(m);
        }
        this.msgQ.removeAll(removeList);
        return !removeList.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.messageContentList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.messageContentList().toArray(a);
    }

    public synchronized List<e> getUpdatesSince(Date referenceTime) {
        ArrayList<e> returnList = new ArrayList<e>();
        for (Message<e> m : this.msgQ) {
            if (!m.getTimestamp().after(referenceTime)) continue;
            returnList.add(m.getMessageContent());
            m.setLastAccess();
        }
        return returnList;
    }

    public synchronized List<e> getUpdatesSince(Date referenceTime, long commandId) {
        ArrayList<e> returnList = new ArrayList<e>();
        for (Message<e> m : this.commandIdMessageMap.get(commandId)) {
            if (!m.getTimestamp().after(referenceTime)) continue;
            returnList.add(m.getMessageContent());
            m.setLastAccess();
        }
        return returnList;
    }

    public String toString() {
        String stringValue = "";
        for (Message<e> m : this.msgQ) {
            stringValue = String.valueOf(stringValue) + m.getMessageString().toString() + "\n";
        }
        return stringValue;
    }
}

