/*
 * Decompiled with CFR 0.152.
 */
package ice;

import ice.Controller;
import ice.Global;
import ice.IceClientNotifier;
import ice.IceGuiManager;
import ice.data.IceFileType;
import ice.data.tas.bt7.Instrument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class JavaClassLoader {
    private static JavaClassLoader reference = null;
    private static Logger logger = Logger.getLogger("ErrorLogger");
    private HashMap<String, Class<?>> loadedClasses = new HashMap();
    private static final String path = Global.getConfigPath();
    private static final String separator = Global.separator;
    private static final String pluginJavaDir = "Plugins" + separator + "Java";
    private static final String pluginPythonDir = "Plugins" + separator + "Python";
    private static final String panelJavaDir = "ice.gui.panel";
    private static final String dotSeparator = ".";
    private static final String classExtention = ".class";
    private static final String jarExtention = ".jar";
    private static final String fileNameEnding = "Pane";
    private static final String dollarSign = "$";
    private static final String staticFunction = "getSupportedFileTypes";
    private ArrayList<String> list;
    private Controller controller = Controller.getReference();
    private JavaClassFilter javaFilter = new JavaClassFilter();
    private char separatorChar;
    private HashMap<IceFileType, String> IcePanelFileTypeMap;
    private IceClientNotifier errorManager = IceClientNotifier.getReference();

    public static JavaClassLoader getReference() {
        if (reference == null) {
            reference = new JavaClassLoader();
        }
        return reference;
    }

    private JavaClassLoader() {
        this.IcePanelFileTypeMap = new HashMap();
        this.separatorChar = separator.charAt(0);
    }

    public HashMap<String, Class<?>> loadJavaClasses() {
        this.getIceClientJavaClasses();
        this.getExternalJavaClasses();
        return this.loadedClasses;
    }

    public HashMap<String, Class<?>> getLoadedJavaClasses() {
        return this.loadedClasses;
    }

    public HashMap<IceFileType, String> getSaveableIcePanelFileTypes() {
        return this.IcePanelFileTypeMap;
    }

    private void loadExternalJavaClasses(String classPath) {
        File file = new File(classPath);
        boolean dirExists = false;
        dirExists = file.mkdirs();
        String[] children = file.list(this.javaFilter);
        File[] files = file.listFiles();
        try {
            URL url = file.toURI().toURL();
            URL[] urls = new URL[]{url};
            URLClassLoader classLoader = new URLClassLoader(urls);
            if (children == null) {
                logger.error("No classes in the directory: " + classPath);
                return;
            }
            int i = 0;
            while (i < children.length) {
                String className = children[i];
                int index = className.indexOf(classExtention);
                className = className.substring(0, index);
                String newName = this.getParsedClassName(className);
                Class<?> javaClass = classLoader.loadClass(className);
                Class<?> oldClass = this.loadedClasses.get(newName);
                this.loadedClasses.put(newName, javaClass);
                ++i;
            }
        }
        catch (Exception e) {
            logger.error("Cannot load external classes", e.getCause());
        }
    }

    private void loadLocalJavaClasses(String packageName) {
        block11: {
            URL url;
            String packagePath = packageName.replace('.', '/');
            packagePath = packageName.replaceAll("\\.", "/");
            if (packagePath.charAt(0) != '/') {
                packagePath = String.valueOf('/') + packagePath;
            }
            if ((url = IceGuiManager.class.getResource(packagePath)) == null) {
                logger.error("URL is null, can't load classes");
                return;
            }
            try {
                File directory = new File(url.toURI());
                if (!directory.exists()) break block11;
                String[] files = directory.list(this.javaFilter);
                int i = 0;
                while (i < files.length) {
                    String className = files[i];
                    if (!className.contains(dollarSign)) {
                        int index = className.indexOf(classExtention);
                        className = className.substring(0, index);
                        String newName = this.getParsedClassName(className);
                        try {
                            IceFileType[] types;
                            Class<?> javaClass = Class.forName(String.valueOf(packageName) + dotSeparator + className);
                            this.loadedClasses.put(newName, javaClass);
                            Method staticMethod = javaClass.getMethod(staticFunction, new Class[0]);
                            IceFileType[] iceFileTypeArray = types = (IceFileType[])staticMethod.invoke(null, new Object[0]);
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IceFileType type = iceFileTypeArray[n2];
                                if (type != null && type != IceFileType.unknown) {
                                    this.IcePanelFileTypeMap.put(type, newName);
                                }
                                ++n2;
                            }
                        }
                        catch (NoSuchMethodException nsme) {
                            logger.error(nsme);
                        }
                        catch (Exception e) {
                            logger.error(e);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error("Cannot load local java classes", e.getCause());
            }
        }
    }

    private void loadLocalJavaClassesFromJar(String packageName, String jarName) {
        String packagePath = packageName.replace('.', '/');
        packagePath = packageName.replaceAll("\\.", "/");
        jarName = jarName.replace("%20", " ");
        try {
            JarEntry jarEntry;
            JarInputStream jarFile = new JarInputStream(new FileInputStream(jarName));
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                String className = jarEntry.getName();
                int lastIndex = className.lastIndexOf(47);
                String classPath = className;
                if (lastIndex != -1) {
                    classPath = className.substring(0, lastIndex);
                }
                if (!classPath.equals(packagePath) || !className.endsWith(classExtention) || className.contains(dollarSign)) continue;
                int index = className.indexOf(classExtention);
                className = className.substring(0, index);
                String newName = this.getParsedClassNameFromJar(className);
                className = className.replace('/', '.');
                try {
                    IceFileType[] types;
                    Class<?> javaClass = Class.forName(className);
                    this.loadedClasses.put(newName, javaClass);
                    Method staticMethod = javaClass.getMethod(staticFunction, new Class[0]);
                    IceFileType[] iceFileTypeArray = types = (IceFileType[])staticMethod.invoke(null, new Object[0]);
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IceFileType type = iceFileTypeArray[n2];
                        if (type != null && type != IceFileType.unknown) {
                            this.IcePanelFileTypeMap.put(type, newName);
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    logger.error(e);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private void getExternalJavaClasses() {
        String jarName = this.getJarFileName();
        Controller controller = null;
        Instrument instrument = null;
        String instrumentPath = null;
        String[] pathParts = null;
        String filePath = String.valueOf(path) + pluginJavaDir;
        int counter = 0;
        int pathPartsLength = -1;
        controller = Controller.getReference();
        instrument = controller.getInstrument();
        instrumentPath = instrument.getPath();
        instrumentPath = instrumentPath.toLowerCase();
        pathParts = instrumentPath.split("\\.");
        pathPartsLength = pathParts.length - 1;
        while (true) {
            this.loadExternalJavaClasses(filePath);
            if (counter > pathPartsLength) break;
            filePath = String.valueOf(filePath) + separator + pathParts[counter];
            ++counter;
        }
    }

    private void getIceClientJavaClasses() {
        String jarName = this.getJarFileName();
        Controller controller = null;
        Instrument instrument = null;
        String instrumentPath = null;
        String[] pathParts = null;
        String filePath = panelJavaDir;
        int counter = 0;
        int pathPartsLength = -1;
        controller = Controller.getReference();
        instrument = controller.getInstrument();
        instrumentPath = instrument.getPath();
        instrumentPath = instrumentPath.toLowerCase();
        pathParts = instrumentPath.split("\\.");
        pathPartsLength = pathParts.length - 1;
        if (jarName.endsWith(jarExtention)) {
            while (true) {
                this.loadLocalJavaClassesFromJar(filePath, jarName);
                if (counter <= pathPartsLength) {
                    filePath = String.valueOf(filePath) + dotSeparator + pathParts[counter];
                    ++counter;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                this.loadLocalJavaClasses(filePath);
                if (counter > pathPartsLength) break;
                filePath = String.valueOf(filePath) + dotSeparator + pathParts[counter];
                ++counter;
            }
        }
    }

    private String getJarFileName() {
        URL outputURL = IceGuiManager.class.getProtectionDomain().getCodeSource().getLocation();
        String outputString = "";
        String jarFilename = "";
        try {
            outputString = outputURL.toURI().toASCIIString();
            int index1 = outputString.indexOf(":");
            int index2 = outputString.lastIndexOf(":");
            String[] parseString = index1 != index2 ? outputString.split("file:/") : outputString.split("file:");
            jarFilename = parseString[1];
        }
        catch (URISyntaxException e) {
            logger.error("Error in getting jar name:", e.getCause());
        }
        return jarFilename;
    }

    public String getParsedClassName(String className) {
        int index = className.indexOf(fileNameEnding);
        if (index == -1) {
            return className;
        }
        String tempName = className.substring(0, index);
        Pattern pattern = Pattern.compile("([A-Z]+)");
        Matcher matcher = pattern.matcher(tempName);
        String newName = tempName;
        while (matcher.find()) {
            String upperCaseLetters = matcher.group(1);
            newName = newName.replace(upperCaseLetters, " " + upperCaseLetters);
        }
        newName = newName.trim();
        return newName;
    }

    public String getParsedClassNameFromJar(String className) {
        int index = className.lastIndexOf(47);
        String tempName = className;
        if (index != -1) {
            tempName = className.substring(index + 1);
        }
        if ((index = tempName.indexOf(fileNameEnding)) == -1) {
            return tempName;
        }
        tempName = tempName.substring(0, index);
        Pattern pattern = Pattern.compile("([A-Z]+)");
        Matcher matcher = pattern.matcher(tempName);
        String newName = tempName;
        while (matcher.find()) {
            String upperCaseLetters = matcher.group(1);
            newName = newName.replace(upperCaseLetters, " " + upperCaseLetters);
        }
        newName = newName.trim();
        return newName;
    }

    private class JavaClassFilter
    implements FilenameFilter {
        private JavaClassFilter() {
        }

        @Override
        public boolean accept(File directory, String filename) {
            return filename.endsWith(JavaClassLoader.classExtention);
        }
    }
}

