/*
 * Decompiled with CFR 0.152.
 */
package ice;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import ice.BackUpLogs;
import ice.Controller;
import ice.Global;
import ice.IceClientNotifier;
import ice.IcePanelManager;
import ice.data.Server;
import ice.event.FatalErrorEvent;
import ice.event.FatalErrorListener;
import ice.event.InitializationEvent;
import ice.event.InitializationEventListener;
import ice.event.InstrumentSelectionEvent;
import ice.event.InstrumentSelectionListener;
import ice.event.StartUpEvent;
import ice.event.communication.ConnectionEvent;
import ice.event.communication.ConnectionListener;
import ice.gui.core.IceWindow;
import ice.gui.core.InstrumentSelectionWindow;
import ice.gui.core.controlPanel.ControlPanel;
import ice.gui.core.startup.StartUpWindow;
import ice.swing.RememberDecisionDialog;
import ice.util.ConversionUtilities;
import ice.util.FileManager;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import ice.util.PreferencesManager;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Logger;

public class IceGuiManager
implements InstrumentSelectionListener,
InitializationEventListener,
FatalErrorListener,
ConnectionListener {
    public static final String CLOSING_WINDOW_NOT_IN_LIST = "ice.Controller.closingWindowNotInList";
    public static final String ERROR_DIALOG_TITLE = "ice.Controller.errorDialogTitle";
    private Controller controller = null;
    private static Logger logger = Logger.getLogger("ControllerLogger");
    private static Logger errorLogger = Logger.getLogger("ErrorLogger");
    private static Server iceServer = null;
    private static InstrumentSelectionWindow instrSelectionWindow;
    public FileManager fileInterface = FileManager.getInstance();
    protected InstrumentSelectionWindow selectionWindow;
    private ControlPanel controlPanel;
    private IcePanelManager panelManager;

    public IceGuiManager() {
        this.setLookAndFeel();
    }

    public static InstrumentSelectionWindow getSelectionDialog() {
        return instrSelectionWindow;
    }

    public void init(Controller controller) {
        this.controller = controller;
        controller.addInitializationEventListener(this);
        controller.getCommMgr().addConnectionListener(this);
        controller.getCommMgr().connectToServer(iceServer);
        StartUpWindow startUp = StartUpWindow.getInstance();
        try {
            controller.addStartUpListener(startUp);
        }
        catch (ICEListenerListExceptionBase e) {
            e.printStackTrace();
        }
        startUp.setLocationTopMiddle();
        startUp.setVisible(true);
    }

    public void showConnectionDialog() {
        try {
            TreeMap<String, Server> serverMap = this.fileInterface.getServerList();
            instrSelectionWindow = new InstrumentSelectionWindow(serverMap);
            instrSelectionWindow.listenToOK(this);
            instrSelectionWindow.createAndShowGUI();
        }
        catch (IOException ioe) {
            logger.fatal("Unable to get server list:", ioe);
            String error = "Unable to read user settings.  Your program may be corrupt.  \nPlease try downing again.  If problem persists, contact technical support.";
            this.dialogError(error);
            return;
        }
    }

    private void setLookAndFeel() {
        try {
            String os2 = System.getProperty("os.name");
            if (os2.toUpperCase().contains("LINUX")) {
                UIManager.setLookAndFeel(new Plastic3DLookAndFeel());
            } else if (os2.toUpperCase().startsWith("WINDOWS")) {
                UIManager.setLookAndFeel((LookAndFeel)((Object)new WindowsLookAndFeel()));
            } else {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
                UIManager.put("Label.font", Global.labelFont);
            }
        }
        catch (UnsupportedLookAndFeelException ulafe) {
            logger.error("Failed applying look and feel.  This probably shouldn't happen.  Sticking with default metal look with a few adjustments.", ulafe);
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            UIManager.put("Label.font", Global.labelFont);
        }
        UIManager.put("TaskPaneGroup.background", UIManager.get("Panel.background"));
    }

    @Override
    public void handleInitializationEvent(InitializationEvent initEvent) {
        try {
            Global.init(this.controller.getInstrument().getName());
        }
        catch (IOException ioe) {
            logger.fatal("Unable to initialize configuration files!  Exiting.", ioe);
            this.fatalError(new FatalErrorEvent("Unable to  configuration settings.  Please contact technical support"));
            return;
        }
        this.controlPanel = new ControlPanel(this.controller.getInstrument(), this.controller.getSendManager(), this.controller.getDeviceList());
        try {
            this.controller.getInstrument().addPropertyChangeListener(this.controlPanel);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("IceGuiManager.handleInitializationEvent " + e);
        }
        this.controller.getDeviceListeners().add(this.controlPanel);
        int width = this.controlPanel.getSize().width;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = ge.getMaximumWindowBounds();
        this.controlPanel.setLocation(bounds.width / 2 - width / 2, 0);
        String message = "Loading panels from saved session...";
        StartUpEvent start = new StartUpEvent((Object)this, message);
        this.controller.notifyStartUpListeners(start);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IceGuiManager.getSelectionDialog().killWindow();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IceGuiManager.this.panelManager = IcePanelManager.getReference();
                IceGuiManager.this.panelManager.showGUI();
                IceGuiManager.this.controlPanel.setVisible(true);
            }
        });
    }

    @Override
    public synchronized void receiveConnectionEvent(ConnectionEvent ce) {
        ConnectionEvent.ConnectionState state = ce.getConnectionState();
        if (state == ConnectionEvent.ConnectionState.RECONNECTION_SUCCESS) {
            this.unlockPanels();
        } else if (state == ConnectionEvent.ConnectionState.INITIAL_CONNECTION_SUCCESS) {
            logger.debug("Connection to server successful.");
            IceGuiManager.getSelectionDialog().connectionSuccessful();
            StartUpEvent connected = new StartUpEvent((Object)this, "Connection successful...");
            this.controller.notifyStartUpListeners(connected);
            this.notifyAll();
        } else if (state == ConnectionEvent.ConnectionState.INITIAL_CONNECTION_FAILURE) {
            logger.debug("Connection to server failed: " + ce.getMessage());
            IceGuiManager.getSelectionDialog().connectionFailed();
            StartUpEvent failed = new StartUpEvent((Object)this, "Connection failed...");
            this.controller.notifyStartUpListeners(failed);
        } else if (state == ConnectionEvent.ConnectionState.LOST_CONNECTION) {
            this.lockPanels();
            String error = "ICE has lost connection with the server at " + ConversionUtilities.getCurrentTime();
            error = String.valueOf(error) + "\nPlease close the client and restart again.";
            System.out.println(error);
            IceClientNotifier errorManager = IceClientNotifier.getReference();
            errorManager.showIcePanelError(error);
            String preference = PreferencesManager.getPreferenceString("communication.allowReconnect");
            if (preference.equalsIgnoreCase("undefined")) {
                String body = "ICE has lost connection with the server.  Reconnect?";
                IceWindow ownerWindow = null;
                IcePanelManager panelManager = IcePanelManager.getReference();
                ownerWindow = panelManager.getFirstIceWindow();
                EnumSet<RememberDecisionDialog.Decision> decision = RememberDecisionDialog.showDialog(ownerWindow, "Lost Connection", body, RememberDecisionDialog.DialogType.YesNo);
                if (decision.contains((Object)RememberDecisionDialog.Decision.Remember)) {
                    try {
                        if (decision.contains((Object)RememberDecisionDialog.Decision.Yes)) {
                            PreferencesManager.setPreferenceString("communication.allowReconnect", "yes");
                        }
                        if (decision.contains((Object)RememberDecisionDialog.Decision.No)) {
                            PreferencesManager.setPreferenceString("communication.allowReconnect", "no");
                        }
                    }
                    catch (IOException ioe) {
                        logger.error("Unable to write preferences to disk.");
                    }
                }
                if (decision.contains((Object)RememberDecisionDialog.Decision.Yes)) {
                    preference = "yes";
                } else if (decision.contains((Object)RememberDecisionDialog.Decision.No)) {
                    preference = "no";
                }
            }
            if (preference.equalsIgnoreCase("yes")) {
                this.controller.getCommMgr().reconnect();
            }
        }
    }

    @Override
    public void fatalError(FatalErrorEvent fee) {
        this.dialogError(fee.getData());
        System.exit(1);
    }

    public void panelError(Exception e) {
        String message = IceGuiManager.getException(e);
        this.dialogError(message);
    }

    public static String getException(Exception e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        return w.toString();
    }

    public void dialogError(String message) {
        JOptionPane.showMessageDialog(null, message, "JICE - Error", 0);
    }

    protected void lockPanels() {
        if (this.panelManager != null) {
            this.panelManager.lockAllPanels(true);
        }
    }

    protected void unlockPanels() {
        if (this.panelManager != null) {
            this.panelManager.lockAllPanels(false);
        }
    }

    @Override
    public synchronized void instrumentSelected(InstrumentSelectionEvent ise) {
        logger.debug("Instrument selected: " + ise.getServer().getAddress());
        instrSelectionWindow.connecting();
        iceServer = ise.getServer();
        if (this.controller != null) {
            this.controller.getCommMgr().connectToServer(iceServer);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] s) {
        new BackUpLogs();
        String startingMessage = "Starting Ice Client...";
        System.out.println(startingMessage);
        Controller controller = null;
        IceGuiManager iceGuiObject = new IceGuiManager();
        iceGuiObject.showConnectionDialog();
        try {
            IceGuiManager iceGuiManager = iceGuiObject;
            synchronized (iceGuiManager) {
                iceGuiObject.wait();
            }
        }
        catch (InterruptedException ie) {
            iceGuiObject.dialogError("There was an error connecting to the server.  Please restart the Ice Client.");
            System.exit(1);
        }
        controller = Controller.getReference();
        iceGuiObject.init(controller);
    }
}

