/*
 * Decompiled with CFR 0.152.
 */
package ice;

import ice.IceGuiManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.log4j.Logger;

public class Global {
    public static final String separator = System.getProperty("file.separator");
    private static final Logger logger = Logger.getLogger("GlobalLogger");
    private static final String COPY_TO_USER_FOLDER = "CopyToUserFolder" + separator;
    private static final String COPY_TO_USER_FOLDER_DIR_NAME = "CopyToUserFolder";
    public static final String jarExtention = ".jar";
    public static final String APPNAME = "JICE";
    public static final String WINDOWNAME = "ICE Window";
    public static final Font labelFont = new Font("Arial", 0, 12);
    public static final int scanFieldLength = 6;
    public static final int peakToleranceFieldLength = 6;
    public static final int horizSpacing = 5;
    public static final int numColumnsHKLField = 5;
    private static final double EPSILON = 1.0E-6;
    public static final Color GREEN = new Color(0, 128, 0);
    public static final Color HIGHLIGHT = new Color(49, 106, 197);
    public static final int unitIncrement = 7;
    private static Integer panelNumber = 1;
    public static final String SCAN_EXTENSION = "scan.txt";
    public static final String SEQUENCE_EXTENSION = "seq.txt";
    public static final String PYTHON_SCRIPT_EXTENSION = "py";
    public static final String EXPT_MAGIC_WORD = "EXPT";
    public static final String USER_MAGIC_WORD = "USER";
    public static final String COMM_MAGIC_WORD = "COMM";
    private static final Clipboard clipboard = new Clipboard("main");
    private static String instrumentName = "noName";
    private static String instrumentPath = "noPath";

    public static String getJarFileName() {
        URL outputURL = IceGuiManager.class.getProtectionDomain().getCodeSource().getLocation();
        String outputString = "";
        String jarFilename = "";
        try {
            outputString = outputURL.toURI().toASCIIString();
            int index1 = outputString.indexOf(":");
            int index2 = outputString.lastIndexOf(":");
            String[] parseString = index1 != index2 ? outputString.split("file:/") : outputString.split("file:");
            jarFilename = parseString[1];
            jarFilename = jarFilename.replace("%20", " ");
            jarFilename = jarFilename.replace('/', separator.charAt(0));
        }
        catch (URISyntaxException e) {
            logger.error("Error in getting jar name:", e.getCause());
        }
        return jarFilename;
    }

    protected static void copyResourcesFromCopyToUserFolderToJICEFolder() {
        String jarFileName = Global.getJarFileName();
        if (jarFileName.endsWith(jarExtention)) {
            Global.copyResourcesToJICEFolderFromJar(jarFileName);
        } else {
            Global.copyConfigResourcesToJICEFolderFromFileSystem();
        }
    }

    protected static void copyResourcesToJICEFolderFromJar(String jarFileName) {
        try {
            JarInputStream jarFile = new JarInputStream(new FileInputStream(jarFileName));
            String jarEntryName = null;
            boolean beginsWith = false;
            while (true) {
                try {
                    JarEntry jarEntry;
                    while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                        jarEntryName = jarEntry.getName();
                        beginsWith = jarEntryName.startsWith(COPY_TO_USER_FOLDER_DIR_NAME);
                        if (!beginsWith) continue;
                        String usersConfigPath = Global.getConfigPath();
                        String filePath = "";
                        int lastIndex = -1;
                        usersConfigPath = usersConfigPath.substring(0, usersConfigPath.length() - 1);
                        filePath = String.valueOf(usersConfigPath) + jarEntryName.replaceFirst(COPY_TO_USER_FOLDER_DIR_NAME, "");
                        lastIndex = filePath.lastIndexOf(47);
                        filePath = filePath.replace('/', separator.charAt(0));
                        String path = filePath.substring(0, lastIndex);
                        File dirStructure = new File(path);
                        dirStructure.mkdirs();
                        try {
                            File theFile = new File(filePath);
                            boolean theFileExists = theFile.exists();
                            if (theFileExists) continue;
                            InputStream is = new Global().getClass().getResourceAsStream("/" + jarEntryName);
                            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                            BufferedWriter writer = new BufferedWriter(new FileWriter(theFile));
                            String line = reader.readLine();
                            while (line != null) {
                                writer.append(line);
                                writer.newLine();
                                line = reader.readLine();
                            }
                            writer.flush();
                        }
                        catch (IOException e) {
                            System.out.println(e);
                            Logger.getLogger("ErrorLogger").error(e);
                        }
                    }
                }
                catch (IOException e) {
                    System.out.println(e);
                    Logger.getLogger("ErrorLogger").error(e);
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            Logger.getLogger("ErrorLogger").error(e);
        }
        catch (IOException e) {
            Logger.getLogger("ErrorLogger").error(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void recursiveFileCopyToUsersJICEFolder(File file) {
        boolean isDirectory = file.isDirectory();
        String fileName = file.getName();
        if (fileName.startsWith(".")) return;
        String filePath = file.getPath();
        String usersConfigPath = Global.getConfigPath();
        String configPath = "";
        usersConfigPath = usersConfigPath.substring(0, usersConfigPath.length() - 1);
        configPath = String.valueOf(usersConfigPath) + filePath.replaceFirst(COPY_TO_USER_FOLDER_DIR_NAME, "");
        if (isDirectory) {
            File newDir = new File(configPath);
            newDir.mkdir();
            File[] fileList = file.listFiles();
            if (fileList == null) return;
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File aFile = fileArray[n2];
                Global.recursiveFileCopyToUsersJICEFolder(aFile);
                ++n2;
            }
            return;
        } else {
            try {
                File theFile = new File(configPath);
                boolean theFileExists = theFile.exists();
                if (theFileExists) return;
                FileInputStream is = new FileInputStream(filePath);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                BufferedWriter writer = new BufferedWriter(new FileWriter(configPath));
                String line = reader.readLine();
                while (line != null) {
                    writer.append(line);
                    writer.newLine();
                    line = reader.readLine();
                }
                writer.flush();
                return;
            }
            catch (IOException e) {
                Logger.getLogger("ErrorLogger").error(e);
            }
        }
    }

    private static void copyConfigResourcesToJICEFolderFromFileSystem() {
        File file = new File(COPY_TO_USER_FOLDER_DIR_NAME);
        Global.recursiveFileCopyToUsersJICEFolder(file);
    }

    public static void init(String prefix) throws IOException {
        String[] files = new String[]{"preferences.properties", "peakScanDefaults.properties"};
        int size = files.length;
        String configPath = Global.getConfigPath();
        Global.copyResourcesFromCopyToUserFolderToJICEFolder();
        int i = 0;
        while (i < size) {
            File file = new File(String.valueOf(configPath) + prefix + files[i]);
            if (!file.exists()) {
                logger.debug(String.valueOf(files[i]) + " does not exist");
                if (file.getName().endsWith("-DeviceOrder.xml")) {
                    Global.createConfigFile(configPath, "", files[i]);
                } else {
                    Global.createConfigFile(configPath, prefix, files[i]);
                }
            }
            ++i;
        }
    }

    private static void createConfigFile(String configPath, String prefix, String filename) throws IOException {
        logger.debug("filename: " + filename);
        InputStream is = new Global().getClass().getResourceAsStream("/config/" + filename);
        if (is == null) {
            logger.debug("Input Stream is null for " + filename + ".  Possibly not running from JAR?");
            logger.debug("classpath:" + System.getProperty("java.class.path"));
            is = new FileInputStream(String.valueOf(System.getProperty("user.dir")) + separator + "config" + separator + filename);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        File file = new File(configPath, String.valueOf(prefix) + filename);
        File dir = new File(configPath);
        logger.debug("directory exists?  " + String.valueOf(dir.exists()));
        if (!dir.exists()) {
            dir.mkdir();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        String line = reader.readLine();
        logger.debug("line: " + line);
        while (line != null) {
            writer.append(line);
            writer.newLine();
            line = reader.readLine();
            logger.debug("line: " + line);
        }
        writer.flush();
    }

    public static String getConfigPath() {
        String separator = System.getProperty("file.separator");
        String configPath = System.getProperty("user.home");
        String os2 = System.getProperty("os.name");
        configPath = os2.equalsIgnoreCase("Windows XP") || os2.equalsIgnoreCase("Windows 2000") ? String.valueOf(configPath) + separator + "Application Data" + separator + APPNAME + separator : (os2.equalsIgnoreCase("Linux") ? String.valueOf(configPath) + separator + ".JICE" + separator : (os2.startsWith("Mac OS X") ? String.valueOf(configPath) + separator + ".JICE" + separator : "." + separator + ".JICE" + separator));
        return configPath;
    }

    public static DecimalFormat createDecimalValue() {
        return new DecimalFormat("######0.####");
    }

    public static String degreeSign() {
        return new String("\u00ba");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPanelNumber() {
        Integer n = panelNumber;
        synchronized (n) {
            return panelNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementPanelNumber() {
        Integer n = panelNumber;
        synchronized (n) {
            panelNumber = panelNumber + 1;
        }
    }

    public static synchronized void setClipboardContents(Transferable contents, ClipboardOwner owner) {
        clipboard.setContents(contents, owner);
    }

    public static synchronized Transferable getClipboardContents(Object requester) {
        return clipboard.getContents(requester);
    }

    public static final String[] getMagicWords() {
        String[] magicWords = new String[]{USER_MAGIC_WORD, EXPT_MAGIC_WORD, COMM_MAGIC_WORD};
        return magicWords;
    }

    public static boolean equals(Double a, Double b, double epsilon) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Math.abs(a - b) < epsilon;
    }

    public static boolean equals(Double a, Double b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Math.abs(a - b) < 1.0E-6;
    }

    public static boolean equals(HashMap<String, String> a, HashMap<String, String> b) {
        boolean equals = true;
        if (a == null || b == null) {
            return !equals;
        }
        if (a.size() != b.size()) {
            return !equals;
        }
        for (Map.Entry<String, String> pair : a.entrySet()) {
            String aKey = pair.getKey();
            String aValue = pair.getValue();
            String bValue = b.get(aKey);
            if (bValue.equals(aValue)) continue;
            return !equals;
        }
        return equals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInstrumentName() {
        String string = instrumentName;
        synchronized (string) {
            return instrumentName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstrumentName(String newInstrumentName) {
        String string = instrumentName;
        synchronized (string) {
            instrumentName = newInstrumentName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInstrumentPath() {
        String string = instrumentPath;
        synchronized (string) {
            return instrumentPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstrumentPath(String newInstrumentPath) {
        String string = instrumentPath;
        synchronized (string) {
            instrumentPath = newInstrumentPath;
        }
    }
}

