/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TLeafI;
import hep.io.root.interfaces.TLeafL;
import java.io.IOException;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.Type;

public abstract class TLeafLRep
extends AbstractRootObject
implements TLeafL,
Constants {
    private Object lastValue;
    private TBranch branch;
    private long lastLong;
    private long lastLongIndex;
    private long lastValueIndex;

    public void setBranch(TBranch branch) {
        this.branch = branch;
        this.lastValueIndex = -1L;
        this.lastLongIndex = -1L;
    }

    public long getValue(long index) throws IOException {
        try {
            if (index == this.lastLongIndex) {
                return this.lastLong;
            }
            this.lastLongIndex = index;
            RootInput in = this.branch.setPosition(this, this.lastLongIndex);
            this.lastLong = in.readLong();
            return this.lastLong;
        }
        catch (IOException x) {
            this.lastLongIndex = -1L;
            throw x;
        }
    }

    public Object getWrappedValue(long index) throws IOException {
        try {
            if (index == this.lastValueIndex) {
                return this.lastValue;
            }
            this.lastValueIndex = index;
            RootInput in = this.branch.setPosition(this, index);
            int arrayDim = this.getArrayDim();
            if (arrayDim == 0) {
                this.lastValue = new Long(in.readLong());
                return this.lastValue;
            }
            if (arrayDim == 1) {
                TLeafI count = (TLeafI)this.getLeafCount();
                int len = count == null ? this.getLen() : count.getValue(index);
                long[] array = new long[len];
                in.readFixedArray(array);
                this.lastValue = array;
                return array;
            }
            this.lastValue = this.readMultiArray(in, Long.TYPE, index);
            return this.lastValue;
        }
        catch (IOException x) {
            this.lastValueIndex = -1L;
            throw x;
        }
    }

    public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
        String leafClassName = this.getClass().getName();
        int arrayDim = this.getArrayDim();
        if (arrayDim == 0) {
            il.append(factory.createInvoke(leafClassName, "getValue", Type.LONG, new Type[]{Type.LONG}, (short)182));
        } else {
            il.append(factory.createInvoke(leafClassName, "getWrappedValue", Type.OBJECT, new Type[]{Type.LONG}, (short)182));
        }
    }

    abstract Object[] readMultiArray(RootInput var1, Class var2, long var3);
}

