/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.RootObject;
import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.Clone;
import hep.io.root.core.Clones;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TObjArray;
import hep.io.root.interfaces.TObject;
import java.io.IOException;

public abstract class TClonesArrayRep
extends AbstractRootObject
implements TObjArray {
    private String fClassName;
    private String fName;
    private TObject fObject;
    private RootObject[] fArray;
    private int fLowerBound;
    private int fNobjects;
    private int fSize;

    public void readMembers(RootInput in) throws IOException {
        int v = in.readVersion(this);
        this.fObject = (TObject)in.readObject("TObject");
        this.fName = in.readObject("TString").toString();
        this.fClassName = in.readObject("TString").toString();
        this.fNobjects = in.readInt();
        if (this.fNobjects < 0) {
            this.fNobjects = -this.fNobjects;
        }
        this.fLowerBound = in.readInt();
        this.fArray = new RootObject[this.fNobjects];
        if (in.getRootVersion() >= 30200) {
            in.skipBytes(4 * this.fNobjects);
        }
        try {
            String className = this.fClassName;
            int pos = className.indexOf(59);
            if (pos > 0) {
                className = className.substring(0, pos);
            }
            Class<?> clcl = in.getFactory().getLoader().loadClass("hep.io.root.clones." + className);
            Clones clones = (Clones)clcl.newInstance();
            clones.read(in, this.fNobjects);
            clcl = in.getFactory().getLoader().loadClass("hep.io.root.clone." + className);
            for (int i = 0; i < this.fNobjects; ++i) {
                Clone clone = (Clone)clcl.newInstance();
                clone.setData(i, clones);
                this.fArray[i] = clone;
            }
            this.fSize = this.fArray.length;
            while (this.fSize > 0 && this.fArray[this.fSize - 1] == null) {
                --this.fSize;
            }
        }
        catch (ClassNotFoundException x) {
            throw new IOException("TClonesArray class not found: " + this.fClassName);
        }
        catch (Throwable x) {
            x.printStackTrace();
            System.exit(0);
            throw new IOException("TClonesArray instantiation exception: " + this.fClassName);
        }
        in.checkLength(this);
    }
}

