/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.NameMangler;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBasket;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TObjArray;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;

public abstract class TBranchRep
extends AbstractRootObject
implements TBranch {
    private HashMap mangledMap;
    private HashMap map;
    private RootInput rin;
    private TBasket curBasket;
    private int curIndex;
    private int fWriteBasket;
    private int[] cBasketBytes;
    private long[] cBasketEntry;
    private long[] cBasketSeek;

    public int[] getBasketBytes() {
        return this.cBasketBytes;
    }

    public long[] getBasketEntry() {
        return this.cBasketEntry;
    }

    public long[] getBasketSeek() {
        return this.cBasketSeek;
    }

    private int[] saveIntSpace(String source, int size) {
        try {
            if (size == 0) {
                return null;
            }
            int[] result = new int[size];
            Field field = this.getClass().getDeclaredField(source);
            Object array = field.get(this);
            for (int i = 0; i < size; ++i) {
                result[i] = Array.getInt(array, i);
            }
            return result;
        }
        catch (NoSuchFieldException x) {
            return null;
        }
        catch (Exception x) {
            throw new RuntimeException("Wierd error while compressing " + source, x);
        }
    }

    private long[] saveLongSpace(String source, int size) {
        try {
            if (size == 0) {
                return null;
            }
            long[] result = new long[size];
            Field field = this.getClass().getDeclaredField(source);
            Object array = field.get(this);
            for (int i = 0; i < size; ++i) {
                result[i] = Array.getLong(array, i);
            }
            return result;
        }
        catch (NoSuchFieldException x) {
            return null;
        }
        catch (Exception x) {
            throw new RuntimeException("Wierd error while compressing " + source, x);
        }
    }

    public TBranch getBranchForMangledName(String name) {
        if (this.map == null) {
            this.buildMap();
        }
        return (TBranch)this.mangledMap.get(name);
    }

    public TBranch getBranchForName(String name) {
        if (this.map == null) {
            this.buildMap();
        }
        return (TBranch)this.map.get(name);
    }

    public RootInput setPosition(TLeaf leaf, long index) throws IOException {
        int i = this.findBasketForIndex(index);
        TBasket basket = this.getBasket(i);
        return basket.setPosition(index, i == 0 ? 0L : this.getBasketEntry()[i], leaf);
    }

    public void read(RootInput in) throws IOException {
        super.read(in);
        this.cBasketBytes = this.saveIntSpace("fBasketBytes", this.fWriteBasket);
        this.cBasketEntry = this.saveLongSpace("fBasketEntry", this.fWriteBasket + 1);
        this.cBasketSeek = this.saveLongSpace("fBasketSeek", this.fWriteBasket);
        this.rin = in.getTop();
        TObjArray leaves = this.getLeaves();
        if (leaves != null) {
            for (int i = 0; i < leaves.size(); ++i) {
                TLeaf leaf = (TLeaf)leaves.get(i);
                leaf.setBranch(this);
            }
        }
        this.curIndex = -1;
    }

    private TBasket getBasket(int index) throws IOException {
        try {
            TObjArray baskets = this.getBaskets();
            TBasket basket = (TBasket)baskets.get(index);
            if (basket != null) {
                return basket;
            }
            if (index == this.curIndex) {
                return this.curBasket;
            }
            this.rin.setPosition(this.getBasketSeek()[index]);
            basket = (TBasket)this.rin.readObject("TBasket");
            int len = this.getEntryOffsetLen();
            if (len > 0) {
                basket.readEntryOffsets(len);
            }
            this.curIndex = index;
            this.curBasket = basket;
            return this.curBasket;
        }
        catch (IOException x) {
            this.curIndex = -1;
            throw x;
        }
    }

    private void buildMap() {
        NameMangler nameMangler = NameMangler.instance();
        this.map = new HashMap();
        this.mangledMap = new HashMap();
        TObjArray branches = this.getBranches();
        int size = branches.size();
        for (int i = 0; i < size; ++i) {
            TBranch b = (TBranch)branches.get(i);
            String bName = b.getName();
            int pos = bName.indexOf(91);
            if (pos > 0) {
                bName = bName.substring(0, pos);
            }
            if ((pos = bName.lastIndexOf(46)) > 0) {
                bName = bName.substring(pos + 1);
            }
            this.map.put(bName, b);
            this.mangledMap.put(nameMangler.mangleMember(bName), b);
        }
    }

    private int findBasketForIndex(long index) {
        if (index < 0L || index >= this.getEntries()) {
            throw new ArrayIndexOutOfBoundsException("index=" + index);
        }
        long[] entries = this.getBasketEntry();
        if (entries == null) {
            return 0;
        }
        int n = this.getWriteBasket();
        for (int i = 0; i < n; ++i) {
            if (index < entries[i] || index >= entries[i + 1]) continue;
            return i;
        }
        return n;
    }
}

