/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.core.BasicMember;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.IntrinsicRootClass;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.StreamerInfo;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.Type;

public class StreamerInfoString
extends StreamerInfo {
    private String description;

    public StreamerInfoString(String description) {
        this.description = description;
    }

    int getBits() {
        return 0;
    }

    int getCheckSum() {
        return 0;
    }

    int getVersion() {
        return 0;
    }

    void resolve(RootClassFactory factory) throws RootClassNotFound {
        if (this.description != null) {
            Vector<BasicRootClass> sv = new Vector<BasicRootClass>();
            Vector<MemberString> mv = new Vector<MemberString>();
            StringTokenizer tokenizer = new StringTokenizer(this.description, ";");
            while (tokenizer.hasMoreTokens()) {
                int pos;
                String token = tokenizer.nextToken();
                StringTokenizer t2 = new StringTokenizer(token, " ");
                if (t2.countTokens() == 1) {
                    String className = t2.nextToken();
                    BasicRootClass superClass = factory.create(className);
                    sv.addElement(superClass);
                    continue;
                }
                String index = null;
                String type = t2.nextToken();
                String name = t2.nextToken();
                boolean pointer = type.endsWith("*");
                if (pointer) {
                    type = type.substring(0, type.length() - 1);
                }
                if ((pos = type.indexOf(91)) > 0) {
                    int l = type.length();
                    index = type.substring(pos + 1, l - 1);
                    type = type.substring(0, pos);
                }
                BasicRootClass memberClass = factory.create(type);
                mv.addElement(new MemberString(memberClass, name, pointer, index));
            }
            this.superClasses = new RootClass[sv.size()];
            sv.copyInto(this.superClasses);
            this.members = new MemberString[mv.size()];
            mv.copyInto(this.members);
            this.description = null;
        }
    }

    private class MemberString
    extends BasicMember {
        private BasicRootClass varClass;
        private String name;
        private boolean pointer;
        private int dim;
        private int index;
        private String varCounter;

        MemberString(BasicRootClass type, String name, boolean pointer, String index) {
            this.varClass = type;
            this.name = name;
            this.pointer = pointer;
            this.dim = index == null ? 0 : 1;
            try {
                this.index = Integer.parseInt(index);
            }
            catch (NumberFormatException x) {
                this.varCounter = index;
            }
        }

        public int getArrayDim() {
            return this.dim;
        }

        public String getVarCounter() {
            return this.varCounter;
        }

        public String getComment() {
            return null;
        }

        public Type getJavaType() {
            Type t = this.varClass.getJavaTypeForMethod();
            if (this.dim > 0) {
                t = new ArrayType(t, this.dim);
            }
            return t;
        }

        public int getMaxIndex(int index) {
            return index == 0 ? this.index : 1;
        }

        public String getName() {
            return this.name;
        }

        public RootClass getType() {
            return this.varClass;
        }

        public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
            if (this.pointer) {
                ((GenericRootClass)this.varClass).generateReadPointerCode(il, factory, cp);
            } else if (this.dim == 0) {
                this.varClass.generateReadCode(il, factory, cp);
            } else if (this.varCounter == null) {
                ((IntrinsicRootClass)this.varClass).generateReadArrayCode(il, factory, cp, 1, new int[]{this.index});
            } else {
                BasicMember varMember = StreamerInfoString.this.getMember(this.varCounter);
                if (varMember == null) {
                    throw new RuntimeException("Cannot find variable counter " + this.varCounter);
                }
                Type varMemberType = varMember.getJavaType();
                il.append(InstructionConstants.ALOAD_0);
                il.append(factory.createInvoke(className, nameMangler.mangleMember(this.varCounter), varMemberType, Type.NO_ARGS, (short)183));
                if (varMemberType != Type.INT) {
                    il.append(factory.createCast(varMemberType, Type.INT));
                }
                BasicType type = (BasicType)this.varClass.getJavaType();
                il.append(new NEWARRAY(type));
                il.append(InstructionConstants.DUP_X1);
                Type[] arrayArgType = new Type[]{new ArrayType(type, 1)};
                il.append(factory.createInvoke("hep.io.root.core.RootInput", "readFixedArray", Type.VOID, arrayArgType, (short)185));
            }
            if (this.varClass.getConvertMethod() != null) {
                il.append(factory.createInvoke("hep.io.root.interfaces." + this.varClass.getClassName(), this.varClass.getConvertMethod(), this.varClass.getJavaTypeForMethod(), Type.NO_ARGS, (short)185));
            }
        }

        boolean isPointer() {
            return this.pointer;
        }
    }
}

