/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClassNotFound;
import hep.io.root.RootObject;
import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.RootByteArrayInputStream;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootInput;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.Inflater;

class RootInputStream
extends DataInputStream
implements RootInput {
    private static int kByteCountMask = 0x40000000;
    private static int kNewClassTag = -1;
    private static int kClassMask = Integer.MIN_VALUE;
    private static int kMapOffset = 2;
    private Hashtable readMap = new Hashtable();
    private RootInput top;

    public RootInputStream(RootByteArrayInputStream in, RootInput top) {
        super(in);
        this.top = top;
    }

    public RootClassFactory getFactory() {
        return this.top.getFactory();
    }

    public void setMap(int offset) {
        ((RootByteArrayInputStream)this.in).setOffset(offset);
    }

    public void setPosition(long pos) {
        ((RootByteArrayInputStream)this.in).setPosition(pos);
    }

    public long getPosition() {
        return ((RootByteArrayInputStream)this.in).getPosition();
    }

    public int getRootVersion() {
        return this.top.getRootVersion();
    }

    public RootInput getTop() {
        return this.top;
    }

    public void checkLength(AbstractRootObject obj) throws IOException {
        RootInputStream.checkLength(this, obj);
    }

    public void clearMap() {
        ((RootByteArrayInputStream)this.in).setOffset(0);
    }

    public int readArray(int[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    public int readArray(byte[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    public int readArray(short[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    public int readArray(float[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    public int readArray(double[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    public void readFixedArray(int[] data) throws IOException {
        RootInputStream.readFixedArray((RootInput)this, data);
    }

    public void readFixedArray(long[] data) throws IOException {
        RootInputStream.readFixedArray((RootInput)this, data);
    }

    public void readFixedArray(byte[] data) throws IOException {
        int n;
        int l = data.length;
        for (int i = 0; i < l; i += n) {
            n = this.in.read(data, i, l - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
    }

    public void readFixedArray(short[] data) throws IOException {
        RootInputStream.readFixedArray((RootInput)this, data);
    }

    public void readFixedArray(float[] data) throws IOException {
        RootInputStream.readFixedArray((RootInput)this, data);
    }

    public void readFixedArray(double[] data) throws IOException {
        RootInputStream.readFixedArray((RootInput)this, data);
    }

    public void readMultiArray(Object[] array) throws IOException {
        RootInputStream.readMultiArray(this, array);
    }

    public String readNullTerminatedString(int maxLength) throws IOException {
        return RootInputStream.readNullTerminatedString(this, maxLength);
    }

    public RootObject readObject(String type) throws IOException {
        return RootInputStream.readObject(this, type);
    }

    public RootObject readObjectRef() throws IOException {
        return RootInputStream.readObjectRef(this, this.readMap);
    }

    public String readString() throws IOException {
        return RootInputStream.readString(this);
    }

    public int readVersion() throws IOException {
        return RootInputStream.readVersion(this, null);
    }

    public int readVersion(AbstractRootObject obj) throws IOException {
        return RootInputStream.readVersion(this, obj);
    }

    public RootInput slice(int size) throws IOException {
        return RootInputStream.slice(this, size);
    }

    public RootInput slice(int inSize, int outSize) throws IOException {
        return RootInputStream.slice(this, inSize, outSize);
    }

    public double readTwistedDouble() throws IOException {
        return RootInputStream.readTwistedDouble(this);
    }

    public void dump() throws IOException {
        RootInputStream.dump(this, 200);
    }

    public void skipObject() throws IOException {
        RootInputStream.skipObject(this);
    }

    static void checkLength(RootInput in, AbstractRootObject obj) throws IOException {
        obj.checkLength(in.getPosition());
    }

    static int readArray(RootInput in, int[] data) throws IOException {
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            data[i] = in.readInt();
        }
        return n;
    }

    static int readArray(RootInput in, byte[] data) throws IOException {
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            data[i] = in.readByte();
        }
        return n;
    }

    static int readArray(RootInput in, short[] data) throws IOException {
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            data[i] = in.readShort();
        }
        return n;
    }

    static int readArray(RootInput in, float[] data) throws IOException {
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            data[i] = in.readFloat();
        }
        return n;
    }

    static int readArray(RootInput in, double[] data) throws IOException {
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            data[i] = in.readDouble();
        }
        return n;
    }

    static void readFixedArray(RootInput in, int[] data) throws IOException {
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = in.readInt();
        }
    }

    static void readFixedArray(RootInput in, long[] data) throws IOException {
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = in.readLong();
        }
    }

    static void readFixedArray(RootInput in, byte[] data) throws IOException {
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = in.readByte();
        }
    }

    static void readFixedArray(RootInput in, short[] data) throws IOException {
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = in.readShort();
        }
    }

    static void readFixedArray(RootInput in, float[] data) throws IOException {
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = in.readFloat();
        }
    }

    static void readFixedArray(RootInput in, double[] data) throws IOException {
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = in.readDouble();
        }
    }

    static void readMultiArray(RootInput in, Object[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            Object o = array[i];
            if (o instanceof double[]) {
                RootInputStream.readFixedArray(in, (double[])o);
                continue;
            }
            if (o instanceof float[]) {
                RootInputStream.readFixedArray(in, (float[])o);
                continue;
            }
            if (o instanceof short[]) {
                RootInputStream.readFixedArray(in, (short[])o);
                continue;
            }
            if (o instanceof byte[]) {
                RootInputStream.readFixedArray(in, (byte[])o);
                continue;
            }
            if (o instanceof int[]) {
                RootInputStream.readFixedArray(in, (int[])o);
                continue;
            }
            if (o instanceof long[]) {
                RootInputStream.readFixedArray(in, (long[])o);
                continue;
            }
            if (o instanceof Object[]) {
                RootInputStream.readMultiArray(in, (Object[])o);
                continue;
            }
            throw new IOException("Unknown multiarray element: " + o.getClass());
        }
    }

    static String readNullTerminatedString(DataInput in, int maxLength) throws IOException {
        int actualLength = maxLength - 1;
        byte[] data = new byte[maxLength];
        for (int i = 0; i < maxLength; ++i) {
            data[i] = in.readByte();
            if (data[i] != 0) continue;
            actualLength = i;
            break;
        }
        return new String(data, 0, actualLength);
    }

    static RootObject readObject(RootInput in, String type) throws IOException {
        try {
            AbstractRootObject obj = ((GenericRootClass)in.getFactory().create(type)).newInstance();
            obj.read(in);
            return obj;
        }
        catch (RootClassNotFound x) {
            throw new IOException("Could not find class " + x.getClassName());
        }
    }

    static RootObject readObjectRef(RootInput in, Map map) throws IOException {
        int tag;
        long objStartPos = in.getPosition();
        int fVersion = 0;
        long startpos = 0L;
        int bcnt = in.readInt();
        if ((bcnt & kByteCountMask) == 0 || bcnt == kNewClassTag) {
            tag = bcnt;
            bcnt = 0;
        } else {
            fVersion = 1;
            startpos = in.getPosition();
            tag = in.readInt();
        }
        if ((tag & kClassMask) == 0) {
            if (tag == 0) {
                return null;
            }
            if (tag == 1) {
                return null;
            }
            Object obj = map.get(new Long(tag));
            if (obj == null || !(obj instanceof RootObject)) {
                throw new IOException("Invalid tag found " + tag);
            }
            return (RootObject)obj;
        }
        if (tag == kNewClassTag) {
            try {
                String className = in.readNullTerminatedString(80);
                GenericRootClass rootClass = (GenericRootClass)in.getFactory().create(className);
                if (fVersion > 0) {
                    map.put(new Long(startpos + (long)kMapOffset), rootClass);
                } else {
                    map.put(new Long(map.size() + 1), rootClass);
                }
                AbstractRootObject obj = rootClass.newInstance();
                if (fVersion > 0) {
                    map.put(new Long(objStartPos + (long)kMapOffset), obj);
                } else {
                    map.put(new Long(map.size() + 1), obj);
                }
                obj.read(in);
                return obj;
            }
            catch (RootClassNotFound x) {
                throw new IOException("Class not found during object read: " + x.getClassName());
            }
        }
        Object cls = map.get(new Long(tag &= ~kClassMask));
        if (cls == null || !(cls instanceof BasicRootClass)) {
            System.out.println("Map Dump");
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
            throw new IOException("Invalid object tag " + tag);
        }
        GenericRootClass rootClass = (GenericRootClass)cls;
        AbstractRootObject obj = rootClass.newInstance();
        if (fVersion > 0) {
            Long offset = new Long(objStartPos + (long)kMapOffset);
            map.put(offset, obj);
        } else {
            map.put(new Long(map.size() + 1), obj);
        }
        obj.read(in);
        return obj;
    }

    static String readString(DataInput in) throws IOException {
        int l = in.readByte();
        byte[] data = new byte[l];
        for (int i = 0; i < l; ++i) {
            data[i] = in.readByte();
        }
        return new String(data);
    }

    static int readVersion(RootInput in, AbstractRootObject obj) throws IOException {
        short version = in.readShort();
        if ((version & 0x4000) == 0) {
            return version;
        }
        int byteCount = ((version & 0x3FFF) << 16) + in.readUnsignedShort();
        if (obj != null) {
            obj.setExpectedLength(in.getPosition(), byteCount);
        }
        return in.readShort();
    }

    static void skipObject(RootInput in) throws IOException {
        short version = in.readShort();
        if ((version & 0x4000) == 0) {
            throw new IOException("Cannot skip object with no length");
        }
        int byteCount = ((version & 0x3FFF) << 16) + in.readUnsignedShort();
        System.err.println("skipping " + byteCount);
        in.skipBytes(byteCount);
    }

    static RootInput slice(RootInput in, int size) throws IOException {
        byte[] buf = new byte[size];
        in.readFixedArray(buf);
        return new RootInputStream(new RootByteArrayInputStream(buf, 0), in.getTop());
    }

    static RootInput slice(RootInput in, int size, int decompressedSize) throws IOException {
        byte[] buf = new byte[size];
        in.readFixedArray(buf);
        byte[] out = new byte[decompressedSize];
        int nout = 0;
        int nin = 0;
        while (nout < decompressedSize) {
            boolean hasHeader = buf[0] == 90 && buf[1] == 76;
            Inflater inf = new Inflater(!hasHeader);
            try {
                inf.setInput(buf, nin += 9, buf.length - nin);
                int rc = inf.inflate(out, nout, out.length - nout);
                nout += rc;
                nin += inf.getTotalIn();
            }
            catch (Exception x) {
                IOException xx = new IOException("Error during decompression (size=" + size + "/" + decompressedSize + ")");
                xx.initCause(x);
                throw xx;
            }
            finally {
                inf.end();
            }
        }
        return new RootInputStream(new RootByteArrayInputStream(out, 0), in.getTop());
    }

    static double readTwistedDouble(RootInput in) throws IOException {
        int i1 = in.readInt();
        int i2 = in.readInt();
        long val = (long)i1 + ((long)i2 << 32);
        return Double.longBitsToDouble(val);
    }

    static void dump(RootInput in, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            byte b = in.readByte();
            char c = (char)(b < 32 ? 32 : (char)b);
            System.out.println("dump[" + i + "]: " + b + " " + c);
        }
        throw new IOException("dump");
    }
}

