/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.core.DefaultClassFactory;
import hep.io.root.core.FastInputStream;
import hep.io.root.core.FileClassFactory;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootDaemonInputStream;
import hep.io.root.core.RootInput;
import hep.io.root.core.RootRandomAccessFile;
import hep.io.root.daemon.DaemonInputStream;
import hep.io.root.interfaces.TDatime;
import hep.io.root.interfaces.TDirectory;
import hep.io.root.interfaces.TFile;
import hep.io.root.interfaces.TKey;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class RootFileReader
implements TFile {
    private static boolean welcome = false;
    private static boolean debug = System.getProperty("debugRoot") != null;
    private ClassLoader classLoader;
    private Date fDatimeC;
    private Date fDatimeM;
    private RootClass fileClass;
    private RootClassFactory factory;
    private RootInput in;
    private String name;
    private String title;
    private TDirectory dir;
    private TKey streamerInfo;
    private int fNbytesKeys;
    private int fNbytesName;
    private long fSeekDir;
    private long fSeekKeys;
    private long fSeekParent;
    private int fVersion;
    private long fSeekInfo;

    public RootFileReader(URL url, Map options, RootFileReader shared) throws IOException {
        if (url.getProtocol().equals("file")) {
            this.init(new File(url.getFile()), shared);
        } else {
            InputStream source;
            URLConnection connection = url.openConnection();
            if (options != null) {
                Object bufferSize;
                Object mode;
                Object pass;
                Object user = options.get("user");
                if (user != null) {
                    connection.setRequestProperty("user", user.toString());
                }
                if ((pass = options.get("password")) != null) {
                    connection.setRequestProperty("password", pass.toString());
                }
                if ((mode = options.get("scheme")) != null) {
                    connection.setRequestProperty("scheme", mode.toString());
                }
                if ((bufferSize = options.get("bufferSize")) != null) {
                    connection.setRequestProperty("bufferSize", bufferSize.toString());
                }
            }
            if ((source = connection.getInputStream()) instanceof DaemonInputStream) {
                this.init(new RootDaemonInputStream((DaemonInputStream)source, this), shared);
            } else {
                throw new IOException("Unsupported protocol: " + url.getProtocol());
            }
        }
    }

    public RootFileReader(URL url, Map options) throws IOException {
        this(url, options, null);
    }

    public RootFileReader(URL url) throws IOException {
        this(url, null);
    }

    public RootFileReader(String file) throws IOException {
        this.init(new File(file), null);
    }

    public RootFileReader(File file) throws IOException {
        this.init(file, null);
    }

    public RootFileReader(File file, RootFileReader shared) throws IOException {
        this.init(file, shared);
    }

    private void init(File file, RootFileReader shared) throws IOException {
        RootRandomAccessFile raf;
        RootInput in = raf = new RootRandomAccessFile(file, this);
        if (System.getProperty("useNIO") != null) {
            in = new FastInputStream(this, raf);
        }
        this.init(in, shared);
    }

    private void init(RootInput in, RootFileReader shared) throws IOException {
        block12: {
            try {
                this.in = in;
                if (!welcome) {
                    RootFileReader.welcome();
                }
                this.factory = new DefaultClassFactory(this);
                this.fileClass = this.factory.create("TFile");
                this.fVersion = in.readInt();
                if (this.fVersion < 30006) {
                    throw new IOException("hep.io.root package cannot read files created by Root before release 3.00/6 (" + this.fVersion + ")");
                }
                if (debug) {
                    System.out.println("version=" + this.fVersion);
                }
                int fBEGIN = in.readInt();
                if (this.fVersion > 1000000) {
                    long fEND = in.readLong();
                    long fSeekFree = in.readLong();
                    int fNbytesFree = in.readInt();
                    int nfree = in.readInt();
                    this.fNbytesName = in.readInt();
                    byte fUnits = in.readByte();
                    int fCompress = in.readInt();
                    this.fSeekInfo = in.readLong();
                    int fNBytesInfo = in.readInt();
                } else {
                    int fEND = in.readInt();
                    int fSeekFree = in.readInt();
                    int fNbytesFree = in.readInt();
                    int nfree = in.readInt();
                    this.fNbytesName = in.readInt();
                    byte fUnits = in.readByte();
                    int fCompress = in.readInt();
                    this.fSeekInfo = in.readInt();
                    int fNBytesInfo = in.readInt();
                }
                in.setPosition(fBEGIN);
                int Nbytes = in.readInt();
                short version = in.readShort();
                int ObjLen = in.readInt();
                this.fDatimeC = this.fDatimeM = ((TDatime)in.readObject("TDatime")).getDate();
                short KeyLen = in.readShort();
                short Cycle = in.readShort();
                if (version > 1000) {
                    long fSeekKey = in.readLong();
                    long fSeekPdir = in.readLong();
                } else {
                    long fSeekKey = in.readInt();
                    long fSeekPdir = in.readInt();
                }
                String className = in.readObject("TString").toString();
                this.name = in.readObject("TString").toString();
                this.title = in.readObject("TString").toString();
                in.setPosition(fBEGIN + this.fNbytesName);
                this.dir = (TDirectory)in.readObject("TDirectory");
                if (this.fSeekInfo == 0L) {
                    this.recover(fBEGIN);
                }
                if (shared != null) {
                    this.factory = shared.factory;
                    break block12;
                }
                if (this.fSeekInfo != 0L) {
                    in.setPosition(this.fSeekInfo);
                    this.streamerInfo = (TKey)in.readObject("TKey");
                    this.factory = new FileClassFactory(this.streamerInfo, this.factory, this);
                    break block12;
                }
                throw new IOException("Could not located StreamerInfo in root file");
            }
            catch (RootClassNotFound xr) {
                IOException x = new IOException("Root Class Not Found: " + xr.getClassName());
                x.initCause(xr);
                throw x;
            }
        }
    }

    private void recover(int begin) throws IOException {
        if (debug) {
            System.err.println("File recovery in process");
        }
        long idcur = begin;
        int nread = 1024;
        while (true) {
            this.in.setPosition(idcur);
            int nbytes = this.in.readInt();
            if (nbytes < 0) {
                idcur -= (long)nbytes;
                continue;
            }
            int v = this.in.readVersion();
            int fObjlen = this.in.readInt();
            Date fDatime = ((TDatime)this.in.readObject("TDatime")).getDate();
            short fKeylen = this.in.readShort();
            short fCycle = this.in.readShort();
            if (v > 1000) {
                long fSeekKey = this.in.readLong();
                long fSeekPdir = this.in.readLong();
            } else {
                int fSeekKey = this.in.readInt();
                int fSeekPdir = this.in.readInt();
            }
            String fClassName = this.in.readObject("TString").toString();
            String fName = this.in.readObject("TString").toString();
            String fTitle = this.in.readObject("TString").toString();
            if ("StreamerInfo".equals(fName)) {
                this.fSeekInfo = idcur;
            }
            idcur += (long)nbytes;
        }
    }

    public int getBits() {
        return 0;
    }

    public RootClassFactory getClassFactory() {
        return this.factory;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Date getDatimeC() {
        return this.fDatimeC;
    }

    public Date getDatimeM() {
        return this.fDatimeM;
    }

    public RootClassFactory getFactory() {
        return this.factory;
    }

    public TKey getKey(int index) {
        return this.dir.getKey(index);
    }

    public TKey getKey(String name) {
        return this.dir.getKey(name);
    }

    public TKey getKey(String name, int cycle) {
        return this.dir.getKey(name, cycle);
    }

    public TKey getKeyForTitle(String name) {
        return this.dir.getKeyForTitle(name);
    }

    public boolean hasKey(String name, int cycle) {
        return this.dir.hasKey(name, cycle);
    }

    public boolean hasKey(String name) {
        return this.dir.hasKey(name);
    }

    public String getName() {
        return this.name;
    }

    public int getNbytesKeys() {
        return this.fNbytesKeys;
    }

    public int getNbytesName() {
        return this.fNbytesName;
    }

    public RootClass getRootClass() {
        return this.fileClass;
    }

    public long getSeekDir() {
        return this.fSeekDir;
    }

    public long getSeekKeys() {
        return this.fSeekKeys;
    }

    public long getSeekParent() {
        return this.fSeekParent;
    }

    public String getTitle() {
        return this.title;
    }

    public int getUniqueID() {
        return 0;
    }

    public int getVersion() {
        return this.fVersion;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public Object get(String name) throws IOException, RootClassNotFound {
        TKey key = this.getKey(name);
        return key.getObject();
    }

    public int nKeys() {
        return this.dir.nKeys();
    }

    public List streamerInfo() throws IOException {
        try {
            return (List)((Object)this.streamerInfo.getObject());
        }
        catch (RootClassNotFound x) {
            throw new IOException("Root Class Not Found during IO: " + x);
        }
    }

    public TKey streamerInfoKey() {
        return this.streamerInfo;
    }

    private static void welcome() {
        System.out.println("Root IO for Java, part of the FreeHEP library: http://java.freehep.org");
        System.out.println("Please report all bugs/problems to tonyj@slac.stanford.edu");
        System.out.println("Version $Id: RootFileReader.java 13440 2007-12-07 01:12:30Z tonyj $");
        welcome = true;
    }
}

