/*
 * Decompiled with CFR 0.152.
 */
package hep.io.hbook;

import hep.io.hbook.CompositeHbookObject;
import hep.io.hbook.Hbook;
import hep.io.hbook.Tuple;

public class RowwiseTuple
extends Tuple {
    private int id;
    private int idx;
    long buffer = 0L;

    RowwiseTuple(CompositeHbookObject parent, String name, int length, int id, int idx) {
        super(parent, name, 2, length);
        this.id = id;
        this.idx = idx;
    }

    int getID() {
        return this.id;
    }

    public String toString() {
        String result = "RW Tuple: " + this.idx + " " + this.getName() + " (" + this.nChildren() + " columns " + this.getRows() + " rows)";
        return result;
    }

    void close() {
        super.close();
        if (this.buffer != 0L) {
            Hbook.freeBuffer(this.buffer);
        }
        Hbook.delete(this.id);
    }

    public int id() {
        return this.idx;
    }

    long getBuffer() {
        if (this.buffer == 0L) {
            this.buffer = Hbook.allocBuffer(4 * this.nChildren());
            Hbook.setRWEvent(this.id, this.ievent, this.buffer);
        }
        return this.buffer;
    }

    public void setCurrentRow(int row) {
        super.setCurrentRow(row);
        if (this.buffer != 0L) {
            Hbook.setRWEvent(this.id, this.ievent, this.buffer);
        }
    }
}

