/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.test.AidaTestCase;
import hep.aida.test.TestUtils;
import java.io.IOException;
import junit.framework.Assert;

public class TestPathNameTitleConvention
extends AidaTestCase {
    private String outputName = TestUtils.getFullPath("testPathNameTitleConvention.aida");
    private String options = "compress=no";

    public TestPathNameTitleConvention(String testName) {
        super(testName);
    }

    public void testPathNameTitle() throws IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create(this.outputName, null, false, true, this.options);
        IHistogramFactory hf = af.createHistogramFactory(tree);
        IDataPointSetFactory dpsf = af.createDataPointSetFactory(tree);
        IFunctionFactory ff = af.createFunctionFactory(tree);
        ITupleFactory tf = af.createTupleFactory(tree);
        tree.mkdir("/histograms");
        tree.mkdir("/clouds");
        tree.mkdir("/dataPointSets");
        tree.mkdir("/functions");
        tree.mkdir("/tuples");
        IHistogram1D hist1DWithTitle = hf.createHistogram1D("/histograms/hist1DWithTitle", "hist1D title", 10, 0.0, 10.0);
        IHistogram1D hist1DWithoutTitle = hf.createHistogram1D("/histograms/hist1DWithoutTitle", 10, 0.0, 10.0);
        IHistogram2D hist2DWithTitle = hf.createHistogram2D("/histograms/hist2DWithTitle", "hist2D title", 10, 0.0, 10.0, 10, 0.0, 10.0);
        IHistogram2D hist2DWithoutTitle = hf.createHistogram2D("/histograms/hist2DWithoutTitle", 10, 0.0, 10.0, 10, 0.0, 10.0);
        IHistogram3D hist3DWithTitle = hf.createHistogram3D("/histograms/hist3DWithTitle", "hist3D title", 10, 0.0, 10.0, 10, 0.0, 10.0, 10, 0.0, 10.0);
        IHistogram3D hist3DWithoutTitle = hf.createHistogram3D("/histograms/hist3DWithoutTitle", 10, 0.0, 10.0, 10, 0.0, 10.0, 10, 0.0, 10.0);
        Assert.assertEquals(hist1DWithTitle.title(), "hist1D title");
        Assert.assertEquals(((IManagedObject)((Object)hist1DWithTitle)).name(), "hist1DWithTitle");
        Assert.assertEquals(hist1DWithoutTitle.title(), ((IManagedObject)((Object)hist1DWithoutTitle)).name());
        Assert.assertEquals(hist2DWithoutTitle.title(), ((IManagedObject)((Object)hist2DWithoutTitle)).name());
        Assert.assertEquals(hist2DWithTitle.title(), "hist2D title");
        Assert.assertEquals(((IManagedObject)((Object)hist2DWithTitle)).name(), "hist2DWithTitle");
        Assert.assertEquals(hist3DWithoutTitle.title(), ((IManagedObject)((Object)hist3DWithoutTitle)).name());
        Assert.assertEquals(hist3DWithTitle.title(), "hist3D title");
        Assert.assertEquals(((IManagedObject)((Object)hist3DWithTitle)).name(), "hist3DWithTitle");
        ICloud1D cloud1DWithTitle = hf.createCloud1D("/clouds/cloud1DWithTitle", "cloud1D title");
        ICloud1D cloud1DWithoutTitle = hf.createCloud1D("/clouds/cloud1DWithoutTitle");
        ICloud2D cloud2DWithTitle = hf.createCloud2D("/clouds/cloud2DWithTitle", "cloud2D title");
        ICloud2D cloud2DWithoutTitle = hf.createCloud2D("/clouds/cloud2DWithoutTitle");
        ICloud3D cloud3DWithTitle = hf.createCloud3D("/clouds/cloud3DWithTitle", "cloud3D title");
        ICloud3D cloud3DWithoutTitle = hf.createCloud3D("/clouds/cloud3DWithoutTitle");
        Assert.assertEquals(cloud1DWithTitle.title(), "cloud1D title");
        Assert.assertEquals(((IManagedObject)((Object)cloud1DWithTitle)).name(), "cloud1DWithTitle");
        Assert.assertEquals(cloud1DWithoutTitle.title(), ((IManagedObject)((Object)cloud1DWithoutTitle)).name());
        Assert.assertEquals(cloud2DWithoutTitle.title(), ((IManagedObject)((Object)cloud2DWithoutTitle)).name());
        Assert.assertEquals(cloud2DWithTitle.title(), "cloud2D title");
        Assert.assertEquals(((IManagedObject)((Object)cloud2DWithTitle)).name(), "cloud2DWithTitle");
        Assert.assertEquals(cloud3DWithoutTitle.title(), ((IManagedObject)((Object)cloud3DWithoutTitle)).name());
        Assert.assertEquals(cloud3DWithTitle.title(), "cloud3D title");
        Assert.assertEquals(((IManagedObject)((Object)cloud3DWithTitle)).name(), "cloud3DWithTitle");
        IDataPointSet dpsWithTitle = dpsf.create("/dataPointSets/dpsWithTitle", "dps Title", 12);
        IDataPointSet dpsWithoutTitle = dpsf.create("/dataPointSets/dpsWithoutTitle", 1);
        Assert.assertEquals(dpsWithTitle.title(), "dps Title");
        Assert.assertEquals(((IManagedObject)((Object)dpsWithTitle)).name(), "dpsWithTitle");
        Assert.assertEquals(dpsWithoutTitle.title(), ((IManagedObject)((Object)dpsWithoutTitle)).name());
        IFunction function = ff.createFunctionByName("/functions/gauss", "g");
        ITuple tupleWithTitle = tf.create("/tuples/tupleWithTitle", "tuple Title", "double x");
        Assert.assertEquals(tupleWithTitle.title(), "tuple Title");
        Assert.assertEquals(((IManagedObject)((Object)tupleWithTitle)).name(), "tupleWithTitle");
        try {
            hf.createHistogram1D("/abc/hist1DWithTitle", "hist1D title", 10, 0.0, 10.0);
            Assert.assertTrue(false);
        }
        catch (Throwable t) {
            // empty catch block
        }
        tree.commit();
    }
}

