/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;

public class TestCloud
extends AidaTestCase {
    private String cloud1DName = "1D Cloud Name Test";
    private String cloud1Dtitle = "1D Cloud title Test";
    private String cloud1DOpts = "Some, options=false , for=true, cloud1D=maybe ; autoConvert = false";
    private String cloud2DName = "2D Cloud Name Test";
    private String cloud2Dtitle = "2D Cloud title Test";
    private String cloud2DOpts = " Some= asdf, options = false , for= true, cloud2D = maybe, autoConvert";
    private String cloud3DName = "3D Cloud Name Test";
    private String cloud3Dtitle = "3D Cloud title Test";
    private String cloud3DOpts = " Some = sdf, options = False , for = TRUE, cloud3D = maybe, autoconvert = true";
    private int maxEntries = 10000000;
    private int xBins = 20;
    private int yBins = 15;
    private int zBins = 10;

    public TestCloud(String testName) {
        super(testName);
    }

    public void testCloudCreation() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ICloud1D cl1D = hf.createCloud1D(this.cloud1DName, this.cloud1Dtitle, this.maxEntries, this.cloud1DOpts);
        Assert.assertEquals(this.cloud1DName, ((IManagedObject)((Object)cl1D)).name());
        Assert.assertEquals(this.cloud1Dtitle, cl1D.title());
        Assert.assertEquals(1, cl1D.dimension());
        ICloud2D cl2D = hf.createCloud2D(this.cloud2DName, this.cloud2Dtitle, this.maxEntries, this.cloud2DOpts);
        Assert.assertEquals(this.cloud2DName, ((IManagedObject)((Object)cl2D)).name());
        Assert.assertEquals(this.cloud2Dtitle, cl2D.title());
        Assert.assertEquals(2, cl2D.dimension());
        ICloud3D cl3D = hf.createCloud3D(this.cloud3DName, this.cloud3Dtitle, this.maxEntries, this.cloud3DOpts);
        Assert.assertEquals(this.cloud3DName, ((IManagedObject)((Object)cl3D)).name());
        Assert.assertEquals(this.cloud3Dtitle, cl3D.title());
        Assert.assertEquals(3, cl3D.dimension());
    }

    public void testCloudFill() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ICloud1D cl1D = hf.createCloud1D(this.cloud1DName, this.cloud1Dtitle, -1, this.cloud1DOpts);
        ICloud2D cl2D = hf.createCloud2D(this.cloud2DName, this.cloud2Dtitle, -1, this.cloud2DOpts);
        ICloud3D cl3D = hf.createCloud3D(this.cloud3DName, this.cloud3Dtitle, -1, this.cloud3DOpts);
        IHistogram1D h1D = hf.createHistogram1D("AIDA 1D Histogram", this.xBins, -5.0, 5.0);
        IHistogram2D h2D = hf.createHistogram2D("AIDA 2D Histogram", this.xBins, -5.0, 5.0, this.yBins, -5.0, 5.0);
        IHistogram3D h3D = hf.createHistogram3D("AIDA 3D Histogram", this.xBins, -5.0, 5.0, this.yBins, -5.0, 5.0, this.zBins, -5.0, 5.0);
        double clUpperEdgeX = Double.MIN_VALUE;
        double clLowerEdgeX = Double.MAX_VALUE;
        double clUpperEdgeY = Double.MIN_VALUE;
        double clLowerEdgeY = Double.MAX_VALUE;
        double clUpperEdgeZ = Double.MIN_VALUE;
        double clLowerEdgeZ = Double.MAX_VALUE;
        double xValueTotal = 0.0;
        double yValueTotal = 0.0;
        double zValueTotal = 0.0;
        double weightTotal = 0.0;
        int entries = 20473;
        Random r = this.getRandomNumberGenerator();
        for (int i = 0; i < entries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            xValueTotal += xval;
            yValueTotal += yval;
            zValueTotal += zval;
            if (w > r.nextDouble()) {
                cl1D.fill(xval, w);
                h1D.fill(xval, w);
                cl2D.fill(xval, yval, w);
                h2D.fill(xval, yval, w);
                cl3D.fill(xval, yval, zval, w);
                h3D.fill(xval, yval, zval, w);
                weightTotal += w;
            } else {
                cl1D.fill(xval);
                h1D.fill(xval);
                cl2D.fill(xval, yval);
                h2D.fill(xval, yval);
                cl3D.fill(xval, yval, zval);
                h3D.fill(xval, yval, zval);
                weightTotal += 1.0;
            }
            if (xval > clUpperEdgeX) {
                clUpperEdgeX = xval;
            }
            if (xval < clLowerEdgeX) {
                clLowerEdgeX = xval;
            }
            if (yval > clUpperEdgeY) {
                clUpperEdgeY = yval;
            }
            if (yval < clLowerEdgeY) {
                clLowerEdgeY = yval;
            }
            if (zval > clUpperEdgeZ) {
                clUpperEdgeZ = zval;
            }
            if (!(zval < clLowerEdgeZ)) continue;
            clLowerEdgeZ = zval;
        }
        int cl1DEntries = cl1D.entries();
        Assert.assertEquals(entries, cl1DEntries);
        int cl2DEntries = cl2D.entries();
        Assert.assertEquals(entries, cl2DEntries);
        int cl3DEntries = cl3D.entries();
        Assert.assertEquals(entries, cl3DEntries);
        Assert.assertEquals(cl1D.lowerEdge(), clLowerEdgeX, 0.0);
        Assert.assertEquals(cl1D.upperEdge(), clUpperEdgeX, 0.0);
        Assert.assertEquals(cl2D.lowerEdgeX(), clLowerEdgeX, 0.0);
        Assert.assertEquals(cl2D.upperEdgeX(), clUpperEdgeX, 0.0);
        Assert.assertEquals(cl2D.lowerEdgeY(), clLowerEdgeY, 0.0);
        Assert.assertEquals(cl2D.upperEdgeY(), clUpperEdgeY, 0.0);
        Assert.assertEquals(cl3D.lowerEdgeX(), clLowerEdgeX, 0.0);
        Assert.assertEquals(cl3D.upperEdgeX(), clUpperEdgeX, 0.0);
        Assert.assertEquals(cl3D.lowerEdgeY(), clLowerEdgeY, 0.0);
        Assert.assertEquals(cl3D.upperEdgeY(), clUpperEdgeY, 0.0);
        Assert.assertEquals(cl3D.lowerEdgeZ(), clLowerEdgeZ, 0.0);
        Assert.assertEquals(cl3D.upperEdgeZ(), clUpperEdgeZ, 0.0);
        double xValueTotalCloud1D = 0.0;
        double weightTotalCloud1D = 0.0;
        double xValueTotalCloud2D = 0.0;
        double yValueTotalCloud2D = 0.0;
        double weightTotalCloud2D = 0.0;
        double xValueTotalCloud3D = 0.0;
        double yValueTotalCloud3D = 0.0;
        double zValueTotalCloud3D = 0.0;
        double weightTotalCloud3D = 0.0;
        for (int i = 0; i < entries; ++i) {
            xValueTotalCloud1D += cl1D.value(i);
            weightTotalCloud1D += cl1D.weight(i);
            xValueTotalCloud2D += cl2D.valueX(i);
            yValueTotalCloud2D += cl2D.valueY(i);
            weightTotalCloud2D += cl2D.weight(i);
            xValueTotalCloud3D += cl3D.valueX(i);
            yValueTotalCloud3D += cl3D.valueY(i);
            zValueTotalCloud3D += cl3D.valueZ(i);
            weightTotalCloud3D += cl3D.weight(i);
        }
        Assert.assertTrue(xValueTotal != 0.0);
        Assert.assertTrue(yValueTotal != 0.0);
        Assert.assertTrue(zValueTotal != 0.0);
        Assert.assertTrue(weightTotal != 0.0);
        Assert.assertTrue(xValueTotal != Double.NaN);
        Assert.assertTrue(yValueTotal != Double.NaN);
        Assert.assertTrue(zValueTotal != Double.NaN);
        Assert.assertTrue(weightTotal != Double.NaN);
        Assert.assertTrue(xValueTotal == xValueTotalCloud1D);
        Assert.assertTrue(weightTotal == weightTotalCloud1D);
        Assert.assertTrue(xValueTotal == xValueTotalCloud2D);
        Assert.assertTrue(yValueTotal == yValueTotalCloud2D);
        Assert.assertTrue(weightTotal == weightTotalCloud2D);
        Assert.assertTrue(xValueTotal == xValueTotalCloud3D);
        Assert.assertTrue(yValueTotal == yValueTotalCloud3D);
        Assert.assertTrue(zValueTotal == zValueTotalCloud3D);
        Assert.assertTrue(weightTotal == weightTotalCloud3D);
        Assert.assertTrue(!cl1D.isConverted());
        Assert.assertTrue(!cl2D.isConverted());
        Assert.assertTrue(!cl3D.isConverted());
        cl1D.reset();
        cl2D.reset();
        cl3D.reset();
        Assert.assertEquals(cl1D.entries(), 0);
        Assert.assertEquals(cl2D.entries(), 0);
        Assert.assertEquals(cl3D.entries(), 0);
    }

    public void testCloudConversion() {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        int maxE = -1;
        ICloud1D cl1D = hf.createCloud1D(this.cloud1DName, this.cloud1Dtitle, maxE, this.cloud1DOpts);
        ICloud2D cl2D = hf.createCloud2D(this.cloud2DName, this.cloud2Dtitle, maxE, this.cloud2DOpts);
        ICloud3D cl3D = hf.createCloud3D(this.cloud3DName, this.cloud3Dtitle, maxE, this.cloud3DOpts);
        IHistogram1D h1D = hf.createHistogram1D("AIDA 1D Histogram", this.xBins, -20.0, 20.0);
        IHistogram2D h2D = hf.createHistogram2D("AIDA 2D Histogram", this.xBins, -20.0, 20.0, this.yBins, -20.0, 20.0);
        IHistogram3D h3D = hf.createHistogram3D("AIDA 3D Histogram", this.xBins, -20.0, 20.0, this.yBins, -20.0, 20.0, this.zBins, -20.0, 20.0);
        int entries = 1347;
        int c = 0;
        for (int i = 0; i < entries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            if (++c == 250) {
                cl1D.convert(this.xBins, -20.0, 20.0);
                cl2D.convert(this.xBins, -20.0, 20.0, this.yBins, -20.0, 20.0);
                cl3D.convert(this.xBins, -20.0, 20.0, this.yBins, -20.0, 20.0, this.zBins, -20.0, 20.0);
            }
            if (w > r.nextDouble()) {
                cl1D.fill(xval, w);
                h1D.fill(xval, w);
                cl2D.fill(xval, yval, w);
                h2D.fill(xval, yval, w);
                cl3D.fill(xval, yval, zval, w);
                h3D.fill(xval, yval, zval, w);
            } else {
                cl1D.fill(xval);
                h1D.fill(xval);
                cl2D.fill(xval, yval);
                h2D.fill(xval, yval);
                cl3D.fill(xval, yval, zval);
                h3D.fill(xval, yval, zval);
            }
            if (i == 0) continue;
            AidaTestCase.assertEqualsDouble(cl1D.mean(), h1D.mean(), 1.0);
            AidaTestCase.assertEqualsDouble(cl2D.meanX(), h2D.meanX(), 1.0);
            AidaTestCase.assertEqualsDouble(cl2D.meanY(), h2D.meanY(), 1.0);
            AidaTestCase.assertEqualsDouble(cl3D.meanX(), h3D.meanX(), 1.0);
            AidaTestCase.assertEqualsDouble(cl3D.meanY(), h3D.meanY(), 1.0);
            AidaTestCase.assertEqualsDouble(cl3D.meanZ(), h3D.meanZ(), 1.0);
            AidaTestCase.assertEqualsDouble(cl1D.rms(), h1D.rms(), 1.0);
            AidaTestCase.assertEqualsDouble(cl2D.rmsX(), h2D.rmsX(), 1.0);
            AidaTestCase.assertEqualsDouble(cl2D.rmsY(), h2D.rmsY(), 1.0);
            AidaTestCase.assertEqualsDouble(cl3D.rmsX(), h3D.rmsX(), 1.0);
            AidaTestCase.assertEqualsDouble(cl3D.rmsY(), h3D.rmsY(), 1.0);
            AidaTestCase.assertEqualsDouble(cl3D.rmsZ(), h3D.rmsZ(), 1.0);
        }
        Assert.assertEquals(entries, cl1D.entries());
        Assert.assertEquals(entries, h1D.allEntries());
        Assert.assertEquals(entries, cl2D.entries());
        Assert.assertEquals(entries, h2D.allEntries());
        Assert.assertEquals(entries, cl3D.entries());
        Assert.assertEquals(entries, h3D.allEntries());
        cl1D.fill(Double.NaN);
        cl2D.fill(1.0, 0.0, Double.NaN);
        cl3D.fill(1.0, Double.NaN, 3.0, 0.7);
        Assert.assertEquals(cl1D.nanEntries(), 1);
        Assert.assertEquals(cl2D.nanEntries(), 1);
        Assert.assertEquals(cl3D.nanEntries(), 1);
        IHistogram1D convertedH1D = cl1D.histogram();
        Assert.assertTrue(convertedH1D != null);
        Assert.assertEquals(convertedH1D.mean(), h1D.mean(), 0.0);
        Assert.assertEquals(convertedH1D.rms(), h1D.rms(), 0.0);
        IHistogram2D convertedH2D = cl2D.histogram();
        Assert.assertTrue(convertedH2D != null);
        Assert.assertEquals(convertedH2D.meanX(), h2D.meanX(), 0.0);
        Assert.assertEquals(convertedH2D.meanY(), h2D.meanY(), 0.0);
        Assert.assertEquals(convertedH2D.rmsX(), h2D.rmsX(), 0.0);
        Assert.assertEquals(convertedH2D.rmsY(), h2D.rmsY(), 0.0);
        IHistogram3D convertedH3D = cl3D.histogram();
        Assert.assertTrue(convertedH3D != null);
        Assert.assertEquals(convertedH3D.meanX(), h3D.meanX(), 0.0);
        Assert.assertEquals(convertedH3D.meanY(), h3D.meanY(), 0.0);
        Assert.assertEquals(convertedH3D.meanZ(), h3D.meanZ(), 0.0);
        Assert.assertEquals(convertedH3D.rmsX(), h3D.rmsX(), 0.0);
        Assert.assertEquals(convertedH3D.rmsY(), h3D.rmsY(), 0.0);
        Assert.assertEquals(convertedH3D.rmsZ(), h3D.rmsZ(), 0.0);
        cl1D.reset();
        cl2D.reset();
        cl3D.reset();
        Assert.assertEquals(cl1D.entries(), 0);
        Assert.assertEquals(cl2D.entries(), 0);
        Assert.assertEquals(cl3D.entries(), 0);
    }

    public void testCloudScale() {
        double w;
        double zval;
        double yval;
        double xval;
        int i;
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ICloud1D cl1DScaled = hf.createCloud1D("cl1DScaled", this.cloud1Dtitle, -1, this.cloud1DOpts);
        ICloud2D cl2DScaled = hf.createCloud2D("cl2DScaled", this.cloud2Dtitle, -1, this.cloud2DOpts);
        ICloud3D cl3DScaled = hf.createCloud3D("cl3DScaled", this.cloud3Dtitle, -1, this.cloud3DOpts);
        ICloud1D cl1DNotScaled = hf.createCloud1D("cl1DScaled", this.cloud1Dtitle, -1, this.cloud1DOpts);
        ICloud2D cl2DNotScaled = hf.createCloud2D("cl2DScaled", this.cloud2Dtitle, -1, this.cloud2DOpts);
        ICloud3D cl3DNotScaled = hf.createCloud3D("cl3DScaled", this.cloud3Dtitle, -1, this.cloud3DOpts);
        double scale1D = 0.8;
        double scale2D = 3.5;
        double scale3D = 0.001;
        Random r = this.getRandomNumberGenerator();
        for (i = 0; i < 40; ++i) {
            xval = r.nextGaussian();
            yval = r.nextGaussian();
            zval = r.nextGaussian();
            w = r.nextDouble();
            cl1DScaled.fill(xval, w * scale1D);
            cl1DNotScaled.fill(xval, w);
            cl2DScaled.fill(xval, yval, w * scale2D);
            cl2DNotScaled.fill(xval, yval, w);
            cl3DScaled.fill(xval, yval, zval, w * scale3D);
            cl3DNotScaled.fill(xval, yval, zval, w);
        }
        cl1DNotScaled.scale(scale1D);
        cl2DNotScaled.scale(scale2D);
        cl3DNotScaled.scale(scale3D);
        AidaTestCase.assertEquals(cl1DNotScaled, cl1DScaled);
        AidaTestCase.assertEquals(cl2DNotScaled, cl2DScaled);
        AidaTestCase.assertEquals(cl3DNotScaled, cl3DScaled);
        for (i = 0; i < 50; ++i) {
            xval = r.nextGaussian();
            yval = r.nextGaussian();
            zval = r.nextGaussian();
            w = r.nextDouble();
            cl1DScaled.fill(xval, w);
            cl1DNotScaled.fill(xval, w);
            cl2DScaled.fill(xval, yval, w);
            cl2DNotScaled.fill(xval, yval, w);
            cl3DScaled.fill(xval, yval, zval, w);
            cl3DNotScaled.fill(xval, yval, zval, w);
        }
        AidaTestCase.assertEquals(cl1DNotScaled, cl1DScaled);
        AidaTestCase.assertEquals(cl2DNotScaled, cl2DScaled);
        AidaTestCase.assertEquals(cl3DNotScaled, cl3DScaled);
    }

    public void testCloudCopy() throws IOException {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree1 = tf.create();
        IHistogramFactory hf1 = af.createHistogramFactory(tree1);
        ITree tree2 = tf.create();
        IHistogramFactory hf2 = af.createHistogramFactory(tree2);
        ICloud1D cl1Da = hf1.createCloud1D("cl1Da", "Cloud1d Not Converted", this.maxEntries, "");
        ICloud1D cl1Db = hf1.createCloud1D("cl1Db", "Cloud1D Converted", 5, "");
        ICloud2D cl2Da = hf1.createCloud2D("cl2Da", "Cloud2D Not Converted", this.maxEntries, this.cloud2DOpts);
        ICloud2D cl2Db = hf1.createCloud2D("cl2Db", "Cloud2D Converted", 5, this.cloud2DOpts);
        ICloud3D cl3Da = hf1.createCloud3D("cl3Da", "Cloud3D Not Converted", this.maxEntries, this.cloud3DOpts);
        ICloud3D cl3Db = hf1.createCloud3D("cl3Db", "Cloud3D Converted", 5, this.cloud3DOpts);
        int entries = 37;
        for (int i = 0; i < entries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            if (w < r.nextDouble()) {
                cl1Da.fill(xval, w);
                cl1Db.fill(xval, w);
                cl2Da.fill(xval, yval, w);
                cl2Db.fill(xval, yval, w);
                cl3Da.fill(xval, yval, zval, w);
                cl3Db.fill(xval, yval, zval, w);
                continue;
            }
            cl1Da.fill(xval);
            cl1Db.fill(xval);
            cl2Da.fill(xval, yval);
            cl2Db.fill(xval, yval);
            cl3Da.fill(xval, yval, zval);
            cl3Db.fill(xval, yval, zval);
        }
        ICloud1D cl1DaNew = hf2.createCopy("cl1Da", cl1Da);
        ICloud2D cl2DaNew = hf2.createCopy("cl2Da", cl2Da);
        ICloud3D cl3DaNew = hf2.createCopy("cl3Da", cl3Da);
        ICloud1D cl1DbNew = hf2.createCopy("cl1Db", cl1Db);
        ICloud2D cl2DbNew = hf2.createCopy("cl2Db", cl2Db);
        ICloud3D cl3DbNew = hf2.createCopy("cl3Db", cl3Db);
        AidaTestCase.assertEquals(cl1Da, cl1DaNew);
        AidaTestCase.assertEquals(cl1Db, cl1DbNew);
        AidaTestCase.assertEquals(cl2Da, cl2DaNew);
        AidaTestCase.assertEquals(cl2Db, cl2DbNew);
        AidaTestCase.assertEquals(cl3Da, cl3DaNew);
        AidaTestCase.assertEquals(cl3Db, cl3DbNew);
    }
}

