/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml;

import hep.aida.ref.xml.AidaBinaryHandler;
import hep.aida.ref.xml.binary.AidaWBXMLLookup;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.freehep.wbxml.Attributes;
import org.freehep.wbxml.ContentHandler;
import org.freehep.wbxml.WBXMLParser;
import org.xml.sax.SAXException;

public class AidaWBXMLParser
implements ContentHandler {
    private StringBuffer buffer;
    private AidaBinaryHandler handler;
    private Stack context;

    public AidaWBXMLParser(AidaBinaryHandler handler) {
        this.handler = handler;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(int tagID, Attributes attrs, boolean empty) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{new Integer(tagID), attrs});
        switch (tagID) {
            case 37: {
                this.handler.handle_item(attrs);
                break;
            }
            case 25: {
                this.handler.start_entries1d(attrs);
                break;
            }
            case 41: {
                this.handler.start_argument(attrs);
                break;
            }
            case 9: {
                this.handler.start_data1d(attrs);
                break;
            }
            case 10: {
                this.handler.handle_bin1d(attrs);
                break;
            }
            case 21: {
                this.handler.start_entryITuple(attrs);
                break;
            }
            case 17: {
                this.handler.handle_column(attrs);
                break;
            }
            case 15: {
                this.handler.start_tuple(attrs);
                break;
            }
            case 38: {
                this.handler.start_function(attrs);
                break;
            }
            case 16: {
                this.handler.start_columns(attrs);
                break;
            }
            case 33: {
                this.handler.start_dataPointSet(attrs);
                break;
            }
            case 34: {
                this.handler.start_dataPoint(attrs);
                break;
            }
            case 1: {
                this.handler.handle_implementation(attrs);
                break;
            }
            case 28: {
                this.handler.handle_entry1d(attrs);
                break;
            }
            case 22: {
                this.handler.start_cloud1d(attrs);
                break;
            }
            case 19: {
                this.handler.start_row(attrs);
                break;
            }
            case 36: {
                this.handler.start_annotation(attrs);
                break;
            }
            case 30: {
                this.handler.handle_entry3d(attrs);
                break;
            }
            case 4: {
                this.handler.start_histogram3d(attrs);
                break;
            }
            case 0: {
                this.handler.start_aida(attrs);
                break;
            }
            case 20: {
                this.handler.handle_entry(attrs);
                break;
            }
            case 11: {
                this.handler.start_data2d(attrs);
                break;
            }
            case 14: {
                this.handler.handle_bin3d(attrs);
                break;
            }
            case 44: {
                this.handler.handle_parameter(attrs);
                break;
            }
            case 40: {
                this.handler.start_arguments(attrs);
                break;
            }
            case 43: {
                this.handler.start_parameters(attrs);
                break;
            }
            case 18: {
                this.handler.start_rows(attrs);
                break;
            }
            case 2: {
                this.handler.start_histogram1d(attrs);
                break;
            }
            case 5: {
                this.handler.start_axis(attrs);
                break;
            }
            case 24: {
                this.handler.start_cloud3d(attrs);
                break;
            }
            case 6: {
                this.handler.handle_binBorder(attrs);
                break;
            }
            case 42: {
                this.handler.handle_range(attrs);
                break;
            }
            case 35: {
                this.handler.handle_measurement(attrs);
                break;
            }
            case 13: {
                this.handler.start_data3d(attrs);
                break;
            }
            case 29: {
                this.handler.handle_entry2d(attrs);
                break;
            }
            case 31: {
                this.handler.start_profile1d(attrs);
                break;
            }
            case 26: {
                this.handler.start_entries2d(attrs);
                break;
            }
            case 27: {
                this.handler.start_entries3d(attrs);
                break;
            }
            case 12: {
                this.handler.handle_bin2d(attrs);
                break;
            }
            case 7: {
                this.handler.start_statistics(attrs);
                break;
            }
            case 32: {
                this.handler.start_profile2d(attrs);
                break;
            }
            case 23: {
                this.handler.start_cloud2d(attrs);
                break;
            }
            case 8: {
                this.handler.handle_statistic(attrs);
                break;
            }
            case 3: {
                this.handler.start_histogram2d(attrs);
            }
        }
        if (empty) {
            this.dispatch(false);
            this.context.pop();
        }
    }

    public void endElement(int tagID) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        switch (tagID) {
            case 25: {
                this.handler.end_entries1d();
                break;
            }
            case 41: {
                this.handler.end_argument();
                break;
            }
            case 9: {
                this.handler.end_data1d();
                break;
            }
            case 21: {
                this.handler.end_entryITuple();
                break;
            }
            case 15: {
                this.handler.end_tuple();
                break;
            }
            case 38: {
                this.handler.end_function();
                break;
            }
            case 16: {
                this.handler.end_columns();
                break;
            }
            case 33: {
                this.handler.end_dataPointSet();
                break;
            }
            case 34: {
                this.handler.end_dataPoint();
                break;
            }
            case 22: {
                this.handler.end_cloud1d();
                break;
            }
            case 19: {
                this.handler.end_row();
                break;
            }
            case 36: {
                this.handler.end_annotation();
                break;
            }
            case 4: {
                this.handler.end_histogram3d();
                break;
            }
            case 0: {
                this.handler.end_aida();
                break;
            }
            case 11: {
                this.handler.end_data2d();
                break;
            }
            case 40: {
                this.handler.end_arguments();
                break;
            }
            case 43: {
                this.handler.end_parameters();
                break;
            }
            case 18: {
                this.handler.end_rows();
                break;
            }
            case 2: {
                this.handler.end_histogram1d();
                break;
            }
            case 5: {
                this.handler.end_axis();
                break;
            }
            case 24: {
                this.handler.end_cloud3d();
                break;
            }
            case 13: {
                this.handler.end_data3d();
                break;
            }
            case 31: {
                this.handler.end_profile1d();
                break;
            }
            case 26: {
                this.handler.end_entries2d();
                break;
            }
            case 27: {
                this.handler.end_entries3d();
                break;
            }
            case 7: {
                this.handler.end_statistics();
                break;
            }
            case 32: {
                this.handler.end_profile2d();
                break;
            }
            case 23: {
                this.handler.end_cloud2d();
                break;
            }
            case 3: {
                this.handler.end_histogram2d();
            }
        }
    }

    public void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        int here = (Integer)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        if (39 == here) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event!");
            }
            this.handler.handle_codelet(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputStream in) throws SAXException, IOException {
        WBXMLParser p = new WBXMLParser(this);
        p.parse(in);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: AidaWBXMLParser filename");
            System.exit(1);
        }
        AidaWBXMLParser handler = new AidaWBXMLParser(null){

            public void characters(char[] chars, int start, int len) throws SAXException {
                System.err.print("'" + String.valueOf(chars) + "'");
            }

            public void endDocument() throws SAXException {
                System.err.println("END DOCUMENT");
            }

            public void endElement(int tagID) throws SAXException {
                System.err.println("</" + AidaWBXMLLookup.getTagName(tagID) + ">");
            }

            public void startDocument() throws SAXException {
                System.err.println("START DOCUMENT");
            }

            public void startElement(int tagID, Attributes attr, boolean empty) throws SAXException {
                System.err.println("<" + AidaWBXMLLookup.getTagName(tagID));
                int[] tags = attr.getTags();
                block11: for (int i = 0; i < tags.length; ++i) {
                    switch (attr.getType(tags[i])) {
                        case 0: {
                            System.err.println("  " + AidaWBXMLLookup.getAttributeName(tags[i]) + "=" + attr.getBooleanValue(tags[i]));
                            continue block11;
                        }
                        case 1: {
                            System.err.println("  " + AidaWBXMLLookup.getAttributeName(tags[i]) + "=" + attr.getByteValue(tags[i]));
                            continue block11;
                        }
                        case 2: {
                            System.err.println("  " + AidaWBXMLLookup.getAttributeName(tags[i]) + "=" + attr.getCharValue(tags[i]));
                            continue block11;
                        }
                        case 3: {
                            System.err.println("  " + AidaWBXMLLookup.getAttributeName(tags[i]) + "=" + attr.getDoubleValue(tags[i]));
                            continue block11;
                        }
                        case 4: {
                            System.err.println("  " + AidaWBXMLLookup.getAttributeName(tags[i]) + "=" + attr.getFloatValue(tags[i]));
                            continue block11;
                        }
                        case 5: {
                            System.err.println("  " + AidaWBXMLLookup.getAttributeName(tags[i]) + "=" + attr.getIntValue(tags[i]));
                            continue block11;
                        }
                        case 6: {
                            System.err.println("  " + AidaWBXMLLookup.getAttributeName(tags[i]) + "=" + attr.getLongValue(tags[i]));
                            continue block11;
                        }
                        case 7: {
                            System.err.println("  " + AidaWBXMLLookup.getAttributeName(tags[i]) + "=" + attr.getShortValue(tags[i]));
                            continue block11;
                        }
                        case 8: {
                            System.err.println("  " + AidaWBXMLLookup.getAttributeName(tags[i]) + "=\"" + attr.getStringValue(tags[i]) + "\"");
                            continue block11;
                        }
                        default: {
                            System.err.println("Unhandled attribute type: " + attr.getType(tags[i]));
                        }
                    }
                }
                if (empty) {
                    System.err.print("/");
                }
                System.err.println(">");
            }
        };
        WBXMLParser p = new WBXMLParser(handler);
        p.parse(new FileInputStream(args[0]));
    }
}

