/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.converters;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IManagedObject;
import hep.aida.IProfile1D;
import hep.aida.ref.Annotation;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.remote.RemoteProfile1D;
import hep.aida.ref.remote.rmi.converters.RmiHist1DConverter;
import hep.aida.ref.remote.rmi.data.RmiAnnotationItem;
import hep.aida.ref.remote.rmi.data.RmiAxis;
import hep.aida.ref.remote.rmi.data.RmiHist1DData;
import java.text.DateFormat;
import java.util.Date;

public class RmiProfile1DConverter
extends RmiHist1DConverter {
    protected static RmiProfile1DConverter converter = null;

    public static RmiHist1DConverter getInstance() {
        if (converter == null) {
            converter = new RmiProfile1DConverter();
        }
        return converter;
    }

    protected RmiProfile1DConverter() {
        this.dataType = "RmiHist1DData";
        this.aidaType = "IProfile1D";
    }

    public Object createAidaObject(String name) {
        RemoteProfile1D result = new RemoteProfile1D(name);
        return result;
    }

    public Object extractData(Object aidaObject) {
        RmiHist1DData data = null;
        if (aidaObject instanceof IProfile1D) {
            data = this.createData((IProfile1D)aidaObject);
        } else if (aidaObject instanceof Object[] && ((Object[])aidaObject)[0] instanceof IProfile1D) {
            IProfile1D[] arr = new IProfile1D[((Object[])aidaObject).length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (IProfile1D)((Object[])aidaObject)[i];
            }
            data = this.createData(arr);
        } else {
            throw new IllegalArgumentException("Not supported data type: " + aidaObject.getClass().getName());
        }
        return data;
    }

    public boolean updateAidaObject(Object aidaObject, Object newData) {
        RmiHist1DData data = null;
        if (newData instanceof RmiHist1DData) {
            data = (RmiHist1DData)newData;
        }
        if (!(aidaObject instanceof RemoteProfile1D)) {
            throw new IllegalArgumentException("Not supported object type: " + aidaObject.getClass().getName());
        }
        if (data == null || !(data instanceof RmiHist1DData)) {
            throw new IllegalArgumentException("Not supported data type: " + (newData == null ? "null" : newData.getClass().getName()));
        }
        this.updateData((RemoteProfile1D)aidaObject, data);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IManagedObject updateData(RemoteProfile1D hist, RmiHist1DData data) {
        if (data == null) {
            return hist;
        }
        RemoteProfile1D remoteProfile1D = hist;
        synchronized (remoteProfile1D) {
            RmiAnnotationItem[] items;
            hist.setFillable(true);
            IAxis lAxis = hist.axis();
            RmiAxis rAxis = data.getAxis();
            int nBins = rAxis.bins();
            Object newAxis = null;
            if (lAxis == null || lAxis.bins() != nBins || lAxis.lowerEdge() != rAxis.lowerEdge() || lAxis.upperEdge() != rAxis.upperEdge()) {
                hist.setAxis(nBins, rAxis.lowerEdge(), rAxis.upperEdge());
            }
            if ((items = data.getAnnotationItems()) != null && items.length > 0) {
                boolean sticky = false;
                IAnnotation localAnnotation = hist.annotation();
                if (localAnnotation instanceof Annotation) {
                    ((Annotation)localAnnotation).setFillable(true);
                }
                for (int i = 0; i < items.length; ++i) {
                    String key = items[i].key;
                    String newValue = items[i].value;
                    String oldValue = null;
                    try {
                        oldValue = localAnnotation.value(key);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    if (oldValue == null) {
                        localAnnotation.addItem(key, newValue, sticky);
                        continue;
                    }
                    if (newValue.equals(oldValue)) continue;
                    localAnnotation.setValue(key, newValue);
                    localAnnotation.setSticky(key, sticky);
                }
                Date date = new Date();
                DateFormat df = DateFormat.getTimeInstance();
                String dateString = df.format(date);
                try {
                    String value = localAnnotation.value("stat.Updated");
                    if (value == null || value.equals("0") || value.equals("")) {
                        localAnnotation.setValue("stat.Updated", dateString);
                    }
                }
                catch (IllegalArgumentException e) {
                    localAnnotation.addItem("stat.Updated", dateString);
                }
                if (localAnnotation instanceof Annotation) {
                    ((Annotation)localAnnotation).setFillable(false);
                }
            }
            hist.setHeights(data.getBinHeights());
            hist.setErrors(data.getBinErrors());
            hist.setEntries(data.getBinEntries());
            hist.setMeans(data.getBinMeans());
            hist.setRmss(data.getBinRmss());
            hist.setEquivalentBinEntries(data.getEquivalentBinEntries());
            hist.setNanEntries(data.getNanEntries());
            hist.setMean(data.getMean());
            hist.setRms(data.getRms());
            hist.setFillable(false);
            hist.setDataValid(true);
        }
        return hist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmiHist1DData createData(IProfile1D hist) {
        RmiHist1DData data = new RmiHist1DData();
        RmiAxis rAxis = null;
        RmiAnnotationItem[] rAnnotation = null;
        int nanEntries = 0;
        double mean = Double.NaN;
        double rms = Double.NaN;
        int[] entries = null;
        double[] heights = null;
        double[] errors = null;
        double[] means = null;
        double[] rmss = null;
        IProfile1D iProfile1D = hist;
        synchronized (iProfile1D) {
            int i;
            IAxis lAxis = hist.axis();
            int nBins = lAxis.bins();
            rAxis = new RmiAxis(nBins, lAxis.lowerEdge(), lAxis.upperEdge());
            boolean sticky = false;
            IAnnotation lAnnotation = hist.annotation();
            if (lAnnotation != null && lAnnotation.size() > 0) {
                rAnnotation = new RmiAnnotationItem[lAnnotation.size()];
                for (i = 0; i < lAnnotation.size(); ++i) {
                    String key = lAnnotation.key(i);
                    String value = lAnnotation.value(key);
                    rAnnotation[i] = new RmiAnnotationItem(key, value, sticky);
                }
            }
            nanEntries = hist.nanEntries();
            mean = hist.mean();
            rms = hist.rms();
            if (nBins > 0) {
                entries = new int[nBins + 2];
                heights = new double[nBins + 2];
                errors = new double[nBins + 2];
                means = new double[nBins + 2];
                rmss = new double[nBins + 2];
                i = 0;
                for (i = 0; i < nBins; ++i) {
                    heights[i + 1] = hist.binHeight(i);
                    errors[i + 1] = hist.binError(i);
                    entries[i + 1] = hist.binEntries(i);
                    means[i + 1] = hist.binMean(i);
                    if (!(hist instanceof Histogram1D)) continue;
                    rmss[i + 1] = ((Histogram1D)((Object)hist)).binRms(i);
                }
                i = -2;
                int j = 0;
                heights[j] = hist.binHeight(i);
                errors[j] = hist.binError(i);
                entries[j] = hist.binEntries(i);
                means[j] = hist.binMean(i);
                if (hist instanceof Histogram1D) {
                    rmss[j] = ((Histogram1D)((Object)hist)).binRms(i);
                }
                i = -1;
                j = nBins + 1;
                heights[j] = hist.binHeight(i);
                errors[j] = hist.binError(i);
                entries[j] = hist.binEntries(i);
                means[j] = hist.binMean(i);
                if (hist instanceof Histogram1D) {
                    rmss[j] = ((Histogram1D)((Object)hist)).binRms(i);
                }
            }
        }
        data.setAxis(rAxis);
        data.setAnnotationItems(rAnnotation);
        data.setBinHeights(heights);
        data.setBinErrors(errors);
        data.setBinEntries(entries);
        data.setBinMeans(means);
        data.setBinRmss(rmss);
        data.setNanEntries(nanEntries);
        data.setMean(mean);
        data.setRms(rms);
        return data;
    }

    public RmiHist1DData createData(IProfile1D[] arr) {
        RmiHist1DData[] allData = new RmiHist1DData[arr.length];
        for (int i = 0; i < allData.length; ++i) {
            allData[i] = this.createData(arr[i]);
        }
        RmiHist1DData data = new RmiHist1DData();
        data.setAxis(allData[0].getAxis());
        data.setAnnotationItems(allData[0].getAnnotationItems());
        double mean = 0.0;
        int nanEntries = 0;
        double rms = 0.0;
        double[] sumBinHeights = new double[allData.length];
        int nBins = data.getAxis().bins();
        int[] entries = new int[nBins + 2];
        double[] heights = new double[nBins + 2];
        double[] errors = new double[nBins + 2];
        double[] means = new double[nBins + 2];
        double[] rmss = new double[nBins + 2];
        for (int ii = 0; ii < nBins + 2; ++ii) {
            for (int i = 0; i < allData.length; ++i) {
                double h = allData[i].getBinHeights()[ii];
                if (ii > 0 && ii < nBins + 1) {
                    int n = i;
                    sumBinHeights[n] = sumBinHeights[n] + h;
                }
                int n = ii;
                heights[n] = heights[n] + h;
                int n2 = ii;
                entries[n2] = entries[n2] + allData[i].getBinEntries()[ii];
                int n3 = ii;
                errors[n3] = errors[n3] + Math.pow(allData[i].getBinErrors()[ii], 2.0);
                int n4 = ii;
                means[n4] = means[n4] + allData[i].getBinMeans()[ii] * h;
                int n5 = ii;
                rmss[n5] = rmss[n5] + (Math.pow(allData[i].getBinRmss()[ii], 2.0) + Math.pow(allData[i].getBinMeans()[ii], 2.0)) * h;
            }
            errors[ii] = Math.sqrt(errors[ii]);
            means[ii] = means[ii] / heights[ii];
            rmss[ii] = Math.sqrt(rmss[ii] / heights[ii] - means[ii] * means[ii]);
        }
        data.setBinHeights(heights);
        data.setBinErrors(errors);
        data.setBinEntries(entries);
        data.setBinMeans(means);
        data.setBinRmss(rmss);
        double sh = 0.0;
        for (int i = 0; i < allData.length; ++i) {
            sh += sumBinHeights[i];
            mean += allData[i].getMean() * sumBinHeights[i];
            rms += (Math.pow(allData[i].getRms(), 2.0) + Math.pow(allData[i].getMean(), 2.0)) * sumBinHeights[i];
            nanEntries += allData[i].getNanEntries();
        }
        rms = Math.sqrt(rms / sh - (mean /= sh) * mean);
        data.setMean(mean);
        data.setNanEntries(nanEntries);
        data.setRms(rms);
        return data;
    }
}

