/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.converters;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IHistogram2D;
import hep.aida.IManagedObject;
import hep.aida.ref.Annotation;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.remote.RemoteHistogram2D;
import hep.aida.ref.remote.rmi.converters.RmiConverter;
import hep.aida.ref.remote.rmi.data.RmiAnnotationItem;
import hep.aida.ref.remote.rmi.data.RmiAxis;
import hep.aida.ref.remote.rmi.data.RmiHist2DData;
import java.text.DateFormat;
import java.util.Date;

public class RmiHist2DConverter
extends RmiConverter {
    private static RmiHist2DConverter converter = null;

    public static RmiHist2DConverter getInstance() {
        if (converter == null) {
            converter = new RmiHist2DConverter();
        }
        return converter;
    }

    private RmiHist2DConverter() {
        this.dataType = "RmiHist2DData";
        this.aidaType = "IHistogram2D";
    }

    public Object createAidaObject(String name) {
        RemoteHistogram2D result = new RemoteHistogram2D(name);
        return result;
    }

    public Object extractData(Object aidaObject) {
        RmiHist2DData data = null;
        if (aidaObject instanceof RemoteHistogram2D) {
            data = this.createRemoteData((RemoteHistogram2D)aidaObject);
        } else if (aidaObject instanceof IHistogram2D) {
            data = this.createData((IHistogram2D)aidaObject);
        } else if (aidaObject instanceof Object[] && ((Object[])aidaObject)[0] instanceof IHistogram2D) {
            IHistogram2D[] arr = new IHistogram2D[((Object[])aidaObject).length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (IHistogram2D)((Object[])aidaObject)[i];
            }
            data = this.createData(arr);
        } else {
            throw new IllegalArgumentException("Not supported data type: " + aidaObject.getClass().getName());
        }
        return data;
    }

    public boolean updateAidaObject(Object aidaObject, Object newData) {
        RmiHist2DData data = null;
        if (newData instanceof RmiHist2DData) {
            data = (RmiHist2DData)newData;
        }
        if (!(aidaObject instanceof RemoteHistogram2D)) {
            throw new IllegalArgumentException("Not supported object type: " + aidaObject.getClass().getName());
        }
        if (data == null || !(data instanceof RmiHist2DData)) {
            throw new IllegalArgumentException("Not supported data type: " + (newData == null ? "null" : newData.getClass().getName()));
        }
        this.updateData((RemoteHistogram2D)aidaObject, data);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IManagedObject updateData(RemoteHistogram2D hist, RmiHist2DData data) {
        if (data == null) {
            return hist;
        }
        RemoteHistogram2D remoteHistogram2D = hist;
        synchronized (remoteHistogram2D) {
            RmiAnnotationItem[] items;
            hist.setFillable(true);
            IAxis lXAxis = hist.xAxis();
            RmiAxis rXAxis = data.getXAxis();
            int nXBins = rXAxis.bins();
            if (lXAxis == null || lXAxis.bins() != nXBins || lXAxis.lowerEdge() != rXAxis.lowerEdge() || lXAxis.upperEdge() != rXAxis.upperEdge()) {
                hist.setXAxis(nXBins, rXAxis.lowerEdge(), rXAxis.upperEdge());
            }
            IAxis lYAxis = hist.yAxis();
            RmiAxis rYAxis = data.getYAxis();
            int nYBins = rYAxis.bins();
            if (lYAxis == null || lYAxis.bins() != nYBins || lYAxis.lowerEdge() != rYAxis.lowerEdge() || lYAxis.upperEdge() != rYAxis.upperEdge()) {
                hist.setYAxis(nYBins, rYAxis.lowerEdge(), rYAxis.upperEdge());
            }
            if ((items = data.getAnnotationItems()) != null && items.length > 0) {
                boolean sticky = false;
                IAnnotation localAnnotation = hist.annotation();
                if (localAnnotation instanceof Annotation) {
                    ((Annotation)localAnnotation).setFillable(true);
                }
                for (int i = 0; i < items.length; ++i) {
                    String key = items[i].key;
                    String newValue = items[i].value;
                    String oldValue = null;
                    try {
                        oldValue = localAnnotation.value(key);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    if (oldValue == null) {
                        localAnnotation.addItem(key, newValue, sticky);
                        continue;
                    }
                    if (newValue.equals(oldValue)) continue;
                    localAnnotation.setValue(key, newValue);
                    localAnnotation.setSticky(key, sticky);
                }
                Date date = new Date();
                DateFormat df = DateFormat.getTimeInstance();
                String dateString = df.format(date);
                try {
                    String value = localAnnotation.value("stat.Updated");
                    if (value == null || value.equals("0") || value.equals("")) {
                        localAnnotation.setValue("stat.Updated", dateString);
                    }
                }
                catch (IllegalArgumentException e) {
                    localAnnotation.addItem("stat.Updated", dateString);
                }
                if (localAnnotation instanceof Annotation) {
                    ((Annotation)localAnnotation).setFillable(false);
                }
            }
            hist.setHeights(data.getBinHeights());
            hist.setErrors(data.getBinErrors());
            hist.setEntries(data.getBinEntries());
            hist.setBinMeansX(data.getBinMeansX());
            hist.setBinRmssX(data.getBinRmssX());
            hist.setBinMeansY(data.getBinMeansY());
            hist.setBinRmssY(data.getBinRmssY());
            hist.setBinEntriesX(data.getBinEntriesX());
            hist.setBinEntriesY(data.getBinEntriesY());
            hist.setBinHeightsX(data.getBinHeightsX());
            hist.setBinHeightsY(data.getBinHeightsY());
            hist.setMeanX(data.getMeanX());
            hist.setRmsX(data.getRmsX());
            hist.setMeanY(data.getMeanY());
            hist.setRmsY(data.getRmsY());
            hist.setEquivalentBinEntries(data.getEquivalentBinEntries());
            hist.setNanEntries(data.getNanEntries());
            hist.setInRangeEntries(data.getInRangeEntries());
            hist.setExtraEntries(data.getExtraEntries());
            hist.setMinBinEntries(data.getMinBinEntries());
            hist.setMaxBinEntries(data.getMaxBinEntries());
            hist.setInRangeBinHeights(data.getInRangeBinHeights());
            hist.setExtraBinHeights(data.getExtraBinHeights());
            hist.setMinBinHeights(data.getMinBinHeights());
            hist.setMaxBinHeights(data.getMaxBinHeights());
            hist.setFillable(false);
            hist.setDataValid(false);
            hist.setDataValid(true);
        }
        return hist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmiHist2DData createData(IHistogram2D hist) {
        RmiHist2DData data = new RmiHist2DData();
        RmiAxis rXAxis = null;
        RmiAxis rYAxis = null;
        RmiAnnotationItem[] rAnnotation = null;
        double meanX = Double.NaN;
        double rmsX = Double.NaN;
        double meanY = Double.NaN;
        double rmsY = Double.NaN;
        double equivalentBinEntries = 0.0;
        int nanEntries = 0;
        int inRangeEntries = 0;
        int extraEntries = 0;
        int minBinEntries = 0;
        int maxBinEntries = 0;
        double inRangeBinHeights = 0.0;
        double extraBinHeights = 0.0;
        double minBinHeights = 0.0;
        double maxBinHeights = 0.0;
        int[][] entries = null;
        double[][] heights = null;
        double[][] errors = null;
        double[][] rmss = null;
        double[][] meansX = null;
        double[][] rmssX = null;
        double[][] meansY = null;
        double[][] rmssY = null;
        int[] binEntriesX = null;
        int[] binEntriesY = null;
        double[] binHeightsX = null;
        double[] binHeightsY = null;
        IHistogram2D iHistogram2D = hist;
        synchronized (iHistogram2D) {
            IAxis lXAxis = hist.xAxis();
            int nXBins = lXAxis.bins();
            rXAxis = new RmiAxis(nXBins, lXAxis.lowerEdge(), lXAxis.upperEdge());
            IAxis lYAxis = hist.yAxis();
            int nYBins = lYAxis.bins();
            rYAxis = new RmiAxis(nYBins, lYAxis.lowerEdge(), lYAxis.upperEdge());
            boolean sticky = false;
            IAnnotation lAnnotation = hist.annotation();
            if (lAnnotation != null && lAnnotation.size() > 0) {
                rAnnotation = new RmiAnnotationItem[lAnnotation.size()];
                for (int i = 0; i < lAnnotation.size(); ++i) {
                    String key = lAnnotation.key(i);
                    String value = lAnnotation.value(key);
                    rAnnotation[i] = new RmiAnnotationItem(key, value, sticky);
                }
            }
            if (nXBins > 0 && nYBins > 0) {
                int i;
                entries = new int[nXBins + 2][nYBins + 2];
                heights = new double[nXBins + 2][nYBins + 2];
                errors = new double[nXBins + 2][nYBins + 2];
                meansX = new double[nXBins + 2][nYBins + 2];
                rmssX = new double[nXBins + 2][nYBins + 2];
                meansY = new double[nXBins + 2][nYBins + 2];
                rmssY = new double[nXBins + 2][nYBins + 2];
                binEntriesX = new int[nXBins + 2];
                binEntriesY = new int[nYBins + 2];
                binHeightsX = new double[nXBins + 2];
                binHeightsY = new double[nYBins + 2];
                minBinEntries = Integer.MAX_VALUE;
                maxBinEntries = Integer.MIN_VALUE;
                minBinHeights = Double.MAX_VALUE;
                maxBinHeights = Double.MIN_VALUE;
                int ii = 0;
                int jj = 0;
                for (i = 0; i < nXBins + 2; ++i) {
                    for (int j = 0; j < nYBins + 2; ++j) {
                        ii = this.convertToAIDAIndex(nXBins, i);
                        jj = this.convertToAIDAIndex(nYBins, j);
                        double h = hist.binHeight(ii, jj);
                        int e = hist.binEntries(ii, jj);
                        if (ii != -1 && ii != -2 && jj != -1 && jj != -2) {
                            if (e > maxBinEntries) {
                                maxBinEntries = e;
                            }
                            if (e < minBinEntries) {
                                minBinEntries = e;
                            }
                            if (h > maxBinHeights) {
                                maxBinHeights = h;
                            }
                            if (h < minBinHeights) {
                                minBinHeights = h;
                            }
                        }
                        heights[i][j] = h;
                        entries[i][j] = e;
                        errors[i][j] = hist.binError(ii, jj);
                        meansX[i][j] = hist.binMeanX(ii, jj);
                        meansY[i][j] = hist.binMeanY(ii, jj);
                        if (!(hist instanceof Histogram2D)) continue;
                        rmssX[i][j] = ((Histogram2D)hist).binRmsX(ii, jj);
                        rmssY[i][j] = ((Histogram2D)hist).binRmsY(ii, jj);
                    }
                }
                for (i = 0; i < nXBins + 2; ++i) {
                    ii = this.convertToAIDAIndex(nXBins, i);
                    binEntriesX[i] = hist.binEntriesX(ii);
                    binHeightsX[i] = hist.binHeightX(ii);
                }
                for (int j = 0; j < nYBins + 2; ++j) {
                    jj = this.convertToAIDAIndex(nYBins, j);
                    binEntriesY[j] = hist.binEntriesY(jj);
                    binHeightsY[j] = hist.binHeightY(jj);
                }
            }
            meanX = hist.meanX();
            rmsX = hist.rmsX();
            meanY = hist.meanY();
            rmsY = hist.rmsY();
            equivalentBinEntries = hist.equivalentBinEntries();
            nanEntries = hist.nanEntries();
            extraEntries = hist.extraEntries();
            inRangeEntries = hist.entries();
            extraBinHeights = hist.sumExtraBinHeights();
            inRangeBinHeights = hist.sumAllBinHeights() - extraBinHeights;
            minBinHeights = hist.minBinHeight();
            maxBinHeights = hist.maxBinHeight();
        }
        data.setXAxis(rXAxis);
        data.setYAxis(rYAxis);
        data.setAnnotationItems(rAnnotation);
        data.setBinHeights(heights);
        data.setBinErrors(errors);
        data.setBinEntries(entries);
        data.setBinMeansX(meansX);
        data.setBinRmssX(rmssX);
        data.setBinMeansY(meansY);
        data.setBinRmssY(rmssY);
        data.setBinEntriesX(binEntriesX);
        data.setBinEntriesY(binEntriesY);
        data.setBinHeightsX(binHeightsX);
        data.setBinHeightsY(binHeightsY);
        data.setMeanX(meanX);
        data.setRmsX(rmsX);
        data.setMeanY(meanY);
        data.setRmsY(rmsY);
        data.setEquivalentBinEntries(equivalentBinEntries);
        data.setNanEntries(nanEntries);
        data.setInRangeEntries(inRangeEntries);
        data.setExtraEntries(extraEntries);
        data.setMinBinEntries(minBinEntries);
        data.setMaxBinEntries(maxBinEntries);
        data.setInRangeBinHeights(inRangeBinHeights);
        data.setExtraBinHeights(extraBinHeights);
        data.setMinBinHeights(minBinHeights);
        data.setMaxBinHeights(maxBinHeights);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmiHist2DData createRemoteData(RemoteHistogram2D hist) {
        RmiHist2DData data = new RmiHist2DData();
        RmiAxis rXAxis = null;
        RmiAxis rYAxis = null;
        RmiAnnotationItem[] rAnnotation = null;
        double meanX = Double.NaN;
        double rmsX = Double.NaN;
        double meanY = Double.NaN;
        double rmsY = Double.NaN;
        double equivalentBinEntries = 0.0;
        int nanEntries = 0;
        int inRangeEntries = 0;
        int extraEntries = 0;
        int minBinEntries = 0;
        int maxBinEntries = 0;
        double inRangeBinHeights = 0.0;
        double extraBinHeights = 0.0;
        double minBinHeights = 0.0;
        double maxBinHeights = 0.0;
        int[][] entries = null;
        double[][] heights = null;
        double[][] errors = null;
        double[][] rmss = null;
        double[][] meansX = null;
        double[][] rmssX = null;
        double[][] meansY = null;
        double[][] rmssY = null;
        int[] binEntriesX = null;
        int[] binEntriesY = null;
        double[] binHeightsX = null;
        double[] binHeightsY = null;
        RemoteHistogram2D remoteHistogram2D = hist;
        synchronized (remoteHistogram2D) {
            int i;
            IAxis lXAxis = hist.xAxis();
            int nXBins = lXAxis.bins();
            rXAxis = new RmiAxis(nXBins, lXAxis.lowerEdge(), lXAxis.upperEdge());
            IAxis lYAxis = hist.yAxis();
            int nYBins = lYAxis.bins();
            rYAxis = new RmiAxis(nYBins, lYAxis.lowerEdge(), lYAxis.upperEdge());
            boolean sticky = false;
            IAnnotation lAnnotation = hist.annotation();
            if (lAnnotation != null && lAnnotation.size() > 0) {
                rAnnotation = new RmiAnnotationItem[lAnnotation.size()];
                for (i = 0; i < lAnnotation.size(); ++i) {
                    String key = lAnnotation.key(i);
                    String value = lAnnotation.value(key);
                    rAnnotation[i] = new RmiAnnotationItem(key, value, sticky);
                }
            }
            if (nXBins > 0 && nYBins > 0) {
                if (hist.getBinEntries() != null) {
                    entries = new int[nXBins + 2][nYBins + 2];
                }
                if (hist.getBinHeights() != null) {
                    heights = new double[nXBins + 2][nYBins + 2];
                }
                if (hist.getBinErrors() != null) {
                    errors = new double[nXBins + 2][nYBins + 2];
                }
                if (hist.getBinMeansX() != null) {
                    meansX = new double[nXBins + 2][nYBins + 2];
                }
                if (hist.getBinRmssX() != null) {
                    rmssX = new double[nXBins + 2][nYBins + 2];
                }
                if (hist.getBinMeansY() != null) {
                    meansY = new double[nXBins + 2][nYBins + 2];
                }
                if (hist.getBinRmssY() != null) {
                    rmssY = new double[nXBins + 2][nYBins + 2];
                }
                if (hist.getBinEntriesX() != null) {
                    binEntriesX = new int[nXBins + 2];
                }
                if (hist.getBinEntriesY() != null) {
                    binEntriesY = new int[nYBins + 2];
                }
                if (hist.getBinHeightsX() != null) {
                    binHeightsX = new double[nXBins + 2];
                }
                if (hist.getBinHeightsY() != null) {
                    binHeightsY = new double[nYBins + 2];
                }
                for (i = 0; i < nXBins + 2; ++i) {
                    if (hist.getBinEntries() != null) {
                        System.arraycopy(hist.getBinEntries()[i], 0, entries[i], 0, entries[i].length);
                    }
                    if (hist.getBinHeights() != null) {
                        System.arraycopy(hist.getBinHeights()[i], 0, heights[i], 0, heights[i].length);
                    }
                    if (hist.getBinErrors() != null) {
                        System.arraycopy(hist.getBinErrors()[i], 0, errors[i], 0, errors[i].length);
                    }
                    if (hist.getBinMeansX() != null) {
                        System.arraycopy(hist.getBinMeansX()[i], 0, meansX[i], 0, meansX[i].length);
                    }
                    if (hist.getBinRmssX() != null) {
                        System.arraycopy(hist.getBinRmssX()[i], 0, rmssX[i], 0, rmssX[i].length);
                    }
                    if (hist.getBinMeansY() != null) {
                        System.arraycopy(hist.getBinMeansY()[i], 0, meansY[i], 0, meansY[i].length);
                    }
                    if (hist.getBinRmssY() == null) continue;
                    System.arraycopy(hist.getBinRmssY()[i], 0, rmssY[i], 0, rmssY[i].length);
                }
                if (hist.getBinEntriesX() != null) {
                    System.arraycopy(hist.getBinEntriesX(), 0, binEntriesX, 0, binEntriesX.length);
                }
                if (hist.getBinEntriesY() != null) {
                    System.arraycopy(hist.getBinEntriesY(), 0, binEntriesY, 0, binEntriesY.length);
                }
                if (hist.getBinHeightsX() != null) {
                    System.arraycopy(hist.getBinHeightsX(), 0, binHeightsX, 0, binHeightsX.length);
                }
                if (hist.getBinHeightsY() != null) {
                    System.arraycopy(hist.getBinHeightsY(), 0, binHeightsY, 0, binHeightsY.length);
                }
                meanX = hist.meanX();
                rmsX = hist.rmsX();
                meanY = hist.meanY();
                rmsY = hist.rmsY();
                equivalentBinEntries = hist.equivalentBinEntries();
                nanEntries = hist.nanEntries();
                extraEntries = hist.extraEntries();
                inRangeEntries = hist.entries();
                minBinEntries = hist.getMinBinEntries();
                maxBinEntries = hist.getMinBinEntries();
                extraBinHeights = hist.sumExtraBinHeights();
                inRangeBinHeights = hist.sumAllBinHeights() - extraBinHeights;
                minBinHeights = hist.minBinHeight();
                maxBinHeights = hist.maxBinHeight();
            }
        }
        data.setXAxis(rXAxis);
        data.setYAxis(rYAxis);
        data.setAnnotationItems(rAnnotation);
        data.setBinHeights(heights);
        data.setBinErrors(errors);
        data.setBinEntries(entries);
        data.setBinMeansX(meansX);
        data.setBinRmssX(rmssX);
        data.setBinMeansY(meansY);
        data.setBinRmssY(rmssY);
        data.setBinEntriesX(binEntriesX);
        data.setBinEntriesY(binEntriesY);
        data.setBinHeightsX(binHeightsX);
        data.setBinHeightsY(binHeightsY);
        data.setMeanX(meanX);
        data.setRmsX(rmsX);
        data.setMeanY(meanY);
        data.setRmsY(rmsY);
        data.setEquivalentBinEntries(equivalentBinEntries);
        data.setNanEntries(nanEntries);
        data.setInRangeEntries(inRangeEntries);
        data.setExtraEntries(extraEntries);
        data.setMinBinEntries(minBinEntries);
        data.setMaxBinEntries(maxBinEntries);
        data.setInRangeBinHeights(inRangeBinHeights);
        data.setExtraBinHeights(extraBinHeights);
        data.setMinBinHeights(minBinHeights);
        data.setMaxBinHeights(maxBinHeights);
        return data;
    }

    public RmiHist2DData createData(IHistogram2D[] arr) {
        int k;
        int ii;
        RmiHist2DData[] allData = new RmiHist2DData[arr.length];
        for (int i = 0; i < allData.length; ++i) {
            allData[i] = arr[i] instanceof RemoteHistogram2D ? this.createRemoteData((RemoteHistogram2D)arr[i]) : this.createData(arr[i]);
        }
        RmiHist2DData data = new RmiHist2DData();
        int nXBins = allData[0].getBinHeightsX().length;
        int nYBins = allData[0].getBinHeightsY().length;
        double[] sumBinHeights = new double[allData.length];
        double meanX = 0.0;
        double rmsX = 0.0;
        double meanY = 0.0;
        double rmsY = 0.0;
        int inRangeEntries = 0;
        int extraEntries = 0;
        double equivalentBinEntries = 0.0;
        double inRangeBinHeights = 0.0;
        double extraBinHeights = 0.0;
        double minBinHeights = Double.POSITIVE_INFINITY;
        double maxBinHeights = Double.NEGATIVE_INFINITY;
        double h = 0.0;
        for (int k2 = 0; k2 < allData.length; ++k2) {
            inRangeBinHeights += (h += allData[k2].getInRangeBinHeights());
            inRangeEntries += allData[k2].getInRangeEntries();
            extraEntries += allData[k2].getExtraEntries();
            equivalentBinEntries += allData[k2].getEquivalentBinEntries();
            extraBinHeights += allData[k2].getExtraBinHeights();
            if (allData[k2].getMinBinHeights() < minBinHeights) {
                minBinHeights = allData[k2].getMinBinHeights();
            }
            if (allData[k2].getMaxBinHeights() > maxBinHeights) {
                maxBinHeights = allData[k2].getMaxBinHeights();
            }
            meanX += allData[k2].getMeanX() * h;
            meanY += allData[k2].getMeanY() * h;
            rmsX += (Math.pow(allData[k2].getRmsX(), 2.0) + Math.pow(allData[k2].getMeanX(), 2.0)) * h;
            rmsY += (Math.pow(allData[k2].getRmsY(), 2.0) + Math.pow(allData[k2].getMeanY(), 2.0)) * h;
        }
        rmsX = Math.sqrt(rmsX / inRangeBinHeights - (meanX /= inRangeBinHeights) * meanX);
        rmsY = Math.sqrt(rmsY / inRangeBinHeights - (meanY /= inRangeBinHeights) * meanY);
        int[][] entries = new int[nXBins][nYBins];
        double[][] heights = new double[nXBins][nYBins];
        double[][] errors = new double[nXBins][nYBins];
        double[][] meansX = new double[nXBins][nYBins];
        double[][] rmssX = new double[nXBins][nYBins];
        double[][] meansY = new double[nXBins][nYBins];
        double[][] rmssY = new double[nXBins][nYBins];
        int[] binEntriesX = new int[nXBins];
        int[] binEntriesY = new int[nYBins];
        double[] binHeightsX = new double[nXBins];
        double[] binHeightsY = new double[nYBins];
        for (ii = 0; ii < nXBins; ++ii) {
            for (int jj = 0; jj < nYBins; ++jj) {
                for (int k3 = 0; k3 < allData.length; ++k3) {
                    h = allData[k3].getBinHeights()[ii][jj];
                    int[] nArray = entries[ii];
                    int n = jj;
                    nArray[n] = nArray[n] + allData[k3].getBinEntries()[ii][jj];
                    double[] dArray = heights[ii];
                    int n2 = jj;
                    dArray[n2] = dArray[n2] + h;
                    double[] dArray2 = errors[ii];
                    int n3 = jj;
                    dArray2[n3] = dArray2[n3] + Math.pow(allData[k3].getBinErrors()[ii][jj], 2.0);
                    double[] dArray3 = meansX[ii];
                    int n4 = jj;
                    dArray3[n4] = dArray3[n4] + h * allData[k3].getBinMeansX()[ii][jj];
                    double[] dArray4 = rmssX[ii];
                    int n5 = jj;
                    dArray4[n5] = dArray4[n5] + h * (Math.pow(allData[k3].getBinRmssX()[ii][jj], 2.0) + Math.pow(allData[k3].getBinMeansX()[ii][jj], 2.0));
                    double[] dArray5 = meansY[ii];
                    int n6 = jj;
                    dArray5[n6] = dArray5[n6] + h * allData[k3].getBinMeansY()[ii][jj];
                    double[] dArray6 = rmssY[ii];
                    int n7 = jj;
                    dArray6[n7] = dArray6[n7] + h * (Math.pow(allData[k3].getBinRmssY()[ii][jj], 2.0) + Math.pow(allData[k3].getBinMeansY()[ii][jj], 2.0));
                }
                errors[ii][jj] = Math.sqrt(errors[ii][jj]);
                meansX[ii][jj] = meansX[ii][jj] / heights[ii][jj];
                meansY[ii][jj] = meansY[ii][jj] / heights[ii][jj];
                rmssX[ii][jj] = Math.sqrt(rmssX[ii][jj] / heights[ii][jj] - meansX[ii][jj] * meansX[ii][jj]);
                rmssY[ii][jj] = Math.sqrt(rmssY[ii][jj] / heights[ii][jj] - meansY[ii][jj] * meansY[ii][jj]);
            }
        }
        for (ii = 0; ii < nXBins; ++ii) {
            for (k = 0; k < allData.length; ++k) {
                int n = ii;
                binEntriesX[n] = binEntriesX[n] + allData[k].getBinEntriesX()[ii];
                int n8 = ii;
                binHeightsX[n8] = binHeightsX[n8] + allData[k].getBinHeightsX()[ii];
            }
        }
        for (int jj = 0; jj < nYBins; ++jj) {
            for (k = 0; k < allData.length; ++k) {
                int n = jj;
                binEntriesY[n] = binEntriesY[n] + allData[k].getBinEntriesY()[jj];
                int n9 = jj;
                binHeightsY[n9] = binHeightsY[n9] + allData[k].getBinHeightsY()[jj];
            }
        }
        data.setXAxis(allData[0].getXAxis());
        data.setYAxis(allData[0].getYAxis());
        data.setAnnotationItems(allData[0].getAnnotationItems());
        data.setBinHeights(heights);
        data.setBinErrors(errors);
        data.setBinEntries(entries);
        data.setBinMeansX(meansX);
        data.setBinRmssX(rmssX);
        data.setBinMeansY(meansY);
        data.setBinRmssY(rmssY);
        data.setBinEntriesX(binEntriesX);
        data.setBinEntriesY(binEntriesY);
        data.setBinHeightsX(binHeightsX);
        data.setBinHeightsX(binHeightsY);
        data.setMeanX(meanX);
        data.setRmsX(rmsX);
        data.setMeanY(meanY);
        data.setRmsY(rmsY);
        data.setInRangeEntries(inRangeEntries);
        data.setExtraEntries(extraEntries);
        data.setEquivalentBinEntries(equivalentBinEntries);
        data.setInRangeBinHeights(inRangeBinHeights);
        data.setExtraBinHeights(extraBinHeights);
        data.setMinBinHeights(minBinHeights);
        data.setMaxBinHeights(maxBinHeights);
        return data;
    }

    private int convertToAIDAIndex(int nBins, int index) {
        int mi = index == 0 ? -2 : (index == nBins + 1 ? -1 : index - 1);
        return mi;
    }
}

