/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.client;

import hep.aida.dev.IStore;
import hep.aida.dev.IStoreFactory;
import hep.aida.ref.remote.RemoteTable;
import hep.aida.ref.remote.rmi.client.RmiMutableStore;
import hep.aida.ref.remote.rmi.converters.RmiCloud1DConverter;
import hep.aida.ref.remote.rmi.converters.RmiCloud2DConverter;
import hep.aida.ref.remote.rmi.converters.RmiDataPointSetConverter;
import hep.aida.ref.remote.rmi.converters.RmiHist1DConverter;
import hep.aida.ref.remote.rmi.converters.RmiHist2DConverter;
import hep.aida.ref.remote.rmi.converters.RmiProfile1DConverter;
import hep.aida.ref.remote.rmi.converters.RmiTableConverter;
import org.freehep.util.FreeHEPLookup;

public class RmiStoreFactory
implements IStoreFactory {
    public static String storeType = "aidaRmi";

    public RmiStoreFactory() {
        FreeHEPLookup lookup = FreeHEPLookup.instance();
        Object item = lookup.lookup(RmiHist1DConverter.class);
        if (item == null) {
            lookup.add((Object)RmiHist1DConverter.getInstance(), "IHistogram1D");
        }
        if ((item = lookup.lookup(RmiHist2DConverter.class)) == null) {
            lookup.add((Object)RmiHist2DConverter.getInstance(), "IHistogram2D");
        }
        if ((item = lookup.lookup(RmiDataPointSetConverter.class)) == null) {
            lookup.add((Object)RmiDataPointSetConverter.getInstance(), "IDataPointSet");
        }
        if ((item = lookup.lookup(RmiCloud1DConverter.class)) == null) {
            lookup.add((Object)RmiCloud1DConverter.getInstance(), "ICloud1D");
        }
        if ((item = lookup.lookup(RmiCloud2DConverter.class)) == null) {
            lookup.add((Object)RmiCloud2DConverter.getInstance(), "ICloud2D");
        }
        if ((item = lookup.lookup(RmiProfile1DConverter.class)) == null) {
            lookup.add((Object)RmiProfile1DConverter.getInstance(), "IProfile1D");
        }
        if ((item = lookup.lookup(RmiTableConverter.class)) == null) {
            RemoteTable rt = new RemoteTable("tmp");
            lookup.add((Object)RmiTableConverter.getInstance(), rt.type());
        }
    }

    public IStore createStore() {
        return new RmiMutableStore();
    }

    public String description() {
        return storeType;
    }

    public boolean supportsType(String type) {
        return storeType.equalsIgnoreCase(type);
    }
}

