/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.style.registry.IStyleRule;
import hep.aida.ref.plotter.style.registry.IStyleStore;
import hep.aida.ref.plotter.style.registry.JELRule;
import hep.aida.ref.plotter.style.registry.StyleStoreEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class BaseStyleStore
implements IStyleStore {
    protected String storeName;
    protected String storeType;
    protected boolean isReadOnly;
    protected Object lock = new Object();
    protected List entries;
    protected Properties props = new Properties();

    public BaseStyleStore(String storeName) {
        this.storeName = storeName;
        this.entries = new ArrayList(10);
    }

    public Properties getProperties() {
        return this.props;
    }

    public StyleStoreEntry getStoreEntry(String styleName) {
        StyleStoreEntry entry = null;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!styleName.equals(((StyleStoreEntry)this.entries.get(i)).getName())) continue;
            entry = (StyleStoreEntry)this.entries.get(i);
            break;
        }
        return entry;
    }

    public void addStoreEntry(StyleStoreEntry entry) {
        if (this.hasStyle(entry.getName())) {
            throw new IllegalArgumentException("StyleStore " + this.storeName + " already has Style " + entry.getName());
        }
        entry.getStyle().setParameter("plotterStyleName", this.storeName + "." + entry.getName());
        this.entries.add(entry);
    }

    public void moveUp(String styleName) {
        this.moveUp(this.getStoreEntry(styleName));
    }

    public void moveUp(StyleStoreEntry entry) {
        if (!this.hasStyle(entry.getName())) {
            throw new IllegalArgumentException("StyleStore " + this.storeName + " does not have Style " + entry.getName());
        }
        int index = this.entries.indexOf(entry);
        if (index == 0) {
            return;
        }
        this.entries.remove(index);
        this.entries.add(index - 1, entry);
    }

    public void moveDown(String styleName) {
        this.moveDown(this.getStoreEntry(styleName));
    }

    public void moveDown(StyleStoreEntry entry) {
        if (!this.hasStyle(entry.getName())) {
            throw new IllegalArgumentException("StyleStore " + this.storeName + " does not have Style " + entry.getName());
        }
        int index = this.entries.indexOf(entry);
        if (index == this.entries.size() - 1) {
            return;
        }
        this.entries.remove(index);
        this.entries.add(index + 1, entry);
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void addStyle(String styleName, IPlotterStyle style) {
        this.addStyle(styleName, style, this.createRule());
    }

    public void addStyle(String styleName, IPlotterStyle style, IStyleRule rule) {
        if (this.hasStyle(styleName)) {
            throw new IllegalArgumentException("StyleStore " + this.storeName + " already has Style " + styleName);
        }
        style.setParameter("plotterStyleName", this.storeName + "." + styleName);
        StyleStoreEntry entry = new StyleStoreEntry(styleName, style, rule);
        this.entries.add(entry);
    }

    public boolean hasStyle(String styleName) {
        boolean ok = false;
        StyleStoreEntry entry = this.getStoreEntry(styleName);
        if (entry != null) {
            ok = true;
        }
        return ok;
    }

    public IPlotterStyle getStyle(String styleName) {
        IPlotterStyle style = null;
        StyleStoreEntry entry = this.getStoreEntry(styleName);
        if (entry != null) {
            style = entry.getStyle();
        }
        return style;
    }

    public IPlotterStyle removeStyle(String styleName) {
        IPlotterStyle style = null;
        StyleStoreEntry entry = this.getStoreEntry(styleName);
        if (entry != null) {
            style = entry.getStyle();
            this.entries.remove(entry);
        }
        return style;
    }

    public String[] getAllStyleNames() {
        String[] names = new String[this.entries.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((StyleStoreEntry)this.entries.get(i)).getName();
        }
        return names;
    }

    public IStyleRule createRule() {
        return new JELRule();
    }

    public IStyleRule getRuleForStyle(String styleName) {
        IStyleRule rule = null;
        StyleStoreEntry entry = this.getStoreEntry(styleName);
        if (entry != null) {
            rule = entry.getRule();
        }
        return rule;
    }

    public void setRuleForStyle(String styleName, IStyleRule rule) {
        StyleStoreEntry entry = this.getStoreEntry(styleName);
        if (entry != null) {
            entry.setRule(rule);
        }
    }

    public void removeRuleForStyle(String styleName) {
        this.setRuleForStyle(styleName, this.createRule());
    }

    public abstract void commit();

    public void close() {
        this.entries.clear();
    }

    public String toString() {
        return this.storeName;
    }
}

