/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.ref.plotter.adapter.CanSetData;
import jas.hist.CustomOverlay;
import jas.hist.DataSource;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import jas.hist.XYDataSource;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.MutableLegendEntry;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import java.awt.BasicStroke;

public class ScalerOverlay
implements CanSetData,
CustomOverlay,
MutableLegendEntry {
    private XYDataSource source;
    private OverlayContainer container;
    private JASHistData data;
    private JASHist1DHistogramStyle style;
    private String[] labels;
    private double[] xPoly;
    private double[] yPoly;
    private double xmax;
    private double xmin;
    private int oldn = 0;
    private static final float[][] lineStyles = new float[][]{null, {1.0f, 5.0f}, {4.0f, 6.0f}, {6.0f, 4.0f, 2.0f, 4.0f}};

    public void setData(JASHistData data) {
        this.data = data;
    }

    public void setStyle(JASHistStyle s) {
        this.style = (JASHist1DHistogramStyle)s;
        if (this.style != null) {
            this.style.setShowHistogramBars(false);
            this.style.setShowLinesBetweenPoints(true);
        }
    }

    public JASHist1DHistogramStyle getStyle() {
        return this.style;
    }

    public String getTitle() {
        return this.source.getTitle();
    }

    public void paintIcon(PlotGraphics g, int width, int height) {
        if (this.style == null) {
            this.setStyle((JASHist1DHistogramStyle)this.data.getStyle());
        }
        if (this.style.getShowDataPoints()) {
            g.setColor(this.style.getDataPointColor());
            g.drawSymbol(width / 2, height / 2, width / 2, this.style.getDataPointStyle());
        } else if (this.style.getShowHistogramBars()) {
            if (this.style.getHistogramFill()) {
                g.setColor(this.style.getHistogramBarColor());
                g.fillRect(1.0, 1.0, width - 2, height - 2);
            } else {
                g.setColor(this.style.getHistogramBarLineColor());
                BasicStroke s = new BasicStroke(this.style.getHistogramBarLineWidth(), 2, 1, 10.0f, lineStyles[this.style.getHistogramBarLineStyle()], 0.0f);
                g.setStroke(s);
                g.drawLine(1.0, height / 2, width - 2, height / 2);
                g.setStroke(null);
            }
        } else if (this.style.getShowLinesBetweenPoints()) {
            g.setColor(this.style.getLineColor());
            BasicStroke s = new BasicStroke(this.style.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[this.style.getLinesBetweenPointsStyle()], 0.0f);
            g.setStroke(s);
            g.drawLine(1.0, height / 2, width - 2, height / 2);
            g.setStroke(null);
        } else if (this.style.getShowErrorBars()) {
            g.setColor(this.style.getErrorBarColor());
            BasicStroke s = new BasicStroke(this.style.getErrorBarWidth(), 2, 1, 10.0f, lineStyles[this.style.getErrorBarStyle()], 0.0f);
            g.setStroke(s);
            g.drawLine(1.0, height / 2, width - 2, height / 2);
            g.setStroke(null);
        } else if (this.style.getHistogramFill()) {
            g.setColor(this.style.getHistogramBarColor());
            g.fillRect(1.0, 1.0, width - 2, height - 2);
        }
    }

    public void setTitle(String newTitle) {
    }

    public boolean titleIsChanged() {
        return false;
    }

    public void setDataSource(DataSource sr) {
        if (!(sr instanceof XYDataSource)) {
            throw new IllegalArgumentException("DataSource is not XYDataSource,  DataSource=" + sr.toString());
        }
        this.source = (XYDataSource)sr;
    }

    public void containerNotify(OverlayContainer c) {
        this.container = c;
    }

    public void paint(PlotGraphics g, boolean isPrinting) {
        if (this.style == null) {
            this.setStyle((JASHist1DHistogramStyle)this.data.getStyle());
        }
        CoordinateTransformation xp = this.container.getXTransformation();
        CoordinateTransformation yp = this.container.getYTransformation(this.data.getYAxis());
        if (xp instanceof DateCoordinateTransformation) {
            xp = new DateTransformationConverter((DateCoordinateTransformation)xp);
        }
        if (xp instanceof DoubleCoordinateTransformation && yp instanceof DoubleCoordinateTransformation) {
            DoubleCoordinateTransformation xt = (DoubleCoordinateTransformation)xp;
            DoubleCoordinateTransformation yt = (DoubleCoordinateTransformation)yp;
            this.xmin = xt.getPlotMin();
            this.xmax = xt.getPlotMax();
            int bins = this.source.getNPoints();
            double binWidth = (this.xmax - this.xmin) / (double)bins;
            double pixelWidth = (xt.convert(this.xmax) - xt.convert(this.xmin)) / (double)bins;
            boolean outline = pixelWidth > 5.0;
            double errorBarWidth = Math.min(binWidth, 3.0 * binWidth / pixelWidth);
            g.setTransformation(xt, yt);
            double x = this.xmin;
            double oldx = this.xmin;
            double y0 = 0.0;
            if (yt.getPlotMin() > y0) {
                y0 = yt.getPlotMin();
            }
            if (yt.getPlotMax() < y0) {
                y0 = yt.getPlotMax();
            }
            if ((this.style.getShowLinesBetweenPoints() || this.style.getShowDataPoints()) && bins != this.oldn) {
                this.xPoly = new double[bins];
                this.yPoly = new double[bins];
                this.oldn = bins;
            }
            int index = 0;
            double y = this.source.getY(index);
            x = this.source.getX(index);
            double oldy = y;
            this.xPoly[index] = x;
            this.yPoly[index] = y;
            for (int i = 0; i < bins; ++i) {
                y = this.source.getY(i);
                x = this.source.getX(i);
                if (Double.isNaN(y) || Double.isNaN(x)) continue;
                this.xPoly[index] = x;
                this.yPoly[index] = y;
                BasicStroke s = new BasicStroke(this.style.getHistogramBarLineWidth(), 2, 1, 10.0f, lineStyles[this.style.getHistogramBarLineStyle()], 0.0f);
                g.setStroke(s);
                if (this.style.getShowHistogramBars()) {
                    g.setColor(this.style.getHistogramBarColor());
                    if (this.style.getHistogramFill()) {
                        g.setColor(this.style.getHistogramBarLineColor());
                        if (i > 0) {
                            g.fillRect(oldx, y0, x, oldy);
                        }
                        if (outline) {
                            g.drawRect(oldx, y0, x, oldy);
                        } else {
                            if (i > 0) {
                                g.drawLine(oldx, oldy, x, oldy);
                            }
                            g.drawLine(x, oldy, x, y);
                        }
                    } else {
                        g.setColor(this.style.getHistogramBarLineColor());
                        g.drawLine(oldx, oldy, x, oldy);
                        g.drawLine(x, oldy, x, y);
                    }
                }
                if (this.style.getShowErrorBars()) {
                    g.setColor(this.style.getErrorBarColor());
                    s = new BasicStroke(this.style.getErrorBarWidth(), 2, 1, 10.0f, lineStyles[this.style.getErrorBarStyle()], 0.0f);
                    g.setStroke(s);
                    double xm = x;
                    double xe = errorBarWidth;
                    double yplus = y + this.source.getPlusError(i);
                    double yminus = y - this.source.getMinusError(i);
                    if (!Double.isNaN(yplus) && !Double.isNaN(yminus) && yminus != yplus) {
                        g.drawLine(xm, yplus, xm, yminus);
                        if (outline) {
                            BasicStroke ss = new BasicStroke(this.style.getErrorBarWidth(), 2, 1, 10.0f);
                            g.setStroke(ss);
                            g.drawLine(xm - xe, yplus, xm + xe, yplus);
                            g.drawLine(xm - xe, yminus, xm + xe, yminus);
                        }
                    }
                }
                oldx = x;
                oldy = y;
                ++index;
            }
            if (index > 0) {
                if (this.style.getShowLinesBetweenPoints()) {
                    g.setColor(this.style.getLineColor());
                    BasicStroke s = new BasicStroke(this.style.getLinesBetweenPointsWidth(), 2, 1, 10.0f, lineStyles[this.style.getLinesBetweenPointsStyle()], 0.0f);
                    g.setStroke(s);
                    g.drawPolyLine(this.xPoly, this.yPoly, index);
                }
                if (this.style.getShowDataPoints()) {
                    g.setColor(this.style.getDataPointColor());
                    g.drawPolySymbol(this.xPoly, this.yPoly, this.style.getDataPointSize(), this.style.getDataPointStyle(), index);
                }
            }
        }
    }

    private class DateTransformationConverter
    implements DoubleCoordinateTransformation {
        private DateCoordinateTransformation dateCT;

        DateTransformationConverter(DateCoordinateTransformation dateCT) {
            this.dateCT = dateCT;
        }

        public double convert(double d) {
            return this.dateCT.convert((long)(d * 1000.0));
        }

        public double unConvert(double i) {
            return (double)this.dateCT.map(i) / 1000.0;
        }

        public double getPlotMin() {
            return (double)this.dateCT.getAxisMin() / 1000.0;
        }

        public double getPlotMax() {
            return (double)this.dateCT.getAxisMax() / 1000.0;
        }
    }
}

