/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Grid;
import hep.aida.ref.pdf.RangeSet;
import hep.aida.ref.pdf.VariableList;

public class FunctionIntegrator {
    private static final int AllStages = 0;
    private static final int ReuseGrid = 1;
    private static final int RefineGrid = 2;
    private static final int Importance = 0;
    private static final int ImportanceOnly = 1;
    private static final int Stratified = 2;
    private static double wtdIntSum;
    private static double sumWgts;
    private static double chiSum;
    private static int itNum;
    private static int itStart;
    private static double samples;
    private static int callsPerBox;
    private static double jac;
    private static double alpha;

    public static double integralVegasMC(Function f, Dependent x) {
        return FunctionIntegrator.integralVegasMC(f, new Dependent[]{x});
    }

    public static double integralVegasMC(Function f, VariableList v) {
        if (v.type() != VariableList.DEPENDENT) {
            throw new IllegalArgumentException("Only a list of Dependents can be provided when integrating.");
        }
        Dependent[] vars = new Dependent[v.size()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = (Dependent)v.get(i);
        }
        return FunctionIntegrator.integralVegasMC(f, vars);
    }

    public static double integralVegasMC(Function f, Dependent[] vars) {
        Grid grid = new Grid(vars);
        if (!grid.isValid()) {
            throw new RuntimeException("Problem initializing the grid for function " + f);
        }
        int nRefineIter = 5;
        int nRefinePerDim = 1000;
        int nIntegratePerDim = 5000;
        FunctionIntegrator.vegas(f, grid, 0, nRefinePerDim * grid.dimension(), nRefineIter, 0);
        return FunctionIntegrator.vegas(f, grid, 0, nIntegratePerDim * grid.dimension(), 1, 0);
    }

    private static double vegas(Function ff, Grid grid, int stage, int calls, int iterations, int mode) {
        if (stage == 0) {
            grid.initialize();
        }
        if (stage <= 1) {
            wtdIntSum = 0.0;
            sumWgts = 0.0;
            chiSum = 0.0;
            itNum = 1;
            samples = 0.0;
        }
        int dim = grid.dimension();
        if (stage <= 2) {
            double totBoxes;
            int bins = grid.maxBins();
            int boxes = 1;
            if (mode != 1) {
                boxes = (int)Math.floor(Math.pow((double)calls / 2.0, 1.0 / (double)dim));
                mode = 0;
                if (2 * boxes >= grid.maxBins()) {
                    mode = 2;
                    int boxPerBin = boxes > grid.maxBins() ? boxes / grid.maxBins() : 1;
                    bins = boxes / boxPerBin;
                    if (bins > grid.maxBins()) {
                        bins = grid.maxBins();
                    }
                    boxes = boxPerBin * bins;
                }
            }
            if ((callsPerBox = (int)((double)calls / (totBoxes = Math.pow(boxes, dim)))) < 2) {
                callsPerBox = 2;
            }
            calls = (int)((double)callsPerBox * totBoxes);
            jac = grid.volume() * Math.pow(bins, dim) / (double)calls;
            grid.setBoxes(boxes);
            if (bins != grid.nBins()) {
                grid.resize(bins);
            }
        }
        double cumInt = 0.0;
        double cumSig = 0.0;
        itStart = itNum;
        for (int it = 0; it < iterations; ++it) {
            double intgrl = 0.0;
            double intgrlSq = 0.0;
            double sig = 0.0;
            double jacbin = jac;
            itNum = itStart + it;
            grid.resetValues();
            int[][] box = grid.firstBox();
            int[][] bin = new int[dim][box[0].length];
            do {
                double m = 0.0;
                double q = 0.0;
                for (int k = 0; k < callsPerBox; ++k) {
                    double[] binVol = new double[1];
                    grid.generatePoint(box, bin, binVol);
                    double fVal = jacbin * binVol[0] * ff.functionValue();
                    double d = fVal - m;
                    m += d / ((double)k + 1.0);
                    q += d * d * ((double)k / ((double)k + 1.0));
                    if (mode == 2) continue;
                    grid.accumulate(bin, fVal * fVal);
                }
                intgrl += m * (double)callsPerBox;
                double fSqSum = q * (double)callsPerBox;
                sig += fSqSum;
                if (mode != 2) continue;
                grid.accumulate(bin, fSqSum);
            } while (grid.nextBox(box));
            double wgt = (sig /= (double)callsPerBox - 1.0) > 0.0 ? 1.0 / sig : (sumWgts > 0.0 ? sumWgts / samples : 0.0);
            intgrlSq = intgrl * intgrl;
            if (wgt > 0.0) {
                samples += 1.0;
                chiSum += intgrlSq * wgt;
                cumInt = (wtdIntSum += intgrl * wgt) / (sumWgts += wgt);
                cumSig = Math.sqrt(1.0 / sumWgts);
                if (samples > 1.0) {
                    // empty if block
                }
            } else {
                cumInt += (intgrl - cumInt) / ((double)it + 1.0);
                cumSig = 0.0;
            }
            grid.refine(alpha);
        }
        return cumInt;
    }

    public static double integralMC(Function f, Dependent x) {
        return FunctionIntegrator.integralMC(f, new Dependent[]{x});
    }

    public static double integralMC(Function f, VariableList v) {
        if (v.type() != VariableList.DEPENDENT) {
            throw new IllegalArgumentException("Only a list of Dependents can be provided when integrating.");
        }
        Dependent[] vars = new Dependent[v.size()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = (Dependent)v.get(i);
        }
        return FunctionIntegrator.integralMC(f, v);
    }

    public static double integralMC(Function f, Dependent[] deps) {
        int dim = deps.length;
        RangeSet[] ranges = new RangeSet[dim];
        double vol = 1.0;
        for (int i = 0; i < dim; ++i) {
            ranges[i] = deps[i].range();
            vol *= ranges[i].length();
        }
        double integral = 0.0;
        int nIter = 1000000;
        for (int i = 0; i < nIter; ++i) {
            for (int j = 0; j < dim; ++j) {
                deps[j].setValue(ranges[j].generatePoint());
            }
            integral += f.functionValue();
        }
        return vol * integral / (double)nIter;
    }

    public static double integralTrapezoid(Function f, Dependent x) {
        return FunctionIntegrator.integralTrapezoid(f, new Dependent[]{x});
    }

    public static double integralTrapezoid(Function f, VariableList v) {
        if (v.type() != VariableList.DEPENDENT) {
            throw new IllegalArgumentException("Only a list of Dependents can be provided when integrating.");
        }
        Dependent[] vars = new Dependent[v.size()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = (Dependent)v.get(i);
        }
        return FunctionIntegrator.integralTrapezoid(f, v);
    }

    public static double integralTrapezoid(Function f, Dependent[] deps) {
        if (deps.length != 1) {
            throw new IllegalArgumentException("Cannot integrate multi-dimensional functions!");
        }
        Dependent x = deps[0];
        int steps = 1000;
        double integral = 0.0;
        RangeSet range = x.range();
        double[] lowerBounds = range.lowerBounds();
        double[] upperBounds = range.upperBounds();
        for (int i = 0; i < range.size(); ++i) {
            double rub = upperBounds[i];
            double rlb = lowerBounds[i];
            double delta = (rub - rlb) / (double)steps;
            double norm = delta / 2.0;
            double tmpIntegral = 0.0;
            x.setValue(rub);
            tmpIntegral += f.functionValue();
            x.setValue(rlb);
            tmpIntegral += f.functionValue();
            for (int j = 1; j < steps; ++j) {
                x.setValue(rlb + (double)j * delta);
                tmpIntegral += 2.0 * f.functionValue();
            }
            integral += norm * tmpIntegral;
        }
        return integral;
    }

    public static double integralSimpson(Function f, Dependent x) {
        return FunctionIntegrator.integralSimpson(f, new Dependent[]{x});
    }

    public static double integralSimpson(Function f, VariableList v) {
        if (v.type() != VariableList.DEPENDENT) {
            throw new IllegalArgumentException("Only a list of Dependents can be provided when integrating.");
        }
        Dependent[] vars = new Dependent[v.size()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = (Dependent)v.get(i);
        }
        return FunctionIntegrator.integralSimpson(f, v);
    }

    public static double integralSimpson(Function f, Dependent[] deps) {
        if (deps.length != 1) {
            throw new IllegalArgumentException("Cannot integrate multi-dimensional functions!");
        }
        int steps = 120;
        double integral = 0.0;
        Dependent x = deps[0];
        RangeSet range = x.range();
        double[] lowerBounds = range.lowerBounds();
        double[] upperBounds = range.upperBounds();
        for (int i = 0; i < range.size(); ++i) {
            int j;
            double rub = upperBounds[i];
            double rlb = lowerBounds[i];
            double delta = (rub - rlb) / (double)steps;
            double norm = delta / 3.0;
            double tmpIntegral = 0.0;
            x.setValue(rub);
            tmpIntegral += f.functionValue();
            x.setValue(rlb);
            tmpIntegral += f.functionValue();
            for (j = 0; j < steps / 2; ++j) {
                x.setValue(rlb + (double)(2 * j + 1) * delta);
                tmpIntegral += 4.0 * f.functionValue();
            }
            for (j = 1; j < steps / 2; ++j) {
                x.setValue(rlb + (double)(2 * j) * delta);
                tmpIntegral += 2.0 * f.functionValue();
            }
            integral += norm * tmpIntegral;
        }
        return integral;
    }

    static {
        alpha = 1.5;
    }
}

