/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.Variable;
import hep.aida.ref.pdf.VariableList;

public class Exponential
extends Function {
    public static int NORMAL = 0;
    public static int DECAY = 1;
    private Dependent x;
    private Parameter alpha;
    private double alphaVal;
    private double xVal;
    private double argFact;
    private int type;

    public Exponential(String name) {
        this(name, null, null, NORMAL);
    }

    public Exponential(String name, int type) {
        this(name, null, null, type);
    }

    public Exponential(String name, Dependent x) {
        this(name, x, null, NORMAL);
    }

    public Exponential(String name, Dependent x, int type) {
        this(name, x, null, type);
    }

    public Exponential(String name, Dependent x, Parameter alpha) {
        this(name, x, alpha, NORMAL);
    }

    public Exponential(String name, Dependent x, Parameter alpha, int type) {
        super(name);
        this.x = x;
        this.alpha = alpha;
        this.type = type;
        this.initializeVariables();
    }

    private void initializeVariables() {
        if (this.x == null) {
            this.x = new Dependent("x", 0.0, 1.0);
        }
        if (this.alpha == null) {
            this.alpha = this.type == NORMAL ? new Parameter("alpha") : new Parameter("tau");
        }
        VariableList list = new VariableList();
        list.add(this.x);
        list.add(this.alpha);
        this.addVariables(list);
    }

    public void variableChanged(Variable var) {
        if (var == this.alpha) {
            this.alphaVal = this.alpha.value();
            this.argFact = this.type == NORMAL ? this.alphaVal : -1.0 / this.alphaVal;
        } else if (var == this.x) {
            this.xVal = this.x.value();
        }
    }

    public double functionValue() {
        return Math.exp(this.argFact * this.xVal);
    }

    public boolean hasAnalyticalVariableGradient(Variable var) {
        return true;
    }

    public double evaluateAnalyticalVariableGradient(Variable var) {
        if (var == this.x) {
            return this.functionValue() * this.argFact;
        }
        if (var == this.alpha) {
            double r = this.functionValue() * this.xVal;
            if (this.type == NORMAL) {
                return r;
            }
            return this.argFact * this.argFact * r;
        }
        return 0.0;
    }

    public boolean hasAnalyticalNormalization(Dependent dep) {
        return dep == this.x;
    }

    public double evaluateAnalyticalNormalization(Dependent dep) {
        double[] xMax = this.x.range().upperBounds();
        double[] xMin = this.x.range().lowerBounds();
        if (xMax.length != 1 || xMin.length != 1) {
            throw new IllegalArgumentException("Normalization over multiple ranges is not supported for Function Gaussian.");
        }
        double a = xMin[0];
        if (a < 0.0) {
            System.out.println("Lower bound cannot be less than zero");
            a = 0.0;
        }
        double b = xMax[0];
        return Math.exp(b * this.argFact) / this.argFact - Math.exp(a * this.argFact) / this.argFact;
    }
}

