/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.ICloud3D;
import hep.aida.IHistogram;
import hep.aida.IHistogram3D;
import hep.aida.ref.histogram.Cloud;
import hep.aida.ref.histogram.HistUtils;
import hep.aida.ref.histogram.Histogram3D;
import hep.aida.ref.histogram.VariableAxis;
import java.util.ArrayList;

public class Cloud3D
extends Cloud
implements ICloud3D {
    private int nEntries = 0;
    private double lowerEdgeX = Double.NaN;
    private double upperEdgeX = Double.NaN;
    private double lowerEdgeY = Double.NaN;
    private double upperEdgeY = Double.NaN;
    private double lowerEdgeZ = Double.NaN;
    private double upperEdgeZ = Double.NaN;
    private double meanX;
    private double rmsX;
    private double meanY;
    private double rmsY;
    private double meanZ;
    private double rmsZ;
    private IHistogram3D histo;
    protected double sumOfWeights;
    private ArrayList xValuesArray = new ArrayList();
    private ArrayList yValuesArray = new ArrayList();
    private ArrayList zValuesArray = new ArrayList();
    private ArrayList weightsArray = new ArrayList();
    private double[] xValues;
    private double[] yValues;
    private double[] zValues;
    private double[] weights;
    private int convBinsX = 50;
    private double convLowerEdgeX = Double.NaN;
    private double convUpperEdgeX = Double.NaN;
    private int convBinsY = 50;
    private double convLowerEdgeY = Double.NaN;
    private double convUpperEdgeY = Double.NaN;
    private int convBinsZ = 50;
    private double convLowerEdgeZ = Double.NaN;
    private double convUpperEdgeZ = Double.NaN;

    public Cloud3D() {
        super("", "", 3, 0, "");
    }

    protected Cloud3D(String name, String title, int nMax, String options) {
        super(name, title, 3, nMax, options);
    }

    public void fill(double xValue, double yValue, double zValue) {
        this.fill(xValue, yValue, zValue, 1.0);
    }

    public void fill(double xValue, double yValue, double zValue, double weight) {
        if (this.nEntries == 0) {
            this.lowerEdgeX = this.upperEdgeX = xValue;
            this.lowerEdgeY = this.upperEdgeY = yValue;
            this.lowerEdgeZ = this.upperEdgeZ = zValue;
        } else {
            if (xValue < this.lowerEdgeX) {
                this.lowerEdgeX = xValue;
            }
            if (xValue > this.upperEdgeX) {
                this.upperEdgeX = xValue;
            }
            if (yValue < this.lowerEdgeY) {
                this.lowerEdgeY = yValue;
            }
            if (yValue > this.upperEdgeY) {
                this.upperEdgeY = yValue;
            }
            if (zValue < this.lowerEdgeZ) {
                this.lowerEdgeZ = zValue;
            }
            if (zValue > this.upperEdgeZ) {
                this.upperEdgeZ = zValue;
            }
        }
        if (this.histo != null) {
            this.histo.fill(xValue, yValue, zValue, weight);
        } else if (this.autoConvert() && this.nEntries == this.maxEntries) {
            if (this.histo != null) {
                throw new RuntimeException("Cloud already been converted");
            }
            this.histo = this.toShowableHistogram(this.conversionBinsX(), this.conversionLowerEdgeX(), this.conversionUpperEdgeX(), this.conversionBinsY(), this.conversionLowerEdgeY(), this.conversionUpperEdgeY(), this.conversionBinsZ(), this.conversionLowerEdgeZ(), this.conversionUpperEdgeZ());
            this.histo.fill(xValue, yValue, zValue, weight);
            this.weights = null;
            this.xValues = null;
            this.yValues = null;
            this.zValues = null;
            this.xValuesArray.clear();
            this.yValuesArray.clear();
            this.zValuesArray.clear();
            this.weightsArray.clear();
            this.xValuesArray = null;
            this.yValuesArray = null;
            this.zValuesArray = null;
            this.weightsArray = null;
        } else {
            if (this.nEntries % this.arraySize == 0) {
                this.xValues = new double[this.arraySize];
                this.yValues = new double[this.arraySize];
                this.zValues = new double[this.arraySize];
                this.weights = new double[this.arraySize];
                this.xValuesArray.add(this.xValues);
                this.yValuesArray.add(this.yValues);
                this.zValuesArray.add(this.zValues);
                this.weightsArray.add(this.weights);
            }
            this.xValues[this.nEntries % this.arraySize] = xValue;
            this.yValues[this.nEntries % this.arraySize] = yValue;
            this.zValues[this.nEntries % this.arraySize] = zValue;
            this.weights[this.nEntries % this.arraySize] = weight;
            if (!(Double.isNaN(xValue) || Double.isNaN(yValue) || Double.isNaN(zValue) || Double.isNaN(weight))) {
                this.sumOfWeights += weight;
                this.meanX += xValue * weight;
                this.rmsX += xValue * xValue * weight;
                this.meanY += yValue * weight;
                this.rmsY += yValue * yValue * weight;
                this.meanZ += zValue * weight;
                this.rmsZ += zValue * zValue * weight;
                ++this.validEntries;
            }
            ++this.nEntries;
            if (this.nEntries > this.maxEntries && this.maxEntries > 0) {
                throw new IllegalArgumentException();
            }
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public double lowerEdgeX() {
        return this.lowerEdgeX;
    }

    public double lowerEdgeY() {
        return this.lowerEdgeY;
    }

    public double lowerEdgeZ() {
        return this.lowerEdgeZ;
    }

    public double upperEdgeX() {
        return this.upperEdgeX;
    }

    public double upperEdgeY() {
        return this.upperEdgeY;
    }

    public double upperEdgeZ() {
        return this.upperEdgeZ;
    }

    public void setLowerEdgeX(double lowerEdgeX) {
        this.lowerEdgeX = lowerEdgeX;
    }

    public void setLowerEdgeY(double lowerEdgeY) {
        this.lowerEdgeY = lowerEdgeY;
    }

    public void setLowerEdgeZ(double lowerEdgeZ) {
        this.lowerEdgeZ = lowerEdgeZ;
    }

    public void setUpperEdgeX(double upperEdgeX) {
        this.upperEdgeX = upperEdgeX;
    }

    public void setUpperEdgeY(double upperEdgeY) {
        this.upperEdgeY = upperEdgeY;
    }

    public void setUpperEdgeZ(double upperEdgeZ) {
        this.upperEdgeZ = upperEdgeZ;
    }

    public double valueX(int index) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud has been converted");
        }
        double[] val = (double[])this.xValuesArray.get(index / this.arraySize);
        return val[index % this.arraySize];
    }

    public double valueY(int index) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud has been converted");
        }
        double[] val = (double[])this.yValuesArray.get(index / this.arraySize);
        return val[index % this.arraySize];
    }

    public double valueZ(int index) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud has been converted");
        }
        double[] val = (double[])this.zValuesArray.get(index / this.arraySize);
        return val[index % this.arraySize];
    }

    public double weight(int index) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud has been converted");
        }
        double[] val = (double[])this.weightsArray.get(index / this.arraySize);
        return val[index % this.arraySize];
    }

    public double meanX() {
        if (this.histo != null) {
            return this.histo.meanX();
        }
        return this.meanX / this.sumOfWeights();
    }

    public double meanY() {
        if (this.histo != null) {
            return this.histo.meanY();
        }
        return this.meanY / this.sumOfWeights();
    }

    public double meanZ() {
        if (this.histo != null) {
            return this.histo.meanZ();
        }
        return this.meanZ / this.sumOfWeights();
    }

    public double rmsX() {
        if (this.histo != null) {
            return this.histo.rmsX();
        }
        return Math.sqrt(this.rmsX / this.sumOfWeights() - this.meanX * this.meanX / this.sumOfWeights() / this.sumOfWeights());
    }

    public double rmsY() {
        if (this.histo != null) {
            return this.histo.rmsY();
        }
        return Math.sqrt(this.rmsY / this.sumOfWeights() - this.meanY * this.meanY / this.sumOfWeights() / this.sumOfWeights());
    }

    public double rmsZ() {
        if (this.histo != null) {
            return this.histo.rmsZ();
        }
        return Math.sqrt(this.rmsZ / this.sumOfWeights() - this.meanZ * this.meanZ / this.sumOfWeights() / this.sumOfWeights());
    }

    public int entries() {
        if (this.histo != null) {
            return this.histo.allEntries();
        }
        return this.nEntries;
    }

    public void convert(int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud already been converted");
        }
        this.histo = this.toShowableHistogram(nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, nBinsZ, lowerEdgeZ, upperEdgeZ);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    private IHistogram3D toShowableHistogram(int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ) {
        if (this.histo != null) {
            return this.histo;
        }
        return HistUtils.toShowableHistogram(this, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, nBinsZ, lowerEdgeZ, upperEdgeZ);
    }

    public void convert(double[] binEdgesX, double[] binEdgesY, double[] binEdgesZ) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud already been converted");
        }
        Histogram3D hist = new Histogram3D(this.name(), this.title(), new VariableAxis(binEdgesX), new VariableAxis(binEdgesY), new VariableAxis(binEdgesZ));
        for (int i = 0; i < this.nEntries; ++i) {
            hist.fill(this.valueX(i), this.valueY(i), this.valueZ(i), this.weight(i));
        }
        this.histo = hist;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public boolean isConverted() {
        return this.histo != null;
    }

    public IHistogram3D histogram() throws RuntimeException {
        if (this.histo == null) {
            throw new RuntimeException("Cloud has not been converted");
        }
        return this.histo;
    }

    public void setHistogram(IHistogram3D hist) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud already been converted");
        }
        this.histo = hist;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void fillHistogram(IHistogram3D hist3d) {
        if (this.histo != null) {
            throw new IllegalArgumentException("Cloud has already been converted");
        }
        for (int i = 0; i < this.nEntries; ++i) {
            hist3d.fill(this.valueX(i), this.valueY(i), this.valueZ(i), this.weight(i));
        }
    }

    public void reset() {
        this.nEntries = 0;
        this.lowerEdgeX = Double.NaN;
        this.upperEdgeX = Double.NaN;
        this.lowerEdgeY = Double.NaN;
        this.upperEdgeY = Double.NaN;
        this.lowerEdgeZ = Double.NaN;
        this.upperEdgeZ = Double.NaN;
        this.meanX = 0.0;
        this.rmsX = 0.0;
        this.meanY = 0.0;
        this.rmsY = 0.0;
        this.meanZ = 0.0;
        this.rmsZ = 0.0;
        this.sumOfWeights = 0.0;
        if (this.histo != null) {
            this.histo.reset();
        }
        this.histo = null;
        this.xValuesArray = new ArrayList();
        this.yValuesArray = new ArrayList();
        this.zValuesArray = new ArrayList();
        this.weightsArray = new ArrayList();
        this.xValues = null;
        this.yValues = null;
        this.zValues = null;
        this.weights = null;
        super.reset();
    }

    public void convertToHistogram() {
        if (this.histo != null) {
            throw new IllegalArgumentException("Cloud has already been converted to an Histogram");
        }
        this.histo = this.toShowableHistogram(this.conversionBinsX(), this.conversionLowerEdgeX(), this.conversionUpperEdgeX(), this.conversionBinsY(), this.conversionLowerEdgeY(), this.conversionUpperEdgeY(), this.conversionBinsZ(), this.conversionLowerEdgeZ(), this.conversionUpperEdgeZ());
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void scale(double scaleFactor) throws IllegalArgumentException {
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal scale factor " + scaleFactor + " it has to be positive");
        }
        if (this.isConverted()) {
            this.histo.scale(scaleFactor);
        } else {
            for (int i = 0; i < this.entries(); ++i) {
                double[] weights = (double[])this.weightsArray.get(i / this.arraySize);
                int n = i % this.arraySize;
                weights[n] = weights[n] * scaleFactor;
            }
            this.sumOfWeights *= scaleFactor;
            this.meanX *= scaleFactor;
            this.rmsX *= scaleFactor;
            this.meanY *= scaleFactor;
            this.rmsY *= scaleFactor;
            this.meanZ *= scaleFactor;
            this.rmsZ *= scaleFactor;
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public double lowerEdgeXWithMargin() {
        if (Double.isNaN(this.lowerEdgeX)) {
            return Double.NaN;
        }
        double le = this.lowerEdgeX != this.upperEdgeX ? this.lowerEdgeX : this.lowerEdgeX - 1.0;
        double ue = this.lowerEdgeX != this.upperEdgeX ? this.upperEdgeX : this.upperEdgeX + 1.0;
        double delta = ue - le;
        return le - this.margin() * Math.abs(delta);
    }

    public double upperEdgeXWithMargin() {
        if (Double.isNaN(this.upperEdgeX)) {
            return Double.NaN;
        }
        double le = this.lowerEdgeX != this.upperEdgeX ? this.lowerEdgeX : this.lowerEdgeX - 1.0;
        double ue = this.lowerEdgeX != this.upperEdgeX ? this.upperEdgeX : this.upperEdgeX + 1.0;
        double delta = ue - le;
        return ue + this.margin() * Math.abs(delta);
    }

    public double lowerEdgeYWithMargin() {
        if (Double.isNaN(this.lowerEdgeY)) {
            return Double.NaN;
        }
        double le = this.lowerEdgeY != this.upperEdgeY ? this.lowerEdgeY : this.lowerEdgeY - 1.0;
        double ue = this.lowerEdgeY != this.upperEdgeY ? this.upperEdgeY : this.upperEdgeY + 1.0;
        double delta = ue - le;
        return le - this.margin() * Math.abs(delta);
    }

    public double upperEdgeYWithMargin() {
        if (Double.isNaN(this.upperEdgeY)) {
            return Double.NaN;
        }
        double le = this.lowerEdgeY != this.upperEdgeY ? this.lowerEdgeY : this.lowerEdgeY - 1.0;
        double ue = this.lowerEdgeY != this.upperEdgeY ? this.upperEdgeY : this.upperEdgeY + 1.0;
        double delta = ue - le;
        return ue + this.margin() * Math.abs(delta);
    }

    public double lowerEdgeZWithMargin() {
        if (Double.isNaN(this.lowerEdgeZ)) {
            return Double.NaN;
        }
        double le = this.lowerEdgeZ != this.upperEdgeZ ? this.lowerEdgeZ : this.lowerEdgeZ - 1.0;
        double ue = this.lowerEdgeZ != this.upperEdgeZ ? this.upperEdgeZ : this.upperEdgeZ + 1.0;
        double delta = ue - le;
        return le - this.margin() * Math.abs(delta);
    }

    public double upperEdgeZWithMargin() {
        if (Double.isNaN(this.upperEdgeZ)) {
            return Double.NaN;
        }
        double le = this.lowerEdgeZ != this.upperEdgeZ ? this.lowerEdgeZ : this.lowerEdgeZ - 1.0;
        double ue = this.lowerEdgeZ != this.upperEdgeZ ? this.upperEdgeZ : this.upperEdgeZ + 1.0;
        double delta = ue - le;
        return ue + this.margin() * Math.abs(delta);
    }

    public double sumOfWeights() {
        if (this.histo != null) {
            return this.histo.sumAllBinHeights();
        }
        return this.sumOfWeights;
    }

    protected IHistogram hist() {
        return this.histogram();
    }

    public void setConversionParameters(int binsX, double lowerEdgeX, double upperEdgeX, int binsY, double lowerEdgeY, double upperEdgeY, int binsZ, double lowerEdgeZ, double upperEdgeZ) {
        this.convBinsX = binsX;
        this.convLowerEdgeX = lowerEdgeX;
        this.convUpperEdgeX = upperEdgeX;
        this.convBinsY = binsY;
        this.convLowerEdgeY = lowerEdgeY;
        this.convUpperEdgeY = upperEdgeY;
        this.convBinsZ = binsZ;
        this.convLowerEdgeZ = lowerEdgeZ;
        this.convUpperEdgeZ = upperEdgeZ;
    }

    public int conversionBinsX() {
        return this.convBinsX;
    }

    public double conversionLowerEdgeX() {
        if (Double.isNaN(this.convLowerEdgeX)) {
            return this.lowerEdgeXWithMargin();
        }
        return this.convLowerEdgeX;
    }

    public double conversionUpperEdgeX() {
        if (Double.isNaN(this.convUpperEdgeX)) {
            return this.upperEdgeXWithMargin();
        }
        return this.convUpperEdgeX;
    }

    public int conversionBinsY() {
        return this.convBinsY;
    }

    public double conversionLowerEdgeY() {
        if (Double.isNaN(this.convLowerEdgeY)) {
            return this.lowerEdgeYWithMargin();
        }
        return this.convLowerEdgeY;
    }

    public double conversionUpperEdgeY() {
        if (Double.isNaN(this.convUpperEdgeY)) {
            return this.upperEdgeYWithMargin();
        }
        return this.convUpperEdgeY;
    }

    public int conversionBinsZ() {
        return this.convBinsZ;
    }

    public double conversionLowerEdgeZ() {
        if (Double.isNaN(this.convLowerEdgeZ)) {
            return this.lowerEdgeZWithMargin();
        }
        return this.convLowerEdgeZ;
    }

    public double conversionUpperEdgeZ() {
        if (Double.isNaN(this.convUpperEdgeZ)) {
            return this.upperEdgeZWithMargin();
        }
        return this.convUpperEdgeZ;
    }
}

