/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCore;

public class ExponentialCoreNorm
extends FunctionCore {
    protected boolean providesNormalization;

    public ExponentialCoreNorm(String str) {
        super(1, 1, new double[]{1.0});
        this.setTitle("ExponentialCoreNorm::" + str);
        this.providesNormalization = true;
        String[] names = new String[]{"exponent"};
        this.setParameterNames(names);
    }

    public ExponentialCoreNorm(String str, double[] pVal) {
        super(1, 1, pVal);
        this.setTitle("ExponentialCoreNorm::" + str);
        this.providesNormalization = true;
        String[] names = new String[]{"exponent"};
        this.setParameterNames(names);
    }

    public double functionValue(double[] var) {
        double val = Math.exp(var[0] * this.p[0]);
        return val;
    }

    public boolean providesGradient() {
        return true;
    }

    public double[] gradient(double[] var) {
        return new double[]{this.functionValue(var) * this.p[0]};
    }

    public boolean providesParameterGradient() {
        return true;
    }

    public double[] parameterGradient(double[] var) {
        return new double[]{this.functionValue(var) * var[0]};
    }

    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        double val = 0.0;
        val = (this.functionValue(new double[]{xMax[0]}) - this.functionValue(new double[]{xMin[0]})) / this.p[0];
        return val;
    }
}

