/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BtreeDict;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.Schema;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public class FullBtreeDict
extends BtreeDict {
    protected BtreeDictParameters params;
    private boolean update = false;
    private boolean debug = false;

    protected FullBtreeDict() {
    }

    public FullBtreeDict(BtreeDictParameters btreeDictParameters, boolean bl) throws Exception {
        this.init(btreeDictParameters, bl, new BlockFactory(){

            public Block makeBlock() {
                return new FullDictBlock();
            }
        });
        this.blocks = new int[300000];
        this.params = btreeDictParameters;
        this.update = bl;
    }

    public void close(int n) throws Exception {
        this.params.setFreeID(n);
        if (this.update) {
            this.params.updateSchema();
        }
        super.close();
    }

    public void store(String string, int n) throws Exception {
        byte[] byArray = string.getBytes("UTF8");
        Entry entry = this.insert((FullDictBlock)this.accessBlock(this.root), new Entry(byArray, byArray.length, n));
        if (entry != null) {
            FullDictBlock fullDictBlock = this.getNewBlock();
            fullDictBlock.initInternal(this.root, entry);
            this.blocks[entry.id] = this.root = fullDictBlock.number;
            this.params.setRoot(this.root);
        }
    }

    private void setModified(Block block) {
        this.blockManager.setModified(block.number);
    }

    private FullDictBlock getNewBlock() throws Exception {
        FullDictBlock fullDictBlock = (FullDictBlock)this.blockManager.getNewBlock();
        this.setModified(fullDictBlock);
        return fullDictBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry insert(FullDictBlock fullDictBlock, Entry entry) throws Exception {
        if (fullDictBlock.isLeaf) {
            return this.insertHere(fullDictBlock, entry);
        }
        int n = fullDictBlock.insertInternal(entry);
        if (n != -1) {
            Entry entry2;
            try {
                this.lock(fullDictBlock);
                entry = this.insert((FullDictBlock)this.child(fullDictBlock, n), entry);
                entry2 = entry == null ? null : this.insertHere(fullDictBlock, entry);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.unlock(fullDictBlock);
                throw throwable;
            }
            this.unlock(fullDictBlock);
            return entry2;
        }
        return null;
    }

    private Entry insertHere(FullDictBlock fullDictBlock, Entry entry) throws Exception {
        this.setModified(fullDictBlock);
        if (fullDictBlock.insert(entry)) {
            return null;
        }
        FullDictBlock fullDictBlock2 = this.getNewBlock();
        Entry entry2 = fullDictBlock.split(fullDictBlock2);
        fullDictBlock2.setBlockNumbers(this.blocks);
        if (!(entry2.smallerThan(entry) ? fullDictBlock2 : fullDictBlock).insert(entry)) {
            throw new Exception("entry didn't fit into a freshly split block");
        }
        return entry2;
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            Schema schema = new Schema(null, stringArray[0], true);
            BtreeDictParameters btreeDictParameters = new BtreeDictParameters(schema, "TMAP");
            if (!btreeDictParameters.readState()) {
                btreeDictParameters.setBlockSize(2048);
                btreeDictParameters.setRoot(0);
                btreeDictParameters.setFreeID(1);
            }
            FullBtreeDict fullBtreeDict = new FullBtreeDict(btreeDictParameters, true);
            int n = btreeDictParameters.getFreeID();
            LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(stringArray[1])));
            while ((string = lineNumberReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("storing")) {
                        fullBtreeDict.store(stringTokenizer.nextToken(), n++);
                        continue;
                    }
                    if (!string2.equals("fetching")) continue;
                    fullBtreeDict.fetch(stringTokenizer.nextToken());
                }
            }
            lineNumberReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("FullBtreeDict: " + string);
        }
    }

    protected class FullDictBlock
    extends BtreeDict.DictBlock {
        protected FullDictBlock() {
            super(FullBtreeDict.this);
        }

        public void setFree(int n) {
            this.free = n - this.firstEntry();
            this.data[n + 1] = 0;
            this.data[n] = 0;
        }

        public void setNumberOfEntries(int n) {
            this.setIntegerAt(0, n);
        }

        protected void setChildIndex(int n, int n2) {
            this.setIntegerAt(4 * (508 - n + 1), n2);
        }

        public void setEntryID(int n, int n2) {
            this.setIntegerAt(n + 2, n2);
        }

        private boolean insert(Entry entry) {
            byte[] byArray = entry.key;
            int n = byArray.length - 1;
            int n2 = this.free();
            int n3 = this.firstEntry();
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n3 != n2) {
                if (n6 == n4) {
                    int n8 = this.entryKeyLength(n3);
                    int n9 = this.entryKey(n3);
                    n5 = n4;
                    int n10 = 0;
                    while (n10 < n8 && byArray[n4] == this.data[n9 + n10]) {
                        ++n4;
                        ++n10;
                    }
                    if (n10 == n8) {
                        if (n4 == n) {
                            this.setEntryID(n3, entry.id);
                            return true;
                        }
                    } else if ((byArray[n4] & 0xFF) < (this.data[n9 + n10] & 0xFF)) {
                        return this.insert(entry, n3, n5, n4, n7);
                    }
                } else if (n6 < n4) {
                    return this.insert(entry, n3, n4, n6, n3 == n2 ? this.numberOfEntries() : n7);
                }
                do {
                    n3 = this.nextEntry(n3);
                    ++n7;
                } while (this.entryCompression(n3) > n4);
                n6 = this.entryCompression(n3);
            }
            return this.insert(entry, n3, n4, 0, this.numberOfEntries());
        }

        public void makeEntry(int n, byte[] byArray, int n2, int n3, int n4) {
            this.data[n] = (byte)n3;
            this.data[n + 1] = (byte)n4;
            this.setEntryID(n, n2);
            System.arraycopy(byArray, n4, this.data, this.entryKey(n), n3);
        }

        private boolean insert(Entry entry, int n, int n2, int n3, int n4) {
            int n5;
            byte[] byArray = entry.key;
            int n6 = byArray.length - 1 - n2;
            int n7 = this.free();
            int n8 = 6 + n6;
            int n9 = 0;
            if (n < n7 && this.entryCompression(n) < n3) {
                n9 = n3 - this.entryCompression(n);
            }
            int n10 = n5 = this.isLeaf ? 2038 : 4 * (508 - this.numberOfEntries() - 1);
            if (n7 + n8 - n9 <= n5) {
                int n11;
                if (n < n7) {
                    n11 = n9 > 0 ? n + 6 + n9 : n;
                    System.arraycopy(this.data, n11, this.data, n11 + n8 - n9, n7 - n11);
                    if (n9 > 0) {
                        int n12 = n;
                        this.data[n12] = (byte)(this.data[n12] - n9);
                        int n13 = n + 1;
                        this.data[n13] = (byte)(this.data[n13] + n9);
                        System.arraycopy(this.data, n, this.data, n + n8, 6);
                    }
                }
                this.makeEntry(n, byArray, entry.id, n6, n2);
                if (!this.isLeaf) {
                    n11 = 4 * (508 - this.numberOfEntries() + 1);
                    System.arraycopy(this.data, n11, this.data, n11 - 4, 4 * (this.numberOfEntries() - n4));
                    this.setChildIndex(n4 + 1, entry.block);
                }
                this.setFree(n7 + n8 - n9);
                this.setNumberOfEntries(this.numberOfEntries() + 1);
                return true;
            }
            return false;
        }

        public int insertInternal(Entry entry) {
            byte[] byArray = entry.key;
            int n = byArray.length - 1;
            int n2 = this.firstEntry();
            int n3 = this.free();
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n2 != n3) {
                if (n5 == n4) {
                    int n7 = this.entryKeyLength(n2);
                    int n8 = this.entryKey(n2);
                    int n9 = 0;
                    while (n9 < n7 && byArray[n4] == this.data[n8 + n9]) {
                        ++n4;
                        ++n9;
                    }
                    if (n9 == n7) {
                        if (n4 == n) {
                            this.setEntryID(n2, entry.id);
                            return -1;
                        }
                    } else if ((byArray[n4] & 0xFF) < (this.data[n8 + n9] & 0xFF)) {
                        return n6;
                    }
                } else if (n5 < n4) {
                    return n2 >= n3 ? this.numberOfEntries() : n6;
                }
                do {
                    n2 = this.nextEntry(n2);
                    ++n6;
                } while (this.entryCompression(n2) > n4);
                n5 = this.entryCompression(n2);
            }
            return this.numberOfEntries();
        }

        private Entry split(FullDictBlock fullDictBlock) {
            byte[] byArray = new byte[255];
            int n = this.free();
            int n2 = n / 2;
            int n3 = 0;
            fullDictBlock.isLeaf = this.isLeaf;
            int n4 = this.firstEntry();
            while (n4 < n2) {
                this.restoreKeyInBuffer(n4, byArray);
                ++n3;
                n4 = this.nextEntry(n4);
            }
            int n5 = this.numberOfEntries() - n3 - 1;
            this.restoreKeyInBuffer(n4, byArray);
            int n6 = this.entryKeyLength(n4) + this.entryCompression(n4);
            Entry entry = new Entry(byArray, n6, this.entryID(n4));
            entry.block = fullDictBlock.number;
            int n7 = n4;
            n4 = this.nextEntry(n4);
            this.restoreKeyInBuffer(n4, byArray);
            n6 = this.entryKeyLength(n4) + this.entryCompression(n4);
            int n8 = this.firstEntry();
            fullDictBlock.makeEntry(n8, byArray, this.entryID(n4), n6, 0);
            n4 = this.nextEntry(n4);
            System.arraycopy(this.data, n4, fullDictBlock.data, fullDictBlock.nextEntry(n8), n - n4);
            fullDictBlock.setNumberOfEntries(n5);
            fullDictBlock.setFree(fullDictBlock.nextEntry(n8) + n - n4);
            if (!this.isLeaf) {
                int n9 = 4 * (508 - this.numberOfEntries() + 1);
                System.arraycopy(this.data, n9, fullDictBlock.data, n9 + 4 * (n3 + 1), 4 * (n5 + 1));
            }
            this.setFree(n7);
            this.setNumberOfEntries(n3);
            return entry;
        }

        public void initInternal(int n, Entry entry) {
            this.isLeaf = false;
            this.setNumberOfEntries(1);
            this.setChildIndex(0, n);
            this.setChildIndex(1, entry.block);
            int n2 = this.firstEntry();
            this.makeEntry(n2, entry.key, entry.id, entry.key.length - 1, 0);
            this.setFree(this.nextEntry(n2));
        }
    }

    private final class Entry {
        public byte[] key;
        public int id;
        public int block = -1;

        public Entry(byte[] byArray, int n, int n2) {
            this.key = new byte[n + 1];
            System.arraycopy(byArray, 0, this.key, 0, n);
            this.key[n] = 0;
            this.id = n2;
        }

        public boolean smallerThan(Entry entry) {
            int n = 0;
            while (n < Math.min(this.key.length, entry.key.length)) {
                if (this.key[n] != entry.key[n]) {
                    return (this.key[n] & 0xFF) < (entry.key[n] & 0xFF);
                }
                ++n;
            }
            return false;
        }
    }
}

