/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object object) {
        this.value = object;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread thread2 = this.threadVar.get();
        if (thread2 != null) {
            thread2.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread thread2;
        while ((thread2 = this.threadVar.get()) != null) {
            try {
                thread2.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable runnable = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                    Object var2_1 = null;
                    SwingWorker.this.threadVar.clear();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    SwingWorker.this.threadVar.clear();
                    throw throwable;
                }
                SwingUtilities.invokeLater(runnable);
            }
        };
        Thread thread2 = new Thread(runnable2);
        this.threadVar = new ThreadVar(thread2);
    }

    public void start() {
        this.start(5);
    }

    public void start(int n) {
        Thread thread2 = this.threadVar.get();
        if (thread2 != null) {
            if (n < 10 && n > 1) {
                thread2.setPriority(n);
            }
            thread2.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread2) {
            this.thread = thread2;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

