; $Id$
;###############################################################################
;+
; NAME:
;   wd_aboutDAVE
;
; PURPOSE:
;   Implements the About DAVE dialog. Based on IDLitwdAbout.
;
; CATEGORY:
;   DAVE Widgets
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Sep 2006
;-
;###############################################################################

;===============================================================================
; wd_aboutDAVE__event
;
; Purpose:
;   Event handler
pro wd_aboutDAVE_event, event
  compile_opt idl2
  
  widget_control, event.id, get_uvalue=uval
  if(n_elements(uval) gt 0)then begin
     if(uval eq 'close')then  $
        widget_control, event.top, /destroy
  endif
  
end


;===============================================================================
function wd_aboutDAVEGetText, type=type
  compile_opt idl2
  text = ''

  catch, iErr
  if (iErr ne 0) then begin
     catch, /cancel
     if (n_elements(lun) gt 0) then free_lun, lun, /force
     return, text
  endif

  case strupcase(type) of
     'VERSION': filename = !DAVE_AUXILIARY_DIR+'version.txt'
     'LICENSE': filename = !DAVE_AUXILIARY_DIR+'license.txt'
     'ABOUT': filename = !DAVE_AUXILIARY_DIR+'aboutdave.txt'
     'BUILDDATE': filename=!DAVE_AUXILIARY_DIR+'builddate.txt'
     else: return, text
  endcase 

  ;; open file and read contents
  nlines = file_lines(filename)
  if (nlines le 0) then return, ''
  openr, lun, filename, /get_lun
  text = strarr(nlines)
  readf,lun,text
  free_lun, lun, /force

  return, text
end


;===============================================================================
;; See file header for API
;;
function  wd_aboutDAVE,  group_leader=group_leader
  compile_opt idl2

  dave_version = wd_aboutDAVEGetText(type='version')
  license = wd_aboutDAVEGetText(type='license')
  builddate = wd_aboutDAVEGetText(type='builddate')
  strAbout = wd_aboutDAVEGetText(type='about')
  print,builddate

  license = [license,'']
  nlines = n_elements(strAbout)
  strAbout = [strAbout[0],dave_version,'Built on: '+builddate,strAbout[1:nlines-1]]

  license += ''

  title = 'About DAVE'

  ;; Okay, create our modal TLB
  wTLB = Widget_Base(/modal,/col,group_leader=group_leader,tlb_frame_attr=1,title=title $
                     ,/base_align_right $
                     ,SPACE=2 $
                    )

  wTAB = widget_tab(wTLB)
  
  ;; Cannot guarantee the existence of fonts on Motif, but can on Windoze

  font = (!version.os_family eq 'Windows')? 'Lucida Sans Typewriter*24' : $
         'lucidasanstypewriter-18'
  font1 = (!version.os_family eq 'Windows')? 'Lucida Sans Typewriter*18' : $
         'lucidasanstypewriter-12'
  font2 = (!version.os_family eq 'Windows')? 'Lucida Sans Typewriter*14' : $
         'lucidasanstypewriter-10'
;       font = (!version.os_family eq 'Windows')? 'Courier New*24*Bold' : $
;         '-adobe-courier-bold-o-normal--24-240-75-75-m-150-iso8859-1'
;       font1 = (!version.os_family eq 'Windows')? 'Courier New*18*Bold' : $
;         '-adobe-courier-bold-o-normal--18-180-75-75-m-110-iso8859-1'
;       font2 = (!version.os_family eq 'Windows')? 'Courier New*14' : $
;         '-adobe-courier-medium-o-normal--14-140-75-75-m-90-iso8859-1'

  ;; Get the image
;  bHaveImg = IDLitGetResource("itools_about", img)
;bHaveImg = IDLitGetResource(!dave_auxiliary_dir+'dave_logo_90.png', img)
;bHaveImg = IDLitGetResource(!dave_auxiliary_dir+'dave_logo_90.bmp', img)
read_png,!dave_auxiliary_dir+'dave_logo_90.png',img
bHaveImg = (n_elements(img) gt 0)? 1 : 0

  ;; new tab
  wCB1 = Widget_Base(wTAB, /row,title='About')
  
  if (bHaveImg) then begin
     szImage = size(img)
     ;wDraw1 = widget_draw(wCB1, xsize=szImage[1], ysize=szImage[2], retain=2)
     wDraw1 = widget_draw(wCB1, xsize=100, ysize=300, retain=2)
  endif
  
  IDLge91 = (Float(!version.release) ge 9.1)? 1 : 0
  wCB11 = widget_base(wCB1,/col)
  if (IDLge91) then begin
    void = widget_label(wCB11, /align_center, value=strAbout[0], font=font,foreground_color=[255,0,0],background_color=[150,255,255])
    for i=1, 2 do void = widget_label(wCB11, /align_center, value=strAbout[i],font=font1,foreground_color=[0,0,255])
  endif else begin
    void = widget_label(wCB11, /align_center, value=strAbout[0], font=font)
    for i=1, 2 do void = widget_label(wCB11, /align_center, value=strAbout[i],font=font1)
  endelse
  for i=3, n_elements(strAbout)-1 do $
     void = widget_label(wCB11, /align_center, value=strAbout[i],font=font1)
 
   ;; new tab
   wCB2 = Widget_base(wTAB, /row,title='License (Disclaimer)')

  ;; new tab
  wCB3 = Widget_Base(wTAB, /row,title='IDL Version Details')

  if (bHaveImg) then begin
     szImage = size(img)
     ;wDraw2 = widget_draw(wCB2, xsize=szImage[1], ysize=szImage[2], retain=2)
     wDraw3 = widget_draw(wCB3, xsize=100, ysize=300, retain=2)
  endif

  wCB31 = widget_base(wCB3,/col)
  tags = tag_names(!version)
  ntags = n_tags(!version)
  for i=0, 1 do void = widget_label(wCB31, value=' ', font=font) ; vspaces
  fg_col = [[255,0,0],[0,0,255]]
  for i=0, ntags-1 do begin
     label=string(tags[i], ':', strtrim(string(!version.(i)),2), format='(T5,A,A,T25,A)')
     void = widget_label(wCB31,/align_left, value=label, font=font, foreground_color=fg_col[*, i mod 2])
  endfor


  
  if (bHaveImg) then begin
     szImage = size(img)
     ;wDraw2 = widget_draw(wCB2, xsize=szImage[1], ysize=szImage[2], retain=2)
     wDraw2 = widget_draw(wCB2, xsize=100, ysize=300, retain=2)
  endif
  
  wCB21 = widget_base(wCB2,/col)
  
  for i=0, n_elements(license)-1 do $
     void = widget_label(wCB21, /align_center, value=license[i],font=font1);font2)

  ;; Add a Close button.
  wCB4 = Widget_base(wTLB, /align_center,/row,  space=3)
  wOK = Widget_Button(wCB4, value='OK',uvalue='close')
  
  widget_control, wTLB, /realize
  
  if(bHaveImg)then begin
     device, get_decomposed=old_dc ; play nice!

     Widget_Control, wDraw1, get_value=idxDraw
     wset,idxDraw
     device,decompose=1
     ;tv,img, true=3
     tvimage, img
     Widget_Control, wDraw2, get_value=idxDraw
     wset,idxDraw
     device,decompose=1
     tvimage, img
     Widget_Control, wDraw3, get_value=idxDraw
     wset,idxDraw
     device,decompose=1
     tvimage, img

     device, decomposed=old_dc  ; play nice!
  endif
  
  xmanager, 'wd_aboutDAVE', wTLB
  
  return, 1
end
