function ui_selectDir, oUI, oRequester
compile_opt idl2

;; Retrieve widget ID of top-level base.
oUI->GetProperty, GROUP_LEADER=groupLeader

;; Retrieve working directory.
oRequester->GetProperty, propToBeModified=prop2Mod
path = ''
case prop2Mod of
    'WORKING_DIRECTORY': oRequester->GetProperty, WORKING_DIRECTORY=path
    'DATA_DIRECTORY': oRequester->GetProperty, DATA_DIRECTORY=path
    else:
endcase


directory = DIALOG_PICKFILE(/DIRECTORY,path=path,title='Select Directory',dialog_parent=groupLeader)

if (directory eq '') then return, 0

case prop2Mod of
    'WORKING_DIRECTORY': oRequester->SetProperty, WORKING_DIRECTORY=directory
    'DATA_DIRECTORY': oRequester->SetProperty, DATA_DIRECTORY=directory
    else:
endcase

return, 1
end
