; $Id$
;###############################################################################
;+
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the DAVETool.
;
; CATEGORY:
;   DAVE Main Tool

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of the DAVETool object
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2004
;-
;###############################################################################





;===============================================================================
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the BT7PSDTool.
;
; CATEGORY:
;   BT7 PSD Reduction

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of BT7PSDTool object
;
pro bt7psd,  identifier=identifier, group_leader=gl, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

;Okay, launch the Main Tool
title = "BT7PSD Data Reduction"
identifier = IDLITSYS_CREATETOOL("BT7PSDMain", name="Preferences" $
                                 ,title=title $ ;  ,/debug
                                 ;,dimensions=[800,800] $  ;[650,550] $
                                 ,USER_INTERFACE="BT7PSD Main Interface" $
                                )

oSystem = oDaveTool->GetSystem()
oBT7PSDTool = oSystem->GetByIdentifier(identifier)

; Make widget hierarchy with this tool a child of the DAVETool
oBT7PSDUI = oBT7PSDTool->GetUI()
oBT7PSDUI->GetProperty, group_leader=wBT7PSDTLB
widget_control, wBT7PSDTLB, group_leader=gl

; Set system preferences
oBT7PSDTool->SetProperty, DAVETool=oDAVETool $
                      ,data_directory=dataDir $
                      ,working_directory=workDir $
                      ,name = 'Preferences'  ; b/c want the property sheet in main window to have this label
if (obj_valid(oBT7PSDTool)) then  oBT7PSDTool->InitPreferences

; Additional necessary defaults:
; - Set the Automatic Window Resize property of the graphics window to true
; - Set the Stretch to Fit property of the view to true also
; Those two are handy for proper functioning of the generated plots when the user modifies
; the window dimensions or the graphics itself.
oWin = oBT7PSDTool->GetCurrentWindow()
oWin->SetProperty, auto_resize = 1
oView = oWin->GetCurrentView()
oView->SetProperty, stretch = 1
end
