; $Id$
;
; Copyright (c) 2000-2004, Research Systems, Inc.  All rights reserved.
;   Unauthorized reproduction prohibited.
;----------------------------------------------------------------------------
;+
; CLASS_NAME:
;   IDLitToolbase
;
; PURPOSE:
;   This file implements the SPINS PSD Tool object
;
; CATEGORY:
;   
;
; SUPERCLASSES:
;   IDLitTool
;
; SUBCLASSES:
;
; CREATION:
;   See IDLitToolbase::Init
;
; METHODS:
;   This class has the following methods:
;
;   IDLitToolbase::Init
;
; INTERFACES:
; IIDLProperty
;-



;===============================================================================
; SPINSPSDCalibTool::GetSystem
; 
; PURPOSE:
;   Return the IDLitSystem object
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSPSDCalibTool::GetSystem
compile_opt idl2

return, self->_GetSystem()

end


;===============================================================================
; SPINSPSDCalibTool::GetUI
; 
; PURPOSE:
;   Return the IDLitUI object for this tool
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSPSDCalibTool::GetUI
compile_opt idl2

return, self._oUIConnection

end


;-------------------------------------------------------------------------------
pro SPINSPSDCalibTool::Cleanup
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::Cleanup: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle)

        catch, /cancel
        ptr_free, Self.prefsPtr
        ptr_free, Self.historyPtr
        Self->IDLitTool::Cleanup
        Self->EnableUpdates
        return
    endif
endif

Self->DisableUpdates

; save session preferences
status = Self->SavePreferences()

ptr_free, Self.prefsPtr
ptr_free, Self.historyPtr

;; Clean up samp container
;oItems = Self.calibContRef->Get(/all, count=n)
;if (n gt 0) then begin
;   for i=0,n-1 do begin
;      void = oItems[i]->GetMetaData('DATAPTRREF',dataPtr)
;      if (ptr_valid(dataPtr)) then heap_free, dataPtr
;   endfor
;endif

;; Clean up samp container
;oItems = Self.bkgdContRef->Get(/all, count=n)
;if (n gt 0) then begin
;   for i=0,n-1 do begin
;      void = oItems[i]->GetMetaData('DATAPTRREF',dataPtr)
;      if (ptr_valid(dataPtr)) then heap_free, dataPtr
;   endfor
;endif
;
;
;obj_destroy, [Self.calibContRef,Self.bkgdContRef]
;
;obj_destroy, Self.calibContRef

; Call base class cleanup
self->IDLitTool::Cleanup

Self->EnableUpdates

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; SPINSPSDCalibTool::savePreferences
;
; PURPOSE:
;   Update and save current user preferences
;
; PARAMETERS:
;
; RETURN VALUE:
;-
function SPINSPSDCalibTool::SavePreferences, skip_filesave=skip_filesave
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::savePreferences: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

; Save current user graphic customizations and preferences
if (Self->HasVisualizations()) then begin
   oWin = Self->GetCurrentWindow()
   oView = oWin->GetCurrentView()
   oLayer = oView->GetCurrentLayer()
   oWorld = oLayer->GetWorld()
   oDataSpace = oWorld->GetDataSpaces()
   oVis = oDataSpace->GetVisualizations(count = nVis)
   
   for j=nVis-1,0,-1 do begin
      oVis[j]->Select
      Self->saveVisProps, oVis[j]
   endfor
endif

Self->GetProperty, preferences=preferences

if keyword_set(skip_filesave) then return, 1

if (n_elements(preferences) gt 0) then $
   status = SPINSPSDcalibPreferences(preferences, /save)

return, 1

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSPSDCalibTool::Exit
;+
; PURPOSE:
;   Exit handler
;
; PARAMETERS:
;
; RETURN VALUE:
;-
function SPINSPSDCalibTool::Exit
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::Exit: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wd_SPINSPSDCalibTool_event, { WIDGET_KILL_REQUEST, ID:wTLB, TOP:wTLB, HANDLER:wTLB }

return, 1
end


;-------------------------------------------------------------------------------
pro SPINSPSDCalibTool::GetProperty, nameTag=nameTag, prompt=prompt, prmptTitle=prmptTitle, prmptDesc=prmptDesc $
 ,anaModeFlag=anaModeFlag,a4Flag=a4Flag,calibFilename=calibFilename,a4calibFilename=a4calibFilename $
 ,plotFlag=plotFlag,dpdEfCorFlag=dpdEfCorFlag,thetagValue=thetagValue,calibFilePresent=calibFilePresent $
 ,a4calibFilePresent=a4calibFilePresent,requireProcessing=requireProcessing $
 ,pixelNumber=pixelNumber, instrumentName=instrumentName,maskThreshold=maskThreshold, maskedPixels=maskedPixels $
 ,nActiveDetectors=nActiveDetectors,energyUnitFlag=energyUnitFlag $
 ,maskedDets=maskedDets,fastFunc=fastFunc,monScaleValue=monScaleValue,multipleMsliceWinFlag=multipleMsliceWinFlag $
 ,monScaleFlag=monScaleFlag,maskFlag=maskFlag,bkgdFlag=bkgdFlag,calibParamsisSet=calibParamsisSet $
 ,fastFlag=fastFlag,nSamp=nSamp,nBkgd=nBkgd,nFast=nFast,effNormFlag=effNormFlag,logFlag=logFlag $
 ,sumSampFlag=sumSampFlag,sumBkgdFlag=sumBkgdFlag, chDelA4isSet=chDelA4isSet, curMaxDataLen=curMaxDataLen $
 ,calibContRef=calibContRef,bkgdContRef=bkgdContRef,fastContRef=fastContRef,phiOffset=phiOffset $
 ,data_directory=dataDir,mev2wnos=mev2wnos,fastparams=fastparams, daveTool=daveTool $
 ,sampSelected=sampSelected, bkgdSelected=bkgdSelected, fastSelected=fastSelected $
 ,preferences=preferences,history=history,oplotFastFitFlag=oplotFastFitFlag $
 ,minChan=minChan,maxChan=maxChan,minDPnt=minDPnt,maxDPnt=maxDPnt,dpntIndex=dpntIndex $
 ,A6Value=A6Value, A4Value=A4Value, A4Width=A4Width $
 ,oplotBkgdFlag=oplotBkgdFlag, modifiedStatus=modifiedStatus, ftpObject=ftpObject $
 ,defaultIntensityFlag=defaultIntensityFlag, maxIntensity=maxIntensity, minIntensity=minIntensity $
 ,latParamFlag=latParamFlag, latticeParameters=latticeParameters, qUnits=qUnits $
 ,xAxisVar=xAxisVar,yAxisVar=yAxisVar,exportIndex=exportIndex,minBinWidth=minBinWidth,binwidths=binWidths $
 ,indepVar1List=indepVar1List,indepVar2List=indepVar2List,indepVar3List=indepVar3List $
 ,detailedBalanceFlag=detailedBalanceFlag,fastValue=fastValue, resCorFlag=resCorFlag $
 ,monCorFlag=monCorFlag, normalizeTo=normalizeTo, sampTypeFlag=sampTypeFlag,mergePixelsFlag=mergePixelsFlag $
 ,selectedIDs=selectedIDs,nSelectedIDs=nSelectedIDs,selectedNames=selectedNames  $
 ,s_errorbar_capsize=s_errorbar_capsize $
 ,s_transparency=s_transparency $
 ,s_antialias=s_antialias $
 ,s_color=s_color $
 ,s_errorbar_color=s_errorbar_color $
 ,s_use_default_color=s_use_default_color $
 ,s_sym_increment=s_sym_increment $
 ,s_sym_index=s_sym_index $
 ,s_sym_size=s_sym_size $
 ,s_sym_color=s_sym_color $
 ,s_sym_thick=s_sym_thick $
 ,s_y_errorbars=s_y_errorbars $
 ,s_linestyle=s_linestyle $
 ,s_thick=s_thick $
 ,s_sym_filled=s_sym_filled $
 ,s_sym_fill_color=s_sym_fill_color $
 ,s_font_name=s_font_name  $
 ,s_font_size=s_font_size $
 ,s_text_color=s_text_color  $
 ,b_errorbar_capsize=b_errorbar_capsize $
 ,b_transparency=b_transparency $
 ,b_antialias=b_antialias $
 ,b_color=b_color $
 ,b_errorbar_color=b_errorbar_color $
 ,b_use_default_color=b_use_default_color $
 ,b_sym_increment=b_sym_increment $
 ,b_sym_index=b_sym_index $
 ,b_sym_size=b_sym_size $
 ,b_sym_color=b_sym_color $
 ,b_sym_thick=b_sym_thick $
 ,b_y_errorbars=b_y_errorbars $
 ,b_linestyle=b_linestyle $
 ,b_thick=b_thick $
 ,b_sym_filled=b_sym_filled $
 ,b_sym_fill_color=b_sym_fill_color $
 ,b_font_name=b_font_name  $
 ,b_font_size=b_font_size $
 ,b_text_color=b_text_color  $
 ,f_errorbar_capsize=f_errorbar_capsize $
 ,f_transparency=f_transparency $
 ,f_antialias=f_antialias $
 ,f_color=f_color $
 ,f_errorbar_color=f_errorbar_color $
 ,f_use_default_color=f_use_default_color $
 ,f_sym_increment=f_sym_increment $
 ,f_sym_index=f_sym_index $
 ,f_sym_size=f_sym_size $
 ,f_sym_color=f_sym_color $
 ,f_sym_thick=f_sym_thick $
 ,f_y_errorbars=f_y_errorbars $
 ,f_linestyle=f_linestyle $
 ,f_thick=f_thick $
 ,f_sym_filled=f_sym_filled $
 ,f_sym_fill_color=f_sym_fill_color $
 ,f_font_name=f_font_name  $
 ,f_font_size=f_font_size $
 ,f_text_color=f_text_color  $
 ,ff_transparency=ff_transparency $
 ,ff_antialias=ff_antialias $
 ,ff_color=ff_color $
 ,ff_use_default_color=ff_use_default_color $
 ,ff_sym_index=ff_sym_index $
 ,ff_linestyle=ff_linestyle $
 ,ff_thick=ff_thick $
 ,sb_transparency=sb_transparency $
 ,sb_antialias=sb_antialias $
 ,sb_color=sb_color $
 ,sb_use_default_color=sb_use_default_color $
 ,sb_sym_index=sb_sym_index $
 ,sb_linestyle=sb_linestyle $
 ,sb_thick=sb_thick $
 ,fill_background=fill_background $
 ,fill_level=fill_level $
 ,fill_color=fill_color $
 ,fill_transparency=fill_transparency $
 ,_REF_EXTRA=etc

compile_opt idl2

; daveTool
if (arg_present(daveTool)) then $
  daveTool = self.daveTool

if (arg_present(s_errorbar_capsize)) then s_errorbar_capsize=Self.s_errorbar_capsize
if (arg_present(s_transparency)) then s_transparency=Self.s_transparency
if (arg_present(s_antialias)) then s_antialias=Self.s_antialias
if (arg_present(s_color)) then s_color=Self.s_color
if (arg_present(s_errorbar_color)) then s_errorbar_color=Self.s_errorbar_color
if (arg_present(s_use_default_color)) then s_use_default_color=Self.s_use_default_color 
if (arg_present(s_sym_increment)) then s_sym_increment=Self.s_sym_increment 
if (arg_present(s_sym_index)) then s_sym_index=Self.s_sym_index 
if (arg_present(s_sym_size)) then s_sym_size=Self.s_sym_size 
if (arg_present(s_sym_color)) then s_sym_color=Self.s_sym_color 
if (arg_present(s_sym_thick)) then s_sym_thick=Self.s_sym_thick 
if (arg_present(s_y_errorbars)) then s_y_errorbars=Self.s_y_errorbars
if (arg_present(s_linestyle)) then s_linestyle=Self.s_linestyle
if (arg_present(s_thick)) then s_thick=Self.s_thick
if (arg_present(s_sym_filled)) then s_sym_filled=Self.s_sym_filled
if (arg_present(s_sym_fill_color)) then s_sym_fill_color=Self.s_sym_fill_color
if (arg_present(s_font_name)) then s_font_name=Self.s_font_name
if (arg_present(s_font_size)) then s_font_size=Self.s_font_size
if (arg_present(s_text_color)) then s_text_color=Self.s_text_color
if (arg_present(b_errorbar_capsize)) then b_errorbar_capsize=Self.b_errorbar_capsize
if (arg_present(b_transparency)) then b_transparency=Self.b_transparency
if (arg_present(b_antialias)) then b_antialias=Self.b_antialias
if (arg_present(b_color)) then b_color=Self.b_color
if (arg_present(b_errorbar_color)) then b_errorbar_color=Self.b_errorbar_color
if (arg_present(b_use_default_color)) then b_use_default_color=Self.b_use_default_color
if (arg_present(b_sym_increment)) then b_sym_increment=Self.b_sym_increment
if (arg_present(b_sym_index)) then b_sym_index=Self.b_sym_index
if (arg_present(b_sym_size)) then b_sym_size=Self.b_sym_size
if (arg_present(b_sym_color)) then b_sym_color=Self.b_sym_color
if (arg_present(b_sym_thick)) then b_sym_thick=Self.b_sym_thick
if (arg_present(b_y_errorbars)) then b_y_errorbars=Self.b_y_errorbars
if (arg_present(b_linestyle)) then b_linestyle=Self.b_linestyle
if (arg_present(b_thick)) then b_thick=Self.b_thick
if (arg_present(b_sym_filled)) then b_sym_filled=Self.b_sym_filled
if (arg_present(b_sym_fill_color)) then b_sym_fill_color=Self.b_sym_fill_color
if (arg_present(b_errorbar_capsize)) then b_errorbar_capsize=Self.b_errorbar_capsize
if (arg_present(b_font_name)) then b_font_name=Self.b_font_name
if (arg_present(b_font_size)) then b_font_size=Self.b_font_size
if (arg_present(b_text_color)) then b_text_color=Self.b_text_color
if (arg_present(f_transparency)) then f_transparency=Self.f_transparency
if (arg_present(f_antialias)) then f_antialias=Self.f_antialias
if (arg_present(f_color)) then f_color=Self.f_color
if (arg_present(f_errorbar_color)) then f_errorbar_color=Self.f_errorbar_color
if (arg_present(f_use_default_color)) then f_use_default_color=Self.f_use_default_color
if (arg_present(f_sym_increment)) then f_sym_increment=Self.f_sym_increment
if (arg_present(f_sym_index)) then f_sym_index=Self.f_sym_index
if (arg_present(f_sym_size)) then f_sym_size=Self.f_sym_size
if (arg_present(f_sym_color)) then f_sym_color=Self.f_sym_color
if (arg_present(f_sym_thick)) then f_sym_thick=Self.f_sym_thick
if (arg_present(f_y_errorbars)) then f_y_errorbars=Self.f_y_errorbars
if (arg_present(f_linestyle)) then f_linestyle=Self.f_linestyle
if (arg_present(f_thick)) then f_thick=Self.f_thick
if (arg_present(f_sym_filled)) then f_sym_filled=Self.f_sym_filled
if (arg_present(f_sym_fill_color)) then f_sym_fill_color=Self.f_sym_fill_color
if (arg_present(f_font_name)) then f_font_name=Self.f_font_name
if (arg_present(f_font_size)) then f_font_size=Self.f_font_size
if (arg_present(f_text_color)) then f_text_color=Self.f_text_color
if (arg_present(fill_background)) then fill_background=Self.fill_background
if (arg_present(fill_level)) then fill_level=Self.fill_level
if (arg_present(fill_color)) then fill_color=Self.fill_color
if (arg_present(fill_transparency)) then fill_transparency=Self.fill_transparency
;if (arg_present(ff_transparency)) then ff_transparency=Self.ff_transparency
;if (arg_present(ff_antialias)) then ff_antialias=Self.ff_antialias
;if (arg_present(ff_color)) then ff_color=Self.ff_color
;if (arg_present(ff_use_default_color)) then ff_use_default_color=Self.ff_use_default_color
;if (arg_present(ff_sym_index)) then ff_sym_index=Self.ff_sym_index
;if (arg_present(ff_linestyle)) then ff_linestyle=Self.ff_linestyle
;if (arg_present(ff_thick)) then ff_thick=Self.ff_thick
;if (arg_present(sb_transparency)) then sb_transparency=Self.sb_transparency
;if (arg_present(sb_antialias)) then sb_antialias=Self.sb_antialias
;if (arg_present(sb_color)) then sb_color=Self.sb_color
;if (arg_present(sb_use_default_color)) then sb_use_default_color=Self.sb_use_default_color
;if (arg_present(sb_sym_index)) then sb_sym_index=Self.sb_sym_index
;if (arg_present(sb_linestyle)) then sb_linestyle=Self.sb_linestyle
;if (arg_present(sb_thick)) then sb_thick=Self.sb_thick

; Preferences structure
if (arg_present(preferences)) then begin
   if (ptr_valid(Self.prefsPtr)) then begin
      preferences = (*self.prefsPtr)

      ; update the preferences structure
      ntags = n_tags(preferences)
      tags = tag_names(preferences)
      for i=0,ntags-1 do begin
         status = Self->GetPropertyByIdentifier(tags[i], value)
         if (status) then preferences.(i) = strjoin(strtrim(string(value),2),',')
;         if (~status) then continue
;         if (strmatch(tags[i],'*color*',/fold_case)) then begin
;            ; for colors, first convert byte vector to a string eg [0,128,0] to '0,128,0'
;            preference.(i) = strjoin(value,',')
;         endif else $
;            preferences.(i) = value
      endfor
   endif
endif

;
if (arg_present(instrumentName)) then instrumentName = Self.instrumentName
;
if (arg_present(maskThreshold)) then maskThreshold = Self.maskThreshold
;
if (arg_present(maskedPixels)) then maskedPixels = Self.maskedPixels
;
if (arg_present(A6Value)) then A6Value = Self.A6Value
;
if (arg_present(A4Value)) then A4Value = Self.A4Value
;
if (Arg_present(A4Width)) then A4Width = Self.A4Width
;
if (arg_present(anaModeFlag)) then anaModeFlag = Self.anaModeFlag
;
if (arg_present(a4Flag)) then a4Flag = Self.a4Flag
;
if (arg_present(calibFilename)) then calibFilename = Self.calibFilename
;
if (arg_present(a4calibFilename)) then a4calibFilename = Self.a4calibFilename
;
if (arg_present(plotFlag)) then plotFlag = Self.plotFlag
;
if (arg_present(pixelNumber)) then pixelNumber = Self.pixelNumber
;
if (arg_present(dpdEfCorFlag)) then dpdEfCorFlag = Self.dpdEfCorFlag
;
if (arg_present(thetagValue)) then thetagValue = Self.thetagValue
;
if (arg_present(calibFilePresent)) then calibFilePresent = Self.calibFilePresent
;
if (arg_present(a4calibFilePresent)) then a4calibFilePresent = Self.a4calibFilePresent
;
if (arg_present(requireProcessing)) then requireProcessing = Self.requireProcessing
; modifiedStatus
if (arg_present(modifiedStatus)) then modifiedStatus = self.modifiedFlag
; nameTag
if (arg_present(nameTag)) then nameTag = self.nameTag
; nameTag
if (arg_present(history)) then history = (*Self.historyPtr)
; prompt
if (arg_present(prompt)) then prompt = self.prompt
; prompt Title
if (arg_present(prmptTitle)) then prmptTitle = self.promptTitle
; prompt Desc
if (arg_present(prmptDesc)) then prmptDesc = self.promptDesc
;
if (arg_present(nSamp)) then nSamp = Self.nSamp
;
if (arg_present(nBkgd)) then nBkgd = Self.nBkgd
;
if (arg_present(nFast)) then nFast = Self.nFast
;
if (arg_present(sampSelected)) then sampSelected = Self.sampSelected
;
if (arg_present(bkgdSelected)) then bkgdSelected = Self.bkgdSelected
;
if (arg_present(fastSelected)) then fastSelected = Self.fastSelected
;
if (arg_present(calibContRef)) then calibContRef = Self.calibContRef
;
if (arg_present(bkgdContRef)) then bkgdContRef = Self.bkgdContRef
;
if (arg_present(fastContRef)) then fastContRef = Self.fastContRef
;
if (arg_present(nActiveDetectors)) then nActiveDetectors = Self.nActiveDetectors
;
if (arg_present(energyUnitFlag)) then energyUnitFlag = Self.energyUnitFlag
;
if (arg_present(maskedDets)) then maskedDets = Self.maskedDets
;
if (arg_present(fastparams)) then fastparams = Self.fastparams
;
if (arg_present(fastfunc)) then fastfunc = Self.fastfunc
;
if (arg_present(funcs)) then funcs = Self.fastfuncs
;
if (arg_present(monScaleValue)) then monScaleValue = Self.monScaleValue
;
if (arg_present(monScaleFlag)) then monScaleFlag = Self.monScaleFlag
;
if (arg_present(sumSampFlag)) then sumSampFlag = Self.sumSampFlag
;
if (arg_present(sumBkgdFlag)) then sumBkgdFlag = Self.sumBkgdFlag
;
if (arg_present(maskFlag)) then maskFlag = Self.maskFlag
;
if (arg_present(bkgdFlag)) then bkgdFlag = Self.bkgdFlag
;
if (arg_present(fastFlag)) then fastFlag = Self.fastFlag
;
if (arg_present(dataDir)) then dataDir = Self.dataDir
;
if (arg_present(mev2wnos)) then mev2wnos = Self.mev2wnos
;
if (arg_present(oplotFastFitFlag)) then oplotFastFitFlag = Self.oplotFastFitFlag
;
if (arg_present(oplotBkgdFlag)) then oplotBkgdFlag = Self.oplotBkgdFlag
;
if (arg_present(ftpObject)) then ftpObject = Self.ftpObject
;
if (arg_present(latParamFlag)) then latParamFlag = Self.latParamFlag
;
if (arg_present(latticeParameters)) then latticeParameters = Self.latticeParameters
;
if (arg_present(detailedBalanceFlag)) then detailedBalanceFlag = Self.detailedBalanceFlag
;
if (arg_present(fastValue)) then fastValue = Self.fastValue
;
if (arg_present(resCorFlag)) then resCorFlag = Self.resCorFlag
;
if (arg_present(monCorFlag)) then monCorFlag = Self.monCorFlag
;
;if (arg_present(normalizeTo)) then normalizeTo = Self.normalizeTo
;
if (arg_present(sampTypeFlag)) then sampTypeFlag = Self.sampTypeFlag
;
if (arg_present(qUnits)) then qUnits = Self.qUnits
;
if (arg_present(xAxisVar)) then xAxisVar = Self.xAxisVar
;
if (arg_present(yAxisVar)) then yAxisVar = Self.yAxisVar
;
if (arg_present(indepVar1List)) then indepVar1List = (*Self.indepVars1Ptr)
;
if (arg_present(indepVar12List)) then indepVar2List = (*Self.indepVars2Ptr)
;
if (arg_present(indepVar2List)) then indepVar2List = (*Self.indepVars2Ptr)
;
if (arg_present(indepVar3List)) then indepVar3List = (*Self.indepVars3Ptr)
;
if (arg_present(exportIndex)) then exportIndex = (*Self.exportIndexPtr)
;
if (arg_present(calibParamsisSet)) then calibParamsisSet = Self.calibParamsisSet
;
if (ARG_PRESENT(multipleMsliceWinFlag)) then multipleMsliceWinFlag = Self.multipleMsliceWinFlag
;
if (arg_present(effNormFlag)) then effNormFlag = Self.effNormFlag
;
if (ARG_PRESENT(mergePixelsFlag)) then mergePixelsFlag = Self.mergePixelsFlag
;
if (ARG_PRESENT(minBinWidth)) then minBinWidth = Self.minBinWidth
;
if (ARG_PRESENT(binWidths)) then binWidths = Self.binWidths
;
if (ARG_PRESENT(defaultIntensityFlag)) then defaultIntensityFlag = Self.defaultIntensityFlag
;
if (ARG_PRESENT(maxIntensity)) then maxIntensity = Self.maxIntensity
;
if (ARG_PRESENT(minIntensity)) then minIntensity = Self.minIntensity
;
if (ARG_PRESENT(phiOffset)) then phiOffset = Self.phiOffset
;
if (ARG_PRESENT(logFlag)) then logFlag = Self.logFlag
;
if (ARG_PRESENT(minChan)) then minChan = Self.minChan
;
if (ARG_PRESENT(maxChan)) then maxChan = Self.maxChan
;
if (ARG_PRESENT(minDPnt)) then minDPnt = Self.minDPnt
;
if (ARG_PRESENT(maxDPnt)) then maxDPnt = Self.maxDPnt
;
if (ARG_PRESENT(sharedSettingsFlag)) then sharedSettingsFlag = Self.sharedSettingsFlag
;
if (ARG_PRESENT(settingIndex)) then settingIndex = Self.settingIndex
;
if (ARG_PRESENT(dpntIndex)) then dpntIndex = Self.dpntIndex
;
if (arg_present(oneOverKfFlag)) then oneOverKfFlag = Self.oneOverKfFlag
;
;if (arg_present(selectedIDs) || arg_present(nSelectedIDs) || arg_present(selectedNames)) then begin
;   oUI = Self->GetUI()
;   oUI->GetProperty, group_leader = wTLB
;   wChild = WIDGET_INFO(wTLB, /CHILD)
;   WIDGET_CONTROL, wChild, GET_UVALUE=sPtr
;   ; retrieve list of all _selected_ datasets from the data manager
;   wDM = (*sPtr).wDM ; the data manager widget ID
;   widget_control, wDM, get_uvalue=sPtrDM ; the data manager state ptr
;   
;   oSampCont = Self.calibContRef
;   if (oSampCont->Count() eq 0) then begin
;      ; no data currently loaded
;      (*(*sPtrDM).pdataids) = ''
;      selectedIDs = ''
;      selectedNames = ''
;      nSelectedIDs = 0
;   endif else begin
;      selectedIDs = (*(*sPtrDM).pdataids)  ; currently selected identifiers
;      nSelectedIDs = n_elements(selectedIDs)
;      if (selectedIDs[0] eq '') then nSelectedIDs = 0
;      selectedNames = (nSelectedIDs eq 0)? '' :  strarr(nSelectedIDs)
;      for i=0,nSelectedIDs-1 do begin
;         (Self->GetByIdentifier(selectedIDs[i]))->GetProperty, name=name
;         selectedNames[i] = name
;      endfor
;   endelse
;endif
;
;if (arg_present(curMaxDataLen)) then begin
;   oSampCont = Self.calibContRef
;   curMaxDataLen = 1
;   if (obj_valid(oSampCont) && (oSampCont->Count() gt 0)) then begin
;      nSamp = oSampCont->Count()
;      for i = 0, nSamp-1 do begin
;         oI = oSampCont->Get(position=i)
;         status = oI->GetMetaData('NPTS',npts)
;         if (status) then curMaxDataLen = curMaxDataLen > npts
;      endfor
;   endif 
;
;endif

; Call base class method
if (n_elements(etc) gt 0) then $
  self->IDLitTool::GetProperty, _EXTRA=etc

end


;-------------------------------------------------------------------------------
pro SPINSPSDCalibTool::SetProperty, nameTag=nameTag, prompt=prompt,preferences=preferences $
 ,anaModeFlag=anaModeFlag,a4Flag=a4Flag,calibFilename=calibFilename,a4calibFilename=a4calibFilename $
 ,plotFlag=plotFlag,dpdEfCorFlag=dpdEfCorFlag,thetagValue=thetagValue,calibFilePresent=calibFilePresent $
 ,a4calibFilePresent=a4calibFilePresent,requireProcessing=requireProcessing $
 ,nActiveDetectors=nActiveDetectors,energyUnitFlag=energyUnitFlag $
 ,maskedDets=maskedDets,fastFunc=fastFunc,monScaleValue=monScaleValue $
 ,monScaleFlag=monScaleFlag,maskFlag=maskFlag,bkgdFlag=bkgdFlag $
 ,sumSampFlag=sumSampFlag,sumBkgdFlag=sumBkgdFlag,effNormFlag=effNormFlag $
 ,fastFlag=fastFlag, data_directory=dataDir, daveTool=daveTool, oneOverKfFlag=oneOverKfFlag $
 ,minChan=minChan,maxChan=maxChan,minDPnt=minDPnt,maxDPnt=maxDPnt,dpntIndex=dpntIndex $
 ,pixelNumber=pixelNumber, instrumentName=instrumentName,maskThreshold=maskThreshold, maskedPixels=maskedPixels $
 ,nSamp=nSamp,nBkgd=nBkgd,nFast=nFast,fastparams=fastparams,phiOffset=phiOffset,logFlag=logFlag $
 ,defaultIntensityFlag=defaultIntensityFlag, maxIntensity=maxIntensity, minIntensity=minIntensity $
 ,sampSelected=sampSelected, bkgdSelected=bkgdSelected, fastSelected=fastSelected $
 ,A6Value=A6Value, A4Value=A4Value, A4Width=A4Width $
 ,modifiedStatus=modifiedStatus,exportIndex=exportIndex,minBinWidth=minBinWidth,binWidths=binWidths $
 ,latParamFlag=latParamFlag, latticeParameters=latticeParameters, qUnits=qUnits $
 ,detailedBalanceFlag=detailedBalanceFlag,fastValue=fastValue, resCorFlag=resCorFlag $
 ,monCorFlag=monCorFlag, normalizeTo=normalizeTo, sampTypeFlag=sampTypeFlag,mergePixelsFlag=mergePixelsFlag $
 ,s_errorbar_capsize=s_errorbar_capsize $
 ,s_transparency=s_transparency $
 ,s_antialias=s_antialias $
 ,s_color=s_color $
 ,s_errorbar_color=s_errorbar_color $
 ,s_use_default_color=s_use_default_color $
 ,s_sym_increment=s_sym_increment $
 ,s_sym_index=s_sym_index $
 ,s_sym_size=s_sym_size $
 ,s_sym_color=s_sym_color $
 ,s_sym_thick=s_sym_thick $
 ,s_y_errorbars=s_y_errorbars $
 ,s_linestyle=s_linestyle $
 ,s_thick=s_thick $
 ,s_sym_filled=s_sym_filled $
 ,s_sym_fill_color=s_sym_fill_color $
 ,s_font_name=s_font_name  $
 ,s_font_size=s_font_size $
 ,s_text_color=s_text_color  $
 ,b_errorbar_capsize=b_errorbar_capsize $
 ,b_transparency=b_transparency $
 ,b_antialias=b_antialias $
 ,b_color=b_color $
 ,b_errorbar_color=b_errorbar_color $
 ,b_use_default_color=b_use_default_color $
 ,b_sym_increment=b_sym_increment $
 ,b_sym_index=b_sym_index $
 ,b_sym_size=b_sym_size $
 ,b_sym_color=b_sym_color $
 ,b_sym_thick=b_sym_thick $
 ,b_y_errorbars=b_y_errorbars $
 ,b_linestyle=b_linestyle $
 ,b_thick=b_thick $
 ,b_sym_filled=b_sym_filled $
 ,b_sym_fill_color=b_sym_fill_color $
 ,b_font_name=b_font_name  $
 ,b_font_size=b_font_size $
 ,b_text_color=b_text_color  $
 ,f_errorbar_capsize=f_errorbar_capsize $
 ,f_transparency=f_transparency $
 ,f_antialias=f_antialias $
 ,f_color=f_color $
 ,f_errorbar_color=f_errorbar_color $
 ,f_use_default_color=f_use_default_color $
 ,f_sym_increment=f_sym_increment $
 ,f_sym_index=f_sym_index $
 ,f_sym_size=f_sym_size $
 ,f_sym_color=f_sym_color $
 ,f_sym_thick=f_sym_thick $
 ,f_y_errorbars=f_y_errorbars $
 ,f_linestyle=f_linestyle $
 ,f_thick=f_thick $
 ,f_sym_filled=f_sym_filled $
 ,f_sym_fill_color=f_sym_fill_color $
 ,f_font_name=f_font_name  $
 ,f_font_size=f_font_size $
 ,f_text_color=f_text_color $
 ,fill_background=fill_background $
 ,fill_level=fill_level $
 ,fill_color=fill_color $
 ,fill_transparency=fill_transparency $
 ,_EXTRA=etc
; ,ff_transparency=ff_transparency $
; ,ff_antialias=ff_antialias $
; ,ff_color=ff_color $
; ,ff_use_default_color=ff_use_default_color $
; ,ff_sym_index=ff_sym_index $
; ,ff_linestyle=ff_linestyle $
; ,ff_thick=ff_thick $
; ,sb_transparency=sb_transparency $
; ,sb_antialias=sb_antialias $
; ,sb_color=sb_color $
; ,sb_use_default_color=sb_use_default_color $
; ,sb_sym_index=sb_sym_index $
; ,sb_linestyle=sb_linestyle $
; ,sb_thick=sb_thick

compile_opt idl2

if n_elements(s_errorbar_capsize) then Self.s_errorbar_capsize=s_errorbar_capsize
if n_elements(s_transparency) then Self.s_transparency=s_transparency
if n_elements(s_antialias) then Self.s_antialias=s_antialias
if n_elements(s_color) then Self.s_color=s_color
if n_elements(s_errorbar_color) then Self.s_errorbar_color=s_errorbar_color
if n_elements(s_use_default_color) then Self.s_use_default_color=s_use_default_color 
if n_elements(s_sym_increment) then Self.s_sym_increment=s_sym_increment 
if n_elements(s_sym_index) then Self.s_sym_index=s_sym_index 
if n_elements(s_sym_size) then Self.s_sym_size=s_sym_size 
if n_elements(s_sym_color) then Self.s_sym_color=s_sym_color 
if n_elements(s_sym_thick) then Self.s_sym_thick=s_sym_thick 
if n_elements(s_y_errorbars) then Self.s_y_errorbars=s_y_errorbars
if n_elements(s_linestyle) then Self.s_linestyle=s_linestyle
if n_elements(s_thick) then Self.s_thick=s_thick
if n_elements(s_sym_filled) then Self.s_sym_filled=s_sym_filled
if n_elements(s_sym_fill_color) then Self.s_sym_fill_color=s_sym_fill_color
if n_elements(s_font_name) then Self.s_font_name=s_font_name
if n_elements(s_font_size) then Self.s_font_size=s_font_size
if n_elements(s_text_color) then Self.s_text_color=s_text_color
if n_elements(b_errorbar_capsize) then Self.b_errorbar_capsize=b_errorbar_capsize
if n_elements(b_transparency) then Self.b_transparency=b_transparency
if n_elements(b_antialias) then Self.b_antialias=b_antialias
if n_elements(b_color) then Self.b_color=b_color
if n_elements(b_use_default_color) then Self.b_use_default_color=b_use_default_color
if n_elements(b_errorbar_color) then Self.b_errorbar_color=b_errorbar_color
if n_elements(b_sym_increment) then Self.b_sym_increment=b_sym_increment
if n_elements(b_sym_index) then Self.b_sym_index=b_sym_index
if n_elements(b_sym_size) then Self.b_sym_size=b_sym_size
if n_elements(b_sym_color) then Self.b_sym_color=b_sym_color
if n_elements(b_sym_thick) then Self.b_sym_thick=b_sym_thick
if n_elements(b_y_errorbars) then Self.b_y_errorbars=b_y_errorbars
if n_elements(b_linestyle) then Self.b_linestyle=b_linestyle
if n_elements(b_thick) then Self.b_thick=b_thick
if n_elements(b_sym_filled) then Self.b_sym_filled=b_sym_filled
if n_elements(b_sym_fill_color) then Self.b_sym_fill_color=b_sym_fill_color
if n_elements(b_font_name) then Self.b_font_name=b_font_name
if n_elements(b_font_size) then Self.b_font_size=b_font_size
if n_elements(b_text_color) then Self.b_text_color=b_text_color
if n_elements(f_errorbar_capsize) then Self.f_errorbar_capsize=f_errorbar_capsize
if n_elements(f_transparency) then Self.f_transparency=f_transparency
if n_elements(f_antialias) then Self.f_antialias=f_antialias
if n_elements(f_color) then Self.f_color=f_color
if n_elements(f_errorbar_color) then Self.f_errorbar_color=f_errorbar_color
if n_elements(f_use_default_color) then Self.f_use_default_color=f_use_default_color
if n_elements(f_sym_increment) then Self.f_sym_increment=f_sym_increment
if n_elements(f_sym_index) then Self.f_sym_index=f_sym_index
if n_elements(f_sym_size) then Self.f_sym_size=f_sym_size
if n_elements(f_sym_color) then Self.f_sym_color=f_sym_color
if n_elements(f_sym_thick) then Self.f_sym_thick=f_sym_thick
if n_elements(f_y_errorbars) then Self.f_y_errorbars=f_y_errorbars
if n_elements(f_linestyle) then Self.f_linestyle=f_linestyle
if n_elements(f_thick) then Self.f_thick=f_thick
if n_elements(f_sym_filled) then Self.f_sym_filled=f_sym_filled
if n_elements(f_sym_fill_color) then Self.f_sym_fill_color=f_sym_fill_color
if n_elements(f_font_name) then Self.f_font_name=f_font_name
if n_elements(f_font_size) then Self.f_font_size=f_font_size
if n_elements(f_text_color) then Self.f_text_color=f_text_color
if n_elements(fill_background) then Self.fill_background=fill_background
if n_elements(fill_level) then Self.fill_level=fill_level
if n_elements(fill_color) then Self.fill_color=fill_color
if n_elements(fill_transparency) then Self.fill_transparency=fill_transparency
;if n_elements(ff_transparency) then Self.ff_transparency=ff_transparency
;if n_elements(ff_antialias) then Self.ff_antialias=ff_antialias
;if n_elements(ff_color) then Self.ff_color=ff_color
;if n_elements(ff_use_default_color) then Self.ff_use_default_color=ff_use_default_color
;if n_elements(ff_sym_index) then Self.ff_sym_index=ff_sym_index
;if n_elements(ff_linestyle) then Self.ff_linestyle=ff_linestyle
;if n_elements(ff_thick) then Self.ff_thick=ff_thick
;if n_elements(sb_transparency) then Self.sb_transparency=sb_transparency
;if n_elements(sb_antialias) then Self.sb_antialias=sb_antialias
;if n_elements(sb_color) then Self.sb_color=sb_color
;if n_elements(sb_use_default_color) then Self.sb_use_default_color=sb_use_default_color
;if n_elements(sb_sym_index) then Self.sb_sym_index=sb_sym_index
;if n_elements(sb_linestyle) then Self.sb_linestyle=sb_linestyle
;if n_elements(sb_thick) then Self.sb_thick=sb_thick

; DAVETool
if (n_elements(daveTool) && obj_valid(daveTool) && obj_isa(daveTool,'DAVETool')) then $
  Self.daveTool = daveTool

; Preferences
if (n_elements(preferences)) then begin
   if (strcmp(size(preferences,/tname),'STRUCT')) then begin
      ntags = n_tags(preferences)
      tags = tag_names(preferences)
      index = indgen(ntags)
      
      ; handle color tags - convert string to byte array, eg '0,128,255' to [0,128,255]
      spIndex = where(strmatch(tags,'*color*',/fold) eq 1, spCnt, complement=index, ncomplement=theRest)
      if (spCnt gt 0) then begin
         for i=0,spCnt-1 do begin
            strColor = preferences.(spIndex[i])
            bytColor = fix(strsplit(strColor,',',/extract))
            Self->SetPropertyByIdentifier, tags[spIndex[i]], bytColor
         endfor
      endif

      ; all other tags
      for i=0,theRest-1 do begin
        Self->SetPropertyByIdentifier, tags[index[i]], preferences.(index[i])
      endfor
      
      ; Finally, store the preferences structure
      if (ptr_valid(Self.prefsPtr)) then (*Self.prefsPtr) = preferences $
      else Self.prefsPtr = ptr_new(preferences)
   endif
endif
;
if (n_elements(instrumentName)) then begin
  Self.instrumentName = instrumentName
  case instrumentName of
    '0': begin      ; BT7
      Self.ftpObject->SetProperty, currentDir = '/pub/ncnrdata/bt7/'
      Self->SetPropertyAttribute, 'maskedPixels', name='Channels to mask'
    end

    '1': begin      ; SPINS
      Self.ftpObject->SetProperty, currentDir = '/pub/ncnrdata/ng5/'
      Self->SetPropertyAttribute, 'maskedPixels', name='Pixels to mask'
    end

    else:
  endcase
endif
;
if (n_elements(maskThreshold)) then Self.maskThreshold = maskThreshold
;
if (n_elements(maskedPixels)) then Self.maskedPixels = maskedPixels
;
if (n_elements(A6Value)) then Self.A6Value = A6Value
;
if (n_elements(A4Value)) then Self.A4Value = A4Value
;
if (N_elements(A4Width)) then Self.A4Width = A4Width
;
if (n_elements(anaModeFlag)) then Self.anaModeFlag = anaModeFlag
;
if (n_elements(a4Flag)) then Self.a4Flag = a4Flag
;
if (n_elements(calibFilename)) then Self.calibFilename = calibFilename
;
if (n_elements(a4calibFilename)) then Self.a4calibFilename = a4calibFilename
;
if (n_elements(plotFlag)) then Self.plotFlag = plotFlag
;
if (n_elements(pixelNumber)) then Self.pixelNumber = pixelNumber
;
if (n_elements(dpdEfCorFlag)) then Self.dpdEfCorFlag = dpdEfCorFlag
;
if (n_elements(thetagValue)) then Self.thetagValue = thetagValue
;
if (n_elements(calibFilePresent)) then Self.calibFilePresent = calibFilePresent
;
if (n_elements(a4calibFilePresent)) then Self.a4calibFilePresent = a4calibFilePresent
;
if (n_elements(requireProcessing)) then Self.requireProcessing = (fix(requireProcessing) gt 0)? 1 : 0
; modifiedStatus
if (n_elements(modifiedStatus)) then Self.modifiedFlag = (fix(modifiedStatus) gt 0)? 1 : 0
; nameTag
if (n_elements(nameTag)) then Self.nameTag = strtrim(nameTag,2)
; prompt
if (n_elements(prompt)) then begin
   Self.prompt = prompt
   if (prompt eq 0) then Self._bDirty = 0
endif
;
if (n_elements(nActiveDetectors)) then Self.nActiveDetectors = nActiveDetectors
;
if (n_elements(energyUnitFlag)) then Self.energyUnitFlag = energyUnitFlag
;
if (n_elements(oneOverKfFlag)) then Self.oneOverKfFlag = oneOverKfFlag
;
if (n_elements(maskedDets)) then Self.maskedDets = maskedDets
;
if (n_elements(fastfunc)) then Self.fastfunc = fastfunc
;
if (n_elements(fastparams)) then Self.fastparams = fastparams
;
if (n_elements(monScaleValue)) then Self.monScaleValue = (monScaleValue eq 0.0)? 1.0 : monScaleValue
;
if (n_elements(monScaleFlag)) then Self.monScaleFlag = monScaleFlag
;
if (n_elements(sumSampFlag)) then Self.sumSampFlag = sumSampFlag
;
if (n_elements(sumBkgdFlag)) then Self.sumBkgdFlag = sumBkgdFlag
;
if (n_elements(maskFlag)) then Self.maskFlag = maskFlag
;
if (n_elements(bkgdFlag)) then Self.bkgdFlag = bkgdFlag
;
if (n_elements(fastFlag)) then Self.fastFlag = fastFlag
;
if (n_elements(dataDir)) then Self.dataDir = dataDir
;
if (n_elements(nSamp)) then Self.nSamp = nSamp
;
if (n_elements(nBkgd)) then Self.nBkgd = nBkgd
;
if (n_elements(nFast)) then Self.nFast = nFast
;
if (n_elements(sampSelected)) then Self.sampSelected = sampSelected
;
if (n_elements(bkgdSelected)) then Self.bkgdSelected = bkgdSelected
;
if (n_elements(fastSelected)) then Self.fastSelected = fastSelected
;
if (n_elements(oplotFastFitFlag)) then Self.oplotFastFitFlag = oplotFastFitFlag
;
if (n_elements(oplotBkgdFlag)) then Self.oplotBkgdFlag = oplotBkgdFlag
;
if (n_elements(latParamFlag)) then  Self.latParamFlag = latParamFlag
;
if (n_elements(latticeParameters)) then  Self.latticeParameters = latticeParameters
;
if (n_elements(detailedBalanceFlag)) then Self.detailedBalanceFlag = detailedBalanceFlag
;
if (n_elements(fastValue)) then Self.fastValue = fastValue
;
if (n_elements(resCorFlag)) then Self.resCorFlag = resCorFlag
;
if (n_elements(monCorFlag)) then Self.monCorFlag = monCorFlag
;
;if (n_elements(normalizeTo)) then Self.normalizeTo = normalizeTo
;
if (n_elements(minbinWidth)) then Self.minbinWidth = minbinWidth
;
if (n_elements(binWidths)) then Self.binWidths = binWidths
;
if (n_elements(minChan)) then Self.minChan = minChan > 1
;
if (n_elements(maxChan)) then Self.maxChan = maxChan
;
if (n_elements(minDPnt)) then Self.minDPnt = minDPnt > 1
;
if (n_elements(maxDPnt)) then Self.maxDPnt = maxDPnt
;
if (n_elements(dpntIndex)) then Self.dpntIndex = dpntIndex > 1
;
if (n_elements(sharedSettingsFlag)) then Self.sharedSettingsFlag = sharedSettingsFlag
;
if (n_elements(settingIndex)) then Self.settingIndex = settingIndex
;
if (n_elements(sampTypeFlag)) then begin
   Self.sampTypeFlag = sampTypeFlag
   if (n_elements(typeCheck) eq 0) then typeCheck = 1 ; ==> default typeCheck is set to 1
   Self->UpdatePropertySheet, typeCheck = typeCheck
endif
;
if (n_elements(qUnits)) then Self.qUnits = qUnits
;
if (n_elements(xAxisVar)) then Self.xAxisVar = xAxisVar
;
if (n_elements(yAxisVar)) then Self.yAxisVar = yAxisVar
;
if (n_elements(exportIndex) gt 0) then (*Self.exportIndexPtr) = exportIndex 
;
if (n_elements(effNormFlag) gt 0) then Self.effNormFlag = effNormFlag 
;
if (N_ELEMENTS(multipleMsliceWinFlag) gt 0) then Self.multipleMsliceWinFlag = multipleMsliceWinFlag
;
if (N_ELEMENTS(mergePixelsFlag) gt 0) then Self.mergePixelsFlag = mergePixelsFlag
;
if (N_ELEMENTS(defaultIntensityFlag) gt 0) then Self.defaultIntensityFlag = defaultIntensityFlag
;
if (N_ELEMENTS(maxIntensity) gt 0) then begin
   if (maxIntensity gt Self.minIntensity) then Self.maxIntensity = maxIntensity
endif
;
if (N_ELEMENTS(minIntensity) gt 0) then begin
   if (minIntensity lt Self.maxIntensity) then Self.minIntensity = minIntensity
endif
;
if (N_ELEMENTS(phiOffset) gt 0) then Self.phiOffset = phiOffset
;
if (N_ELEMENTS(logFlag) gt 0) then Self.logFlag = logFlag

; Call base class method
if (n_elements(etc) gt 0) then $
  self->IDLitTool::SetProperty, _EXTRA=etc

end


;===============================================================================
; SPINSPSDCalibTool::deleteAllDatasets
;
; PURPOSE:
;   Delete all datasets currently loaded
;
; PARAMETERS:
;
; RETURN VALUE:
;
function SPINSPSDCalibTool::deleteAllDatasets, _EXTRA=etc
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

wDM = (*sPtr).wDM
widget_control, wDM, get_uvalue=sPtrDM

cw_SPINSPSDDataManager_DeleteData, sPtrDM, wDM, /delall, _EXTRA=etc

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSPSDCalibTool::subtractBkgd
;
; PURPOSE:
;   Subtract bkgd data
;
; PARAMETERS:
;
; RETURN VALUE:
;
pro SPINSPSDCalibTool::subtractBkgd
compile_opt idl2


end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSPSDCalibTool::loadEnergyCalib
;
; PURPOSE:
;   Specify and load sample data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSPSDCalibTool::GetFileList, title, count, fromFTP=fromFTP, filter=filter $
                                ,multiple_files=multiple_files, path=path, newPath=newPath

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

if (keyword_set(fromFTP)) then begin
  Self->GetProperty, ftpObject=oFTP, instrumentName=instrumentFlag  ; instrumentFlag: 0 => BT7, 1=>
  if (n_elements(filter) eq 0) then filter = (instrument eq 0)? ['*.bt7','*.*'] : ['*.ng5','*.*']
  files = Dialog_NCNRpublicData(oFTP,title=title,filter=filter,group_leader=wTLB,count=count)
endif else begin
  Self->GetProperty, instrumentName=instrumentFlag
  if (n_elements(filter) eq 0) then filter = (instrumentFlag eq 0)? '*.bt7' : '*.ng5'
  if (n_elements(multiple_files) eq 0) then multiple_files=1
  if (n_elements(path) eq 0) then Self->GetProperty, data_directory=path
  if (n_elements(title) eq 0) then title='Specify files to load'
  
  files = dialog_pickfile(title=title,multiple_files=multiple_files,/must_exist, dialog_parent=wTLB $
                         ,filter=filter,path=path, get_path=newPath)
  
  if (files[0] eq '') then begin
     count = 0
     return, ''
  endif
  
  count = n_elements(files)
  ;Self->SetProperty, data_directory=newPath
endelse

return, files

end
;-------------------------------------------------------------------------------



;===============================================================================
; SPINSPSDCalibTool::refreshPropertySheet
;
; PURPOSE:
;   Refresh the propertysheet UI
;
; PARAMETERS:
;
; KEYWORDS:
;
pro SPINSPSDCalibTool::RefreshPropertySheet

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

widget_control, (*sPtr).wPS, /refresh_property

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSPSDCalibTool::loadFastFtp
;
; PURPOSE:
;   Specify and load fast bkgd data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSPSDCalibTool::loadFastFtp

return, Self->LoadFast(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSPSDCalibTool::loadA4CalibFtp
;
; PURPOSE:
;   Specify and load bkgd data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSPSDCalibTool::loadA4CalibFtp

return, Self->loadA4Calib(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; SPINSPSDCalibTool::loadA4Calib
;
; PURPOSE:
;   Select and load Bkgd data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
; 
;   dataObject - specifies the data object whose data is to be reloaded
;   
;   reload  - set if the data specified by the dataObject keyword is to be reloaded
;   
;   fromFTP - set if the source of the datafile to be loaded is the FTP server
;-
function SPINSPSDCalibTool::loadA4Calib, reload=reload, dataObject=oItem, fromFTP=fromFTP

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::loadA4Calib: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        Self->EnableUpdates
        return, 0
    endif
endif

reloading = keyword_set(reload)
if (reloading) then begin
   if (~obj_valid(oItem)) then return, 0
   oItem->GetProperty, description=files
   count = 1
   void = oItem->GetMetaData('FROMFTP',fromFtp)
   ;if (~Self->ReadData(filename, dataPtr)) then return, 0
endif else begin
   ; Let user specify files to load
   title = 'Select A4 Calibration File to Load'
   
   filename = Self->GetFileList(title,count,fromFTP=fromFTP,newPath=newPath,multiple_files=0)
   if (count eq 0) then return, 0
   if (n_elements(newPath) gt 0) then Self->SetProperty, data_directory=newPath
endelse

; switch on the busy symbol for cursor
widget_control, /HOURGLASS

Self->DisableUpdates
; Read the contents of the data files and save them in a hash data structure

if (~Self->readData(filename, fromFTP=fromFTP,type='A4')) then begin
  Self->EnableUpdates
  return, 0
endif
Self.a4CalibFilename = file_basename(filename,/fold_case)
Self.a4calibFilePresent = 1
Self.requireProcessing = 1
Self.modifiedFlag = 1

wChild = WIDGET_INFO(wTLB, /CHILD)
WIDGET_CONTROL, wChild, GET_UVALUE=sPtr
widget_control, (*sPtr).wProcess, sensitive=Self.requireProcessing gt 0
widget_control, (*sPtr).wPlot, sensitive=Self.requireProcessing gt 0
widget_control, (*sPtr).wSaveCalib, sensitive=0


Self->SetProperty, plotFlag = 1 ; set to display image of energy calibration data
Self->Plot                      ; display the dataset

Self->UpdatePropertySheet
Self->RefreshPropertySheet
Self->EnableUpdates

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSPSDCalibTool::ViewCalibParams
;
; PURPOSE:
;   Specify calibration file and load PSD detector calibration parameters
;   (Pixel efficiencies and delta A4, Ef) values from it
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSPSDCalibTool::ViewCalibParams

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

status = file_test(Self.calibParamsFilename,/read)
if (~status) then begin
  msg = ['Calibration information not found','Please, load a proper SPINS calibration parameter file']
  Self->ErrorMessage, msg,title='Calibration not found',severity=0
  Self->StatusMessage, 'Please, load a proper SPINS calibration parameter file'
  return, 0
endif

font = (!version.os_family eq 'Windows')? 'Courier New*24*Bold' : $
  '-adobe-courier-bold-o-normal--24-240-75-75-m-150-iso8859-1'
font1 = (!version.os_family eq 'Windows')? 'Courier New*18*Bold' : $
  '-adobe-courier-bold-o-normal--18-180-75-75-m-110-iso8859-1'
font2 = (!version.os_family eq 'Windows')? 'Courier New*16' : $
  '-adobe-courier-medium-o-normal--14-140-75-75-m-90-iso8859-1'

doneTxt = "Close "+Self.calibParamsBaseFilename

xdisplayfile, Self.calibParamsFilename, done_button=doneTxt, /grow_to_screen, group=wTLB, font=font2

return, 1

end
;-------------------------------------------------------------------------------



;===============================================================================
; SPINSPSDCalibTool::loadEnergyCalibFtp
;
; PURPOSE:
;   Specify and load sample data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSPSDCalibTool::loadEnergyCalibFtp

return, Self->loadEnergyCalib(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; SPINSPSDCalibTool::loadEnergyCalib
;
; PURPOSE:
;   Specify and load sample data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
; 
;   dataObject - specifies the data object whose data is to be reloaded
;   
;   reload  - set if the data specified by the dataObject keyword is to be reloaded
;   
;   fromFTP - set if the source of the datafile to be loaded is the FTP server
;-
function SPINSPSDCalibTool::loadEnergyCalib, reload=reload, dataObject=oItem, fromFTP=fromFTP

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::loadEnergyCalib: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        Self->EnableUpdates
        return, 0
    endif
endif

reloading = keyword_set(reload)
if (reloading) then begin
   if (~obj_valid(oItem)) then return, 0
   oItem->GetProperty, description=files
   count = 1
   void = oItem->GetMetaData('FROMFTP',fromFtp)
   ;if (~Self->ReadData(filename, dataPtr)) then return, 0
endif else begin
   ; Let user specify files to load
   title = 'Select Energy Calibration File to Load'
   
   filename = Self->GetFileList(title,count,fromFTP=fromFTP,newPath=newPath,multiple_files=0)
   if (count eq 0) then return, 0
   if (n_elements(newPath) gt 0) then Self->SetProperty, data_directory=newPath
endelse

; switch on the busy symbol for cursor
widget_control, /HOURGLASS

Self->DisableUpdates
; Read the contents of the data files  and save them in a hash data structure

if (~Self->readData(filename, fromFTP=fromFTP,type='Energy')) then begin
  Self->EnableUpdates
  return, 0
endif
Self.calibFilename = file_basename(filename,/fold_case)
Self.calibFilePresent = 1
Self.requireProcessing = 1
Self.modifiedFlag = 1

wChild = WIDGET_INFO(wTLB, /CHILD)
WIDGET_CONTROL, wChild, GET_UVALUE=sPtr
widget_control, (*sPtr).wProcess, sensitive=Self.requireProcessing gt 0
widget_control, (*sPtr).wPlot, sensitive=Self.requireProcessing gt 0
widget_control, (*sPtr).wSaveCalib, sensitive=0

Self->SetProperty, plotFlag = 0 ; set to display image of energy calibration data
Self->Plot                      ; display the dataset

Self->UpdatePropertySheet
Self->RefreshPropertySheet

Self->EnableUpdates

return, 1


;oItems = []
;A2s = []
;for i=0, count-1 do begin
;
;   filename = files[i]
;   if (~Self->readData(filename, dataPtr, fromFTP=fromFTP)) then begin
;      if (ptr_valid(dataPtr)) then heap_free, dataPtr
;      continue
;   endif
;
;   basename = file_basename(filename,'.ng5',/fold_case)
;
;   if (~reloading) then begin
;      ;; create new object and attach dataPtr
;      oItem = obj_new('IDLitParameterSet',name=basename,description=filename,type='samp')   
;      oItem->AddMetaData,'DATAPTRREF',dataPtr
;      oItem->AddMetaData,'FROMFTP',keyword_set(fromFTP)
;      
;      ; iTools does not handle '_[0-9]' characters in identifiers well eg _0, _1, etc
;      ; replace all '_' with '-'
;      oItem->GetProperty, identifier=idd
;      hasChanged = 0
;      while ((pos = stregex(idd,'_[0-9]')) ne -1) do begin
;         strput, idd,'-',pos
;         hasChanged = 1
;      endwhile
;      if (strmatch(idd,'[0-9]*')) then begin   ; if first char is a number
;         idd = 'id'+idd
;         hasChanged = 1
;      endif
;      if (hasChanged) then oItem->SetProperty,identifier=idd 
;      
;      if (sampTypeFlag eq 0) then begin
;        ; I-Scan specific
;        A2 = (*(*dataPtr).a2)[0]
;        oItem->AddMetaData,'A2VALUE',A2
;        oItems = [oItems,oItem]
;        A2s = [A2s,A2]
;      endif else begin
;        ; Add to the data manager
;        Self->AddByIdentifier, 'Sample Data Manager', oItem, position=0
;      endelse
;   endif else begin
;      ;; simply replace previous dataPtr with updated one
;      void = oItem->GetMetaData('DATAPTRREF',tempPtr)
;      if (ptr_valid(tempPtr)) then heap_free, tempPtr
;      oItem->AddMetaData,'DATAPTRREF',dataPtr
;   endelse
;   
;   ; Update calculations (q,e,intensity) for data
;   Self->UpdateCalculation, oItem
;   
;   if (~reloading) then begin
;      oCont->Add, oItem
;      Self.nSamp++
;   endif
;
;   dataPtr = 0   ; make dataPtr invalid before it is used again when looping
;endfor
;
;if (n_elements(oItems) gt 0) then begin
;  ; Sort by A2 value and add to the data manager
;  n = n_elements(oItems)
;  index = sort(A2s)
;  for i=0,n-1 do begin
;      Self->AddByIdentifier, 'Sample Data Manager', oItems[index[i]]   
;  endfor
;endif
;; TODO
;;if ((Self.nSamp gt 1) && sumFlag) then Self->MergeData, 'samp'
;;
;;Self->SetPropertyAttribute, 'SUMSAMPFLAG', sensitive=(Self.nSamp gt 0)
;;Self->refreshPropertySheet   ; force prop sheet to update
;
;Self.modifiedFlag = 1
;Self->EnableUpdates
;
;nSamp = oCont->Count()
;wChild = WIDGET_INFO(wTLB, /CHILD)
;WIDGET_CONTROL, wChild, GET_UVALUE=sPtr
;widget_control, (*sPtr).wMslice, sensitive=((nSamp gt 0) && ((Self.sampTypeFlag eq 1) || (Self.sampTypeFlag eq 1)))
;;widget_control, (*sPtr).wDaveDM, sensitive=(nSamp gt 0)
;;widget_control, (*sPtr).wPAN, sensitive=(nSamp gt 0)
;
;Self->UpdatePropertySheet
;Self->RefreshPropertySheet
;
;return, 1

end
;-------------------------------------------------------------------------------



;===============================================================================
; SPINSPSDCalibTool::UpdateCalculation
;
; PURPOSE:
;   Fit Gaussians to data. The fitted peak position at each data point is the pixel
;   which corresponds to the final energy for that data point.
;   Fit Gaussians to data. The fitted peak position at each pixel is the Energy transfer
;   which corresponds with that pixel
;
; PARAMETERS:
;
;
; KEYWORDS:
;
pro SPINSPSDCalibTool::UpdateCalculation
compile_opt idl2

oDiffEvo = SPINSCalib_EPSDE()

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

if (Self.calibFilePresent && Self.anaModeFlag ne 3) then begin
;if (Self.calibFilePresent eq 0) then begin
  dataHash = Self.calibData
  data = dataHash['Data']
  E = dataHash['Etran']
  Ef = dataHash['Ef']
  nDat = dataHash['nDat']
  nPix = dataHash['nPix']
  meanInt = dataHash['meanInt']
  sigmaInt = dataHash['sigmaInt']
  
  midIndex = fix((nPix-1)/2)
  
  x = E
  Emin = min(E, max=Emax)
;  index = where(fwhm le 0.0, fwhmIsZero)
;  Esigma = fwhm       ; Assume initial widths of approx 0.1
;  EsigmaMin = Esigma * 0.1        ; 10% of Esigma
;  EsigmaMax = Esigma * 2          ; 200% of Sigma
  
  p = [1.0,0.0,1.0,0.0,0.0]  
  ePix = []
  ePixErr = []
  pixArea = []
  pixel = []
  fitData = data*0.0
  sqrt2pi = sqrt(2*!pi)

  ; Create a progress bar
  
  for i = 0, nPix-1 do begin
    pixel = [pixel,i+1]                     ; pixel nos
    msg = "Energy Calibration Fit: Fitting pixel "+string(pixel[i],format='(I3.3)')+" of "+string(nPix,format='(I3.3)')
    Self->StatusMessage, msg
    y = reform(data[*,i])
    yerror = sqrt(y)
    ind = where(yerror le 0.0, cnt)
    if (cnt gt 0) then yerror[ind] = 1.0

    ; Initial parameter estimates
;    peak_loc = get_peak_pos(x,y,1,fwhm=fwhm,indices=indices)
;    if (indices gt 0 and fwhm gt 0.0) then begin
;      peakInt = y[indices]
;      peakFWHM = fwhm
;    endif else begin
      peakInt = max(y)
      peakFWHM = 0.2*(Emax - Emin)
;    endelse
    Amin = peakInt * 0.5
    Amax = peakInt * 1.5
    BCmax = peakInt * 0.3
    BCmin = 0.0
    EsigmaMin = peakFWHM * 0.1        ; 10% of fwhm
    EsigmaMax = peakFWHM * 1.5          ; 200% of fwhm
    pMin = [Amin,Emin,EsigmaMin,BCmin]
    pMax = [Amax,Emax,EsigmaMax,BCmax]

    oDiffEvo->SetProperty, xData=x, yData=y, yError=yError, pMin=pMin, pMax=pMax, startingFlag=0
    status = oDiffEvo->Fit()

    oDiffEvo->GetProperty, initParam=p0, bestParam=p1, bestfValue=chisq, generationCnt=genCnt
    status = oDiffEvo->Model(p1,calc=yFit)
    fitData[*,i] = yFit
    ePix = [ePix,p1[1]]               ; Fitted energy transfer at each pixel == peak pos
    ePixErr = [ePixErr,p1[1]*0.05]    ; estimate fitted error as 5% of fitted value
    ;pixArea = [pixArea,p1[0]*p1[2]*sqrt2pi] ; area = Imax*sigma*sqrt(2*pi)
    pixArea =  [pixArea,p1[0]] ; just use peak Intensity: decision by Igor and Leland Harriger
  endfor
  msg = "Energy Calibration Fit successfully completed!"
  Self->StatusMessage, msg

  ; Now know the energy transfer (peak position) at each pixel that was fitted.
  ; Now need to extrapolate the results using a linear interpolation/fit to obtain
  ; a smooth energy transfer for any pixel.
  ; pixel = pixels that were fitted
  ; ePix = fitted energy transfer for each fitted pixel
  ; ePixErr = estimated error in the energy transfer
  ; ePix  = effective energy transfer at each pixel
  ; efPix = effective final energy for each pixel

  ; Obtain a polynomial fir to the fitted pixel energy transfers
  eparam = poly_fit(pixel,ePix,1,measure_errors=ePixErr,status=status)  ; fit fiited energy transfers to polynomial of degree 1
  if (status eq 0) then begin
    ePixFit = eParam[0] + eParam[1]*pixel
  endif else begin
    ePixFit = interpol(ePix,pixel,pixel,/lsquadratic)
  endelse
  
  ; Final energy at each pixel = Energy transfer at pixel + fixed analyzer energy(Ef)
  EfPix = ePix + Ef[0]

;  EfPixFit = ePixFit + Ef    ; same as EfPix but using the polynomial fit to the pixel energy transfers
;  dataHash['EfPixFit'] = EfPixFit
;  
;  dEfdPix = abs(deriv(pixel,EfPix))   ;abs(deriv(pixels,EfPixFit))  ; dEf/dp - gradient of Ef wrt pixels
;                                         ; NB - the fitted polynomial form of Efp is used here to avoid numerical singularities
;  normFactor = nPix/total(pixArea/dEfdPix)
;  sens = (pixArea/dEfdPix) * normFactor
;  sensError = sqrt(pixArea)/dEfdPix * normFactor  
  
  
  sens = pixArea * sqrt(EfPix[midIndex]/EfPix) ; 1/kf correction due to the fact that... suggested by Igor

  sensError = sqrt(sens)/mean(sens)
  sens = sens/mean(sens)

  dataHash['EfPix'] = EfPix
  dataHash['pixel'] = pixel
  dataHash['sen'] = sens
  dataHash['senError'] = sensError
  dataHash['fitData'] = fitData
  
  ;dataHash['anaModeFlag'] = Self.anaModeFlag  ; Note the mode that was used during processing of the data
  
  ; Determine Delta a4 at each pixel for the different analyser modes

  ; 1) Flat Analyzer
  ; calculate 2theta for individual pixels relative to the central pixel from the final energies
  ; the central pixel is assummed to be pixel 127 out of 256
  rtod = 1.0/!dtor
  dSpaceA = dataHash['dSpaceA']
  ekFac = Self.ekFac
  dtthetap = (Self.instrumentName eq 0)? $
    rtod*(Asin(!pi/(dSpaceA*Sqrt(EfPix/ekFac)))) - 0.5 * Self.A6Value :       $                      ; <-- BT7: delta is relative to central detector A4
    rtod*(Asin(!pi/(dSpaceA*Sqrt(EfPix/ekFac)))  - Asin(!pi/(dSpaceA*Sqrt(EfPix[midIndex]/ekFac))))  ; <-- SPINS: delta is rel to central pixel
  dataHash['DeltaA4_flat'] = dtthetap

  ; 2) See Through Analyzer: 
  ; set to Zero
  dataHash['DeltaA4_seeTro'] = fltarr(nPix)

  ; 3) Fixed Ef: Requires A4p so see below
  
  if (Self.anaModeFlag ne 2) then begin
    ; If not using Fixed Ef mode then we are finished and don't require additional processing
    ; For Fixed Ef, the A4 Calibration data still needs to be processed
    Self.requireProcessing = 0
  endif
endif else begin
  if (Self.anaModeFlag ne 3) then begin
    ; if NOT 2-axis (diffraction) mode
    msg = "You must specify an 'Energy Calibration File' in order to proceed'"
    msg = [msg,"Use the 'Dataset Input' -> 'Load Energy Calibration' menu"]
    Self->ErrorMessage, msg, Severity=0, title='Energy Calibration File Required!'
  endif
endelse


if (Self.a4CalibFilePresent && Self.anaModeFlag ge 2) then begin
  dataHash = Self.a4calibData
  data = dataHash['Data']
  a4 = dataHash['A4']
  Ef = dataHash['Ef']
  nDat = dataHash['nDat']
  nPix = dataHash['nPix']
  meanInt = dataHash['meanInt']
  sigmaInt = dataHash['sigmaInt']
  midIndex = fix((nPix-1)/2)

  x = a4
  A4min = min(a4, max=A4max)
  a4sigma = fltarr(nPix)+1.0 ;assume widths of approx 1.0
  a4sigmaMin = a4sigma * 0.1        ; 10% of Esigma
  a4sigmaMax = a4sigma * 2          ; 200% of Sigma
  a4min = a4min * (fltarr(nPix) + 1.0)  ; make it a vector for convenience
  a4max = a4max * (fltarr(nPix) + 1.0)  ; make it a vector for convenience
  
  ;p = [1.0,0.0,1.0,0.0,0.0]
 
  a4Pix = []
  a4PixErr = []
  pixArea = []
  pixel = []
  fitData = data*0.0
  sqrt2pi = sqrt(2*!pi)

  if (Self.instrumentName eq 0) then begin
    ; for BT7, we have extra information (from Yang Zhao, BT7 instrument scientist)
    ; the user specifies the A4Value which is the A4 for the central A4 that intersects the calibration peak
    ; Also for pixel 1, the a4 value has value of -3 rel to the central value
    ; and for pixel 48 the a4 value has value of +3 rel to the central value
    ; Putting this all together gives a linear eqn
    ; A4(px) = A4mean - 3 + px*(6/47)
    ; where px is the pixels in the range 0 to 47 (ie 48 pixels)
    px = findgen(nPix)
    A4px = Self.A4Value - 3 + (6.0*px)/(nPix - 1)
    a4min = a4px - 0.5*Self.A4Width    ; min a4 range for fitting
    a4max = a4px + 0.5*Self.A4Width    ; max a4 range for fitting
  endif

  for i = 0, nPix-1 do begin
    pixel = [pixel,i+1]                     ; pixel nos
    msg = "A4 Calibration Fit: Fitting pixel "+string(pixel[i],format='(I3.3)')+" of "+string(nPix,format='(I3.3)')
    Self->StatusMessage, msg
    y = reform(data[*,i])
    yerror = sqrt(y)
    ind = where(yerror le 0.0, cnt)
    if (cnt gt 0) then yerror[ind] = 1.0
    
    fitIndex = Where(x le a4max[i] and x ge a4min[i], fitCnt)
    if (fitCnt le 4) then fitIndex = Indgen(N_elements(x))

    maxy = max(y[fitIndex])
    IntMin = 0.0  ;maxy * 0.5
    IntMax = maxy * 1.5
    BCmax = maxy
    BCmin = 0.0
    pMin = [IntMin,a4min[i],a4sigmaMin[i],BCmin]
    pMax = [IntMax,a4max[i],a4sigmaMax[i],BCmax]
    
    ;oDiffEvo->SetProperty, xData=x, yData=y, yError=yError, pMin=pMin, pMax=pMax, startingFlag=0
    oDiffEvo->Setproperty, xData=x[fitIndex], yData=y[fitIndex], yError=yError[fitIndex], pMin=pMin, pMax=pMax, startingFlag=0
    status = oDiffEvo->Fit()

    oDiffEvo->GetProperty, initParam=p0, bestParam=p1, bestfValue=chisq, generationCnt=genCnt
    oDiffEvo->setproperty, xdata=x  ; necessary just in case x was restricted previously
    status = oDiffEvo->Model(p1,calc=yFit)
    fitData[*,i] = yFit
    a4Pix = [a4Pix,p1[1]]               ; Fitted energy transfer at each pixel == peak pos
    a4PixErr = [a4PixErr,p1[1]*0.05]    ; estimate fitted error as 5% of fitted value
    pixArea = [pixArea,p1[0]]
  endfor
  msg = "A4 Calibration Fit successfully completed!"
  Self->StatusMessage, msg
  
  ;dataHash['anaModeFlag'] = Self.anaModeFlag  ; Note the mode that was used during processing of the data
  dataHash['A4Pix'] = a4Pix
  ;dataHash['EfPixFit'] = EfPixFit
  dataHash['pixel'] = pixel
  ;dataHash['sen'] = sens
  dataHash['fitData'] = fitData
  
  ; Determine Delta a4 at each pixel
  ; 3) Fixed Ef Analyzer (see above for Flat and See Through)
  ; 4) 2-Axis mode
  dataHash['DeltaA4_fixed'] = (Self.instrumentName eq 0)? $
    a4Pix - Self.A4Value    : $                             ; <-- BT7: delta is relative to midvalue of the A4 scan range of detector
    a4Pix[midIndex] - a4Pix                                 ; <-- SPINS: delta is relative to central pixel
  
  ; For 2-axis mode, Delta Ef is zero
  if (Self.anaModeFlag eq 3) then begin
    dataHash['EfPix'] = fltarr(nPix)
    dataHash['sen'] = pixArea / mean(pixArea)
  endif
  
  Self.requireProcessing = 0
endif else begin
  if (Self.anaModeFlag eq 2 || Self.anaModeFlag eq 3) then begin
    str = ['Flat','See Through','Fixed Ef','Two Axis (Diffraction)']
    msg = "The 'Analyzer Mode' is currently set to "+ str[Self.anaModeFlag]
    msg = [msg,"In this mode an 'A4 Calibration File' must also be specified"]
    msg = [msg,"in order to determine the Delta A4 values at each pixel"]
    msg = [msg,"Use the 'Dataset Input' -> 'Load A4 Calibration' menu"]
    Self->ErrorMessage, msg, Severity=0, title='A4 Calibration File Required!'
  endif
endelse

if (Self.requireProcessing eq 0) then widget_control, (*sPtr).wSaveCalib, sensitive=1

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSPSDCalibTool::UpdateMask
;+
; PURPOSE:
;   Update the channels/pixels to be masked. This is calculated from the Mask threshold setting
;
; PARAMETERS:
;
;
; KEYWORDS:
;-
pro SPINSPSDCalibTool::UpdateMask
compile_opt idl2

if (~Self.calibFilePresent && Self.anaModeFlag ne 3) then begin
  msg = "Please load Calibration data first"
  Self.StatusMessage, msg
  return
endif

if (Self.requireProcessing) then begin
  msg = "Calculation requires updating! Please use the 'Process calibration dataset(s)' button"
  Self.StatusMessage, msg
  return
endif

if ((Self.anaModeFlag eq 2 || Self.anaModeFlag eq 3) && ~Self.a4CalibFilePresent) then begin
  msg = "Please load A4 Calibration data first"
  Self.StatusMessage, msg
  return
endif

dataHash = Self.calibData
a4dataHash = Self.a4CalibData

sen = (Self.anaModeFlag eq 3)? a4dataHash['sen'] : dataHash['sen']
pixel = (Self.anaModeFlag eq 3)? a4dataHash['pixel'] : dataHash['pixel']

Self->GetProperty, MASKTHRESHOLD=maskThreshold
maxs = max(sen,min=mins)
range = maxs-mins
limit = maskThreshold*0.01*range
index = where(sen le limit, cnt)
maskedPixels = ''
if (cnt gt 0) then status = intVector2CompactString(pixel[index],maskedPixels)
Self->SetProperty, MASKEDPIXELS=maskedPixels

Self->UpdatePropertySheet

end


;;===============================================================================
;; SPINSPSDCalibTool::UpdateIntensityScale
;;+
;; PURPOSE:
;;   Update the intensity scale - switch between linear/logbase10 scales
;;
;; PARAMETERS:
;;   
;;
;; KEYWORDS:
;;-
;pro SPINSPSDCalibTool::UpdateIntensityScale
;compile_opt idl2
;
;Self->GetProperty, logFlag=logFlag, minIntensity=minval, maxIntensity=maxval
;
; must be single crystal sample
;if (Self.sampTypeFlag ne 0 && Self.sampTypeFlag ne 1) then return
;
;nData = oCont->Count()
;if (nData eq 0) then return
; 
;oData = oCont->Get(/all)
;
;case logFlag of
;   0: begin ; switch to linear scale
;      minVal = 10.0^(minVal)  ; update max and min intensity to the same scale as the intensity
;      maxVal = 10.0^(maxVal)
;      for i = 0,nData-1 do begin
;         oZ = oData[i]->GetByName('Counts')
;         if (~obj_valid(oZ)) then continue
;         if (~oZ->GetMetaData('LinearCounts',counts)) then continue
;         status = oZ->SetData(counts,/no_copy);,/no_notify)      
;      endfor
;   end
;   
;   1: begin ; switch to log scale
;       minVal = (minVal gt 0.0)? alog10(minVal) : 0.0 ; update max and min intensity to the same scale as the intensity
;       maxVal = (maxVal gt 0.0)? alog10(maxVal) : 0.0 
;       for i = 0,nData-1 do begin
;         oZ = oData[i]->GetByName('Counts')
;         if (~obj_valid(oZ)) then continue
;         if (~oZ->GetMetaData('LinearCounts',counts)) then begin
;            ; probably data from an older session so create the metadata
;            status = oZ->Getdata(counts)
;            oZ->AddMetaData, 'linearCounts',counts
;         endif
;
;         index = where(counts le 0.0, nBad)
;         if (nBad gt 0) then counts[index] = !values.F_NAN
;         counts = alog10(temporary(counts))
;         status = oZ->SetData(counts,/no_copy);,/no_notify)      
;      endfor
;   
;   end
;   
;   else:
;endcase
;Self->SetProperty, minIntensity=minVal, maxIntensity=maxVal
;
;; Update the intensity range
;Self->UpdatePlotIntensityRange
;
;end
;;-------------------------------------------------------------------------------


;;===============================================================================
;; SPINSPSDCalibTool::UpdatePlotIntensityRange
;;+
;; PURPOSE:
;;   Update the max and min intensity of the existing plot
;;
;; PARAMETERS:
;;   
;;
;; KEYWORDS:
;;-
;pro SPINSPSDCalibTool::UpdatePlotIntensityRange, oVis
;compile_opt idl2
;
;Self->GetProperty, defaultIntensityFlag=defIntFlag, sampTypeFlag=sampTypeFlag, maxIntensity=maxVal, minIntensity=minVal
;
;; must be single crystal sample
;if (Self.sampTypeFlag ne 0 && Self.sampTypeFlag ne 1) then return
;
;if (Self.defaultIntensityFlag eq 1) then begin  ;using default intensity range
;   Self->GetProperty, selectedIDs=selIDs,nSelectedIDs=nSel
;   if (nSel eq 0) then return   ; exit if no dataset is currently selected
;   ; Retrieve intensity of selected data
;   intensity = []
;   for i=0,nSel - 1 do begin
;      oTest = Self->GetByIdentifier(selIDs[i])
;      if (~isa(oTest,'IDLitParameterSet')) then continue
;      ;status = oTest->GetMetaData('sampTypeFlag',sTypeFlag) ; only consider single crystal data to Mslice
;      ;if (sTypeFlag ne 1) then continue
;      oZ = oTest->GetByName('Counts')
;      status = oZ->GetData(counts)
;      intensity = [intensity,reform(counts,n_elements(counts))]
;   endfor
;   if (~isa(intensity)) then return
;   maxVal = max(intensity,min=minVal,/NAN)
;endif else begin
;   maxVal = Self.maxIntensity
;   minVal = Self.minIntensity
;endelse
;
;if (maxVal eq minVal) then return
;
;if (maxVal lt minVal) then begin
;   tempVal = maxVal
;   maxVal = minVal
;   minVal = tempVal
;endif
;
;if (obj_valid(oVis) && isa(oVis,'IDLitVisualization')) then begin
;   oVis->SetProperty, min_value=minVal, max_value=maxVal
;endif else begin
;   if (Self->HasVisualizations()) then begin
;      oWin = Self->GetCurrentWindow()
;      oView = oWin->GetCurrentView()
;      oLayer = oView->GetCurrentLayer()
;      oWorld = oLayer->GetWorld()
;      oDataSpace = oWorld->GetDataSpaces()
;      oVis = oDataSpace->GetVisualizations(count = nVis)
;   
;      for i=0, nVis-1 do oVis[i]->SetProperty, min_value=minVal, max_value=maxVal
;   endif
;endelse
;end
;;-------------------------------------------------------------------------------


;;===============================================================================
;; SPINSPSDCalibTool::UpdateIndependentVariables
;;+
;; PURPOSE:
;;   Update the Qx and Qy variables due to changes in the lattice parameter
;;
;; PARAMETERS:
;;   oPSet [in|out] - object whose data is to be updated
;;
;; KEYWORDS:
;;-
;pro SPINSPSDCalibTool::UpdateIndependentVariables, oPSet, updateObservers=updateObservers
;compile_opt idl2
;
;Self->GetProperty, LATPARAMFLAG=lpFlag, LATTICEPARAMETERS=latParm_str, indepVar1List=varList, sampTypeFlag=sampTypeFlag
;if (sampTypeFlag ne 1) then return  ; Only process Single Crystal data
;
;void = oPSet->GetMetaData('DATAPTRREF',dataPtr)
;if (~ptr_valid(dataPtr)) then return
;dataStr = *dataPtr
;dSpaceA = dataStr.dSpaceA
;dSpaceM = dataStr.dSpaceM
;nPix = dataStr.nPix
;nPts = datastr.nPts
;
;midIndex = fix((nPix-1)/2)
;
;unitVecnPts = Fltarr(nPts) + 1.0
;unitVecnPix = Fltarr(nPix) + 1.0
;
;Ei0 = (*dataStr.ei)
;Ef0 = (*dataStr.ef)
;chEf = Self.chEf  ; final energies for each pixel
;ekFac = Self.ekFac
;rtod = 1.0/!dtor
;
;lpLen = strlen(strtrim(latParm_str))
;if (lpFlag) then begin             ; 0 = from data, 1 = user specified
;   ; if using user specified lat params
;   toks = strsplit(latParm_str,/extract,count=nToks)
;   if (nToks eq 6) then latParm = float(toks)
;endif
;if ((lpFlag eq 0) || (n_elements(latParm) eq 0)) then begin
;   ; if lat params is undefined or not using user specified lat params
;   ; use the dataset's lattice parameters
;   latparm = (*dataStr.LATTICE_PTR)
;   if (lpLen eq 0) then begin
;      ; if the Tool's lattice Parameter property is blank, initialize it with the current dataset's
;      latParm_str = strjoin(strtrim(string(float(latParm)),2),' ',/single)
;      Self->SetProperty, latticeParameters = latParm_str
;      Self->RefreshPropertysheet
;   endif
;endif
;
;orient = *dataStr.ORIENTATION_PTR ; retrieve crystal orientation vectors u,v in rec. space coordinates
;u = orient[0:2]            ; the crystal orientation vectors specified in multiples of a*, b* and c*
;v = orient[3:5]
;
;; In case v is not perpendicular to u, w is obtained so that
;; u & w are orthogonal and equal in length.
;auv = getangle2hkl(u,v,latparm=latparm,/degree)
;qu = HKLnorm(u,latparm=latparm)
;qv = HKLnorm(v,latparm=latparm)
;w = chop(v - u/qu*qv*sin((90.-auv)*!dtor))
;qw = HKLnorm(w,latparm=latparm)
;w = w/qw*qu
;M = [ [u] $
;     ,[w] $
;     ,[crossp(u,w)]]
;MPrime = invert(M)
;
;; the norminal khl values
;h = (*dataStr.h)
;k = (*dataStr.k)
;l = (*dataStr.l)
;
;; calculate 2theta for individual pixels relative to the central pixel from the final energies
;; the central pixel is assummed to be pixel 127 out of 256
;dttp = Asin(!pi/(dSpaceA*Sqrt(chEf/ekFac))) - Asin(!pi/(dSpaceA*Sqrt(chEf[midIndex]/ekFac))) ; in radians
; 
;; loop through data points and calculate q values
;qp = fltarr(nPix,nPts)
;qxp = fltarr(nPix,nPts)
;qyp = fltarr(nPix,nPts)
;;hp = fltarr(nPix,nPts)
;;kp = fltarr(nPix,nPts)
;;lp = fltarr(nPix,nPts)
;for i = 0,nPts-1 do begin
;  hkl0 = [h[i],k[i],l[i]] ; norminal hkl for data point
;  q0 = HKLNorm(hkl0,latparm=latparm) ; norminal q magnitude given hkl0 and lattice params
;  tt0 = acos((ei0[i]+ef0[i]-ekFac*q0^2)/(2.0*sqrt(ei0[i]*ef0[i])))  ; the norminal ttheta or A40 in radians
;  ttp = tt0 + dttp      ; ttheta at each pixel in radians
;  qp[*,i] =  Sqrt( ( ei0[i]+chEf-2*sqrt(ei0[i]*chEf)*Cos(ttp)) / ekFac) ; Q at each pixel
;  
;  ; Need to decompose Q into its hkl components
;  
;  ;Below solves for a0,b0 such that hkl0 = a0 u + b0 w
;  ;since u and w are orthogonal vectors, they serve as basis vectors for cartesian coordinate.
;  ;Then we can use a rotational matrix to rotate [a0,b0] by known angles, which are dttp to determine
;  ;[ap,bp] thus enabling the evaluation of hklp at any pixel through 
;  ;hklp = ap u + bp w
;  tmp = chop(hkl0##MPrime) ; M = [[u],[w],[crossp(u,w)]]; MPrime = inverse(M)
;  a0 = tmp[0]
;  b0 = tmp[1]
;  ;Determine ap, bp and hence [Qh,Qk,Ql]
;  for j=0,nPix-1 do begin
;    sdttp = sin(dttp[j])
;    cdttp = cos(dttp[j])
;    rotmat = [[ cdttp,sdttp] $
;             ,[-sdttp,cdttp]]
;    tmp = rotmat##transpose([a0,b0]) ; [ap,bp]=rotmat(dttp)[a0,b0]
;    hklp = tmp[0]*u + tmp[1]*w ; hklp = ap u + bp w
;    hklp = hklp/HKLnorm(hklp,latparm=latparm) * q0 ; scale the length qp to be same as q0
;    ;hp[j,i] = hklp[0]
;    ;kp[j,i] = hklp[1]
;    ;lp[j,i] = hklp[2]
;    apbp = hklp##MPrime
;    qxp[j,i] = apbp[0]
;    qyp[j,i] = apbp[1]
;  endfor
;endfor
;
;xAA2RLU = qu                 ; e.g. ~ 2*pi/a  if u = [1,0,0]
;yAA2RLU = qw                 ; e.g. ~ 2*pi/c  if v = [0,0,1]
;
;Self->GetProperty, QUNITS=rlu       ;  rlu = 0 => 1/A, 1 => r.l.u.
;
;oQX = oPSet->GetByName(varList[0],count=count)
;if (count ne 1) then return
;oQY = oPSet->GetByName(varList[1],count=count)
;if (count ne 1) then return
;oQTot = oPSet->GetByName('|Q|',count=count)
;
;; determine appropriate labels to use for qx and qy
;xlabrlu = (u[0] eq 0)? '0' : 'H'
;xlabrlu += (u[1] eq 0)? '0' : 'K'
;xlabrlu += (u[2] eq 0)? '0' : 'L'
;ylabrlu = (w[0] eq 0)? '0' : 'H'
;ylabrlu += (w[1] eq 0)? '0' : 'K'
;ylabrlu += (w[2] eq 0)? '0' : 'L'
;xunitrlu = 'r.l.u.'
;yunitrlu = 'r.l.u.'
;
;xlab = 'qx'
;ylab = 'qy'
;xunit = '$\AA^{-1}$'
;yunit = '$\AA^{-1}$'
;if (rlu eq 1) then begin
;  xlab = xlabrlu
;  ylab = ylabrlu
;  xunit = xunitrlu
;  yunit = yunitrlu
;endif
;oQx->AddMetaData,'Long_name',xlab
;oQx->AddMetaData,'Units',xunit
;oQy->AddMetaData,'Long_name',ylab
;oQy->AddMetaData,'Units',yunit
;
;status = oQx->GetMetaData('RLU',unitFlag)    ; unitFlag eq 0 => 1/A, 1 => rlu 
;status = oQx->GetMetaData('AA2RLU',oldxAA2RLU)
;status = oQy->GetMetaData('AA2RLU',oldyAA2RLU)
;
;; Only need to rescale data if the active units for qx,qy is in inverse angstroms
;if (rlu eq 1) then begin                     ; rlu is equivalent to unitFlag, just stored at different locations
;   ; rescale using updated conversion factor
;   status = oQX->SetData(qxp,/no_copy,/no_notify)
;   status = oQY->SetData(qyp,/no_copy,/no_notify)
;endif else begin
;  status = oQX->SetData(qxp*(xAA2RLU/oldxAA2RLU),/no_copy,/no_notify)
;  status = oQY->SetData(qyp*(yAA2RLU/oldyAA2RLU),/no_copy,/no_notify)  
;endelse
;status = oQTot->SetData(qp,/no_copy,/no_notify)
;  
;; update the stored conversion factors
;oQx->AddMetaData,'AA2RLU', xAA2RLU
;oQy->AddMetaData,'AA2RLU', yAA2RLU   
;
;
;if (keyword_set(updateObservers)) then begin
;   oQX->NotifyDataChange
;   oQX->NotifyDataComplete
;   oQY->NotifyDataChange
;   oQY->NotifyDataComplete
;endif
;
;end
;;-------------------------------------------------------------------------------


;;===============================================================================
;; SPINSPSDCalibTool::Mslice
;;+
;; PURPOSE:
;;   Launch Mslice tool with a copy of the currently selected data for further analysis. 
;;   If Mslice is already launched, update its data with the currently selected data.
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;-
;function SPINSPSDCalibTool::Mslice
;compile_opt idl2
;
;; Basic error Handler
;if (n_elements(!debug) && (!debug eq 0)) then begin
;    catch, catchError
;    if (catchError ne 0) then begin
;        if (widget_info(wB,/valid)) then widget_control, wB, /destroy
;        Self->StatusMessage, !ERROR_STATE.msg
;        catch, /cancel
;        return, 0
;    endif
;endif
;
;oUI = Self->GetUI()
;oUI->GetProperty, group_leader = wTLB
;
;; display dialog to let user select variables to be exported to Mslice 
;Self->GetProperty, daveTool=daveTool ,selectedIDs=selIDs,nSelectedIDs=nSel
;if (nSel eq 0) then return, 0  ; exit if no dataset is currently selected
;
;
;oFirst = Self->GetByIdentifier(selIDs[0])
;if (~isa(oFirst,'IDLitParameterSet')) then return, 0
;status = oFirst->GetMetaData('sampTypeFlag',sTypeFlag)
;if (sTypeFlag eq 0) then Self->GetProperty, INDEPVAR2LIST=exportList, exportIndex=exportIndex
;if (sTypeFlag eq 1) then Self->GetProperty, INDEPVAR1LIST=exportList, exportIndex=exportIndex
;if (n_elements(exportList) eq 0) then return, 0
;
;; construct basic dialog
;title = 'Select Variables to Export'
;wB = widget_base(/col,title=title,/modal,group_leader=wTLB)
;wB1 = widget_base(wB,/col,grid=2,/frame,/nonexclusive,scr_xsize=200)
;wB2 = widget_base(wB,/row,/frame)
;
;n = n_elements(exportList)
;wButtons = lindgen(n)
;for i=0,n-1 do begin
;   wButtons[i] = widget_button(wB1,value=exportList[i],uname=exportList[i])
;   widget_control, wButtons[i], set_button=exportIndex[i]
;endfor
;wOK = widget_button(wB2,value='OK',uname='APPLY',/align_center)
;wCancel = widget_button(wB2,value='Cancel',uname='CANCEL',/align_center)
;
;statePtr = ptr_new({wButtons:wButtons,exportIndex:exportIndex,cancel:0})
;widget_control, wB, /realize, set_uvalue=statePtr
;
;xmanager, 'SPINSPSDExport2Mslice', wB, event_handler='SPINSPSDExport2Mslice_event'
;
;exportIndex = (*statePtr).exportIndex
;cancel = (*statePtr).cancel
;ptr_free, statePtr
;
;if (cancel) then return, 0
;
;Self->SetProperty, exportIndex=exportIndex
;
;index = where(exportIndex eq 1,nVar)
;if (nVar lt 1) then return, 0
;
;exportList = exportList[index]
;
;; Counts and Error
;z = []
;Err = []
;label = ['Intensity','Error']
;unit = ['','']
;unique = [0,0]
;
;oData = []
;for i=0,nSel - 1 do begin
;   oTest = Self->GetByIdentifier(selIDs[i])
;   if (~isa(oTest,'IDLitParameterSet')) then continue
;   status = oTest->GetMetaData('sampTypeFlag',sTypeFlag) ; only export single crystal data to Mslice
;   if (sTypeFlag ne 0 && sTypeFlag ne 1) then continue
;   oZ = oTest->GetByName('Counts')
;   if (~oZ->GetMetaData('LinearCounts',counts)) then status = oZ->GetData(counts)
;   Z = [Z,reform(counts,n_elements(counts))]
;   oErr = oTest->GetByName('Error')
;   status = oErr->GetData(error)
;   Err = [Err,reform(error,n_elements(error))]
;   oData = [oData,oTest]
;endfor
;nSel = n_elements(oData)
;npts = n_elements(Z)
;if (npts eq 0) then return, 0
;data = fltarr(npts,2+nVar)
;;index = where(finite(Z,/NAN),nanCnt)
;;if (nanCnt gt 0) then Z[index] = -1.0e20
;data[*,0] = Z
;data[*,1] = Err
;
;; Get the independent vars
;for i=0,nVar-1 do begin
;   varName = exportList[i]
;   varData = []
;   for j=0,nSel-1 do begin
;      oVar = oData[j]->GetByName(varName)
;      if (~obj_valid(oVar)) then continue
;      if (j eq 0) then begin
;         status = oVar->GetMetaData('Long_name',varLab)
;         status = oVar->GetMetaData('Units',varUnit)
;         label = [label,varLab]
;         unit = [unit,varUnit]
;         unique = strcmp(varName,'E',/fold_case)? [unique,1] : [unique,0]
;      endif
;      status = oVar->GetData(iVarData)
;      varData = [vardata,reform(iVarData,n_elements(iVarData))]
;   endfor
;   data[*,i+2] = varData
;endfor
;
;;; discriminate for any masked data
;;void = where(finite(data),complement=mskIndex,ncomplement=nMsk)
;;if (nMsk gt 0) then data[mskIndex] = -1.0e20
;
;
;if (obj_valid(Self.objMslice) && (Self.multipleMsliceWinFlag eq 0)) then begin
;   Self.objMslice->Reset_data, data=data, label=tex2idl(label), instrument='SPINS' $
;                             ,is_uniq=unique, unit=tex2idl(unit), /no_copy
;endif else begin
;   dataPtr = ptr_new({data:temporary(data),label:tex2idl(label),unit:tex2idl(unit),instrument:'SPINS',is_uniq:unique},/no_copy)
;   Self->GetProperty, DAVETOOL=daveTool, DATA_DIRECTORY=dataDir, working_directory=workDir
;   dcs_mslice, dataPtr=dataPtr, obj_mslice=objMslice, group_leader=wTLB $
;             ,DAVETool=daveTool, workDir=workDir, dataDir=dataDir
;   Self.objMslice = objMslice
;endelse
;
;return, 0
;end
;;-------------------------------------------------------------------------------
;
;
;;===============================================================================
;pro SPINSPSDExport2Mslice_event, event
;compile_opt idl2
;uname = widget_info(event.id,/uname)
;widget_control, event.top, get_uvalue=statePtr
;
;case uname of
;   'APPLY': begin
;      exportIndex = widget_info((*statePtr).wButtons,/button_set)
;      (*statePtr).exportIndex = exportIndex
;      widget_control, event.top, /destroy  
;   end
;   
;   'CANCEL': begin
;      (*statePtr).cancel = 1
;      widget_control, event.top, /destroy  
;   end
;   
;   else:
;   
;endcase
;if (strcmp(uname,'APPLY')) then begin
;endif
;
;end
;;-------------------------------------------------------------------------------


;===============================================================================
; SPINSPSDCalibTool::restoreDataVersion
;
; PURPOSE:
;   Restore the specified object to the latest version
;
; PARAMETERS:
;   oData [in|out] - object to be restored to the latest version
;
; KEYWORDS:
;
pro SPINSPSDCalibTool::restoreDataVersion, oData
compile_opt idl2

; restore to latest IDLitData version
oData->Restore

; Pull the data pointer structure and ensure it is up to data
currentVersion = Self.dataVersion

void = oData->GetMetaData('DATAPTRREF',tempPtr)
oldDataVersion = (*tempPtr).dataVersion

if (currentVersion gt oldDataVersion) then begin
   ; Update the data as necessary
endif

end




;===============================================================================
; SPINSPSDCalibTool::IsNG5Dataset
;+
; PURPOSE:
;   Determine if the specified file is a valid SPINS dataset. Works for network files from the FTP server. 
;   If a SPINS dataset, also read the scan type
;
; PARAMETERS:
;   filename [in] - filename to be read.
;
; KEYWORDS:
;
;   scanType [out] - the type of scan performed eg 'Q', 'I', etc
; 
; RETURNS:
;   1 if it is valid SPINS (.ng5) dataset
;   0 otherwise
;-
function SPINSPSDCalibTool::IsNG5Dataset, filename, errmsg=errmsg, oFTP=oFTP, scanType=scantype

errmsg = 'Not a valid NG5 data file'
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   if n_elements(lun) ne 0 then free_lun,lun,/force
   errmsg = !error_state.msg
   return,0B
endif

fromFtp = (stregex(filename,'/pub/ncnrdata/',/fold,/bool))? 1 : 0
if (fromFTP) then begin
  if (~obj_valid(oFTP)) then return, 0
  ; retrieve file contents from ftp server and store into dstring array
  buffer = oFTP->GetFileContent(filename,/string)
  if (strcmp(buffer[0],'')) then return, 0
  nlines = n_elements(buffer)
endif else begin
  if ~file_test(filename) then begin
     errmsg = 'File '+filename+' not found'
     return,0B
  endif
  nlines = file_lines(filename)
  buffer = strarr(nlines)
  
  ; B/c of unusual error resulting from running out of available logical units
  ; (probably a bug in get_lun); add the following 4 lines to force the use of 
  ; the same first available file unit every time
  lun = 100
  while ((fstat(lun)).open && (lun lt 129)) do begin
    lun++
  endwhile
  
  openr,lun,filename;,/get_lun
  readf,lun,buffer
  free_lun,lun,/force
endelse

; It must be an ICP Q-buffer or I-buffer file: line 1, col 37 should be letter Q or I
scanType = strmid(buffer[0],36,1)
if (~strcmp(scanType,'Q') && ~strcmp(scanType,'I')) then begin
  errmsg = "Unrecognised file format: Must be 'Q' or 'I' scan"
  return, 0
endif

; Is there a '#ASD' entry on line twelve? If so, this is a+ mode SPINS data file
asd = (scanType eq 'Q')? strmid(strtrim(buffer[11],2),0,4) : strmid(strtrim(buffer[12],2),0,4)
if (~strcmp(asd,'#ASD')) then begin
  errmsg = '#ASD tag missing: Unknown file format'
  return, 0
endif

;; Measurement must have been performed in fixed-final energy mode
;if (~strcmp(strmid(buffer[8],27,8),'EA fixed')) then return, 0

return, 1B
end


;===============================================================================
; SPINSPSDCalibTool::IsBT7Dataset
;+
; PURPOSE:
;   Determine if the specified file is a valid BT7 dataset. Works for network files from the FTP server.
;   If a BT7 dataset, also read the analyzer/detector mode used
;
; PARAMETERS:
;   filename [in] - filename to be read.
;
; KEYWORDS:
;
;   anaMode [out]     - the analyzer/detector package mode index used to perform the scan
;
;   anaModeName [out] - the analyzer/detector package mode name used to perform the scan
;
; RETURNS:
;   1 if it is valid BT7 (.bt7) dataset
;   0 otherwise
;-
function SPINSPSDCalibTool::IsBT7Dataset, filename, errmsg=errmsg, oFTP=oFTP, anaModeFlag=anaMode, anaModeName=anaModeName $
                                        ,buffer=buffer, headerLen=nHeader

errmsg = ''
anaModeName = ''
catch,the_error
if the_error ne 0 then begin
  catch,/cancel
  if n_elements(lun) ne 0 then free_lun,lun,/force
  errmsg = !error_state.msg
  return,0B
endif

fromFtp = (stregex(filename,'/pub/ncnrdata/',/fold,/bool))? 1 : 0
if (fromFTP) then begin
  if (~obj_valid(oFTP)) then return, 0
  ; retrieve file contents from ftp server and store into buffer array
  buffer = oFTP->GetFileContent(filename,/string)
  if (strcmp(buffer[0],'')) then return, 0
  nlines = n_elements(buffer)
endif else begin
  if ~file_test(filename) then begin
    errmsg = 'File '+filename+' not found'
    return,0B
  endif
  nlines = file_lines(filename)
  buffer = strarr(nlines)

  ; B/c of unusual error resulting from running out of available logical units
  ; (probably a bug in get_lun); add the following 4 lines to force the use of
  ; the same first available file unit every time
  lun = 100
  while ((fstat(lun)).open && (lun lt 129)) do begin
    lun++
  endwhile

  openr,lun,filename;,/get_lun
  readf,lun,buffer
  free_lun,lun,/force
endelse

; Scan throufh an identify header section of the buffer
for i=0,nlines-1 do begin
  if (strmid(buffer[i],0,1) ne '#') then break
endfor
if (i eq 0) then begin
  errmsg = "Unrecognised file format: Expecting an ICE file"
  return, 0    
endif
header = buffer[0:i-1]
nHeader = n_elements(header)
nData = nlines - nHeader

; It must be an ICE file
void = where(stregex(header,'#ICE ',/bool,/fold_case),icePresent)
if (icePresent eq 0) then begin
  errmsg = "Unrecognised file format: Expecting an ICE file"
  return, 0    
endif

; Search for the BT7 instrument text from the header
void = where(stregex(header,' BT7',/bool,/fold_case),BT7Present)
if (BT7Present eq 0) then begin
  errmsg = filename + " is not a valid BT7 file"
  return, 0
endif


; Read the analyzerdetector mode
keyIndex = where(stregex(header,'#AnalyzerDetectorMode',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = strsplit(header[keyIndex],count=ntok,/extract)
  anaMode = fix(toks[1])
  ;anaModeName = toks[2]
endif else begin
  errmsg = "Could not determine the AnalyzerDetector mode from "+filename
  return, 0    
endelse

if (anaMode lt 4) then begin
  ; PSD detectors in use only if anaMode >= 4
  if (anaMode eq 1) then anaModeName = 'DiffDet'
  if (anaMode eq 2) then anaModeName = 'SDFlat'
  if (anaMode eq 3) then anaModeName = 'SDHF'
  errmsg = "AnalyzerDetector mode is less than 4. The PSD detectors are not active!"
  return, 0
endif

; Get the column headers for the dataset
colNames = strsplit(header[nHeader-1],count=ntoks,/extract)
colNames = colNames[1:nToks-1]

; locate a few key column names: Diffdet, PSDet, AnalyzerRotation, PSDC00
; AnalyzerRotation == analyzer position (A5)
; PSDet == PSD detector location (A6)
ddIndex = where(stregex(colNames,'Diffdet',/bool,/fold_case),keyPresent)
if (~keyPresent) then begin
  errmsg = "Dataset is incomplete; 'Diffdet' column not present in file!"
  return, 0
endif
pdIndex = where(stregex(colNames,'PSDet',/bool,/fold_case),keyPresent)
if (~keyPresent) then begin
  errmsg = "Dataset is incomplete; 'PSDet' column not present in file!"
  return, 0
endif
amIndex = where(stregex(colNames,'AnalyzerRotation',/bool,/fold_case),keyPresent)
if (~keyPresent) then begin
  errmsg = "Dataset is incomplete; 'AnalyzerRotation' column not present in file!"
  return, 0
endif
void = where(stregex(colNames,'PSDC00',/bool,/fold_case),keyPresent)
if (~keyPresent) then begin
  errmsg = "Dataset is incomplete; PSD detector columns (PSDC**) are not present in file!"
  return, 0
endif

; read the first datapoint
data = float(strsplit(buffer[nHeader],/extract))
DiffDet = data[ddIndex]
PSDet = data[pdIndex]
AnalyzerRotation = data[amIndex]

; Determine the operating mode
tol = 0.1
if (DiffDet eq 180.0) then begin                            
  ; DiffDet == 180.0
  anaModeName = "DiffDet"
endif else begin
  ; DiffDet != 180.0
  if (abs(PSDet) lt tol) then begin
    ; PSDDet (A6) == 0.0
    if (abs(AnalyzerRotation - 90.0) lt tol) then begin
      ; AnalyzerRotation == 90.0 +/- 0.1
      anaModeName = "PSD2Axis"
    endif else begin
      ; AnalyzerRotation != 90.0
      anaModeName = "PSD2Axis"
      errmsg = "Warning: Analyzer is not set correctly! AnalyzerRotation != 90.0"
    endelse      
  endif else begin
    ; PSDDet (A6) != 0.0
    if (abs(AnalyzerRotation - PSDet/2.0) lt tol) then begin
      ; AnalyzerRotation == PSDet/2.0
      anaModeName = "PSDFlat"
    endif else if (abs(AnalyzerRotation) lt tol) then begin
      ; AnalyzerRotation == 0.0 +/- 0.1
      anaModeName = "PSDSeeThrough"
    endif else begin
      ; AnalyzerRotation != PSDet/2.0 and != 0.0
      anaModeName = "PSDFixedEf"
    endelse
  endelse
endelse

return, 1B
end


;===============================================================================
; SPINSPSDCalibTool::ReadICEFile
;
; PURPOSE:
;   Read the contents of an ICE format BT7 dataset
;
; PARAMETERS:
;   filename[in] - filename to be read
;
; KEYWORDS:
;   type [in]   - flag specifying whether A4 or energy scan is to be read from file
;
;
function SPINSPSDCalibTool::ReadICEFile, filename, type=type, oFTP=oFTP
compile_opt idl2

; Exit if not an ICE format dataset
if (~Is_ice(filename)) then return, 0

if ~Self->Isbt7dataset(filename, errmsg=errmsg, anaModeFlag=anaMode, anaModeName=anaModeName, oFTP=oFtp, buffer=buffer, headerLen=nHLen) then begin
  Self->Statusmessage, errmsg
  Return, 0
endif else if (errmsg ne '') then begin
  Self->Errormessage, errmsg, severity=0
endif

; Check mode and ensure it is what we want
case (Self.anamodeflag) of
  '0': begin      ; Flat
    if (~Strcmp(anaModeName,'PSDFlat',/fold_case)) then begin
      msg = "The Analyser mode property is currently set to 'Flat'"
      msg = [msg,'But the calibration file '+filename]
      msg = [msg,'is found to have an incompartible Analyzer/Detector mode setting of '+anaModeName]
      Self->Errormessage, msg, severity=1
      Return, 0
    endif
  end

  '1': begin      ; Seethrough
    if (~Strcmp(anaModeName,'PSDSeeThrough',/fold_case)) then begin
      msg = "The Analyser mode property is currently set to 'See Through'"
      msg = [msg,'But the calibration file '+filename]
      msg = [msg,'is found to have an incompartible Analyzer/Detector mode setting of '+anaModeName]
      Self->Errormessage, msg, severity=1
      Return, 0
    endif
  end

  '2': begin      ; Fixed Ef
    if (~Strcmp(anaModeName,'PSDFixedEf',/fold_case)) then begin
      msg = "The Analyser mode property is currently set to 'Fixed Ef'"
      msg = [msg,'But the calibration file '+filename]
      msg = [msg,'is found to have an incompartible Analyzer/Detector mode setting of '+anaModeName]
      Self->Errormessage, msg, severity=1
      Return, 0
    endif
  end

  '3': begin      ; 2-Axis
    if (~Strcmp(anaModeName,'PSD2Axis',/fold_case)) then begin
      msg = "The Analyser mode property is currently set to '2-Axis'"
      msg = [msg,'But the calibration file '+filename]
      msg = [msg,'is found to have an incompartible Analyzer/Detector mode setting of '+anaModeName]
      Self->Errormessage, msg, severity=1
      Return, 0
    endif
  end

  else:
endcase

; the contents of filename are now in the buffer array
nlines = N_elements(buffer)
header = buffer[0:nHLen-1]

cannotProceed = 0
; retrieve useful info from the header
keyIndex = Where(Stregex(header,'#AnaSpacing',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = Strsplit(header[keyIndex],count=ntok,/extract)
  dSpaceA = Float(toks[1])
endif else cannotProceed = 1
keyIndex = Where(Stregex(header,'#MonoSpacing',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = Strsplit(header[keyIndex],count=ntok,/extract)
  dSpaceM = Float(toks[1])
endif else dSpaceM = 0.0
keyIndex = Where(Stregex(header,'#Scan ',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = Strsplit(header[keyIndex],count=ntok,/extract)
  scanVarName = toks[2]
endif else scanVarName = ''
keyIndex = Where(Stregex(header,'#FixedE',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = Strsplit(header[keyIndex],count=ntok,/extract)
  if (ntok gt 1) then fixedEType = toks[1] else fixedEType=''
endif else fixedEType=''
keyIndex = Where(Stregex(header,'#AnalyzerDetectorDevicesOfInterest',/bool,/fold_case),keyPresent)
if (keyPresent) then begin
  toks = Strsplit(header[keyIndex],count=ntok,/extract)
  detectorNames = toks[1:ntok-1]
  nPix = ntok-1
endif else cannotProceed = 1
if (cannotProceed) then begin
  msg = "Vital information is missing from the header section! Cannot proceed..."
  Self->Statusmessage, msg
  Return, 0
endif

datakeys = ['Ei','Ef','A4','PSDet','AnalyzerRotation','DiffDet',detectorNames[0],'A6']
nKeys = N_elements(dataKeys)
keyIndex = Intarr(nKeys)
toks = Strsplit(header[nHlen-1],count=ntoks,/extract)
colNames = toks[1:nToks-1]
for i=0,nKeys-1 do begin
  keyIndex[i] = Where(Stregex(colNames,dataKeys[i],/bool,/fold_case),keyPresent)
  if (~keyPresent) then begin
    msg = "'"+dataKeys[i]+"' column is missing from the dataset! Cannot proceed..."
    Self->Statusmessage, msg
    Return, 0
  endif
endfor

; check if the last line contains a comment
nDat =  (Stregex(buffer[nLines-1],':END',/bool,/fold_case))? nlines - nHlen - 1 : nlines - nHlen
dataBuffer = Buffer[nHlen:(nHlen+nDat-1)]
dataList = Strsplit(dataBuffer,/extract)

if (Float(!version.release) ge 8.2) then begin  ; seems there is bug in list::ToArray() for older versions!
  dataString = dataList->Toarray()
endif else begin
  dataString = []
  for i=0,dataList.Count()-1 do dataString = [dataString,Transpose(dataList[i])]
endelse

Ei = Float(dataString[*,keyIndex[0]])
Ef = Float(dataString[*,keyIndex[1]])
E = Ei - Ef
A4 = Float(dataString[*,keyIndex[2]])
PSDet = Float(dataString[*,keyIndex[3]])
AnalyzerRotation = Float(dataString[*,keyIndex[4]])
DiffDet = Float(dataString[*,keyIndex[5]])
A6 = Float(dataString[*,keyIndex[7]])
;PSDet = float(dataString[*,keyIndex[5]])

; Evaluate data so far to ensure it conforms to what we expect
small = 0.1
case Strupcase(type) of
  'A4': begin     ; Only read PSDDiff datasets
    diff = Abs(A4[nDat-1] - A4[0])
    A4isVarying = (diff gt small)? 1 : 0
    if (~A4isVarying) then begin
      msg = ['A4 does not appear to be varying in the calibration file:', filename,'Cannot Proceed...']
      Self->Errormessage, msg, severity=1
      Return, 0
    endif
    dataHash = Self.a4calibdata
    a4mean = Mean(A4)
    Self->Setproperty, A4Value = a4mean
    a4range = Max(a4) - Min(a4)
    if (a4range gt 20) then begin
      msg = 'The A4 scan range for this dataset is large and may contain multiple peaks!'
      msg = [msg,'To process the data, we need to constrain the fitting to a single peak']
      msg = [msg,'This is done by specifying the "A4 Bragg Peak" property so that it is']
      msg = [msg,'approximately correct. It should be close to the value of A4 between pixel 24 and 25']
      msg = [msg,'for the correct calibration peak to be evaluated. Please select and display the']
      msg = [msg,'"PSD Image - A4 Scan" and then zoom in as needed to read off the A4 value.']
      Self->Errormessage, msg, title='Check the "A4 Bragg Peak" property', severity=0
    endif
  end

  'ENERGY': begin     ;
    diff = Abs(E[nDat-1] - E[0])
    EisVarying = (diff gt small)? 1 : 0
    if (~EisVarying) then begin
      msg = ['Energy transfer does not appear to be varying in the calibration file:', filename,'Cannot Proceed...']
      Self->Errormessage, msg, severity=1
      Return, 0
    endif
    dataHash = Self.calibdata
    Self->Setproperty, A6Value = A6[0]
  end
endcase

PSDData = Float(dataString[*,keyIndex[6]:keyIndex[6]+nPix-1])

x = Findgen(nPix) + 1.0
peakInt = Fltarr(nDat)
for i=0,ndat-1 do begin
  ; identify peak intensities and keep rolling sum
  peak_loc = Get_peak_pos(x,Reform(PSDData[i,*]),1,fwhm=fwhm,indices=indices)
  if (indices gt 0 and fwhm gt 0.0) then begin
    peakInt[i] = PSDData[i,indices]
  endif
endfor

dataHash['filename'] = file

; Determine standard deviation of peak intensities
dataHash['sigmaInt'] = Stddev(peakInt)
dataHash['meanInt'] = Mean(peakInt)

dataHash['nDat'] = nDat
dataHash['nPix'] = nPix
dataHash['Ef'] = Ef
dataHash['A4'] = A4
dataHash['A6'] = A6
dataHash['Data'] = PSDData
dataHash['Etran'] = E
dataHash['pixel'] = Indgen(nPix) + 1
dataHash['dSpaceM'] = dSpaceM
dataHash['dSpaceA'] = dSpaceA
dataHash['fixedEType'] = fixedEType
dataHash['anaModeFlag'] = Self.anamodeflag

return, 1B
end


;===============================================================================
; SPINSPSDCalibTool::ReadNICEFile
;
; PURPOSE:
;   Read the contents of a NICE format BT7 dataset. This is a NeXus/Hdf file
;
; PARAMETERS:
;   filename[in] - filename to be read
;
; KEYWORDS:
;   type [in]   - flag specifying whether A4 or energy scan is to be read from file
;
;
function Spinspsdcalibtool::ReadNICEFile, filename, type=type, oFTP=oFTP
compile_opt idl2

; Exit if not an hdf format dataset
if (~H5f_is_hdf5(filename)) then Return, 0

; file handle must be a long integer and must be set before calling Nxopen()
handle=0L
hdlerror=0

; Open the hdf file
; The file handle will subsequently be used just like a file unit
status = Nxopen(filename,'NXACC_READ',handle)
if (~status) then begin
  errmsg = 'Could not open nexus file: '+filename
  Return, 0
endif

; Determine the name of the first main group/entry in the file
; Required because groups are opened by name
nEntry = H5g_get_nmembers(handle.ivid, '/')
if (nEntry lt 1) then begin
  errmsg = filename + " contains no entries"
  Return, 0
endif
entryIndex = 0
group_name = '/'
entryName = H5g_get_member_name(handle.ivid, group_name, entryIndex)

; open the main NXentry group
if (~Nxopengroup(handle,entryName,'NXentry')) then begin
  errmsg = "Cannot open " + entryName
  Return, 0
endif

  ; Read various relevant details from the DAS_LOGS folder
  status = Nxopengroup(handle,'DAS_logs','NXcollection')
  
    ; These are the possible analyzer modes defined for BT7 as of 2022 in NICE format 
    NICE_anaModeNames = ['DD_2AXIS', $
                         'SD_2AXIS', $
                         'PSD_2AXIS', $               ;<--  2-AXIS analyzer mode
                         'SD_3AXIS_ENERGY', $
                         'SD_3AXIS_FLAT', $
                         'PSD_3AXIS_CONSTANT_EF', $   ;<--  Fixed Ef analyzer mode
                         'PSD_3AXIS_FLAT', $          ;<--  Flat analyzer mode
                         'PSD_3AXIS_ ENERGY' $        ;<--  See Through analyzer mode
                        ]
    status = Nxopengroup(handle,'analyzerMode','NXcollection')              ; open analyzerMode group
      status = Davenxopengetclosedata(handle,'mode',data=anaModeName)       ; read the analyzerMode 
    status = Nxclosegroup(handle)                                           ; close analyzerMode group
    
    ; Check to ensure the mode selected by user is consistent with the analyzer mode used for calibration dataset being read
    ; Exit if incompatible
    case (Self.anamodeflag) of
      '0': begin      ; Flat
        if (~Strcmp(anaModeName,'PSD_3AXIS_Flat',/fold_case)) then begin
          msg = "The Analyser mode property is currently set to 'Flat'"
          msg = [msg,'But the calibration file '+filename]
          msg = [msg,'is found to have an incompartible Analyzer/Detector mode setting of '+anaModeName]
          Self->Errormessage, msg, severity=1
          Return, 0
        endif
      end
    
      '1': begin      ; Seethrough
        if (~Strcmp(anaModeName,'PSD_3AXIS_ENERGY',/fold_case)) then begin
          msg = "The Analyser mode property is currently set to 'See Through'"
          msg = [msg,'But the calibration file '+filename]
          msg = [msg,'is found to have an incompartible Analyzer/Detector mode setting of '+anaModeName]
          Self->Errormessage, msg, severity=1
          Return, 0
        endif
      end
    
      '2': begin      ; Fixed Ef
        if (~Strcmp(anaModeName,'PSD_3AXIS_CONSTANT_EF',/fold_case)) then begin
          msg = "The Analyser mode property is currently set to 'Fixed Ef'"
          msg = [msg,'But the calibration file '+filename]
          msg = [msg,'is found to have an incompartible Analyzer/Detector mode setting of '+anaModeName]
          Self->Errormessage, msg, severity=1
          Return, 0
        endif
      end
    
      '3': begin      ; 2-Axis
        if (~Strcmp(anaModeName,'PSD_2AXIS',/fold_case)) then begin
          msg = "The Analyser mode property is currently set to '2-Axis'"
          msg = [msg,'But the calibration file '+filename]
          msg = [msg,'is found to have an incompartible Analyzer/Detector mode setting of '+anaModeName]
          Self->Errormessage, msg, severity=1
          Return, 0
        endif
      end
    
      else:
    endcase

    status = Nxopengroup(handle,'trajectory','NXcollection')
      ; Grap trajectory data details
      status = Davenxopengetclosedata(handle,'length',data=nDat)
      nDat = fix(max(nDat))
      status = Davenxopengetclosedata(handle,'defaultXAxisPlotNode',data=scanVarName)
      status = Davenxopengetclosedata(handle,'defaultYAxisPlotNode',data=detectorName)
      if (nDat lt 2) then begin
        ; scan too short, no need to continue
        msg = "The number of points in the dataset is "+string(nDat)
        msg = [msg, "Too few to proceed!"]
        Self->Errormessage, msg, severity=1
        Return, 0
      endif
      ; TODO: ensure scanVarName is consistent with the type of scan required either A4 or Energy
      ;if (scanVarName) then begin
      ;  ; scan too short, no need to continue
      ;  msg = "The number of points in the dataset is "+String(Fix(Max(nPointsArr)))
      ;  msg = [msg, "Too few to proceed!"]
      ;  Self->Errormessage, msg, severity=1
      ;  Return, 0
      ;endif
      case Strupcase(type) of
        'A4': begin
          if (~scanVarName.Contains('sampleTwoTheta',/fold)) then begin
            msg = "Cannot proceed because scan variable is not A4"
            Self->Errormessage, msg, severity=1
            return, 0
          endif
        end
        
        'ENERGY': begin
          if (~scanVarName.Contains('Et',/fold)) then begin
            msg = "Cannot proceed because scan variable is not Energy"
            Self->Errormessage, msg, severity=1
            Return, 0
          endif
        end
      endcase
    status = Nxclosegroup(handle) ; trajectory
  
    status = Nxopengroup(handle,'psDetector','NXcollection')
      ; Grap the PSD counts
      status = Davenxopengetclosedata(handle,'counts',data=psdData,attrNames='long_name',attrData=psdLabel)
      psdData = transpose(psdData)    ; stored as (npix,npts) in hdf/nexus
                                      ; but should be (npts,npix)
      status = Davenxopengetclosedata(handle,'description',data=psdDesc)
      status = Davenxopengetclosedata(handle,'detectorEfficiency',data=psdEfficiencies)
      status = Davenxopengetclosedata(handle,'dimension',data=nPix)
    status = Nxclosegroup(handle) ; PSD Detector

    status = Nxopengroup(handle,'et','NXcollection')
      ; Grab the energy transfer
      status = Davenxopengetclosedata(handle,'deltaE',data=E)
      status = Davenxopengetclosedata(handle,'fixedEnergyMode',data=fixedEType)
    status = Nxclosegroup(handle) ; Et 

  status = Nxclosegroup(handle)     ; DAS_logs

  ; Instrument Group: - monochromator/analyzer/detectors
  status = Nxopengroup(handle,'instrument','NXcollection')
    status = Nxopengroup(handle,'monochromator','NXcollection')
    ; Monochromator info
    status = Davenxopengetclosedata(handle,'dspacing',data=dspaceM,attrNames='units',attrData=dspaceUnits)
    status = Davenxopengetclosedata(handle,'energy',data=Ei,attrNames=['error','units'],attrData=EiAttrs)
    status = Davenxopengetclosedata(handle,'material',data=monoMaterial)
    status = Davenxopengetclosedata(handle,'rotation_angle',data=A4)
    ;Print,' '
    ;Print,'Monochrmator:  d-spacing = ',dspaceM
    ;Print,'Monochrmator:  units = ',dspaceUnits
    ;Print,'Monochrmator:  material = ',monoMaterial
    ;Print,'Monochrmator:  angle = ',mono2theta
    status = Nxclosegroup(handle) ; monochromator
  
    status = Nxopengroup(handle,'analyzer','NXcollection')
    ; Analyzer info
    status = Davenxopengetclosedata(handle,'dspacing',data=dspaceA)
    status = Davenxopengetclosedata(handle,'energy',data=Ef)
    status = Davenxopengetclosedata(handle,'material',data=anaMaterial)
    status = Davenxopengetclosedata(handle,'rotation_angle',data=A6)
    status = Nxclosegroup(handle) ; analyzer
  status = Nxclosegroup(handle) ; instrument
  
  status = Nxopengroup(handle,'sample','NXcollection')     ; Open Sample group
    ; Sample information:
    ;status = Davenxopengetclosedata(handle,'unit_cell_a',data=sampA)
    ;status = Davenxopengetclosedata(handle,'unit_cell_b',data=sampB)
    ;status = Davenxopengetclosedata(handle,'unit_cell_c',data=sampC)
    ;status = Davenxopengetclosedata(handle,'unit_cell_alpha',data=sampAlpha)
    ;status = Davenxopengetclosedata(handle,'unit_cell_beta',data=sampBeta)
    ;status = Davenxopengetclosedata(handle,'unit_cell_gamma',data=sampGamma)
    ;lattice = [sampA,sampB,sampC,sampAlpha,sampBeta,sampGamma]
    ;Print, ' '
    ;Print,'lattice parameters = ',Lattice
    ;status = Davenxopengetclosedata(handle,'orientation',data=sampOrientQuaternion)
    ;status = Davenxopengetclosedata(handle,'rotation_angle',data=A4)
  status = Nxclosegroup(handle)      ; close Sample group

status = Nxclosegroup(handle)     ; NXentry

status = Nxclose(handle)          ; Nexus/hdf file

; Evaluate data so far to ensure it conforms to what we expect
small = 0.1
case Strupcase(type) of
  'A4': begin     ; Only read PSDDiff datasets
    diff = Abs(A4[nDat-1] - A4[0])
    A4isVarying = (diff gt small)? 1 : 0
    if (~A4isVarying) then begin
      msg = ['A4 does not appear to be varying in the calibration file:', filename,'Cannot Proceed...']
      Self->Errormessage, msg, severity=1
      Return, 0
    endif
    dataHash = Self.a4calibdata
    a4mean = Mean(A4)
    Self->Setproperty, A4Value = a4mean
    a4range = Max(a4) - Min(a4)
    if (a4range gt 20) then begin
      msg = 'The A4 scan range for this dataset is large and may contain multiple peaks!'
      msg = [msg,'To process the data, we need to constrain the fitting to a single peak']
      msg = [msg,'This is done by specifying the "A4 Bragg Peak" property so that it is']
      msg = [msg,'approximately correct. It should be close to the value of A4 between pixel 24 and 25']
      msg = [msg,'for the correct calibration peak to be evaluated. Please select and display the']
      msg = [msg,'"PSD Image - A4 Scan" and then zoom in as needed to read off the A4 value.']
      Self->Errormessage, msg, title='Check the "A4 Bragg Peak" property', severity=0
    endif
  end

  'ENERGY': begin     ;
    diff = Abs(E[nDat-1] - E[0])
    EisVarying = (diff gt small)? 1 : 0
    if (~EisVarying) then begin
      msg = ['Energy transfer does not appear to be varying in the calibration file:', filename,'Cannot Proceed...']
      Self->Errormessage, msg, severity=1
      Return, 0
    endif
    dataHash = Self.calibdata
    Self->Setproperty, A6Value = A6[0]
  end
endcase

x = Findgen(nPix) + 1.0
peakInt = Fltarr(nDat)
for i=0,ndat-1 do begin
  ; identify peak intensities and keep rolling sum
  peak_loc = Get_peak_pos(x,Reform(PSDData[i,*]),1,fwhm=fwhm,indices=indices)
  if (indices gt 0 and fwhm gt 0.0) then begin
    peakInt[i] = PSDData[i,indices]
  endif
endfor

dataHash['filename'] = filename

; Determine standard deviation of peak intensities
dataHash['sigmaInt'] = Stddev(peakInt)
dataHash['meanInt'] = Mean(peakInt)

dataHash['nDat'] = nDat[0]
dataHash['nPix'] = nPix[0]
dataHash['Ef'] = (Ef.dim eq 1)? replicate(Ef,nDat) : Ef
dataHash['A4'] = (A4.dim eq 1)? replicate(A4,nDat) : A4
dataHash['A6'] =  (A6.dim eq 1)? replicate(A6,nDat) : A6
dataHash['Data'] = PSDData
dataHash['Etran'] = (E.dim eq 1)? replicate(E,nDat) : E
dataHash['pixel'] = Indgen(nPix[0]) + 1
dataHash['dSpaceM'] = dSpaceM[0]
dataHash['dSpaceA'] = dSpaceA[0]
dataHash['fixedEType'] = fixedEType[0]
dataHash['anaModeFlag'] = Self.anamodeflag

Return, 1B
end


;===============================================================================
; SPINSPSDCalibTool::readData
;
; PURPOSE:
;   Read the contents of a .bt4 file
;
; PARAMETERS:
;   file [in] - filename to be read.
;
;   dataPtr [out] - data structure to read file contents into
;
; KEYWORDS:
;
function SPINSPSDCalibTool::ReadData, file, fromFTP=fromFTP, type=type
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::readData: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        if (ptr_valid(dataPtr)) then heap_free, dataPtr
        if (n_elements(lun) gt 0) then free_lun, lun, /force
        return, 0
    endif
endif

; check parameter count
if (n_params() ne 1) then return, 0

; check file parameter is defined
if (n_elements(file) le 0) then return, 0

filename=file

fromFtp = (stregex(filename,'/pub/ncnrdata/',/fold,/bool))? 1 : 0
if (~fromFTP && ~file_test(filename)) then return, 0

if (keyword_set(fromFTP)) then Self->GetProperty, ftpObject=oFTP

if (Self.instrumentName eq 0) then begin  
  ; if fromFTP, get contents of remote file and save in a local file on disk
  if (fromFTP) then begin
    if (~obj_valid(oFTP)) then begin
      Self->StatusMessage, 'The FTP service object is invalid. Cannot proceed'
      return, 0
    endif
    ; retrieve the file contents from ftp server and save in temporal local file
    tmpFile = !home_dir+path_sep()+'BT7TmpDatasetFromFTP.dat'
    filename=oFTP->GetFileContent(filename,localfilename=tmpFile)
    if (~file_test(filename,/read)) then begin
      Self->StatusMessage, 'Unable to create local file '+tmpFile
      return, 0  ; if local file was not created then bail
    endif
  endif
  
  ; Handle NICE/ICE dataset
  if (H5f_is_hdf5(filename)) then begin
    ; process NICE file
    status = Self->ReadNICEfile(filename, type=type)
  endif else begin
    status = Self->ReadICEFile(filename, type=type)
  endelse
  if (fromFTP && file_test(tmpFile)) then File_delete, tmpFile      ; deflete any tmp file that may have been created
  return, status  
endif else if (Self.instrumentName eq 1) then begin  
  ; 1 == SPINS; Expecting filename to contain SPINS dataset
  if ~Self->isNG5Dataset(filename, errmsg=errmsg, scanType=scanType, oFTP=oFtp) then begin
    Self->StatusMessage, errmsg
    return, 0
  endif
  
  ; Scan type of file being loaded must match that of current Scan Type preference 
  case STRUPCASE(type) of
    'A4': begin     ; Only read I-scan datasets
      if (scanType ne 'I') then begin
        msg = "Expecting an 'I' buffer dataset. Cannot Proceed..."
        Self->ErrorMessage, msg, severity=0
        return, 0      
      endif
    end
    
    'ENERGY': begin     ; Q-Scan
      if (scanType ne 'Q') then begin
        msg = "Expecting an 'Q' buffer dataset. Cannot Proceed..."
        Self->ErrorMessage, msg, severity=0
        return, 0      
      endif
    end
  endcase

  if (keyword_set(fromFTP)) then begin
    Self->GetProperty, ftpObject=oFTP
    
    ; locate a suitable temporal directory
  ;  tmpDir = (!version.OS_FAMILY eq 'Windows')? GETENV('TMP') : GETENV('TMPDIR')
  ;  if (tmpDir eq '') then return, 0
    tmpDir = !home_dir
    ; and copy file from the server into tmpfile on the host
    ; use this tmpfile below to load the data from
    tmpfile = (Self.instrumentName eq '0')? 'BT7ftpData.txt' : 'NG5ftpData.txt'
    tmpfile = tmpDir + path_sep() +  tmpfile
    filename = oFTP->GetFileContent(filename,localfilename=tmpfile)
    if (~file_test(filename,/read)) then return, 0  ; check local file exists and is readable
  endif
  
  ; B/c of unusual error resulting from running out of available logical units
  ; (probably a bug in get_lun); add the following 4 lines to force the use of 
  ; the same first available file unit every time
  lun = 100
  while ((fstat(lun)).open && (lun lt 129)) do begin
    lun++
  endwhile
  
  ; open input file
  openr, lun, filename, error=err ;, /get_lun
  if (err ne 0) then begin
     free_lun, lun, /force
     return, 0
  endif

  ; Read SPINS dataset
  buffer = (scanType eq 'Q')? strarr(13) : strarr(14)
  readf, lun, buffer
  
  if (scanType eq 'Q') then begin
    ;nDat = fix(strmid(buffer[0],65,4))
    ;nDat = fix((strsplit(buffer[0],' ',/extract))[7])
    toks = strsplit(buffer[0],' ',/extract,count=ntoks)
    nDat = fix(toks[ntoks-2])
  
    toks = float(strsplit(buffer[7],' ',/extract, count=ntok))
  
    Ef = toks[2]
    dSpaceM = toks[3]
    dSpaceA = toks[4]
    fixedEType = (stregex(buffer[8],'EM fixed',/fold,/bool))? 'Ei' : 'Ef'
  
    nPix = fix((strsplit(buffer[11],' ',/extract))[2])
    
    colTitles = strsplit(buffer[12],' ',/extract,count=nCol)
    eIndex = (where(colTitles eq 'E',found))[0]
    if (~found) then begin
      Self->StatusMessage, 'Energy transfer column not found'
      return, 0
    endif
    
    E = fltarr(nDat)
  endif else begin
    ;nDat = fix(strmid(buffer[0],65,4))
    ;nDat = fix((strsplit(buffer[0],' ',/extract))[7])
    toks = strsplit(buffer[0],' ',/extract,count=ntoks)
    nDat = fix(toks[ntoks-2])
    ;Ef = float((strsplit(buffer[7],' ',/extract))[2])
    nPix = fix((strsplit(buffer[12],' ',/extract))[2])
  
    colTitles = strsplit(buffer[13],' ',/extract,count=nCol)
    a4Index = (where(colTitles eq 'A4',found))[0]
    if (~found) then begin
      Self->StatusMessage, 'A4 column not found'
      return, 0
    endif
  
    A4 = fltarr(nDat)
  endelse
  
  
  data = fltarr(nDat,nPix)
  buffer1 = fltarr(nCol)
  buffer2 = fltarr(nPix)
  x = findgen(nPix)+1
  i = 0
  
  while not eof(lun) do begin
    readf,lun,buffer1,buffer2
    if (scanType eq 'Q') then  E[i] = buffer1[eIndex] $
      else A4[i] = buffer1[a4Index]
    data[i,*] = buffer2
  
    ; identify peak intensities and keep rolling sum
    peak_loc = get_peak_pos(x,buffer2,1,fwhm=fwhm,indices=indices)
    if (indices gt 0 and fwhm gt 0.0) then begin
      peakInt = (n_elements(peakInt) gt 0)? [peakInt,buffer2[indices]] : buffer2[indices]
    endif
  
    i++
  endwhile
  free_lun,lun,/force
  
  if (scanType eq 'Q') then begin
    dataHash = Self.calibData
    dataHash['filename'] = file
  
    ; Determine standard deviation of peak intensities
    if (n_elements(peakInt) ge 2) then begin
      dataHash['sigmaInt'] = stddev(peakInt)
      dataHash['meanInt'] = mean(peakInt)
    endif
    
    if (i ne nDat) then begin
      E = E[0:i-1]
      data = data[0:i-1,*]
    endif
    
    dataHash['nDat'] = i
    dataHash['nPix'] = nPix
    dataHash['Ef'] = Ef
    dataHash['Data'] = data
    dataHash['Etran'] = E
    dataHash['pixel'] = indgen(nPix) + 1
    dataHash['dSpaceM'] = dSpaceM
    dataHash['dSpaceA'] = dSpaceA
    dataHash['fixedEType'] = fixedEType
  endif
  
  if (scanType eq 'I') then begin
    dataHash = Self.a4CalibData
    dataHash['filename'] = file
  
    ; Determine standard deviation of peak intensities
    if (n_elements(peakInt) ge 2) then begin
      dataHash['sigmaInt'] = stddev(peakInt)
      dataHash['meanInt'] = mean(peakInt)
    endif
    
    if (i ne nDat) then begin
      A4 = A4[0:i-1]
      data = data[0:i-1,*]
    endif
    
    dataHash['nDat'] = i
    dataHash['nPix'] = nPix
    dataHash['Ef'] = Ef
    dataHash['Data'] = data
    dataHash['A4'] = A4
    dataHash['pixel'] = indgen(nPix) + 1
  endif
  dataHash['anaModeFlag'] = Self.anaModeFlag
endif

Self->SetPropertyAttribute,'pixelNumber', valid_range=[1,nPix,1]

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSPSDCalibTool::UpdatePropertySheet
;
; PURPOSE:
;   Update the propertysheet to reflect the current sample type
;
; PARAMETERS:
;
; KEYWORDS:
;    typeCheck - if datasets already loaded use dialog to warn about possibility of samplt type change
;
pro SPINSPSDCalibTool::UpdatePropertySheet, typeCheck=typeCheck
compile_opt idl2

if (Self.plotFlag eq 2 || Self.plotFlag eq 3) then begin
  Self->SetPropertyAttribute,'pixelNumber', hide=0;, valid_range=[1,maxLen,1]
endif else begin
  Self->SetPropertyAttribute,'pixelNumber', hide=1
endelse

; Self.anaModeFlag: 0==Flat;  1==See Through; 2==Fixed Ef;  3==Two Axis
case Self.anaModeFlag of
  0: begin
    Self->SetPropertyAttribute, 'calibFilename', hide=0
    Self->SetPropertyAttribute, 'a4CalibFilename', hide=1
    Self->SetPropertyAttribute, 'A4Value', hide=1
    Self->Setpropertyattribute, 'A4Width', hide=1
    Self->SetPropertyAttribute, 'A6Value', hide=0
  end

  1: begin
    Self->SetPropertyAttribute, 'calibFilename', hide=0
    Self->SetPropertyAttribute, 'a4CalibFilename', hide=1
    Self->SetPropertyAttribute, 'A4Value', hide=1
    Self->Setpropertyattribute, 'A4Width', hide=1
    Self->SetPropertyAttribute, 'A6Value', hide=1
  end

  2: begin
    Self->SetPropertyAttribute, 'calibFilename', hide=0 
    Self->SetPropertyAttribute, 'a4CalibFilename', hide=0
    Self->SetPropertyAttribute, 'A4Value', hide=0
    Self->Setpropertyattribute, 'A4Width', hide=0
    Self->SetPropertyAttribute, 'A6Value', hide=0
  end

  3: begin
    Self->SetPropertyAttribute, 'calibFilename', hide=1
    Self->SetPropertyAttribute, 'a4CalibFilename', hide=0
    Self->SetPropertyAttribute, 'A4Value', hide=0
    Self->Setpropertyattribute, 'A4Width', hide=0
    Self->SetPropertyAttribute, 'A6Value', hide=1
  end

  else:
endcase
oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = WIDGET_INFO(wTLB, /CHILD)
WIDGET_CONTROL, wChild, GET_UVALUE=sPtr
calibDataPresent = Self.calibFilePresent || Self.a4calibFilePresent
widget_control, (*sPtr).wProcess, sensitive=calibDataPresent
widget_control, (*sPtr).wPlot, sensitive=calibDataPresent
widget_control, (*sPtr).wSaveCalib, sensitive=(calibDataPresent && (Self.requireProcessing eq 0))


end
;-------------------------------------------------------------------------------


;;===============================================================================
;;+
;; SPINSPSDCalibTool::PlotRaw
;;
;; PURPOSE:
;;   Generates a line or contour plot of the specified dataset for raw data view
;;
;; PARAMETERS:
;;   oItem   - dataset to be plotted
;;   sPtr    - heap variable containing useful widget related info
;;   overPlotFlag  - is overplotting on (1) or off (0)
;;   lastPltFlag   - if overplotting, is this the last plot to be included
;;
;; KEYWORDS:
;;-
;pro SPINSPSDCalibTool::PlotRaw, oItem, sPtr, overPlotFlag, lastPlotFlag, position=pos
;compile_opt idl2
;
;if (~obj_isa(oItem, 'IDLitParameterSet')) then return
;if (oItem->GetMetaDataCount() eq 0) then return
;
;; Ensure dataset was processed for 'Raw Data' view
;status = oItem->GetMetaData('sampTypeFlag',sTypeFlag) 
;if (sTypeFlag ne 2) then begin
;  stypes = ['Powder','Single Crystal','Raw Data']
;  msg = 'Cannot plot dataset; It is of Sample Type: "'+stypes[sTypeFlag]+'" which does not match current setting!'
;  Self->StatusMessage, msg
;  return
;endif
;
;    ;; Plot the data
;Self->GetProperty, xAxisVar=mode, yAxisVar=xAxisVar, indepVar3List=varList, calibParamsisSet=calibParamsisSet $
;                 , minChan=minChan,maxChan=maxChan,minDPnt=minDPnt,maxDPnt=maxDPnt,dpntIndex=dpntIndex $
;                 , MONSCALEVALUE=monScaleVal, NORMALIZETO=normTo, effNormFlag=effFlag $
;                 , sampTypeFlag=sampTypeFlag, logFlag=logFlag, nSelectedIDs=nSel
;
;status = oItem->GetMetaData('OriginalCounts',counts)
;error = counts
;index = where(error le 0.0,cnt)
;if (cnt gt 0) then error[index] = 1.0
;error = sqrt(error)
;
;if (effFlag) then begin
;   status = oItem->GetMetaData('CHEFF',chEff)
;   counts = temporary(counts)/chEff
;   error = temporary(error)/sqrt(chEff)
;endif
;
;;; Mask bad Pixels
;Self->GetProperty, maskFlag=maskFlag
;sBadChans = Self.maskedDets
;maskedChansExist = ~strcmp(sBadChans,'')
;if (maskFlag && maskedChansExist) then begin
;   status = compactstring2intvector(sBadChans, badChans)
;   badChanIndex = badChans - 1   ; convert Pixel nos to 0-based Pixel index
;   ; Apply mask by simple replacing the counts in the masked Pixels by NaNs
;   ; Leave error variable untouched
;   counts[badChanIndex,*] = !values.F_NAN
;   error[badChanIndex,*] = 0.0
;endif
;
;
;;; Apply monitor normalization
;case normTo of
;   0: begin
;      status = oItem->GetMetaData('MON',mon)
;      monScale = monScaleVal/mon
;   end
;   
;   1: begin
;      if (~isa(time)) then begin    ; may have retrieve time already
;         status = oItem->GetMetaData('TIME',time)
;      endif
;      monScale = monScaleVal/time
;   end
;   
;   else: monScale = monScaleVal
;endcase
;counts = TEMPORARY(counts)*monScale
;error = TEMPORARY(error)*monscale
;
;oZ = oItem->GetByName('Counts')
;oErr = oItem->GetByName('Error')
;
;PSDDims = size(counts,/dimensions)  ; dimension lenghts
;status = oItem->GetMetaData('NPTS',npts)  ; determine nos of datapoints in dataset
;
;
;showSI = ~Self.sharedSettingsFlag && (nSel ge 2)
;if (showSI) then begin
;   status = oItem->GetMetaData('DPNTINDEX', dpntIndex)
;   status = oItem->GetMetaData('MINDPNT', minDPnt)
;   status = oItem->GetMetaData('MAXDPNT', maxDPnt)
;endif
;
;status = oItem->GetMetaData('CHDELA4',chDelA4)
;
;case mode of
;   0: begin    ; Cts vs Pixel
;      ;if (~isa(xAxisVar)) then xAxisVar = 0
;      if (npts gt 1) then begin
;         index = (dpntIndex > 0) < (PSDDims[1] - 1) ; 0 < xAxisVar < npts-1
;         counts = counts[*,index]
;         error = error[*,index]
;      endif else begin
;         ; dataset has a single datapoint, no need to do anything
;         index = 0
;      endelse
;      
;      if (Self.calibParamsIsSet) then begin
;        ; Determine the A4 accross PSD from norminal A4 and delta A4 (= A4o- DelA4)
;        ; and set this to the PSDPixelA4 object before plotting
;        oA4 = oItem->GetByName('A4')
;        status = oA4->GetData(A4o)
;        chA4 = A4o[index] - chDelA4 
;        oX = oItem->GetByName('PSDPixelA4',count=cnt)
;        status = oX->SetData(chA4,/no_copy,/no_notify)
;      endif else begin
;        ; just use the PSD Pixel index
;        oX = oItem->GetByName('PSDPixel',count=cnt)
;      endelse
;      
;      ; If the scan variable was identified from the raw data, then use it in the 
;      ; y-axis label in addition to the datapoint index nos
;      status = oItem->GetMetaData('INDEP_VAR_TAG',indep_var_tag)
;      oIndepVar = oItem->GetByName(indep_var_tag)
;      if (obj_valid(oIndepVar)) then begin
;        status = oIndepVar->GetData(IV_value)
;        status = oIndepVar->GetMetaData('Long_name',IV_name)
;        oZ->AddMetaData,'Long_name','Counts, dPnt='+strtrim(string(index),2)+', '+IV_name+'='+strtrim(string(IV_value[index]),2)
;      endif else begin 
;        oZ->AddMetaData,'Long_name','Counts, dPnt='+strtrim(string(index),2)
;      endelse
;   end
;   
;   1: begin    ; Integrated Cts (data points) vs Pixel
;      if (npts gt 1) then begin
;         ;; dataset has moe than 1 datapoint
;         if (minDPnt gt maxDPnt) then begin
;            Self.maxDPnt = minDPnt
;            Self.minDPnt = maxDPnt
;            minDPnt = Self.minDPnt
;            maxDPnt = Self.maxDPnt
;            ;Self->RefreshPropertySheet
;         endif
;         index =  minDPnt - 1 + indgen(maxDPnt - minDPnt + 1)  ; minDPnt -1 converts pnt nos to index nos
;         nIndex = n_elements(index)
;         if (nIndex gt 1) then begin
;            counts = total(counts[*,index],2,/NAN)   ; integrated along data point from minDPnt to maxDPnt
;            error = sqrt(total(error[*,index]^2,2,/NAN))
;         endif else begin
;            counts = reform(counts[*,index])
;            error = reform(error[*,index])      
;         endelse
;      endif else begin
;         ;; dataset has only 1 datapoint
;         minDPnt = 1
;         maxDPnt = 1
;      endelse
;      
;      oX = oItem->GetByName('PSDPixel',count=cnt)
;      strMinDPnt = strtrim(string(minDPnt),2)
;      strMaxDPnt = strtrim(string(maxDPnt),2)
;      oZ->AddMetaData,'Long_name','$\sum_{dPnt='+strMinDPnt+'}^{'+strMaxDPnt+'}$ Counts'
;   end
;   
;   2: begin    ; Integrated Cts (detector Pixels) vs ScanVariable
;      if (minChan gt maxChan) then begin
;         Self.maxChan = minChan
;         Self.minChan = maxChan
;         minChan = Self.minChan
;         maxChan = Self.maxChan
;         ;Self->RefreshPropertySheet
;      endif
;      index =  minChan - 1 + indgen(maxChan - minChan + 1)  ; minChan -1 converts Pixels to index nos
;      nIndex = n_elements(index)
;      if (nIndex gt 1) then begin
;         counts = total(counts[index,*],1,/NAN)   ; integrated along det Pixel from minChan to maxChan
;         error = sqrt(total(error[index, *]^2,1,/NAN))
;      endif else begin
;         counts = reform(counts[index,*])
;         error = reform(error[index,*])      
;      endelse
;      
;      xvar = varList[xAxisVar]
;      oX = oItem->GetByName(xvar,count=cnt)
;      if (cnt ne 1) then begin
;         oX = oItem->GetByName('Data_Index',count=cnt)
;         msg = ['Scan variable "'+xvar+'" not found!','Switching to "Data_Index"']
;         Self->ErrorMessage, msg, severity=0
;      endif
;      strMinChan = strtrim(string(minChan),2)
;      strMaxChan = strtrim(string(maxChan),2)
;      oZ->AddMetaData,'Long_name','$\sum_{chan='+strMinChan+'}^{'+strMaxChan+'}$ Counts'
;   end
;   
;   else: return
;
;endcase
;
;ctype = partype(counts)
;
;if (ctype ne 'IDLVECTOR') then return  ; can't crate a plot from non-vector data
;
;status = oZ->SetData(counts,/no_copy,/no_notify)
;status = oErr->SetData(error,/no_copy,/no_notify)
;
;oZ->SetProperty, type=ctype
;oX->SetProperty, type=ctype
;oErr->SetProperty, type=ctype
;
;strparms = ['Y','X','Y ERROR','X ERROR','VERTICES','PALETTE','VERTEX_COLORS']
;idparms = [oZ->GetFullIdentifier() $
;          ,oX->GetFullIdentifier() $
;          ,oErr->GetFullIdentifier() $
;          ,'','','','']
;visID = 'PLOT'
;opID = 'Operations/Insert Visualization'
;oRequester = (Self->GetByIdentifier(opID))->GetObjectInstance()
;oRequester->_setTool, Self
;oRequester->GetProperty, show_execution_ui = orig_showUI
;oRequester->SetProperty, show_execution_ui = 0
;
;oItem->GetProperty, name=plotName   ; retrieve the dataset name as shown in the data manager and set it as plotname
;oRequester->SetProperty, name=plotName, parameter_names=strParms, data_ids=idParms, visualization_id=visID
;
;oWin = Self->GetCurrentWindow()
;oView = oWin->GetCurrentView()
;activateManip = 0
;rangeChange = 0
;
;noOverplot = overplotFlag eq 0
;if (Self->HasVisualizations() && noOverplot) then begin
;   ;; store the active manipulator
;   (*sPtr).manipID = (Self->GetCurrentManipulator())->GetFullIdentifier()
;   activateManip = 1
;
;   ;; ensure the existing visualization is selected
;   oLayer = oView->GetCurrentLayer()
;   oWorld = oLayer->GetWorld()
;   oDataSpace = oWorld->GetDataSpaces()
;   oVis = oDataSpace->GetVisualizations(count = nVis)
;    
;   ; retrieve current xrange and yrange to determine if user has zoomed plot
;   oDataSpace->GetProperty, xrange=xr, yrange=yr
;   xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1]) 
;   yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1]) 
;   rangeChange = xChange && yChange
;   
;   delID = 'Operations/Edit/Delete'
;   oDelete = (Self->GetByIdentifier(delID))->GetObjectInstance()
;   
;   oDataSpace->Select
;   void = oDelete->DoAction(Self)
;
;   obj_destroy, [oVis,oDataSpace]
;endif
;
;; create the new vis
;oCmd = oRequester->DoAction(Self)
;
;;; Get the newly created vis
;oLayer = oView->GetCurrentLayer()
;oWorld = oLayer->GetWorld()
;oDataSpace = oWorld->GetDataSpaces()
;oVis = oDataSpace->GetVisualizations(count = nVis)
;
;; TODO - fix vis cuztomization
;; Customize it
;colors = [[0,0,255],[0255,0,0],[0,255,0],[0,255,255],[255,0,255] $
;        ,[128,255,0],[255,128,0],[0,255,128],[128,128,255],[255,128,128] $
;        ,[128,255,128],[128,128,128],[255,255,0]]
;Self->SetProperty, b_color=colors[*,pos], b_sym_color=colors[*,pos], b_use_default_color=1 $
;                 , b_errorbar_color=colors[*,pos], b_sym_fill_color=colors[*,pos]
;Self->CustomizeVis, oVis[nVis-1], plotName, 'BKGDPLOT'
;if (noOverplot) then oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
;
;;; customize axes
;;oAxes = oDataSpace->GetAxes(/container)
;;oAxes->SetProperty,axis_style=2  $    ; draw box axes
;;                  ;,yTitle=ylabel, xTitle=xlabel $
;;                  ,zTitle=zlabel
;                  
;
;if (activateManip) then Self->ActivateManipulator, (*sPtr).manipID
;Self->RefreshCurrentWindow   ;oWin->Draw   ; force window to refresh
;
;
;
;
;end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; SPINSPSDCalibTool::Plot
;
; PURPOSE:
;   Generates a line or contour plot of the quantity specified in the property sheet for the case of a powder sample
;
; PARAMETERS:
;
; KEYWORDS:
;-
pro SPINSPSDCalibTool::Plot
compile_opt idl2

if (~Self.calibFilePresent && ~Self.a4calibFilePresent) then begin
  msg = "Please make sure calibration data is loaded first"
  Self->StatusMessage, msg
  return
endif

Self->DisableUpdates

;oUI = Self->GetUI()
;uiPresent = obj_valid(oUI)
;if (uiPresent) then begin
;   oUI->GetProperty, group_leader = wTLB
;   wChild = widget_info(wTLB, /child)
;   widget_control, wChild, get_uvalue=sPtr
;endif

oSystem = Self->GetSystem()

;oZ = IDLitData(name='Z')
;oZ->SetProperty, /auto_delete
;oErr = IDLitData(name='Err')
;oErr->SetProperty, /auto_delete
;oX = IDLitData(name='X')
;oX->SetProperty, /auto_delete
;oY = IDLitData(name='Y')
;oY->SetProperty, /auto_delete
;
;oSystem->AddByIdentifier, '/Data Manager', oZ
;oSystem->AddByIdentifier, '/Data Manager', oErr
;oSystem->AddByIdentifier, '/Data Manager', oX
;oSystem->AddByIdentifier, '/Data Manager', oY

; create color Palette using IDL color table colors
oTempPalette = IDLgrPalette()
oTempPalette->LoadCT, 13
oTempPalette->GetProperty, red_values=red, green_values=green, blue_values=blue
obj_destroy, oTempPalette
oDataRGB = IDLitDataIDLPalette(transpose([[red],[green],[blue]]),name='RGB Table')

dataHash = Self.calibData
a4dataHash = Self.a4CalibData
examiningFits = 0

switch (Self.plotFlag) of ; View one of 0=Raw Calib, 1=Raw A4Calib, 2=Ef  3=dA4  4=Sens
  0: begin  ; PSD Image for Q-Scan
    data = transpose(dataHash['Data'])
    E = dataHash['Etran']
    pix = dataHash['pixel']


    oZ = IDLitData(name='Z')
    oZ->SetProperty, /auto_delete
    oX = IDLitData(name='X')
    oX->SetProperty, /auto_delete
    oY = IDLitData(name='Y')
    oY->SetProperty, /auto_delete

    oSystem->AddByIdentifier, '/Data Manager', oZ
    oSystem->AddByIdentifier, '/Data Manager', oX
    oSystem->AddByIdentifier, '/Data Manager', oY

    oX->SetProperty, type=parType(pix)
    status = oX->SetData(pix,/no_copy,/no_notify)
    oX->AddMetaData,'Long_name','PSD Pixel Nos'
    oX->AddMetaData,'Units',''
    
    oY->SetProperty, type=parType(E)
    status = oY->SetData(E,/no_copy,/no_notify)
    oY->AddMetaData,'Long_name','Energy Transfer'
    oY->AddMetaData,'Units','meV'

    oZ->SetProperty, type=parType(data)
    status = oZ->SetData(data,/no_copy,/no_notify)
    oZ->AddMetaData,'Long_name','Counts'
    oZ->AddMetaData,'Units',''
    oZ->AddMetaData,'Signal', 1
    
    aspect_ratio = 1.0
    strparms = ['Z','X','Y','PALETTE','RGB_INDICES']
    idparms = [oZ->GetFullIdentifier() $
      ,oX->GetFullIdentifier() $
      ,oY->GetFullIdentifier() $
      ,'' $ ;oDataRGB->GetFullIdentifier() $
      ,'']
    visID = 'CONTOUR'
    break
  end
  
  1: begin      ; PSD Image for I-Scan
    if (~Self.a4calibFilePresent) then begin
      msg = "Please make sure A4 calibration data file is loaded first"
      Self->StatusMessage, msg
      Self->EnableUpdates
      return
    endif

    data = transpose(a4dataHash['Data'])
    E = a4dataHash['A4']
    pix = a4dataHash['pixel']

    oZ = IDLitData(name='Z')
    oZ->SetProperty, /auto_delete
    oX = IDLitData(name='X')
    oX->SetProperty, /auto_delete
    oY = IDLitData(name='Y')
    oY->SetProperty, /auto_delete

    oSystem->AddByIdentifier, '/Data Manager', oZ
    oSystem->AddByIdentifier, '/Data Manager', oX
    oSystem->AddByIdentifier, '/Data Manager', oY

    oX->SetProperty, type=parType(pix)
    status = oX->SetData(pix,/no_copy,/no_notify)
    oX->AddMetaData,'Long_name','PSD Pixel Nos'
    oX->AddMetaData,'Units',''

    oY->SetProperty, type=parType(E)
    status = oY->SetData(E,/no_copy,/no_notify)
    oY->AddMetaData,'Long_name','A4'
    oY->AddMetaData,'Units',''

    oZ->SetProperty, type=parType(data)
    status = oZ->SetData(data,/no_copy,/no_notify)
    oZ->AddMetaData,'Long_name','Counts'
    oZ->AddMetaData,'Units',''
    oZ->AddMetaData,'Signal', 1

    aspect_ratio = 1.0
    strparms = ['Z','X','Y','PALETTE','RGB_INDICES']
    idparms = [oZ->GetFullIdentifier() $
      ,oX->GetFullIdentifier() $
      ,oY->GetFullIdentifier() $
      ,'' $ ;oDataRGB->GetFullIdentifier() $
      ,'']
    visID = 'CONTOUR'
    break
  end

  2: begin  ; Examine fitted Energy at each pixel
    if (~Self.calibFilePresent) then begin
      msg = "Energy calibration file is not loaded"
      Self->StatusMessage, msg
      Self->EnableUpdates
      return
    endif

    if (Self.requireProcessing) then begin
      msg = "Calculation is not up-to-date. Please update calculation with 'Process calibration dataset(s)' button"
      Self->StatusMessage, msg
      Self->EnableUpdates
      return
    endif
    
    examiningFits = 1
    data = dataHash['Data']   ; fltarr(nDat,nPix)
    EfPix = dataHash['EfPix']
    ;EfPixFit = dataHash['EfPixFit']
    pixel = dataHash['pixel']
    fitData = dataHash['fitData']
    pixelIndex = Self.pixelNumber - 1

    E = dataHash['Etran']
    counts = reform(data[*,pixelIndex])
    error = counts
    zeroIndex = where(error le 0.0, zeroCnt)
    if (zerocnt gt 0) then error[zeroIndex] = 1.0
    error = sqrt(error)
    fit = reform(fitData[*,pixelIndex])

    oErr = IDLitData(name='Err')
    oErr->SetProperty, /auto_delete
    oX = IDLitData(name='X')
    oX->SetProperty, /auto_delete
    oY = IDLitData(name='Y')
    oY->SetProperty, /auto_delete

    oSystem->AddByIdentifier, '/Data Manager', oErr
    oSystem->AddByIdentifier, '/Data Manager', oX
    oSystem->AddByIdentifier, '/Data Manager', oY

    oX->SetProperty, type=parType(E)
    status = oX->SetData(E,/no_copy,/no_notify)
    oX->AddMetaData,'Long_name','Energy Transfer'
    oX->AddMetaData,'Units','meV'

    oY->SetProperty, type=parType(counts)
    status = oY->SetData(counts,/no_copy,/no_notify)
    oY->AddMetaData,'Long_name','Channel '+strtrim(string(Self.pixelNumber),2)+'Counts'
    oY->AddMetaData,'Units',''

    oErr->SetProperty, type=parType(error)
    status = oErr->SetData(error,/no_copy,/no_notify)

    aspect_ratio = 1.0

    strparms = ['Y','X','VERTICES','Y ERROR','X ERROR','PALETTE','VERTEX_COLORS']
    idparms = [oY->GetFullIdentifier() $
      ,oX->GetFullIdentifier() $
      ,'' $
      ,oErr->GetFullIdentifier(),'','','']

    visID = 'PLOT'
    plotname = file_basename(Self.calibFilename)
    break
  end

  3: begin  ; Examine fitted a4 at each pixel
    if (~Self.a4calibFilePresent) then begin
      msg = "Please make sure A4 calibration data file is loaded first"
      Self->StatusMessage, msg
      Self->EnableUpdates
      return
    endif

    if (Self.requireProcessing) then begin
      msg = "Calculation is not up-to-date. Please update calculation with 'Process calibration dataset(s)' button"
      Self->StatusMessage, msg
      Self->EnableUpdates
      return
    endif

    examiningFits = 1
    data = a4dataHash['Data']   ; fltarr(nDat,nPix)
    ;EfPix = a4dataHash['EfPix']
    ;EfPixFit = a4dataHash['EfPixFit']
    pixel = a4dataHash['pixel']
    fitData = a4dataHash['fitData']
    pixelIndex = Self.pixelNumber - 1

    a4 = a4dataHash['A4']
    counts = reform(data[*,pixelIndex])
    error = counts
    zeroIndex = where(error le 0.0, zeroCnt)
    if (zerocnt gt 0) then error[zeroIndex] = 1.0
    error = sqrt(error)
    fit = reform(fitData[*,pixelIndex])

    oErr = IDLitData(name='Err')
    oErr->SetProperty, /auto_delete
    oX = IDLitData(name='X')
    oX->SetProperty, /auto_delete
    oY = IDLitData(name='Y')
    oY->SetProperty, /auto_delete

    oSystem->AddByIdentifier, '/Data Manager', oErr
    oSystem->AddByIdentifier, '/Data Manager', oX
    oSystem->AddByIdentifier, '/Data Manager', oY

    oX->SetProperty, type=parType(a4)
    status = oX->SetData(a4,/no_copy,/no_notify)
    oX->AddMetaData,'Long_name','A4'
    oX->AddMetaData,'Units','$\deg$'

    oY->SetProperty, type=parType(counts)
    status = oY->SetData(counts,/no_copy,/no_notify)
    oY->AddMetaData,'Long_name','Channel '+strtrim(string(Self.pixelNumber),2)+' Counts'
    oY->AddMetaData,'Units',''

    oErr->SetProperty, type=parType(error)
    status = oErr->SetData(error,/no_copy,/no_notify)

    aspect_ratio = 1.0

    strparms = ['Y','X','VERTICES','Y ERROR','X ERROR','PALETTE','VERTEX_COLORS']
    idparms = [oY->GetFullIdentifier() $
      ,oX->GetFullIdentifier() $
      ,'' $
      ,oErr->GetFullIdentifier(),'','','']

    visID = 'PLOT'
    plotname = file_basename(Self.a4calibFilename)
    break
  end

  4: begin  ; view Final Energy at each pixel
    if (~Self.calibFilePresent) then begin
      msg = "Energy calibration file is not loaded"
      Self->StatusMessage, msg
      Self->EnableUpdates
      return
    endif

    if (Self.requireProcessing) then begin
      msg = "Calculation is not up-to-date. Please update calculation with 'Process calibration dataset(s)' button"
      Self->StatusMessage, msg
      Self->EnableUpdates
      return
    endif

    pixel = dataHash['pixel']    
    EfPix = (Self.anaModeFlag eq 3)? a4dataHash['EfPix'] : dataHash['EfPix']

    oX = IDLitData(name='X')
    oX->SetProperty, /auto_delete
    oY = IDLitData(name='Y')
    oY->SetProperty, /auto_delete

    oSystem->AddByIdentifier, '/Data Manager', oX
    oSystem->AddByIdentifier, '/Data Manager', oY

    oX->SetProperty, type=parType(pixel)
    status = oX->SetData(pixel,/no_copy,/no_notify)
    oX->AddMetaData,'Long_name','PSD Pixel Nos'
    oX->AddMetaData,'Units',''

    oY->SetProperty, type=parType(EfPix)
    status = oY->SetData(EfPix,/no_copy,/no_notify)
    oY->AddMetaData,'Long_name','Ef'
    oY->AddMetaData,'Units','meV'

    aspect_ratio = 1.0

    strparms = ['Y','X','VERTICES','Y ERROR','X ERROR','PALETTE','VERTEX_COLORS']
    idparms = [oY->GetFullIdentifier() $
      ,oX->GetFullIdentifier() $
      ,'' $
      ,'','','','']

    visID = 'PLOT'
    break
  end
  
  5: begin  ; view Delta A4 at each pixel
    if ((Self.anaModeFlag eq 2 || Self.anaModeFlag eq 3) && ~Self.a4calibFilePresent) then begin
      msg = "Please make sure A4 calibration data file is loaded first"
      Self->StatusMessage, msg
      Self->EnableUpdates
      return
    endif

    if (Self.requireProcessing) then begin
      msg = "Calculation is not up-to-date. Please update calculation with 'Process calibration dataset(s)' button"
      Self->StatusMessage, msg
      Self->EnableUpdates
      return
    endif

    case Self.anaModeFlag of
      0: begin
        deltaA4 = dataHash['DeltaA4_flat']
        pixel = dataHash['pixel']
      end
      
      1: begin
        deltaA4 = dataHash['DeltaA4_seeTro']
        pixel = dataHash['pixel']
      end

      2: begin 
        deltaA4 = a4dataHash['DeltaA4_fixed']
        pixel = a4dataHash['pixel']
      end

      3: begin
        deltaA4 = a4dataHash['DeltaA4_fixed']
        pixel = a4dataHash['pixel']
      end

    endcase

    oX = IDLitData(name='X')
    oX->SetProperty, /auto_delete
    oY = IDLitData(name='Y')
    oY->SetProperty, /auto_delete

    oSystem->AddByIdentifier, '/Data Manager', oX
    oSystem->AddByIdentifier, '/Data Manager', oY

    oX->SetProperty, type=parType(pixel)
    status = oX->SetData(pixel,/no_copy,/no_notify)
    oX->AddMetaData,'Long_name','PSD Pixel Nos'
    oX->AddMetaData,'Units',''

    oY->SetProperty, type=parType(deltaA4)
    status = oY->SetData(deltaA4,/no_copy,/no_notify)
    oY->AddMetaData,'Long_name','$\Delta$A4'
    oY->AddMetaData,'Units','$\deg$'

    aspect_ratio = 1.0

    strparms = ['Y','X','VERTICES','Y ERROR','X ERROR','PALETTE','VERTEX_COLORS']
    idparms = [oY->GetFullIdentifier() $
      ,oX->GetFullIdentifier() $
      ,'' $
      ,'','','','']

    visID = 'PLOT'
    break
  end

  6: begin  ; view Calculated Sensitivity at each pixel
    if (Self.requireProcessing) then begin
      msg = "Calculation is not up-to-date. Please update calculation with 'Process calibration dataset(s)' button"
      Self->StatusMessage, msg
      Self->EnableUpdates
      return
    endif

    sen = (Self.anaModeFlag eq 3)? a4dataHash['sen'] : dataHash['sen']
    pixel = (Self.anaModeFlag eq 3)? a4dataHash['pixel'] : dataHash['pixel']
    plotname = (Self.anaModeFlag eq 3)? file_basename(Self.a4calibFilename) : file_basename(Self.calibFilename)

    Self->GetProperty, MASKTHRESHOLD=maskThreshold
    maxs = max(sen,min=mins)
    range = maxs-mins
    limit = maskThreshold*0.01*range
    
    examiningFits = 1
    fit = pixel*0.0 + limit

    oX = IDLitData(name='X')
    oX->SetProperty, /auto_delete
    oY = IDLitData(name='Y')
    oY->SetProperty, /auto_delete

    oSystem->AddByIdentifier, '/Data Manager', oX
    oSystem->AddByIdentifier, '/Data Manager', oY

    oX->SetProperty, type=parType(pixel)
    status = oX->SetData(pixel,/no_copy,/no_notify)
    oX->AddMetaData,'Long_name','PSD Pixel Nos'
    oX->AddMetaData,'Units',''

    oY->SetProperty, type=parType(sen)
    status = oY->SetData(sen,/no_copy,/no_notify)
    oY->AddMetaData,'Long_name','Sensitivity'
    oY->AddMetaData,'Units',''

    aspect_ratio = 1.0

    strparms = ['Y','X','VERTICES','Y ERROR','X ERROR','PALETTE','VERTEX_COLORS']
    idparms = [oY->GetFullIdentifier() $
      ,oX->GetFullIdentifier() $
      ,'' $
      ,'','','','']

    visID = 'PLOT'
    break
  end

  else:

endswitch

opID = 'Operations/Insert Visualization'
oRequester = (Self->GetByIdentifier(opID))->GetObjectInstance()
oRequester->_setTool, Self
oRequester->GetProperty, show_execution_ui = orig_showUI
oRequester->SetProperty, show_execution_ui = 0

oRequester->SetProperty, parameter_names=strParms, data_ids=idParms, visualization_id=visID

oWin = Self->GetCurrentWindow()
oView = oWin->GetCurrentView()
activateManip = 0
rangeChange = 0

overplotFlag = 0
noOverplot = overplotFlag eq 0
if (Self->HasVisualizations() && noOverplot) then begin
   ;; store the active manipulator
   Self.manipID = (Self->GetCurrentManipulator())->GetFullIdentifier()
   activateManip = 1

   ;; ensure the existing visualization is selected
   oLayer = oView->GetCurrentLayer()
   oWorld = oLayer->GetWorld()
   oDataSpace = oWorld->GetDataSpaces()
   oVis = oDataSpace->GetVisualizations(count = nVis)
    
;   ; retrieve current xrange and yrange to determine if user has zoomed plot
;   oDataSpace->GetProperty, xrange=xr, yrange=yr
;   xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1]) 
;   yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1]) 
;   rangeChange = xChange && yChange
   
   delID = 'Operations/Edit/Delete'
   oDelete = (Self->GetByIdentifier(delID))->GetObjectInstance()
   
   oDataSpace->Select
   void = oDelete->DoAction(Self) ; delete selected vis

   obj_destroy, [oVis,oDataSpace]
   
   ; delete any residual annotations that may have been added
   annID = oView->FindIdentifiers('*ANNOTATION LAYER*',count=nAnn)
   if (nAnn gt 2) then begin
     oVoid = []
     for i=2, nAnn-1 do begin
       oTmp = Self->GetByIdentifier(annID[i])
       oTmp->Select
       oVoid = [oVoid,oTmp]
     endfor
     void = oDelete->DoAction(Self) ; delete selected anootations
     obj_destroy, oVoid
   endif
endif

; create the new vis
oCmd = oRequester->DoAction(Self)

; add an overplot if plotFlag = 2,3,6
if (examiningFits) then begin
  ; add a line plot of the fit to the existing data plot
  oYLine = obj_new('IDLitData',fit,name='Fit',type=partype(fit))
  oYLine->SetProperty, /auto_delete
  oSystem->AddByIdentifier, '/Data Manager', oYLine

  idparms = [oYLine->GetFullIdentifier() $
    ,oX->GetFullIdentifier() $
    ,'','','','','']

  oRequester->SetProperty,parameter_names=strParms,data_ids=idParms,visualization_id=visID
  oVoid = oRequester->DoAction(Self)
endif

;; Get the newly created vis
oLayer = oView->GetCurrentLayer()
oWorld = oLayer->GetWorld()
oDataSpace = oWorld->GetDataSpaces()
oVis = oDataSpace->GetVisualizations(count = nVis)

; Customize it
;colors = [[0,0,255],[255,0,0],[0,255,0],[0,255,255],[255,0,255] $
;  ,[128,255,0],[255,128,0],[0,255,128],[128,128,255],[255,128,128] $
;  ,[128,255,128],[128,128,128],[255,255,0]]

switch (Self.plotFlag) of ; View one of 0=Raw Calib, 1=Raw A4Calib, 2=Ef  3=dA4  4=Sens
  0: 
  1: begin
    oVis[nVis-1]->SetProperty, /fill $
      ,aspect_ratio=aspect_ratio $
      ,transparency = 5 $
      ,n_levels=15 $
      ,pal_color=1  ; => use palette for level colors
    status = oVis[nVis-1]->SetData(oDataRGB, parameter_name='PALETTE',/by_value)
    ; customize axes
    oAxes = oDataSpace->GetAxes(/container)
    oAxes->SetProperty,axis_style=2  ;$    ; draw box axes
      ;,yTitle=ylabel, xTitle=xlabel $
      ;,zTitle=zlabel

    break
  end
  
  2: 
  3: begin  ; customize a plot and an overplot
    fitName = 'Fit'
    Self->CustomizeVis, oVis[nVis-2], plotname, 'SAMPPLOT'
    Self->CustomizeVis, oVis[nVis-1], fitName, 'BKGDPLOT'
    oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
    break
  end
  
  6: begin  ; customize a plot and an overplot
    fitName = 'Mask Threshold'
    Self->CustomizeVis, oVis[nVis-2], plotname, 'SAMPPLOT'
    Self->CustomizeVis, oVis[nVis-1], fitName, 'BKGDPLOT', /fill
    oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
    break
  end

  
  else: begin
    Self->CustomizeVis, oVis[nVis-1], file_basename(Self.a4CalibFilename), 'SAMPPLOT'
    oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
    break
  end
endswitch
                  

if (activateManip) then Self->ActivateManipulator, Self.manipID
Self->RefreshCurrentWindow   ;oWin->Draw   ; force window to refresh

Self->EnableUpdates

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSPSDCalibTool::saveAsASCII
;
; PURPOSE:
;   Save output to file using DAVE format
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSPSDCalibTool::CalibParamsFile
  return, Self->SaveCalibParameters()
end

function SPINSPSDCalibTool::SaveCalibParameters
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

if (~Self.calibFilePresent && Self.anaModeFlag ne 3) then begin
  msg = "Please load Calibration data first"
  Self.StatusMessage, msg
  return, 0
endif

if (Self.requireProcessing) then begin
  msg = "Calculation requires updating! Please use the 'Process calibration dataset(s)' button"
  Self.StatusMessage, msg
  return, 0
endif

if ((Self.anaModeFlag eq 2 || Self.anaModeFlag eq 3) && ~Self.a4CalibFilePresent) then begin
  msg = "Please load A4 Calibration data first"
  Self.StatusMessage, msg
  return, 0  
endif

dataHash = Self.calibData
a4dataHash = Self.a4CalibData

anaMF = dataHash.HasKey('anaModeFlag')? dataHash['anaModeFlag'] : -1
a4anaMF = a4dataHash.HasKey('anaModeFlag')? a4dataHash['anaModeFlag'] : -1
; Ensure calculation is up to date for the selected mode
case Self.anaModeFlag of
  2: sameMode = strcmp(anaMF,Self.anaModeFlag) && strcmp(a4anaMF,Self.anaModeFlag)
  3: sameMode = strcmp(a4anaMF,Self.anaModeFlag)
  else: sameMode = strcmp(anaMF,Self.anaModeFlag)
endcase
if (~sameMode) then begin
  msg = 'Calculation requires updating.'
  msg = [msg,"The 'Analyzer Mode' setting has changed after calibration data was loaded."]
  msg = [msg,"Either return to the previous 'Analyzer Mode' setting or load another calibration data."]
  Self->ErrorMessage, msg, severity=0
  return, 0
endif

calibMode = ['Flat','SeeThrough','FixedEf','2Axis']
case Self.anaModeFlag of
  2: extra = '_'+calibMode[Self.anaModeFlag]+'_E_A4'
  3: extra = '_'+calibMode[Self.anaModeFlag]+'_A4'
  else: extra = '_'+calibMode[Self.anaModeFlag]+'_E'
endcase


ext = (Self.instrumentName eq 0)? '.bt7' : '.ng5'
basename = (Self.anaModeFlag eq 3)? file_basename(a4dataHash['filename'],ext) : file_basename(dataHash['filename'],ext)
infile = basename + extra + '_calib.txt'

Self->GetProperty, working_directory=workDir
title = "Specify filename to store calibration parameters"
ext = 'txt'
filename = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
                       ,/overwrite_prompt, file=infile, path=workDir, get_path=new_workDir)
                          
if (filename eq '') then return, 0

if (Self.anaModeFlag lt 3) then begin
  npix =  dataHash['nPix']
  EfPix = dataHash['EfPix']
  sen =   dataHash['sen']
  case Self.anaModeFlag of
    0: deltaA4 = dataHash['DeltaA4_flat']
    1: deltaA4 = dataHash['DeltaA4_seeTro']
    2: deltaA4 = a4dataHash['DeltaA4_fixed']
  endcase
endif else begin
  npix =    a4dataHash['nPix']
  EfPix =   a4dataHash['EfPix']
  deltaA4 = a4dataHash['DeltaA4_fixed']
  sen =     a4dataHash['sen']
endelse
midIndex = fix((nPix-1)/2)
;npix = dataHash['nPix']
;EfPix = dataHash['EfPix']
;sen = dataHash['sen']
;
;case Self.anaModeFlag of
;  0: deltaA4 = dataHash['DeltaA4_flat']
;  1: deltaA4 = dataHash['DeltaA4_seeTro']
;  2: deltaA4 = a4dataHash['DeltaA4_fixed']
;  3: begin
;    
;  end
;endcase


openw,lun,filename,/get_lun

if (Self.instrumentName eq 1) then begin
  if (Self.anaModeFlag eq 3) then begin
    msg = a4dataHash['filename']
  endif else begin
    msg = (Self.anaModeFlag eq 2 && Self.a4CalibFilePresent)? dataHash['filename']+' and '+a4dataHash['filename'] : $
      dataHash['filename']    
  endelse
  printf,lun, '#SPINS PSD Calibration based on: '+msg
  printf,lun, '#Created on: '+systime()+';   Calibration Mode: '+calibMode[Self.anaModeFlag]
  printf,lun, '#number of Pixels'
  printf,lun, '#Ef block - final energy for each pixel in meV'
  printf,lun, '#Efficiency block - effieciency divisor for each pixel'
  printf,lun, '#Pixels to be masked: '+Self.maskedPixels
  printf,lun, '#Delta A4 block - A4 delta (relative to central pixel) for each pixel in degrees'
  printf,lun,nPix
  printf,lun,efpix,format='(8G10.4)'
  printf,lun,sen,format='(8G10.4)'
  printf,lun,deltaA4,format='(8G10.4)'  
endif else begin  
  if (Self.anaModeFlag eq 3) then begin
    msg = a4dataHash['filename']
  endif else begin
    msg = (Self.anaModeFlag eq 2 && Self.a4CalibFilePresent)? dataHash['filename']+' and '+a4dataHash['filename'] : $
      dataHash['filename']    
  endelse
  if (Self.anaModeFlag eq 3) then Ef0 = 0.0 else $
    Ef0 = (Self.A6Value ne 0.0)? Self.ekFac * (2*!pi/(2*dataHash['dSpaceA']*sin(0.5*(Self.A6Value)*!dtor)))^2 : 0.0
  printf,lun, '#BT7 PSD Calibration based on: '+msg
  printf,lun, '#Created on: '+systime()+';   Calibration Mode: '+calibMode[Self.anaModeFlag] $
              +';    Central Channel Ef = '+strtrim(string(Ef0,format='(F5.2)'),2)+' meV'
  printf,lun, '#Channels to be masked: '+Self.maskedPixels
  printf,lun, '#Efficiency DeltaA4(degrees) DeltaEf(meV)
  for i=0,nPix-1 do printf,lun,sen[i], deltaA4[i], Efpix[i] - Ef0,format='(8G10.4)'  ; for BT7 delta Efpix is saved instead of Efpix as for SPINS
  ;for i=0,nPix-1 do printf,lun,sen[i], deltaA4[i], Efpix[i] - Efpix[midIndex],format='(8G10.4)'  ; for BT7 delta Efpix is saved instead of Efpix as for SPINS
endelse

free_lun, lun,/force

if (file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir

msg = 'Output stored in: '+filename
Self->StatusMessage, msg

return, 1
end


;;===============================================================================
;; SPINSPSDCalibTool::saveAsDave
;;
;; PURPOSE:
;;   Save output to file using DAVE format
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;
;function SPINSPSDCalibTool::SaveAsDave
;compile_opt idl2
;
;oUI = Self->GetUI()
;oUI->GetProperty, group_leader = wTLB
;
;
;if (~Self->ExportSelection(davePtr, nameTag=nametag, /useTexlabels,/dave)) then return, 0
;if (ptr_valid(davePtr)) then begin
;
;   Self->GetProperty, working_directory=workDir
;   title = "Specify filename to store DAVE format data"
;   ext = 'dave'
;   filename = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
;                          ,/overwrite_prompt, file=nameTag+'.dave',path=workDir, get_path=new_workDir)
;                          
;   if (~strcmp(filename,'')) then begin
;      save, davePtr, filename=filename
;      if (file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir
;   
;      msg = 'Output stored in: '+filename
;      Self->StatusMessage, msg
;   endif
;   
;   heap_free, davePtr
;endif
;
;return, 1
;end


;;===============================================================================
;; SPINSPSDCalibTool::exportToDaveDM
;;
;; PURPOSE:
;;   export dataset to DAVE Data Manager
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;
;function SPINSPSDCalibTool::exportToDaveDM
;compile_opt idl2
;
;; Basic error Handler
;if (n_elements(!debug) && (!debug eq 0)) then begin
;    catch, catchError
;    if (catchError ne 0) then begin
;        Self->StatusMessage, !ERROR_STATE.msg
;        catch, /cancel
;        return, 0
;    endif
;endif
;
;;oUI = Self->GetUI()
;;oUI->GetProperty, group_leader = wTLB
;;
;;; display dialog to let user select variables to be exported to Mslice 
;;Self->GetProperty, selectedIDs=selIDs,nSelectedIDs=nSel, xAxisVar=xAxisVar, indepVar2List=varList
;;if (nSel eq 0) then begin
;;   Self->StatusMessage, 'No dataset selected!'
;;   return, 0  ; exit if no dataset is currently selected
;;endif
;;xvar = varList[xAxisVar]
;;
;;for i=0,nSel - 1 do begin
;;   oData = Self->GetByIdentifier(selIDs[i])
;;   status = oData->GetMetaData('sampTypeFlag',sTypeFlag) ; only export powder data to Mslice
;;   if (sTypeFlag ne 0) then continue
;;      
;;   if (~Self->retrieveDavePtr(oData, xVar, davePtr, /useTexlabels)) then continue
;;
;;   oData->GetProperty, name=nameTag
;;   if ((n_elements(nameTag) le 0) || (strtrim(nameTag,2) eq '')) then nameTag='Untitled'
;;   
;;   ; Send data to DAVE Data Manager Folder
;;   Self.DAVETool->AddDavePtrToDataManager, davePtr, nameTag
;;   
;;   msg = "New extry '"+nameTag+"' created in DAVE Data Manager"
;;   Self->StatusMessage, msg
;;   
;;   if (ptr_valid(dataPtr)) then  heap_free, davePtr
;;endfor
;
;if (~Self->ExportSelection(davePtr, nameTag=nametag, /useTexlabels, /dave)) then return, 0
;
;if (ptr_valid(davePtr)) then begin
;   if ((n_elements(nameTag) le 0) || (strtrim(nameTag,2) eq '')) then nameTag='Untitled'
;      
;   ; Send data to DAVE Data Manager Folder
;   Self.DAVETool->AddDavePtrToDataManager, davePtr, nameTag
;   
;   msg = "New extry '"+nameTag+"' created in DAVE Data Manager"
;   Self->StatusMessage, msg
;
;   heap_free, davePtr
;endif
;
;return, 1
;end




;;===============================================================================
;; SPINSPSDCalibTool::exportToPAN
;;
;; PURPOSE:
;;   export dataset to DAVE Data Manager
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;
;function SPINSPSDCalibTool::ExportSelection, davePtr, nameTag=nameTag, useTexLabels=useTexLabels $
;                                    ,dave=dave, ascii=ascii
;compile_opt idl2
;
;; Basic error Handler
;if (n_elements(!debug) && (!debug eq 0)) then begin
;    catch, catchError
;    if (catchError ne 0) then begin
;        Self->StatusMessage, !ERROR_STATE.msg
;        catch, /cancel
;        return, 0
;    endif
;endif
;
;; Check the sample type flag setting
;Self->GetProperty, sampTypeFlag=sampTypeFlag
;if (sampTypeFlag eq 1) then begin
;   Self->StatusMessage, 'Cannot export single crystal data to ASCII or DAVE data Format!'
;   return, 0 ; can only export powder sample (type=0) or raw (type=2) data
;endif
;
;; determine the independent variable required
;if (sampTypeFlag eq 0) then begin
;   ; expect powder sample data
;   Self->GetProperty, selectedIDs=selIDs,nSelectedIDs=nSel, xAxisVar=xAxisVar, indepVar2List=varList
;   xvar = varList[xAxisVar]
;endif else begin
;   ; raw data
;   Self->GetProperty, xAxisVar=mode, yAxisVar=xAxisVar, indepVar3List=varList, nSelectedIDs=nSel, selectedIDs=selIDs
;   ;if ((mode eq 0) || (mode eq 1)) then xvar = 'PSDPixel' ; Cts vs Pixel || Integrated Cts (data points) vs Pixel
;   if (mode eq 0) then xvar = 'PSDPixelA4' ; Cts vs Pixel
;   if (mode eq 1) then xvar = 'PSDPixel' ; Integrated Cts (data points) vs Pixel
;   if (mode eq 2) then xvar = varList[xAxisVar] ; Integrated Cts (detector Pixels) vs ScanVariable
;endelse
;
;; Are there any datasets selected?
;if (nSel eq 0) then begin
;   Self->StatusMessage, 'No dataset selected!'
;   return, 0  ; exit if no dataset is currently selected
;endif
;
;; Retrieve the selected datasets
;oData = []
;for i=0,nSel - 1 do begin
;   oTmp = Self->GetByIdentifier(selIDs[i])
;   status = oTmp->GetMetaData('sampTypeFlag',sTypeFlag)
;   if (sTypeFlag ne sampTypeFlag) then continue ; dataset's sample type flag must match current that of the app preference
;   oData = [oData,oTmp]
;endfor
;nSel = n_elements(oData)
;if (nSel eq 0) then begin
;   Self->StatusMessage, 'No valid dataset selected!'
;   return, 0  ; exit if no dataset is currently selected
;endif
;
;; Convert selected datasets to ASCII or davePtr structure as necessary 
;if (~obj_valid(oData[0])) then return, 0
;if (~Self->retrieveDavePtr(oData, xVar, davePtr, sampTypeFlag=sampTypeFlag, mode=mode, useTexLabels=useTexLabels, ascii=ascii, dave=dave)) then return, 0
;
;oData[0]->GetProperty, name = nameTag
;
;return, 1
;
;end


;;===============================================================================
;; SPINSPSDCalibTool::exportToPAN
;;
;; PURPOSE:
;;   export dataset to DAVE Data Manager
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;
;function SPINSPSDCalibTool::ExportToPAN
;compile_opt idl2
;
;; Basic error Handler
;if (n_elements(!debug) && (!debug eq 0)) then begin
;    catch, catchError
;    if (catchError ne 0) then begin
;        Self->StatusMessage, !ERROR_STATE.msg
;        catch, /cancel
;        return, 0
;    endif
;endif
;
;oUI = Self->GetUI()
;oUI->GetProperty, group_leader = wTLB
;notifyIDs = [wTLB,wTLB]
;Self->GetProperty, working_directory=workDir, data_directory=dataDir
;
;;status = Self->ExportSelectionToDavePtr(davePtr)
;if (~Self->ExportSelection(davePtr, nameTag=nametag, /useTexlabels, /dave)) then return, 0
;
;if (ptr_valid(davePtr)) then  begin
;   oVoid = obj_new('OPAN',notifyID=[wTLB,wTLB],group_leader=wTLB $
;                ,davePtr=davePtr,workDir=workDir,daveTool=Self.DAVETool,dataDir=dataDir)
;
;   heap_free, davePtr
;endif
;
;return, 1
;end


;===============================================================================
; SPINSPSDCalibTool::saveProperties
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSPSDCalibTool::SaveProperties
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::saveProperties: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

print, 'properties saved...'

return, 1
end


;;===============================================================================
;; SPINSPSDCalibTool::RetrieveDavePtr
;;
;; PURPOSE:
;;   create a davePtr structure from the data in the specified dataset object
;;
;; PARAMETERS:
;;
;; KEYWORDS:
;;
;function SPINSPSDCalibTool::RetrieveDavePtr, oData, xVar, davePtr, sampTypeFlag=sampTypeFlag, mode=mode, useTexLabels=useTexLabels $
;                                     ,dave=dave, ascii=ascii
;compile_opt idl2
;
;; Basic error Handler
;if (n_elements(!debug) && (!debug eq 0)) then begin
;    catch, catchError
;    if (catchError ne 0) then begin
;        Self->StatusMessage, !ERROR_STATE.msg
;        catch, /cancel
;        if (ptr_valid(davePtr)) then heap_free, davePtr
;        return, 0
;    endif
;endif
;
;if (~obj_valid(oData[0])) then return, 0
;if (xVar eq '') then return, 0
;
;davePtr = ptr_new()
;
;if (keyword_set(dave) && (sampTypeFlag eq 2) && (mode eq 0)) then begin
;  ;; if rawmode and Cts vs Pixel handle slightly differenly
;  ;; - export 2D data
;  ;; - dim 1 is the PSD Pixels in 2theta or index nos
;  ;; - dim 2 is the scan variable or data point nos 
;
;  Self->GetProperty, calibParamsisSet=calibParamsisSet, maskFlag=maskFlag $
;                 , MONSCALEVALUE=monScaleVal, effNormFlag=effFlag,dpntIndex=dpntIndex
;
;  moreThanOne = 0
;  for i = 0, n_elements(oData)-1 do begin
;    if (~obj_valid(oData[0])) then continue
;    
;    status = oData[i]->GetMetaData('CHDELA4',chDelA4)
;    
;    ; Dim 1
;    if (calibParamsisSet) then begin
;      ; Determine the A4 accross PSD from norminal A4 and delta A4 (= A4o- DelA4)
;      ; and set this to the PSDPixelA4 object before plotting
;      oA4 = oData[i]->GetByName('A4')
;      status = oA4->GetData(A4o)
;      index = (dpntIndex > 0) < (n_elements(A4o) - 1) ; 0 < xAxisVar < npts-1    
;      xvals = A4o[index] - chDelA4
;      oX = oData[i]->GetByName('PSDPixelA4')
;    endif else begin
;      ; just use the PSD Pixel index
;      oX = oData[i]->GetByName('PSDPixel')
;      status = oX->GetData(xvals)
;    endelse
;  
;    ; Dim 2
;    ; If the scan variable was identified from the raw data, then use it as 2nd dim
;    ; else use the data point indices
;    if (moreThanOne eq 0) then begin
;      status = oData[i]->GetMetaData('INDEP_VAR_TAG',indep_var_tag)
;      oY = oData[i]->GetByName(indep_var_tag)
;      if (~obj_valid(oY)) then begin 
;         indep_var_tag = 'Data_Index'
;         oY = oData[i]->GetByName(indep_var_tag)
;      endif
;      if (~obj_valid(oY)) then continue 
;      status = oY->GetData(yvals)
;    endif else begin
;      ; retrieve the same scan var from subsequent datasets
;      oY = oData[i]->GetByName(indep_var_tag)
;      if (~obj_valid(oY)) then continue 
;      status = oY->GetData(yvals)
;    endelse
;  
;    ; Intensity
;    status = oData[i]->GetMetaData('OriginalCounts',counts)
;    error = counts
;    index = where(error le 0.0,cnt)
;    if (cnt gt 0) then error[index] = 1.0
;    error = sqrt(error)
;  
;  
;    ; efficiency correction
;    if (effFlag) then begin
;       status = oData[i]->GetMetaData('CHEFF',chEff)
;       counts = temporary(counts)/chEff
;       error = temporary(error)/sqrt(chEff)
;    endif
;    
;    ;; Mask bad Pixels
;    sBadChans = Self.maskedDets
;    maskedChansExist = ~strcmp(sBadChans,'')
;    if (maskFlag && maskedChansExist) then begin
;       status = compactstring2intvector(sBadChans, badChans)
;       badChanIndex = badChans - 1   ; convert Pixel nos to 0-based Pixel index
;       ; Apply mask by simple replacing the counts in the masked Pixels by NaNs
;       ; Leave error variable untouched
;       counts[badChanIndex,*] = !values.F_NAN
;       error[badChanIndex,*] = 0.0
;    endif
;    
;    
;    ;; Apply monitor normalization
;;    case normTo of
;;       0: begin
;;          status = oData[i]->GetMetaData('MON',mon)
;;          monScale = monScaleVal/mon
;;       end
;;       
;;       1: begin
;;          if (~isa(time)) then begin    ; may have retrieve time already
;;             status = oData[i]->GetMetaData('TIME',time)
;;          endif
;;          monScale = monScaleVal/time
;;       end
;;       
;;       else: monScale = monScaleVal
;;    endcase
;;    counts = TEMPORARY(counts)*monScale
;;    error = TEMPORARY(error)*monscale
;    
;    if (moreThanOne gt 0) then begin
;      aggY = [aggY, yvals]
;      if (n_elements(yvals) eq 1) then begin
;        ; ==> counts and error are vectors of length n so reform to an nx1
;        ; array so aggregation statements can work
;        counts = reform(counts,n_elements(counts),1)
;        error = reform(error,n_elements(error),1)
;      endif
;      aggCnts = transpose([transpose(aggCnts),transpose(counts)])
;      aggErr = transpose([transpose(aggErr),transpose(error)])
;    endif else begin
;      aggY = yvals
;      aggCnts = counts
;      aggErr = error   
;    endelse
;    
;    moreThanOne++
;
;    if (i eq 0) then begin
;      xLabel = ''
;      if (oX->GetMetaData('LONG_NAME',label)) then xLabel += label
;      xUnits = ''
;      if (oX->GetMetaData('UNITS',units)) then xUnits += units
;      yLabel = ''
;      if (oY->GetMetaData('LONG_NAME',label)) then yLabel += label
;      yUnits = ''
;      if (oY->GetMetaData('UNITS',units)) then yUnits += units
;      zLabel = 'Counts'
;    endif
;  endfor
;
;  counts = aggCnts
;  error = aggErr
;  yvals = aggY
;  
;  ; sort in increasing yvals
;  if (n_elements(yvals) gt 1) then begin
;    yindex = sort(yvals)
;    yvals = yvals[yindex]
;    counts = counts[*,yindex]
;    error = error[*,yindex]
;    Self->MergeDupGroups, yvals, counts, error, tolerance=0.001
;  endif
;  
;  status = oData[0]->GetMetaData('DATAPTRREF',dataPtr)
;
;  status = create_dave_pointer(davePtr, qty=counts, xvals=xvals, yvals=yvals, err=error)
;  if (~status) then begin
;     msg = "Unable to allocate memory!"
;     Self->StatusMessage, msg
;     if (ptr_valid(davePtr)) then heap_free, davePtr
;     return, 0
;  endif
;      
;  (*(*davePtr).dataStrPtr).commonStr.instrument = 'SPINS'
;  (*(*davePtr).dataStrPtr).commonStr.xlabel = xLabel
;  (*(*davePtr).dataStrPtr).commonStr.xunits = xunits
;  (*(*davePtr).dataStrPtr).commonStr.xtype = 'points'
;  (*(*davePtr).dataStrPtr).commonStr.ylabel = yLabel
;  (*(*davePtr).dataStrPtr).commonStr.yunits = yunits
;  (*(*davePtr).dataStrPtr).commonStr.ytype = 'points'
;   
;  (*(*davePtr).dataStrPtr).commonStr.histlabel = zLabel
;  (*(*davePtr).dataStrPtr).commonStr.histunits = ''
;  (*(*(*davePtr).dataStrPtr).commonStr.treatmentPtr) = ''
;   
;  if (ptr_valid(dataPtr)) then begin
;     specificStr = { $
;                 filename:(*dataPtr).filename, $
;                 monitor:(*dataPtr).monave, $
;                 orientation:(*(*dataPtr).orientation_ptr), $
;                 latticeParams:(*(*dataPtr).lattice_ptr), $
;                 monDSpace:(*dataPtr).dspacem, $
;                 anaDSpace:(*dataPtr).dspacea, $
;                 pan_filler:!VALUES.F_NAN, $
;                 pan_mask:ptr_new(bits2bytes(finite(counts))) $
;                }
;      
;     (*(*davePtr).dataStrPtr).specificPtr = ptr_new(specificStr)
;  endif
;  
;  ; davePtr is fully defined so exit now
;  return, 1
;endif
;
;n = n_elements(oData)
;xvals = []
;yvals = []
;evals = []
;for i = 0,n-1 do begin
;   oX = oData[i]->GetByName(xVar)
;   status = oX->GetData(x1)
;   oZ = oData[i]->GetByName('Counts')
;   status = oZ->GetData(y1)
;   oErr = oData[i]->GetByName('Error')
;   status = oErr->GetData(e1)
;   xvals = [xvals,x1]
;   yvals = [yvals,y1]
;   evals = [evals,e1]
;endfor
;
;index = sort(xvals)
;xvals = xvals[index]
;yvals = yvals[index]
;evals = evals[index]
;
;xLabel = ''
;if (oX->GetMetaData('LONG_NAME',label)) then xLabel += label
;xUnits = ''
;if (oX->GetMetaData('UNITS',units)) then xUnits += units
;yLabel = 'Counts'
;
;if (~keyword_set(useTexLabels)) then begin
;   xLabel = tex2idl(xLabel)
;   xUnits = tex2idl(xunits)
;   yLabel = tex2idl(yLabel)
;endif
;
;; convert to ASCII struct if required
;if (keyword_set(ascii)) then begin
;   struct = {xvals:xvals,yvals:yvals,evals:evals,xlabel:xlabel,xunits:xunits,ylabel:ylabel}
;   davePtr = ptr_new(struct)
;endif
;
;; convert to davePtr struct if required
;if (keyword_set(dave)) then begin
;   status = oData[0]->GetMetaData('DATAPTRREF',dataPtr)
;
;   status = create_dave_pointer(davePtr, qty=yvals, xvals=xvals, err=evals)
;   if (~status) then begin
;      msg = "Unable to allocate memory!"
;      Self->StatusMessage, msg
;      if (ptr_valid(davePtr)) then heap_free, davePtr
;      return, 0
;   endif
;      
;   (*(*davePtr).dataStrPtr).commonStr.instrument = 'SPINS'
;   (*(*davePtr).dataStrPtr).commonStr.xlabel = xLabel
;   (*(*davePtr).dataStrPtr).commonStr.xunits = xunits
;   (*(*davePtr).dataStrPtr).commonStr.xtype = 'points'
;   (*(*davePtr).dataStrPtr).commonStr.ylabel = ''
;   (*(*davePtr).dataStrPtr).commonStr.yunits = ''
;   (*(*davePtr).dataStrPtr).commonStr.ytype = 'points'
;   
;   (*(*davePtr).dataStrPtr).commonStr.histlabel = yLabel
;   (*(*davePtr).dataStrPtr).commonStr.histunits = ''
;   (*(*(*davePtr).dataStrPtr).commonStr.treatmentPtr) = ''
;   
;   if (ptr_valid(dataPtr)) then begin
;      specificStr = { $
;                  filename:(*dataPtr).filename, $
;                  monitor:(*dataPtr).monave, $
;                  orientation:(*(*dataPtr).orientation_ptr), $
;                  latticeParams:(*(*dataPtr).lattice_ptr), $
;                  monDSpace:(*dataPtr).dspacem, $
;                  anaDSpace:(*dataPtr).dspacea, $
;                  pan_filler:!VALUES.F_NAN, $
;                  pan_mask:ptr_new(bits2bytes(finite(yvals))) $
;                 }
;      
;      (*(*davePtr).dataStrPtr).specificPtr = ptr_new(specificStr)
;   endif
;endif
;
;return, 1
;end


;===============================================================================
;+
; SPINSPSDCalibTool::WriteProjectAs
;
; PURPOSE:
;   save project (data plus state) to file
;
; PARAMETERS:
;
; KEYWORDS:
;-
function SPINSPSDCalibTool::WriteProjectAs
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::writeProjectAs: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

Self->GetProperty, working_directory=workDir
if (~Self.calibFilePresent && ~Self.a4CalibFilePresent) then begin
   msg = 'Nothing to save! There is no calibration data loaded in current session.'
   Self->StatusMessage, msg
   Self->ErrorMessage, msg, severity=0, title='Save Unnecessary!'
   return, 0
endif

dataHash = Self.calibData
a4dataHash = Self.a4CalibData

projName = file_basename(Self.projName,/fold_case,'.tisv')
if (strcmp(projName,'Untitled',8,/fold_case)) then begin
   ext = (Self.instrumentName eq 0)? '.bt7' : '.ng5'
   projName = (Self.anaModeFlag eq 3)? file_basename(a4dataHash['filename'],ext) : file_basename(dataHash['filename'],ext)

   ; replace spaces in filename with _
   while ((pos = stregex(projName,' ')) ne -1) do strput, projName,'_',pos
endif

title = "Specify filename to store session"
ext = 'tisv'
filter = ['*.tisv']
projName = dialog_pickfile(title=title,filter=filter,default_extension=ext $
                          ,dialog_parent=wTLB, /write $
                          ,/overwrite_prompt, file=projName+'.tisv' $
                          ,path=workDir, get_path=new_workDir)

if (strcmp(projName,'')) then return, 0 

return, Self->writeProject(/noPrompt, new_workDir=file_dirname(projName,/mark_dir), new_projName=file_basename(projName,/fold_case,'.tisv'))

end


;===============================================================================
;+
; SPINSPSDCalibTool::WriteProject
;
; PURPOSE:
;   save project (data plus state) to file
;
; PARAMETERS:
;
; KEYWORDS:
;-
function SPINSPSDCalibTool::WriteProject, noPrompt=noPrompt, new_workDir=new_workDir,new_projName=new_projName 
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::writeProject: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

; save session preferences
status = Self->SavePreferences(/skip_filesave)

Self->GetProperty, preferences=_prefStr, working_directory=workDir

if (~Self.calibFilePresent && ~Self.a4CalibFilePresent) then begin
   msg = 'Nothing to save! There is no calibration data loaded in current session.'
   Self->StatusMessage, msg
   Self->ErrorMessage, msg, severity=0, title='Save Unnecessary!'
   return, 0
endif

projName = (keyword_set(new_projName))? new_projName : Self.projName
if (keyword_set(new_workDir)) then workDir = new_workDir
  
dataHash = Self.calibData
a4dataHash = Self.a4CalibData

if (keyword_set(noPrompt)) then begin
    projName = workDir+projName+'.tisv'
endif else begin
  projName = Self.projName
  if (strcmp(projName,'Untitled',/fold_case) || strcmp(projName,'')) then begin
    ext = (Self.instrumentName eq 0)? '.bt7' : '.ng5'
    projName = (Self.anaModeFlag eq 3)? file_basename(a4dataHash['filename'],ext) : file_basename(dataHash['filename'],ext)
  
    ; replace spaces in filename with _
    while ((pos = stregex(projName,' ')) ne -1) do strput, projName,'_',pos
    
    title = "Specify filename to store session"
    ext = 'tisv'
    filter = ['*.tisv']
    projName = dialog_pickfile(title=title,filter=filter,default_extension=ext $
                               ,dialog_parent=wTLB, /write $
                               ,/overwrite_prompt, file=projName+'.tisv' $
                               ,path=workDir, get_path=new_workDir)
  
  endif else $
    projName = workDir+projName+'.tisv'
endelse
                       
if (~strcmp(projName,'')) then begin
  _calibInfo = {calibFilePresent:Self.calibFilePresent $
               ,a4calibFilePresent:Self.a4CalibFilePresent $
               ,instrumentName:Self.instrumentName $
               ,anamodeFlag:Self.anaModeFlag $
               ,plotFlag:Self.plotFlag $
               ,requireProcessing:Self.requireProcessing $
               ,a4Flag:Self.a4Flag $
               ,a4Value:Self.a4Value $
               ,a6Value:Self.a6Value $
               ,maskThreshold:Self.maskThreshold $
               ,maskedPixels:Self.maskedPixels $
               }

   save, _calibInfo, _prefStr, dataHash, a4dataHash $
       , description = 'TAS PSD Calibration Session' $
       , filename=projName, /compress
   if (isa(new_workDir) && file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir

   msg = 'Session stored in: '+projName
   Self->StatusMessage, msg
   
   projName = file_basename(projName,/fold_case,'.tisv')
   Self.projName = projName
   Self->SetProperty, tool_filename=projName
   
   Self.modifiedFlag = 0
endif

return, 1
end


;===============================================================================
; SPINSPSDCalibTool::readProject
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSPSDCalibTool::ReadProject
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::ReadProject: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        if (obj_valid(oSave)) then obj_destroy, oSave
        Self->EnableUpdates
        return, 0
    endif
endif

filter = '*.tisv'
Self->GetProperty, working_directory=workDir
if (n_elements(title) eq 0) then title='Specify session to load'

filename = dialog_pickfile(title=title,/must_exist, dialog_parent=wTLB $
                       ,filter=filter,path=workDir, get_path=newWorkDir)

if (filename eq '') then return, 0
Self->SetProperty, work_directory=newWorkDir

oSave = obj_new('IDL_Savefile', filename)
contents = oSave->Contents()
obj_destroy, oSave
expectedDesc='TAS PSD Calibration Session'
if (~strcmp(contents.description,expectedDesc,/fold_case)) then begin
   msg = 'Not a valid TAS PSD Calibration session file!'
   Self->StatusMessage, msg
   Self->ErrorMessage, msg, severity=1, title='Invalid file type!'   
   return, 0
endif

restore, filename, restored_objects=oObj, /relaxed_structure_assignment
nObj = n_elements(oObj)
if (nObj le 0) then return, 0

; Check whether or not to save current session before closing it
if (Self.modifiedFlag) then begin
   ; If our current state is dirty, prompt to save first.
   Self->GetProperty, working_directory=workDir
   outfile = workDir+Self.projName+'.tisv'
   status = self->PromptUserYesNo( $
       "Save changes to " + outfile + "?", $
       answer, $
       DEFAULT_NO=0, $
       TITLE='Save', $
       /CANCEL)

   if (status && (answer eq 1)) then begin
      void = Self->writeProject(/noPrompt)
   endif

endif

Self->DisableUpdates

projName = file_basename(filename,/fold_case,'.tisv')
Self.projName = projName

; update preferences structure to most current definition
status = SPINSPSDCalibPreferences(_prefStr,/updateVersion) 

Self->InitPreferences, _prefStr
Self->SetProperty, tool_filename=projName, instrumentName=_calibInfo.instrumentName

obj_destroy, Self.calibData
obj_destroy, Self.a4CalibData
Self.calibData = dataHash
Self.a4CalibData = a4dataHash
Self.a4calibFilePresent = _calibInfo.a4calibFilePresent
Self.calibFilePresent = _calibInfo.calibFilePresent
Self.anaModeFlag = _calibInfo.anamodeFlag
Self.a4Flag = _calibInfo.a4Flag
Self.plotFlag = _calibInfo.plotFlag
Self.requireProcessing = _calibInfo.requireProcessing
Self.A4Value = _calibInfo.A4Value
Self.A6Value = _calibInfo.A6Value
Self.maskThreshold = _calibInfo.maskThreshold
Self.maskedPixels = _calibInfo.maskedPixels

ext = (Self.instrumentName eq 0)? '.bt7' : '.ng5'
if (Self.calibFilePresent) then Self.calibFilename = file_basename(dataHash['filename'],ext)
if (Self.a4calibFilePresent) then Self.a4calibFilename = file_basename(a4dataHash['filename'],ext)
nPix = (Self.calibFilePresent)? dataHash['nPix'] : a4dataHash['nPix'] 
Self->SetPropertyAttribute,'pixelNumber', valid_range=[1,nPix,1]

Self->UpdatePropertySheet
Self->Plot

Self.modifiedFlag = 0
Self->EnableUpdates
return, 1
end


;---------------------------------------------------------------------------
; Lifecycle Routines
;---------------------------------------------------------------------------
; SPINSPSDCalibTool::Init
;
; Purpose:
; The constructor of the SPINSPSDCalibTool object.
;
; Parameters:
; None.
;
;+
; :Description:
;    Describe the procedure.
;
;
;
; :Keywords:
;    _REF_EXTRA
;
; :Author: azuah
;-
function SPINSPSDCalibTool::Init, _REF_EXTRA=_EXTRA
compile_opt idl2

;; Call our super class
if (~self->IDLitTool::Init(_EXTRA=_extra)) then $
  return, 0

oSystem = self->_GetSystem()

; Specify current data version number
; Essentially, whevever the data structure used to store 
; datasets changes the version number should be incremented to reflect
; this. When the version number changes, restoreDataVersion() must also
; be modified to handle restoring older version datasets to the
; current version.
Self.dataVersion = 1

; Add a 'DAVEDATA_MANAGER' service
;self->AddService, OBJ_NEW("DAVEsrvDatamanager", name="DAVEDATA_MANAGER")

; Create the data manager folders
oSampFolder = Obj_New("IDLitDataManagerFolder", identifier='Calib Data Manager' $
                      ,name='Calibration Raw Data', description='Calibration Data Manager Container',tool=self)
self->Add, oSampFolder
;oBkgdFolder = Obj_New("IDLitDataManagerFolder", identifier='Bkgd Data Manager' $
;                      ,name='Background', description='Bkgd Data Manager Container',tool=self)
;self->Add, [oSampFolder,oBkgdFolder]


self->createfolders,'Operations/       ',NAME='', description='Horizontal Space'
;;---------------------------------------------------------------------
;;*** File Menu

;; create folders
self->createfolders,'Operations/File',NAME=IDLitLangCatQuery('Menu:File')

self->RegisterOperation, 'Open Session', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='File/readProject'

self->RegisterOperation, 'Save Session', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/writeProject'
self->RegisterOperation, 'Save Session As', $
  'DAVEopMenuItem',icon='Save_24', IDENTIFIER='File/writeProjectAs'

Self->RegisterOperation,'Export Graphics...' $
  ,'DAVEopExportGraphics' $
  ,identifier='File/Export' $
  ,ACCELERATOR='Ctrl+E' $
  ,writertypes=['IDLDEST','IDLIMAGE'] $
  ,icon='export',/separator

self->RegisterOperation, IDLitLangCatQuery('Menu:File:PrintPreview'), $
  'IDLitopPrintPreview', $
  DESCRIPTION='Print the contents of the active window', $
  IDENTIFIER='File/PrintPreview', ICON='print'

self->RegisterOperation, IDLitLangCatQuery('Menu:File:Print'), $
  'IDLitopFilePrint', $
  ACCELERATOR='Ctrl+P', $
  DESCRIPTION='Print the contents of the active window', $
  IDENTIFIER='File/Print', ICON='print_24'


self->RegisterOperation, 'Save Preferences', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/savePreferences',/separator

self->RegisterOperation, 'Reset Preferences (Default Values)', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/resetPreferences'

self->RegisterOperation, 'Exit', 'DAVEopMenuItem', ACCELERATOR='Ctrl+Q', $
  IDENTIFIER='File/Exit', /SEPARATOR

self->RegisterOperation, 'ExitOp', 'DAVEopFileExit', IDENTIFIER='ExitOp'


;-----------
; Data Input Menu
self->createfolders,'Operations/Input',NAME='Dataset Input'

self->RegisterOperation, 'Load Energy Calibration', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadEnergyCalib'
self->RegisterOperation, 'Load Energy Calibration - from FTP server', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadEnergyCalibFtp'
self->RegisterOperation, 'Load A4 Calibration', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadA4Calib', /separator
self->RegisterOperation, 'Load A4 Calibration - from FTP server', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadA4CalibFtp'

;self->RegisterOperation, 'Delete All Loaded Data', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/deleteAllDatasets',/separator



;-----------
; Data Output Menu
self->createfolders,'Operations/Output',NAME='Data Output'
  
self->RegisterOperation, 'Save Calibration Parameter File', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/SaveCalibParameters'



;;---------------------------------------------------------------------
;; Create our File toolbar container.
;;
;self->Register, IDLitLangCatQuery('Menu:File:New'), 'IDLitOpNewTool', $
;                IDENTIFIER='Toolbar/File/NewTool', ICON='new'
;self->Register, IDLitLangCatQuery('Menu:File:Open'), $
;                PROXY='Operations/File/Open', $
;                IDENTIFIER='Toolbar/File/Open'
;self->Register, IDLitLangCatQuery('Menu:File:Save'), $
;                PROXY='Operations/File/Save', $
;                IDENTIFIER='Toolbar/File/Save'
self->Register, "Open Session", $
                PROXY='Operations/File/ReadProject', $
                IDENTIFIER='Toolbar/File/ReadProject'
self->Register, "Save Session", $
                PROXY='Operations/File/WriteProject', $
                IDENTIFIER='Toolbar/File/WriteProject'
self->Register, "Save Session As", $
                PROXY='Operations/File/WriteProjectAs', $
                IDENTIFIER='Toolbar/File/WriteProjectAs'
self->Register, IDLitLangCatQuery('Menu:File:Print'), $
                PROXY='Operations/File/Print', $
                IDENTIFIER='Toolbar/File/Print'
self->Register, IDLitLangCatQuery('Menu:File:PrintPreview'), $
                PROXY='Operations/File/PrintPreview', $
                IDENTIFIER='Toolbar/File/PrintPreview'
self->Register, IDLitLangCatQuery('Menu:File:Export'), $
                PROXY='Operations/File/Export', $
                IDENTIFIER='Toolbar/File/Export'


;;---------------------------------------------------------------------
;;*** Edit Menu

self->createfolders,'Operations/Edit',NAME=IDLitLangCatQuery('Menu:Edit')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Undo'), $
  'IDLitopUndo', $
  ACCELERATOR='Ctrl+Z', $
  IDENTIFIER='Edit/Undo', ICON='undo', /disable, $
  /IGNORE_AVAILABILITY

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Redo'), $
  'IDLitopRedo', $
  ACCELERATOR='Ctrl+Y', $
  IDENTIFIER='Edit/Redo', ICON='redo',/disable, $
  /IGNORE_AVAILABILITY

;; Clipboard...note these are proxied from the system registry!

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Cut'), $
  PROXY="/REGISTRY/OPERATIONS/CUT",$
  IDENTIFIER='Edit/Cut'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Copy') , $
  PROXY='/REGISTRY/OPERATIONS/COPY', $
  IDENTIFIER='Edit/Copy'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Paste') , $
  PROXY='/REGISTRY/OPERATIONS/Paste', $
  IDENTIFIER='Edit/Paste'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:PasteSpecial') , $
  PROXY='/REGISTRY/OPERATIONS/PASTESPECIAL', $
  IDENTIFIER='Edit/PasteSpecial'

                                ;-----------------
self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Delete') , $
  PROXY='/REGISTRY/OPERATIONS/Delete', $
  IDENTIFIER='Edit/Delete'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SelectAll') , $
  'IDLitopSelectAll', $
  DESCRIPTION="Select all visualizations in the current view.", $
  IDENTIFIER='Edit/SelectAll', $
  ICON='select'


                                ;-----------------
self->createfolders,'Operations/Edit/Grouping', $
                    NAME=IDLitLangCatQuery('Menu:Edit:Grouping')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Group'), $
  'IDLitopGroup', $
  IDENTIFIER='Edit/Grouping/Group', $
  ICON='group', $
  /SEPARATOR

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Ungroup'), $
  'IDLitopUngroup', $
  IDENTIFIER='Edit/Grouping/Ungroup', $
  ICON='ungroup'


;;---------------------------------------------------------------------
;;*** Format Menu

self->createfolders,'Operations/Edit/Style', $
                    NAME=IDLitLangCatQuery('Menu:Style')

self->RegisterOperation, IDLitLangCatQuery('Menu:Style:ApplyStyle') , $
  PROXY='/REGISTRY/OPERATIONS/Apply Style', $
  IDENTIFIER='Edit/Style/Apply Style'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Style:CreateStylefromSelection'), $
  'IDLitopStyleCreate', $
  IDENTIFIER='Edit/Style/Create Style', $
  ICON='style'

self->RegisterOperation, IDLitLangCatQuery('Menu:Style:StyleEditor'), $
  'IDLitopStyleEditor', $
  IDENTIFIER='Edit/Style/StyleEditor', $
  ICON='style'


;;-----------------
;; Register here but make private. We only expose this operation
;; in the context menu, but we want it to be (de)sensitized along with
;; the rest of the Edit menu.
;self->RegisterOperation, 'Export to IDL...', 'IDLitopclExport', $
;  /PRIVATE, $
;  DESCRIPTION='Export Visualization Parameters to IDL Variables. ', $
;  IDENTIFIER='Edit/CLExport', $
;  /separator


;;-----------------
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Parameters'), $
;  'IDLitopEditParameters', $
;  IDENTIFIER='Edit/EditParameters', $
;  ICON='binary', $
;  /separator
self->RegisterOperation, 'Edit Parameters','IDLitopEditParameters'

Self->RegisterOperation, 'SaveProperties','DAVEopMenuItem',identifier='Edit/SaveProperties'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Properties'), $
  'IDLitopPropertySheet', $
  DESCRIPTION='Display the Property Sheet for the item', $
  IDENTIFIER='Edit/Properties', $
  ICON='propsheet'


;;---------------------------------------------------------------------
;; Create our Edit toolbar container.
;;
self->Register, IDLitLangCatQuery('Menu:Edit:Undo'), $
                PROXY='Operations/Edit/Undo', $
                IDENTIFIER='Toolbar/Edit/Undo'
self->Register, IDLitLangCatQuery('Menu:Edit:Redo'), $
                PROXY='Operations/Edit/Redo', $
                IDENTIFIER='Toolbar/Edit/Redo'
self->Register, IDLitLangCatQuery('Menu:Edit:Cut'), $
                PROXY="/REGISTRY/OPERATIONS/CUT",$
                IDENTIFIER='Toolbar/Edit/Cut'
self->Register, IDLitLangCatQuery('Menu:Edit:Copy'), $
                PROXY='/REGISTRY/OPERATIONS/COPY', $
                IDENTIFIER='Toolbar/Edit/Copy'
self->Register, IDLitLangCatQuery('Menu:Edit:Paste'), $
                PROXY='/REGISTRY/OPERATIONS/Paste', $
                IDENTIFIER='Toolbar/Edit/Paste'


;;---------------------------------------------------------------------
;;*** Insert menu

self->createfolders,'Operations/Insert', $
                    NAME=IDLitLangCatQuery('Menu:Insert')

;self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:Visualization'), 'IDLitopInsertVis', $
;;  IDENTIFIER='Insert/Visualization', ICON='view'

self->RegisterOperation, 'Insert Visualization','IDLitopInsertVis';, $
;  IDENTIFIER='Insert/Visualization', ICON='view'


self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:View'), $
  'IDLitopInsertView', $
  IDENTIFIER='Insert/View', ICON='view'

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:DataSpace'), $
  'IDLitopInsertDataSpace';, $
  ;IDENTIFIER='Insert/Data Space', ICON='mcr'

;self->createfolders,'Operations/Insert/Axis', NAME=IDLitLangCatQuery('Menu:Insert:Axis')

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:XAxis'), $
  'IDLitOpInsertAxisX';, IDENTIFIER='Insert/Axis/X Axis', ICON='mcr'
self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:YAxis'), $
  'IDLitOpInsertAxisY';, IDENTIFIER='Insert/Axis/Y Axis', ICON='mcr'
self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:ZAxis'), $
  'IDLitOpInsertAxisZ';, IDENTIFIER='Insert/Axis/Z Axis', ICON='mcr'


;;---------------------------------------------------------------------
;;*** Operations Menu
self->createfolders,'Operations/Operations', $
                    NAME=IDLitLangCatQuery('Menu:Operations')

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:OperationsBrowser'), $
;  'IDLitopBrowserOperation', $
;  IDENTIFIER='Operations/Operations Browser' ; ,ICON='mcr'

self->createfolders,'Operations/Operations/Macros', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Macros')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RunMacro'), $
  PROXY='/Registry/MacroTools/Run Macro', $
  IDENTIFIER='Operations/Macros/Run Macro'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:StartRecording'), $
  PROXY='/Registry/MacroTools/Start Recording', $
  IDENTIFIER='Operations/Macros/Start Recording'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:StopRecording'), $
  PROXY='/Registry/MacroTools/Stop Recording', $
  IDENTIFIER='Operations/Macros/Stop Recording'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:MacroEditor'), $
  PROXY='/Registry/MacroTools/Macro Editor', $
  IDENTIFIER='Operations/Macros/Macro Editor'

;
self->createfolders,'Operations/Operations/Filter', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Filter')

;
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:Median'), $
  'IDLitopMedianFilter', $
  DESCRIPTION='Perform the median filter operation on the selected item', $
  IDENTIFIER='Operations/Filter/Median', ICON='sum'

self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Smooth'), $
  'IDLitopSmooth', $
  DESCRIPTION='Perform the smooth operation on the selected item', $
  IDENTIFIER='Operations/Filter/Smooth', ICON='sum'

self->createfolders,'Operations/Operations/Rotate', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Rotate')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateLeft'), $
  'IDLitopRotateLeft', $
  DESCRIPTION='Rotate left by 90 degrees', $
  IDENTIFIER='Operations/Rotate/RotateLeft', $
  ICON='rotate'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateRight'), $
  'IDLitopRotateRight', $
  DESCRIPTION='Rotate right by 90 degrees', $
  IDENTIFIER='Operations/Rotate/RotateRight', $
  ICON='rotate'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateByAngle'), $
  'IDLitopRotateByAngle', $
  DESCRIPTION='Rotate by a specified angle', $
  IDENTIFIER='Operations/Rotate/RotateByAngle', $
  ICON='rotate'

;;---------------------------------------------------------------------
;;*** Window Menu

self->createfolders,'Operations/Window', $
                    NAME=IDLitLangCatQuery('Menu:Window')

;;-----------------
Self->RegisterOperation, 'Reset to Default Data Range', 'IDLitopRangeReset' $
   ,description='Reset to default data range', identifier='Window/Resetrange' $
   ,icon='range_reset'

;;--
self->createfolders,'Operations/Toolbar/Dataspace',name='Dataspace'
self->Register, 'Reset to Default Data Range', $
                PROXY='Operations/Window/Resetrange', $
                IDENTIFIER='Toolbar/Dataspace/Resetrange'

self->createfolders,'Operations/Window/Canvas Zoom', $
                    NAME=IDLitLangCatQuery('Menu:Window:CanvasZoom')

self->RegisterOperation, '800%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/800%', $
  ICON='zoom', /CHECKED;, /SEPARATOR
self->RegisterOperation, '400%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/400%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '200%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/200%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '100%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/100%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '75%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/75%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '50%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/50%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '25%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/25%', $
  ICON='zoom', /CHECKED

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:ZoomonResize'), $
  'IDLitopZoomResize', $
  ICON='zoom', $
  IDENTIFIER='Window/ZoomResize', /CHECKED

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:Layout'), $
  'IDLitopWindowLayout', $
  IDENTIFIER='Window/Layout'

                                ;-----------------

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:FittoView'), $
  'IDLitopFitToView', $
  IDENTIFIER='Window/FitToView', $
  ICON='fitwindow', /SEPARATOR

;;---------------------------------------------------------------------
;;*** Help Menu
self->createfolders,'Operations/Help', $
                    NAME=IDLitLangCatQuery('Menu:Help')


self->RegisterOperation, "User's Manual", 'DAVEopHelp', $
  IDENTIFIER='Help/TASPSDCalibManual',helptopic='TASPSD_CALIBRATION'
;-----------------

self->RegisterOperation, 'About TAS PSD Calibration', 'SPINSPSDCalibopHelpAbout', $
  IDENTIFIER='Help/About SPINSPSD',/separator

self->RegisterOperation, 'About DAVE', 'DAVEopHelpAbout', $
  IDENTIFIER='Help/About DAVE',/separator


;;---------------------------------------------------------------------
;;*** Manipulators
self->RegisterManipulator, 'Arrow', 'IDLitManipArrow', $
  ICON='arrow', /DEFAULT, IDENTIFIER="ARROW", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Select')

self->RegisterManipulator, 'Rotate', 'IDLitManipRotate', $
  ICON='rotate', IDENTIFIER="ROTATE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Rotate')

self->RegisterManipulator, 'View Pan', 'IDLitManipViewPan', $
  ICON='hand', IDENTIFIER="VIEWPAN", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Pan')


;;---------------------------------------------------------------------
;;*** View Zoom Manipulator
self->RegisterManipulator, 'View Zoom', 'IDLitManipViewZoom', $
  IDENTIFIER='View/ViewZoom', ICON='zoom', $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:ViewZoom')

;;---------------------------------------------------------------------
;; *** View Zoom Combobox

                                ; Combobox is not available on True64 (OSF Alpha)
useCombobox = ~(!VERSION.os eq 'OSF')
self->Register, 'View Zoom', 'IDLitopViewZoom', $
                IDENTIFIER='Toolbar/View/ViewZoom', $
                DROPLIST_EDIT=useCombobox, $
                DROPLIST_ITEMS=['800%', $
                                '400%', $
                                '200%', $
                                '150%', $
                                '130%', $
                                '100%', $
                                '75%',  $
                                '50%',  $
                                '25%'], $
                DROPLIST_INDEX=4, $
                /SINGLETON

;;---------------------------------------------------------------------
;;*** Annotation Manipulators
self->RegisterManipulator, 'Text', 'IDLitAnnotateText', $
  ICON='text', IDENTIFIER="ANNOTATION/TEXT", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateText')

self->RegisterManipulator, 'Line', 'IDLitAnnotateLine', $
  ICON='line', IDENTIFIER="ANNOTATION/LINE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateLine')

self->RegisterManipulator, 'Rectangle', 'IDLitAnnotateRectangle', $
  ICON='rectangl', IDENTIFIER="ANNOTATION/RECTANGLE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateRectangle')

self->RegisterManipulator, 'Oval', 'IDLitAnnotateOval', $
  ICON='ellipse', IDENTIFIER="ANNOTATION/OVAL", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateOval')

self->RegisterManipulator, 'Polygon', 'IDLitAnnotatePolygon', $
  ICON='segpoly', IDENTIFIER="ANNOTATION/POLYGON", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotatePolygon')

self->RegisterManipulator, 'Freehand', 'IDLitAnnotateFreehand', $
  ICON='freehand', IDENTIFIER="ANNOTATION/FREEHAND", $
  DESCRIPTION='Click & drag to draw'



;;---------------------------------------------------------------------
;;*** DrawContext
;self->Register, 'Cut', $
;                PROXY="/REGISTRY/OPERATIONS/CUT",$
;                IDENTIFIER='ContextMenu/DrawContext/Cut'
;
;self->Register, 'Copy', $
;                PROXY='/REGISTRY/OPERATIONS/COPY', $
;                IDENTIFIER='ContextMenu/DrawContext/Copy'
;
;self->Register, 'Paste', $
;                PROXY='/REGISTRY/OPERATIONS/Paste', $
;                IDENTIFIER='ContextMenu/DrawContext/Paste'
;
;                                ;-----------------
self->Register, 'Delete', $
                PROXY='/REGISTRY/OPERATIONS/Delete', $
                IDENTIFIER='ContextMenu/DrawContext/Delete'

                                ;-----------------
self->Register, 'Group', $
                PROXY='Operations/Edit/Grouping/Group', $
                IDENTIFIER='ContextMenu/DrawContext/Grouping/Group'

self->Register, 'Ungroup', $
                PROXY='Operations/Edit/Grouping/Ungroup', $
                IDENTIFIER='ContextMenu/DrawContext/Grouping/Ungroup'

self->Register, 'Modify Properties...', $
                PROXY='Operations/Edit/Properties', $
                IDENTIFIER='ContextMenu/DrawContext/Properties'

;;---------------------------------------------------------------------
;;*** CropContext
;self->Register, 'Crop...', 'IDLitopCropImage', $
;                DESCRIPTION='Crop the selected image', $
;                IDENTIFIER='ContextMenu/CropDrawContext/Crop', $
;                ICON='crop', $
;                /SINGLETON

;Self.calibContRef = obj_new('IDL_Container') ;obj_new('IDLitContainer',name='SampContainer')
;Self.bkgdContRef = obj_new('IDL_Container') ;obj_new('IDLitContainer',name='BkgdContainer')

;; Initialise data and Register Properties

Self.instrumentName = 0
Self->RegisterProperty, 'instrumentName', enumlist=['BT7','SPINS'], name='Instrument' $
  ,description='Instrument Name';, sensitive=0
IDLge90 = (float(!version.release) ge 9.0)? 1 : 0
Self.ftpObject =  (IDLge90)? DAVEHttpRequest() :  DAVEftpURL()
Self.ftpObject->SetProperty, currentDir = '/pub/ncnrdata/bt7/'



Self.anaModeFlag = 0
Self->RegisterProperty, 'anaModeFlag', enumlist=['Flat','See Through','Fixed Ef','Two Axis (Diffraction)'], name='Analyzer Mode' $
                      ,description='Analyzer Mode';, sensitive=0

Self.a4Flag = 0
Self.RegisterProperty, 'a4Flag', enumlist=['Calculation','Measurement'], name='A4 Determined By' $
  ,description='A4 Determination method', sensitive=0

Self.calibFilename = '<not specified>'
Self->RegisterProperty, 'calibFilename', /string, name='Energy Calibration File', description='Energy Calibration File', sensitive=0
Self.a4CalibFilename = '<not specified>'
Self->RegisterProperty, 'a4CalibFilename', /string, name='A4 Calibration File', description='A4 Calibration File', sensitive=0

Self->RegisterProperty, 'A4Value', /float, name='A4 Bragg Peak', description='A4 value used as A4 midpoint for A4 scan'
Self->Registerproperty, 'A4Width', /float, name='A4 width to use for fit', description='A4 width around bragg peak to be considered in fit'
Self->RegisterProperty, 'A6Value', /float, name='A6 Value', description='A6 value for used to calculate A4 midpoint for Energy scan'

Self.plotFlag = 0
enum = ['PSD Image - Energy Scan','PSD Image - A4 Scan','Energy Fits at each pixel','A4 Fits at each pixel','Ef per pixel','Delta A4 per pixel','Sensitivity per pixel']
Self.RegisterProperty, 'plotFlag', enumlist=enum, name='Display Quantity' $
  ,description='Display Item';

Self.pixelNumber = 10
Self->RegisterProperty, 'pixelNumber', /integer, name='Pixel Number';, valid_range[1,1,1]

Self.maskThreshold = 10
Self->RegisterProperty, 'maskThreshold', /integer, name='Mask Threshold %', valid_range=[0,100,1]

Self.maskedPixels = ''
Self->RegisterProperty, 'maskedPixels', /string,name=(Self.instrumentName eq 0)? 'Channels to mask' : 'Pixels to mask'

;Self.thetagValue = 0.0
;Self->RegisterProperty, 'thetagValue', /float, name='Theta_g', description='thetagValue', sensitive=0


;Self.logFlag = 0
;Self->RegisterProperty, 'logFlag', enumlist=['Linear','Logbase10'], name='Intensity Scale' $
;                      ,description='Intensity Scale' ,hide=hideifpowder
;
;Self.defaultIntensityFlag = 1
;Self->RegisterProperty, 'defaultIntensityFlag', enumlist=['No','Yes'], name='Use Default Intensity Range?' $
;                      ,description='Use Default Intensity Range?' ,hide=hideifpowder
;Self.minIntensity = 0.0
;Self->RegisterProperty, 'minIntensity', /float, name='Min Intensity Value' $
;                      ,description='Min Intensity Value' ,hide=hideifpowder
;Self.maxIntensity = 0.0
;Self->RegisterProperty, 'maxIntensity', /float, name='Max Intensity Value' $
;                      ,description='Max Intensity Value' ,hide=hideifpowder

Self->SetPropertyAttribute, 'NAME', /hide
Self->SetPropertyAttribute, 'DESCRIPTION', /hide
Self.projName = 'Untitled'

;; Finally, set the prompt property to 1 meaning display a warning dialog 
;; before deleting this tool
Self.prompt = 1
Self.promptDesc = 'TAS PSD Calibration'
Self.promptTitle = 'Delete TAS PSD Calibration?'

; initialize data structures to hold the calibration raw and processed data
Self.calibData = hash()
Self.a4CalibData = hash()

Self.ekFac = 2.072194
Self.A6Value = 0.0
Self.A4Value = 0.0
Self.A4Width = 5.0

return, 1

end


;-------------------------------------------------------------------------
; SPINSPSDCalibTool::SaveVisProps
;+
; Purpose:
;    Retrieve the curent vis properties and save them
;
; Parameters:
;    oVis     - The visualization whose properties are to be saved
;    
;-
pro SPINSPSDCalibTool::SaveVisProps, oVis
compile_opt idl2

if (~obj_valid(oVis)) then return
if (~obj_isa(oVis,'IDLitVisualization')) then return

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSPSDCalibTool::SaveVisProps: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return
    endif
endif

oVis->GetProperty, description=plotDesc
case strupcase(plotDesc) of
   'SAMPPLOT': prefix = 's_'
   'BKGDPLOT': prefix = 'b_'
;   'FASTPLOT': prefix = 'f_'
;   'SAMPBKGDPLOT': prefix = 'sb_'
;   'FASTFITPLOT': prefix = 'ff_'
   else: return
endcase

switch strupcase(plotDesc) of
   'SAMPPLOT':
   'BKGDPLOT':
   'FASTPLOT': begin
      ;; store the vis props
      vTags = ['use_default_color','color','errorbar_color','sym_color','errorbar_capsize' $
              ,'sym_increment','sym_index','sym_size','sym_thick','y_errorbars','antialias' $
              ,'linestyle','nsum','thick','sym_filled','sym_fill_color','transparency']
;      vTags = ['errorbar_capsize','transparency','antialias','color','use_default_color' $
;              ,'sym_increment','sym_index','sym_size','sym_color','sym_thick','y_errorbars' $
;              ,'linestyle','nsum','thick','sym_filled','sym_fill_color']
      tTags = prefix + vTags
      if (keyword_set(fill)) then begin
        tTags = [tTags,'fill_background','fill_level','fill_color','fill_transparency']
        vTags = [vTags,'fill_background','fill_level','fill_color','fill_transparency']
      endif

      nTags = n_elements(vTags)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
         status = oVis->GetPropertyByIdentifier(vTags[i], value)
         if (status) then etc = create_struct(etc,tTags[i],value)
      endfor
      Self->SetProperty, _EXTRA=etc

      ;; store the axes props
      vTags = ['font_name','font_size','text_color']
      tTags = prefix + vTags
      nTags = n_elements(vTags)
      oDataSpace = oVis->GetDataSpace()
      oAxes = oDataSpace->GetAxes(count=naxes)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
         status = oAxes[0]->GetPropertyByIdentifier(vTags[i], value)
         if (status) then etc = create_struct(etc,tTags[i],value)
      endfor
      Self->SetProperty, _EXTRA=etc   
   
      break
   end
   
   else:
endswitch

end




;-------------------------------------------------------------------------
; SPINSPSDCalibTool::customizeVis
;+
; Purpose:
;    Customize a newly created visualization using attributes obtained from the tool
;
; Parameters:
;    oVis     - The visualization to be customized
;    
;    plotname - a string name to be used to identify the visualization
;-
pro SPINSPSDCalibTool::CustomizeVis, oVis, plotName, plotDesc, fill=fill
compile_opt idl2

if (~obj_valid(oVis)) then return
if (~obj_isa(oVis,'IDLitVisualization')) then return

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'wd_SPINSPSDCalibTool_customizeVis: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return
    endif
endif

case strupcase(plotDesc) of
   'SAMPPLOT': prefix = 's_'
   'BKGDPLOT': prefix = 'b_'
;   'FASTPLOT': prefix = 'f_'
;   'SAMPBKGDPLOT': prefix = 'sb_'
;   'FASTFITPLOT': prefix = 'ff_'
   else: return
endcase

switch strupcase(plotDesc) of
   'SAMPPLOT':
   'BKGDPLOT':
   'FASTPLOT': begin
      ;; Set the vis props
      vTags = ['use_default_color','color','errorbar_color','sym_color','errorbar_capsize' $
              ,'sym_increment','sym_index','sym_size','sym_thick','y_errorbars','antialias' $
              ,'linestyle','nsum','thick','sym_filled','sym_fill_color','transparency']
      tTags = prefix + vTags
      if (keyword_set(fill)) then begin
        tTags = [tTags,'fill_background','fill_level','fill_color','fill_transparency']
        vTags = [vTags,'fill_background','fill_level','fill_color','fill_transparency']
      endif

      nTags = n_elements(vTags)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
         status = Self->GetPropertyByIdentifier(tTags[i], value)
         if (status) then etc = create_struct(etc,vTags[i],value)
      endfor

      if (float((strtok(!version.release,/extract))[0]) lt 8.0) then begin
         ; workaround for bug in IDL 7.1 or lower; use_default_color is not honoured for errorbar_color
         if (etc.use_default_color eq 1) then etc.errorbar_color = etc.color
      endif

      oVis->SetProperty, name=strupcase(plotName)
      oVis->SetProperty, name=strupcase(plotName), description=plotDesc, _EXTRA=etc
      oVis->SetPropertyAttribute, 'NSUM', sensitive=0   ; disable point averaging/smoothing b/c errors are not taken into account

      ;; Set the axes props
      vTags = ['font_name','font_size','text_color']
      tTags = prefix + vTags
      nTags = n_elements(vTags)
      oDataSpace = oVis->GetDataSpace()
      oAxes = oDataSpace->GetAxes(count=naxes)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
         status = Self->GetPropertyByIdentifier(tTags[i], value)
         if (status) then etc = create_struct(etc,vTags[i],value)
      endfor
      for i=0,naxes-1 do oAxes[i]->SetProperty, _EXTRA=etc   
   
      break
   end
   
   else:
endswitch



end



;---------------------------------------------------------------------------
; SPINSPSDCalibTool::InitPreferences
;
; Purpose:
;   This method
;
pro SPINSPSDCalibTool::InitPreferences, preferences
compile_opt idl2

; Init working and data directory from the DAVETool values
;daveTool = Self.daveTool
;if (obj_valid(daveTool) and obj_isa(daveTool,'DAVETool')) then begin
;   daveTool->GetProperty, data_directory=datDir, working_directory=workDir
;   Self->SetProperty, data_directory=datDir, working_directory=workDir
;endif


; Retrieve user settings on disk and initialise current session
status = 1
if (n_elements(preferences) eq 0) then status = SPINSPSDCalibPreferences(preferences)
if (status) then Self->SetProperty, preferences=preferences
Self.A4Value = 0.0
Self.A4Width = 5.0
Self.A6Value = 0.0

;Self->GetProperty, maskFlag=mF, fastFlag=fF, xAxisVar=xAxisVar $
;                 , binWidths=binWidths, defaultIntensityFlag=defIntFlag, sampTypeFlag=sampTypeFlag
;Self->SetProperty, minBinWidth = binwidths[xAxisVar]
;noHide = (defIntFlag eq 0) && (sampTypeFlag eq 1)  ; don't hide if not using default intensity and single crystal sample
;Self->SetPropertyAttribute, 'maxIntensity', hide=~noHide
;Self->SetPropertyAttribute, 'minIntensity', hide=~noHide
;Self->SetPropertyAttribute, 'MASKEDDETS', sensitive=mF
;Self->SetPropertyAttribute, 'FASTVALUE', sensitive=fF
;Self->SetPropertyAttribute, 'MONCORFLAG', sensitive=fF
;;Self->SetPropertyAttribute, 'RESCORFLAG', sensitive=mF
;;Self->SetPropertyAttribute, 'DETAILEDBALANCEFLAG', sensitive=mF
;
;; For safety, always initialise phiOffset to 0.0 b/c a user may not be fully aware
;; about this setting. A value of 0.0 is harmless
;Self->SetProperty, phiOffset = 0.0

Self->UpdatePropertySheet
Self->RefreshPropertySheet

; Update title to reflect session name
; setting tool_filename generates a callback on the registered UI callback
Self->SetProperty, tool_filename=Self.projName

; Retrieve the graphics window
; and set auto-resize and zoom-on-resize to 1 so the graphics window behaves properly when its size is changed
oWin = Self->GetCurrentWindow()
oWin->SetProperty, auto_resize=1, zoom_on_resize=1

if (float((strtok(!version.release,/extract))[0]) ge 8.0) then begin
   ; For IDL 8.0 and newer, a title text is added to the graphics by default
   ; Hide it!

   idText = iGetID('*title*',tool=Self)
   oText = Self->GetByIdentifier(idText[0])
   if (isa(oText,'IDLitvisText')) then oText->setProperty, hide=1
   ;oWin = Self->GetCurrentWindow()
   ;oScene = oWin->GetScene()
   ;oView = oScene->GetCurrentView()
   ;atoms = oView->GetAll(count=natoms)
   ;for i=0,natoms-1 do begin
   ;   if (obj_isa(atoms[i],'IDLitvisText')) then atoms[i]->setProperty, hide=1
   ;endfor
   Self->RefreshCurrentWindow
endif

end


;---------------------------------------------------------------------------
; SPINSPSDCalibTool::resetPreferences
;
; Purpose:
;   This method
;
function SPINSPSDCalibTool::ResetPreferences
compile_opt idl2


; Retrieve user settings on disk and initialise current session
status = SPINSPSDcalibPreferences(preferences,/reset)
if (status) then Self->SetProperty, preferences=preferences

;Self->GetProperty, maskFlag=mF, fastFlag=fF
;
;Self->SetPropertyAttribute, 'MASKEDDETS', sensitive=mF
;Self->SetPropertyAttribute, 'FASTVALUE', sensitive=fF
;Self->SetPropertyAttribute, 'MONCORFLAG', sensitive=fF
;Self->SetPropertyAttribute, 'RESCORFLAG', sensitive=mF
;Self->SetPropertyAttribute, 'DETAILEDBALANCEFLAG', sensitive=mF

Self->refreshPropertySheet

end


;---------------------------------------------------------------------------
; SPINSPSDCalibTool::EditUserDefProperty
;
; Purpose:
;   This method
;
function SPINSPSDCalibTool::EditUserDefProperty, oTool, PropID
compile_opt idl2

;; The API requires the oTool arg. It is redundant here since it is Self!

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

case PropID of
  'CALIBPARAMSBASEFILENAME': begin
    status = Self->loadCalibParams()
  end

;  'chEfBASEFILENAME': begin
;    status = Self->loadChEf()
;    break
;  end
;
;  'CHEFFBASEFILENAME': begin
;    status = Self->loadChEfficiency()
;    break
;  end

;  'MASKEDDETS': begin
;     ; The currently selected dataset is registered as (*sPtr).itemID
;     noSelection = strcmp(strtrim((*sPtr).itemID),'')
;     if (noselection) then begin
;       ; retrieve the first loaded dataset, if any
;       Self->GetProperty, calibContRef=oCont
;       oItem = oCont->Get(position=0,count=nItem)
;     endif else begin
;       oItem = Self->GetByIdentifier((*sPtr).itemID)
;       nItem = 1
;     endelse
;     if (nItem ne 1) then return, 0
;     
;     wd_SPINSPSDMaskPixels, oUI, oItem, Self.calibParamsIsSet, Self.chEff
;  end
  
   
  else:
endcase

Self->refreshPropertySheet

return, 1
end


;---------------------------------------------------------------------------
; SPINSPSDCalibTool__Define
;
; Purpose:
;   This method defines the SPINSPSDCalibTool class.
;
pro SPINSPSDCalibTool__Define
compile_opt idl2

void = { SPINSPSDCalibTool,                 $
         inherits IDLitTool        $   ; Provides iTool interface
         
         ,instrumentName:''        $   ; instrument name (read from calibration file)
         ,anaModeFlag:0            $   ; Analyzer mode: 0='Flat', 1='See Through', 2='Fixed Ef'
         ,a4Flag:0                 $   ; how to determine a4: 0=Calculation, 1=Measurement
         ,calibFilename:''         $   ; The filename from which the calibration data is read from
         ,a4CalibFilename:''       $   ; If a4Flag eq 1, then this should contain the filename for the a4 calibration data
         ,plotFlag:0               $   ; View one of 0=Raw Calib, 1=Raw A4Calib, 2=Ef  3=dA4  4=Sens
         ,pixelNumber:0            $   ; specifies which pixel to view when 'plotFlag' is set to examine fits
         ,dpdefCorFlag:0           $   ; Apply dpdEf correction? 0=No, 1=Yes
         ,thetagValue:0.0          $   ; Required when calculating delta A4 in Fixed Ef mode
         ,calibFilePresent:0       $   ; Is there a calibration file present?
         ,a4CalibFilePresent:0     $   ; Is there an a$ Calibration file present?
         ,requireProcessing:0      $   ; should calculations be repeated? 0=No, 1=Yes
         ,calibData:hash()         $
         ,a4CalibData:hash()       $
         ,manipID:''               $
         ,A4Value:0.0              $
         ,A4Width:0.0              $   ; 
         ,A6Value:0.0              $ 
         ,maskThreshold:10         $
         ,maskedPixels:''          $
         
         ,dataDir:''               $   ; data directory (Note: working_directory is defined by the base class
         ,DAVETool:obj_new()       $   ; DAVETool object
         ,projName:''              $   ; name of current project
         ,nameTag:''               $   ; Tag to be used for identification purposes
         ,prompt:1                 $
         ,promptTitle:''           $
         ,promptDesc:''            $

         ,xAxisVar:0               $   ; Variable to plotted as the x-axis
         ,yAxisVar:0               $   ; variable to be plotted as the y-axis

         ,logFlag:0                $   ; use linear (0) or log (1) intensity scale
         ,defaultIntensityFlag:0   $   ; use default intensity range 1 = yes, 0 = no
         ,maxIntensity:0.0         $
         ,minIntensity:0.0         $
         ,monScaleValue:1.0        $   ; user specified mon scale factor

         ,prefsPtr:ptr_new()       $   ; points to preference structure
         ,historyPtr:ptr_new()     $
         ,modifiedFlag:0B          $   ; determines modification state of tool - unsufficient control over _bDirty property!
         ,dataVersion:0            $   ; current version number for dataset structure
         ,ftpObject:obj_new()      $   ; DAVEftpURL() object used to access data on ftp://ftp.ncnr.nist.gov/pub/ncnrdata/

         ,ekFac:2.072194           $   ; Energy = ekFac * k^2

         ,s_errorbar_capsize:    0.1 $
         ,s_transparency:        50 $
         ,s_antialias:           3 $
         ,s_color:               [0,0,255] $
         ,s_errorbar_color:      [0,0,255] $
         ,s_use_default_color:   1   $
         ,s_sym_increment:       1   $
         ,s_sym_index:           4   $
         ,s_sym_size:            1.0   $          ; 
         ,s_sym_color:           [0,0,255] $   ;
         ,s_sym_thick:           1.0 $            ;
         ,s_y_errorbars:         1 $              ; show y errors
         ,s_linestyle:           0 $              ; 
         ,s_nsum:                1 $              ; no point everaging
         ,s_thick:               2.0 $            ; line thickness
         ,s_sym_filled:          1   $            ; use filled symbols
         ,s_sym_fill_color:      [0,0,255] $   ; symbol fill color
         ,s_font_name:           'Helvetica'  $   ;
         ,s_font_size:           13 $             ;
         ,s_text_color:          [0,0,0]  $    ;
         ,b_errorbar_capsize:    0.1 $
         ,b_transparency:        50 $
         ,b_antialias:           3 $
         ,b_color:               [0,255,255] $
         ,b_errorbar_color:      [0,255,255] $
         ,b_use_default_color:   1   $
         ,b_sym_increment:       1   $
         ,b_sym_index:           4   $
         ,b_sym_size:            1.0   $          ; 
         ,b_sym_color:           [0,255,255] $   ;
         ,b_sym_thick:           1.0 $            ;
         ,b_y_errorbars:         1 $              ; show y errors
         ,b_linestyle:           6 $              ; no line
         ,b_nsum:                1 $              ; no point everaging
         ,b_thick:               1.0 $            ; line thickness
         ,b_sym_filled:          1   $            ; use filled symbols
         ,b_sym_fill_color:      [0,255,255] $   ; symbol fill color
         ,b_font_name:           'Helvetica'  $   ;
         ,b_font_size:           13 $             ;
         ,b_text_color:          [0,0,0]  $    ;
         ,fill_background:       1           $
         ,fill_level:            0.0         $
         ,fill_color:            [128,128,128] $
         ,fill_transparency:     50          $

       }
end
