; $Id$
;
; Copyright (c) 2000-2004, Research Systems, Inc.  All rights reserved.
;   Unauthorized reproduction prohibited.
;----------------------------------------------------------------------------
;+
; CLASS_NAME:
;   IDLitToolbase
;
; PURPOSE:
;   This file implements the HFBS Tool object
;
; CATEGORY:
;   
;
; SUPERCLASSES:
;   IDLitTool
;
; SUBCLASSES:
;
; CREATION:
;   See IDLitToolbase::Init
;
; METHODS:
;   This class has the following methods:
;
;   IDLitToolbase::Init
;
; INTERFACES:
; IIDLProperty
;-



;===============================================================================
; HfbsTool::GetSystem
; 
; PURPOSE:
;   Return the IDLitSystem object
;
; PARAMETERS:
;
; KEYWORDS:
;
function HfbsTool::GetSystem
compile_opt idl2

return, self->_GetSystem()

end


;===============================================================================
; HfbsTool::GetUI
; 
; PURPOSE:
;   Return the IDLitUI object for this tool
;
; PARAMETERS:
;
; KEYWORDS:
;
function HfbsTool::GetUI
compile_opt idl2

return, self._oUIConnection

end


;-------------------------------------------------------------------------------
pro HfbsTool::Cleanup
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'HfbsTool::Cleanup: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle)

        catch, /cancel
        ptr_free, Self.prefsPtr
        ptr_free, Self.historyPtr
        Self->IDLitTool::Cleanup
        Self->EnableUpdates
        return
    endif
endif

Self->DisableUpdates

; save session preferences
status = Self->SavePreferences()

ptr_free, Self.prefsPtr
ptr_free, Self.historyPtr

; Clean up samp container
oItems = Self.sampContRef->Get(/all, count=n)
if (n gt 0) then begin
   for i=0,n-1 do begin
      void = oItems[i]->GetMetaData('DATAPTRREF',dataPtr)
      if (ptr_valid(dataPtr)) then heap_free, dataPtr
   endfor
endif

; Clean up samp container
oItems = Self.bkgdContRef->Get(/all, count=n)
if (n gt 0) then begin
   for i=0,n-1 do begin
      void = oItems[i]->GetMetaData('DATAPTRREF',dataPtr)
      if (ptr_valid(dataPtr)) then heap_free, dataPtr
   endfor
endif


obj_destroy, [Self.sampContRef,Self.bkgdContRef]

; Call base class cleanup
self->IDLitTool::Cleanup

Self->EnableUpdates

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::savePreferences
;
; PURPOSE:
;   Update and save current user preferences
;
; PARAMETERS:
;
; RETURN VALUE:
;-
function HfbsTool::SavePreferences, skip_filesave=skip_filesave
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'HfbsTool::savePreferences: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

; Save current user graphic customizations and preferences
if (Self->HasVisualizations()) then begin
   oWin = Self->GetCurrentWindow()
   oView = oWin->GetCurrentView()
   oLayer = oView->GetCurrentLayer()
   oWorld = oLayer->GetWorld()
   oDataSpace = oWorld->GetDataSpaces()
   oVis = oDataSpace->GetVisualizations(count = nVis)
   
   for j=nVis-1,0,-1 do begin
      oVis[j]->Select
      Self->saveVisProps, oVis[j]
   endfor
endif

Self->GetProperty, preferences=preferences

if keyword_set(skip_filesave) then return, 1

if (n_elements(preferences) gt 0) then $
   status = HFBSReducPreferences(preferences, /save)

return, 1

end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::Exit
;+
; PURPOSE:
;   Exit handler
;
; PARAMETERS:
;
; RETURN VALUE:
;-
function HfbsTool::Exit
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'HfbsTool::Exit: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wd_HfbsTool_event, { WIDGET_KILL_REQUEST, ID:wTLB, TOP:wTLB, HANDLER:wTLB }

return, 1
end



;-------------------------------------------------------------------------------
pro HfbsTool::GetProperty, nameTag=nameTag, prompt=prompt, prmptTitle=prmptTitle, prmptDesc=prmptDesc $
 ,monScaleFlag=monScaleFlag,bkgdFlag=bkgdFlag,vanFlag=vanFlag,nSamp=nSamp,nBkgd=nBkgd,nVan=nVan $
 ,sumSampFlag=sumSampFlag,sumBkgdFlag=sumBkgdFlag, data_directory=dataDir, daveTool=daveTool $
 ,sampContRef=sampContRef,bkgdContRef=bkgdContRef,vanContRef=vanContRef, ftpObject=ftpObject $
 ,sampFoldCont=sampFoldCont, nosSampFolder=nosSampFolder,ssfactor=ssfactor,autoScaleFlag=autoScaleFlag $
,sampSelected=sampSelected, bkgdSelected=bkgdSelected, vanSelected=vanSelected,detsInGroup1=detsInGroup1 $
 ,detMaskString=detMaskString,detGroupFlag=detGroupFlag, plotFlag=plotFlag, logFlag=logFlag $
 ,preferences=preferences,history=history,oplotBkgdFlag=oplotBkgdFlag, modifiedStatus=modifiedStatus $
 ,xAxisVar=xAxisVar,yAxisVar=yAxisVar, sampTypeFlag=sampTypeFlag $
 ,indepVar1List=indepVar1List,indepVar2List=indepVar2List,indepVar3List=indepVar3List $
 ,selectedIDs=selectedIDs,nSelectedIDs=nSelectedIDs $
 ,grpNos=grpNos, detGroupings=detGroupings, grpScaleFactors=grpScaleFactors $
 ,grpscaleFacStr=grpscaleFacStr, nGroups=nGroups, monNormFlag=monNormFlag $
 ,s_errorbar_capsize=s_errorbar_capsize $
 ,s_transparency=s_transparency $
 ,s_antialias=s_antialias $
 ,s_color=s_color $
 ,s_errorbar_color=s_errorbar_color $
 ,s_use_default_color=s_use_default_color $
 ,s_sym_increment=s_sym_increment $
 ,s_sym_index=s_sym_index $
 ,s_sym_size=s_sym_size $
 ,s_sym_color=s_sym_color $
 ,s_sym_thick=s_sym_thick $
 ,s_y_errorbars=s_y_errorbars $
 ,s_linestyle=s_linestyle $
 ,s_thick=s_thick $
 ,s_sym_filled=s_sym_filled $
 ,s_sym_fill_color=s_sym_fill_color $
 ,s_font_name=s_font_name  $
 ,s_font_size=s_font_size $
 ,s_text_color=s_text_color  $
 ,b_errorbar_capsize=b_errorbar_capsize $
 ,b_transparency=b_transparency $
 ,b_antialias=b_antialias $
 ,b_color=b_color $
 ,b_errorbar_color=b_errorbar_color $
 ,b_use_default_color=b_use_default_color $
 ,b_sym_increment=b_sym_increment $
 ,b_sym_index=b_sym_index $
 ,b_sym_size=b_sym_size $
 ,b_sym_color=b_sym_color $
 ,b_sym_thick=b_sym_thick $
 ,b_y_errorbars=b_y_errorbars $
 ,b_linestyle=b_linestyle $
 ,b_thick=b_thick $
 ,b_sym_filled=b_sym_filled $
 ,b_sym_fill_color=b_sym_fill_color $
 ,b_font_name=b_font_name  $
 ,b_font_size=b_font_size $
 ,b_text_color=b_text_color  $
 ,f_errorbar_capsize=f_errorbar_capsize $
 ,f_transparency=f_transparency $
 ,f_antialias=f_antialias $
 ,f_color=f_color $
 ,f_errorbar_color=f_errorbar_color $
 ,f_use_default_color=f_use_default_color $
 ,f_sym_increment=f_sym_increment $
 ,f_sym_index=f_sym_index $
 ,f_sym_size=f_sym_size $
 ,f_sym_color=f_sym_color $
 ,f_sym_thick=f_sym_thick $
 ,f_y_errorbars=f_y_errorbars $
 ,f_linestyle=f_linestyle $
 ,f_thick=f_thick $
 ,f_sym_filled=f_sym_filled $
 ,f_sym_fill_color=f_sym_fill_color $
 ,f_font_name=f_font_name  $
 ,f_font_size=f_font_size $
 ,f_text_color=f_text_color  $
 ,ff_transparency=ff_transparency $
 ,ff_antialias=ff_antialias $
 ,ff_color=ff_color $
 ,ff_use_default_color=ff_use_default_color $
 ,ff_sym_index=ff_sym_index $
 ,ff_linestyle=ff_linestyle $
 ,ff_thick=ff_thick $
 ,sb_transparency=sb_transparency $
 ,sb_antialias=sb_antialias $
 ,sb_color=sb_color $
 ,sb_use_default_color=sb_use_default_color $
 ,sb_sym_index=sb_sym_index $
 ,sb_linestyle=sb_linestyle $
 ,sb_thick=sb_thick $
 ,_REF_EXTRA=etc

compile_opt idl2

; daveTool
if (arg_present(daveTool)) then daveTool = Self.daveTool
;
if (Arg_present(logFlag)) then logFlag = Self.logFlag
if (arg_present(s_errorbar_capsize)) then s_errorbar_capsize=Self.s_errorbar_capsize
if (arg_present(s_transparency)) then s_transparency=Self.s_transparency
if (arg_present(s_antialias)) then s_antialias=Self.s_antialias
if (arg_present(s_color)) then s_color=Self.s_color
if (arg_present(s_errorbar_color)) then s_errorbar_color=Self.s_errorbar_color
if (arg_present(s_use_default_color)) then s_use_default_color=Self.s_use_default_color 
if (arg_present(s_sym_increment)) then s_sym_increment=Self.s_sym_increment 
if (arg_present(s_sym_index)) then s_sym_index=Self.s_sym_index 
if (arg_present(s_sym_size)) then s_sym_size=Self.s_sym_size 
if (arg_present(s_sym_color)) then s_sym_color=Self.s_sym_color 
if (arg_present(s_sym_thick)) then s_sym_thick=Self.s_sym_thick 
if (arg_present(s_y_errorbars)) then s_y_errorbars=Self.s_y_errorbars
if (arg_present(s_linestyle)) then s_linestyle=Self.s_linestyle
if (arg_present(s_thick)) then s_thick=Self.s_thick
if (arg_present(s_sym_filled)) then s_sym_filled=Self.s_sym_filled
if (arg_present(s_sym_fill_color)) then s_sym_fill_color=Self.s_sym_fill_color
if (arg_present(s_font_name)) then s_font_name=Self.s_font_name
if (arg_present(s_font_size)) then s_font_size=Self.s_font_size
if (arg_present(s_text_color)) then s_text_color=Self.s_text_color
if (arg_present(b_errorbar_capsize)) then b_errorbar_capsize=Self.b_errorbar_capsize
if (arg_present(b_transparency)) then b_transparency=Self.b_transparency
if (arg_present(b_antialias)) then b_antialias=Self.b_antialias
if (arg_present(b_color)) then b_color=Self.b_color
if (arg_present(b_errorbar_color)) then b_errorbar_color=Self.b_errorbar_color
if (arg_present(b_use_default_color)) then b_use_default_color=Self.b_use_default_color
if (arg_present(b_sym_increment)) then b_sym_increment=Self.b_sym_increment
if (arg_present(b_sym_index)) then b_sym_index=Self.b_sym_index
if (arg_present(b_sym_size)) then b_sym_size=Self.b_sym_size
if (arg_present(b_sym_color)) then b_sym_color=Self.b_sym_color
if (arg_present(b_sym_thick)) then b_sym_thick=Self.b_sym_thick
if (arg_present(b_y_errorbars)) then b_y_errorbars=Self.b_y_errorbars
if (arg_present(b_linestyle)) then b_linestyle=Self.b_linestyle
if (arg_present(b_thick)) then b_thick=Self.b_thick
if (arg_present(b_sym_filled)) then b_sym_filled=Self.b_sym_filled
if (arg_present(b_sym_fill_color)) then b_sym_fill_color=Self.b_sym_fill_color
if (arg_present(b_sym_fill_color)) then f_errorbar_capsize=Self.f_errorbar_capsize
if (arg_present(b_font_name)) then b_font_name=Self.b_font_name
if (arg_present(b_font_size)) then b_font_size=Self.b_font_size
if (arg_present(b_text_color)) then b_text_color=Self.b_text_color
if (arg_present(f_transparency)) then f_transparency=Self.f_transparency
if (arg_present(f_antialias)) then f_antialias=Self.f_antialias
if (arg_present(f_color)) then f_color=Self.f_color
if (arg_present(f_errorbar_color)) then f_errorbar_color=Self.f_errorbar_color
if (arg_present(f_use_default_color)) then f_use_default_color=Self.f_use_default_color
if (arg_present(f_sym_increment)) then f_sym_increment=Self.f_sym_increment
if (arg_present(f_sym_index)) then f_sym_index=Self.f_sym_index
if (arg_present(f_sym_size)) then f_sym_size=Self.f_sym_size
if (arg_present(f_sym_color)) then f_sym_color=Self.f_sym_color
if (arg_present(f_sym_thick)) then f_sym_thick=Self.f_sym_thick
if (arg_present(f_y_errorbars)) then f_y_errorbars=Self.f_y_errorbars
if (arg_present(f_linestyle)) then f_linestyle=Self.f_linestyle
if (arg_present(f_thick)) then f_thick=Self.f_thick
if (arg_present(f_sym_filled)) then f_sym_filled=Self.f_sym_filled
if (arg_present(f_sym_fill_color)) then f_sym_fill_color=Self.f_sym_fill_color
if (arg_present(f_font_name)) then f_font_name=Self.f_font_name
if (arg_present(f_font_size)) then f_font_size=Self.f_font_size
if (arg_present(f_text_color)) then f_text_color=Self.f_text_color
if (arg_present(ff_transparency)) then ff_transparency=Self.ff_transparency
if (arg_present(ff_antialias)) then ff_antialias=Self.ff_antialias
if (arg_present(ff_color)) then ff_color=Self.ff_color
if (arg_present(ff_use_default_color)) then ff_use_default_color=Self.ff_use_default_color
if (arg_present(ff_sym_index)) then ff_sym_index=Self.ff_sym_index
if (arg_present(ff_linestyle)) then ff_linestyle=Self.ff_linestyle
if (arg_present(ff_thick)) then ff_thick=Self.ff_thick
if (arg_present(sb_transparency)) then sb_transparency=Self.sb_transparency
if (arg_present(sb_antialias)) then sb_antialias=Self.sb_antialias
if (arg_present(sb_color)) then sb_color=Self.sb_color
if (arg_present(sb_use_default_color)) then sb_use_default_color=Self.sb_use_default_color
if (arg_present(sb_sym_index)) then sb_sym_index=Self.sb_sym_index
if (arg_present(sb_linestyle)) then sb_linestyle=Self.sb_linestyle
if (arg_present(sb_thick)) then sb_thick=Self.sb_thick


; Preferences structure
if (arg_present(preferences)) then begin
   if (ptr_valid(Self.prefsPtr)) then begin
      preferences = (*self.prefsPtr)

      ; update the preferences structure
      ntags = n_tags(preferences)
      tags = tag_names(preferences)
      for i=0,ntags-1 do begin
         status = Self->GetPropertyByIdentifier(tags[i], value)
         if (status) then preferences.(i) = strjoin(strtrim(string(value),2),',')
      endfor
   endif
endif
; modifiedStatus
if (arg_present(modifiedStatus)) then modifiedStatus = self.modifiedFlag
; nameTag
if (arg_present(nameTag)) then nameTag = self.nameTag
; prompt
if (arg_present(prompt)) then prompt = self.prompt
; prompt Title
if (arg_present(prmptTitle)) then prmptTitle = self.promptTitle
; prompt Desc
if (arg_present(prmptDesc)) then prmptDesc = self.promptDesc
;
if (arg_present(ssfactor)) then ssfactor = Self.ssfactor
;
if (Arg_present(autoScaleFlag)) then autoScaleFlag = Self.autoScaleFlag
;
if (Arg_present(plotFlag)) then plotFlag = Self.plotFlag
;
if (Arg_present(detMaskString)) then detMaskString = Self.detMaskString
;
if (Arg_present(detsInGroup1)) then detsInGroup1 = Self.detsInGroup1
;
if (Arg_present(detGroupFlag)) then detGroupFlag = Self.detGroupFlag
;
if (Arg_present(nSamp)) then nSamp = Self.nSamp
;
if (arg_present(nBkgd)) then nBkgd = Self.nBkgd
;
if (arg_present(nVan)) then nVan = Self.nVan
;
if (Arg_present(nosSampFolder)) then nosSampFolder = Self.nosSampFolder
;
if (arg_present(sampFoldCont)) then sampFoldCont = Self.sampFoldCont
;
if (Arg_present(sampSelected)) then sampSelected = Self.sampSelected
;
if (arg_present(bkgdSelected)) then bkgdSelected = Self.bkgdSelected
;
if (arg_present(vanSelected)) then vanSelected = Self.vanSelected
;
if (arg_present(sampContRef)) then sampContRef = Self.sampContRef
;
if (arg_present(bkgdContRef)) then bkgdContRef = Self.bkgdContRef
;
if (arg_present(vanContRef)) then vanContRef = Self.vanContRef
;
if (arg_present(sumSampFlag)) then sumSampFlag = Self.sumSampFlag
;
if (arg_present(sumBkgdFlag)) then sumBkgdFlag = Self.sumBkgdFlag
;
if (arg_present(bkgdFlag)) then bkgdFlag = Self.bkgdFlag
;
if (arg_present(vanFlag)) then vanFlag = Self.vanFlag
;
if (arg_present(dataDir)) then dataDir = Self.dataDir
;
if (arg_present(oplotVanFitFlag)) then oplotVanFitFlag = Self.oplotVanFitFlag
;
if (arg_present(oplotBkgdFlag)) then oplotBkgdFlag = Self.oplotBkgdFlag
;
if (arg_present(ftpObject)) then ftpObject = Self.ftpObject
;
;if (arg_present(sampTypeFlag)) then sampTypeFlag = Self.sampTypeFlag
;
if (arg_present(xAxisVar)) then xAxisVar = Self.xAxisVar
;
if (arg_present(yAxisVar)) then yAxisVar = Self.yAxisVar
;
if (ARG_PRESENT(nGroups)) then nGroups = Self.nGroups
;
if (ARG_PRESENT(grpScaleFactors)) then grpScaleFactors = Self.grpScaleFactors
;
if (ARG_PRESENT(grpscaleFacStr)) then grpscaleFacStr = Self.grpscaleFacStr
;
if (ARG_PRESENT(grpNos)) then grpNos = Self.grpNos
;
if (ARG_PRESENT(monNormFlag)) then monNormFlag = Self.monNormFlag
;
;if (arg_present(indepVar1List)) then indepVar1List = (*Self.indepVars1Ptr)
;;
;if (arg_present(indepVar12List)) then indepVar2List = (*Self.indepVars2Ptr)
;;
;if (arg_present(indepVar2List)) then indepVar2List = (*Self.indepVars2Ptr)
;
if (arg_present(history)) then history = (*Self.historyPtr)
;
if (arg_present(detGroupings)) then detGroupings = (*Self.detGroupings)
;
if (arg_present(selectedIDs) || arg_present(nSelectedIDs)) then begin
   oUI = Self->GetUI()
   oUI->GetProperty, group_leader = wTLB
   wChild = WIDGET_INFO(wTLB, /CHILD)
   WIDGET_CONTROL, wChild, GET_UVALUE=sPtr
   ; retrieve list of all _selected_ datasets from the data manager
   wDM = (*sPtr).wDM ; the data manager widget ID
   widget_control, wDM, get_uvalue=sPtrDM ; the data manager state ptr
   selectedIDs = (*(*sPtrDM).pdataids)  ; currently selected identifiers
   nSelectedIDs = n_elements(selectedIDs)
   if (selectedIDs[0] eq '') then nSelectedIDs = 0
endif

; Call base class method
if (n_elements(etc) gt 0) then $
  self->IDLitTool::GetProperty, _EXTRA=etc

end


;-------------------------------------------------------------------------------
pro HfbsTool::SetProperty, nameTag=nameTag, prompt=prompt,preferences=preferences, _EXTRA=etc $
 ,monScaleFlag=monScaleFlag,maskFlag=maskFlag,bkgdFlag=bkgdFlag, detsInGroup1=detsInGroup1 $
 ,sumSampFlag=sumSampFlag,sumBkgdFlag=sumBkgdFlag,vanFlag=vanFlag, data_directory=dataDir, daveTool=daveTool $
 ,nSamp=nSamp,nBkgd=nBkgd,nVan=nVan,vanparams=vanparams,detMaskString=detMaskString,detGroupFlag=detGroupFlag $
 ,sampSelected=sampSelected, bkgdSelected=bkgdSelected, vanSelected=vanSelected, modifiedStatus=modifiedStatus $
 ,xAxisVar=xAxisVar,yAxisVar=yAxisVar, sampTypeFlag=sampTypeFlag, plotFlag=plotFlag $
 ,ssfactor=ssfactor,autoScaleFlag=autoScaleFlag, logFlag=logFlag $
 ,grpNos=grpNos, detGroupings=detGroupings $
 ,grpScaleFactors=grpScaleFactors, grpscaleFacStr=grpscaleFacStr, nGroups=nGroups, monNormFlag=monNormFlag $
 ,s_errorbar_capsize=s_errorbar_capsize $
 ,s_transparency=s_transparency $
 ,s_antialias=s_antialias $
 ,s_color=s_color $
 ,s_errorbar_color=s_errorbar_color $
 ,s_use_default_color=s_use_default_color $
 ,s_sym_increment=s_sym_increment $
 ,s_sym_index=s_sym_index $
 ,s_sym_size=s_sym_size $
 ,s_sym_color=s_sym_color $
 ,s_sym_thick=s_sym_thick $
 ,s_y_errorbars=s_y_errorbars $
 ,s_linestyle=s_linestyle $
 ,s_thick=s_thick $
 ,s_sym_filled=s_sym_filled $
 ,s_sym_fill_color=s_sym_fill_color $
 ,s_font_name=s_font_name  $
 ,s_font_size=s_font_size $
 ,s_text_color=s_text_color  $
 ,b_errorbar_capsize=b_errorbar_capsize $
 ,b_transparency=b_transparency $
 ,b_antialias=b_antialias $
 ,b_color=b_color $
 ,b_errorbar_color=b_errorbar_color $
 ,b_use_default_color=b_use_default_color $
 ,b_sym_increment=b_sym_increment $
 ,b_sym_index=b_sym_index $
 ,b_sym_size=b_sym_size $
 ,b_sym_color=b_sym_color $
 ,b_sym_thick=b_sym_thick $
 ,b_y_errorbars=b_y_errorbars $
 ,b_linestyle=b_linestyle $
 ,b_thick=b_thick $
 ,b_sym_filled=b_sym_filled $
 ,b_sym_fill_color=b_sym_fill_color $
 ,b_font_name=b_font_name  $
 ,b_font_size=b_font_size $
 ,b_text_color=b_text_color  $
 ,f_errorbar_capsize=f_errorbar_capsize $
 ,f_transparency=f_transparency $
 ,f_antialias=f_antialias $
 ,f_color=f_color $
 ,f_errorbar_color=f_errorbar_color $
 ,f_use_default_color=f_use_default_color $
 ,f_sym_increment=f_sym_increment $
 ,f_sym_index=f_sym_index $
 ,f_sym_size=f_sym_size $
 ,f_sym_color=f_sym_color $
 ,f_sym_thick=f_sym_thick $
 ,f_y_errorbars=f_y_errorbars $
 ,f_linestyle=f_linestyle $
 ,f_thick=f_thick $
 ,f_sym_filled=f_sym_filled $
 ,f_sym_fill_color=f_sym_fill_color $
 ,f_font_name=f_font_name  $
 ,f_font_size=f_font_size $
 ,f_text_color=f_text_color  $
 ,ff_transparency=ff_transparency $
 ,ff_antialias=ff_antialias $
 ,ff_color=ff_color $
 ,ff_use_default_color=ff_use_default_color $
 ,ff_sym_index=ff_sym_index $
 ,ff_linestyle=ff_linestyle $
 ,ff_thick=ff_thick $
 ,sb_transparency=sb_transparency $
 ,sb_antialias=sb_antialias $
 ,sb_color=sb_color $
 ,sb_use_default_color=sb_use_default_color $
 ,sb_sym_index=sb_sym_index $
 ,sb_linestyle=sb_linestyle $
 ,sb_thick=sb_thick

compile_opt idl2

if n_elements(s_errorbar_capsize) then Self.s_errorbar_capsize=s_errorbar_capsize
if n_elements(s_transparency) then Self.s_transparency=s_transparency
if n_elements(s_antialias) then Self.s_antialias=s_antialias
if n_elements(s_color) then Self.s_color=s_color
if n_elements(s_errorbar_color) then Self.s_errorbar_color=s_errorbar_color
if n_elements(s_use_default_color) then Self.s_use_default_color=s_use_default_color 
if n_elements(s_sym_increment) then Self.s_sym_increment=s_sym_increment 
if n_elements(s_sym_index) then Self.s_sym_index=s_sym_index 
if n_elements(s_sym_size) then Self.s_sym_size=s_sym_size 
if n_elements(s_sym_color) then Self.s_sym_color=s_sym_color 
if n_elements(s_sym_thick) then Self.s_sym_thick=s_sym_thick 
if n_elements(s_y_errorbars) then Self.s_y_errorbars=s_y_errorbars
if n_elements(s_linestyle) then Self.s_linestyle=s_linestyle
if n_elements(s_thick) then Self.s_thick=s_thick
if n_elements(s_sym_filled) then Self.s_sym_filled=s_sym_filled
if n_elements(s_sym_fill_color) then Self.s_sym_fill_color=s_sym_fill_color
if n_elements(s_font_name) then Self.s_font_name=s_font_name
if n_elements(s_font_size) then Self.s_font_size=s_font_size
if n_elements(s_text_color) then Self.s_text_color=s_text_color
if n_elements(b_errorbar_capsize) then Self.b_errorbar_capsize=b_errorbar_capsize
if n_elements(b_transparency) then Self.b_transparency=b_transparency
if n_elements(b_antialias) then Self.b_antialias=b_antialias
if n_elements(b_color) then Self.b_color=b_color
if n_elements(b_use_default_color) then Self.b_use_default_color=b_use_default_color
if n_elements(b_errorbar_color) then Self.b_errorbar_color=b_errorbar_color
if n_elements(b_sym_increment) then Self.b_sym_increment=b_sym_increment
if n_elements(b_sym_index) then Self.b_sym_index=b_sym_index
if n_elements(b_sym_size) then Self.b_sym_size=b_sym_size
if n_elements(b_sym_color) then Self.b_sym_color=b_sym_color
if n_elements(b_sym_thick) then Self.b_sym_thick=b_sym_thick
if n_elements(b_y_errorbars) then Self.b_y_errorbars=b_y_errorbars
if n_elements(b_linestyle) then Self.b_linestyle=b_linestyle
if n_elements(b_thick) then Self.b_thick=b_thick
if n_elements(b_sym_filled) then Self.b_sym_filled=b_sym_filled
if n_elements(b_sym_fill_color) then Self.b_sym_fill_color=b_sym_fill_color
if n_elements(b_font_name) then Self.b_font_name=b_font_name
if n_elements(b_font_size) then Self.b_font_size=b_font_size
if n_elements(b_text_color) then Self.b_text_color=b_text_color
if n_elements(f_errorbar_capsize) then Self.f_errorbar_capsize=f_errorbar_capsize
if n_elements(f_transparency) then Self.f_transparency=f_transparency
if n_elements(f_antialias) then Self.f_antialias=f_antialias
if n_elements(f_color) then Self.f_color=f_color
if n_elements(f_errorbar_color) then Self.f_errorbar_color=f_errorbar_color
if n_elements(f_use_default_color) then Self.f_use_default_color=f_use_default_color
if n_elements(f_sym_increment) then Self.f_sym_increment=f_sym_increment
if n_elements(f_sym_index) then Self.f_sym_index=f_sym_index
if n_elements(f_sym_size) then Self.f_sym_size=f_sym_size
if n_elements(f_sym_color) then Self.f_sym_color=f_sym_color
if n_elements(f_sym_thick) then Self.f_sym_thick=f_sym_thick
if n_elements(f_y_errorbars) then Self.f_y_errorbars=f_y_errorbars
if n_elements(f_linestyle) then Self.f_linestyle=f_linestyle
if n_elements(f_thick) then Self.f_thick=f_thick
if n_elements(f_sym_filled) then Self.f_sym_filled=f_sym_filled
if n_elements(f_sym_fill_color) then Self.f_sym_fill_color=f_sym_fill_color
if n_elements(f_font_name) then Self.f_font_name=f_font_name
if n_elements(f_font_size) then Self.f_font_size=f_font_size
if n_elements(f_text_color) then Self.f_text_color=f_text_color
if n_elements(ff_transparency) then Self.ff_transparency=ff_transparency
if n_elements(ff_antialias) then Self.ff_antialias=ff_antialias
if n_elements(ff_color) then Self.ff_color=ff_color
if n_elements(ff_use_default_color) then Self.ff_use_default_color=ff_use_default_color
if n_elements(ff_sym_index) then Self.ff_sym_index=ff_sym_index
if n_elements(ff_linestyle) then Self.ff_linestyle=ff_linestyle
if n_elements(ff_thick) then Self.ff_thick=ff_thick
if n_elements(sb_transparency) then Self.sb_transparency=sb_transparency
if n_elements(sb_antialias) then Self.sb_antialias=sb_antialias
if n_elements(sb_color) then Self.sb_color=sb_color
if n_elements(sb_use_default_color) then Self.sb_use_default_color=sb_use_default_color
if n_elements(sb_sym_index) then Self.sb_sym_index=sb_sym_index
if n_elements(sb_linestyle) then Self.sb_linestyle=sb_linestyle
if n_elements(sb_thick) then Self.sb_thick=sb_thick

; DAVETool
if (n_elements(daveTool) && obj_valid(daveTool) && obj_isa(daveTool,'DAVETool')) then $
  Self.daveTool = daveTool

; Preferences
if (n_elements(preferences)) then begin
   if (strcmp(size(preferences,/tname),'STRUCT')) then begin
      ntags = n_tags(preferences)
      tags = tag_names(preferences)
      index = indgen(ntags)
      
      ; handle color tags - convert string to byte array, eg '0,128,255' to [0,128,255]
      spIndex = where(strmatch(tags,'*color*',/fold) eq 1, spCnt, complement=index, ncomplement=theRest)
      if (spCnt gt 0) then begin
         for i=0,spCnt-1 do begin
            strColor = preferences.(spIndex[i])
            bytColor = fix(strsplit(strColor,',',/extract))
            Self->SetPropertyByIdentifier, tags[spIndex[i]], bytColor
         endfor
      endif

      ; all other tags
      for i=0,theRest-1 do begin
         if (strcmp(tags[index[i]],'grpScaleFactors',/fold)) then begin
            ; another special case (grpScaleFactors) - convert string to 16 element float array
            strSF = preferences.(index[i])
            fltSF = float(strsplit(strSF,',',/extract))
            Self.grpscaleFacStr = strSF
            Self.grpScaleFactors = fltSF
         endif else $
            Self->SetPropertyByIdentifier, tags[index[i]], preferences.(index[i])
      endfor
      
      ; Need further to assign some userdef attribute for user-defined properties
      ; in order for property sheet to reflect updated value
      uProps = ['MASKEDDETS']
      n = n_elements(uProps)
      for i = 0,n-1 do begin
         index = where(strcmp(tags,uProps[i]), found)
         if (found) then $
            Self->SetPropertyAttribute, uProps[i],userdef=preferences.(index)
      endfor
      
      ; Finally, store the preferences structure
      if (ptr_valid(Self.prefsPtr)) then (*Self.prefsPtr) = preferences $
      else Self.prefsPtr = ptr_new(preferences)
   endif
endif

; modifiedStatus
if (n_elements(modifiedStatus)) then Self.modifiedFlag = (fix(modifiedStatus) gt 0)? 1 : 0
; nameTag
if (n_elements(nameTag)) then Self.nameTag = strtrim(nameTag,2)
; prompt
if (n_elements(prompt)) then begin
   Self.prompt = prompt
   if (prompt eq 0) then Self._bDirty = 0
endif
;
if (N_elements(logFlag) gt 0) then Self.logFlag = logFlag
;
if (n_elements(ssfactor)) then Self.ssfactor = ssfactor
;
if (N_elements(autoScaleFlag)) then Self.autoScaleFlag = autoScaleFlag
;
if (N_elements(plotFlag)) then Self.plotFlag = plotFlag
;
if (N_elements(detMaskString)) then Self.detMaskString = detMaskString
;
if (N_elements(detsInGroup1)) then begin
  ; Check input and modify as needed
  if (Strcmp(Strtrim(detsInGroup1),'')) then detsInGroup1 = '1'
  ; also, for HFBS, the detectors must range from 1 to 16 only
  void = Compactstring2intvector(detsInGroup1,detIndex)
  myindex = Where(detIndex ge 1 and detIndex le 16, cnt)  ; note use of 'and' instead of the logical '&&'
  if (cnt lt 1) then begin
    detsInGroup1 = '1-16'
  endif else begin
    detIndex = detIndex[myindex]
    status = Intvector2compactstring(detIndex, detsInGroup1)
  endelse
  Self.detsInGroup1 = detsInGroup1
endif
;
if (N_elements(detGroupFlag)) then Self.detGroupFlag = detGroupFlag
;
if (N_elements(monScaleFlag)) then Self.monScaleFlag = monScaleFlag
;
if (n_elements(sumSampFlag)) then Self.sumSampFlag = sumSampFlag
;
if (n_elements(sumBkgdFlag)) then Self.sumBkgdFlag = sumBkgdFlag
;
if (n_elements(maskFlag)) then Self.maskFlag = maskFlag
;
if (n_elements(bkgdFlag)) then Self.bkgdFlag = bkgdFlag
;
if (n_elements(vanFlag)) then Self.vanFlag = vanFlag
;
if (n_elements(dataDir)) then Self.dataDir = dataDir
;
if (n_elements(nSamp)) then Self.nSamp = nSamp
;
if (n_elements(nBkgd)) then Self.nBkgd = nBkgd
;
if (n_elements(nVan)) then Self.nVan = nVan
;
if (n_elements(sampSelected)) then Self.sampSelected = sampSelected
;
if (n_elements(bkgdSelected)) then Self.bkgdSelected = bkgdSelected
;
if (n_elements(vanSelected)) then Self.vanSelected = vanSelected
;
if (n_elements(oplotVanFitFlag)) then Self.oplotVanFitFlag = oplotVanFitFlag
;
if (n_elements(oplotBkgdFlag)) then Self.oplotBkgdFlag = oplotBkgdFlag
;
;if (n_elements(sampTypeFlag)) then begin
;   Self.sampTypeFlag = sampTypeFlag
;   
;   Self->UpdatePropertySheet
;endif
;
if (n_elements(xAxisVar)) then Self.xAxisVar = xAxisVar
;
if (n_elements(yAxisVar)) then Self.yAxisVar = yAxisVar
;
if (N_ELEMENTS(grpNos) gt 0) then Self.grpNos = grpNos
;
if (N_ELEMENTS(grpScaleFactors) gt 0) then Self.grpScaleFactors = grpScaleFactors
;
if (N_ELEMENTS(grpscaleFacStr) gt 0) then begin
  Self.grpscaleFacStr = grpscaleFacStr
  Self.grpScaleFactors = float(strsplit(grpscaleFacStr,',',/extract))
endif
;
if (N_ELEMENTS(nGroups) gt 0) then Self.nGroups = nGroups
;
if (n_elements(detGroupings) gt 0) then (*Self.detGroupings) = detGroupings 
;
if (N_ELEMENTS(monNormFlag) gt 0) then Self.monNormFlag = monNormFlag

; Call base class method
if (n_elements(etc) gt 0) then $
  self->IDLitTool::SetProperty, _EXTRA=etc

end


;===============================================================================
; HfbsTool::deleteAllDatasets
;
; PURPOSE:
;   Delete all datasets currently loaded
;
; PARAMETERS:
;
; RETURN VALUE:
;
function HfbsTool::DeleteAllDatasets, _EXTRA=etc
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

wDM = (*sPtr).wDM
widget_control, wDM, get_uvalue=sPtrDM

cw_hfbsDataManager_DeleteData, sPtrDM, wDM, /delall, _EXTRA=etc

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::loadSamp
;
; PURPOSE:
;   Specify and load sample data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
;
function HfbsTool::GetFileList, title, count, fromFTP=fromFTP, filter=filter $
                                ,multiple_files=multiple_files, path=path, newPath=newPath

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

if (keyword_set(fromFTP)) then begin
  Self->GetProperty, ftpObject=oFTP
  if (n_elements(filter) eq 0) then filter = ['*.hfbs','*.*']
  files = Dialog_NCNRpublicData(oFTP,title=title,filter=filter,group_leader=wTLB,count=count)
endif else begin
  if (n_elements(filter) eq 0) then filter = '*.hfbs'
  if (n_elements(multiple_files) eq 0) then multiple_files=1
  if (n_elements(path) eq 0) then Self->GetProperty, data_directory=path
  if (n_elements(title) eq 0) then title='Specify files to load'
  
  files = dialog_pickfile(title=title,multiple_files=multiple_files,/must_exist, dialog_parent=wTLB $
                         ,filter=filter,path=path, get_path=newPath)
  
  if (files[0] eq '') then begin
     count = 0
     return, ''
  endif
  
  count = n_elements(files)
  ;Self->SetProperty, data_directory=newPath
endelse

return, files

end
;-------------------------------------------------------------------------------



;===============================================================================
; HfbsTool::refreshPropertySheet
;
; PURPOSE:
;   Refresh the propertysheet UI
;
; PARAMETERS:
;
; KEYWORDS:
;
pro HfbsTool::RefreshPropertySheet

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

widget_control, (*sPtr).wPS, /refresh_property

end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::loadVanFtp
;
; PURPOSE:
;   Specify and load van bkgd data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function HfbsTool::loadVanFtp

return, Self->LoadVan(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::loadVan
;
; PURPOSE:
;   Select and load Bkgd data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
; 
;   dataObject - specifies the data object whose data is to be reloaded
;   
;   reload  - set if the data specified by the dataObject keyword is to be reloaded
;   
;   fromFTP - set if the source of the datafile to be loaded is the FTP server
;-
function HfbsTool::loadVan, reload=reload, dataObject=oItem, fromFTP=fromFTP

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'HfbsTool::loadVan: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

reloading = Keyword_set(reload)
if (reloading) then begin
  if (~Obj_valid(oItem)) then Return, 0
  oItem->Getproperty, description=files
  count = 1
  void = oItem->Getmetadata('FROMFTP',fromFtp)
endif else begin
  ; Let user specify files to load
  title = 'Select Vanadium Calibration Files to Load'

  files = Self->Getfilelist(title,count,fromFTP=fromFTP,newPath=newPath,filter=['*.hfbs'])
  if (count eq 0) then Return, 0
  if (N_elements(newPath) gt 0) then Self->Setproperty, data_directory=newPath
endelse

; switch on the busy symbol for cursor
widget_control, /HOURGLASS

; Read the contents of the data files and make entries in the 'Bacground' tab of the data manager
Self->GetProperty, sumVanFlag=sumFlag, vanContRef=oCont, nVan=nData
for i=0, count-1 do begin
  filename = files[i]
  if (~Self->Readdata(filename, dataHash, fromFTP=fromFTP)) then continue
  if (~Self->Updatecalculation(dataHash=dataHash, /bkgdData)) then continue

  basename = File_basename(filename,'.hfbs',/fold_case)

  if (~reloading) then begin
    ;; create new object and attach dataPtr
    oItem = Obj_new('IDLitParameterSet',name=basename,description=filename,type='van')
    oItem->Addmetadata,'DATAHASH',Ptr_new(dataHash) ; stuff the datahash as a heap var; note cannot store a hash directoy as a metadata!
    oItem->Addmetadata,'FROMFTP',Keyword_set(fromFTP)

    ; iTools does not handle '_[0-9]' characters in identifiers well eg _0, _1, etc
    ; replace all '_' with '-'
    oItem->Getproperty, identifier=idd
    hasChanged = 0
    while ((pos = Stregex(idd,'_[0-9]')) ne -1) do begin
      Strput, idd,'-',pos
      hasChanged = 1
    endwhile
    if (Strmatch(idd,'[0-9]*')) then begin   ; if first char is a number
      idd = 'id'+idd
      hasChanged = 1
    endif
    if (hasChanged) then oItem->Setproperty,identifier=idd

    ; Add to the Vanadium tab of the data manager
    Self->AddByIdentifier, 'Van Data Manager', oItem

    ; Create Place holder objects for x-axis, y-axis and error to be used later for plotting
    oZ = Idlitdata(name='Dependent')
    oZ->Addmetadata,'Long_name','Detector Counts'
    oZ->Addmetadata,'Units',''
    oZ->Addmetadata,'Signal', 1
    oX = Idlitdata(name='Independent')
    oE = Idlitdata(name='Error')
    oItem->Add, [oZ,oX,oE], parameter_name=['Dependent','Independent','Error']
  endif else begin
    ;; simply replace previous dataHash with updated one
    void = oItem->Getmetadata('DATAHASH',pDataHash)
    if (Ptr_valid(pDataHash)) then Heap_free, pDataHash
    oItem->Addmetadata,'DATAHASH',Ptr_new(dataHash)
  endelse

  if (~reloading) then begin
    oCont->Add, oItem
    Self.nVan++
  endif
endfor



; Now combine data within Vanadium Tab and stuff the combined data hash structure
; as a 'DATAHASH' meta in the first data object
oItems = oCont->Get(/all,count=nItems)
if (nItems gt 0) then begin
  hashArr = []
  for i=0,nItems-1 do begin
    void = oItems[i]->Getmetadata('DATAHASH',pDataHash)
    hashArr = [hashArr,*pDataHash]
  endfor
  combDataHash = Self->Combinedatasets(hashArr)
  if (Obj_valid(combDataHash)) then oItems[0]->Addmetadata,'COMBDATAHASH',Ptr_new(combDataHash)
  void = Self->Updatecalculation(dataHash=combDataHash, /bkgdData)
endif

Self->Setpropertyattribute, 'VANFLAG', sensitive=(Self.nVan gt 0)
Self->Refreshpropertysheet   ; force prop sheet to update

; Since van datasets have changed, need to update the sample calculations
Self->UpdateAllDatasets, /doFromBkgd

Self.modifiedFlag = 1
Self->Enableupdates
return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::loadBkgdFtp
;
; PURPOSE:
;   Specify and load bkgd data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function Hfbstool::loadBkgdFtp

  Return, Self->Loadbkgd(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::loadBkgd
;
; PURPOSE:
;   Select and load Bkgd data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
;
;   dataObject - specifies the data object whose data is to be reloaded
;
;   reload  - set if the data specified by the dataObject keyword is to be reloaded
;
;   fromFTP - set if the source of the datafile to be loaded is the FTP server
;-
function Hfbstool::loadBkgd, reload=reload, dataObject=oItem, fromFTP=fromFTP

oUI = Self->Getui()
oUI->Getproperty, group_leader = wTLB

; Basic error Handler
if (N_elements(!debug) && (!debug eq 0)) then begin
  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'HfbsTool::loadBkgd: Error encountered'
    eMsg = 'An error or unusual condition was encountered!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
    Catch, /cancel
    Return, 0
  endif
endif

reloading = Keyword_set(reload)
if (reloading) then begin
  if (~Obj_valid(oItem)) then Return, 0
  oItem->Getproperty, description=files
  count = 1
  void = oItem->Getmetadata('FROMFTP',fromFtp)
endif else begin
  ; Let user specify files to load
  title = 'Select Background Files to Load'

  files = Self->Getfilelist(title,count,fromFTP=fromFTP,newPath=newPath,filter=['*.hfbs'])
  if (count eq 0) then Return, 0
  if (N_elements(newPath) gt 0) then Self->Setproperty, data_directory=newPath
endelse

; switch on the busy symbol for cursor
Widget_control, /HOURGLASS

; Read the contents of the data files and make entries in the 'Bacground' tab of the data manager
Self->Getproperty, sumBkgdFlag=sumFlag, bkgdContRef=oCont, nBkgd=nData
for i=0, count-1 do begin
  filename = files[i]
  if (~Self->Readdata(filename, dataHash, fromFTP=fromFTP)) then continue
  if (~Self->Updatecalculation(dataHash=dataHash, /bkgdData)) then continue

  basename = File_basename(filename,'.hfbs',/fold_case)

  if (~reloading) then begin
    ;; create new object and attach dataPtr
    oItem = Obj_new('IDLitParameterSet',name=basename,description=filename,type='bkgd')
    oItem->Addmetadata,'DATAHASH',Ptr_new(dataHash) ; stuff the datahash as a heap var; note cannot store a hash directoy as a metadata!
    oItem->Addmetadata,'FROMFTP',Keyword_set(fromFTP)

    ; iTools does not handle '_[0-9]' characters in identifiers well eg _0, _1, etc
    ; replace all '_' with '-'
    oItem->Getproperty, identifier=idd
    hasChanged = 0
    while ((pos = Stregex(idd,'_[0-9]')) ne -1) do begin
      Strput, idd,'-',pos
      hasChanged = 1
    endwhile
    if (Strmatch(idd,'[0-9]*')) then begin   ; if first char is a number
      idd = 'id'+idd
      hasChanged = 1
    endif
    if (hasChanged) then oItem->Setproperty,identifier=idd

    ; Add to the Background tab of the data manager
    Self->Addbyidentifier, 'Bkgd Data Manager', oItem

    ; Create Place holder objects for x-axis, y-axis and error to be used later for plotting
    oZ = Idlitdata(name='Dependent')
    oZ->Addmetadata,'Long_name','Detector Counts'
    oZ->Addmetadata,'Units',''
    oZ->Addmetadata,'Signal', 1
    oX = Idlitdata(name='Independent')
    oE = Idlitdata(name='Error')
    oItem->Add, [oZ,oX,oE], parameter_name=['Dependent','Independent','Error']
  endif else begin
    ;; simply replace previous dataHash with updated one
    void = oItem->Getmetadata('DATAHASH',pDataHash)
    if (Ptr_valid(pDataHash)) then Heap_free, pDataHash
    oItem->Addmetadata,'DATAHASH',Ptr_new(dataHash)
  endelse

  if (~reloading) then begin
    oCont->Add, oItem
    Self.nBkgd++
  endif
endfor



; Now combine data within Background Tab and stuff the combined data hash structure
; as a 'DATAHASH' meta in the first data object
oItems = oCont->Get(/all,count=nItems)
if (nItems gt 0) then begin
  hashArr = []
  for i=0,nItems-1 do begin
    void = oItems[i]->Getmetadata('DATAHASH',pDataHash)
    hashArr = [hashArr,*pDataHash]
  endfor
  combDataHash = Self->Combinedatasets(hashArr)
  if (Obj_valid(combDataHash)) then oItems[0]->Addmetadata,'COMBDATAHASH',Ptr_new(combDataHash)
  void = Self->Updatecalculation(dataHash=combDataHash, /bkgdData)
endif

Self->Setpropertyattribute, 'BKGDFLAG', sensitive=(Self.nBkgd gt 0)
Self->Refreshpropertysheet   ; force prop sheet to update

; Since bkgd datasets have changed, need to update the sample calculations
Self->UpdateAllDatasets, /doFromBkgd

Self.modifiedFlag = 1
Self->Enableupdates
Return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::DelSampFolder
;
; PURPOSE:
;   Add a new folder in the Data Manager section underneath 'Sample'
;
; PARAMETERS:
;
; KEYWORDS:
;   basename - a string to be used as a label/name for the created folder
;
;-
pro Hfbstool::DelSampFolder, oFolders, _EXTRA=etc
compile_opt idl2

oDM = Self->GetService("DATA_MANAGER")
nFolder = n_elements(oFolders)
Self->Getproperty, nSamp=nData, sampContRef=oCont
for i = 0,nFolder-1 do begin
  oFolder = oFolders[i]
  ; retrieve all datasets from this folder and delete them
  oItems = oFolder->Get(/all, count=nItems)
  for j = 0, nItems-1 do begin
    oItems[j]->GetProperty, type=type
    if (~strcmp(type,'samp',/fold)) then continue
    void = oItems[j]->Getmetadata('DATAHASH',pDataHash)
    if (Ptr_valid(pDataHash)) then Heap_free, pDataHash
    oCont->Remove, oItems[j]
    ;oFolder->Remove, oItems[j]
    nData--
  endfor
  Self.sampFoldCont->Remove, oFolder                     ; remove folder record from the samp fold container
  void = oDM->DeleteData(oFolder->GetFullIdentifier())   ; finally delete folder from data manager
  ;if (Obj_valid(oArr[i])) then Obj_destroy, oArr[i]   ; just a double check
  Self.nosSampFolder--
endfor
Self->Setproperty, nSamp=nData

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::AddSampFolder
;
; PURPOSE:
;   Add a new folder in the Data Manager section underneath 'Sample'
;
; PARAMETERS:
;
; KEYWORDS:
;   basename - a string to be used as a label/name for the created folder
;
;-
function HfbsTool::AddSampFolder, basename=basename, _EXTRA=etc
compile_opt idl2

oUI = Self->Getui()
oUI->Getproperty, group_leader = wTLB
; Basic error Handler
if (N_elements(!debug) && (!debug eq 0)) then begin
  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'HfbsTool::AddSampFolder: Error encountered'
    eMsg = 'An error or unusual condition was encountered!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
    Catch, /cancel
    Self->Enableupdates
    Return, 0
  endif
endif
if (n_elements(basename) eq 0 || basename eq '') then begin
  title = 'Name of new Folder to be created           '
  msg = 'Specify a name to associate with new folder'
  status = Self->Promptusertext(msg,newname,Title=title)
  if (status) then basename=newname else return, 0
endif
if (n_elements(basename) eq 0 || basename eq '') then basename = 'Sample Set'

desc = 'Sample Folder'
oItem = IDLitDataContainer(name=basename,description=desc,type='folder')

Self->AddByIdentifier, 'Sample Data Manager', oItem
Self.nosSampFolder++  ; increment count
Self.sampFoldCont->Add, oItem ; and record it

;; iTools does not handle '_[0-9]' characters in identifiers well eg _0, _1, etc
;; replace all '_' with '-'
;oItem->Getproperty, identifier=idd
;hasChanged = 0
;while ((pos = Stregex(idd,'_[0-9]')) ne -1) do begin
;  Strput, idd,'-',pos
;  hasChanged = 1
;endwhile
;if (Strmatch(idd,'[0-9]*')) then begin   ; if first char is a number
;  idd = 'id'+idd
;  hasChanged = 1
;endif
;if (hasChanged) then oItem->Setproperty,identifier=idd

return, 1

end
;;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::GetSelectedSamplefolder
;
; PURPOSE:
;   Return the currently selected sample folder according to the following logic
;   If a sample folder is directly selected, then return it
;   If anitem underneath a sample folder is selected then return the sample folder
;   if no sample folder is selected then return the most recent sample folder created
;   if no sample folder is selected and none exist then return null and an error message to the user asking them to create a sample folder
;
; PARAMETERS:
;
; KEYWORDS:
;-
function HfbsTool::GetSelectedSamplefolder, oItem
  compile_opt idl2

oFolder = !null
if (Self.nosSampFolder le 0) then begin
  title='No Sample Folder present'
  msg = 'You need to create a sample folder. A sample folder is used to'
  msg = [msg,'load and group multiple datasets that are expected to be the']
  msg = [msg,'same so that they can be summed and subsequently treated as a']
  msg = [msg,'single dataset and can be compared to data in another folder.']
  msg = [msg,'You should use the following menu to create folders as needed:']
  msg = [msg,'"Data Input -> Create Sample Folder" .']
  msg = [msg,'Do you want to create a sample folder now?']
  status = Self->Promptuseryesno(msg,answer,title=title)
  if (status ne 0 and answer eq 1) then begin
    status = Self->Addsampfolder()
  endif
  return, oFolder
endif

; If oItem exists then simply find then parent folder for this item and return it
if (obj_valid(oItem)) then begin
  ; find the first parent that is a folder
  oChild = oItem
  while (Obj_valid(oChild) && Obj_isa(oChild, 'IDLitData')) do begin
    oChild->Getproperty, _parent=oParent, type=childType
    if (Strcmp(childType,'samp',/fold)) then begin
      if (~Obj_valid(oParent)) then break
      oParent->Getproperty, type=type
      foldFound = Strcmp(type,'folder',/fold)
      oChild = oParent
      if (foldFound) then oFolder = oParent
    endif
    if foldFound then break
  endwhile
  return, oFolder
endif

Self->GetProperty, selectedIDs=selIDs,nSelectedIDs=nSel
if (nSel eq 0) then begin
  ; Nothing is selected, so find the last sample folder created and return it
  n = Self.sampFoldCont->Count()
  oFolder = Self.sampFoldCont->Get(position=(n-1))
  foldFound = 1
endif else begin
  foldFound = 0
  for i = 0, nSel-1 do begin
    oTmp = Self->GetByIdentifier(selIDs[i])
    if (Obj_valid(oTmp) && obj_isa(oTmp, 'IDLitData')) then $
      oTmp->GetProperty, type=type else type = ''
    foldFound = strcmp(type,'folder',/fold)
    if foldFound then break
  endfor
  if (foldFound) then begin
    oFolder = oTmp  ; the first selection that is a folder
  endif else begin
    ; non of the selections is a sample folder so only 2 options left
    ; - 1) the main Sample Dataset Manager Folder is selected. In 
    ;      this case, simple return the last sample folder created
    ; - 2) an actual dataset is selected so use the first parent of 
    ;      the selection that is a folder
    ; - 3) the selection is from the bkgd or van tabs - in this case
    ;      simply locate the last sample folder created and return it
    for i=0,nSel-1 do begin
      if foldFound then continue
      oChild = Self->GetByIdentifier(selIDs[i])
      if (Obj_valid(oChild) && obj_isa(oChild, 'IDLitDataManagerFolder')) then begin
        ; find the last sample folder created and return it
        n = Self.sampFoldCont->Count()
        oFolder = Self.sampFoldCont->Get(position=(n-1))
        foldFound = 1      
      endif else begin
        ; find the first parent that is a folder
        while (Obj_valid(oChild) && obj_isa(oChild, 'IDLitData')) do begin
          oChild->Getproperty, _parent=oParent, type=childType
          if (strcmp(childType,'samp',/fold)) then begin
            if (~Obj_valid(oParent)) then break
            oParent->Getproperty, type=type
            foldFound = Strcmp(type,'folder',/fold)            
            oChild = oParent
            if (foldFound) then oFolder = oParent
          endif else begin
            ; probably in vanadium or bkgd tab so retrieve the 
            ; Nothing is selected, so find the last sample folder created and return it
            n = Self.sampFoldCont->Count()
            oFolder = Self.sampFoldCont->Get(position=(n-1))
            foldFound = 1           
          endelse
          if foldFound then break
        endwhile        
      endelse
    endfor
  endelse  
endelse

if (~obj_valid(oFolder)) then begin
  ; if still not found and we have at least one folder available then return the latest folder created
  n = Self.sampFoldCont->Count()
  oFolder = Self.sampFoldCont->Get(position=(n-1))  
endif

return, oFolder

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::CombineDatasets
;
; PURPOSE:
;   Combine several HFBS datasets into a single dataset. The datasets to be combined are
;   specified using the hashArr keyword parameter and the combine results are stored in the
;   returned value of the function
;
; PARAMETERS:
;   hashArr - array of hashes containing the datasets to be combined
;
; KEYWORDS:
;
; RETURN VALUE:
;   - if successful, a hash structure containing the combined dataset
;   - if not successful, a null object
;-
function Hfbstool::CombineDatasets, hashArr
compile_opt idl2

oUI = Self->Getui()
oUI->Getproperty, group_leader = wTLB

; Basic error Handler
if (N_elements(!debug) && (!debug eq 0)) then begin
  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'HfbsTool::CombineDatasets: Error encountered'
    eMsg = 'An error or unusual condition was encountered!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
    Catch, /cancel
    Self->Enableupdates
    Return, 0
  endif
endif

index = where(obj_valid(hashArr), n)
if (n eq 0) then return, obj_new()

; make a new hash as an identical copy of te first one in the array
newHash = (hashArr[0])[*]  ; could also use hash(hashArr[0].Keys(), hashArr[0].Values(),/fold_case)

if (n eq 1) then return, newHash

counts = 0.0
temp = []
dopFreq = []
wbm = []
tbm = []
header = []
filename = []
user = []
startTime = []
stopTime = []

for i=0,n_elements(index)-1 do begin
  dataHash=hashArr[index[i]]

  counts = counts + dataHash['detCounts']

  filename = [filename,dataHash['filename']]
  header = [header,dataHash['header']]
  dopFreq = [dopFreq,dataHash['dopFreq']]
  wbm = [wbm,dataHash['wbm']]
  tbm = [tbm,dataHash['tbm']]
  temp = [temp,dataHash['temp']]
  user = [user,dataHash['user']]
  startTime = [startTime,dataHash['startTime']]
  stopTime = [stoptime,dataHash['stopTime']]
  ;timeBin = dataHash['timeBin']]
  ;cycleTime = dataHash['cycleTime']]
  ;numCycles = dataHash['numCycles']]
endfor
treatment = [systime(),'Dataset(s) included:']
treatment = [treatment,filename]

newHash['detCounts'] = counts
newHash['filename'] = filename
newHash['header'] = header
newHash['dopFreq'] = dopFreq
newHash['wbm'] = wbm
newHash['tbm'] = tbm
newHash['temp'] = temp
newHash['user'] = user
newHash['startTime'] = startTime
newHash['stopTime'] = stopTime
newHash['treatment'] = treatment

return, newHash
end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::loadSampFtp
;
; PURPOSE:
;   Specify and load sample data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function Hfbstool::loadSampFtp

Return, Self->Loadsamp(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::loadSamp
;
; PURPOSE:
;   Specify and load sample data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
; 
;   dataObject - specifies the data object whose data is to be reloaded
;   
;   reload  - set if the data specified by the dataObject keyword is to be reloaded
;   
;   fromFTP - set if the source of the datafile to be loaded is the FTP server
;-
function HfbsTool::loadSamp, reload=reload, dataObject=oItem, fromFTP=fromFTP

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'HfbsTool::loadSamp: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        Self->EnableUpdates
        return, 0
    endif
endif

; Get a valid sample folder in which to save the loaded sample dataset(s)
oFolder = Self->Getselectedsamplefolder()
if (~obj_valid(oFolder)) then return, 0

reloading = keyword_set(reload)
if (reloading) then begin
   if (~obj_valid(oItem)) then return, 0
   oItem->GetProperty, description=files
   count = 1
   void = oItem->GetMetaData('FROMFTP',fromFtp)
   ;if (~Self->ReadData(filename, dataPtr)) then return, 0
endif else begin
   ; Let user specify files to load
   title = 'Select Sample Files to Load'
   
   files = Self->GetFileList(title,count,fromFTP=fromFTP,newPath=newPath,filter=['*.hfbs'])
   if (count eq 0) then return, 0
   if (n_elements(newPath) gt 0) then Self->SetProperty, data_directory=newPath
endelse

; switch on the busy symbol for cursor
widget_control, /HOURGLASS

Self->DisableUpdates
; Read the contents of the data files and make entries in the 'Sample' tree of the data manager
Self->GetProperty, sumSampFlag=sumFlag, sampContRef=oCont, nSamp=nData
for i=0, count-1 do begin

   filename = files[i]
   if (~Self->readData(filename, dataHash, fromFTP=fromFTP)) then continue
   if (~Self->Updatecalculation(dataHash=dataHash)) then continue

   basename = file_basename(filename,'.hfbs',/fold_case)

   if (~reloading) then begin
      ;; create new object and attach dataPtr
      oItem = obj_new('IDLitParameterSet',name=basename,description=filename,type='samp')   
      oItem->AddMetaData,'DATAHASH',ptr_new(dataHash) ; stuff the datahash as a heap var; note cannot store a hash directoy as a metadata!
      oItem->AddMetaData,'FROMFTP',keyword_set(fromFTP)
      
      ; iTools does not handle '_[0-9]' characters in identifiers well eg _0, _1, etc
      ; replace all '_' with '-'
      oItem->GetProperty, identifier=idd
      hasChanged = 0
      while ((pos = stregex(idd,'_[0-9]')) ne -1) do begin
         strput, idd,'-',pos
         hasChanged = 1
      endwhile
      if (strmatch(idd,'[0-9]*')) then begin   ; if first char is a number
         idd = 'id'+idd
         hasChanged = 1
      endif
      if (hasChanged) then oItem->SetProperty,identifier=idd 

      ;; Add to the chosen sample folder
      oFolder->Add, oItem

      ; Create Place holder objects for x-axis, y-axis and error to be used later for plotting
      oZ = Idlitdata(name='Dependent')
      oZ->Addmetadata,'Long_name','Detector Counts'
      oZ->Addmetadata,'Units',''
      oZ->Addmetadata,'Signal', 1

      oX = Idlitdata(name='Independent')

      oE = Idlitdata(name='Error')

      oItem->Add, [oZ,oX,oE], parameter_name=['Dependent','Independent','Error']
      ;oCalc = Idlitdata(name='Calc')
      ;oItem->Add, [oZ,oX,oE,oCalc], parameter_name=['Dependent','Independent','Error','Calc']

   endif else begin
      ;; simply replace previous dataHash with updated one
      void = oItem->GetMetaData('DATAHASH',pDataHash)
      if (ptr_valid(pDataHash)) then heap_free, pDataHash
      oItem->AddMetaData,'DATAHASH',ptr_new(dataHash)
   endelse
   
   if (~reloading) then begin
      oCont->Add, oItem
      Self.nSamp++
   endif
endfor

; Now combine data within the folder and stuff the combined data hash structure
; as a 'DATAHASH' meta data for the folder
oItems = oFolder->Get(/all,count=nItems)
if (nItems gt 0) then begin
  hashArr = []
  for i=0,nItems-1 do begin
    void = oItems[i]->Getmetadata('DATAHASH',pDataHash)
    hashArr = [hashArr,*pDataHash]
  endfor
  combDataHash = Self->Combinedatasets(hashArr)
  if (obj_valid(combDataHash)) then oFolder->AddMetaData,'DATAHASH',ptr_new(combDataHash)
  void = Self->Updatecalculation(dataHash=combDataHash)
endif

Self->SetPropertyAttribute, 'SUMSAMPFLAG', sensitive=(Self.nSamp gt 0)
Self->refreshPropertySheet   ; force prop sheet to update

Self.modifiedFlag = 1
Self->EnableUpdates

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::CalculateEnergyTransfer
;
; PURPOSE:
;   Convert the data from cam bins to energy transfer
;
; PARAMETERS:
;   dataHash [in|out] - a hash data structure that contains all info about one complete dataset.
;
; KEYWORDS:
;
; RETURN VALUE:
;   1 if successful and 0 if not
;-
function HfbsTool::CalculateEnergyTransfer, dataHash
compile_opt idl2

oUI = Self->Getui()
oUI->Getproperty, group_leader = wTLB

; Basic error Handler
if (N_elements(!debug) && (!debug eq 0)) then begin
  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'HfbsTool::CalculateEnergyTransfer: Error encountered'
    eMsg = 'An error or unusual condition was encountered!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
    Catch, /cancel
    Self->Enableupdates
    Return, 0
  endif
endif

counts = dataHash['detCounts']
mode = dataHash['mode']
nDet = (size(counts,/dimensions))[1]  ;dataHash['nDet']
nChan = (size(counts,/dimensions))[0] ;dataHash['nChan']
;
;cycleTime = dataHash['cycleTime']
;numCycles = dataHash['numCycles']

if (strcmp(mode,'VELOCITY',/fold)) then begin
  energy = dblarr(nchan)
  de = (200.0+200.0)/(nchan - 1.0)
  energy = -200.0+de*Dindgen(nchan)
  index = where(energy le 50. and energy ge -50.,nValid)
  if (nValid lt 2) then begin

  endif  
  energy = energy[index]
  counts = counts[index,*]
endif else if (Strcmp(mode,'TIME',/fold)) then begin
  timeBin = dataHash['timeBin']
  dopFreq = Mean(dataHash['dopFreq'],/double) ; use the average doppler freq

  ; determine camType - historical setting - from exp't run number
  filename = dataHash['filename']
  compnum = long(Strmid(file_basename(filename),0,8)) ; is the first 8 characters of the filename are significant
  if compnum ge 20000601L or compnum le 19990824L then begin
    camType = 1  ; triangle cam
  endif else begin
    camType = 0  ; sine cam
  endelse

  channels = findgen(nchan)
  guesschannels = fix(1.0/(1.0e-6*dopFreq*timebin))
  realchannels = guesschannels
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ; begin the time to energy conversion
  lamo = dataHash['lambda']
  eo = 81.81/lamo^2
  vo = 3956.0/lamo
  dms = 2.25
  dsad = 4.15
  dsafc = 4.24    ; distance to fission chamber
  nchannels = fix(dsafc/(vo*TimeBin*1.0e-6))
  if realchannels lt nchan then begin
    counts[0:realchannels-1,0]=Shift(counts[0:realchannels-1,0],nchannels)
    ;error[0:realchannels-1,0]=Shift(error[0:realchannels-1,0],nchannels)
  endif
  camData = Fltarr(2,nchan)
  dataNew = Fltarr(nchan,16)
  energy = Fltarr(nchan)
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ; Perform a circular shift of the data up to realchannels
  ; in order to center the data in the effective time window

  ;ytest = Fltarr(nchan)
  ;for i=5,13 do begin
  ;  ytest[0:nchan-1]=ytest[0:nchan-1]+counts[0:nchan-1,i]
  ;endfor

  ; Vectorize above for loop
  ; sum counts in detectors 5 to 13 to obtain total counts in each channel
  ytest = total(counts[*,5:13],2)

  numtest = 1300
  y1max = Max(ytest[0:numtest-1]) & y2max = Max(ytest[numtest:nChan])
  y1ind = (Where(ytest eq y1max))[0]  ; use [0] to convert to scaler
  y2ind = (Where(ytest eq y2max))[0]

  nhalf = fix((y2ind-y1ind)/2.0)
  realhalf = Fix(0.5*realchannels)
  halfshift = (nhalf-realhalf)

  if DopFreq gt 8.0 and compnum ge 19990824L then begin
    ;for i = 0,16 do begin
    ;  counts[0:realchannels-1,i]=Shift(counts[0:realchannels-1,i],halfshift)
    ;  ;error[0:realchannels-1,i]=Shift(error[0:realchannels-1,i],halfshift)
    ;endfor

    ; Vectorize above for loop
    ; perform a circular shifts of the channel dimension of the counts for detector 0 to 16
    counts[0:realchannels-1,0:16] = shift(counts[0:realchannels-1,0:16],halfshift,0)
  endif

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;ytest = Fltarr(nchan)
  ;for i=5,13 do begin
  ;  ytest[0:nchan-1]=ytest[0:nchan-1]+data[0:nchan-1,i]
  ;endfor

  ; Vectorize above for loop
  ; sum counts in detectors 5 to 13 to obtain total counts in each channel
  ytest = Total(counts[*,5:13],2)


  ; Added the following line for numtest on 11/1/2000
  ;       numtest = 1300
  numtest = 1000
  y1max = Max(ytest[0:numtest-1]) & y2max = Max(ytest[numtest:nChan])
  y1ind = (Where(ytest eq y1max))[0]  ; use [0] to convert to scaler
  y2ind = (Where(ytest eq y2max))[0]

  arbchannels = nChan
  nfold = Fix((y2ind-y1ind)/2) + y1ind + fix(arbchannels/2)

  channels = Findgen(nchan+arbchannels)
  energy = Findgen(nchan)
  newdata = Fltarr(nchan+arbchannels,ndet)
  jfinal = Abs(nfold-Fix(nchan))
  longdata = Fltarr(nchan+arbchannels,ndet)
  longdata[arbchannels/2:nchan+arbchannels/2-1,0:ndet-1]=counts[0:nchan-1,0:ndet-1]

  for j=0,nfold do begin
    if nfold+j lt nchan+arbchannels then begin
      newdata[j+arbchannels/2,0:ndet-1]=longdata[nfold+j,0:ndet-1]+$
        longdata[nfold-j,0:ndet-1]
    endif else begin
      newdata[j+arbchannels/2,0:ndet-1]=0.0
    endelse
  endfor

  nfold2 = arbchannels/2+Fix(realchannels/2)
  numchannels = nfold2-nfold
  ;ynew = Fltarr(nchan+arbchannels,ndet)
  ynew = newdata
  ;y = Fltarr(nchan+arbchannels,ndet)
  y = newdata
  for j=1,numchannels-1 do begin
    ynew[nfold+j,0:ndet-1]=y[nfold+j,0:ndet-1]+y[nfold2+numchannels-j,0:ndet-1]
  endfor

  ynew[nfold2:nchan+arbchannels-1,0:ndet-1]=0.0*Findgen(nchan+arbchannels-nfold2,ndet)

  indlo = nfold-y1ind-(y2ind-y1ind)/2
  indhi = nfold2
  indlo = indlo[0]
  indhi = indhi[0]
  numind = indhi-indlo+1

  ydatnew = Fltarr(numind,ndet)
  ydatnew[0:numind-1,0:ndet-1]=ynew[indlo:indhi,0:ndet-1]

  realchannels = numind
  artchannels = Round(1.0/(2.0e-6*TimeBin*DopFreq))
  ndiff = realchannels-artchannels+1

  realchannels = realchannels+ndiff
  ;camdata = Fltarr(2,2*(realchannels))

  ;camdata = Sine_cam_funq(2*(realchannels),DopFreq)

  ;;;Determine energy from cam profile
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  y1new = Fltarr(realchannels,ndet)
  y1new[0:realchannels-1-ndiff,0:ndet-1] = ydatnew[0:realchannels-1-ndiff,0:ndet-1]

  velocity = Fltarr(realchannels)

  if CamType eq 0 then begin               ; sine cam
    scalefactor = 1.0
    camdata = Sine_cam_funq(2*(realchannels),DopFreq)
    velocity[0:realchannels-1] = scalefactor*camData[1,0:realchannels-1]
  endif else begin                         ; triangle cam
    camData = triangle_cam_funQ(2*realchannels,DopFreq)
    velocity[0:realchannels-1] = camData[1,0:realchannels-1]
  endelse
  energy = Fltarr(realchannels)

  k1 = 5.22707e-3 & k2 = 1261.64

  energy[0:realchannels-1] = k1*(k2*velocity[0:realchannels-1]+$
    (velocity[0:realchannels-1])^2)

  if realchannels mod 2 eq 0 then begin
    finalchannels = realchannels/2
    newchannels = realchannels-finalchannels+1
  endif else begin
    finalchannels = (realchannels+1)/2
    newchannels = realchannels-finalchannels
  endelse

  newchannels = realchannels-ndiff
  newenergy = Fltarr(newchannels)
  newenergy[0:newchannels-1] = energy[0:newchannels-1]
  newdata = Fltarr(newchannels,ndet)
  newdata[0:newchannels-1,0:ndet-1] = y1new[0:newchannels-1,0:ndet-1]

  nchan = newchannels
  energy = Fltarr(nchan)
  energy[0:nchan-1] = newenergy[0:nchan-1]
  data = Fltarr(nchan,ndet)
  error = Fltarr(nchan,ndet)


  ;  shift the low angle detectors the appropriate amount so that
  ;  their elastic peaks line up with the high angle detectors

  for i = 1,16 do begin
    ymax = Max(newdata[0:nchan-1,i]) & ymax = ymax[0]
    yind = Where(newdata[0:nchan-1,i] eq ymax) & yind = yind[0]
    emin = Min(Abs(energy[0:nchan-1])) & emin = emin[0]
    eind = Where(Abs(energy[0:nchan-1]) eq Abs(emin)) & eind = eind[0]
    newdata[0:nchan-1,i] = Shift(newdata[0:nchan-1,i],(eind-yind))
  endfor
;  data  = newdata
;  error = Sqrt(data)
;  totdetcounts = Dblarr(ndet)
;  for i = 0,ndet-1 do begin
;    totdetcounts[i] = Total(Double(data[0:nchan-1,i]))
;  endfor
  ;thisDetectorRates = dblarr(ndet)
  ;thisDetectorRates = totdetcounts/timeMinutes

;  *self.xvalsPtr = energy;[erange]
;  *self.dataPtr = data;[erange,*]
;  *self.errorPtr = error;[erange,*]
;  self.xlabel = '!6E (!4l!6eV)'
;
;  *self.oxvalsPtr = *self.xvalsPtr
;  *self.odataPtr = *self.dataPtr
;  *self.oerrorPtr = *self.errorPtr
endif else begin
  ; unknown mode
  title = 'Error processing dataset'
  msg = ['Dataset '+dataHash['filename'],'could not be processed because mode is unknown','Valid mode should be "Energy" or "Time"']
  Self->Errormessage, msg, title=title, severity=2
  return, 0
endelse

dataHash['corCounts'] = strcmp(mode,'VELOCITY')? counts : newdata
dataHash['eTransfer'] = energy
dataHash['xLabel'] = '$\hbar\omega$'
dataHash['xUnits'] = '$\mu$eV'

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::NormalizeToVanadium
;
; PURPOSE:
;   Normalize the detector counts to vanadium calibration measurement. This function is an adapted version of
;   the method hfbsreduction::normalize_to_vanadium found in hfbsreduction__define.pro
;
; PARAMETERS:
;   dataHash [in|out] - a hash data structure that contains all info about one complete dataset.
;
; KEYWORDS:
;
; RETURN VALUE:
;   1 if successful and 0 if not
;-
function Hfbstool::NormalizeToVanadium, dataHash
compile_opt idl2

if (~obj_valid(dataHash)) then return, 0

oUI = Self->Getui()
oUI->Getproperty, group_leader = wTLB

; Basic error Handler
if (N_elements(!debug) && (!debug eq 0)) then begin
  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'HfbsTool::NormalizeToVanadium: Error encountered'
    eMsg = 'An error or unusual condition was encountered!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
    Catch, /cancel
    Self->Enableupdates
    Return, 0
  endif
endif

Self->GetProperty, vanContRef=oVanCont, nVan=nVan
if (nVan lt 1) then return, 0

oItem = oVanCont->Get(position=0)
status = oItem->Getmetadata('COMBDATAHASH',pDataHash) ; retrieve aggregae data for all loaded vanadium datasets
vanHash = *pDataHash
vanCounts = vanHash['corCounts']
vanError = vanHash['corErrors']
vanXvals = vanHash['eTransfer']
vanTrmt = vanHash['treatment']
nDet = vanHash['nDet']

reducedFlag = dataHash['reduced']
if (reducedFlag) then begin
  counts = dataHash['redCounts']
  error = dataHash['redErrors']
  trmt = dataHash['redtreatment']
endif else begin
  counts = dataHash['corCounts']
  error = dataHash['corErrors']
  trmt = dataHash['treatment']
endelse

; The normalization factor is the area of the van peak which can be determine by a Gaussian fit
; Perform a fit of the vanadirm spectrum in the region between -5 to 5 ueV
fitIndex = where((vanXvals ge -5.0) and (vanXvals le 5.0))
vanXVals = vanXVals[fitIndex]
vanCounts = vanCounts[fitIndex,*]
vanError = vanError[fitIndex,*]

ymax = Max(vanCounts,dimension=1)             ; find the max intensity at each detector
sig = 1.0/2.354
area = []
for i=1,nDet do begin
  po = [ymax[i]*Sqrt(2.0*!pi*sig^2),0.0,1.0,0.0]      ; initial fit params
  result = gaussfit(vanXVals,vanCounts[*,i],params,estimates = po,nterms = 4, MEASURE_ERRORS=vanError[*,i])  ; make a Gaussian fit
  area = [area,params[0]*sqrt(2.0*!pi*params[2]^2)]        ; retain fitted area
endfor
area = area/mean(area[3:nDet-1])              ; normalize the areas using the average of the last 13 values
area = [1.0,area]                             ; add dummy value for the monitor channel
strarea = strjoin(string(area[1:nDet],format='(F5.2)'),',')
nChan = (size(counts,/dimensions))[0]
area = (1.0 + fltarr(nChan)) # area           ; extend to all channels for vectorization reasons

; Normalize the data
dataHash['redCounts'] = counts/area
dataHash['redErrors'] = error/area
dataHash['reduced'] = 1
line = '_________________________________________________________'
trmt = [trmt,line,'Perform a vanadium normalization of the data']
trmt = [trmt,'Vanadium files used:',vanHash['filename']]
trmt = [trmt,'Estimated vanadium normalization factor per detector: ',strarea]
dataHash['redtreatment'] = trmt

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::SubtractBkgd
;
; PURPOSE:
;   Subtract background files, summing them first if more than one is present
;
; PARAMETERS:
;
; KEYWORDS:
;   dataHash [in|out] - a hash data structure that contains all info about one complete dataset.
;
; RETURN VALUE:
;   1 if successful and 0 if not
;-
function Hfbstool::SubtractBkgd, dataHash
compile_opt idl2

if (~Obj_valid(dataHash)) then Return, 0

Self->Getproperty, bkgdContRef=oBkgdCont, nBkgd=nBkgd, ssfactor=ssfactor
if (nBkgd lt 1) then Return, 0

oBkgd = oBkgdCont->Get(position=0)
status = oBkgd->Getmetadata('COMBDATAHASH',pDataHash) ; retrieve aggregae data for all loaded bkgd datasets
bkgdHash = *pDataHash
bgCounts = bkgdHash['corCounts']
bgError = bkgdHash['corErrors']
bgXvals = bkgdHash['eTransfer']
bgTrmt = bkgdHash['treatment']
bgWBM = bkgdHash['WBM']

counts = dataHash['corCounts']
error = dataHash['corErrors']
xvals = dataHash['eTransfer']
trmt = dataHash['treatment']
WBM = dataHash['WBM']

; Ensure bkgd and sample have the same energy bins
; If not, rebin the bkgd data to the energy bins of the sample
rebinFlag = 1
if (n_elements(xvals)  eq n_elements(bgXvals)) then begin
  tol = 0.01
  diff = Abs(xvals - bgXvals)
  void = Where(diff gt tol, nDiff)
  rebinFlag = nDiff ne 0  
endif
if (rebinFlag) then begin
  Drebin,bgxVals,bgCounts,bgError,xvals,rebCounts,rebError,err=err,emsg=emsg,/points,/to_points
  if (err eq 0) then begin
    bgCounts = rebCounts
    bgError = reberror
  endif
endif

; use wbm to determine scale factor for sub.
; also include the user supplied self-shielding correction factor
sf = ssfactor*total(WBM)/total(bgWBM)

; aggregate the sample and bkgd monitor counts taking into account the user supplied ssfactor 
counts[*,0] = counts[*,0] + bgCounts[*,0]
error[*,0] = Sqrt(error[*,0]^2 + bgError[*,0]^2)

; For detectors, scale the bkgd counts and subtract off from sample counts
nDet = (size(counts,/dimensions))[1]
counts[*,1:nDet-1] = counts[*,1:nDet-1] - sf * bgCounts[*,1:nDet-1]
error[*,1:nDet-1] = sqrt(error[*,1:nDet-1]^2 + (sf * bgError[*,1:nDet-1])^2) 

; Treatment history
line = '_________________________________________________________'
trmt = [trmt,line,'Background subtraction performed']
trmt = [trmt,'Background files:',bkgdHash['filename']]
trmt = [trmt,'Self Shielding correction factor applied: '+String(ssfactor)]

; Update the records
dataHash['redCounts'] = counts
dataHash['redErrors'] = error
dataHash['reduced'] = 1
dataHash['redtreatment'] = trmt

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::NormalizeToMonitor
;
; PURPOSE:
;   Normalize the detector counts to the incident beam monitor. This function is an adapted version of
;   the method hfbsreduction::normalize_to_monitor found in hfbsreduction__define.pro
;
; PARAMETERS:
;   dataHash [in|out] - a hash data structure that contains all info about one complete dataset.
;
; KEYWORDS:
;
; RETURN VALUE:
;   1 if successful and 0 if not
;-
function Hfbstool::NormalizeToMonitor, dataHash
compile_opt idl2

oUI = Self->Getui()
oUI->Getproperty, group_leader = wTLB

; Basic error Handler
if (N_elements(!debug) && (!debug eq 0)) then begin
  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'HfbsTool::NormalizeToMonitor: Error encountered'
    eMsg = 'An error or unusual condition was encountered!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
    Catch, /cancel
    Self->Enableupdates
    Return, 0
  endif
endif

if (~Obj_valid(dataHash)) then Return, 0

energy = dataHash['eTransfer']
reducedFlag = dataHash['reduced']
if (reducedFlag) then begin
  counts = dataHash['redCounts']
  error = dataHash['redErrors']
  trmt = dataHash['redtreatment']
endif else begin
  counts = dataHash['corCounts']
  error = dataHash['corErrors']
  trmt = dataHash['treatment']
endelse
;error = Sqrt(counts)
index = Where(error le 0.0, nZero)
if (nZero gt 0) then error[index] = 1.0

datSize = Size(counts,/dimensions)
nChan = datSize[0]
nDet = 16

uVec = 1.0 + Fltarr(nChan)
vVec = 1.0 + Fltarr(nDet)

Self->Getproperty, grpScaleFactors=grpsf    ; user specified scale factors for each detector
grpsf = uVec#grpsf                          ; expand along energy axis

; calculate residual bkgd in each detector from the counts in the wings

mon = counts[*,0]
wt = float(energy ge 5.0) - float(energy le -5.0)   ; specify the region of interest used in evaluating the bkgd
mon = mon#vVec  ; expand in v direction
wt = wt#vVec    ; expand in v direction
data = counts[*,1:nDet]
bArray = total(wt*data/mon,1)/total(wt/mon,1) ; est. residual bkgd for each detector; sum counts in all channels within reg of interest, norm to monitor
uVec = 1.0 + fltarr(nChan)
bArray = uVec#bArray  ; expand in u direction
data = data - bArray  ; subtract off the residual bkgd

; Now scale the detector counts by the monitor
index = where(mon le 0.0, zeroMon)
if (zeroMon gt 1) then mon[index] = 1.0
normCounts = (data*grpsf)/mon

; estimate the error
; if z = x/y then dz = z*sqrt(dx^2/x + dy^2/y)
;monError = error[*,0]#vVec
;error[*,1:nDet] = abs(normCounts)*sqrt((error[*,1:nDet]/counts[*,1:nDet])^2 + (monError/mon)^2) ; use abs() to avoid -ve values for error

error[*,1:nDet] = (error[*,1:nDet]*grpsf)/mon

counts[*,1:nDet] = normCounts
; update the dataset
line = '_________________________________________________________'
dataHash['redCounts'] = counts
dataHash['redErrors'] = error
dataHash['reduced'] = 1
dataHash['redtreatment'] = [trmt,line,'Normalize detector counts to incident beam monitor']

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::NormalizeToPv
;
; PURPOSE:
;   Normalize the detector counts to the velocity profile of the doppler monichromator since
;   it is a function of time. The energy transfer is related to the velocity of the monochromator
;   and the velocity of the monochromator varies with time. This function is an adapted version of
;   the method hfbsreduction::normalize_to_pv found in hfbsreduction__define.pro
;
; PARAMETERS:
;   dataHash [in|out] - a hash data structure that contains all info about one complete dataset.
;
; KEYWORDS:
;
; RETURN VALUE:
;   1 if successful and 0 if not
;-
function Hfbstool::NormalizeToPv, dataHash
compile_opt idl2

if (~Obj_valid(dataHash)) then Return, 0

oUI = Self->Getui()
oUI->Getproperty, group_leader = wTLB

; Basic error Handler
if (N_elements(!debug) && (!debug eq 0)) then begin
  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'HfbsTool::NormalizeToPv: Error encountered'
    eMsg = 'An error or unusual condition was encountered!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
    Catch, /cancel
    Self->Enableupdates
    Return, 0
  endif
endif

counts = dataHash['corCounts']
energy = dataHash['eTransfer']
error = sqrt(counts)
;index = where(error le 0.0, nZero)
;if (nZero gt 0) then error[index] = 1.0

datSize = Size(counts,/dimensions)
nChan = datSize[0]
nDet = 16

;data = *self.dataPtr
;error = *self.errorPtr
;x = *self.xvalsPtr
;

; determine the normalization factor
index = Where(counts[*,19] ne 0.0)
uVec = 1+Bytarr(nDet)
pe = counts[index,19]/(Total(counts[index,19]*Deriv(energy[index])))

; normalize the detectors
counts[index,1:nDet] = counts[index,1:nDet]/(pe#uVec)
error[index,1:nDet] = error[index,1:nDet]/(pe#uVec)

; normalize the monitor to its P(v)
index = Where(counts[*,18] ne 0.0)
counts[index,0] = (counts[index,0]/counts[index,18])*Total(counts[index,18]*Deriv(energy[index]))
error[index,0] = (error[index,0]/error[index,18])*Total(error[index,18]*Deriv(energy[index]))
; update the dataset
dataHash['corCounts'] = counts[index,0:16]
dataHash['corErrors'] = error[index,0:16]
dataHash['eTransfer'] = energy[index]
;*self.dataPtr = counts[index,0:16]
;*self.errorPtr = error[index,0:16]
;*self.xvalsPtr = x[index]
;*self.yvalsPtr = (*self.yvalsPtr)[0:16]
;Widget_control,self.grpSlider,set_slider_max = self.ndet
;
;*self.oyvalsPtr = *self.yvalsPtr
;*self.oxvalsPtr = *self.xvalsPtr
;*self.odataPtr = *self.dataPtr
;*self.oerrorPtr = *self.errorPtr
;

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::RegroupData
;
; PURPOSE:
;   Regroup the detectors data into user-specified groups that are fewer than the 
;   naximum number of detectors available (16)
;
; PARAMETERS:
;   dataHash [in|out] - a hash data structure that contains all info about one complete dataset.
;
; KEYWORDS:
;
; RETURN VALUE:
;   1 if successful and 0 if not
;-
function Hfbstool::RegroupData, dataHash
compile_opt idl2

if (~Obj_valid(dataHash)) then Return, 0

reducedFlag = dataHash['reduced']
if (reducedFlag) then begin
  counts = dataHash['redCounts']
  errors = dataHash['redErrors']
  trmt = dataHash['redtreatment']
endif else begin
  counts = dataHash['corCounts']
  errors = dataHash['corErrors']
  trmt = dataHash['treatment']
endelse
qVals = dataHash['qVals']
nmax = 16

; Group detectors according to the user specified nos of groups
grpOptions = ['16 Groups','8  Groups','4  Groups','2  Groups','1  Group']
Self->Getproperty, detGroupFlag=detgflag, detsInGroup1=detsInGroup1
if (detgflag eq 4) then begin
  ; special case b/c the detInGroup1 field needs to be used
  if (detsInGroup1 eq '') then msdString='1-16'
  void = Compactstring2intvector(detsInGroup1,group0Index)
  group0Index = group0Index -1  ; groups to indices
endif

case detgFlag of        ; 
  0: nGroups = 16
  1: nGroups = 8
  2: nGroups = 4
  3: nGroups = 2
  4: nGroups = 1
endcase
if (nGroups ne 16) then begin
  nDetsPerGrp = nmax/nGroups
  for i=0,nGroups-1 do begin
    index = i*nDetsPerGrp + Indgen(nDetsPerGrp)
    if (nGroups eq 1) then index = group0Index
    qVals[i] = Mean(qVals[index])                   ; calculate average q in each group
    if (n_elements(index) gt 1) then begin
      counts[*,i+1] = Total(counts[*,index+1], 2)         ; sum all detector counts in each group. The +1 is because detectors
      ; go from 1 to 16. Index 0 contains monitor info
      errors[*,i+1] = Sqrt(Total(errors[*,index+1]^2, 2)) ; sqrt of sum of squares of the detector error in each group      
    endif else begin
      counts[*,i+1] = reform(counts[*,index+1])         ; sum all detector counts in each group. The +1 is because detectors
      ; go from 1 to 16. Index 0 contains monitor info
      errors[*,i+1] = reform(errors[*,index+1])         ; sqrt of sum of squares of the detector error in each group      
    endelse
  endfor
  qVals = Temporary(qVals[0:nGroups-1])
  counts = Temporary(counts[*,0:nGroups]) ; index 0 is monitor hence 0:nGroups not 0:nGroups-1
  errors = Temporary(errors[*,0:nGroups])
  line = '_________________________________________________________'
  trmt = [trmt,line,'Regroup data from 16 detectors into '+grpOptions[detgFlag]]
endif
trmt = [trmt,'','16 Detectors in raw dataset ']
trmt = [trmt,'Final number of groups: '+string(nGroups,format='(I2)')]
trmt = [trmt,'Final number of channels: '+string((size(counts,/dimension))[0],format='(I3)')]
trmt = [trmt,'Total white beam monitor counts: '+string(total(dataHash['wbm']),format='(G11.5)')]
trmt = [trmt,'Total incident beam monitor counts: '+string(total(counts[*,0]),format='(G11.5)')]
trmt = [trmt,'Total transmitted beam monitor counts: '+string(total(dataHash['tbm']),format='(G11.5)')]
dataHash['finalCounts'] = counts
dataHash['finalErrors'] = errors
dataHash['finalqVals'] = qVals
dataHash['finalTreatment'] = trmt


return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::UpdateAllDatasets
;
; PURPOSE:
;   Loop through all datasets currently loaded and reduce them according to user specs
;
; PARAMETERS:
;
; KEYWORDS:
;-
pro Hfbstool::UpdateAllDatasets, doFromNorm=doFromNorm, doFromRegroup=doFromRegroup, doFromBkgd=doFromBkgd, doFromVan=doFromVan
compile_opt idl2

; Retrieve the contents of the Sample Folder Container 
oSampFoldCont = Self.sampFoldCont
oSampFolders = oSampFoldCont->Get(/all,count=nFolders)
if (nFolders eq 0) then return
for i=0,nFolders-1 do begin
  oFolder = oSampFolders[i]
  oItems = oFolder->Get(/all,count=nItems)
  if (nItems eq 0) then continue

  hashArr = []  ; store the data hashes so they can be combined
  for j=0,nItems-1 do begin
    void = Self->Updatecalculation(oItems[j],doFromNorm=doFromNorm, doFromRegroup=doFromRegroup $
                                            ,doFromBkgd=doFromBkgd, doFromVan=doFromVan)
    void = oItems[j]->Getmetadata('DATAHASH',pDataHash)
    hashArr = [hashArr,*pDataHash]    
  endfor
  ; Now combine data within the folder and stuff the combined data hash structure
  ; as a 'DATAHASH' meta data for the folder
  combDataHash = Self->Combinedatasets(hashArr)
  if (~Obj_valid(combDataHash)) then continue
  oFolder->Addmetadata,'DATAHASH',Ptr_new(combDataHash)
  void = Self->Updatecalculation(dataHash=combDataHash)
endfor

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::UpdateCalculation
;
; PURPOSE:
;   Perform all necessary transformations and corrections of the raw dataset
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated
;
; KEYWORDS:
;   dataHash [in] - a hash data structure that contains all info about one complete dataset.
;
; RETURN VALUE:
;   1 if successful and 0 if not
;-
function Hfbstool::UpdateCalculation, oPSet, dataHash=dataHash, bkgdData=bkgdData, vanData=vanData $
  ,doFromNorm=doFromNorm, doFromRegroup=doFromRegroup, doFromBkgd=doFromBkgd, doFromVan=doFromVan
compile_opt idl2

; if dataHash is passed in then use it instead, otherwise retrieve it from the parameterset
if (n_elements(dataHash) eq 0) then begin
  ; what type of dataset is this?
  ;oPSet->GetProperty, type=type
  
  oPSet->Getproperty, name=nameTag
  void = oPSet->Getmetadata('DATAHASH',pDataHash)
  dataHash = *pDataHash
  if (~Obj_isa(dataHash,'hash')) then Return, 0
endif else begin
  nametag = file_basename(dataHash['filename'],'.hfbs')
endelse
Self->Statusmessage, 'Updating Calculation for '+nameTag[0]+' ...'

if (keyword_set(doFromBkgd)) then goto, FROMBKGD
if (Keyword_set(doFromNorm)) then goto, FROMNORM
if (Keyword_set(doFromRegroup)) then goto, FROMREGROUP
if (Keyword_set(doFromVan)) then goto, FROMVAN

; Calculate the energy transfer
if (~Self->CalculateEnergyTransfer(dataHash)) then return, 0

; Normalize counts to velocity profile of the doppler monochromator
if (~Self->Normalizetopv(dataHash)) then return, 0

; For Background and Vanadium datasets, don't need to process any further
if (keyword_set(bkgdData) or keyword_set(vanData)) then return, 1

FROMBKGD:
dataHash['reduced'] = 0  ; this is significant! Do not change location of statement!
; Subtract bkgd, if required
Self->GetProperty, bkgdFlag=bkdgFlag
if (bkdgFlag) then begin
  status = Self->SubtractBkgd(dataHash)
endif

FROMNORM:
; Normalize to incident beam monitor, if required
Self->Getproperty, monNormFlag=monNormFlag
if (monNormFlag) then begin
  status = Self->NormalizeToMonitor(dataHash)
endif

FROMVAN:
; Normalize to vanadium calibration, if required
Self->Getproperty,vanFlag=vanFlag
if (vanFlag) then begin
  status = Self->NormalizeToVanadium(dataHash)
endif

FROMREGROUP:
; Regroup data according to user specification
status = Self->Regroupdata(dataHash)

trmt = dataHash['finaltreatment']
print,'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
for i=0,N_elements(trmt)-1 do Print, trmt[i]
print, ' '

return, 1

end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::restoreDataVersion
;
; PURPOSE:
;   Restore the specified object to the latest version
;
; PARAMETERS:
;   oData [in|out] - object to be restored to the latest version
;
; KEYWORDS:
;
pro HfbsTool::restoreDataVersion, oData
compile_opt idl2

; restore to latest IDLitData version
oData->Restore

; Pull the data pointer structure and ensure it is up to data
currentVersion = Self.dataVersion

void = oData->Getmetadata('DATAHASH',pDataHash)
dataHash = *pDataHash
if (~Obj_isa(dataHash,'hash')) then Return
oldDataVersion = dataHash['dataVersion']

if (currentVersion gt oldDataVersion) then begin
   ; Update the data as necessary
endif

end


;===============================================================================
; HfbsTool::readData
;
; PURPOSE:
;   Read the contents of a .bt4 file
;
; PARAMETERS:
;   filename [in] - file to be read.
;
;   dataHash [out] - data structure to read file contents into
;
; KEYWORDS:
;
function Hfbstool::ReadData, filename, dataHash, fromFTP=fromFTP
compile_opt idl2

oUI = Self->Getui()
oUI->Getproperty, group_leader = wTLB

; Basic error Handler
if (N_elements(!debug) && (!debug eq 0)) then begin
  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'HfbsTool::readData: Error encountered'
    eMsg = 'An error or unusual condition was encountered!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
    Catch, /cancel
    if (Ptr_valid(dataPtr)) then Heap_free, dataPtr
    if (N_elements(lun) gt 0) then Free_lun, lun, /force
    Return, 0
  endif
endif


; check parameter count
if (N_params() ne 2) then Return, 0

; check file parameter is defined
if (N_elements(filename) le 0) then Return, 0

fromFtp = (Stregex(filename,'/pub/ncnrdata/',/fold,/bool))? 1 : 0
if (~fromFTP && ~File_test(filename)) then Return, 0

if (Keyword_set(fromFTP)) then Self->Getproperty, ftpObject=oFTP

if (fromFTP) then begin
  ; retrieve file contents from ftp server and store into dstring array
  dstring = oFtp->Getfilecontent(filename,/string)
  if (Strcmp(dstring[0],'')) then Return, 0
  nlines = N_elements(dstring)
endif else begin
  read_ok = Dave_read_filecontents(filename,dstring=dstring,errmsg=errmsg)
  if ~read_ok then begin
    void = Dialog_message(errmsg)
    Return, 0
  endif
endelse

; Rest of code is adapted from the original HFBS reduction program
; by Rob Dimeo. Specifically from hfbsreduction::read_raw_hfbs

; The header
nHeader = 9
header = dstring[0:nHeader-1]

; What is the mode of data acquisition?
ind = where(stregex(header,'#Run Mode',/bool,/fold_case))
toks = strsplit(header[ind],':',/extract,count=nTok)
mode = Strupcase(strtrim(toks[1],2))
if (~strcmp(mode,'VELOCITY')) then mode='TIME'

; user
ind = Where(Stregex(header,'#User',/bool,/fold_case))
if (ind ge 0) then begin
  toks = Strsplit(header[ind],':',/extract,count=nTok)
  user = toks[1]
endif else user = ''

; start time
ind = Where(Stregex(header,'#Start Time',/bool,/fold_case))
if (ind ge 0) then begin
  toks = Strsplit(header[ind],':',/extract,count=nTok)
  startTime = strtrim(strjoin(toks[1:ntok-1],':'),2)
endif else startTime=''

; end time
ind = Where(Stregex(header,'#Stop  Time',/bool,/fold_case))
if (ind ge 0) then begin
  toks = Strsplit(header[ind],':',/extract,count=nTok)
  stopTime = strtrim(strjoin(toks[1:ntok-1],':'),2)
endif else stopTime=''

; num cycles
ind = Where(Stregex(header,'#Num Cycles',/bool,/fold_case))
if (ind ge 0) then begin
  toks = Strsplit(header[ind],':',/extract,count=nTok)
  numCycles = float(toks[1])
endif else numCycles=1

; cycle time
ind = Where(Stregex(header,'#Cycle Time',/bool,/fold_case))
if (ind ge 0) then begin
  toks = Strsplit(header[ind],':',/extract,count=nTok)
  cycleTime = Float(toks[1])
endif else cycleTime=1

; time bin
ind = Where(Stregex(header,'#Time bin (usec)',/bool,/fold_case))
if (ind ge 0) then begin
  toks = Strsplit(header[ind],':',/extract,count=nTok)
  timeBin = Float(toks[1])
endif else timeBin=1

; The doppler frequencies
dopFreq = []
ind = where(stregex(dstring,'#Log Doppler Freq',/bool,/fold_case),dopplerFound)
if (dopplerFound) then begin
  ind++
  while (~strcmp(dstring[ind],'#',1)) do begin
    dopFreq = [dopFreq,double(dstring[ind])]
    ind++
  endwhile
endif

; The white beam monitor counts
wbm = []
ind = Where(Stregex(dstring,'#Log White beam',/bool,/fold_case),wbFound)
if (wbFound) then begin
  ind++
  while (~Strcmp(dstring[ind],'#',1)) do begin
    wbm = [wbm,Double(dstring[ind])]
    ind++
  endwhile
endif

; The transmitted beam monitor counts
tbm = []
ind = Where(Stregex(dstring,'#Log Trans beam',/bool,/fold_case),tbFound)
if (tbFound) then begin
  ind++
  while (~Strcmp(dstring[ind],'#',1)) do begin
    tbm = [tbm,Double(dstring[ind])]
    ind++
  endwhile
endif

; The temperature values
temp = []
ind = Where(Stregex(dstring,'#Log Sample temp',/bool,/fold_case),tempFound)
if (tempFound) then begin
  ind++
  while (~Strcmp(dstring[ind],'#',1)) do begin
    temp = [temp,Double(dstring[ind])]
    ind++
  endwhile
endif else begin
  temp = 300.0 * (dopFreq*0.0 + 1.0)  ; if no temp field, default to 300 K
endelse

; The detector counts
ind0 = Where(Stregex(dstring,'# Detector 0',/bool,/fold_case),detFound)
if (~detFound) then begin
  print,'Data setion could not be identified in the file'
  return, 0
endif

nDet = 20
nChan = 4096
data = fltarr(nChan,nDet)
buf = fltarr(2,nChan)
line = ''
for i=0,nDet-1 do begin
  ind = ind0 + i*(1 + nChan)            ; move counter to the next detector block
  if (i lt nDet-1) then $               ; read the two columns following the label into a float array
  reads,dstring[ind+1:ind+1+nChan],buf,line  else $
  reads,dstring[ind+1:ind+nChan],buf
  data[*,i] = buf[1,*]                  ; second column is the counts
endfor
detLabels = ['Monitor','Detector 1', 'Detector 2', 'Detector 3', $
  'Detector 4', 'Detector 5', 'Detector 6','Detector 7', $
  'Detector 8', 'Detector 9','Detector 10', 'Detector 11', $
  'Detector 12', 'Detector 13','Detector 14', 'Detector 15', $
  'Detector 16', 'Arbitrary','Monitor P(v)','Detector P(v)']
detAngles = [14.46,20.98,27.08,32.31,36.0,43.75,51.5,59.25,67.0,$
  74.75,82.5,90.25,98.0,105.75,113.5,121.5]
lambda = 6.27
qVals = (4.0*!pi/lambda)*Sin(0.5*!dtor*detAngles)
qUnit = '$\AA^{-1}$'
treatment = [systime(),'Dataset(s) included:']
treatment = [treatment,filename]

keys = ['filename'        $
       ,'header'          $
       ,'dataVersion'     $
       ,'detCounts'       $
       ,'detLabels'       $
       ,'qVals'           $
       ,'qUnit'           $
       ,'nDet'            $
       ,'nChan'           $
       ,'detAngles'       $
       ,'lambda'          $
       ,'dopFreq'         $
       ,'wbm'             $
       ,'tbm'             $
       ,'temp'            $
       ,'mode'            $
       ,'user'            $
       ,'timeBin'         $
       ,'cycleTime'       $
       ,'numCycles'       $
       ,'startTime'       $
       ,'stopTime'        $
       ,'treatment'       $ 
       ,'xLabel'          $
       ,'xUnits'          $    
       ]

values = list(filename          $
             ,header            $
             ,Self.dataVersion  $
             ,data              $
             ,detLabels         $
             ,qVals             $
             ,qUnit             $
             ,16                $
             ,4096              $
             ,detAngles         $
             ,6.27              $
             ,dopFreq           $
             ,wbm               $
             ,tbm               $
             ,temp              $
             ,mode              $
             ,user              $
             ,timeBin           $
             ,cycleTime         $
             ,numCycles         $
             ,startTime         $
             ,stopTime          $
             ,treatment         $
             ,''                $
             ,''                $
             )

dataHash = hash(keys,values,/fold_case)

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::UpdatePropertySheet
;
; PURPOSE:
;   Update the propertysheet to reflect the current sample type
;
; PARAMETERS:
;
; KEYWORDS:
;
pro HfbsTool::UpdatePropertySheet
compile_opt idl2

Self->GetProperty, detGroupFlag=detGroupFlag, grpNos=grpNos,plotFlag=plotFlag ;sampContRef=oSamp, bkgdContRef=oBkgd, vanContRef=oVan
nGroups = [16,8,4,2,1]
Self.nGroups = nGroups[detGroupFlag]
valid_rg = [1,Self.nGroups,1]
grpNos = grpNos < Self.nGroups
Self->Setproperty, grpNos=grpNos
Self->Setpropertyattribute, 'grpNos', valid_range=[1,Self.nGroups,1], hide=plotFlag
Self->Setpropertyattribute, 'detsingroup1', hide=(detGroupFlag ne 4)

;nSamp = oSamp->Count()
;nBkgd = oBkgd->Count()
;nVan  = oVan->Count()
Self->SetPropertyAttribute, 'SUMSAMPFLAG', sensitive=(Self.nSamp gt 0)
Self->Setpropertyattribute, 'BKGDFLAG', sensitive=(Self.nBkgd gt 0)
Self->Setpropertyattribute, 'VANFLAG', sensitive=(Self.nVan gt 0)

;if (nSamp gt 0) then begin
;   msg = 'Not advisable to change Sample Type with data already loaded!'
;   msg = [msg,'Do you wish to delete all loaded datasets first?']
;   title = 'Change Sample Type: Delete data?'
;   status = Self->PromptUserYesNo(msg,answer,title=title)
;   if (status && answer) then $
;      void = Self->DeleteAllDatasets(/noPrompt)
;endif
;
;dynProps = ptr_valid(Self.dynOnlyPropsPtr)? (*Self.dynOnlyPropsPtr) : []
;nDynProps = n_elements(dynProps)
;fwsProps = ptr_valid(Self.fwsOnlyPropsPtr)? (*Self.fwsOnlyPropsPtr) : []
;nFwsProps = n_elements(fwsProps)

;oUI = Self->GetUI()
;uiPresent = obj_valid(oUI)
;if (uiPresent) then begin
;   oUI->GetProperty, group_leader = wTLB
;   wChild = widget_info(wTLB, /child)
;   widget_control, wChild, get_uvalue=sPtr
;endif
;
;case Self.sampTypeFlag of
;
;   0: begin ; DYN
;      for i = 0, nDynProps-1 do begin
;         Self->SetPropertyAttribute, dynProps[i], hide=0
;      endfor   
;      for i = 0, nFwsProps-1 do begin
;         Self->SetPropertyAttribute, fwsProps[i], hide=1
;      endfor
;;      ; fix label for x-axis variable
;;      Self->SetPropertyAttribute,'xAxisVar', name='Scan Variable', enumlist=(*Self.indepVars2Ptr)
;
;   end
;   
;   1: begin ; FWS
;      for i = 0, nFwsProps-1 do begin
;         Self->SetPropertyAttribute, fwsProps[i], hide=0
;      endfor   
;      for i = 0, nDynProps-1 do begin
;         Self->SetPropertyAttribute, dynProps[i], hide=1
;      endfor
;      ; fix label for x-axis variable
;;      Self->SetPropertyAttribute,'xAxisVar', name='Horizontal Axis Variable', enumlist=(*Self.indepVars1Ptr)
;;
;;      Self->SetPropertyAttribute, 'maxIntensity', hide=(Self.defaultIntensityFlag eq 1)
;;      Self->SetPropertyAttribute, 'minIntensity', hide=(Self.defaultIntensityFlag eq 1)
;   end
;   
;   else:
;endcase

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::Plot
;
; PURPOSE:
;   Generates a plot of the specified dataset
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPltFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro HfbsTool::Plot, oItem, sPtr, overPlotFlag, lastPlotFlag, position=pos
compile_opt idl2
;print,'############################################################################################################ '
;print,'In Hfbstool::Plot...'
;Print,' '

oItem->Getproperty, type=dataType
case Strlowcase(dataType) of
  'samp': Self->PlotSample, oItem, sPtr, overPlotFlag, lastPlotFlag, position=pos
  'bkgd': Self->PlotBkgd, oItem, sPtr, overPlotFlag, lastPlotFlag, position=pos
  'van': Self->PlotBkgd, oItem, sPtr, overPlotFlag, lastPlotFlag, position=pos
  else: Return
endcase

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::PlotBkgd
;
; PURPOSE:
;   Generates a plot of the specified dataset
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPltFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro Hfbstool::PlotBkgd, oItem, sPtr, overPlotFlag, lastPlotFlag, position=pos
compile_opt idl2

; Retrieve info from current property sheet settings
oItem->Getproperty, type=dataType
if (strcmp(dataType,'bkgd',/fold)) then begin
  Self->Getproperty, sumBkgdFlag=sumFlag, bkgdContRef=oCont  
endif else begin
  sumFlag = 1
  Self->Getproperty, vanContRef=oCont
endelse
if (sumFlag) then begin
  ; retrieve the data from the folder
  oItem = oCont->Get(position=0)  ; Get the first bkgd dataset
  if (~Obj_valid(oItem)) then Return
  void = oItem->Getmetadata('COMBDATAHASH',pDataHash)
  dataHash = *pDataHash
  if (~Obj_isa(dataHash,'hash')) then Return
  ;Print,dataHash['filename']
endif else begin
  ; retrieve the data from the selected dataset
  void = oItem->Getmetadata('DATAHASH',pDataHash)
  dataHash = *pDataHash
  if (~Obj_isa(dataHash,'hash')) then Return
  ;Print,dataHash['filename']
endelse

; Retrieve the data to plot
Self->Getproperty, grpNos=grpNos, autoscaleFlag=autoscaleFlag, logFlag=logFlag
counts = (dataHash['corCounts'])[*,grpNos]
errors = (dataHash['corErrors'])[*,grpNos]
energy = dataHash['eTransfer']
qVal = (dataHash['qVals'])[grpNos-1]
yTitle = 'Intensity'
yUnits = 'arb. units'
xTitle = dataHash['xLabel']
xUnits = dataHash['xUnits']
title = 'Q = '+string(qVal,format='(F5.3)')+' $\AA^{-1}$'
title = [file_basename((dataHash['filename'])[0], 'hfbs'),title]

; take a log of the data if requested
if (logFlag) then begin
  ;fracError = abs(errors/counts)
  index = Where(counts le 0.0, nBad)
  if (nBad gt 0) then counts[index] = !values.F_NAN
  errors = Abs(Alog10(counts + errors) - Alog10(counts - errors))
  counts = Alog10(Temporary(counts))
endif

; If autoscaling plot then normalize the data so its maximum value
; close to E=0 is 1
if (autoscaleFlag) then begin
  index = where(energy ge -2.0 and energy le 2.0, nRange)
  maxInt = (nRange gt 0)? max(counts[index]) : max(counts)
  counts = counts/abs(maxInt)
  errors = errors/abs(maxInt)
  yTitle = 'Scaled Intensity'
endif

;; sanitize errors; replace zero with 1
index = where(errors le 0.0, zeroError)
if (zeroError gt 0) then errors[index] = 1.0

; Create objects to store data to be plotted
oX = oItem->GetByName('Independent',count=found)
oZ = oItem->GetByName('Dependent',count=found)
oE = oItem->GetByName('Error',count=found)
;oC = oItem->GetByName('Calc',count=found)
oZ->AddMetaData,'Long_name', yTitle
oZ->AddMetaData,'Units', yUnits
oX->AddMetaData,'Long_name', xTitle
oX->AddMetaData,'Units', xUnits
ctype = partype(counts)
status = oZ->SetData(counts,/no_copy,/no_notify)
status = oE->SetData(errors,/no_copy,/no_notify)
status = oX->SetData(energy,/no_copy,/no_notify)
oZ->SetProperty, type=ctype
oX->SetProperty, type=ctype
oE->SetProperty, type=ctype
;if (examiningFits) then begin
;  status = oC->SetData(yFit,/no_copy,/no_notify)
;  oC->SetProperty, type=ctype
;endif

axisHasChanged = 0
msg = []

strparms = ['Y','X','Y ERROR','X ERROR','VERTICES','PALETTE','VERTEX_COLORS']
idparms = [oZ->GetFullIdentifier() $
          ,oX->GetFullIdentifier() $
          ,oE->GetFullIdentifier() $
          ,'','','','']
visID = 'PLOT'
opID = 'Operations/Insert Visualization'
oRequester = (Self->GetByIdentifier(opID))->GetObjectInstance()
oRequester->_setTool, Self
oRequester->GetProperty, show_execution_ui = orig_showUI
oRequester->SetProperty, show_execution_ui = 0

oItem->GetProperty, name=plotName   ; retrieve the dataset name as shown in the data manager and set it as plotname
oRequester->SetProperty, name=plotName, parameter_names=strParms, data_ids=idParms, visualization_id=visID

oWin = Self->GetCurrentWindow()
oView = oWin->GetCurrentView()
activateManip = 0
rangeChange = 0

noOverplot = overplotFlag eq 0
if (Self->HasVisualizations() && noOverplot) then begin
   ;; store the active manipulator
   (*sPtr).manipID = (Self->GetCurrentManipulator())->GetFullIdentifier()
   activateManip = 1

   ;; ensure the existing visualization is selected
   oLayer = oView->GetCurrentLayer()
   oWorld = oLayer->GetWorld()
   oDataSpace = oWorld->GetDataSpaces()
   oVis = oDataSpace->GetVisualizations(count = nVis)
    
   ; retrieve current xrange and yrange to determine if user has zoomed plot
   oDataSpace->GetProperty, xrange=xr, yrange=yr
   xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1]) 
   yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1]) 
   rangeChange = xChange && yChange
   
   delID = 'Operations/Edit/Delete'
   oDelete = (Self->GetByIdentifier(delID))->GetObjectInstance()
   
   oDataSpace->Select
   void = oDelete->DoAction(Self)

   obj_destroy, [oVis,oDataSpace]
   
   ; delete any residual annotations that may have been added
   annID = oView->FindIdentifiers('*ANNOTATION LAYER*',count=nAnn)
   if (nAnn gt 2) then begin
     oVoid = []
     for i=2, nAnn-1 do begin
       oTmp = Self->GetByIdentifier(annID[i])
       oTmp->Select
       oVoid = [oVoid,oTmp]
     endfor
     void = oDelete->DoAction(Self) ; delete selected anootations
     obj_destroy, oVoid
   endif

endif

; create the new vis
oCmd = oRequester->DoAction(Self)

;; Get the newly created vis
oLayer = oView->GetCurrentLayer()
oWorld = oLayer->GetWorld()
oDataSpace = oWorld->GetDataSpaces()
oVis = oDataSpace->GetVisualizations(count = nVis)

; And Customize it
colors = [[0,0,0],[0,0,255],[0255,0,0],[0,255,0],[0,255,255],[255,0,255] $
  ,[128,255,0],[255,128,0],[0,255,128],[128,128,255],[255,128,128] $
  ,[128,255,128],[128,128,128],[255,255,0]]
nColors = N_elements(colors)/3
pos = pos mod nColors
Self->SetProperty, s_color=colors[*,pos], s_sym_color=colors[*,pos], s_use_default_color=1 $
  , s_errorbar_color=colors[*,pos], s_sym_fill_color=colors[*,pos]
Self->CustomizeVis, oVis[nVis-1], plotName, 'BKGDPLOT'
if (noOverplot) then oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only

;; customize axes
;oAxes = oDataSpace->GetAxes(/container)
;oAxes->SetProperty,axis_style=2  $    ; draw box axes
;                  ;,yTitle=ylabel, xTitle=xlabel $
;                  ,zTitle=zlabel

; Update Plot Title text to reflect name of dataset being plotted
; The plot title annotation was automatically created when visualization was first created so
; all we need to do is change the text string
annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
if (nAnn gt 0) then begin
  oText = Self->Getbyidentifier(annID[1])
  ;oItem->Getproperty, name=visname
  if (Isa(oText,'IDLitvisText')) then oText->Setproperty, string=title
endif

if (activateManip) then Self->ActivateManipulator, (*sPtr).manipID
Self->RefreshCurrentWindow   ;oWin->Draw   ; force window to refresh

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::PlotSample
;
; PURPOSE:
;   Generates a plot of the specified dataset
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPltFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro Hfbstool::PlotSample, oItem, sPtr, overPlotFlag, lastPlotFlag, position=pos
compile_opt idl2

; Retrieve info from current property sheet settings
Self->Getproperty, sumSampFlag=sumSampFlag, sumBkgdFlag=sumBkgdFlag
if (sumSampFlag) then begin
  ; retrieve the data from the folder
  oFolder = Self->Getselectedsamplefolder(oItem)  ; Get the sample folder first
  if (~Obj_valid(oFolder)) then Return
  void = oFolder->Getmetadata('DATAHASH',pDataHash)
  dataHash = *pDataHash
  if (~Obj_isa(dataHash,'hash')) then Return
endif else begin
  ; retrieve the data from the selected dataset
  void = oItem->Getmetadata('DATAHASH',pDataHash)
  dataHash = *pDataHash
  if (~Obj_isa(dataHash,'hash')) then Return
endelse
trmt = dataHash['finaltreatment']
;for i=0,n_elements(trmt)-1 do print, trmt[i]

; Retrieve the data to plot
Self->Getproperty, grpNos=grpNos, autoscaleFlag=autoscaleFlag, logFlag=logFlag
counts = (dataHash['finalCounts'])[*,grpNos]
errors = (dataHash['finalErrors'])[*,grpNos]
energy = dataHash['eTransfer']
qVal = (dataHash['finalqVals'])[grpNos-1]
yTitle = 'Intensity'
yUnits = 'arb. units'
xTitle = dataHash['xLabel']
xUnits = dataHash['xUnits']
title = 'Q = '+string(qVal,format='(F5.3)')+' $\AA^{-1}$'
title = [file_basename((dataHash['filename'])[0], 'hfbs'),title]

; take a log of the data if requested
if (logFlag) then begin
  ;fracError = abs(errors/counts)
  index = Where(counts le 0.0, nBad)
  if (nBad gt 0) then counts[index] = !values.F_NAN
  errors = Abs(Alog10(counts + errors) - Alog10(counts - errors))
  counts = Alog10(Temporary(counts))
endif

; If autoscaling plot then normalize the data so its maximum value
; close to E=0 is 1
if (autoscaleFlag) then begin
  index = where(energy ge -2.0 and energy le 2.0, nRange)
  maxInt = (nRange gt 0)? max(counts[index]) : max(counts)
  counts = counts/abs(maxInt)
  errors = errors/abs(maxInt)
  yTitle = 'Scaled Intensity'
endif

;; sanitize errors; replace zero with 1
index = where(errors le 0.0, zeroError)
if (zeroError gt 0) then errors[index] = 1.0

; Create objects to store data to be plotted
oX = oItem->GetByName('Independent',count=found)
oZ = oItem->GetByName('Dependent',count=found)
oE = oItem->GetByName('Error',count=found)
;oC = oItem->GetByName('Calc',count=found)
oZ->AddMetaData,'Long_name', yTitle
oZ->AddMetaData,'Units', yUnits
oX->AddMetaData,'Long_name', xTitle
oX->AddMetaData,'Units', xUnits
ctype = partype(counts)
status = oZ->SetData(counts,/no_copy,/no_notify)
status = oE->SetData(errors,/no_copy,/no_notify)
status = oX->SetData(energy,/no_copy,/no_notify)
oZ->SetProperty, type=ctype
oX->SetProperty, type=ctype
oE->SetProperty, type=ctype
;if (examiningFits) then begin
;  status = oC->SetData(yFit,/no_copy,/no_notify)
;  oC->SetProperty, type=ctype
;endif

axisHasChanged = 0
msg = []

strparms = ['Y','X','Y ERROR','X ERROR','VERTICES','PALETTE','VERTEX_COLORS']
idparms = [oZ->GetFullIdentifier() $
          ,oX->GetFullIdentifier() $
          ,oE->GetFullIdentifier() $
          ,'','','','']
visID = 'PLOT'
opID = 'Operations/Insert Visualization'
oRequester = (Self->GetByIdentifier(opID))->GetObjectInstance()
oRequester->_setTool, Self
oRequester->GetProperty, show_execution_ui = orig_showUI
oRequester->SetProperty, show_execution_ui = 0

oItem->GetProperty, name=plotName   ; retrieve the dataset name as shown in the data manager and set it as plotname
oRequester->SetProperty, name=plotName, parameter_names=strParms, data_ids=idParms, visualization_id=visID

oWin = Self->GetCurrentWindow()
oView = oWin->GetCurrentView()
activateManip = 0
rangeChange = 0

noOverplot = overplotFlag eq 0
if (Self->HasVisualizations() && noOverplot) then begin
   ;; store the active manipulator
   (*sPtr).manipID = (Self->GetCurrentManipulator())->GetFullIdentifier()
   activateManip = 1

   ;; ensure the existing visualization is selected
   oLayer = oView->GetCurrentLayer()
   oWorld = oLayer->GetWorld()
   oDataSpace = oWorld->GetDataSpaces()
   oVis = oDataSpace->GetVisualizations(count = nVis)
    
   ; retrieve current xrange and yrange to determine if user has zoomed plot
   oDataSpace->GetProperty, xrange=xr, yrange=yr
   xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1]) 
   yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1]) 
   rangeChange = xChange && yChange
   
   delID = 'Operations/Edit/Delete'
   oDelete = (Self->GetByIdentifier(delID))->GetObjectInstance()
   
   oDataSpace->Select
   void = oDelete->DoAction(Self)

   obj_destroy, [oVis,oDataSpace]
   
   ; delete any residual annotations that may have been added
   annID = oView->FindIdentifiers('*ANNOTATION LAYER*',count=nAnn)
   if (nAnn gt 2) then begin
     oVoid = []
     for i=2, nAnn-1 do begin
       oTmp = Self->GetByIdentifier(annID[i])
       oTmp->Select
       oVoid = [oVoid,oTmp]
     endfor
     void = oDelete->DoAction(Self) ; delete selected anootations
     obj_destroy, oVoid
   endif

endif

; create the new vis
oCmd = oRequester->DoAction(Self)

;; add an overplot if plotFlag = 2,3,6
;if (examiningFits) then begin
;  ; add a line plot of the fit to the existing data plot
;  idparms = [oC->GetFullIdentifier() $
;    ,oX->GetFullIdentifier() $
;    ,'','','','','']
;
;  oRequester->SetProperty,parameter_names=strParms,data_ids=idParms,visualization_id=visID
;  oVoid = oRequester->DoAction(Self)
;endif

;; Get the newly created vis
oLayer = oView->GetCurrentLayer()
oWorld = oLayer->GetWorld()
oDataSpace = oWorld->GetDataSpaces()
oVis = oDataSpace->GetVisualizations(count = nVis)

; And Customize it
colors = [[0,0,0],[0,0,255],[0255,0,0],[0,255,0],[0,255,255],[255,0,255] $
  ,[128,255,0],[255,128,0],[0,255,128],[128,128,255],[255,128,128] $
  ,[128,255,128],[128,128,128],[255,255,0]]
nColors = n_elements(colors)/3
pos = pos mod nColors
Self->SetProperty, s_color=colors[*,pos], s_sym_color=colors[*,pos], s_use_default_color=1 $
  , s_errorbar_color=colors[*,pos], s_sym_fill_color=colors[*,pos]
Self->CustomizeVis, oVis[nVis-1], plotName, 'SAMPPLOT'
if (noOverplot) then oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only


; Update Plot Title text to reflect name of dataset being plotted
; The plot title annotation was automatically created when visualization was first created so
; all we need to do is change the text string
annID = oView->Findidentifiers('*ANNOTATION LAYER*',count=nAnn)
if (nAnn gt 0) then begin
  oText = Self->Getbyidentifier(annID[1])
  ;oItem->Getproperty, name=visname
  if (Isa(oText,'IDLitvisText')) then begin
    oText->Setproperty, string=title
  endif
endif

if (activateManip) then Self->ActivateManipulator, (*sPtr).manipID
Self->RefreshCurrentWindow   ;oWin->Draw   ; force window to refresh

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::ConvertToDavePtr
;
; PURPOSE:
;   Convert selected dataset to its davePtr structure equivalent
;
; PARAMETERS:
;   oPSet [in] - object whose data is to be updated
;
; KEYWORDS:
;   dataHash [in] - a hash data structure that contains all info about one complete dataset.
;
; RETURN VALUE:
;   a davePtr if successful or a null pointer if not
;-
function Hfbstool::ConvertToDavePtr, oPSet, dataHash=dataHash, nameTag=nameTag, texToText=texToText,mondata=mondata

oUI = Self->Getui()
oUI->Getproperty, group_leader = wTLB

;; if dataHash is passed in then use it instead, otherwise retrieve it from the parameterset
;if (N_elements(dataHash) eq 0) then begin
;  oPSet->Getproperty, name=nameTag
;  void = oPSet->Getmetadata('DATAHASH',pDataHash)
;  dataHash = *pDataHash
;  if (~Obj_isa(dataHash,'hash')) then Return, ptr_new()
;endif else begin
;  nametag = (File_basename(dataHash['filename'],'.hfbs'))[0]
;endelse

oPSet->GetProperty, type=dataType, name=nameTag

switch strlowcase(dataType) of
  'samp': begin
    ; Retrieve info from current property sheet settings
    Self->Getproperty, sumSampFlag=sumSampFlag
    if (sumSampFlag) then begin
      ; retrieve the data from the folder
      oFolder = Self->Getselectedsamplefolder()  ; Get the sample folder first
      if (~Obj_valid(oFolder)) then Return, ptr_new()
      void = oFolder->Getmetadata('DATAHASH',pDataHash)
      dataHash = *pDataHash
      if (~Obj_isa(dataHash,'hash')) then Return, ptr_new()
    endif else begin
      ; retrieve the data from the selected dataset
      void = oPSet->Getmetadata('DATAHASH',pDataHash)
      dataHash = *pDataHash
      if (~Obj_isa(dataHash,'hash')) then Return, ptr_new()
    endelse
    trmt = dataHash['finaltreatment']

    ; Retrieve the data to plot
    Self->Getproperty, grpNos=grpNos, autoscaleFlag=autoscaleFlag
    counts = dataHash['finalCounts']
    errors = dataHash['finalErrors']
    energy = dataHash['eTransfer']
    qVal = dataHash['finalqVals']
    title = 'Intensity'
    units = 'arb. units'
    xTitle = (keyword_set(texToText))? Tex2IDL(dataHash['xLabel']) : dataHash['xLabel']
    xUnits = (keyword_set(texToText))? Tex2IDL(dataHash['xUnits']) : dataHash['xUnits']
    break
  end
  
  'bkgd':
  'van': begin

    ; Retrieve info from current property sheet settings
    if (Strcmp(dataType,'bkgd',/fold)) then begin
      Self->Getproperty, sumBkgdFlag=sumFlag, bkgdContRef=oCont
    endif else begin
      sumFlag = 1
      Self->Getproperty, vanContRef=oCont
    endelse
    if (sumFlag) then begin
      ; retrieve the data from the folder
      oPSet = oCont->Get(position=0)  ; Get the first bkgd dataset
      if (~Obj_valid(oPSet)) then Return, ptr_new()
      void = oPSet->Getmetadata('COMBDATAHASH',pDataHash)
      dataHash = *pDataHash
      if (~Obj_isa(dataHash,'hash')) then Return, ptr_new()
      Print,dataHash['filename']
    endif else begin
      ; retrieve the data from the selected dataset
      void = oPSet->Getmetadata('DATAHASH',pDataHash)
      dataHash = *pDataHash
      if (~Obj_isa(dataHash,'hash')) then Return, ptr_new()
      Print,dataHash['filename']
    endelse
    trmt = dataHash['treatment']

    Self->Getproperty, grpNos=grpNos, autoscaleFlag=autoscaleFlag
    counts = dataHash['corCounts']
    errors = dataHash['corErrors']
    energy = dataHash['eTransfer']
    qVal = dataHash['qVals']
    title = 'Intensity'
    units = 'arb. units'
    xTitle = (keyword_set(texToText))? Tex2IDL(dataHash['xLabel']) : dataHash['xLabel']
    xUnits = (keyword_set(texToText))? Tex2IDL(dataHash['xUnits']) : dataHash['xUnits']
    ;title = 'Q = '+String(qVal,format='(F5.3)')+' $\AA^{-1}$'
    break
  end
endswitch

header = dataHash['header']
liveTime = 1.0
ind = Where(Stregex(header,'#Cycle Time',/bool,/fold_case))
if (ind[0] ge 0) then begin
  toks = Strsplit(header[ind[0]],':',/extract,count=nTok)
  liveTime = float(toks[1])
endif
;
comments = ''
toks = Strsplit(header[0],':',/extract,count=nTok)
if (nTok gt 1) then comments = toks[1]
;
nDet = n_elements(qVals)
cRates = 60.0*float(total(counts[*,1:nDet-1],1))/float(livetime)

specific = {nchan:n_elements(energy),$
  ndet:n_elements(qVal),$
  header:header, $
  monPtr:Ptr_new(counts[*,0]),$
  monErrPtr:Ptr_new(errors[*,0]),$
  ncycles:Fix(dataHash['numCycles']),$
  phiPtr:Ptr_new(dataHash['detAngles']),$
  instrument:'HFBS',$
  wavelength:dataHash['lambda'],$
  camType:'triangular',$
  daqmode:'inelastic',$
  dopplerFrequency:mean(dataHash['dopFreq']),$
  date:Systime(),$
  user:dataHash['user'],$
  temp_sample:dataHash['temp'],$
  temp_setpoint:dataHash['temp'],$
  temp_control:dataHash['temp'],$
  livetime:livetime, $
  comments:comments,$
  sumfc:total(counts[*,0]),$
  sumtbm:total(dataHash['tbm']),$
  sumwbm:total(dataHash['wbm']),$
  wbmRate:60.0*Float(Total(dataHash['wbm']))/Float(livetime),$;
  wbmRateErr:60.0*Sqrt(Float(Total(dataHash['wbm'])))/Float(livetime),$;
  cRates:cRates}

yunits = (keyword_set(texToText))? Tex2IDL('$\AA^{-1}$') :  '$\AA^{-1}$'

retval = Create_dave_pointer(davePtr, $  ;self.davePtr,   $
  qty = counts[*,1:nDet-1],   $
  err = errors[*,1:nDet-1],    $
  xvals = energy,            $
  yvals = qVal,      $
  specificstr = specific,      $
  instrument = 'HFBS',      $
  xtype = 'POINTS',        $
  ytype = 'POINTS',        $
  xlabel = xTitle,         $
  ylabel = 'Q',         $
  qtlabel = title,      $
  xunits = xUnits,         $
  yunits = yunits,         $
  qtunits = units,      $
  dname = 'T',          $
  dunits = 'temperature:K',     $
  dlegend = 'Temperature',    $
  dqty = mean(dataHash['temp']),         $
  derr = 0.0,            $
  treatment = trmt,   $
  ermsg = ermsg           )
  
monData = fltarr(n_elements(energy),3)
mondata[*,0] = energy
mondata[*,1] = counts[*,0]
mondata[*,2] = errors[*,0]

return, davePtr

end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::saveAsASCII
;
; PURPOSE:
;   Save output to file using DAVE format
;
; PARAMETERS:
;
; KEYWORDS:
;
function HfbsTool::SaveAsASCII, oItem
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB


if (N_elements(oItem) eq 0) then begin
  ; if object is not passed in then retrieve from selection
  Self->Getproperty, selectedIDs=selIDs,nSelectedIDs=nSel
  if (nSel eq 0) then Return, 0
  for i=0, nSel-1 do begin
    oItem = Self->Getbyidentifier(selIDs[i])
    if (Obj_valid(oItem) && Obj_isa(oItem,'IDLitParameterSet')) then break
  endfor
endif

if (~obj_valid(oItem) || ~obj_isa(oItem,'IDLitParameterSet')) then return, 0

davePtr = Self->ConvertToDavePtr(oItem, nameTag=nametag)
if (~ptr_valid(davePtr)) then return, 0

if ((n_elements(nameTag) le 0) || (strtrim(nameTag,2) eq '')) then nameTag='Untitled'

if (ptr_valid(davePtr)) then begin  
  oData = DaveDataset(davePtr=davePtr,nameTag=nameTag)
  if (~oData->toASCIIColumn(dataColumns,header,errorMsg)) then return, 0
  obj_destroy, oData  ; done with this, simply needed to extract column data from davePtr structure.

  Self->Getproperty, working_directory=workDir
  title = "Specify filename to store ASCII format data"
  ext = 'txt'
  filename = Dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
    ,/overwrite_prompt, file=nameTag+'.txt',path=workDir, get_path=new_workDir,filter=['*.txt'],/write)
  if (filename eq '') then return, 0

  ;; write to disk and inform user of ouput destination
  msgTxt = 'Include header (column titles) in data file?'
  myTitle = 'Save as ASCII column text file'
  status = Self->Promptuseryesno(msgTxt,headerFlag,title=myTitle)

  ;; open output file
  Openw, lun, filename, /get_lun
;  ;; Deal with masked data.
;  ; Replace NaNs with a filler value of -1e20
;  index = Where(Finite(dataColumns,/NAN),nMask)
;  if (nMask gt 0) then dataColumns[index] = -1e20

  dims = Size(dataColumns,/dimensions)
  ncols = dims[0]
  nx = dims[1]
  fmt = '('+Strtrim(String(ncols),2)+'(A13,2X))'
  if (headerFlag) then Printf, lun, format=fmt,header
  fmt = '('+Strtrim(String(ncols),2)+'(E13.5,2X))'
  for i = 0,nx-1 do Printf, lun, format=fmt,dataColumns[*,i]

  Free_lun, lun, /force
  
  msg = 'Output stored in: '+filename
  Self->Statusmessage, msg
endif

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::SaveMonAsASCII
;
; PURPOSE:
;   Save output to file using DAVE format
;
; PARAMETERS:
;
; KEYWORDS:
;
function Hfbstool::SaveMonAsASCII, oItem
  compile_opt idl2

  oUI = Self->Getui()
  oUI->Getproperty, group_leader = wTLB


  if (N_elements(oItem) eq 0) then begin
    ; if object is not passed in then retrieve from selection
    Self->Getproperty, selectedIDs=selIDs,nSelectedIDs=nSel
    if (nSel eq 0) then Return, 0
    for i=0, nSel-1 do begin
      oItem = Self->Getbyidentifier(selIDs[i])
      if (Obj_valid(oItem) && Obj_isa(oItem,'IDLitParameterSet')) then break
    endfor
  endif

  if (~Obj_valid(oItem) || ~Obj_isa(oItem,'IDLitParameterSet')) then Return, 0

  davePtr = Self->Converttodaveptr(oItem, nameTag=nametag, mondata=dataColumns)
  if (~Ptr_valid(davePtr)) then Return, 0

  if ((N_elements(nameTag) le 0) || (Strtrim(nameTag,2) eq '')) then nameTag='Untitled'

  if (Ptr_valid(davePtr)) then begin
    Self->Getproperty, working_directory=workDir
    title = "Specify filename to store Monitor data in ASCII format"
    ext = 'txt'
    filename = Dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
      ,/overwrite_prompt, file=nameTag+'_mon.txt',path=workDir, get_path=new_workDir,filter=['*.txt'],/write)
    if (filename eq '') then Return, 0

    ;; open output file
    Openw, lun, filename, /get_lun

    dims = Size(dataColumns,/dimensions)
    ncols = dims[1]
    nx = dims[0]
    fmt = '('+Strtrim(String(ncols),2)+'(E13.5,2X))'
    for i = 0,nx-1 do Printf, lun, format=fmt,dataColumns[i,*]

    Free_lun, lun, /force

    msg = 'Output stored in: '+filename
    Self->Statusmessage, msg
  endif

  Return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::saveAsDave
;
; PURPOSE:
;   Save output to file using DAVE format
;
; PARAMETERS:
;
; KEYWORDS:
;
function HfbsTool::SaveAsDave, oItem
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

if (N_elements(oItem) eq 0) then begin
  ; if object is not passed in then retrieve from selection
  Self->Getproperty, selectedIDs=selIDs,nSelectedIDs=nSel
  if (nSel eq 0) then Return, 0
  for i=0, nSel-1 do begin
    oItem = Self->Getbyidentifier(selIDs[i])
    if (Obj_valid(oItem) && Obj_isa(oItem,'IDLitParameterSet')) then break
  endfor
endif

if (~obj_valid(oItem) || ~obj_isa(oItem,'IDLitParameterSet')) then return, 0

davePtr = Self->ConvertToDavePtr(oItem, nameTag=nametag)
if (~ptr_valid(davePtr)) then return, 0

if ((n_elements(nameTag) le 0) || (strtrim(nameTag,2) eq '')) then nameTag='Untitled'
    
if (ptr_valid(davePtr)) then begin

   Self->GetProperty, working_directory=workDir
   title = "Specify filename to store DAVE format data"
   ext = 'dave'
   filename = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
                          ,/overwrite_prompt, file=nameTag+'.dave',path=workDir, get_path=new_workDir,/write,filter=['*.dave'])
                          
   if (~strcmp(filename,'')) then begin
      save, davePtr, filename=filename
      if (file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir
   
      msg = 'Output stored in: '+filename
      Self->StatusMessage, msg
   endif
   
   heap_free, davePtr
endif

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::ExportToDaveDM
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function HfbsTool::ExportToDaveDM, oItems
compile_opt idl2

; Basic error Handler
if (N_elements(!debug) && (!debug eq 0)) then begin
  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'HfbsTool::ExportToDaveDM: Error encountered'
    eMsg = 'An error or unusual condition was encountered!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
    Catch, /cancel
    Self->Enableupdates
    Return, 0
  endif
endif

if (n_elements(oItems) eq 0) then begin
  ; if object is not passed in then retrieve the selection
  Self->GetProperty, selectedIDs=selIDs,nSelectedIDs=nSel
  if (nSel eq 0) then return, 0 
  oItems  = []
  for i=0, nSel-1 do begin
    oTmp = Self->GetByIdentifier(selIDs[i])
    if (obj_valid(oTmp) && obj_isa(oTmp,'IDLitParameterSet')) then oItems = [oItems,oTmp]
  endfor
endif

nItems = n_elements(oItems)

for i=0,nItems-1 do begin
  oItem = oItems[i]
  davePtr = Self->ConvertToDavePtr(oItem, nameTag=nametag)
  if (~ptr_valid(davePtr)) then return, 0
  
  if ((n_elements(nameTag) le 0) || (strtrim(nameTag,2) eq '')) then nameTag='Untitled'
      
  ; Send data to DAVE Data Manager Folder
  Self.DAVETool->AddDavePtrToDataManager, davePtr, nameTag
   
  msg = "New extry '"+nameTag+"' created in DAVE Data Manager"
  Self->StatusMessage, msg
  
  heap_free, davePtr
endfor

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::exportToPAN
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function HfbsTool::exportToPAN, oItems
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        Self->StatusMessage, !ERROR_STATE.msg
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
notifyIDs = [wTLB,wTLB]
Self->GetProperty, working_directory=workDir, data_directory=dataDir

if (N_elements(oItems) eq 0) then begin
  ; if object is not passed in then retrieve the selection
  Self->Getproperty, selectedIDs=selIDs,nSelectedIDs=nSel
  if (nSel eq 0) then Return, 0
  oItems  = []
  for i=0, nSel-1 do begin
    oTmp = Self->Getbyidentifier(selIDs[i])
    if (Obj_valid(oTmp) && Obj_isa(oTmp,'IDLitParameterSet')) then oItems = [oItems,oTmp]
  endfor
endif

nItems = N_elements(oItems)

for i=0,nItems-1 do begin
  oItem = oItems[i]

  davePtr = Self->ConvertToDavePtr(oItem)
  if (~ptr_valid(davePtr)) then return, 0
  
  if (ptr_valid(davePtr)) then  begin
     oVoid = obj_new('OPAN',notifyID=[wTLB,wTLB],group_leader=wTLB $
                  ,davePtr=davePtr,workDir=workDir,daveTool=Self.davetool,dataDir=dataDir)
     heap_free, davePtr
  endif
endfor

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::saveProperties
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function HfbsTool::SaveProperties
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'HfbsTool::saveProperties: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

print, 'properties saved...'

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::WriteProjectAs
;
; PURPOSE:
;   save project (data plus state) to file
;
; PARAMETERS:
;
; KEYWORDS:
;-
function HfbsTool::WriteProjectAs
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'HfbsTool::writeProjectAs: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

Self->GetProperty, nSamp=_nSamp, working_directory=workDir
if (_nSamp le 0) then begin
   msg = 'No data in current session so cannot proceed with save action!'
   Self->StatusMessage, msg
   Self->ErrorMessage, msg, severity=0, title='Save Unnecessary!'
   return, 0
endif


projName = file_basename(Self.projName,/fold_case,'.tisv')
oSamp = Self.sampContRef->Get(position = 0)
if (strcmp(projName,'Untitled',/fold_case) && obj_valid(oSamp)) then begin
   oSamp->GetProperty, description=desc
   projName = file_basename(desc,/fold_case,'.bt7')
   ; replace spaces in filename with _
   while ((pos = stregex(projName,' ')) ne -1) do strput, projName,'_',pos
endif
title = "Specify filename to store session"
ext = 'tisv'
filter = ['*.tisv']
projName = dialog_pickfile(title=title,filter=filter,default_extension=ext $
                          ,dialog_parent=wTLB, /write $
                          ,/overwrite_prompt, file=projName+'.tisv' $
                          ,path=workDir, get_path=new_workDir)

if (strcmp(projName,'')) then return, 0 

return, Self->writeProject(/noPrompt, new_workDir=file_dirname(projName,/mark_dir), new_projName=file_basename(projName,/fold_case,'.tisv'))

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; HfbsTool::WriteProject
;
; PURPOSE:
;   save project (data plus state) to file
;
; PARAMETERS:
;
; KEYWORDS:
;-
function HfbsTool::WriteProject, noPrompt=noPrompt, new_workDir=new_workDir,new_projName=new_projName 
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'HfbsTool::writeProject: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

; save session preferences
status = Self->SavePreferences(/skip_filesave)

Self->GetProperty, nSamp=_nSamp,nBkgd=_nBkgd,nVan=_nVan, nosSampFolder=_nSampFolder $
                 ;, minIntensity=_minIntensity, maxIntensity=_maxIntensity $
                 , preferences=_prefStr, working_directory=workDir
noData = (_nSamp le 0) && (_nBkgd le 0) && (_nVan le 0)
if (noData) then begin
   msg = 'No data in current session so cannot proceed with save action!'
   Self->StatusMessage, msg
   Self->ErrorMessage, msg, severity=0, title='Save Unnecessary!'
   return, 0
endif

projName = (keyword_set(new_projName))? new_projName : Self.projName
if (keyword_set(new_workDir)) then workDir = new_workDir

if (keyword_set(noPrompt)) then begin
   projName = workDir+projName+'.tisv'
endif else begin
   projName = Self.projName
   oSamp = Self.sampContRef->Get(position = 0)
   if (strcmp(projName,'Untitled',/fold_case) || strcmp(projName,'')) then begin
      oSamp->GetProperty, description=desc
      projName = file_basename(desc,/fold_case,'.hfbs')
      ; replace spaces in filename with _
      while ((pos = stregex(projName,' ')) ne -1) do strput, projName,'_',pos

      title = "Specify filename to store session"
      ext = 'tisv'
      filter = ['*.tisv']
      projName = dialog_pickfile(title=title,filter=filter,default_extension=ext $
                                ,dialog_parent=wTLB, /write $
                                ,/overwrite_prompt, file=projName+'.tisv' $
                                ,path=workDir, get_path=new_workDir)
      ;projName = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
      ;                       ,/overwrite_prompt, file=projName+'.tisv',path=workDir, get_path=new_workDir)

   endif else projName = workDir+projName+'.tisv'
endelse
if (strcmp(projName,'')) then return, 0

_datasets = []
if (_nSamp gt 0) then _datasets = (Self.sampContRef->Get(/all))[0:_nSamp-1]
if (_nBkgd gt 0) then _datasets = [_datasets,(Self.bkgdContRef->Get(/all))[0:_nBkgd-1]]
if (_nVan gt 0) then _datasets = [_datasets,(Self.vanContRef->Get(/all))[0:_nVan-1]]

_sampFolders = Self.sampFoldCont->Get(/all, count=_nSampFolders)
;nd = n_elements(_datasets)
;_dataPtrs = ptrarr(nd)
;for i=0,nd-1 do begin
;   void = _datasets[i]->Getmetadata('DATAHASH',pDataHash)
;   _dataPtrs[i] = pDataHash
;endfor
 
save, _datasets, _sampFolders, _prefStr, _nSamp, _nBkgd, _nVan, _nSampFolders $ , _dataPtrs
    ;, _minIntensity, _maxIntensity $
    , description = 'HFBS Data Reduction Session' $
    , filename=projName, /compress
if (isa(new_workDir) && file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir

msg = 'Session stored in: '+projName
Self->StatusMessage, msg
 
projName = file_basename(projName,/fold_case,'.tisv')
Self.projName = projName
Self->SetProperty, tool_filename=projName
 
Self.modifiedFlag = 0

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; HfbsTool::readProject
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function HfbsTool::ReadProject
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'HfbsTool::ReadProject: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        if (obj_valid(oSave)) then obj_destroy, oSave
        Self->EnableUpdates
        return, 0
    endif
endif

filter = '*.tisv'
Self->GetProperty, working_directory=workDir
if (n_elements(title) eq 0) then title='Specify session to load'

filename = dialog_pickfile(title=title,/must_exist, dialog_parent=wTLB $
                       ,filter=filter,path=workDir, get_path=newWorkDir)

if (filename eq '') then return, 0
Self->SetProperty, work_directory=newWorkDir

oSave = obj_new('IDL_Savefile', filename)
contents = oSave->Contents()
obj_destroy, oSave
expectedDesc='HFBS Data Reduction Session'
if (~strcmp(contents.description,expectedDesc,/fold_case)) then begin
   msg = 'Not a valid HFBS Reduction session file!'
   Self->StatusMessage, msg
   Self->ErrorMessage, msg, severity=1, title='Invalid file type!'   
   return, 0
endif

restore, filename, restored_objects=oObj, /relaxed_structure_assignment
nObj = n_elements(oObj)
if (nObj le 0) then return, 0

; Check whether or not to save current session before closing it
if (Self.modifiedFlag) then begin
   ; If our current state is dirty, prompt to save first.
   Self->GetProperty, working_directory=workDir
   outfile = workDir+Self.projName+'.tisv'
   status = self->PromptUserYesNo( $
       "Save changes to " + outfile + "?", $
       answer, $
       DEFAULT_NO=0, $
       TITLE='Save', $
       /CANCEL)

   if (status && (answer eq 1)) then begin
      void = Self->writeProject(/noPrompt)
   endif

endif

Self->DisableUpdates

; delete all datasets in current session
void = Self->DeleteAllDatasets(/noPrompt)

; delete all sample folders
oFolders = Self.sampFoldCont->Get(/all, count=nFolders)
if (nFolders gt 0) then Self->Delsampfolder, oFolders

projName = file_basename(filename,/fold_case,'.tisv')
Self.projName = projName

; update preferences structure to most current definition
status = HFBSReducPreferences(_prefStr,/updateVersion) 

Self->SetProperty, preferences=_prefStr, tool_filename=projName

; Restore sample folders (which also include sample datasets)
if (_nSampFolders gt 0) then begin
  for i=0, _nSampFolders-1 do begin
    Self.nosSampFolder++  ; increment count
    Self.sampFoldCont->Add, _sampFolders[i]
    Self->AddByIdentifier, 'Sample Data Manager', _sampFolders[i]
  endfor
endif

; restore datasets into their containers
nd = n_elements(_datasets)
for i=0, nd-1 do begin
  oData = _datasets[i]
  Self->restoreDataVersion, oData
  oData->GetProperty, type=dataType
  case dataType of
    
    'samp': begin
        ; sample datasets were already added to the hierarchy with the sample folders earlier
       Self.sampContRef->Add, oData
    end
    
    'bkgd': begin
       Self->AddByIdentifier, 'Bkgd Data Manager', oData ;, position=0
       Self.bkgdContRef->Add, oData
    end
    
    'van': begin
      Self->Addbyidentifier, 'Van Data Manager', oData ;, position=0
      Self.vanContRef->Add, oData
    end
    
    else:
  
  endcase
endfor
Self.nSamp = _nSamp
if (n_elements(_nBkgd) gt 0) then Self.nBkgd = _nBkgd
if (n_elements(_nVan) gt 0) then Self.nVan = _nVan

Self->UpdatePropertySheet
Self->Refreshpropertysheet

;; Select a dataset and plot it
if (_nSamp gt 0) then begin
   oItem = Self.sampContRef->Get(position = 0)
   dataType='samp'
endif else if (_nBkgd gt 0) then begin
   oItem = Self.sampContRef->Get(position = 0)
   dataType='bkgd'
endif 

if (obj_valid(oItem)) then begin
   (*sPtr).itemID = oItem->GetFullIdentifier()
   cw_hfbsDataManager_Setselect, (*sPtr).wDM, (*sPtr).itemID, /clear, dataType=dataType ; select it

   wd_HfbsTool_sendPlotEvent, oUI, oItem  ; plot it
endif

Self.modifiedFlag = 0
Self->EnableUpdates
return, 1
end
;-------------------------------------------------------------------------------


;---------------------------------------------------------------------------
; Lifecycle Routines
;---------------------------------------------------------------------------
; HfbsTool::Init
;
; Purpose:
; The constructor of the HfbsTool object.
;
; Parameters:
; None.
;
function HfbsTool::Init, _REF_EXTRA=_EXTRA
compile_opt idl2

;; Call our super class
if (~self->IDLitTool::Init(_EXTRA=_extra)) then $
  return, 0

oSystem = self->_GetSystem()

; Specify current data version number
; Essentially, whevever the data structure used to store 
; datasets changes the version number should be incremented to reflect
; this. When the version number changes, restoreDataVersion() must also
; be modified to handle restoring older version datasets to the
; current version.
Self.dataVersion = 1

; Add a 'DAVEDATA_MANAGER' service
;self->AddService, OBJ_NEW("DAVEsrvDatamanager", name="DAVEDATA_MANAGER")

; Create the data manager folders
oSampManagerFolder = Obj_New("IDLitDataManagerFolder", identifier='Sample Data Manager' $
                      ,name='Sample', description='Sample Data Manager Container',tool=self)
oBkgdManagerFolder = Obj_New("IDLitDataManagerFolder", identifier='Bkgd Data Manager' $
                      ,name='Background', description='Bkgd Data Manager Container',tool=self)
oVanManagerFolder = Obj_New("IDLitDataManagerFolder", identifier='Van Data Manager' $
                      ,name='Vanadium', description='Van Data Manager Container',tool=self)
self->Add, [oSampManagerFolder,oBkgdManagerFolder,oVanManagerFolder]


self->createfolders,'Operations/       ',NAME='', description='Horizontal Space'
;;---------------------------------------------------------------------
;;*** File Menu

;; create folders
self->createfolders,'Operations/File',NAME=IDLitLangCatQuery('Menu:File')

self->RegisterOperation, 'Open Session', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='File/readProject'

self->RegisterOperation, 'Save Session', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/writeProject'
self->RegisterOperation, 'Save Session As', $
  'DAVEopMenuItem',icon='Save_24', IDENTIFIER='File/writeProjectAs'

                                ;-----------------
Self->RegisterOperation,'Export Graphics...' $
  ,'DAVEopExportGraphics' $
  ,identifier='File/Export' $
  ,ACCELERATOR='Ctrl+E' $
  ,writertypes=['IDLDEST','IDLIMAGE'] $
  ,icon='export',/separator

self->RegisterOperation, IDLitLangCatQuery('Menu:File:PrintPreview'), $
  'IDLitopPrintPreview', $
  DESCRIPTION='Print the contents of the active window', $
  IDENTIFIER='File/PrintPreview', ICON='print'

self->RegisterOperation, IDLitLangCatQuery('Menu:File:Print'), $
  'IDLitopFilePrint', $
  ACCELERATOR='Ctrl+P', $
  DESCRIPTION='Print the contents of the active window', $
  IDENTIFIER='File/Print', ICON='print_24'


self->RegisterOperation, 'Save Preferences', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/savePreferences',/separator

self->RegisterOperation, 'Reset Preferences (Default Values)', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/resetPreferences'


                                ;-----------------
self->RegisterOperation, 'Exit', 'DAVEopMenuItem', ACCELERATOR='Ctrl+Q', $
  IDENTIFIER='File/Exit', /SEPARATOR

self->RegisterOperation, 'ExitOp', 'DAVEopFileExit', IDENTIFIER='ExitOp'


;-----------
; Data Input Menu
self->createfolders,'Operations/Input',NAME='Data Input'

;self->RegisterOperation, 'Load PSD Calibration Parameters file', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadCalibParams'

self->RegisterOperation, 'New Sample Folder', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/AddSampFolder'

self->Registeroperation, 'Load Signal file(s)', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadSamp', /separator
self->RegisterOperation, 'Load Signal file(s) (NCNR ftp server)', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadSampFtp'

self->RegisterOperation, 'Load Bkgd file(s)', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadBkgd', /separator
self->RegisterOperation, 'Load Bkgd file(s) (NCNR ftp server)', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadBkgdFtp'

self->RegisterOperation, 'Load Vanadium file(s)', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadVan', /separator
self->RegisterOperation, 'Load Vanadium file(s) (NCNR ftp server)', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadVanFtp'

self->RegisterOperation, 'Delete All Loaded Data', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/deleteAllDatasets',/separator



;-----------
; Data Output Menu
self->createfolders,'Operations/Output',NAME='Data Output'
;
self->Registeroperation, 'Save Monitor data as ASCII file', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/SaveMonAsASCII', sensitive=0
  
self->RegisterOperation, 'Save output as DAVE file', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/saveAsDave', /separator, sensitive=0

self->RegisterOperation, 'Save output as ASCII file', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/saveAsAscii', sensitive=0

self->RegisterOperation, 'Export output to DAVE Data Maneger', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/exportToDaveDM', sensitive=0

self->RegisterOperation, 'Fit output in PAN', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/exportToPAN',/separator, sensitive=0



;;---------------------------------------------------------------------
;; Create our File toolbar container.
;;
self->Register, "Open Session", $
                PROXY='Operations/File/ReadProject', $
                IDENTIFIER='Toolbar/File/ReadProject'
self->Register, "Save Session", $
                PROXY='Operations/File/WriteProject', $
                IDENTIFIER='Toolbar/File/WriteProject'
self->Register, "Save Session As", $
                PROXY='Operations/File/WriteProjectAs', $
                IDENTIFIER='Toolbar/File/WriteProjectAs'
self->Register, IDLitLangCatQuery('Menu:File:Print'), $
                PROXY='Operations/File/Print', $
                IDENTIFIER='Toolbar/File/Print'
self->Register, IDLitLangCatQuery('Menu:File:PrintPreview'), $
                PROXY='Operations/File/PrintPreview', $
                IDENTIFIER='Toolbar/File/PrintPreview'
self->Register, IDLitLangCatQuery('Menu:File:Export'), $
                PROXY='Operations/File/Export', $
                IDENTIFIER='Toolbar/File/Export'


;;---------------------------------------------------------------------
;;*** Edit Menu

self->createfolders,'Operations/Edit',NAME=IDLitLangCatQuery('Menu:Edit')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Undo'), $
  'IDLitopUndo', $
  ACCELERATOR='Ctrl+Z', $
  IDENTIFIER='Edit/Undo', ICON='undo', /disable, $
  /IGNORE_AVAILABILITY

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Redo'), $
  'IDLitopRedo', $
  ACCELERATOR='Ctrl+Y', $
  IDENTIFIER='Edit/Redo', ICON='redo',/disable, $
  /IGNORE_AVAILABILITY

;; Clipboard...note these are proxied from the system registry!

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Cut'), $
  PROXY="/REGISTRY/OPERATIONS/CUT",$
  IDENTIFIER='Edit/Cut'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Copy') , $
  PROXY='/REGISTRY/OPERATIONS/COPY', $
  IDENTIFIER='Edit/Copy'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Paste') , $
  PROXY='/REGISTRY/OPERATIONS/Paste', $
  IDENTIFIER='Edit/Paste'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:PasteSpecial') , $
  PROXY='/REGISTRY/OPERATIONS/PASTESPECIAL', $
  IDENTIFIER='Edit/PasteSpecial'

                                ;-----------------
self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Delete') , $
  PROXY='/REGISTRY/OPERATIONS/Delete', $
  IDENTIFIER='Edit/Delete'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SelectAll') , $
  'IDLitopSelectAll', $
  DESCRIPTION="Select all visualizations in the current view.", $
  IDENTIFIER='Edit/SelectAll', $
  ICON='select'


                                ;-----------------
self->createfolders,'Operations/Edit/Grouping', $
                    NAME=IDLitLangCatQuery('Menu:Edit:Grouping')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Group'), $
  'IDLitopGroup', $
  IDENTIFIER='Edit/Grouping/Group', $
  ICON='group', $
  /SEPARATOR

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Ungroup'), $
  'IDLitopUngroup', $
  IDENTIFIER='Edit/Grouping/Ungroup', $
  ICON='ungroup'


;;---------------------------------------------------------------------
;;*** Format Menu

self->createfolders,'Operations/Edit/Style', $
                    NAME=IDLitLangCatQuery('Menu:Style')

self->RegisterOperation, IDLitLangCatQuery('Menu:Style:ApplyStyle') , $
  PROXY='/REGISTRY/OPERATIONS/Apply Style', $
  IDENTIFIER='Edit/Style/Apply Style'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Style:CreateStylefromSelection'), $
  'IDLitopStyleCreate', $
  IDENTIFIER='Edit/Style/Create Style', $
  ICON='style'

self->RegisterOperation, IDLitLangCatQuery('Menu:Style:StyleEditor'), $
  'IDLitopStyleEditor', $
  IDENTIFIER='Edit/Style/StyleEditor', $
  ICON='style'

self->RegisterOperation, 'Edit Parameters','IDLitopEditParameters'

Self->RegisterOperation, 'SaveProperties','DAVEopMenuItem',identifier='Edit/SaveProperties'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Properties'), $
  'IDLitopPropertySheet', $
  DESCRIPTION='Display the Property Sheet for the item', $
  IDENTIFIER='Edit/Properties', $
  ICON='propsheet'


;;---------------------------------------------------------------------
;; Create our Edit toolbar container.
;;
self->Register, IDLitLangCatQuery('Menu:Edit:Undo'), $
                PROXY='Operations/Edit/Undo', $
                IDENTIFIER='Toolbar/Edit/Undo'
self->Register, IDLitLangCatQuery('Menu:Edit:Redo'), $
                PROXY='Operations/Edit/Redo', $
                IDENTIFIER='Toolbar/Edit/Redo'
self->Register, IDLitLangCatQuery('Menu:Edit:Cut'), $
                PROXY="/REGISTRY/OPERATIONS/CUT",$
                IDENTIFIER='Toolbar/Edit/Cut'
self->Register, IDLitLangCatQuery('Menu:Edit:Copy'), $
                PROXY='/REGISTRY/OPERATIONS/COPY', $
                IDENTIFIER='Toolbar/Edit/Copy'
self->Register, IDLitLangCatQuery('Menu:Edit:Paste'), $
                PROXY='/REGISTRY/OPERATIONS/Paste', $
                IDENTIFIER='Toolbar/Edit/Paste'


;;---------------------------------------------------------------------
;;*** Insert menu

self->createfolders,'Operations/Insert', $
                    NAME=IDLitLangCatQuery('Menu:Insert')

self->RegisterOperation, 'Insert Visualization','IDLitopInsertVis';, $
;  IDENTIFIER='Insert/Visualization', ICON='view'


self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:View'), $
  'IDLitopInsertView', $
  IDENTIFIER='Insert/View', ICON='view'

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:DataSpace'), $
  'IDLitopInsertDataSpace';, $
  ;IDENTIFIER='Insert/Data Space', ICON='mcr'

;self->createfolders,'Operations/Insert/Axis', NAME=IDLitLangCatQuery('Menu:Insert:Axis')

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:XAxis'), $
  'IDLitOpInsertAxisX';, IDENTIFIER='Insert/Axis/X Axis', ICON='mcr'
self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:YAxis'), $
  'IDLitOpInsertAxisY';, IDENTIFIER='Insert/Axis/Y Axis', ICON='mcr'
self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:ZAxis'), $
  'IDLitOpInsertAxisZ';, IDENTIFIER='Insert/Axis/Z Axis', ICON='mcr'


;;---------------------------------------------------------------------
;;*** Operations Menu
self->createfolders,'Operations/Operations', $
                    NAME=IDLitLangCatQuery('Menu:Operations')

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:OperationsBrowser'), $
;  'IDLitopBrowserOperation', $
;  IDENTIFIER='Operations/Operations Browser' ; ,ICON='mcr'

self->createfolders,'Operations/Operations/Macros', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Macros')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RunMacro'), $
  PROXY='/Registry/MacroTools/Run Macro', $
  IDENTIFIER='Operations/Macros/Run Macro'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:StartRecording'), $
  PROXY='/Registry/MacroTools/Start Recording', $
  IDENTIFIER='Operations/Macros/Start Recording'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:StopRecording'), $
  PROXY='/Registry/MacroTools/Stop Recording', $
  IDENTIFIER='Operations/Macros/Stop Recording'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:MacroEditor'), $
  PROXY='/Registry/MacroTools/Macro Editor', $
  IDENTIFIER='Operations/Macros/Macro Editor'

self->createfolders,'Operations/Operations/Filter', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Filter')

;
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:Median'), $
  'IDLitopMedianFilter', $
  DESCRIPTION='Perform the median filter operation on the selected item', $
  IDENTIFIER='Operations/Filter/Median', ICON='sum'

self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Smooth'), $
  'IDLitopSmooth', $
  DESCRIPTION='Perform the smooth operation on the selected item', $
  IDENTIFIER='Operations/Filter/Smooth', ICON='sum'

self->createfolders,'Operations/Operations/Rotate', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Rotate')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateLeft'), $
  'IDLitopRotateLeft', $
  DESCRIPTION='Rotate left by 90 degrees', $
  IDENTIFIER='Operations/Rotate/RotateLeft', $
  ICON='rotate'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateRight'), $
  'IDLitopRotateRight', $
  DESCRIPTION='Rotate right by 90 degrees', $
  IDENTIFIER='Operations/Rotate/RotateRight', $
  ICON='rotate'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateByAngle'), $
  'IDLitopRotateByAngle', $
  DESCRIPTION='Rotate by a specified angle', $
  IDENTIFIER='Operations/Rotate/RotateByAngle', $
  ICON='rotate'


;;---------------------------------------------------------------------
;;*** Window Menu

self->createfolders,'Operations/Window', $
                    NAME=IDLitLangCatQuery('Menu:Window')

;;-----------------
Self->RegisterOperation, 'Reset to Default Data Range', 'IDLitopRangeReset' $
   ,description='Reset to default data range', identifier='Window/Resetrange' $
   ,icon='range_reset'

;;--
self->createfolders,'Operations/Toolbar/Dataspace',name='Dataspace'
self->Register, 'Reset to Default Data Range', $
                PROXY='Operations/Window/Resetrange', $
                IDENTIFIER='Toolbar/Dataspace/Resetrange'

self->createfolders,'Operations/Window/Canvas Zoom', $
                    NAME=IDLitLangCatQuery('Menu:Window:CanvasZoom')

self->RegisterOperation, '800%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/800%', $
  ICON='zoom', /CHECKED;, /SEPARATOR
self->RegisterOperation, '400%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/400%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '200%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/200%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '100%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/100%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '75%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/75%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '50%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/50%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '25%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/25%', $
  ICON='zoom', /CHECKED

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:ZoomonResize'), $
  'IDLitopZoomResize', $
  ICON='zoom', $
  IDENTIFIER='Window/ZoomResize', /CHECKED

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:Layout'), $
  'IDLitopWindowLayout', $
  IDENTIFIER='Window/Layout'

                                ;-----------------

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:FittoView'), $
  'IDLitopFitToView', $
  IDENTIFIER='Window/FitToView', $
  ICON='fitwindow', /SEPARATOR

;;---------------------------------------------------------------------
;;*** Help Menu
self->createfolders,'Operations/Help', $
                    NAME=IDLitLangCatQuery('Menu:Help')


self->RegisterOperation, "User's Manual", 'DAVEopHelp', $
  IDENTIFIER='Help/HFBSReductionManual',helptopic='HFBS_REDUCTION'
;-----------------

self->RegisterOperation, 'About HFBS Data Reduction', 'HFBSopHelpAbout', $
  IDENTIFIER='Help/About HFBS',/separator

self->RegisterOperation, 'About DAVE', 'DAVEopHelpAbout', $
  IDENTIFIER='Help/About DAVE',/separator


;;---------------------------------------------------------------------
;;*** Manipulators
self->RegisterManipulator, 'Arrow', 'IDLitManipArrow', $
  ICON='arrow', /DEFAULT, IDENTIFIER="ARROW", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Select')

self->RegisterManipulator, 'Rotate', 'IDLitManipRotate', $
  ICON='rotate', IDENTIFIER="ROTATE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Rotate')

self->RegisterManipulator, 'View Pan', 'IDLitManipViewPan', $
  ICON='hand', IDENTIFIER="VIEWPAN", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Pan')


;;---------------------------------------------------------------------
;;*** View Zoom Manipulator
self->RegisterManipulator, 'View Zoom', 'IDLitManipViewZoom', $
  IDENTIFIER='View/ViewZoom', ICON='zoom', $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:ViewZoom')

;;---------------------------------------------------------------------
;; *** View Zoom Combobox

                                ; Combobox is not available on True64 (OSF Alpha)
useCombobox = ~(!VERSION.os eq 'OSF')
self->Register, 'View Zoom', 'IDLitopViewZoom', $
                IDENTIFIER='Toolbar/View/ViewZoom', $
                DROPLIST_EDIT=useCombobox, $
                DROPLIST_ITEMS=['800%', $
                                '400%', $
                                '200%', $
                                '150%', $
                                '130%', $
                                '100%', $
                                '75%',  $
                                '50%',  $
                                '25%'], $
                DROPLIST_INDEX=4, $
                /SINGLETON

;;---------------------------------------------------------------------
;;*** Annotation Manipulators
self->RegisterManipulator, 'Text', 'IDLitAnnotateText', $
  ICON='text', IDENTIFIER="ANNOTATION/TEXT", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateText')

self->RegisterManipulator, 'Line', 'IDLitAnnotateLine', $
  ICON='line', IDENTIFIER="ANNOTATION/LINE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateLine')

self->RegisterManipulator, 'Rectangle', 'IDLitAnnotateRectangle', $
  ICON='rectangl', IDENTIFIER="ANNOTATION/RECTANGLE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateRectangle')

self->RegisterManipulator, 'Oval', 'IDLitAnnotateOval', $
  ICON='ellipse', IDENTIFIER="ANNOTATION/OVAL", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateOval')

self->RegisterManipulator, 'Polygon', 'IDLitAnnotatePolygon', $
  ICON='segpoly', IDENTIFIER="ANNOTATION/POLYGON", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotatePolygon')

self->RegisterManipulator, 'Freehand', 'IDLitAnnotateFreehand', $
  ICON='freehand', IDENTIFIER="ANNOTATION/FREEHAND", $
  DESCRIPTION='Click & drag to draw'



;;---------------------------------------------------------------------
;;*** DrawContext
;self->Register, 'Cut', $
;                PROXY="/REGISTRY/OPERATIONS/CUT",$
;                IDENTIFIER='ContextMenu/DrawContext/Cut'
;
;self->Register, 'Copy', $
;                PROXY='/REGISTRY/OPERATIONS/COPY', $
;                IDENTIFIER='ContextMenu/DrawContext/Copy'
;
;self->Register, 'Paste', $
;                PROXY='/REGISTRY/OPERATIONS/Paste', $
;                IDENTIFIER='ContextMenu/DrawContext/Paste'
;
;                                ;-----------------
self->Register, 'Delete', $
                PROXY='/REGISTRY/OPERATIONS/Delete', $
                IDENTIFIER='ContextMenu/DrawContext/Delete'

                                ;-----------------
self->Register, 'Group', $
                PROXY='Operations/Edit/Grouping/Group', $
                IDENTIFIER='ContextMenu/DrawContext/Grouping/Group'

self->Register, 'Ungroup', $
                PROXY='Operations/Edit/Grouping/Ungroup', $
                IDENTIFIER='ContextMenu/DrawContext/Grouping/Ungroup'

self->Register, 'Modify Properties...', $
                PROXY='Operations/Edit/Properties', $
                IDENTIFIER='ContextMenu/DrawContext/Properties'




Self.sampContRef = obj_new('IDL_Container') ;obj_new('IDLitContainer',name='SampContainer')
Self.bkgdContRef = obj_new('IDL_Container') ;obj_new('IDLitContainer',name='BkgdContainer')
Self.vanContRef = obj_new('IDL_Container') ;obj_new('IDLitContainer',name='BkgdContainer')
Self.sampFoldCont = obj_new('Idl_container')

;; Initialise data and Register Properties

Self.nSamp = 0
Self.nBkgd = 0
Self.nVan = 0

Self.sumSampFlag = 0
Self->RegisterProperty, 'sumSampFlag', enumlist=['No','Yes'], name='Sum Sample Datasets?' $
                      ,description='Sum all loaded Sample data?', sensitive=(Self.nSamp gt 1)
                      
Self.sumBkgdFlag = 1
Self->Registerproperty, 'sumBkgdFlag', enumlist=['No','Yes'], name='Sum Bkgd Datasets?' $
  ,description='Sum all loaded Bkgd data?', hide=1

Self.bkgdFlag = 0
Self->Registerproperty, 'bkgdFlag', enumlist=['No','Yes'], name='Subtract Bkgd?' $
  ,sensitive=(Self.nBkgd gt 0)

Self.vanFlag = 0
Self->Registerproperty, 'vanFlag', enumlist=['No','Yes'], name='Vanadium Normalization?' $
  ,description='Should van normalization be applied?',sensitive=(Self.nVan gt 1)

Self.monNormFlag = 0
Self->Registerproperty, 'monNormFlag', enumlist=['No','Yes'], name='Monitor Normalization?' $
  ,description='Should mon normalization be applied?'

Self.grpScaleFactors = Fltarr(16)+1
Self->Registerproperty, 'grpScaleFactors', userdef='', hide=1
Self.grpscaleFacStr = Strjoin(Strtrim(String(Self.grpScaleFactors),2),',')
Self->Registerproperty, 'grpScaleFacStr', userdef=Self.grpscaleFacStr, name='Detector Scale Factors' $
  ,description='Scale Factors for each detector'

Self.nGroups = 16
Self.detGroupFlag = 0
elist = ['16 Groups','8  Groups','4  Groups','2  Groups','1  Group']
Self->RegisterProperty, 'detGroupFlag', enumlist=elist,name='Group 16 detectors into'
Self.detsingroup1 = '1-16'
Self->Registerproperty, 'detsInGroup1', /string,name='Detectors Included in Sum:', hide = (Self.detGroupFlag ne 4)

;Self.maskFlag = 0
;Self->RegisterProperty, 'maskFlag', enumlist=['No','Yes'], name='Remove Masked Channels?' $
;                      ,description='Remove Masked Channels'

;Self->Registerproperty, 'detMaskString', /string,name='Dets to mask (eg 1,6,11)'

;indVars = ['Time','Control Temperature','Sample Temperature']
;Self.xAxisVar = 0
;Self->RegisterProperty, 'xAxisVar', enumlist=indVars, name='Independent Variable'
;
;Self.yAxisVar = 0
;depVars = []
;for i=1,16 do depVars = [depVars,'Detector '+strtrim(string(i),2)]
;Self->RegisterProperty, 'yAxisVar', enumlist=depVars, name='Dependent Variable'

;Self.plotFlag = 1
;Self->RegisterProperty, 'plotFlag', enumlist=['No (One group at a time)','Yes (all groups together)'], name='Display complete dataset?'

Self.grpNos = 1
Self.grpNosRange = [1,Self.nGroups,1]
Self->Registerproperty, 'grpNos', /integer, valid_range=Self.grpNosRange, name='Det. Group to plot',hide=Self.plotFlag

Self.ssfactor = 1.0
Self->Registerproperty, 'ssfactor', /float, name='Self shielding factor'

Self.autoScaleFlag = 0
Self->Registerproperty, 'autoScaleFlag', enumlist=['No','Yes'], name='Autoscale to unit height?'



;
Self.logFlag = 0
Self->RegisterProperty, 'logFlag', enumlist=['Linear','Logbase10'], name='Intensity Scale' $
                      ,description='Intensity Scale'
;
;Self.defaultIntensityFlag = 1
;Self->RegisterProperty, 'defaultIntensityFlag', enumlist=['No','Yes'], name='Use Default Intensity Range?' $
;                      ,description='Use Default Intensity Range?' ,hide=hideifpowder
;Self.maxIntensity = 0.0
;Self->RegisterProperty, 'maxIntensity', /float, name='Max Intensity Value' $
;                      ,description='Max Intensity Value' ,hide=hideifpowder
;Self.minIntensity = 0.0
;Self->RegisterProperty, 'minIntensity', /float, name='Min Intensity Value' $
;                      ,description='Min Intensity Value' ,hide=hideifpowder
;
;Self.normalizeTo = 0
;Self->RegisterProperty, 'normalizeTo', enumlist=['Monitor','Counting Time','No Normalization'], name='Normalize To' $
;                      ,description='Normalize Counts To'
;
;
;Self.detailedBalanceFlag = 0
;Self->RegisterProperty, 'detailedBalanceFlag', enumlist=['No','Yes'], name='Det. balance Correction?' $
;                      ,description='Should detailed balance correction be applied?' $
;                      ,sensitive=Self.vanFlag,hide=1
;                      

Self->SetPropertyAttribute, 'NAME', /hide
Self->SetPropertyAttribute, 'DESCRIPTION', /hide
Self.projName = 'Untitled'

;; Finally, set the prompt property to 1 meaning display a warning dialog 
;; before deleting this tool
Self.prompt = 1
Self.promptDesc = 'HFBS Reduction Window'
Self.promptTitle = 'Delete Reduction Window?'

IDLge90 = (float(!version.release) ge 9.0)? 1 : 0
Self.ftpObject =  (IDLge90)? DAVEHttpRequest() :  DAVEftpURL()
Self.ftpObject->SetProperty, currentDir = '/pub/ncnrdata/hfbs/'

Self.historyPtr = ptr_new('')

Self.ekFac = 2.072194

return, 1

end


;-------------------------------------------------------------------------
; HfbsTool::SaveVisProps
;+
; Purpose:
;    Retrieve the curent vis properties and save them
;
; Parameters:
;    oVis     - The visualization whose properties are to be saved
;    
;-
pro HfbsTool::SaveVisProps, oVis
compile_opt idl2

if (~obj_valid(oVis)) then return
if (~obj_isa(oVis,'IDLitVisualization')) then return

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'HfbsTool::SaveVisProps: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return
    endif
endif

oVis->GetProperty, description=plotDesc
case strupcase(plotDesc) of
   'SAMPPLOT': prefix = 's_'
   'BKGDPLOT': prefix = 'b_'
;   'FASTPLOT': prefix = 'f_'
;   'SAMPBKGDPLOT': prefix = 'sb_'
;   'FASTFITPLOT': prefix = 'ff_'
   else: return
endcase

switch strupcase(plotDesc) of
   'SAMPPLOT':
   'BKGDPLOT':
   'FASTPLOT': begin
      ;; store the vis props
      vTags = ['use_default_color','color','errorbar_color','sym_color','errorbar_capsize' $
              ,'sym_increment','sym_index','sym_size','sym_thick','y_errorbars','antialias' $
              ,'linestyle','nsum','thick','sym_filled','sym_fill_color','transparency']
;      vTags = ['errorbar_capsize','transparency','antialias','color','use_default_color' $
;              ,'sym_increment','sym_index','sym_size','sym_color','sym_thick','y_errorbars' $
;              ,'linestyle','nsum','thick','sym_filled','sym_fill_color']
      tTags = prefix + vTags

      nTags = n_elements(vTags)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
         status = oVis->GetPropertyByIdentifier(vTags[i], value)
         if (status) then etc = create_struct(etc,tTags[i],value)
      endfor
      Self->SetProperty, _EXTRA=etc

      ;; store the axes props
      vTags = ['font_name','font_size','text_color']
      tTags = prefix + vTags
      nTags = n_elements(vTags)
      oDataSpace = oVis->GetDataSpace()
      oAxes = oDataSpace->GetAxes(count=naxes)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
         status = oAxes[0]->GetPropertyByIdentifier(vTags[i], value)
         if (status) then etc = create_struct(etc,tTags[i],value)
      endfor
      Self->SetProperty, _EXTRA=etc   
   
      break
   end
   
;   'SAMPBKGDPLOT':
;   'FASTFITPLOT': begin
;      ;; Set the vis props
;      vTags = ['transparency','antialias','color','use_default_color','sym_index' $
;              ,'linestyle','thick']
;      tTags = prefix + vTags
;
;      nTags = n_elements(vTags)
;      etc = {dummy:''}
;      for i=0, nTags-1 do begin
;         status = oVis->GetPropertyByIdentifier(vTags[i], value)
;         if (status) then etc = create_struct(etc,tTags[i],value)
;      endfor
;      Self->SetProperty, _EXTRA=etc
;   
;      break
;   end
   
   else:
endswitch

end




;-------------------------------------------------------------------------
; HfbsTool::customizeVis
;+
; Purpose:
;    Customize a newly created visualization using attributes obtained from the tool
;
; Parameters:
;    oVis     - The visualization to be customized
;    
;    plotname - a string name to be used to identify the visualization
;-
pro HfbsTool::CustomizeVis, oVis, plotName, plotDesc
compile_opt idl2

if (~obj_valid(oVis)) then return
if (~obj_isa(oVis,'IDLitVisualization')) then return

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'wd_HfbsTool_customizeVis: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return
    endif
endif

case strupcase(plotDesc) of
   'SAMPPLOT': prefix = 's_'
   'BKGDPLOT': prefix = 'b_'
;   'FASTPLOT': prefix = 'f_'
;   'SAMPBKGDPLOT': prefix = 'sb_'
;   'FASTFITPLOT': prefix = 'ff_'
   else: return
endcase

switch strupcase(plotDesc) of
   'SAMPPLOT':
   'BKGDPLOT':
   'FASTPLOT': begin
      ;; Set the vis props
      vTags = ['use_default_color','color','errorbar_color','sym_color','errorbar_capsize' $
              ,'sym_increment','sym_index','sym_size','sym_thick','y_errorbars','antialias' $
              ,'linestyle','nsum','thick','sym_filled','sym_fill_color','transparency']
      tTags = prefix + vTags

      nTags = n_elements(vTags)
      etc = []
      for i=0, nTags-1 do begin
         status = Self->GetPropertyByIdentifier(tTags[i], value)
         if (status) then etc = create_struct(etc,vTags[i],value)
      endfor

      if (float((strtok(!version.release,/extract))[0]) lt 8.0) then begin
         ; workaround for bug in IDL 7.1 or lower; use_default_color is not honoured for errorbar_color
         if (etc.use_default_color eq 1) then etc.errorbar_color = etc.color
      endif

      oVis->SetProperty, name=strupcase(plotName), description=plotDesc, _EXTRA=etc
      oVis->SetPropertyAttribute, 'NSUM', sensitive=0   ; disable point averaging/smoothing b/c errors are not taken into account

      ;; Set the axes props
      vTags = ['font_name','font_size','text_color']
      tTags = prefix + vTags
      nTags = n_elements(vTags)
      oDataSpace = oVis->GetDataSpace()
      oAxes = oDataSpace->GetAxes(count=naxes)
      etc = []
      for i=0, nTags-1 do begin
         status = Self->GetPropertyByIdentifier(tTags[i], value)
         if (status) then etc = create_struct(etc,vTags[i],value)
      endfor
      for i=0,naxes-1 do oAxes[i]->SetProperty, _EXTRA=etc   
   
      break
   end
   
;   'SAMPBKGDPLOT':
;   'FASTFITPLOT': begin
;      ;; Set the vis props
;      vTags = ['transparency','antialias','color','use_default_color','sym_index' $
;              ,'linestyle','thick']
;      tTags = prefix + vTags
;
;      nTags = n_elements(vTags)
;      etc = {dummy:''}
;      for i=0, nTags-1 do begin
;         status = Self->GetPropertyByIdentifier(tTags[i], value)
;         if (status) then etc = create_struct(etc,vTags[i],value)
;      endfor
;      oVis->SetProperty, name=strupcase(plotname), _EXTRA=etc
;      oVis->SetPropertyAttribute, 'NSUM', sensitive=0   ; disable point averaging/smoothing b/c errors are not taken into account
;   
;      break
;   end
   
   else:
endswitch



end



;---------------------------------------------------------------------------
; HfbsTool::InitPreferences
;
; Purpose:
;   This method
;
pro HfbsTool::InitPreferences
compile_opt idl2

; Init working and data directory from the DAVETool values
;daveTool = Self.daveTool
;if (obj_valid(daveTool) and obj_isa(daveTool,'DAVETool')) then begin
;   daveTool->GetProperty, data_directory=datDir, working_directory=workDir
;   Self->SetProperty, data_directory=datDir, working_directory=workDir
;endif


; Retrieve user settings on disk and initialise current session
status = HFBSReducPreferences(preferences)
if (status) then Self->SetProperty, preferences=preferences

;Self->GetProperty, maskFlag=mF, vanFlag=fF, xAxisVar=xAxisVar $
;                 , sampTypeFlag=sampTypeFlag
;noHide = (defIntFlag eq 0) && (sampTypeFlag eq 1)  ; don't hide if not using default intensity and single crystal sample
;Self->SetPropertyAttribute, 'maxIntensity', hide=~noHide
;Self->SetPropertyAttribute, 'minIntensity', hide=~noHide
;Self->SetPropertyAttribute, 'MASKEDDETS', sensitive=mF
;Self->SetPropertyAttribute, 'FASTVALUE', sensitive=fF
;Self->SetPropertyAttribute, 'MONCORFLAG', sensitive=fF
;Self->SetPropertyAttribute, 'RESCORFLAG', sensitive=mF
;Self->SetPropertyAttribute, 'DETAILEDBALANCEFLAG', sensitive=mF

; For safety, always initialise phiOffset to 0.0 b/c a user may not be fully aware
; about this setting. A value of 0.0 is harmless
;Self->SetProperty, phiOffset = 0.0

Self->refreshPropertySheet

; Update title to reflect session name
; setting tool_filename generates a callback on the registered UI callback
Self->SetProperty, tool_filename=Self.projName

; Retrieve the graphics window
; and set auto-resize and zoom-on-resize to 1 so the graphics window behaves properly when its size is changed
oWin = Self->GetCurrentWindow()
oWin->SetProperty, auto_resize=1, zoom_on_resize=1

if (float((strtok(!version.release,/extract))[0]) ge 8.0) then begin
   ; For IDL 8.0 and newer, a title text is added to the graphics by default
   ; Customize it!

   idText = iGetID('*title*',tool=Self)
   oText = Self->GetByIdentifier(idText[0])
   if (isa(oText,'IDLitvisText')) then begin
    oText->setProperty, hide=0, color=[153,0,0], font_size=16
    oText->Translate, 0.0, -0.10, 0.0
   endif
   ;oWin = Self->GetCurrentWindow()
   ;oScene = oWin->GetScene()
   ;oView = oScene->GetCurrentView()
   ;atoms = oView->GetAll(count=natoms)
   ;for i=0,natoms-1 do begin
   ;   if (obj_isa(atoms[i],'IDLitvisText')) then atoms[i]->setProperty, hide=1
   ;endfor
   Self->RefreshCurrentWindow
endif

end


;---------------------------------------------------------------------------
; HfbsTool::resetPreferences
;
; Purpose:
;   This method
;
function HfbsTool::ResetPreferences
compile_opt idl2


; Retrieve user settings on disk and initialise current session
status = HFBSReducPreferences(preferences,/reset)
if (status) then Self->SetProperty, preferences=preferences

;Self->GetProperty, maskFlag=mF, vanFlag=fF

;Self->SetPropertyAttribute, 'MASKEDDETS', sensitive=mF
;Self->SetPropertyAttribute, 'FASTVALUE', sensitive=fF
;Self->SetPropertyAttribute, 'MONCORFLAG', sensitive=fF
;;Self->SetPropertyAttribute, 'RESCORFLAG', sensitive=mF
;;Self->SetPropertyAttribute, 'DETAILEDBALANCEFLAG', sensitive=mF

Self->refreshPropertySheet

end


;---------------------------------------------------------------------------
; HfbsTool::EditUserDefProperty
;
; Purpose:
;   This method
;
function HfbsTool::EditUserDefProperty, oTool, PropID
compile_opt idl2

;; The API requires the oTool arg. It is redundant here since it is Self!

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

case PropID of
  'GRPSCALEFACSTR': begin
    Self->GetProperty, grpScalefacStr=sfStr
    sf = Float(Strsplit(sfStr,',',/extract))
    sf = Wd_hfbstool_setdetsf(group_leader=wTLB, sf=sf)
    sfStr = strjoin(strtrim(string(sf),2),',',/single)
    Self->SetProperty, grpScalefacStr=sfStr
    Self->SetpropertyAttribute, 'GRPSCALEFACSTR', userdef=sfStr
  end

;  'MASKEDDETS': begin
;     ; The currently selected dataset is registered as (*sPtr).itemID
;     noSelection = strcmp(strtrim((*sPtr).itemID),'')
;     if (noselection) then begin
;       ; retrieve the first loaded dataset, if any
;       Self->GetProperty, sampContRef=oCont
;       oItem = oCont->Get(position=0,count=nItem)
;     endif else begin
;       oItem = Self->GetByIdentifier((*sPtr).itemID)
;       nItem = 1
;     endelse
;     if (nItem ne 1) then return, 0
;     
;     wd_HFBSMaskChannels, oUI, oItem
;  end
;  
   
  else:
endcase

Self->refreshPropertySheet

return, 1
end


;---------------------------------------------------------------------------
; HfbsTool__Define
;
; Purpose:
;   This method defines the HfbsTool class.
;
pro HfbsTool__Define
compile_opt idl2

void = { HfbsTool,                 $
         inherits IDLitTool        $   ; Provides iTool interface
         ,dataDir:''               $   ; data directory (Note: working_directory is defined by the base class
         ,nosSampFolder:0          $   ; nos of valid sample folders present
         ,nSamp:0                  $   ; nos of valid Sample datasets
         ,nBkgd:0                  $   ; nos of valid bkgd datasets
         ,nVan:0                   $   ; nof of valid van bkgd datasets
         ,sampContRef:obj_new()    $   ; container for Sample datasets
         ,bkgdContRef:obj_new()    $   ; container for bkgd datasets
         ,vanContRef:obj_new()     $   ; container for van bkgd datasets
         ,sampFoldCont:obj_new()   $   ; container for sample folders
         ,sampSelected:obj_new()   $   ; most recent selection from samp datasets
         ,bkgdSelected:obj_new()   $   ; most recent selection from bkgd datasets
         ,vanSelected:obj_new()    $   ; most recent selection from van datasets
         ,oPlotBkgdFlag:0          $
         ,DAVETool:obj_new()       $   ; DAVETool object
         ,projName:''              $   ; name of current project
         ,nameTag:''               $   ; Tag to be used for identification purposes
         ,prompt:1                 $
         ,promptTitle:''           $
         ,promptDesc:''            $
         ,sumSampFlag:0            $   ; sum multiple sample files? 0=no, 1=yes
         ,sumBkgdFlag:0            $   ; sum multiple bkgd files? 0=no, 1=yes
         ,qUnits:0                 $   ; Units for QX, QY variables: 0->1/A, 1->r.l.u
         ,xAxisVar:0               $   ; Variable to plotted as the x-axis
         ,yAxisVar:0               $   ; variable to be plotted as the y-axis
         ,indepVars1Ptr:ptr_new()  $   ; list of valid sxtal independent variables ('QX','QY','E','|Q|','TEMP','MAGFIELD')
         ,indepVars2Ptr:ptr_new()  $   ; list of valid powder x-axis independent variables ('2THETA','Q','DSPACE','TEMP','MAGFIELD','DATAPOINT')
         ,indepVars3Ptr:ptr_new()  $   ; list of valid powder y-axis independent variables ('2THETA','Q','DSPACE')
         ,nGroups:16               $   ; number of detector groups
         ,detGroupings:ptr_new()   $   ; detector groupings info
         ,detMaskString:''         $   ; detectors to be masked specified as a string in a comma delimited list
         ,detGroupFlag:0           $   ; det groupings: 0=16 grps, 1=8, 2=4, 3=2, 4=1
         ,detsInGroup1:''          $   ; detectors to be included in det groupings is set to 0
         ,grpNos:0                 $   ; current group to plot
         ,grpNosRange:[1,16,1]     $   ; range of valid group numbers
         ,detailedBalanceFlag:0    $   ; apply detailed balance correction 1=yes, 0=no
         ,bkgdFlag:0               $   ; subtract bkgd data  1=yes, 0=no
         ,vanFlag:0                $   ; apply van normilization? 1=yes, 0=no
         ,monNormFlag:0            $   ; apply mon normilization? 1=yes, 0=no
         ,grpScaleFactors:fltarr(16) $ ;
         ,grpscaleFacStr:''        $   ;
         ,prefsPtr:ptr_new()       $   ; points to preference structure
         ,historyPtr:ptr_new()     $   ;
         ,modifiedFlag:0B          $   ; determines modification state of tool - unsufficient control over _bDirty property!
         ,dataVersion:0            $   ; current version number for dataset structure
         ,ftpObject:obj_new()      $   ; DAVEftpURL() object used to access data on ftp://ftp.ncnr.nist.gov/pub/ncnrdata/
         ,chEff:fltarr(16)         $   ; Channel efficiencies
         ,logFlag:0                $   ; use linear (0) or log (1) intensity scale
         ,ekFac:2.072194           $   ; Energy = ekFac * k^2
         ,plotFlag:0               $   ; Plot data using 1D=0 or 2D=1 plots
         ,ssfactor:1.0             $   ; Self shielding factor to premultiply bkgd data before subtraction
         ,autoScaleFlag:0          $   ; Auto-scale flag determines if intensities are auto-scaled at the max height for direct comparisons of lineshape

         ,s_errorbar_capsize:    0.1       $
         ,s_transparency:        50        $
         ,s_antialias:           3         $
         ,s_color:               [0,0,255] $
         ,s_errorbar_color:      [0,0,255] $
         ,s_use_default_color:   1         $
         ,s_sym_increment:       1         $
         ,s_sym_index:           4         $
         ,s_sym_size:            1.0       $          ; 
         ,s_sym_color:           [0,0,255] $   ;
         ,s_sym_thick:           1.0       $            ;
         ,s_y_errorbars:         1         $              ; show y errors
         ,s_linestyle:           0         $              ; 
         ,s_nsum:                1         $              ; no point everaging
         ,s_thick:               2.0       $            ; line thickness
         ,s_sym_filled:          1         $            ; use filled symbols
         ,s_sym_fill_color:      [0,0,255] $   ; symbol fill color
         ,s_font_name:           'Helvetica'  $   ;
         ,s_font_size:           13 $             ;
         ,s_text_color:          [0,0,0]   $    ;

         ,b_errorbar_capsize:    0.1       $
         ,b_transparency:        50        $
         ,b_antialias:           3         $
         ,b_color:               [0,0,255] $
         ,b_errorbar_color:      [0,0,255] $
         ,b_use_default_color:   1         $
         ,b_sym_increment:       1         $
         ,b_sym_index:           4         $
         ,b_sym_size:            1.0       $          ; 
         ,b_sym_color:           [0,0,255] $   ;
         ,b_sym_thick:           1.0       $            ;
         ,b_y_errorbars:         1         $              ; show y errors
         ,b_linestyle:           6         $              ; no line
         ,b_nsum:                1         $              ; no point everaging
         ,b_thick:               1.0       $            ; line thickness
         ,b_sym_filled:          1         $            ; use filled symbols
         ,b_sym_fill_color:      [0,0,255] $   ; symbol fill color
         ,b_font_name:           'Helvetica'  $   ;
         ,b_font_size:           13 $             ;
         ,b_text_color:          [0,0,0]   $    ;

         ,f_errorbar_capsize:    0.1       $
         ,f_transparency:        50        $
         ,f_antialias:           3         $
         ,f_color:               [0,0,255] $
         ,f_errorbar_color:      [0,0,255] $
         ,f_use_default_color:   1         $
         ,f_sym_increment:       1         $
         ,f_sym_index:           4         $
         ,f_sym_size:            1.0       $          ; 
         ,f_sym_color:           [0,0,255] $   ;
         ,f_sym_thick:           1.0       $            ;
         ,f_y_errorbars:         1         $              ; show y errors
         ,f_linestyle:           6         $              ; no line
         ,f_nsum:                1         $              ; no point everaging
         ,f_thick:               1.0       $            ; line thickness
         ,f_sym_filled:          1         $            ; use filled symbols
         ,f_sym_fill_color:      [0,0,255] $   ; symbol fill color
         ,f_font_name:           'Helvetica'  $   ;
         ,f_font_size:           13        $             ;
         ,f_text_color:          [0,0,0]   $    ;
;
;         ,sb_transparency:        60 $
;         ,sb_antialias:           3 $
;         ,sb_color:               [0,128,0] $
;         ,sb_use_default_color:   1   $
;         ,sb_sym_index:           0   $            ; no symbol
;         ,sb_linestyle:           0 $              ;
;         ,sb_thick:               5.0 $            ; line thickness
;
;         ,ff_transparency:        60 $
;         ,ff_antialias:           3 $
;         ,ff_color:               [0,128,0] $
;         ,ff_use_default_color:   1   $
;         ,ff_sym_index:           0   $            ; no symbol
;         ,ff_linestyle:           0 $              ;
;         ,ff_thick:               5.0 $            ; line thickness


       }
end
