; $Id$
;###############################################################################
;
; NAME:
;  LS_DIALOG
;
; PURPOSE:
;  UI for getting customized fitting information from the user.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ls_dialog_event,event
widget_control,event.top,get_uvalue = pinfo
uname = widget_info(event.id,/uname)
case uname of
'QUIT':	$
	begin
		itmax_id = widget_info(event.top,find_by_uname = 'ITMAX')
		ftol_id = widget_info(event.top,find_by_uname = 'FTOL')
		gtol_id = widget_info(event.top,find_by_uname = 'GTOL')
		xtol_id = widget_info(event.top,find_by_uname = 'XTOL')
		widget_control,itmax_id,get_value = itmax & itmax = fix(itmax[0])
		widget_control,ftol_id,get_value = ftol & ftol = double(ftol[0])
		widget_control,gtol_id,get_value = gtol & gtol = double(gtol[0])
		widget_control,xtol_id,get_value = xtol & xtol = double(xtol[0])
		(*pinfo) = {itmax:itmax,xtol:xtol,gtol:gtol,ftol:ftol}
		widget_control,event.top,/destroy
	end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ls_dialog,group_leader = group_leader,old_info
xtol = old_info.xtol
ftol = old_info.ftol
gtol = old_info.gtol
itmax = old_info.itmax
tlb = widget_base(title = 'Least-squares control parameters',/col, $
	tlb_frame_attr = 9,/modal,group_leader = group_leader,/base_align_right)
void = cw_field(tlb,title = 'Max # iterations (def: 200)',value = strtrim(string(itmax),2), $
	uname = 'ITMAX')
strout = 'XTOL: relative error desired in approximate solution'
void = widget_label(tlb,value = strout)
void = cw_field(tlb,title = 'XTOL (def: 1D-10)',value = strtrim(string(xtol),2), $
	uname = 'XTOL')
strout = ['GTOL: orthogonality desired between','function vector and columns of the jacobian']
void = widget_label(tlb,value = strout[0])
void = widget_label(tlb,value = strout[1])
void = cw_field(tlb,title = 'GTOL (def: 1D-10)',value = strtrim(string(gtol),2), $
	uname = 'GTOL')
strout = 'FTOL: relative error desired in the sum of squares'
void = widget_label(tlb,value = strout)
void = cw_field(tlb,title = 'FTOL (def: 1D-10)',value = strtrim(string(ftol),2), $
	uname = 'FTOL')
void = widget_button(tlb,value = 'DONE',uname = 'QUIT')
centertlb,tlb
widget_control,tlb,/realize
pinfo = ptr_new(old_info,/no_copy)
widget_control,tlb,set_uvalue = pinfo
register_name = 'LS_DIALOG'
xmanager,register_name,tlb,event_handler = 'ls_dialog_event'
info = *pinfo
ptr_free,pinfo
return,info
end