; $Id$
;###############################################################################
;
; NAME:
;  REF_TWO_FOLD_JUMP
;
; PURPOSE:
;  Implementation of the 2-fold jump diffusion model for use in fitting
;  data in RAINS.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ref_two_fold_jump,xvals,parms,							$
                    	parmnames = parmnames,					$
                    	init_guess = init_guess,				$
                    	qty = qty,								$
                    	step = step,							$
                    	single_parmnames = single_parmnames,	$
                    	multi_parmnames = multi_parmnames,		$
                    	res_ptr = res_ptr,						$
                    	lorentzian = lorentzian,				$
                    	eisf = eisf,							$
                    	_Extra = extra
compile_opt idl2

; all_y keyword is not relevant for this model
nx = extra.nx & ny = extra.ny
x = xvals[0:nx-1] & y = xvals[nx:nx+ny-1]
ux = 1+bytarr(nx) & uy = 1+bytarr(ny)
parmnames =	['Jump distance','Lorentzian FWHM', $
			'Intensity:'+strtrim(string(indgen(ny)),2), $
			'Center:'+strtrim(string(indgen(ny)),2)]
single_parmnames = parmnames[0:1]
multi_parmnames = ['Intensity','Center']
if arg_present(step) then begin
	step = dblarr(2+2*extra.ny)
endif
if (n_params() eq 0) or (n_params() eq 1) then begin
	if arg_present(init_guess) then begin
		intensity = max(qty,dimension = 1,index)
		qty_size = size(qty)
		for i = 0,qty_size[2]-1 do begin
			qty_max = max(qty[*,i],index)
			if i eq 0 then index_array = index else $
				index_array = [index_array,index]
		endfor
		center = x[index_array]
		; Guess the 1/2 width at the highest y-value
		; Get the low value first
		amp = max(qty[*,qty_size[2]-2])
		ht = 0.5*amp
		wh_lo = where(abs(amp-ht) le min(abs(amp-ht)) and (x lt 0.0),count_lo)
		x_lo_lim = x[wh_lo[0]]
 		wh_hi = where(abs(amp-ht) le min(abs(amp-ht)) and (x gt 0.0),count_hi)
		x_hi_lim = x[wh_hi[0]]
		fwhm = x_hi_lim - x_lo_lim
		radius = 1.0 & center = x[index_array]
		init_guess = [radius,fwhm,intensity,center]
	endif
  return,-1
endif

radius = (parms[0])#uy
gam = (0.5*parms[1])#uy
intensity = ux#(parms[2:2+ny-1])
center = ux#(parms[2+ny:2+2*ny-1])
center1 = parms[2+ny:2+2*ny-1]
resolution = *res_ptr
eisf = 0.5*ux#(1.0+sph_bessel(y*radius,0))
lorentzian = (ux#(gam/!dpi))/((x#uy-center)^2+(ux#gam)^2)
xhi = max(x,min = xlo)
dx = x[1]-x[0] & dy = y[1]-y[0]
nshift = fix(0.5*((abs(xhi)-abs(xlo)))/dx)
lineshape = eisf*ref_delta(xvals,center1,resolution,nx = nx,ny = ny)+$
            scat_convolute(x,y,(1.0-eisf)*lorentzian,resolution) ;RTA change scat_convolve->scat_convolute
yout = intensity*lineshape
return,yout
end
