; $Id$
;###############################################################################
;
; NAME:
;  RMDPAFIXPARMSWIDGET
;
; PURPOSE:
;  Interface to fix, tie, or constrain lower and/or upper bounds
;  on parameters in a fit.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
PRO doneRMDPAFixWidget,event
widget_control,event.top,get_uvalue = pState
widget_control,(*pState).bgroup,get_value = fixValues
parms = fltarr((*pState).nparms)
hiLims = fltarr((*pState).nparms)
loLims = fltarr((*pState).nparms)

widget_control,(*pState).loLimGroup,get_value = checkLoLims
widget_control,(*pState).hiLimGroup,get_value = checkHiLims

for j = 0,(*pState).nparms-1 do begin
  widget_control,(*pState).val[j],get_value = value
  parms[j] = float(value[0])
  widget_control,(*pState).loLimField[j],get_value = thisValue
  loLims[j] = float(thisValue[0])
  widget_control,(*pState).hiLimField[j],get_value = thatValue
  hiLims[j] = float(thatValue[0])
endfor

constraints = ({checkLoLimPtr:ptr_new(checkLoLims),$
                         checkHiLimPtr:ptr_new(checkHiLims),$
                         loLimPtr:ptr_new(loLims),$
                         hiLimPtr:ptr_new(hiLims)})

(*pState).outPtr[0] = ptr_new(fixValues,/no_copy)
(*pState).outPtr[1] = ptr_new(parms,/no_copy)
(*pState).outPtr[2] = ptr_new(constraints,/no_copy)
widget_control,event.top,/destroy
RETURN
END
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro RMDPAFixParmsWidget_event,event
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function RMDPAFixParmsWidget,group_leader = group_leader,$
         parmPtr,$
         fixPtr,$
         namePtr,$
         constraintPtr
tlb = widget_base(group_leader = group_leader,/modal,/row,$
                    title = 'Modify Fit Parameters',/base_align_bottom)
!except = 0
parms = *parmPtr
nparms = n_elements(parms)
if not ptr_valid(fixPtr) then begin
  fixArray = 0*indgen(nparms)
endif else begin
  fixArray = *fixPtr
endelse

if not ptr_valid((*constraintPtr).checkLoLimPtr) then begin
  checkLoLims = 0*indgen(nparms)
endif else begin
  checkLoLims = *(*constraintPtr).checkLoLimPtr
endelse

if not ptr_valid((*constraintPtr).checkHiLimPtr) then begin
  checkHiLims = 0*indgen(nparms)
endif else begin
  checkHiLims = *(*constraintPtr).checkHiLimPtr
endelse

if not ptr_valid((*constraintPtr).LoLimPtr) then begin
  LoLims = 0.0*findgen(nparms)
endif else begin
  LoLims = *(*constraintPtr).LoLimPtr
endelse

if not ptr_valid((*constraintPtr).HiLimPtr) then begin
  HiLims = 1.0+0.0*findgen(nparms)
endif else begin
  HiLims = *(*constraintPtr).HiLimPtr
endelse

names = *namePtr

fixBase = widget_base(tlb,/col,/base_align_center,/base_align_bottom)
valBase = widget_base(tlb,/col,/base_align_center,/base_align_bottom)
loLimitBase = widget_base(tlb,/col,/base_align_center,/base_align_bottom)
loLimitLimBase = widget_base(tlb,/col,/base_align_center,/base_align_bottom)
HiLimitBase = widget_base(tlb,/col,/base_align_center,/base_align_bottom)
HiLimitLimBase = widget_base(tlb,/col,/base_align_center,/base_align_bottom)

val = lonarr(nparms)
fixVal = lonarr(nparms)
loLimField = lonarr(nparms)
hiLimField = lonarr(nparms)

nameVals = replicate('',nparms)
bgroup= cw_bgroup(fixBase, nameVals, /COLUMN, /NONEXCLUSIVE, $
                          LABEL_TOP='Fixed', /FRAME,set_value=fixArray)

for j = 0,nparms-1 do begin
  val[j] = cw_field(valBase,title=names[j],value=parms[j],$
                    xsize=8,/string)
endfor

loLimGroup = cw_bgroup(loLimitBase, nameVals, /COLUMN, /NONEXCLUSIVE, $
                          LABEL_TOP='Constraint', /FRAME,set_value=checkLoLims)
for j = 0,nparms-1 do begin
  loLimField[j] = cw_field(loLimitLimBase,title='Low',value=loLims[j],$
                    xsize=8,/string)
endfor
HiLimGroup = cw_bgroup(HiLimitBase, nameVals, /COLUMN, /NONEXCLUSIVE, $
                          LABEL_TOP='Constraint', /FRAME,set_value=checkHiLims)
for j = 0,nparms-1 do begin
  hiLimField[j] = cw_field(hiLimitLimBase,title='High',value=hiLims[j],$
                    xsize=8,/string)
endfor

void = widget_button(tlb,value = 'Exit',event_pro = 'doneRMDPAFixWidget')
centertlb,tlb
widget_control,tlb,/realize
outPtr = ptrarr(3,/allocate_heap)
outPtr[0] = fixPtr
outPtr[2] = constraintPtr
state = {val:val,bgroup:bgroup,nparms:nparms,outPtr:outPtr,loLimGroup:loLimGroup,$
         hiLimField:hiLimField,loLimField:loLimField,hiLimGroup:hiLimGroup}
pState = ptr_new(state)
widget_control,tlb,set_uvalue = pState
xmanager,'RMDPAFixParmsWidget',tlb,/no_block
return,(*pState).outPtr
end
