; $Id$
;###############################################################################
;
; NAME:
;  FUNC__DEFINE
;
; PURPOSE:
;  Class definition for a fit function component in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Driveq
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro func::cleanup
ptr_free,self.extra
ptr_free,self.xPtr
;ptr_free,self.qPtr
ptr_free,self.yPtr
ptr_free,self.stepPtr
ptr_free,self.ymaxPtr,self.xmodePtr
ptr_free,self.lowPtr,self.lowvalPtr
ptr_free,self.highPtr,self.highvalPtr
ptr_free,self.fixPtr,self.fixedvalPtr
ptr_free,self.parmErrorPtr
ptr_free,self.tiedPtr
ptr_free,self.parmPtr,self.resPtr
end;func::cleanup


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function func::getDrawMessage
y = call_function(self.name,*self.xPtr,*self.parmPtr, $
    expr = (*Self.expr), qVals=(*Self.qvals), $
    extra = *self.extra,drawMessage = drawMessage, $
    fit_fun_filename = self.fit_fun_filename)
return,drawMessage
end;func::getDrawMessage


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro func::changefirst,x,y,xrange
; Called when the user is initializing the function graphically.

if  (Self.candraw eq 0) then return ; no need to proceed

parms = *self.parmPtr

if N_elements(*self.resptr) eq 0 then begin
  calc = Call_function(self.name,*self.xptr,parms, $
    expr = (*Self.expr), extra = *self.extra, $
    func_dataHash = Self.func_data, qVals=(*Self.qvals), $
    qgroup=self.qgroup,groupNumber=self.groupnumber, $
    /changefirst, xMouseClick=x, yMouseClick=y, xrange=xrange)
endif else begin
  calc = Call_function(self.name,*self.xptr,parms, $
    expr = (*Self.expr), resPtr = self.resptr,extra = *self.extra, $
    func_dataHash = Self.func_data, qVals=(*Self.qvals), $
    qgroup=self.qgroup,groupNumber=self.groupnumber, $
    /changefirst, xMouseClick=x, yMouseClick=y, xrange=xrange)
endelse

*Self.parmPtr = parms
*self.yPtr = calc

return

end;func::changefirst


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro func::changesecond,x,y,xrange
; Called when the user is initializing the function graphically.


if  (Self.candraw eq 0) then Return ; no need to proceed

parms = *self.parmptr

if N_elements(*self.resptr) eq 0 then begin
  calc = Call_function(self.name,*self.xptr,parms, $
    expr = (*Self.expr), extra = *self.extra, $
    func_dataHash = Self.func_data, qVals=(*Self.qvals), $
    qgroup=self.qgroup,groupNumber=self.groupnumber, $
    /changesecond, xMouseClick=x, yMouseClick=y, xrange=xrange)
endif else begin
  calc = Call_function(self.name,*self.xptr,parms, $
    expr = (*Self.expr), resPtr = self.resptr,extra = *self.extra, $
    func_dataHash = Self.func_data, qVals=(*Self.qvals), $
    qgroup=self.qgroup,groupNumber=self.groupnumber, $
    /changesecond, xMouseClick=x, yMouseClick=y, xrange=xrange)
endelse

*Self.parmptr = parms
*self.yptr = calc

Return
end;func::changesecond


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro func::draw,overplot = overplot
if n_elements(overplot) eq 0 then overplot = 0
yVals = *self.yptr
y = (yVals.ndim eq 2)? yVals[*self.groupnumber -1] : yVals
if overplot eq 0 then begin
  plot,*self.xPtr,y,psym = 0
endif else begin
  oplot,*self.xPtr,y,psym = 0
endelse
end;func::draw


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro func::setproperty, $
              name = name,$
              xvalues = xvalues, $
              xunits = xunits, $
              qgroup=qgroup,$
              groupNumber=groupNumber,$
              func_dataHash=func_dataHash, $
              step = step, $
              parms = parms, $
              fixed = fixed, $
              fixvalues = fixvalues, $
              low = low, $
              lovalues = lovalues, $
              high = high, $
              hivalues = hivalues, $
              parmError = parmError, $
              canDraw = canDraw, $
              active = active, $
              tied = tied, $
              expr = expr, $
              rlimit = rlimit,	$
              resptr = resptr,	$
              resolutionRequiredFlag=resolutionRequiredFlag, $ ; is instrumental resolution part of the function definition?
              extConvolFlag=extConvolFlag, $                   ; external numerical convolution with resolution necessary
              qVals=qVals, twoDimFlag=twoDimFlag, $
              calculate = calculate	; set this keyword to populate self.yPtr with
              						; the updated values

!except = 0
if n_elements(rlimit) ne 0 then self.rlimit = rlimit
if n_elements(resptr) ne 0 then begin 
  if ptr_valid(resptr) ne 0 then *self.resptr = *resptr 
endif

if n_elements(resolutionRequiredFlag) ne 0 then Self.resolutionRequiredFlag = resolutionRequiredFlag
if n_elements(extConvolFlag) ne 0 then self.extConvolFlag = extConvolFlag
if n_elements(expr) ne 0 then (*self.expr) = expr
if n_elements(canDraw) ne 0 then self.canDraw = canDraw
if n_elements(active) ne 0 then Self.active = active
if n_elements(tied) ne 0 then *self.tiedPtr = tied
if n_elements(step) ne 0 then *self.stepPtr = step
if n_elements(name) ne 0 then self.name = name
if n_elements(xvalues) ne 0 then *self.xPtr = xvalues
if n_elements(xunits) ne 0 then self.xunits = xunits
if n_elements(qgroup) ne 0 then self.qgroup=qgroup;*self.qPtr = qgroup
if n_elements(groupNumber) ne 0 then self.groupNumber=groupNumber
if N_elements(qVals) ne 0 then (*self.qVals)=qVals
if N_elements(twoDimFlag) ne 0 then self.twoDimFlag=twoDimFlag
if Isa(func_dataHash,'hash') then Self.func_data = func_dataHash
if n_elements(parms) ne 0 then *self.parmPtr = parms
if n_elements(parmError) ne 0 then *self.parmErrorPtr = parmError
if n_elements(fixed) ne 0 then *self.fixPtr = fixed
if n_elements(fixvalues) ne 0 then *self.fixedvalPtr = fixvalues
if n_elements(low) ne 0 then *self.lowPtr = low
if n_elements(lovalues) ne 0 then *self.lowvalPtr = lovalues
if n_elements(high) ne 0 then *self.highPtr = high
if n_elements(hivalues) ne 0 then *self.highvalPtr = hivalues
; Now that we have all of the information, calculate the function if
; the user so desires.
if keyword_set(calculate) then begin  
  if n_elements(*self.xPtr) ne 0 then begin
    if n_elements(*self.resPtr) eq 0 then begin
      *self.yPtr = call_function(self.name,*self.xPtr,*self.parmPtr, $
                                expr = (*Self.expr), extra = *self.extra, $
                                func_dataHash = Self.func_data, qVals=(*Self.qVals), $
                                qgroup=self.qgroup,groupNumber=self.groupNumber)  ; fit_fun_filename = self.fit_fun_filename,
    endif else begin
      *self.yPtr = call_function(self.name,*self.xPtr,*self.parmPtr, $
                                expr = (*Self.expr), resPtr = self.resPtr,extra = *self.extra, $
                                func_dataHash = Self.func_data, qVals=(*Self.qVals), $
                                qgroup=self.qgroup,groupNumber=self.groupNumber)  ; fit_fun_filename = self.fit_fun_filename,
    endelse
  endif else begin
    print,'Error...no valid x-values'
  endelse
endif
end;func::setProperty


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro func::getproperty, $
              name = name,  $
              xvalues = xvalues, $
              xunits=xunits, $
              qgroup=qgroup,$
              groupNumber=groupNumber,$
              qVals=qVals, twoDimFlag=twoDimFlag, $
              func_dataHash=func_dataHash, $
              yvalues = yvalues,  $
              step = step, $
              parms = parms, $
              fixed = fixed, $
              fixvalues = fixvalues, $
              low = low, $
              lovalues = lovalues, $
              high = high, $
              hivalues = hivalues,$
              parmnames = parmnames,$
              parmError = parmError, $
              tied = tied, $
              canDraw = canDraw, $
              active = active, $
              fit_fun_filename = fit_fun_filename,	$
              resolutionRequiredFlag = resolutionRequiredFlag, $    ; is instrumental resolution part of the function definition?
              extConvolFlag=extConvolFlag, $                   ; external numerical convolution with resolution necessary
              expr = expr
;if arg_present(parmnames) then begin
;  z = Call_function(self.name,parmnames = parmnames,expr=(*Self.expr))
;  ;qgroup = self.qgroup;*self.qPtr
;  ;;SO DO I ENTER THE QVALUES IN THE FOLLOWING MANNER OR DO I HAVE TO ENTER THEM VIA *self.extra?????????
;  ;;THIS IS WHERE ALL THE ACTUAL EVALUATION HAPPENS, AND THUS WHERE THE Qgroup VALUE NEEDS TO BE ENTERED.
;  ;if self.expr eq '' then begin
;  ;  z = call_function(self.name,parmnames = parmnames, $
;  ;  	extra = *self.extra,fit_fun_filename = self.fit_fun_filename,qgroup=qgroup)
;  ;endif else begin
;  ;  z = call_function(self.name,*self.xPtr,*self.parmPtr, $
;  ;                    parmnames = parmnames, $
;  ;                    expr = self.expr, extra = *self.extra, $
;  ;                    fit_fun_filename = self.fit_fun_filename,qgroup=qgroup)
;  ;endelse
;endif

if arg_present(resolutionRequiredFlag) then resolutionRequiredFlag = self.resolutionRequiredFlag
if Arg_present(extConvolFlag) then extConvolFlag = self.extConvolFlag
if Arg_present(fit_fun_filename) then fit_fun_filename = self.fit_fun_filename
if arg_present(expr) then expr = (*self.expr)
if arg_present(canDraw) then canDraw = self.canDraw
if arg_present(active) then active = Self.active
if arg_present(tied) then tied = *self.tiedPtr
if arg_present(step) then step = *self.stepPtr
if arg_present(name) then name = self.name
if arg_present(xvalues) then xvalues = *self.xPtr
if Arg_present(xunits) then xunits = self.xunits
if arg_present(qgroup) then qgroup = self.qgroup;*self.qPtr
if arg_present(groupNumber) then groupNumber = self.groupNumber
if Arg_present(twoDimFlag) then twoDimFlag = self.twoDimFlag
if Arg_present(qVals) then qVals = *self.qVals
if arg_present(yvalues) then yvalues = *self.yPtr
if Arg_present(parmNames) then parmNames = *self.parmnamesptr
if arg_present(parms) then parms = *self.parmPtr
if arg_present(parmError) then parmError = *self.parmErrorPtr
if arg_present(fixed) then fixed = *self.fixPtr
if arg_present(fixvalues) then fixvalues = *self.fixedvalPtr
if arg_present(low) then low = *self.lowPtr
if arg_present(lovalues) then lovalues = *self.lowvalPtr
if arg_present(high) then high = *self.highPtr
if arg_present(hivalues) then hivalues = *self.highvalPtr
if arg_present(func_dataHash) then func_dataHash=Self.func_data
end;func::getProperty


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function func::init, $
                   name = name, $
                   xvalues = xvalues,$
                   xunits=xunits, $
                   datSize = datSize,$         ; dimensions of the expr't data to be fitted
                   qgroup = qgroup,$           ;THIS MAKES func AWARE OF THE Q-VALUE FOR ITS GROUP
                   groupNumber = groupNumber,$ ;THIS MAKES func AWARE OF THE NUMBER OF THE GROUP IT BELONGS TO
                   workDir = workDir, $
                   wTLB=wTLB, $
                   func_dataHash=func_dataHash, $
                   qVals=qVals, twoDimFlag=twoDimFlag, $
                   fit_fun_filename = fit_fun_filename,	$
                   step = step, $
                   parms = parms, $
                   fixed = fixed, $
                   fixvalues = fixvalues, $
                   low = low, $
                   lovalues = lovalues, $
                   high = high, $
                   hivalues = hivalues, $
                   tied = tied, $
                   resPtr = resPtr, $
                   rlimit = rlimit, $
                   expr = expr, $
                   resolutionRequiredFlag=resolutionRequiredFlag, $   ; is instrumental resolution part of the function definition?
                   extConvolFlag=extConvolFlag, $                   ; external numerical convolution with resolution necessary
                   active = active, $
                   _Extra = extra

; Name must be present!
self.extra = ptr_new(extra)
if n_elements(name) eq 0 then return,-1
self.parmErrorPtr = ptr_new(/allocate_heap)
self.name = name
self.stepPtr = ptr_new(/allocate_heap)
self.xPtr = ptr_new(/allocate_heap)
self.yPtr = ptr_new(/allocate_heap)
if n_elements(xvalues) eq 0 then begin
  xlo = -10.0 & xhi = 10.0 & nx = 100
  dx = (xhi-xlo)/(nx-1.0) & x = xlo+dx*findgen(nx)
  *self.xPtr = x
endif else begin
  *self.xPtr = xvalues
endelse
if (n_elements(qVals) eq 0) then qVals = 0.0
Self.qVals = ptr_new(qVals)
Self.twoDimFlag = (N_elements(twoDimFlag) eq 0)? 0 : twoDimFlag
if n_elements(qgroup) eq 0 then qgroup = 0.0
self.qgroup = qgroup
if n_elements(groupNumber) eq 0 then groupNumber=1
self.groupNumber = groupNumber
if N_elements(resolutionRequiredFlag) eq 0 then resolutionRequiredFlag=0
self.resolutionRequiredFlag = resolutionRequiredFlag
if N_elements(extConvolFlag) eq 0 then extConvolFlag=1
self.extConvolFlag = extConvolFlag
if (n_elements(xunits) eq 0) then xunits=''
Self.xunits = xunits

        
; Let's fill up the function with some dummy data if none is given
; when instantiating the class....
self.resPtr = ptr_new(/allocate_heap)
self.parmPtr = ptr_new(/allocate_heap)
self.parmNamesptr = Ptr_new(/allocate_heap)
self.lowPtr = ptr_new(/allocate_heap)
self.lowvalPtr = ptr_new(/allocate_heap)
self.highPtr = ptr_new(/allocate_heap)
self.highvalPtr = ptr_new(/allocate_heap)
self.fixPtr = ptr_new(/allocate_heap)
self.tiedPtr = ptr_new(/allocate_heap)
self.fixedvalPtr = ptr_new(/allocate_heap)
self.ymaxPtr = ptr_new(/allocate_heap)
self.xmodePtr = ptr_new(/allocate_heap)
if (isa(func_dataHash,'hash')) then begin
  ; this is executed when making a copy of an existing function
  Self.func_data = func_dataHash
endif else begin
  ; this is executed when making a brand new object
  if (Float((strtok(!version.release,/extract))[0]) ge 8.4) then begin
    func_dataHash = Hash(/fold_case) ; use fold_case keyword to make keys case insensitive for the hash
  endif else begin
    func_dataHash = Hash()           ; fold_case keyword only for IDL 8.4 and newer
  endelse 
  func_dataHash['initialized'] = 0
  Self.func_data = func_dataHash        
endelse

self.fit_fun_filename = ""
if (n_elements(expr) ne 0) then begin
  Self.expr = Ptr_new(expr)
endif else if n_elements(fit_fun_filename) ne 0 then begin
  self.fit_fun_filename = fit_fun_filename
  nlines = File_lines(fit_fun_filename)
  expr = Strarr(nlines)
  Openr,lun,fit_fun_filename,/get_lun
  Readf, lun, expr
  Free_lun,lun,/force
  Self.expr = Ptr_new(expr)
endif else begin
  expr = []
  Self.expr = Ptr_new('')
endelse


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Call function without x parameter to determine parameter names, inittial parameter guesses, etc
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

if ((n_elements(expr) gt 0) && expr[0].strlen() ne 0) then begin
  ; Test if we're defining a user function.  We are explicitly
  ; assuming here that the xvalues, expression, parms, and
  ; parmnames are being passed in here!!!!

  *self.parmptr = parms
  dummy = Call_function(self.name, $   ;(self.name,xvalues,parms, $
    Qgroup=Qgroup, xunits=xunits, $$
    func_dataHash=func_dataHash, $
    groupNumber=groupNumber,$
    parmnames = parmnames, twoDimFlag=twoDimFlag, initParms = parms, $
    expr = (*Self.expr), $
    fit_fun_filename = self.fit_fun_filename, $
    canDraw = canDraw, $
    _Extra=extra)
  nparms = N_elements(parmnames)
endif else begin
  ; Now take care of all of the library of fit functions
  ; Call the function to get out the parameter names and initial guess parameters
  status = Call_function(self.name,parmnames = parmnames, twoDimFlag=twoDimFlag, initParms = parms $
    ,Qgroup=Qgroup,groupNumber=groupNumber,func_dataHash=func_dataHash, datSize=datSize,qVals=qVals, xunits=xunits $$ ; , xData=xValues
    ,wTLB=wTLB, workDir=workDir,_Extra=extra ) ;extra = *self.extra)
  nparms = N_elements(parmnames)
  if (status eq 0) then Return, 0
endelse

if ((n_elements(resPtr) gt 0) && ptr_valid(resPtr) && (n_elements(*resPtr) gt 0)) then *self.resPtr = *resPtr
if n_elements(rlimit) ne 0 then self.rlimit = rlimit
unity = 1.0+0.0*findgen(nparms)
zerof = 0.0*unity
zeroi = 0*indgen(nparms)
*self.tiedPtr = n_elements(tied) eq 0 ? replicate(0,nparms) : tied
*self.stepPtr = n_elements(step) eq 0 ? replicate(0D,nparms) : step
*self.parmErrorPtr = replicate(0D,nparms)
*self.parmPtr = n_elements(parms) eq 0 ? unity : parms
if (N_elements(parmnames) gt 0) then (*Self.parmnamesptr) = parmnames

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Call function a second time to evaluate it and save the calculation
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
canDraw = 0
if ((n_elements(resPtr) gt 0) && ptr_valid(resPtr) && (n_elements(*resPtr) gt 0)) then begin
  *self.yPtr = call_function(self.name,*self.xPtr,*self.parmPtr, $
                             Qgroup=Qgroup,$
                             func_dataHash=func_dataHash, $
                             groupNumber=groupNumber,qVals=qVals,$
                             expr = (*Self.expr), canDraw = canDraw, $
                             fit_fun_filename = self.fit_fun_filename,	$
                             resPtr = self.resPtr, $
                             rlimit = self.rlimit, $
                             _Extra=extra)
endif else if (strupcase(self.name) ne 'PAN_QENS') then begin
  *self.yPtr = call_function(self.name,*self.xPtr,*self.parmPtr, $, $
                             Qgroup=Qgroup,qVals=qVals,$
                             groupNumber=groupNumber,$
                             func_dataHash=func_dataHash, $
                             fit_fun_filename = self.fit_fun_filename,	$
                             expr = (*Self.expr), canDraw = canDraw, $
                             _Extra=extra)
endif

self.canDraw = canDraw
if (N_elements(active) eq 0) then active = 1
Self.active = active

*self.fixPtr = n_elements(fixed) eq 0 ? zeroi : fixed
*self.fixedvalPtr = n_elements(fixvalues) eq 0 ? *self.parmPtr : fixvalues
*self.lowPtr = n_elements(low) eq 0 ? zeroi : low
*self.lowvalPtr = n_elements(lovalues) eq 0 ? zerof : lovalues
*self.highPtr = n_elements(high) eq 0 ? zeroi : high
*self.highvalPtr = n_elements(hivalues) eq 0 ? zerof : hivalues
return,1

end;func::init


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro func__define
;
define = {func, $
          name:"", $
          expr:ptr_new(/allocate_heap), $
          fit_fun_filename:"",	$
          canDraw:0, $
          active:0, $                 ; flag used to determine if function is currently active (1) or not (0). Can be used to temporarily switch a function off
          func_data:Obj_new(),  $     ; a hash object that can be used to store misc function data
          extra:ptr_new(/allocate_heap), $
          ymaxPtr:ptr_new(/allocate_heap), $
          xmodePtr:ptr_new(/allocate_heap), $
          parmPtr:ptr_new(/allocate_heap), $
          parmNamesPtr:ptr_new(/allocate_heap), $
          parmErrorPtr:ptr_new(/allocate_heap), $
          ;NEW FOR QGroup VALUE
          qgroup:0.0,$;ptr_new(/allocate_heap),$
          groupNumber:0,$
          xunits:'', $
          xPtr:ptr_new(/allocate_heap),  $
          yPtr:ptr_new(/allocate_heap),  $
          qVals:ptr_new(/allocate_heap),  $     ; ptr to group values
          twoDimFlag:0, $                       ; flag indicating whether this is a 2D==1 or 1D==0 (default) function
          stepPtr:ptr_new(/allocate_heap), $
          fixPtr:ptr_new(/allocate_heap),  $
          fixedvalPtr:ptr_new(/allocate_heap),  $
          lowPtr:ptr_new(/allocate_heap),  $
          lowvalPtr:ptr_new(/allocate_heap),  $
          highPtr:ptr_new(/allocate_heap),  $
          tiedPtr:ptr_new(/allocate_heap), $
          resPtr:ptr_new(/allocate_heap), $
          resolutionRequiredFlag:0, $          ; is instrumental resolution part of the function definition?
          extConvolFlag:0, $                  ; external numerical convolution with resolution necessary
          rlimit:[0.0,0.0], $
          highvalPtr:ptr_new(/allocate_heap) $
          }
end;func__define