; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_selectable_drawplot_class__define,class
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;    idl_container
;
;METHODS:
;    setCircleSymbol
;    cwo_selectable_drawplot_class_event
;    cwo_selectable_drawplot_class::handleContextMenu
;    cwo_selectable_drawplot_class::event
;    cwo_selectable_drawplot_class::handleMouseEvents
;    cwo_selectable_drawplot_class::createContextMenu
;    cwo_selectable_drawplot_class::setProperty
;    cwo_selectable_drawplot_class::getProperty
;    cwo_selectable_drawplot_class_cleanup
;    cwo_selectable_drawplot_class::cleanup
;    cwo_selectable_drawplot_class::init
;    cwo_selectable_drawplot_class__define
;    cwo_selectable_drawplot_class
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Fri May 18 15:20:57 2007
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################


;###############################################
;EVENT HANDLING METHODS
;###############################################
;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_selectable_drawplot_event,event

    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'cwo_selectable_drawplot: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return,-1
    endif


    widget_control,widget_info(event.handler,/child),get_uvalue=self
    event = self->event(event)
    return,event
end;cwo_selectable_drawplot_event


;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_selectable_drawplot_class::event,event

    catch,es
    if es ne 0 then begin
        void = dialog_message('Error occurred in cwo_selectable_drawplot_class::event, please report the following: '+!error_state.msg)
        catch,/cancel
        return,-1
    endif

;NEED TO LOOK FOR BUTTON EVENTS, THEN

;NEED TO LOOK FOR contextMenu EVENTS HERE AND HANDLE IF NECESSARY.
;IF NOT NECESSARY, FINISH THIS METHOD . . . MONDAY!!!!!!

    etype = strupcase(tag_names(event,/structure_name))

    case etype of
    'WIDGET_BUTTON':begin

        self.mouseinwindow = 1

        self->handleContextMenu,event
        self.leftmousepressed = 0
        self.zoomboxflag = 0
        event.id = self.tlb
        xrange=self.zoomxrange
        yrange=self.zoomyrange
        xbeg = double('nan')
        xend = double('nan')
        ybeg = double('nan')
        yend = double('nan')
        event = {id:self.tlb,top:self.parent,handler:self.parent,$
                    xbeg:xbeg,xend:xend,ybeg:ybeg,yend:yend,$
                    xrange:xrange,yrange:yrange,select:0,obj:self,$
                    mode:self.zoom_selectmode}

        ;return,-1
    end;
    'WIDGET_TRACKING':begin
        self.mouseinwindow = event.enter
        event = -1  ;ADDING THIS.  TRACKING EVENTS SHOULD BE HANDLED IN THIS CLASS AND NOT PASSED ON.
                    ;SHOULD DO SOME TESTING ON THIS FIRST.
    end;WIDGET_TRACKING
    'WIDGET_DRAW':begin
        self.mouseinwindow = 1
        case event.key of
        0:event = self->handleMouseEvents(event)
        else:event = self->handleKeyboardEvents(event)
        endcase
    end;WIDGET_DRAW
    else:begin
    end;else
    endcase
    ;print,'self.mouseinwindow=',self.mouseinwindow

    self->draw
    return,event
end;cwo_selectable_drawplot_class::event

;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class::handleContextMenu
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_selectable_drawplot_class::handleContextMenu,event,_Extra=extra

		self->cwo_drawplot_class::handleContextMenu,event,_Extra=extra

end;handleContextMenu

;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class::handleMouseEvents
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_selectable_drawplot_class::handleMouseEvents,event



        !x = *self.xptr
        !y = *self.yptr
        pcoord = convert_coord(self.pressxy,/device,/to_data)
        rcoord = convert_coord(self.releasexy,/device,/to_data)


        xbeg = pcoord[0]  ;double('nan')
        xend = rcoord[0];double('nan')
        ybeg = pcoord[1]  ;double('nan')
        yend = rcoord[1];double('nan')


        zoom = 0    ;FLAGS TO TELL IF RELEASE EVENT IS ZOOM OR SELECT OR NEITHER.
        select = 0

        pressButton = event.press
        releaseButton = event.release



        ;ZOOMING EVENTS
        ;GET LEFT PRESS POINT
        if event.press eq 1 then begin


            switch self.zoom_selectmode of
            0:
            1:
            2:
            3: begin
                self.leftmousepressed = 1
                self.zoomboxflag = 1
                self.pressxy = [event.x,event.y]


                pcoord = convert_coord(self.pressxy,/device,/to_data)
                rcoord = pcoord


                xbeg = pcoord[0]  ;double('nan')
                xend = rcoord[0];double('nan')
                ybeg = pcoord[1]  ;double('nan')
                yend = rcoord[1];double('nan')


                break
            end;3
            else:
            endswitch
        endif;event.press eq 1


        ;GET LEFT RELEASE POINT AND SET NEW RANGE VALUES
        if event.release eq 1 then begin


            self.leftmousepressed = 0
            self.zoomboxflag = 0
            case self.zoom_selectmode of
            0:begin
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]
                xend = self.releasexy[0]
                yend = self.releasexy[1]

                if self.pressxy[0] ne self.releasexy[0] or $
                    self.pressxy[1] ne self.releasexy[1] then begin
                        self->setZoomRange


                        self.zoomflag = 1
                    zoom=1
                    select=0
                endif
            end;0
            1:begin
                ;POSITION MODE
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]

                rcoord = convert_coord(self.releasexy,/device,/to_data)
                xend = rcoord[0];double('nan')
                yend = rcoord[1];double('nan')

                zoom=0
                select=1

            end;1
            2:begin
                ;START/END
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]
                rcoord = convert_coord(self.releasexy,/device,/to_data)
                xend = rcoord[0];double('nan')
                yend = rcoord[1];double('nan')
                zoom=0
                select = 0
            end;2

            3:begin
                ;REGION
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]
                rcoord = convert_coord(self.releasexy,/device,/to_data)
                xend = rcoord[0];double('nan')
                yend = rcoord[1];double('nan')
                zoom=0
                select = 1
            end;3
            else:begin
                zoom=0
                select=0
            endelse
            endcase

        endif;event.release eq 1


;        if event.release eq 4 then begin
;
;            ;widget_displaycontextmenu, self.tlb, event.x, event.y, self.contextMenu
;
;            ;UNZOOM FLAG
;            self.zoomflag = 0
;
;            ;RESTORE RANGES TO THE UNZOOMED VALUES
;            self.zoomxrange = self.xrange
;            self.zoomyrange = self.yrange
;        endif


        if event.press eq 4 then begin
            geom = widget_info(self.tlb,/geometry)
            self->updateContextSetList
            widget_displaycontextmenu,  self.tlb,$
                                        event.x,$
                                        geom.ysize - event.y, $
                                        self.contextMenu

            return,-1
        endif


;######################################################################
;
;   DEALING WITH DRAG EVENTS:
;
;######################################################################
        ;GET MOUSE POSITION ON DRAG WITH LEFT MOUSE BUTTON PRESSED
        if self.leftmousepressed eq 1 then begin
            self.mousexy = [event.x,event.y]
;            xend = self.mousexy[0]
;            yend = self.mousexy[1]
            rcoord = convert_coord(self.mousexy,/device,/to_data)
            xend = rcoord[0];double('nan')
            yend = rcoord[1];double('nan')


            ;020607
            ;SWALLOW DRAG EVENTS --- EXCEPT ON MOTION
            ;IF NOT POSITION MODE, SWALLOW EVENTS.
;            if self.zoom_selectmode ne 1 then return,-1

			;051707
			;SWALLOW ALL DRAG EVENTS IN cwo_selectable_drawplot_class

            return,-1

        endif
;#####################################################################

        xrange=self.zoomxrange
        yrange=self.zoomyrange

    if self.leftmousepressed eq 0 and $
            self.rightmousepressed eq 0 and $
                event.release eq 0 then begin


        ;SWALLOW MOTION EVENTS WHEN NO BUTTON PRESSED/RELEASED.
        return,-1
    endif else begin
        event = {id:self.tlb,top:self.parent,handler:self.parent,$
                    xbeg:xbeg,xend:xend,ybeg:ybeg,yend:yend,$
                    xrange:xrange,yrange:yrange,zoom:zoom,select:select,$
                    mode:self.zoom_selectmode,$
                    press:pressButton,release:releaseButton}
        return,event
    endelse

end;handleMouseEvents





;##########################################
;STARTUP METHODS
;##########################################
;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class::createContextMenu
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_selectable_drawplot_class::createContextMenu


	ret = self->cwo_drawplot_class::createContextmenu()


    return,ret
end;createContextMenu



;##########################################
;GENERAL CLASS METHODS
;##########################################




;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class::setProperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_selectable_drawplot_class::setProperty,$
                parent=parent,$
                tlb=tlb,$
                draw=draw,$
                winpix=winpix,$
                winsav=winsav,$
                winvis=winvis,$
                xptr=xptr,$
                yptr=yptr,$
                xhide=xhide,yhide=yhide,$
                xshow=xshow,yshow=yshow,$
                showplot=showplot,$
                leftMousePressed=leftMousePressed,$
                rightMousePressed=rightMousePressed,$
                mousexy=mousexy,$
                pressxy=pressxy,$
                releasexy=releasexy,$
                    zoomflag=zoomflag,$
                    zoomboxflag=zoomboxflag,$
                    zoomxrange=zoomxrange,$
                    zoomyrange=zoomyrange,$
                    xrange=xrange,$
                    yrange=yrange,$
                      xmaxrange=xmaxrange,$
                      ymaxrange=ymaxrange,$
                    title=title,$
                    subtitle=subtitle,$
                    xtitle=xtitle,$
                    ytitle=ytitle,$
                    xlog=xlog,$
                ylog=ylog,$
                xlegend=xlegend,$
                ylegend=ylegend,$
                showlegend=showlegend,$
                black=black,$
                red=red,$
                green=green,$
                blue=blue,$
                white=white,$
                frame=frame,$
                contextmenu=contextmenu,$
                _ref_extra=extra


		self->cwo_drawplot_class::setproperty,$
                parent=parent,$
                tlb=tlb,$
                draw=draw,$
                winpix=winpix,$
                winsav=winsav,$
                winvis=winvis,$
                xptr=xptr,$
                yptr=yptr,$
                xhide=xhide,yhide=yhide,$
                xshow=xshow,yshow=yshow,$
                showplot=showplot,$
                leftMousePressed=leftMousePressed,$
                rightMousePressed=rightMousePressed,$
                mousexy=mousexy,$
                pressxy=pressxy,$
                releasexy=releasexy,$
                    zoomflag=zoomflag,$
                    zoomboxflag=zoomboxflag,$
                    zoomxrange=zoomxrange,$
                    zoomyrange=zoomyrange,$
                    xrange=xrange,$
                    yrange=yrange,$
                      xmaxrange=xmaxrange,$
                      ymaxrange=ymaxrange,$
                    title=title,$
                    subtitle=subtitle,$
                    xtitle=xtitle,$
                    ytitle=ytitle,$
                    xlog=xlog,$
                ylog=ylog,$
                xlegend=xlegend,$
                ylegend=ylegend,$
                showlegend=showlegend,$
                black=black,$
                red=red,$
                green=green,$
                blue=blue,$
                white=white,$
                frame=frame,$
                contextmenu=contextmenu,$
                _extra=extra


end;cwo_selectable_drawplot_class::setProperty


;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class::getProperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_selectable_drawplot_class::getProperty,$
                parent=parent,$
                tlb=tlb,$
                draw=draw,$
                winpix=winpix,$
                winsav=winsav,$
                winvis=winvis,$
                xptr=xptr,$
                yptr=yptr,$
                xhide=xhide,yhide=yhide,$
                xshow=xshow,yshow=yshow,$
                showplot=showplot,$
                leftMousePressed=leftMousePressed,$
                rightMousePressed=rightMousePressed,$
                mousexy=mousexy,$
                pressxy=pressxy,$
                releasexy=releasexy,$
                    zoomflag=zoomflag,$
                    zoomboxflag=zoomboxflag,$
                    zoomxrange=zoomxrange,$
                    zoomyrange=zoomyrange,$
                    xrange=xrange,$
                    yrange=yrange,$
                      xmaxrange=xmaxrange,$
                      ymaxrange=ymaxrange,$
                    title=title,$
                    subtitle=subtitle,$
                    xtitle=xtitle,$
                    ytitle=ytitle,$
                    xlog=xlog,$
                ylog=ylog,$
                xlegend=xlegend,$
                ylegend=ylegend,$
                showlegend=showlegend,$
                black=black,$
                red=red,$
                green=green,$
                blue=blue,$
                white=white,$
                frame=frame,$
                contextmenu = contextmenu,$
                _ref_extra=extra


		self->cwo_drawplot_class::getProperty,$
                parent=parent,$
                tlb=tlb,$
                draw=draw,$
                winpix=winpix,$
                winsav=winsav,$
                winvis=winvis,$
                xptr=xptr,$
                yptr=yptr,$
                xhide=xhide,yhide=yhide,$
                xshow=xshow,yshow=yshow,$
                showplot=showplot,$
                leftMousePressed=leftMousePressed,$
                rightMousePressed=rightMousePressed,$
                mousexy=mousexy,$
                pressxy=pressxy,$
                releasexy=releasexy,$
                    zoomflag=zoomflag,$
                    zoomboxflag=zoomboxflag,$
                    zoomxrange=zoomxrange,$
                    zoomyrange=zoomyrange,$
                    xrange=xrange,$
                    yrange=yrange,$
                      xmaxrange=xmaxrange,$
                      ymaxrange=ymaxrange,$
                    title=title,$
                    subtitle=subtitle,$
                    xtitle=xtitle,$
                    ytitle=ytitle,$
                    xlog=xlog,$
                ylog=ylog,$
                xlegend=xlegend,$
                ylegend=ylegend,$
                showlegend=showlegend,$
                black=black,$
                red=red,$
                green=green,$
                blue=blue,$
                white=white,$
                frame=frame,$
                contextmenu = contextmenu,$
                _extra=extra


end;cwo_selectable_drawplot_class::getproperty
;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_selectable_drawplot_cleanup,id
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;cwo_selectable_drawplot_cleanup
;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_selectable_drawplot_class::cleanup
    print,'cwo_selectable_drawplot_class::cleanup'

	self->cwo_drawplot_class::cleanup

end;cwo_selectable_drawplot_class::cleanup




;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_selectable_drawplot_class::init,parent, tlb=tlb,$
                                    xhide=xhide,yhide=yhide,$
                                    xshow=xshow,yshow=yshow,$
                                    showplot=showplot,$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue,$
                                    uname=uname,$
                                    frame=frame,$
                                    title=title,$
                                    xtitle=xtitle,$
                                    ytitle=ytitle,$
                                    kill_notify=kill_notify,$
				                    position=position,$
				                    xoffset=xoffset,yoffset=yoffset,$
                                    xmaxrange=xmaxrange,$
                                    ymaxrange=ymaxrange,$
                                    xticks=xticks,yticks=yticks,$
                                    mode=mode,$
                                    _ref_extra=extra
    catch,es
    if es ne 0 then begin
        void = dialog_message('Error occurred in cwo_selectable_drawplot_class::init, please report the following: '+!error_state.msg)
        catch,/cancel
        return,-1
    endif

	ret = self->cwo_drawplot_class::init(parent, tlb=tlb,$
                                    xhide=xhide,yhide=yhide,$
                                    xshow=xshow,yshow=yshow,$
                                    showplot=showplot,$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue,$
                                    uname=uname,$
                                    frame=frame,$
                                    title=title,$
                                    xtitle=xtitle,$
                                    ytitle=ytitle,$
                                    kill_notify=kill_notify,$
				                    position=position,$
				                    xoffset=xoffset,yoffset=yoffset,$
                                    xmaxrange=xmaxrange,$
                                    ymaxrange=ymaxrange,$
                                    xticks=xticks,yticks=yticks,$
                                    mode=mode,$
                                    _extra=extra)

    return,1
end;cwo_selectable_drawplot_class::init


;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot_class__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_selectable_drawplot_class__define,class



    ;NOTE THAT THIS BASE CLASS WILL SIMPLY PROVIDE THE PLOTTING
    ;AND INTERACTION CAPABILITY WITHOUT THE SPECIFIC DATA.
    ;THE SPECIFIC DATA WILL BE HANDLED IN THE SUBCLASSES
    ;USING SUBCLASS VARIABLES.


    ;BUT WAIT, THIS IS A CONTAINER!!!!
    ;THE DATA WILL BE STORED IN DATA OBJECTS!!!



    class = {   cwo_selectable_drawplot_class,$
				inherits cwo_drawplot_class,$
				mymode:0L}


end;cwo_selectable_drawplot_class__define,class



;###############################################################################
;
;NAME:
;        cwo_selectable_drawplot
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_selectable_drawplot,parent,obj=obj,xsize=xsize,ysize=ysize,$
                      uvalue=uvalue,position=position,$
                      uname=uname,$
                      xoffset=xoffset,yoffset=yoffset,$
                      title=title,xtitle=xtitle,ytitle=ytitle,$
                      xhide=xhide,yhide=yhide,$
                      xshow=xshow,yshow=yshow,$
                      showplot=showplot,$
                      xmaxrange=xmaxrange,$
                      ymaxrange=ymaxrange,$
                      frame=frame,$
                      xticks=xticks,yticks=yticks,$
                      mode=mode,$
                      _Extra=extra



    if n_elements(parent) eq 0 then return,0L
    if n_elements(frame) eq 0 then frame=0

    obj = obj_new('cwo_selectable_drawplot_class',parent,frame=frame,xsize=xsize,ysize=ysize,$
                                 uvalue=uvalue,position=position,$
                                 uname=uname,$
                                 xoffset=xoffset,yoffset=yoffset,$
                                 xtitle=xtitle,ytitle=ytitle,title=title,$
                                 xhide=xhide,yhide=yhide,$
                                 xshow=xshow,yshow=yshow,$
                                 showplot=showplot,$
                                 xmaxrange=xmaxrange,$
                                 ymaxrange=ymaxrange,$
                                 xticks=xticks,yticks=yticks,$
                                 mode=mode,$
                                 _Extra=extra)

    obj->getproperty,tlb=tlb


    return,tlb

end;cwo_selectable_drawplot
