; $Id$



function cwo_panmaskeditor::updateMask,xpos,ypos
		;UPDATE BOTH THE DISPLAYED MASK AND THE STORED MASK BASED ON xpos,ypos.
		;DON'T UPDATE IF THE POSITIONS ARE OUTSIDE THE DATA IN THE IMAGE.

		;GET THE DISPLAYED MASK CONTAINED IN THE IMAGE OBJECT
print,'NOTE:  cwo_panmaskeditor::updateMask ASSUMES DISPLAYED MASK IS IN THE 2nd POSITION IN THE IMAGE.'
		imagedata = self.imageobj->get(position=self.maskposition)
		imagedata->getproperty,image=displayedMask
		currentMask = *self.panmask

		szarr = size(displayedmask)
		case szarr[0] of
		1:begin
			;TOGGLE MASK BASED ON SELECTION
			if ypos lt 0 then return,-1
			if ypos ge 1 then return,-1
			if xpos ge szarr[1] then return,-1
			if xpos lt 0 then return,-1

			displayedMask[xpos] = ((displayedmask[xpos] eq 0) ? 1 : 0)
			currentMask[xpos] = ((currentMask[xpos] eq 0) ? 1 : 0)
			*self.panmask = currentmask
			imagedata->setproperty,image=currentMask
			return,1
		end;1
		2:begin
			;TOGGLE MASK BASED ON SELECTION
			if ypos lt 0 then return,-1
			if ypos ge szarr[2] then return,-1
			if xpos ge szarr[1] then return,-1
			if xpos lt 0 then return,-1

			displayedMask[xpos,ypos] = ((displayedMask[xpos,ypos] eq 0) ? 1 : 0)
			currentMask[xpos,ypos] = ((currentMask[xpos,ypos] eq 0) ? 1 : 0)
			*self.panmask = currentmask
			imagedata->setproperty,image=displayedMask
			return,1
		end;2
		else:return,-1
		endcase

end;cwo_panmaskeditor::updateMask


pro cwo_panmaskeditor::updatePlotData


	self.plotobj->cleardata

    sz = size(*self.qty)

    if sz[0] eq 1 then begin
        xlen = sz[1]
        ylen = 1
    endif else begin
        xlen = sz[2]
        ylen = sz[1]
    endelse

	;UPDATE PLOTS
    for i=0,ylen-1 do begin
        if i eq 0 then show = 1 else show = 0

        rowmask = (*self.panmask)[i,*]

;print,transpose(rowmask)
        wh = where(rowmask ne 0,count)

		if count ne 0 then begin
	        ;print,'x=',
	        thisx = (*self.x)[wh]
	        ;print,'qty=',
	        thisqty = (*self.qty)[i,[wh]]
	        ;print,'err=',
	        thiserr = (*self.err)[i,[wh]]
	        ;print,(*self.qty)[i,*]

	        self.plotobj->add,x=thisx,$
	                          y=thisqty,$
	                          sy=thiserr,$
	                          legend='Group'+strtrim(i,2),$
	                          position=i,$
	                          showdata=show
		endif else begin
	        ;print,'x=',
	        thisx = (*self.x)
	        ;print,'qty=',
	        thisqty = 0*(*self.qty)[i,*]
	        ;print,'err=',
	        thiserr = 0*(*self.err)[i,*]
	        ;print,(*self.qty)[i,*]

	        self.plotobj->add,x=thisx,$
	                          y=thisqty,$
	                          sy=thiserr,$
	                          legend='Group'+strtrim(i,2),$
	                          position=i,$
	                          showdata=show

		endelse

    endfor;i

end;cwo_panmaskeditor::updatePlotData




function cwo_panmaskeditor_event,event

    widget_control,event.handler,get_uvalue=self
    newevent = self->event(event)


    return,-1
end;cwo_panmaskeditor_event

function cwo_panmaskeditor::event,event
    case event.id of
    self.plotid:begin
        print,'Plot'
        print,tag_names(event)
        print,event

		;GET THE POINT NUMBER FROM THE DATA AND UPDATE THE MASK AND PLOT APPROPRIATELY

    end;self.plotid
    self.imageid:begin
;        print,'Image'
;        print,tag_names(event)
;        print,event

		;GET THE POSITION AND UPDATE THE MASK AND PLOT APPROPRIATELY


;		print,'event.select=',event.select
		case event.mode of
		0:begin
			;ZOOMING, THEREFORE THIS EVENT SHOULD BE SWALLOWED BY THE IMAGE VIEWER
		end;0
		1:begin
			;GET THE SINGLE PIXEL THAT THE USER WISHES TO CHANGE.
			xpos = fix(floor(event.xend))
			ypos = fix(floor(event.yend))

			ret = self->updateMask(xpos,ypos)
			if ret ne 1 then return,-1

			;NOW UPDATE THE 1d DATA BASED ON THE MASK.  --- THIS SHOULD BE A SEPARATE PROCEDURE.
			;NOTE ALSO THAT PAN WILL PROBABLY NEED THE SAME SORT OF UPDATE ONCE MASK EDITING IS COMPLETE!!!!

			;SET THE NEXT GROUPS BASED ON THE MASK!!!!!!!
			;
			self->updatePlotData
			self.imageobj->draw
			self.plotobj->draw

;TOMORROW

;1) NEED AN UPDATE METHOD THAT UPDATES THE 1D AND 2D DATA SETS AND UPDATES THE DISPLAYS!!!!!

;2) CRAIG EXTENSIVELY MODIFIED xobjview FOR HIS GAUSSIAN DISPLAY PROGRAM.

;3) ADD AXIS LABELS FOR GROUP AND POINT NUMBER ON THE MASK.

;4) MAKE A ROUTINE TO UPDATE THE PLOT BASED ON THE GROUP SELECTION
;5) PUT A CIRCLE AROUND THE CURRENT GROUP IN THE IMAGE.


		end;1
		2:begin
			;START/END, WHICH IS MEANINGLESS IN THE SELECTION CIRCUMSTANCE,
			;UNLESS I ALLOW MASKING ALONG A LINE.
		end;2
		3:begin
			;GET THE BLOCK OF PIXELS SELECTED BY THE USER
		end;3
		else:
		endcase

    end;self.imageid
    self.tlb:begin
        print,'tlb'
    end;self.tlb
    self.open:begin
        print,'Open'
    end;self.open
    self.help:begin
        print,'Help'
    end;self.help
    self.quit:begin
        print,'Quit'
        widget_control,self.tlb,/destroy
    end;self.quit
    self.groupslider:begin
;        print,'Group Slider'
;        print,tag_names(event)
;        print,event

        widget_control,self.groupslider,get_value=val
;        print,val

        ref = self.plotobj->get(/all)
        for i=0,n_elements(ref)-1 do begin
            ref[i]->setProperty,showdata=0
        endfor;i
        ref = self.plotobj->get(position=val)
        ref->setProperty,showdata=1
        self.plotobj->defaultdraw

    end;self.groupslider
    self.imagegroup:begin
        print,'Image selection'
        widget_control,self.imagegroup,get_value=val
        print,val
		case val of
		0:setval=self.qtyposition
		1:setval=self.errposition
		2:setval=self.maskposition
		else:setval = self.maskposition
		endcase

        self.imageobj->setproperty,imageIndex=setval
        self.imageobj->draw,position=setval
    end;self.imagegroup
    else:
    endcase

    return,-1
end;cwo_panmaskeditor::event
pro cwo_panmaskeditor::setProperty,daveptr=daveptr,$
                                   x=x,y=y,$
                                   qty=qty,err=err,$
                                   panmask=panmask



    if n_elements(daveptr) eq 0 then begin
        if ptr_valid(self.daveptr) gt 0 then ptr_free,self.daveptr
        self.daveptr = daveptr
    endif
    if n_elements(x) eq 0 then begin
        if ptr_valid(self.x) gt 0 then ptr_free,self.x
        self.x = x
    endif
    if n_elements(y) eq 0 then begin
        if ptr_valid(self.y) gt 0 then ptr_free,self.y
        self.y = y
    endif
    if n_elements(qty) eq 0 then begin
        if ptr_valid(self.qty) gt 0 then ptr_free,self.qty
        self.qty = qty
    endif
    if n_elements(err) eq 0 then begin
        if ptr_valid(self.err) gt 0 then ptr_free,self.err
        self.err = err
    endif
    if n_elements(panmask) eq 0 then begin
        if ptr_valid(self.panmask) gt 0 then ptr_free,self.panmask
        self.panmask = panmask
    endif



end;cwo_panmaskeditor::setProperty

pro cwo_panmaskeditor::getProperty,daveptr=daveptr,$
                                   x=x,y=y,$
                                   qty=qty,err=err,$
                                   panmask=panmask

    if arg_present(daveptr) then daveptr = self.daveptr
    if arg_present(x) then x = self.x
    if arg_present(y) then y = self.y
    if arg_present(qty) then qty = self.qty
    if arg_present(err) then err = self.err
    if arg_present(panmask) then panmask=self.panmask

end;cwo_panmaskeditor::getProperty


pro cwo_panmaskeditor_cleanup,id

    widget_control,id,get_uvalue=self
    obj_destroy,self


end;cwo_panmaskeditor_cleanup




pro cwo_panmaskeditor::cleanup

    ptr_free,self.daveptr
    ptr_free,self.x
    ptr_free,self.y
    ptr_free,self.qty
    ptr_free,self.err
    ptr_free,self.panmask

end;cwo_panmaskeditor::cleanup

function cwo_panmaskeditor::init,qty=qty,err=err,x=x,y=y,pan_mask=pan_mask,$
                                 tlb=tlb,group_leader=group_leader






    if n_elements(group_leader) eq 0 then begin
        tlb = widget_base(/row,title='PAN Mask Editor',mbar=bar,kill_notify='cwo_panmaskeditor_cleanup')
    endif else begin
        tlb = widget_base(/row,title='PAN Mask Editor',mbar=bar,kill_notify='cwo_panmaskeditor_cleanup',group_leader=group_leader)
    endelse

    self.tlb = tlb

    llb1 = widget_base(tlb,/col)
    llb2 = widget_base(tlb,/col)
    llb3 = widget_base(tlb,/col)

    filemenu = widget_button(bar,value='File',/menu)
    self.open = widget_button(filemenu,value='Open')
    self.help = widget_button(filemenu,value='Help')
    self.quit = widget_button(filemenu,value='Quit')


    self.groupslider = widget_slider(llb1)
    self.imagegroup = cw_bgroup(llb1,['qty','err','mask'],/exclusive,/col)
    widget_control,self.imagegroup,set_value=0;[1,0,0]

    self.plotid = cwo_selectable_drawplot(llb2,obj=obj,xsize=400,ysize=400)
    self.plotobj = obj
    self.imageid = cwo_drawimage(llb3,obj=obj,xsize=400,ysize=400,xtitle='Point Number',ytitle='Group Number',title='Mask')
    self.imageobj = obj


    if ptr_valid(self.qty) gt 0 then ptr_free,self.qty
    if n_elements(qty) ne 0 then begin
        self.qty = ptr_new(qty)
    endif else begin
        self.qty = ptr_new(findgen(20,20))
    endelse

    if ptr_valid(self.err) gt 0 then ptr_free,self.err
    if n_elements(err) ne 0 then begin
        self.err = ptr_new(err)
    endif else begin
        dum = *self.qty
        self.err = ptr_new(0.0*(dum)+1.0*randomu(seed,20,20))
    endelse




    if ptr_valid(self.panmask) gt 0 then ptr_free,self.panmask
    if n_elements(pan_mask) ne 0 then begin

		szqty = size(qty)
		szmsk = size(pan_mask)

		if szqty[0] eq 1 then begin
			nr = szqty[1]
			nc = 1
		endif else begin
			nr = szqty[1]
			nc = szqty[2]
		endelse


		;IF IT EXISTS, CHECK THAT THE pan_mask IS THE SAME SIZE AS
		;qty.  IF IT IS NOT THEN RUN bytes2bits TO CONVERT IT.
		if szmsk[0] ne szqty[0] then begin
			panmask = bytes2bits(pan_mask,nr,nc)
		endif else begin
			if szmsk[1] ne szqty[1] then begin
				panmask = bytes2bits(pan_mask,nr,nc)
			endif else begin
				if szmsk[2] ne szqty[2] then begin
					;THIS SHOULD OVERCOME THE LAST OF THE POTENTIAL COINCIDENCES.
					panmask = bytes2bits(pan_mask,nr,nc)
				endif else begin
					;OTHERWISE THE panmask IS ENTERED IN THE BITS FORMAT
					panmask = pan_mask
				endelse
			endelse
		endelse


        self.panmask = ptr_new(panmask)
    endif else begin
        self.panmask = ptr_new(byte(0*(*self.qty)) + 1b)
    endelse

	self.qtyposition  = 0
	self.errposition  = 1
	self.maskposition = 2

    self.imageobj->addData,*self.qty,self.qtyposition
    self.imageobj->addData,*self.err,self.errposition
    self.imageobj->addData,*self.panmask,self.maskposition

    self.imageobj->setProperty,imageindex=0


    sz = size(*self.qty)

    if sz[0] eq 1 then begin
        xlen = sz[1]
        ylen = 1
    endif else begin
        xlen = sz[2]
        ylen = sz[1]
    endelse

    if n_elements(x) ne 0 then begin
        if ptr_valid(self.x) gt 0 then ptr_free,self.x
        self.x = ptr_new(x)
    endif else begin
        self.x = ptr_new(findgen(xlen))
    endelse


    if n_elements(y) ne 0 then begin
        if ptr_valid(self.y) gt 0 then ptr_free,self.y
        self.y = ptr_new(y)
    endif else begin
        self.y = ptr_new(findgen(ylen))
    endelse


;MONDAY!!!!
;
;
;SET THE NEXT SETS BASED ON THE MASK!!!!!!!
;
;
;
    for i=0,ylen-1 do begin
        if i eq 0 then show = 1 else show = 0

        rowmask = (*self.panmask)[i,*]

        wh = where(rowmask ne 0,count)

        ;print,'x=',
        thisx = (*self.x)[wh]
        ;print,'qty=',
        thisqty = (*self.qty)[i,[wh]]
        ;print,'err=',
        thiserr = (*self.err)[i,[wh]]
        ;print,(*self.qty)[i,*]

        self.plotobj->add,x=thisx,$
                          y=thisqty,$
                          sy=thiserr,$
                          legend='Group'+strtrim(i,2),$
                          position=i,$
                          showdata=show

    endfor;i


    widget_control,self.groupslider,set_slider_max=n_elements(*self.y)-1



    widget_control,self.tlb,/realize,set_uvalue=self

    self.plotobj->defaultdraw
    lk_xmanager,'cwo_panmaskeditor',tlb,event_func='cwo_panmaskeditor_event';,/no_block

    ;widget_control,self.tlb,event_func='cwo_panmaskeditor_event'


;    self.plotobj->defaultdraw

    return,1
end;cwo_panmaskeditor::init


pro cwo_panmaskeditor__define,class
print,'cwo_panmaskeditor__define'
    class = {cwo_panmaskeditor,$
                plotid:0L,$
                plotobj:obj_new(),$
                imageid:0L,$
                imageobj:obj_new(),$
                tlb:0L,$
                open:0L,$
                help:0L,$
                quit:0L,$
                groupslider:0L,$
                imagegroup:0L,$
                maskposition:2,$
                qtyposition:0,$
                errposition:1,$
                daveptr:ptr_new(),$
                x:ptr_new(),$
                y:ptr_new(),$
                qty:ptr_new(),$
                err:ptr_new(),$
                panmask:ptr_new()}


end;cwo_panmaskeditor__define

function cwo_panmaskeditor,qty=qty,err=err,x=x,y=y,pan_mask=pan_mask,obj=obj,group_leader=group_leader,_extra=extra
print,'cwo_panmaskeditor1'


    obj = obj_new('cwo_panmaskeditor',qty=qty,err=err,x=x,y=y,pan_mask=pan_mask,$
                                      tlb=tlb,group_leader=group_leader)

print,'cwo_panmaskeditor2'

    return,tlb


end;cwo_panmaskeditor


