; $Id$
;###############################################################################
;
; NAME:
;  PAN_LOGNORMAL
;
; PURPOSE:
;  Lognormal distribution for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_lognormal, x,parms,$
                    	parmnames = parmnames, $
                    	canDraw = canDraw, $
                    	drawMessage = drawMessage, $
                      func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
                      changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
                      _Extra = extra
canDraw = 1
twoDimFlag = 0


if n_params() eq 0 then begin
  parmnames = ['area','mean','std dev']
  return,-1
endif

drawMessage = strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag function centroid']
drawMessage[2:3] = ['Hold left mouse button down','and drag to change width']

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...'
  func_dataHash['ymax'] = yMouseClick
  width = 0.02*(xrange[1]-xrange[0])
  sig = width/2.354
  xmode = Exp(parms[1]-sig^2)
  func_dataHash['xmode'] = xmode
  area = 2.0*Sqrt(2.0*!dpi*sig^2)*Abs(xmode)*yMouseClick*Exp(-0.5*sig^2)
  parms[0] = area
  parms[1] = sig^2+Alog(Abs(xMouseClick))
  parms[2] = sig
  
  
endif

if (Keyword_set(changesecond)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is move to define the function width
  ; translate the position into suitable parameters.
  ;Print,'###Changesecond called within function...'
  area = parms[0]
  mu = parms[1]
  wid = 0.02*(xrange[1]-xrange[0])
  oldSig = wid/2.354
  xmode = func_dataHash['xmode']

  newWidth = abs(-(abs(xMouseClick)-xmode-wid)) > 1d-8
  newSig = newWidth/2.354
  xmode = exp(mu-newSig^2)

  newArea = 2.0*sqrt(2.0*!dpi*newSig^2)*abs(xmode)*(func_dataHash['ymax'])* $
            exp(-0.5*newSig^2)

  parms[0] = newArea ;area
  parms[1] = newSig^2+alog(abs(xmode))
  parms[2] = newSig
endif


amp = parms[0]
cen = parms[1]
sig = parms[2]

wherezero = where(x eq 0.0,countZero)
whereNotZero = where(x ne 0.0)
y = dblarr(n_elements(x))
y[whereNotZero] = (0.5*amp/(sqrt(2.0*!pi*sig^2)))*(1.0/abs(x[whereNotZero]))*$
                  exp(-0.5*(alog(abs(x[whereNotZero]))-abs(cen))^2/sig^2)
;y[whereNotZero] = 0.5*amp/(sqrt(2.0*!pi*sig^2)*x[whereNotZero])*$
;                  exp(-0.5*(alog(x[whereNotZero]/cen))^2/sig^2)
if countZero gt 0 then begin
  y[wherezero] = 0.0
endif

return,y
end