; $Id$
function pan_FT_KWW_AAC,E,parms, parmnames=parmnames, $
                 canDraw=canDraw, $
                 _Extra=extra

;BASED ON AAC function in D. Gomez and A. Alegria, J. Non-Cryst. Solids, 287, p. 246-251, (2001)

if n_params() eq 0 then begin
    parmnames = ['Amp','E0','tau_KWW','beta_KWW']
    return,-1
endif
canDraw=0
  i = dcomplex(0.0,1.0)
  hbar=0.6528 ;ueV.ns

amp=parms[0]
E0=parms[1]
tau_KWW=parms[2]*complex(1.0) ;Convert to complex this way. For some reason it was problematic with the cast call.
beta_KWW=parms[3]*complex(1.0)

  ;CALCULATE THE FT_KWW
  omega = (E-E0)/hbar  
  omega0 = E0/hbar
  ;result = dcomplexarr(n_elements(e))

  ;NEED ALPHA IN TERMS OF BETA
  alpha = ((dindgen(11001))/10000.0)   ;WILL THIS BE PRECISE ENOUGH???
  gamtemp = (1 - 0.812*(1.0 - alpha)^0.387)
  diff =   abs((alpha*gamtemp)^(1.0/1.23) - beta_kww)  ;SOLVE FOR alpha "GRAPHICALLY"
  
  
  mindiff = min(diff,minindex)
  
  alpha0 = alpha[minindex]
  gam = 1 - 0.812*(1.0 - alpha0)^0.387  ;eq. 4

  ;NOW CALCULATE tau_HN FROM THE FIT PARAMETER, tau_KWW --- eq. 5.2
  tau_HN = tau_KWW*(10.0^(2.6*sqrt(1.0 - beta_KWW)*exp(-3.0*beta_KWW)))
  result = (1/(!dpi*HBAR^2))*(-amp/omega)*imaginary((1.0/((1.0 + (i*(tau_HN/hbar)*omega)^alpha0)^(gam))))

  whzero = where(omega eq 0.0,zeroct)
  ;if zeroct ne 0 then result[whzero] = tau_KWW/beta_KWW*gamma(1/beta_KWW);amp;complex(amp,amp)  ;IS THIS CORRECT???
  if zeroct ne 0 then begin
    epsilon = 1.0e-09
    result_left = (1/(!dpi*HBAR^2))*(-amp/(omega[whzero]-epsilon))*imaginary((1.0/((1.0 + (i*(tau_HN/hbar)*(omega[whzero]-epsilon))^alpha0)^(gam))))
    result_right = (1/(!dpi*HBAR^2))*(-amp/(omega[whzero]+epsilon))*imaginary((1.0/((1.0 + (i*(tau_HN/hbar)*(omega[whzero]+epsilon))^alpha0)^(gam))))
    result[whzero] = (result_left+result_right)/2.0
    print,result[whzero]
  endif
  return,result
end;pan_FTKWW_AAC

;function pan_FT_KWW_AAC,E,parms, parmnames=parmnames, $
;                 canDraw=canDraw, $
;                 _Extra=extra
;
;;BASED ON AAC function in D. Gomez and A. Alegria, J. Non-Cryst. Solids, 287, p. 246-251, (2001)
;
;if n_params() eq 0 then begin
;    parmnames = ['Amp','E0','tau_KWW','beta_KWW']
;    return,-1
;endif
;canDraw=0
;  i = dcomplex(0.0,1.0)
;  hbar=0.6528 ;ueV.ns
;
;amp=parms[0]
;E0=parms[1]
;;tau_KWW=complex(parms[2])
;;beta_KWW=complex(parms[3])
;tau_KWW=parms[2]*complex(1.0) ;Convert to complex this way. For some reason it was problematic with the cast call.
;beta_KWW=parms[3]*complex(1.0)
;
;
;
;
;  ;CALCULATE THE FT_KWW
;  omega = (E-E0)/hbar  
;  omega0 = E0/hbar
;  result = dcomplexarr(n_elements(e))
;
;
;;  beta = (alpha*gamma)^(1.0/1.23) ;eq. 5.1
;
;  ;NEED ALPHA IN TERMS OF BETA
;  alpha = ((dindgen(11001))/10000.0)   ;WILL THIS BE PRECICE ENOUGH???
;  gamtemp = (1 - 0.812*(1.0 - alpha)^0.387)
;  diff =   abs((alpha*gamtemp)^(1.0/1.23) - beta_KWW)  ;SOLVE FOR alpha "GRAPHICALLY"
;  
;  
;  mindiff = min(diff,minindex)
;    
;  alpha0 = alpha[minindex]
;  ;print,'alph0=',alpha0
;  gam = 1 - 0.812*(1.0 - alpha0)^0.387  ;eq. 4
;  ;print,'gamma=',gam
;
;  ;NOW CALCULATE tau_HN FROM THE FIT PARAMETER, tau_KWW --- eq. 5.2
;  tau_HN = tau_KWW*(10.0^(2.6*sqrt(1.0 - beta_KWW)*exp(-3.0*beta_KWW)))
;  ;print,'tau_HN,tau_KWW=',tau_HN,tau_KWW
;  result = (1/(!dpi*HBAR))*(-amp/omega)*imaginary((1.0/((1.0 + (i*(tau_HN/hbar)*omega)^alpha0)^(gam))))
;  
;  return,result
;end;pan_FTKWW_AAC
