;$Id$
;###############################################################################
;
; NAME:
;  TAS_PREFERENCES
;
; PURPOSE:
;  This widget dialog allows the user to set preferences for fitting in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro tas_pref_event,event
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
'CANCEL':	$
	begin
		(*pstate).cancel = 1
		widget_control,event.top,/destroy
	end
'ACCEPT':	$
	begin
		(*pstate).cancel = 0
		month_id = widget_info(event.top,find_by_uname = 'MONTH')
		day_id = widget_info(event.top,find_by_uname = 'DAY')
		year_id = widget_info(event.top,find_by_uname = 'YEAR')
		widget_control,month_id,get_value = month
		widget_control,day_id,get_value = day
		widget_control,year_id,get_value = year
		julian_date = julday(fix(month[0]), fix(day[0]), fix(year[0]))
		(*pstate).julian_date = julian_date
		raw_id = widget_info(event.top,find_by_uname = 'RAW')
		widget_control,raw_id,get_value = raw_dir
		(*pstate).raw_directory = raw_dir[0]
		dave_id = widget_info(event.top,find_by_uname = 'DAVE')
		widget_control,dave_id,get_value = dave_dir
		(*pstate).dave_directory = dave_dir[0]
		widget_control,event.top,/destroy
	end
'CHOOSE_RAW':	$
	begin
		directory = dialog_pickfile(title = 'Select raw data directory',/directory, $
			path=(*pstate).raw_directory)
		if directory ne '' then begin
			(*pstate).raw_directory = directory
			raw_id = widget_info(event.top,find_by_uname = 'RAW')
			widget_control,raw_id,set_value = (*pstate).raw_directory
		endif
	end
'CHOOSE_DAVE':	$
	begin
		directory = dialog_pickfile(title = 'Select DAVE data directory',/directory, $
			path=(*pstate).dave_directory)
		if directory ne '' then begin
			(*pstate).dave_directory = directory
			dave_id = widget_info(event.top,find_by_uname = 'DAVE')
			widget_control,dave_id,set_value = (*pstate).dave_directory
		endif
	end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function tas_preferences,group_leader = group_leader,prefs
widget_control,group_leader,get_uvalue = pinfo
raw_directory = prefs.raw_directory
dave_directory = prefs.dave_directory
julian = prefs.julian_date
caldat,julian,month,day,year
month = string(month) & day = string(day) & year = string(year)
tlb = widget_base(/col,title = 'TAS Preferences',/tlb_frame_attr, $
	group_leader = group_leader,/modal,/base_align_right)
void = widget_label(tlb,value = 'Starting date for browsing files')
void = cw_field(tlb,value = month,title = 'Month',	$
	uname = 'MONTH')
void = cw_field(tlb,value = day,title = 'Day',	$
	uname = 'DAY')
void = cw_field(tlb,value = year,title = 'Year', $
	uname = 'YEAR')
row_base = lonarr(3)
for i = 0,2 do begin
	row_base[i] = widget_base(tlb,/row)
endfor
xsize = 70
void = cw_field(row_base[0],value = raw_directory,title = 'Raw data directory', $
	uname = 'RAW',xsize = xsize,/return_events)

void = cw_field(row_base[1],value = dave_directory,title = 'DAVE data directory', $
	uname = 'DAVE',xsize = xsize,/return_events)
void = widget_button(row_base[2],value = 'Choose RAW directory',uname = 'CHOOSE_RAW')
void = widget_button(row_base[2],value = 'Choose DAVE directory',uname = 'CHOOSE_DAVE')
void = widget_button(row_base[2],value = 'Accept',uname = 'ACCEPT')
void = widget_button(row_base[2],value = 'Cancel',uname = 'CANCEL')

widget_control,tlb,/realize
state =	{	julian_date:prefs.julian_date,			$
			cancel:0,								$
			raw_directory:prefs.raw_directory,		$
			dave_directory:prefs.dave_directory		}

pstate = ptr_new(state)
widget_control,tlb,set_uvalue = pstate
xmanager,'tas_pref',tlb,event_handler = 'tas_pref_event',/no_block
output = *pstate
ptr_free,pstate
return,output
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
