; $Id$
;###############################################################################
;
; NAME:
;  TAS_INDEP_VAR_WIDGET
;
; PURPOSE:
;  This widget dialog allows the user to select an independent variable from
;  an ICP TAS file.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro tivw_cleanup,tlb
widget_control,tlb,get_uvalue = pstate
ptr_free,pstate
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tivw_send_info,event
widget_control,event.top,get_uvalue = pstate
id = widget_info(event.top,find_by_uname = 'XGROUP')
widget_control,id,get_value = val & val = fix(val[0])
(*pstate).indep_var_index = val
ret = (*pstate).object->set(indep_var_index = val)
;tivw_info = {	TIVWEVENT,					$
;				id:(*pstate).notifyids[0],	$
;				top:(*pstate).notifyids[1],	$
;				handler:0L					}
;if widget_info((*pstate).notifyids[0],/valid_id) then begin
;	widget_control,(*pstate).notifyids[0],send_event = tivw_info
;endif
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tivw_event,event
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
;'XGROUP':	tivw_send_info,event
'DISMISS':	$
	begin
		tivw_send_info,event
		widget_control,event.top,/destroy
	end
else:
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function tas_indep_var_widget,	group_leader = group_leader,		$
								notifyids = notifyids,				$
								object = object
register_name = 'tivw'
if xregistered(register_name) then return,0
if (n_elements(group_leader) eq 0) or (n_elements(notifyids) eq 0) or $
	n_elements(object) eq 0 then return,0

ret = object->get(prp = prp,indep_var_index = indep_var_index)

tlb = widget_base(title = 'Independent variable',/col,/tlb_frame_attr, $
	group_leader = group_leader,/modal)
xgroup = cw_bgroup(tlb,prp,/col,/exclusive,set_value = indep_var_index,	$
	label_top = 'Independent variable',/return_index,uname = 'XGROUP', $
	/no_release)
void = widget_button(tlb,value = 'DISMISS',uname = 'DISMISS')

widget_control,tlb,/realize
state =	{	notifyids:notifyids,				$
			indep_var_index:indep_var_index,	$
			xgroup:xgroup,						$
			object:object						$
		}

pstate = ptr_new(state)
widget_control,tlb,set_uvalue = pstate


;xmanager,register_name,tlb,/no_block,cleanup = 'tivw_cleanup',event_handler = $
;	'tivw_event'
xmanager,register_name,tlb,event_handler = 'tivw_event'

ret = (*pstate).object->set(indep_var_index = (*pstate).indep_var_index)
ptr_free,pstate
return,1
end