; $Id$
;###############################################################################
;
; NAME:
;  OPAN_FILEINFO
;
; PURPOSE:
;  This widget dialog displays all of the information currently known about
;  the DAVE file in memory.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro opanFICleanup,tlb
widget_control,tlb,get_uvalue = pState
if ((*pState).notifyIds)[0] ne (-1L) then begin
  s = size((*pState).notifyIDs)
  if s[0] eq 1 then count = 0 else count = s[2]-1
  for j = 0,count do begin
    fileInfo = {fileInfoEvent,$
                        		ID:(*pState).notifyIDs[0,j],$
                        		Top:(*pState).notifyIDs[1,j],$
                        		Handler:0l}
    if widget_info((*pState).notifyIDs[0,j],/valid_id) then begin $
      widget_control,(*pState).notifyIDs[0,j],send_event = fileInfo
    endif
  endfor
endif
ptr_free,pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opanFIQuit,event
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan_fileInfo,	info, $
					group_leader = group_leader, $
                   	notifyIds = notifyIds
; Widget definition module
if n_elements(notifyIds) eq 0 then notifyIds = (-1L)
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = 'PAN File Information', $
        /base_align_center)
endif else begin
  tlb = widget_base(group_leader = group_leader, /col, $
        title = 'PAN File Information', $
        /base_align_center)
endelse
nlines = n_elements(info)
length = 0
for i = 0,nlines-1 do begin
  length = length > strlen(info[i])
endfor
text = widget_text(tlb,value = info,xsize = length,ysize = 25,/editable,/scroll)

void = widget_button(tlb,value = 'Dismiss',event_pro = 'opanFIQuit')

widget_control,tlb,/realize

state = {notifyIds:notifyIds}
pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState,/no_copy
xmanager,'opan_fileinfo',tlb,cleanup = 'opanFICleanup',/no_block
return
end