; $Id$
;###############################################################################
;
; NAME:
;  ENTERFUNCTION
;
; PURPOSE:
;  This widget dialog allows the user to type in a fit expression, save it,
;  and/or restore it.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro enterfunction_event,event
widget_control,event.top,get_uvalue = pState
widget_control,event.id,get_value = val
case strupcase(val[0]) of
'ACCEPT':	begin
			  ;(*pState).out.accept = 1
			  (*pState).out.cancel = 0
			  widget_control,(*pState).expression,get_value = expr
			  msg = ['User Function appears to have multiple lines, but only one line is allowed.','Proceeding with only the first line.']
        if n_elements(expr) gt 1 then void = dialog_message(msg,title='Multiple User Function Lines:',dialog_parent=event.top,/information)
			  (*pState).out.expr = string(expr[0])
			  widget_control,event.top,/destroy
			end
'CANCEL':	begin
			  ;(*pState).out.accept = 0
			  (*pState).out.cancel = 1
			  (*pState).out.expr = ''
			  widget_control,event.top,/destroy
			end
'SAVE EXPRESSION':	$
			begin
			widget_control,(*pState).expression,get_value = expr
			thisExpr = string(expr[0])
			filename = DIALOG_PICKFILE(dialog_parent = event.top,$
                       title = 'Enter file name for your equation',$
                       /write,filter = '*.eq',$
                       path = (*pState).workDir)
            if filename eq '' or filename eq ' ' then return
            filename = lrk_addDotExt(filename,'.eq')
            ;filename = filename + '.eq'
			openw,lun,filename,/get_lun
			printf,lun,thisExpr
			free_lun,lun
			end
'RESTORE EXPRESSION': $
			begin
			filename = DIALOG_PICKFILE(dialog_parent = event.top,$
                       title = 'Select equation to restore',$
                       /read,filter = '*.eq',$
                       path = (*pState).workDir)
            if filename eq '' or filename eq ' ' then return
            thisExpr = ''
			openr,lun,filename,/get_lun
			readf,lun,thisExpr
			free_lun,lun
			widget_control,(*pState).expression,set_value = thisExpr
			end
else:
endcase
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function enterfunction,group_leader = group_leader,directory = directory
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = 'User function entry',/tlb_frame_attr)
endif else begin
  tlb = widget_base(group_leader = group_leader, /col,/modal, $
        title = 'User function entry',/tlb_frame_attr)
endelse
thisFont = "Comic Sans MS*22*Bold"
expression = cw_field(tlb,title = 'e.g. p[0]+p[1]*x+p[2]*x^2', $
             value = 'p[0]+p[1]*x+p[2]*x^2',/col,xsize = 50, $
             fieldfont = thisFont,font = thisFont,ysize = 3)
rowBase = widget_base(tlb,/row)


void = widget_button(rowBase,value = 'Save Expression')
void = widget_button(rowBase,value = 'Restore Expression')
void = widget_button(rowBase,value = 'Accept')
void = widget_button(rowBase,value = 'Cancel')

widget_control,tlb,/realize

out = {expr:'',cancel:1}
state = {out:out,expression:expression,workDir:directory}
pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState
xmanager,'enterfunction',tlb

out = (*pState).out
ptr_free,pState
return,out
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;