pro hc_plot_data
dir = 'c:\bhd\dave_development\dave\programs\testing\cappelletti\'
;filename = dir+'saved_fits_1088021228.sav'
filename = dir+'saved_fits_1088032409.sav'
resolve_routine, 'hc_data__define'
restore,filename = filename

ret = odata->get_property(qty = z,dqty = dz,yfit = fit,xvals = x,yvals = y)

range = where(x le 0.25 and x ge -0.25)
x = x[range]
z = z[range,*]
dz = dz[range,*]
fit = fit[range,*]

nx = n_elements(x)
ny = n_elements(y)
ux = 1+bytarr(nx)
uy = 1+bytarr(ny)

xmat = x#uy
ymat = ux#y

xdisp = float(reform(xmat,nx*ny))
ydisp = float(reform(ymat,nx*ny))
zdisp = float(reform(z,nx*ny))
dzdisp = float(reform(dz,nx*ny))
fitdisp = float(reform(fit,nx*ny))

iplot,xdisp,ydisp,zdisp,sym_index = 4,       $
      /scatter,zerror = dzdisp,/z_errorbars, $
      xtitle = 'E (meV)',ytitle = 'Q (A-1)', $
      ztitle = 'Intensity (arb units)'
iplot,xdisp,ydisp,fitdisp,/overplot,linestyle = 0

;obj_destroy,odata
end