; *************************************************** ;
;
; This is the main driver program that runs the analysis
; of HFBS and DCS data in terms of the diffusion model
; of hopping on a honeycomb lattice.
;
; This batch file is run from the command line as..
; IDL> @hc_analysis
;
; Note: comment the pro and end statements before executing this as a batch file
pro hc_analysis

dir = 'c:\bhd\dave_development\dave\programs\testing\cappelletti\'
data_filename = '580K_sam1SSQW_rb.dave'
res_filename = '300K_resolution_sam1SSQW_rb.dave'
ores = obj_new('hc_data',dir+res_filename)
ret = ores->get_property(xvals = xres)
obj_destroy,ores
;print,deriv(xres)
res_params_filename = 'rebinned_fits.fit';'res_fit_params.fit'

; Get best parameters from a previous analysis...
old_file = dir+'saved_fits_1088102810.sav'
restore,filename = old_file
ret = odata->get_property(fit_parms = parms)
obj_destroy,odata

; Ok, the data files are present...let's open them up
odata = obj_new('hc_data',dir+data_filename,parms = parms)
ret = odata->get_property(ny = ny,xvals = xdat)
;print,deriv(xdat)
ret = odata->load_resolution_params(dir+res_params_filename,msg = msg)
ret = odata->get_property(res_str = res_str)
ret = odata->set_property(ntheta = 10,nphi = 10)
tstart = systime(1)
ret = odata->fit(msg = msg,niter = 10)
tfinish = systime(1)
telapsed = tfinish-tstart
print,'Elapsed time: ',telapsed
ret = odata->get_property(yfit = yfit,xvals = xvals,yvals = yvals,qty = qty)

;; Save as a unique file
;time = strtrim(string(long(systime(/seconds))),2)
;file_out = dir+'saved_fits_'+time+'.sav'
;save,filename = file_out,odata
;ret = odata->show_parms()
;;obj_destroy,odata
; *************************************************** ;

end